/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.quickregister;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;

import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.AWindow;
import org.compiere.apps.AppsAction;
import org.compiere.apps.search.Find;
import org.compiere.framework.Query;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridWindow;
import org.compiere.model.GridWindowVO;
import org.compiere.model.GridWorkbench;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrderTax;
import org.compiere.model.MPOS;
import org.compiere.model.MRefList;
import org.compiere.model.MRole;
import org.compiere.process.ProcessInfo;
import org.compiere.swing.CButton;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

/**
 * Main Application Panel.
 * 
 * @author Horcha
 * @version $Id: QuickRegisterMenu.java,v 1.3 2010/01/10 07:50:34 jrmt Exp $
 */
public final class QuickRegisterMenu extends QuickRegisterSubPanel
	implements   ActionListener, KeyListener
{
	/**
	 * 	Constructor
	 */
	public QuickRegisterMenu (QuickRegisterPanel p_QuickRegisterPanel)
	{
		super(p_QuickRegisterPanel);
	}	//	QuickRegisterProduct

	/** Logger */
	private static CLogger log = CLogger
			.getCLogger(QuickRegisterFormPanel.class);
	/** Quick Register Model */
	protected MQuickRegister p_QuickRegister = null;
	/** MWindow */
	private int order_Id = 0;
	private int rowSelect = 0;

	/** QuickRegisterForm Model */
	protected MPOS m_QuickRegisterForm = null;
	private MOrder m_order = null;
	/** Order Lines */
	private MOrderLine[] m_lines = null;
	
	
	/** Keyoard Focus Manager		*/
//	private QuickRegisterKeyboardFocusManager	m_focusMgr = null;
	
	/**
	 * The Layout
	 */
	// private VTabbedPane tabPanel = new VTabbedPane(true);
	protected JToolBar toolBar = null;
	private JMenuBar menuBar = null;
	private FlowLayout northLayout = null;
	
	

	
	/**
	 * Dispose
	 */
	public void dispose() {
		// log.config("");
		// MenuBar
		if (menuBar != null)
			menuBar.removeAll();
		menuBar = null;
		// ToolBar
		if (toolBar != null)
			toolBar.removeAll();
		toolBar = null;
		// Prepare GC
		this.removeAll();
	} // dispose



	private AppsAction  aParent,
			aCopy,  aIgnore, aPrint, aAttachment, aChat,
			 aWorkflow, aZoomAcross, aRequest, aUserDef,
			aArchive;
	protected AppsAction aMulti,aNew,aPrevious,aRefresh,aSave,  aNext,aFind, aDetail, aFirst, aLast,aDelete;
	/** Save Button */
//	public AppsAction aSave;
	/** Private Lock Button */
	public AppsAction aLock;
	/** decide Action Mutil button push or out */
	protected String mutultiFlg = "0";
	// Local (added to toolbar)
	private AppsAction aReport, aEnd, aHelp, aExit;
	private Query query = null;
	/** Current GridController                          */
	/**************************************************************************
	 * Create Menu and Toolbar and registers keyboard actions. - started from
	 * constructor
	 */
	protected void init() {
		/**
		 * Menu
		 */
		// menuBar.setHelpMenu();
		 menuBar = new JMenuBar();
		 toolBar = new JToolBar();
		// File
		JMenu mFile = AEnv.getMenu("File");
		menuBar.add(mFile);
		addAction("PrintScreen", mFile, KeyStroke.getKeyStroke(
				KeyEvent.VK_PRINTSCREEN, 0), false);
		addAction("ScreenShot", mFile, KeyStroke.getKeyStroke(
				KeyEvent.VK_PRINTSCREEN, Event.SHIFT_MASK), false);
		aReport = addAction("Report", mFile, KeyStroke.getKeyStroke(
				KeyEvent.VK_F11, 0), false);
		aReport.setEnabled(false);
		aPrint = addAction("Print", mFile, KeyStroke.getKeyStroke(
				KeyEvent.VK_F12, 0), false);
		mFile.addSeparator();
		aEnd = addAction("End", mFile, KeyStroke.getKeyStroke(KeyEvent.VK_X,
				Event.ALT_MASK), false);
		aEnd.getButton().addKeyListener(this);
		aExit = addAction("Exit", mFile, KeyStroke.getKeyStroke(KeyEvent.VK_X,
				Event.SHIFT_MASK + Event.ALT_MASK), false);
		// Edit
		JMenu mEdit = AEnv.getMenu("Edit");
		menuBar.add(mEdit);
		aNew = addAction("New", mEdit, KeyStroke
				.getKeyStroke(KeyEvent.VK_F2, 0), false);
		aNew.getButton().requestFocus();
		aNew.getButton().addKeyListener(this);
		aCopy = addAction("Copy", mEdit, KeyStroke.getKeyStroke(KeyEvent.VK_F2,
				Event.SHIFT_MASK), false);
		aDelete = addAction("Delete", mEdit, KeyStroke.getKeyStroke(
				KeyEvent.VK_F3, 0), false);
		aDelete.getButton().addKeyListener(this);
		aDelete.setEnabled(false);
		aSave = addAction("Save", mEdit, KeyStroke.getKeyStroke(KeyEvent.VK_F4,
				0), false);
		mEdit.addSeparator();
		aIgnore = addAction("Ignore", mEdit, KeyStroke.getKeyStroke(
				KeyEvent.VK_ESCAPE, 0), false);
		aRefresh = addAction("Refresh", mEdit, KeyStroke.getKeyStroke(
				KeyEvent.VK_F5, 0), false);
		aRefresh.setEnabled(false);
		mEdit.addSeparator();
		aFind = addAction("Find", mEdit, KeyStroke.getKeyStroke(KeyEvent.VK_F6,
				0), true); // toggle
//		aFind.setEnabled(false);
		if (m_isPersonalLock)
			aLock = addAction("Lock", mEdit, null, true); // toggle
		// View
		JMenu mView = AEnv.getMenu("View");
		menuBar.add(mView);
		addAction("InfoProduct", mView, KeyStroke.getKeyStroke(KeyEvent.VK_I,
				Event.ALT_MASK), false);
		addAction("InfoBPartner", mView, KeyStroke.getKeyStroke(KeyEvent.VK_I,
				Event.SHIFT_MASK + Event.ALT_MASK), false);
		if (MRole.getDefault().isShowAcct())
			addAction("InfoAccount", mView, KeyStroke.getKeyStroke(
					KeyEvent.VK_I, Event.ALT_MASK + Event.CTRL_MASK), false);
		AEnv.addMenuItem("InfoSchedule", null, null, mView, this);
		mView.addSeparator();
		AEnv.addMenuItem("InfoOrder", "Info", null, mView, this);
		AEnv.addMenuItem("InfoInvoice", "Info", null, mView, this);
		AEnv.addMenuItem("InfoInOut", "Info", null, mView, this);
		AEnv.addMenuItem("InfoPayment", "Info", null, mView, this);
		AEnv.addMenuItem("InfoCashLine", "Info", null, mView, this);
		AEnv.addMenuItem("InfoAssignment", "Info", null, mView, this);
		AEnv.addMenuItem("InfoAsset", "Info", null, mView, this);
		mView.addSeparator();
		aAttachment = addAction("Attachment", mView, KeyStroke.getKeyStroke(
				KeyEvent.VK_F7, 0), true); // toggle
		aChat = addAction("Chat", mView, KeyStroke.getKeyStroke(KeyEvent.VK_F8,
				0), true); // toggle
		mView.addSeparator();
		aMulti = addAction("Multi", mView, KeyStroke.getKeyStroke(
				KeyEvent.VK_F9, 0), true); // toggle
		aMulti.setEnabled(false);
//		aMulti.getButton().addKeyListener(this);
		// Go
		JMenu mGo = AEnv.getMenu("Go");
		menuBar.add(mGo);
		aFirst = addAction("First", mGo, KeyStroke.getKeyStroke(
				KeyEvent.VK_PAGE_UP, Event.ALT_MASK), false);
		aFirst.setEnabled(false);
		aPrevious = addAction("Previous", mGo, KeyStroke.getKeyStroke(
				KeyEvent.VK_UP, Event.ALT_MASK), false);
		aPrevious.setEnabled(false);
		aNext = addAction("Next", mGo, KeyStroke.getKeyStroke(KeyEvent.VK_DOWN,
				Event.ALT_MASK), false);
		aNext.setEnabled(false);
		aLast = addAction("Last", mGo, KeyStroke.getKeyStroke(
				KeyEvent.VK_PAGE_DOWN, Event.ALT_MASK), false);
		aLast.setEnabled(false);
		mGo.addSeparator();
		aParent = addAction("Parent", mGo, KeyStroke.getKeyStroke(
				KeyEvent.VK_LEFT, Event.ALT_MASK), false);
		aDetail = addAction("Detail", mGo, KeyStroke.getKeyStroke(
				KeyEvent.VK_RIGHT, Event.ALT_MASK), false);
		mGo.addSeparator();
		aZoomAcross = addAction("ZoomAcross", mGo, KeyStroke.getKeyStroke(
				KeyEvent.VK_F9, Event.SHIFT_MASK), false);
		aRequest = addAction("Request", mGo, KeyStroke.getKeyStroke(
				KeyEvent.VK_F11, Event.SHIFT_MASK), false);
		aArchive = addAction("Archive", mGo, KeyStroke.getKeyStroke(
				KeyEvent.VK_F10, 0), false);
		addAction("Home", mGo, null, false);
		// Tools
		JMenu mTools = AEnv.getMenu("Tools");
		menuBar.add(mTools);
		addAction("Calculator", mTools, null, false);
		addAction("Calendar", mTools, null, false);
		addAction("Editor", mTools, null, false);
		addAction("Script", mTools, null, false);
		if (AEnv.isWorkflowProcess())
			aWorkflow = addAction("WorkFlow", mTools, KeyStroke.getKeyStroke(
					KeyEvent.VK_F10, Event.SHIFT_MASK), false);
		if (MRole.getDefault().isShowPreference()) {
			aUserDef = addAction("WinSize", mTools, null, false);
			mTools.addSeparator();
			addAction("Preference", mTools, KeyStroke.getKeyStroke(
					KeyEvent.VK_F12, Event.ALT_MASK), false);
		}
		// Help
		JMenu mHelp = AEnv.getMenu("Help");
		menuBar.add(mHelp);
		aHelp = addAction("Help", mHelp, KeyStroke.getKeyStroke(KeyEvent.VK_F1,
				0), false);
		addAction("Online", mHelp, null, false);
		addAction("EMailSupport", mHelp, null, false);
		addAction("About", mHelp, KeyStroke.getKeyStroke(KeyEvent.VK_F12,
				Event.SHIFT_MASK), false);

		/**
		 * ToolBar
		 */
		aIgnore.getButton().setEnabled(false);
//		toolBar.add(aIgnore.getButton()); // ESC
		toolBar.addSeparator();
		// toolBar.add(aHelp.getButton()); // F1
		toolBar.add(aNew.getButton());
		toolBar.add(aDelete.getButton());
		//aSave.getButton().setEnabled(false);
		toolBar.add(aSave.getButton());
	
		toolBar.addSeparator();
		toolBar.add(aRefresh.getButton()); // F5
		toolBar.add(aFind.getButton());
		aAttachment.getButton().setEnabled(false);
//		toolBar.add(aAttachment.getButton());
		aChat.getButton().setEnabled(false);
//		toolBar.add(aChat.getButton());
		toolBar.addSeparator();
		toolBar.add(aMulti.getButton()); // F9
		aArchive.getButton().setEnabled(false);
//		toolBar.add(aArchive.getButton()); // F10 is Windows Menu Key
		// toolBar.add(aReport.getButton()); // F11
		// toolBar.add(aPrint.getButton()); // F12
		toolBar.addSeparator();
		toolBar.add(aFirst.getButton());
		toolBar.add(aPrevious.getButton());
		toolBar.add(aNext.getButton());
		toolBar.add(aLast.getButton());
		toolBar.addSeparator();
		if (m_isPersonalLock) {
			aLock.getButton().setEnabled(false);
			toolBar.add(aLock.getButton());
			toolBar.addSeparator();
		}
		aZoomAcross.getButton().setEnabled(false);
//		toolBar.add(aZoomAcross.getButton()); // Shift-F9
		if (aWorkflow != null) {
			aWorkflow.getButton().setEnabled(false);
//			toolBar.add(aWorkflow.getButton()); // Shift-F10
		}
		aRequest.getButton().setEnabled(false);
//		toolBar.add(aRequest.getButton()); // Shift-F11
		toolBar.add(aEnd.getButton()); // Shift-F12
		northLayout = new FlowLayout(FlowLayout.LEFT);
		this.setLayout(northLayout);
		northLayout.setAlignment(FlowLayout.LEFT);
		this.add(toolBar, null);
		
		if (CLogMgt.isLevelAll())
			Util.printActionInputMap(this);
	} // createMenu

	/**
	 * Add (Toggle) Action to Toolbar and Menu
	 * 
	 * @param actionName
	 *            action name
	 * @param menu
	 *            manu
	 * @param accelerator
	 *            accelerator
	 * @param toggle
	 *            toggle button
	 * @return AppsAction
	 */
	private AppsAction addAction(String actionName, JMenu menu,
			KeyStroke accelerator, boolean toggle) {
		AppsAction action = new AppsAction(actionName, accelerator, toggle);
		if (menu != null)
			menu.add(action.getMenuItem());
		action.setDelegate(this);

		// Key Strokes
		if (accelerator != null) {
			getInputMap(WHEN_IN_FOCUSED_WINDOW).put(accelerator, actionName);
			getActionMap().put(actionName, action);
		}
		//
		return action;
	} // addAction

	/**
	 * Return MenuBar
	 * 
	 * @return JMenuBar
	 */
	public JMenuBar getMenuBar() {
		return menuBar;
	} // getMenuBar

	/**
	 * Get Title of Window
	 * 
	 * @return String with Title
	 */
	public String getTitle() {
		if (m_mWorkbench.getWindowCount() > 1) {
			StringBuffer sb = new StringBuffer();
			sb.append(m_mWorkbench.getName()).append("  ").append(
					m_ctx.getContext("#AD_User_Name")).append("@").append(
					m_ctx.getContext("#AD_Client_Name")).append(".").append(
					m_ctx.getContext("#AD_Org_Name")).append(" [").append(
					m_ctx.getContext("#DB_UID")).append("]");
			return sb.toString();
		}
		return Env.getHeader(m_ctx, m_curWindowNo);
	} // getTitle

	/** The Context */
	/** Context */
	private Ctx m_ctx = Env.getCtx();

	/** Workbench Model */
	private GridWorkbench m_mWorkbench;
	/** Current MTab */
	protected GridTab m_curTab;
	/** Current Window No */
	private int m_curWindowNo;
	/** Dispose active */
	private boolean m_disposing = false;
	/** Process Info */
	private boolean m_isLocked = false;
	/** Show Personal Lock */
	private boolean m_isPersonalLock = MRole.getDefault().isPersonalLock();
	/** Last Modifier of Action Event */
	private int m_lastModifiers;
	/** Current Window Panel                            */
	/** Current Window Panel Index                      */

	/**
	 * Indicate Busy
	 * 
	 * @param busy
	 *            busy
	 * @param focus
	 *            request focus
	 */
	private void setBusy(boolean busy, boolean focus) {
		m_isLocked = busy;
		//
		JFrame frame = Env.getFrame(this);
		if (frame == null) // during init
			return;
		if (frame instanceof AWindow)
			((AWindow) frame).setBusy(busy);
		if (busy) {
			this.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
			frame.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
		} else {
			this.setCursor(Cursor.getDefaultCursor());
			frame.setCursor(Cursor.getDefaultCursor());
		}
	} // set Busy

	/**************************************************************************
	 * Action Listener
	 * 
	 * @param e
	 *            event
	 */
	public void actionPerformed(ActionEvent e) {
		log.info(e.getActionCommand() + " - " + e.getModifiers());
		// + " - " + new Timestamp(e.getWhen()) + " " + isUILocked());
		if (m_disposing || isUILocked())
			return;

		m_lastModifiers = e.getModifiers();
		String cmd = e.getActionCommand();
		// Do ScreenShot w/o busy
		if (cmd.equals("ScreenShot")) {
			AEnv.actionPerformed(e.getActionCommand(), m_curWindowNo, this);
			return;
		}

		try {
			// File
			if (cmd.equals(aReport.getName()))
				cmd_report();
			else if (cmd.equals(aPrint.getName()))
				cmd_print();
			else if (cmd.equals(aEnd.getName()))
				cmd_end(false);
			else if (cmd.equals(aExit.getName()))
				cmd_end(true);
			// Edit
			else if (cmd.equals(aNew.getName()))
				cmd_new();
			else if (cmd.equals(aSave.getName()))
				cmd_save();
			else if (cmd.equals(aCopy.getName()))
				cmd_new();
			else if (cmd.equals(aDelete.getName()))
				cmd_delete();
			else if (cmd.equals(aIgnore.getName()))
				cmd_ignore();
			else if (cmd.equals(aRefresh.getName()))
				cmd_refresh();
			else if (cmd.equals(aFind.getName()))
				cmd_find();
			else if (m_isPersonalLock && cmd.equals(aLock.getName()))
				cmd_lock();
			// View
			if (cmd.equals(aAttachment.getName()))
				cmd_attachment();
			else if (cmd.equals(aChat.getName()))
				cmd_chat();
			else if (cmd.equals(aMulti.getName())) {
				cmd_multi();

			} else if (cmd.equals(aFirst.getName())) {
				int rows = p_QuickRegisterPanel.f_orderlines.m_table.getRowCount();
				if (rows == 0) {
					return;
				} else {
					rows = 0;
					p_QuickRegisterPanel.f_orderlines.getM_table()
							.getSelectionModel().setSelectionInterval(0,0);
					//scroll 
					Point p = new Point(0, 0);
					p_QuickRegisterPanel.f_orderlines.scroll.getViewport().setViewPosition(p);
					p_QuickRegisterPanel.f_orderlines.m_table.requestFocus();
					setStatusValue();
					
				}
			} else if (cmd.equals(aPrevious.getName())) {
				int row = p_QuickRegisterPanel.f_orderlines.m_table.getSelectedRow();
				row--;
				p_QuickRegisterPanel.f_orderlines.m_table.getSelectionModel().setSelectionInterval(row, row);
				p_QuickRegisterPanel.f_orderlines.m_table.getSelectionModel().getSelectionMode();
				p_QuickRegisterPanel.f_orderlines.showCell(row,0);
				p_QuickRegisterPanel.f_orderlines.m_table.requestFocus();
				p_QuickRegisterPanel.f_orderlines.clearValue();
				setStatusValue();

			} else if (cmd.equals(aNext.getName())) {
				int rows = p_QuickRegisterPanel.f_orderlines.m_table.getRowCount();
				if (rows == 0){
					p_QuickRegisterPanel.f_product.f_name.requestFocus();
					return;
				}
					
				int row = p_QuickRegisterPanel.f_orderlines.m_table.getSelectedRow();
				row++;
				if (row >= rows)
					row = rows - 1;
				p_QuickRegisterPanel.f_orderlines.m_table.getSelectionModel().setSelectionInterval(row, row);
				p_QuickRegisterPanel.f_orderlines.showCell(row,0);
				p_QuickRegisterPanel.f_orderlines.m_table.requestFocus();
				p_QuickRegisterPanel.f_orderlines.clearValue();
				setStatusValue();

			} else if (cmd.equals(aLast.getName())) {
				int rows = p_QuickRegisterPanel.f_orderlines
				.m_table.getRowCount();
				if (rows != 0) {
					rows--;
//					
					p_QuickRegisterPanel.f_orderlines.getM_table()
							.getSelectionModel().setSelectionInterval(rows,
									rows);
					p_QuickRegisterPanel.f_orderlines.m_table.requestFocus();
//					setValueOrderPanal(rows);
					//scroll 
					Dimension tableSize = p_QuickRegisterPanel.f_orderlines.m_table.getSize();
//					Dimension viewportSize = p_QuickRegisterPanel.f_orderlines.scroll.getViewport().getSize();
					Point p = new Point(0,tableSize.height);
					p_QuickRegisterPanel.f_orderlines.scroll.getViewport().setViewPosition(p); 
					setStatusValue();
				}

			} else if (cmd.equals(aZoomAcross.getName()))
				cmd_zoomAcross();
			else if (cmd.equals(aRequest.getName()))
				cmd_request();
			else if (cmd.equals(aArchive.getName()))
				cmd_archive();
			// Tools
			else if (aWorkflow != null && cmd.equals(aWorkflow.getName())) {
				if (m_curTab.getRecord_ID() <= 0)
					;
				AEnv.startWorkflowProcess(m_curTab.getAD_Table_ID(), m_curTab
						.getRecord_ID());
				// else
				AEnv.startWorkflowProcess(m_curTab.getAD_Table_ID(), m_curTab
						.getRecord_ID());
			}
		} catch (Exception ex) {
			log.log(Level.SEVERE, cmd, ex);
			String msg = ex.getMessage();
			if (msg == null || msg.length() == 0)
				msg = ex.toString();
			msg = Msg.parseTranslation(m_ctx, msg);
			ADialog.error(m_curWindowNo, this, "Error", msg);
		}
		setBusy(false, true);
	} // actionPerformed

	/**
	 * setValueOrderPanal
	 * */
	public void setValueOrderPanal(int selectRow) {
		Object orderNo = p_QuickRegisterPanel.f_orderlines.getM_table()
				.getValueAt(selectRow, 7);
		Object fBPartner = p_QuickRegisterPanel.f_orderlines.getM_table()
				.getValueAt(selectRow, 8);
		Object docmentType = p_QuickRegisterPanel.f_orderlines.getM_table()
				.getValueAt(selectRow, 9);

		if (fBPartner != null)
			p_QuickRegisterPanel.f_orderline.f_customerNo.setValue(fBPartner
					.toString());
		else
			p_QuickRegisterPanel.f_orderline.f_customerNo.setValue("");
		if (orderNo != null)
			p_QuickRegisterPanel.f_orderline.f_orderNo.setValue(orderNo
					.toString());
		else
			p_QuickRegisterPanel.f_orderline.f_orderNo.setValue("");
		if (docmentType != null)
			p_QuickRegisterPanel.f_orderline.f_docmentType.setToolTipText(docmentType.toString());
		else
			p_QuickRegisterPanel.f_orderline.f_docmentType.setValue("");
	}

	/**
	 * Create New Record
	 * 
	 * @param copy
	 *            true if current record is to be copied
	 */
	private void cmd_new() {
		
		log.config("cmd_new()" );
		aDelete.setEnabled(false);
		aRefresh.setEnabled(true);
		aSave.setEnabled(true);
		aMulti.setPressed(false);
		aMulti.setEnabled(false);
		aFirst.setEnabled(false);
		aNext.setEnabled(false);
		aPrevious.setEnabled(false);
		aLast.setEnabled(false);
		p_QuickRegisterPanel.newOrder();
		p_QuickRegisterPanel.f_bpartner.setOrderValue();
		p_QuickRegisterPanel.f_bpartner.f_name.setEnabled(true);
		p_QuickRegisterPanel.f_bpartner.f_bSearch.setEnabled(true);
		p_QuickRegisterPanel.f_bpartner.f_location.setEnabled(true);
		p_QuickRegisterPanel.f_bpartner.f_user.setEnabled(true);
		p_QuickRegisterPanel.f_orderline.f_descreption.setReadWrite(true);
		p_QuickRegisterPanel.f_orderline.f_customerNo.setReadWrite(true);
		p_QuickRegisterPanel.f_orderline.f_complete.setEnabled(true);
		p_QuickRegisterPanel.f_lines.setVisible(false);
		p_QuickRegisterPanel.f_orderlines.setVisible(false);
		p_QuickRegisterPanel.f_bpartner.f_bNew.setEnabled(true);
		p_QuickRegisterPanel.f_bpartner.f_bEdit.setEnabled(true);
		p_QuickRegisterPanel.f_bpartner.f_name.requestFocus();
		String strCo = "";
		MRefList ref = new MRefList(p_QuickRegisterPanel.m_ctx,135,null);
		strCo =  ref.getListName(p_QuickRegisterPanel.m_ctx,135,"PR");
		p_QuickRegisterPanel.f_orderline.f_complete.setText(strCo);
		//orderline edit or new line flg
		if(p_QuickRegisterPanel.f_lines != null)
			p_QuickRegisterPanel.f_lines.newEditFlg = 0;
//		fillCombos();
		// refresh flg if checkClick == 1 then new orderline  
		p_QuickRegisterPanel.f_orderlines.checkClick = 1;
		p_QuickRegisterPanel.f_orderline.m_C_Order_ID = p_QuickRegisterPanel.f_currentLine.getOrder().getC_Order_ID();
		aMulti.setPressed(false);
		p_QuickRegisterPanel.f_status.setStatusDB( "[" + 0  + "/" + 0 + "]");
//		m_curTab.getAD_Process_ID();
		
	} // cmd_new

	/**
	 * Confirm & delete record
	 */
	private void cmd_delete() {
			int rows = p_QuickRegisterPanel.f_orderlines.getM_table()
					.getRowCount();
			if (rows != 0) {
				int deleterow = p_QuickRegisterPanel.f_orderlines.getM_table()
						.getSelectedRow();
				String order_Idstr = p_QuickRegisterPanel.f_orderlines
						.getM_table().getValueAt(deleterow, 0).toString();
				int equlsFlg = order_Idstr.indexOf('=');
				equlsFlg++;
				int pointFlg = order_Idstr.indexOf(',');
				order_Id = Integer.valueOf(order_Idstr.substring(equlsFlg,
						pointFlg));

				boolean deleteFlag = deleteOrder();
				cmd_refresh();
				rows--;
				if ((rows == deleterow) && deleteFlag) {
					deleterow--;
				}
				if(deleterow == -1){
					deleterow = 0;
				}
				p_QuickRegisterPanel.f_orderlines.getM_table()
						.getSelectionModel().setSelectionInterval(deleterow,
								deleterow);
				p_QuickRegisterPanel.f_orderlines.getM_table().requestFocus();
				
				 setStatusValue();
				
			}
	} // cmd_delete

	/**
	 * to erase the lines from order
	 * 
	 * @return true if deleted
	 */
	public void deleteLine(int row) {
		if (row != -1) {
			MOrderLine[] lineas = getLines(true, null);
			int numLineas = lineas.length;
			if (numLineas > row) {
				lineas[row].delete(true);
				for (int i = row; i < (numLineas - 1); i++)
					lineas[i] = lineas[i + 1];
				lineas[numLineas - 1] = null;
			}
		}
	} // deleteLine

	/**
	 * Get Lines of Order
	 * 
	 * @param requery
	 *            requery
	 * @param orderBy
	 *            optional order by column
	 * @return lines
	 */
	public MOrderLine[] getLines(boolean requery, String orderBy) {
		if (m_lines != null && !requery)
			return m_lines;
		//
		String orderClause = "ORDER BY ";
		if (orderBy != null && orderBy.length() > 0)
			orderClause += orderBy;
		else
			orderClause += "Line";
		m_lines = getLines(null, orderClause, order_Id);
		return m_lines;
	} // getLines

	/**************************************************************************
	 * Get Lines of Order
	 * 
	 * @param whereClause
	 *            where clause or null (starting with AND)
	 * @param orderClause
	 *            order clause
	 * @return lines
	 */
	public MOrderLine[] getLines(String whereClause, String orderClause,
			int order_Id) {
		ArrayList<MOrderLine> list = new ArrayList<MOrderLine>();
		StringBuffer sql = new StringBuffer(
				"SELECT * FROM C_OrderLine WHERE C_Order_ID=? ");
		if (whereClause != null)
			sql.append(whereClause);
		if (orderClause != null)
			sql.append(" ").append(orderClause);
		PreparedStatement pstmt = null;
		try {
			pstmt = DB.prepareStatement(sql.toString(), null);
			pstmt.setInt(1, order_Id);
			ResultSet rs = pstmt.executeQuery();
			while (rs.next()) {
				MOrderLine ol = new MOrderLine(m_ctx, rs, null);
				ol.setHeaderInfo(deleteLineByGetOrder());
				list.add(ol);
			}
			rs.close();
			pstmt.close();
			pstmt = null;
		} catch (Exception e) {
			log.log(Level.SEVERE, sql.toString(), e);
		} finally {
			try {
				if (pstmt != null)
					pstmt.close();
			} catch (Exception e) {
			}
			pstmt = null;
		}
		//
		MOrderLine[] lines = new MOrderLine[list.size()];
		list.toArray(lines);
		return lines;
	} // getLines

	/**
	 * Get/create Header
	 * 
	 * @return header or null
	 */
	public MOrder deleteLineByGetOrder() {
		if ((m_order == null) && (order_Id != 0)) {
			m_order = new MOrder(Env.getCtx(), order_Id, null);
			if(m_QuickRegisterForm != null){
				if(m_QuickRegisterForm.getAD_Org_ID() != 0)
					m_order.setAD_Org_ID(m_QuickRegisterForm.getAD_Org_ID());
					if(m_QuickRegisterForm.getM_PriceList_ID() != 0)
					m_order.setM_PriceList_ID(m_QuickRegisterForm.getM_PriceList_ID());
					if(m_QuickRegisterForm.getM_Warehouse_ID() != 0)
					m_order.setM_Warehouse_ID(m_QuickRegisterForm.getM_Warehouse_ID());
					if(m_QuickRegisterForm.getSalesRep_ID() != 0)
					m_order.setSalesRep_ID(m_QuickRegisterForm.getSalesRep_ID());
					if (!m_order.save()){
						m_order = null;
					m_order.setIsSOTrx(true);
					}
			}
			
		}
		return m_order;
	} // getHeader

	/**
	 * Delete order from database
	 */
	public boolean deleteOrder() {
		boolean delete = false;
		m_order = deleteLineByGetOrder();
		if (m_order != null) {
			String drStr = p_QuickRegisterPanel.f_lines.sqlCheckDR(order_Id);
			if (drStr.equals("DR")) {
				MOrderLine[] lineas = m_order.getLines();
				if (lineas != null) {
					int numLineas = lineas.length;
					if (numLineas > 0)
						for (int i = numLineas - 1; i >= 0; i--) {
							if (lineas[i] != null)
								deleteLine(i);
						}
				}

				MOrderTax[] taxs = m_order.getTaxes(true);
				if (taxs != null) {
					int numTax = taxs.length;
					if (numTax > 0)
						for (int i = taxs.length - 1; i >= 0; i--) {
							if (taxs[i] != null)
								taxs[i].delete(true);
							taxs[i] = null;
						}
				}
				lineas = m_order.getLines(true, null);
				m_order.delete(true);
				delete = true;
			}
			m_order = null;
		}
		return delete;
	} // deleteOrder


	/**
	 *  If required ask if you want to save and save it
	 *  @param manualCmd true if invoked manually (i.e. force)
	 *  @return true if saved
	 */
	private void cmd_save ()
	{
		if(!aMulti.isEnabled())
		 p_QuickRegisterPanel.f_orderline.orderUpdate();
		else{
			p_QuickRegisterPanel.f_orderline.oldOrderUpdate();
		}
	}   //  cmd_save

	/**
	 * Ignore
	 */
	private void cmd_ignore() {
	} // cmd_ignore

	/**
	 * Refresh
	 */
	private void cmd_refresh() {
		//orders
		if(p_QuickRegisterPanel.f_orderlines.checkClick == 0){
				showOrderliens(query);
		//orderlines
		}else if(p_QuickRegisterPanel.f_orderlines.checkClick == 1){
			int C_Order_ID = p_QuickRegisterPanel.f_currentLine.m_order.getC_Order_ID();
			p_QuickRegisterPanel.f_currentLine.getOrder().setC_Order_ID(C_Order_ID);
			MOrder order = p_QuickRegisterPanel.f_currentLine.getOrder();
			p_QuickRegisterPanel.f_lines.updateTable(order);
			int count = p_QuickRegisterPanel.f_lines.getM_table().getRowCount();
			if(count > 0){
				p_QuickRegisterPanel.f_lines.getM_table().getSelectionModel().setSelectionInterval(0, 0);
			}
		}
	} // cmd_refresh
	/**
	 * Print standard Report
	 */
	private void cmd_report() {
		log.info("");
		if (!MRole.getDefault().isCanReport(m_curTab.getAD_Table_ID())) {
			ADialog.error(m_curWindowNo, this, "AccessCannotReport");
			return;
		}
	} // cmd_report

	/**
	 * Zoom Across Menu
	 */
	private void cmd_zoomAcross() {
		int record_ID = m_curTab.getRecord_ID();
		log.info("ID=" + record_ID);
		if (record_ID <= 0)
			return;

	} // cmd_zoomAcross

	/**
	 * Open/View Request
	 */
	private void cmd_request() {
		int record_ID = m_curTab.getRecord_ID();
		log.info("ID=" + record_ID);
		if (record_ID <= 0)
			return;

	} // cmd_request

	/**
	 * Open/View Archive
	 */
	private void cmd_archive() {
		int record_ID = m_curTab.getRecord_ID();
		log.info("ID=" + record_ID);
		if (record_ID <= 0)
			return;

	} // cmd_archive

	/**
	 * Print specific Report - or start default Report
	 */
	private void cmd_print() {
		// Get process defined for this tab
		int AD_Process_ID = 0;
		log.info("ID=" + AD_Process_ID);
		// No report defined
		if (AD_Process_ID == 0) {
			cmd_report();
			return;
		}
		cmd_save();
	} // cmd_print

	/**
	 * Find - Set Query
	 */
	private void cmd_find() {
		GridWindowVO wVO = GridWindowVO.create(p_QuickRegisterPanel.m_ctx, p_QuickRegisterPanel.m_WindowNo, 143); // Sales Order
		GridWindow mWindow = new GridWindow (wVO);
		 m_curTab = mWindow.getTab(0);
		m_curTab.query(1);
	
		if (m_curTab == null)
			return;
		//	Gets Fields from AD_Field_v
		GridField[] findFields = GridField.createFields(p_QuickRegisterPanel.m_ctx, p_QuickRegisterPanel.m_WindowNo, 0, m_curTab.getAD_Tab_ID(), 0);
		Find find = new Find (Env.getFrame(this), p_QuickRegisterPanel.m_WindowNo, 
			m_curTab.getName(), m_curTab.getAD_Tab_ID(),
			m_curTab.getAD_Table_ID(), m_curTab.getTableName(),  //m_curTab.getAD_Table_ID()
			"IsSOTrx='Y'", findFields, 0);//m_curTab.getWhereClause()
		//	Simple/Advanced Query
		 query = find.getQuery();
		//	History
		find.dispose();
		find = null;

		//	Confirmed query
		if (query != null ) //&& query.isActive()
		{
			log.config(query.toString()); 
			showOrderliens( query );
		}
		aFind.setPressed(false);
		aSave.setEnabled(false);
	} // cmd_find

	/**
	 * Attachment
	 */
	private void cmd_attachment() {

	} // attachment

	/**
	 * setTotalValues
	 */
	public void setTotalValues(String customerID,String Location,String orderNo,String customerNo,BigDecimal totalValue, int docType,String docstuts,String Description) {
		if (totalValue != null) {
			p_QuickRegisterPanel.f_lines.getF_total().setValue(totalValue);
			p_QuickRegisterPanel.f_lines.getF_net().setValue(totalValue);
		}
		if ((!customerID.equals(""))&& (customerID != null))
			p_QuickRegisterPanel.f_bpartner.f_name.setValue(customerID);
		if ((!Location.equals(""))&& (Location != null))
			p_QuickRegisterPanel.f_bpartner.f_location.setValue(Location);
		if (docstuts != null)
			p_QuickRegisterPanel.f_lines.f_docStatus.setValue(docstuts);
		if (docType != 0)
			p_QuickRegisterPanel.f_orderline.f_docmentType.setValue(docType);
		if(orderNo != null)
			p_QuickRegisterPanel.f_orderline.f_orderNo.setValue(orderNo);
		if(customerNo != null)
			p_QuickRegisterPanel.f_orderline.f_customerNo.setValue(customerNo);
		if(Description != null)
			p_QuickRegisterPanel.f_orderline.f_descreption.setValue(Description);

	} // attachment

	/**
	 * Chat
	 */
	private void cmd_chat() {

	} // chat

	/**
	 * Lock
	 */
	private void cmd_lock() {

	} // lock

	/**
	 * Close this screen - after save
	 * 
	 * @param exit
	 *            ask if user wants to exit application
	 */
	private void cmd_end(boolean exit) {
		boolean exitSystem = false;
//		if (!cmd_save())
//			return;
		if (exit && ADialog.ask(m_curWindowNo, this, "ExitApplication?"))
			exitSystem = true;

		Env.getFrame(this).dispose(); // calls this dispose

		if (exitSystem)
			AEnv.exit(0);
	} // cmd_end

	/**************************************************************************
	 * Lock User Interface. Called from the Worker before processing
	 * 
	 * @param pi
	 *            process info
	 */
	public void lockUI(ProcessInfo pi) {
		// log.fine("" + pi);
		setBusy(true, false);
	} // lockUI

	/**
	 * Unlock User Interface. Called from the Worker when processing is done
	 * 
	 * @param pi
	 *            of execute ASync call
	 */
	public void unlockUI(ProcessInfo pi) {
		// log.fine("" + pi);
		boolean notPrint = pi != null
				&& pi.getAD_Process_ID() != m_curTab.getAD_Process_ID();
		//
		setBusy(false, notPrint);

	} // unlockUI

	/**
	 * Is the UI locked (Internal method)
	 * 
	 * @return true, if UI is locked
	 */
	public boolean isUILocked() {
		return m_isLocked;
	} // isLoacked

	/**
	 * Method to be executed async. Called from the ASyncProcess worker
	 * 
	 * @param pi
	 *            process info
	 */
	public void executeASync(ProcessInfo pi) {
		log.config("-");
	} // executeASync

	public void keyPressed(KeyEvent e) {
		
	}

	public void keyReleased(KeyEvent e) {
		 if((e.getKeyCode() == KeyEvent.VK_ENTER)&&(((CButton)e.getSource()).getActionCommand().equals("New"))){
			 cmd_new() ;
		 }
		
		 if((e.getKeyCode() == KeyEvent.VK_ENTER)&&(((CButton)e.getSource()).getActionCommand().equals("End"))){
			 cmd_end(false);
		 }
		
		 if((e.getKeyCode() == KeyEvent.VK_ENTER)&&(((CButton)e.getSource()).getActionCommand().equals("Delete"))){
			 cmd_delete() ;
		 }
		 if((e.getKeyCode() == KeyEvent.VK_ENTER)&&(((CButton)e.getSource()).getActionCommand().equals("Refresh"))){
			 cmd_find();
		 }
		 if((e.getKeyCode() == KeyEvent.VK_ENTER)&&(((CButton)e.getSource()).getActionCommand().equals("Multi"))){
			 cmd_multi();
		 }
	}

	public void keyTyped(KeyEvent e) {
		
	}
	/**
	 *	set liens  value 
	 * */
	private void cmd_multi(){
		String order_ID = "";
		String orderNo = "";
		String customerNo = "";
		String customerID = "";
		String Description = "";
		String Location = "";
		BigDecimal totalValues = Env.ZERO;
		int docType = 0;
		String docstuts = "";
		rowSelect = p_QuickRegisterPanel.f_orderlines.getM_table()
				.getSelectedRow();
		
		//into orderliens
		if ((mutultiFlg.equals("0")) && (rowSelect != -1)) {
			
			aNew.setEnabled(true);
			p_QuickRegisterPanel.f_bpartner.setVisible(true);
			p_QuickRegisterPanel.f_orderline.setVisible(true);
			p_QuickRegisterPanel.f_orderline.f_descreption.setReadWrite(true);
			p_QuickRegisterPanel.f_orderline.f_customerNo.setReadWrite(true);
			p_QuickRegisterPanel.f_orderline.f_complete.setEnabled(true);
			p_QuickRegisterPanel.f_product.setVisible(true);
			p_QuickRegisterPanel.f_currentLine.setVisible(true);
			p_QuickRegisterPanel.f_currentLine.f_new.setEnabled(false);
			p_QuickRegisterPanel.f_quickRegisterMenu.aDelete.setEnabled(false);
			p_QuickRegisterPanel.f_quickRegisterMenu.aFirst.setEnabled(false);
			p_QuickRegisterPanel.f_quickRegisterMenu.aNext.setEnabled(false);
			p_QuickRegisterPanel.f_quickRegisterMenu.aPrevious.setEnabled(false);
			p_QuickRegisterPanel.f_quickRegisterMenu.aLast.setEnabled(false);
			p_QuickRegisterPanel.f_orderlines.checkClick = 1;
			if(p_QuickRegisterPanel.f_lines != null)
				p_QuickRegisterPanel.f_lines.newEditFlg = 1;
			if(p_QuickRegisterPanel.f_orderlines.m_table.getValueAt(rowSelect, 1) != null)
				orderNo = p_QuickRegisterPanel.f_orderlines.m_table.getValueAt(rowSelect, 1).toString();
			if(p_QuickRegisterPanel.f_orderlines.m_table.getValueAt(rowSelect, 0) != null)
				order_ID = p_QuickRegisterPanel.f_orderlines.m_table.getValueAt(rowSelect, 0).toString();
			if(p_QuickRegisterPanel.f_orderlines.m_table.getValueAt(rowSelect, 4) != null)
				customerID = p_QuickRegisterPanel.f_orderlines.m_table.getValueAt(rowSelect, 4).toString();
			if(p_QuickRegisterPanel.f_orderlines.m_table.getValueAt(rowSelect, 5) != null)
				Location = p_QuickRegisterPanel.f_orderlines.m_table.getValueAt(rowSelect, 5).toString();
			if(p_QuickRegisterPanel.f_orderlines.m_table.getValueAt(rowSelect, 9) != null)
				totalValues = (BigDecimal) p_QuickRegisterPanel.f_orderlines.m_table.getValueAt(rowSelect, 9);
			if(p_QuickRegisterPanel.f_orderlines.m_table.getValueAt(rowSelect, 8) != null)
				docstuts = p_QuickRegisterPanel.f_orderlines.m_table.getValueAt(rowSelect, 8).toString();
			
			if(p_QuickRegisterPanel.f_orderlines.m_table.getValueAt(rowSelect, 6) != null)
				customerNo = p_QuickRegisterPanel.f_orderlines.m_table.getValueAt(rowSelect, 6).toString();
			if(p_QuickRegisterPanel.f_orderlines.m_table.getValueAt(rowSelect, 11)!= null)
			Description = p_QuickRegisterPanel.f_orderlines.m_table.getValueAt(rowSelect, 11).toString();
			if (order_ID != null) {
				
				int equlsFlg = order_ID.indexOf('=');
				equlsFlg++;
				int pointFlg = order_ID.indexOf(',');
				order_ID = order_ID.substring(equlsFlg, pointFlg);
				p_QuickRegisterPanel.f_orderlines.setVisible(false);
				p_QuickRegisterPanel.f_lines.setVisible(true);
				p_QuickRegisterPanel.f_orderline.m_C_Order_ID = Integer.valueOf(order_ID);
				p_QuickRegisterPanel.f_lines.viewTable(Integer.valueOf(order_ID));
				MOrder order = new MOrder(p_QuickRegisterPanel.m_ctx, Integer
						.valueOf(order_ID),null);
				//set button name
				String docAction = "";
				String str = "";
				docAction = order.getDocAction();
				MRefList ref = new MRefList(p_QuickRegisterPanel.m_ctx,135,null);
				if(docAction.equals("CO")){
					str =  ref.getListName(p_QuickRegisterPanel.m_ctx,135,"CO");
				}else if(docAction.equals("PR")){
					str = ref.getListName(p_QuickRegisterPanel.m_ctx,135,"PR");
				}else if(docAction.equals("CL")){
					str = ref.getListName(p_QuickRegisterPanel.m_ctx,135,"CL");
				}else if(docAction.equals("--")){
					str = ref.getListName(p_QuickRegisterPanel.m_ctx,135,"--");
				}
				p_QuickRegisterPanel.f_orderline.f_complete.setText(str);
				
				docType = order.getC_DocType_ID();
				int rows = p_QuickRegisterPanel.f_lines.getM_table().getRowCount();
				
				if (rows != 0) {
					p_QuickRegisterPanel.f_lines.getM_table()
							.getSelectionModel().setSelectionInterval(
									1, 0);
					p_QuickRegisterPanel.f_lines.getM_table()
							.requestFocus();
					p_QuickRegisterPanel.f_status.setStatusLine(Msg.getMsg(Env.getCtx(), "Records")+ "=" + rows);
					p_QuickRegisterPanel.f_status.setStatusDB("[" + "1" + "/" + rows + "]");
				}else {
					p_QuickRegisterPanel.f_status.setStatusDB("[" + "0" + "/" + rows + "]");
				}
				setTotalValues(customerID,Location,orderNo,customerNo,totalValues, docType,docstuts,Description);
				setEnableFunction(order_ID);
				
			}
			mutultiFlg = "1";
			aMulti.setPressed(true);
			//into orders
		} else if ((mutultiFlg.equals("1")) && (rowSelect != -1)) {
			aNew.setEnabled(false);
			aRefresh.setEnabled(true);
			aSave.setEnabled(false);
			p_QuickRegisterPanel.f_lines.setVisible(false);
			p_QuickRegisterPanel.f_orderlines.setVisible(true);
			p_QuickRegisterPanel.f_orderlines.updateTable(query);
			// set scroll control
			int orderTableCount = p_QuickRegisterPanel.f_orderlines.m_table.getRowCount();
			if(orderTableCount > 0){
				String order_oldID = "" ;
				for(int i = 0; i< orderTableCount ;i ++){
					if(p_QuickRegisterPanel.f_orderlines.m_table.getValueAt(i, 0) != null){
						
						order_oldID = p_QuickRegisterPanel.f_orderlines.m_table.getValueAt(i, 0).toString();
						int equlsFlg = order_oldID.indexOf('=');
							equlsFlg++;
						int pointFlg = order_oldID.indexOf(',');
							order_oldID = order_oldID.substring(equlsFlg, pointFlg);
						if(Integer.valueOf(order_oldID) == p_QuickRegisterPanel.f_orderline.m_C_Order_ID){
							p_QuickRegisterPanel.f_orderlines.m_table.getSelectionModel().setSelectionInterval(i, i);
							p_QuickRegisterPanel.f_orderlines.m_table.requestFocus();
//							//scroll 
							Point p = new Point(0,p_QuickRegisterPanel.f_orderlines.m_table.getRowHeight()*i);
							p_QuickRegisterPanel.f_orderlines.scroll.getViewport().setViewPosition(p); 
							break;
						}
					}
				}
			}
			
			
			mutultiFlg = "0";
			
			p_QuickRegisterPanel.f_bpartner.setVisible(false);
			p_QuickRegisterPanel.f_orderline.setVisible(false);
			p_QuickRegisterPanel.f_product.setVisible(false);
			p_QuickRegisterPanel.f_currentLine.setVisible(false);
			p_QuickRegisterPanel.f_quickRegisterMenu.aDelete.setEnabled(true);
			p_QuickRegisterPanel.f_quickRegisterMenu.aFirst.setEnabled(true);
			p_QuickRegisterPanel.f_quickRegisterMenu.aNext.setEnabled(true);
			p_QuickRegisterPanel.f_quickRegisterMenu.aPrevious.setEnabled(true);
			p_QuickRegisterPanel.f_quickRegisterMenu.aLast.setEnabled(true);
			aMulti.setPressed(false);
			p_QuickRegisterPanel.f_orderlines.checkClick = 0;  //mouse count decide  inter 
			
			//clear
			p_QuickRegisterPanel.f_lines.getF_total().setValue(Env.ZERO);
			p_QuickRegisterPanel.f_lines.getF_net().setValue(Env.ZERO);
			p_QuickRegisterPanel.f_lines.f_docStatus.setValue("");
			p_QuickRegisterPanel.f_orderline.f_orderNo.setValue("");
			p_QuickRegisterPanel.f_orderline.f_customerNo.setValue("");
			p_QuickRegisterPanel.f_orderline.f_descreption.setValue("");
			 setStatusValue();
			
		}
	}
	public void setStatusValue()
	{
		int rows = p_QuickRegisterPanel.f_orderlines.getM_table().getRowCount();
		if(rows > 0 ){
			int row = p_QuickRegisterPanel.f_orderlines.getM_table().getSelectedRow();
			row ++;
			p_QuickRegisterPanel.f_status.setStatusLine(Msg.getMsg(Env.getCtx(), "Records")+ "=" + rows);
			p_QuickRegisterPanel.f_status.setStatusDB("[" + row + "/" + rows + "]" );
		}else if(rows == 0 ){
			p_QuickRegisterPanel.f_status.setStatusDB( "[" + 0 + "/" + rows + "]");
		}
	}
	public void showOrderliens (Query query ){
//		if(p_QuickRegisterPanel.f_orderlines.checkClick == 1){
			p_QuickRegisterPanel.f_orderlines.checkClick = 0 ;
			p_QuickRegisterPanel.f_bpartner.setVisible(false);
			p_QuickRegisterPanel.f_orderline.setVisible(false);
			p_QuickRegisterPanel.f_product.setVisible(false);
			p_QuickRegisterPanel.f_currentLine.setVisible(false);
		
			aDelete.setEnabled(true);
			aFirst.setEnabled(true);
			aNext.setEnabled(true);
			aPrevious.setEnabled(true);
			aLast.setEnabled(true);
			aNew.setEnabled(false);
			aMulti.setEnabled(true);
			aMulti.setPressed(false);
			aRefresh.setEnabled(true);
			p_QuickRegisterPanel.closeQuery();
//			p_QuickRegisterPanel.f_orderline.orderUpdate( query );
			p_QuickRegisterPanel.f_orderlines.updateTable(query);
			int rows = p_QuickRegisterPanel.f_orderlines.m_table.getRowCount();
			
			p_QuickRegisterPanel.f_status.setStatusLine(Msg.getMsg(Env.getCtx(), "Records")+ "=" + rows);
			if (rows == 0) {
				p_QuickRegisterPanel.f_status.setStatusDB("[" + 0 + "/" + rows + "]");
				return;
			} else {
				p_QuickRegisterPanel.f_status.setStatusDB("[" + 1 + "/" + rows + "]");
				rows = 0;
				p_QuickRegisterPanel.f_lines.setVisible(false);
				p_QuickRegisterPanel.m_southPanel.setVisible(true);
				p_QuickRegisterPanel.f_orderlines.setVisible(true);
				
				p_QuickRegisterPanel.f_orderlines.getM_table().setVisible(true);
				p_QuickRegisterPanel.f_orderlines.getM_table()
					.getSelectionModel().setSelectionInterval(1, 0);
				p_QuickRegisterPanel.f_orderlines.m_table.requestFocus();
				
				//scroll area 
				p_QuickRegisterPanel.f_orderlines.scroll.getViewport().add(p_QuickRegisterPanel.f_orderlines.m_table);
				Point p = new Point(0, 0);
				p_QuickRegisterPanel.f_orderlines.scroll.getViewport().setViewPosition(p);
				
			}
		}
	
	/**
	 *  set enable or disable
	 *  */
	public  void  setEnableFunction(String order_ID){
	String  dw = p_QuickRegisterPanel.f_orderlines.sqlCheckDR(Integer.valueOf(order_ID));
		p_QuickRegisterPanel.f_currentLine.m_order = new MOrder(p_QuickRegisterPanel.m_ctx,  Integer.valueOf(order_ID),null);
		if(dw.equals("CO")){
			
			p_QuickRegisterPanel.f_product.f_name.setEnabled(false);
			p_QuickRegisterPanel.f_product.f_bSearch.setEnabled(false);
			p_QuickRegisterPanel.f_bpartner.f_name.setEnabled(false);
			p_QuickRegisterPanel.f_bpartner.f_bSearch.setEnabled(false);
			p_QuickRegisterPanel.f_bpartner.f_location.setEnabled(false);
			p_QuickRegisterPanel.f_bpartner.f_user.setEnabled(false);
			p_QuickRegisterPanel.f_currentLine.f_new.setEnabled(false);
			p_QuickRegisterPanel.f_quickRegisterMenu.aSave.setEnabled(false);
			p_QuickRegisterPanel.f_lines.f_delete.setEnabled(false);
		}else {
			p_QuickRegisterPanel.f_product.f_name.setEnabled(true);
			p_QuickRegisterPanel.f_product.f_bSearch.setEnabled(true);
			p_QuickRegisterPanel.f_bpartner.f_bSearch.setEnabled(true);
			p_QuickRegisterPanel.f_bpartner.f_name.setEnabled(true);
			p_QuickRegisterPanel.f_bpartner.f_name.setReadWrite(true);
			p_QuickRegisterPanel.f_bpartner.f_location.setReadWrite(true);
			p_QuickRegisterPanel.f_bpartner.f_location.setEnabled(true);
			p_QuickRegisterPanel.f_bpartner.f_user.setReadWrite(true);
			p_QuickRegisterPanel.f_bpartner.f_user.setEnabled(true);
			p_QuickRegisterPanel.f_currentLine.f_new.setEnabled(false);
			p_QuickRegisterPanel.f_quickRegisterMenu.aSave.setEnabled(true);
			p_QuickRegisterPanel.f_lines.f_delete.setEnabled(true);
			
		}
	}
	

}	//	
