/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.quickregister;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;

import javax.swing.JOptionPane;

import org.compiere.apps.ADialog;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

/**
 *	Quick Register Main Window.
 *
 *  @author Horcha
 *  @version $Id: QuickRegisterPanel.java,v 1.3 2010/01/10 07:50:33 jrmt Exp $
 */
public class QuickRegisterPanel extends CPanel implements ActionListener,DataStatusListener
{
	/**
	 * 	Constructor - see init 
	 */
	public QuickRegisterPanel( )
	{
//		super (new GridBagLayout());
		super (new BorderLayout());
		
		panel.setLayout(new GridBagLayout());
		init();
		
		this.add(panel, BorderLayout.NORTH);
		this.add(m_southPanel, BorderLayout.CENTER);
		this.add(f_status, BorderLayout.SOUTH );
		m_WindowNo = Env.createWindowNo(this);
		
		
	}	//	QuickRegisterPanel

	protected CPanel panel = new CPanel();
	protected CPanel m_northPanel = null;
	/** Status Bar */
	protected StatusBar f_status = new StatusBar();
	/**	Window No			*/
	protected int         	m_WindowNo = 1;
	/**	FormFrame			*/
	private FormFrame 		m_frame;
	/**	Logger				*/
	private CLogger			log = CLogger.getCLogger(getClass());
	/** Context				*/
	protected Ctx				m_ctx = Env.getCtx();
	/** Sales Rep 			*/
	private int				m_SalesRep_ID = 0;
	/** Quick Register Model			*/
	protected MQuickRegister		p_QuickRegister = null;
	/** Customer Panel				*/
	protected SubBPartner 		f_bpartner = null;
	/** Customer Panel				*/
	protected SubOrder 		f_orderline = null;
	protected  QuickRegisterMenu f_quickRegisterMenu = null ;
	/** Current Line				*/
	protected SubCurrentLine 	f_currentLine = null;
	/** Product	Selection			*/
	protected SubProduct 		f_product = null;
	/** All Lines					*/
	protected SubLines 			f_lines = null;
	/** All Lines					*/
	protected SubOrderLines 			f_orderlines = null;
    /** South Panel                  */
    protected CPanel            m_southPanel = null; 
    /** South Panel                  */
    protected HashSet<Frame>    m_visibleFrames = new HashSet<Frame>(); 
    private CPanel queryPanel;
	/**	Product Query Window		*/
	protected QuickRegisterProduct 		f_queryProduct = null;
	/**	BPartner Query Window		*/
	protected QuickRegisterBPartner 		f_queryBPartner = null;
	/**	Currency Precision			*/
	private int         	m_CurrencyPrecision = 2;
	//	Today's (login) date		*/
	private Timestamp			m_today = new Timestamp(m_ctx.getContextAsTime("#Date"));
	
	
	
	/**
	 *	Initialize Panel
	 *  @param WindowNo window
	 *  @param frame parent frame
	 */
	public void init ()
	{
		
		try
		{
			if (!dynInit())
			{
				dispose();
				return;
			}
		}
		catch(Exception e)
		{
			log.log(Level.SEVERE, "init", e);
		}
		log.config( "QuickRegisterPanel.init - " + getPreferredSize());
		
	}	//	init

    /**
     * @param fullScreen
     */
    private void fullScreen(boolean fullScreen)
    {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        if (gd.isFullScreenSupported())
        {
            for (Frame frame : Frame.getFrames())
            {
                if (frame != m_frame)
                {
                    if (fullScreen && frame.isVisible())
                    {
                        m_visibleFrames.add(frame);
                        frame.setVisible(false);
                    }
                    else if (!fullScreen && m_visibleFrames.contains(frame))
                    {
                        m_visibleFrames.remove(frame);
                        frame.setVisible(true);
                    }
                }
                else
                    frame.setVisible(fullScreen);
            }

            try {
                gd.setFullScreenWindow(null);
                if (fullScreen)
                {
                    gd.setFullScreenWindow(m_frame);
                    if (gd.isDisplayChangeSupported())
                    {
                        for (DisplayMode dm : gd.getDisplayModes())
                        {
                            if (dm.getWidth() == 800)
                            {
                                gd.setDisplayMode(dm);
                            }
                        }
                    }
                    m_frame.invalidate();
                    m_frame.repaint();
                }
            }
            catch (Exception e)
            {
                gd.setFullScreenWindow(null);
            }
        }
    }

	/**
	 * 	Dispose - Free Resources
	 */
	public void dispose()
	{
		
		//
		if (f_bpartner != null)
			f_bpartner.dispose();
		f_bpartner = null;
//		if (f_salesRep != null)
//			f_salesRep.dispose();
//		f_salesRep = null;
		if (f_currentLine != null)
			f_currentLine.dispose();
		f_currentLine = null;
		if (f_product != null)
			f_product.dispose();
		f_product = null;
		if (f_lines != null)
			f_lines.dispose();
		f_lines = null;
		if (f_orderlines != null)
			f_orderlines.dispose();
		f_orderlines = null;
		if (f_quickRegisterMenu != null)
			f_quickRegisterMenu.dispose();
		f_quickRegisterMenu = null;
		
		if (f_queryProduct != null)
			f_queryProduct.dispose();
		f_queryProduct = null;
		if (f_queryBPartner != null)
			f_queryBPartner.dispose();
		f_queryBPartner = null;
		m_frame = null;
		m_ctx = null;
	}	//	dispose

	/**************************************************************************
	 * 	Dynamic Init.
	 * 	QuickRegisterPanel has a GridBagLayout.
	 * 	The Sub Panels return their position
	 */
	private boolean dynInit()
	{
		if (!setMQuickRegister())
			return false;
		
		//	Create Sub Panels
      
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = GridBagConstraints.BOTH;
        
        m_northPanel = new CPanel(new GridBagLayout());
        f_quickRegisterMenu = new QuickRegisterMenu(this);
        gbc.gridx = 0;
        gbc.gridy = 0;	
        gbc.gridwidth = 3;
        gbc.weightx = 1;
        gbc.anchor = GridBagConstraints.WEST;
        panel.add (f_quickRegisterMenu, gbc);
        
        
		f_bpartner = new SubBPartner (this);
        gbc.gridx = 0;
        gbc.gridy = 1;	
        gbc.gridwidth = 1;
        gbc.weightx = .28;
        panel.add (f_bpartner, gbc);
        
        //Order line
        f_orderline = new SubOrder (this);
        gbc.gridx = 1;
        gbc.gridy = 1;	
        gbc.gridwidth = 2;
        gbc.weightx = .46;
        panel.add (f_orderline, gbc);

        f_product = new SubProduct (this);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.weightx = .28;
        panel.add (f_product, gbc);


		f_currentLine = new SubCurrentLine (this);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.weightx = .28;
        panel.add (f_currentLine, gbc);
        

        m_southPanel = new CPanel(new GridBagLayout());
		f_lines = new SubLines (this);
		f_lines.setVisible(false);
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1;
        m_southPanel.add (f_lines, gbc);
        
        f_orderlines = new SubOrderLines (this);
        f_orderlines.setVisible(false);
        f_orderlines.setPreferredSize(new Dimension(600, 620));
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1;
        panel.add (f_orderlines, gbc);
//		Info
        f_status.setStatusLine(Msg.getMsg(Env.getCtx(), "Rows"));
		f_status.setStatusDB(" ");
		newOrder();
		return true;
	}	//	dynInit


	/**
	 * 	Set setMQuickRegister
	 *	@return true if found/set
	 */
	protected boolean setMQuickRegister()
	{
		MQuickRegister[] quickregisters = null;
		if (m_SalesRep_ID == 100)	//	superUser
			quickregisters = getQuickRegisters (0);
		else
			quickregisters = getQuickRegisters (m_SalesRep_ID);
		//
		if (quickregisters.length == 0)
		{
			ADialog.error(m_WindowNo, m_frame, "NoPOSForUser");
			return false;
		}
		else if (quickregisters.length == 1)
		{
			p_QuickRegister = quickregisters[0];
			return true;
		}

		//	Select QuickRegister
		String msg = Msg.getMsg(m_ctx, "SelectQuickRegister");
		String title = Env.getHeader(m_ctx, m_WindowNo);
		Object selection = JOptionPane.showInputDialog(m_frame, msg, title, 
			JOptionPane.QUESTION_MESSAGE, null, quickregisters, quickregisters[0]);
		if (selection != null)
		{
			p_QuickRegister = (MQuickRegister)selection;
			return true;
		}
		return false;
	}	//	setMQuickRegister
	
	/**
	 * 	Get QuickRegisters for specific Sales Rep or all
	 *	@param SalesRep_ID
	 *	@return array of QuickRegister
	 */
	private MQuickRegister[] getQuickRegisters (int SalesRep_ID)
	{
		ArrayList<MQuickRegister> list = new ArrayList<MQuickRegister>();
		String sql = "SELECT * FROM C_POS WHERE SalesRep_ID=?";
		if (SalesRep_ID == 0)
			sql = "SELECT * FROM C_POS WHERE AD_Client_ID=?";
		PreparedStatement pstmt = null;
		try
		{
			pstmt = DB.prepareStatement (sql, null);
			if (SalesRep_ID != 0)
				pstmt.setInt (1, m_SalesRep_ID);
			else
				pstmt.setInt (1, m_ctx.getAD_Client_ID());
			ResultSet rs = pstmt.executeQuery ();
			while (rs.next ())
				list.add(new MQuickRegister(m_ctx, rs, null));
			rs.close ();
			pstmt.close ();
			pstmt = null;
		}
		catch (Exception e)
		{
			log.log(Level.SEVERE, sql, e);
		}
		try
		{
			if (pstmt != null)
				pstmt.close ();
			pstmt = null;
		}
		catch (Exception e)
		{
			pstmt = null;
		}
		MQuickRegister[] retValue = new MQuickRegister[list.size ()];
		list.toArray (retValue);
		return retValue;
	}	//	getgetQuickRegisters


	/**
	 * 	Set Visible
	 *	@param aFlag visible
	 */
	public void setVisible (boolean aFlag)
	{
		super.setVisible (aFlag);
		f_product.f_name.requestFocus();
	}	//	setVisible


	/**
	 * 	Open Query Window
	 *	@param panel
	 */
	public void openQuery(CPanel panel)
	{
        if (queryPanel != null)
            closeQuery();
        if(panel != this){
        	GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = GridBagConstraints.BOTH;
            gbc.weighty = 1.0;
            gbc.gridy = 2;
            gbc.gridwidth = GridBagConstraints.REMAINDER;
            gbc.gridheight = GridBagConstraints.REMAINDER;
          
            add (panel);
            queryPanel = panel;
            queryPanel.setVisible(true);
            m_southPanel.setVisible(false);
            
        }
        
	}	//	closeQuery

	/**
	 * 	Close Query Window
	 */
	public void closeQuery ()
	{
        if (queryPanel != null){
        
//        	queryPanel.setVisible(false);
            remove(queryPanel);
        }
        
        m_southPanel.setVisible(true);
	}	//	closeQuery

	/**************************************************************************
	 * 	Get Today's date
	 *	@return date
	 */
	public Timestamp getToday()
	{
		return m_today;
	}	//	getToday
	
	
	/**
	 * 	New Order
	 */
	public void newOrder()
	{
		log.info( "QuickRegisterPabel.newOrder");
		f_currentLine.newOrder();
		f_currentLine.newLine();
		updateInfo();
	}	//	newOrder
	
	/**
	 * Get the number of the window for the function calls that it needs 
	 * 
	 * @return the window number
	 */
	public int getWindowNo()
	{
		return m_WindowNo;
	}
	
	public void updateInfo()
	{
		if (f_lines != null)
			f_lines.updateTable(f_currentLine.getOrder());
	}

	public int getCurrencyPrecision() {
		return m_CurrencyPrecision;
	}

	public void setCurrencyPrecision(int currencyPrecision) {
		m_CurrencyPrecision = currencyPrecision;
	}

	public void actionPerformed(ActionEvent e) {
		
	}

	public void dataStatusChanged(DataStatusEvent e) {
		log.info(e.getMessage());
		f_status.setStatusDB(String.valueOf(e.getMessage()));
	}	
}	//	QuickRegisterPanel

