/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.quickregister;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import org.compiere.grid.ed.VPAttribute;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MWarehousePrice;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

/**
 *	QuickRegister Query Product
 *	
 *  @author Horcha
 *  @version $Id: QuickRegisterProduct.java,v 1.3 2010/01/10 07:50:34 jrmt Exp $
 */
public class QuickRegisterProduct extends QuickRegisterSubPanel
	implements ActionListener, MouseListener, ListSelectionListener,KeyListener
{
	/**
	 * 	Constructor
	 */
	public QuickRegisterProduct (QuickRegisterPanel quickRegisterPanel)
	{
		super(quickRegisterPanel);
	}	//	QuickRegisterProduct

	/** The Table					*/
	private MiniTable		m_table;
	
	private CPanel 			northPanel;
	private CScrollPane 	centerScroll;
	private RegisterConfirmPanel	confirm;
	protected CTextField		f_value;
	protected CTextField		f_name;
	private CTextField		f_upc;
	private CTextField		f_sku;

	private CButton			f_up;
	private CButton			f_down;

	private int				m_M_Product_ID;
	private String			m_ProductName;
	private BigDecimal		m_Price;
	//
	private int 			m_M_PriceList_Version_ID;
	private int 			m_M_Warehouse_ID;
	private BigDecimal m_Qty;
	/** Model Index of Key Column   */
	protected int              	p_keyColumnIndex = -1;
	/**	Logger	*/
	/**	Logger			*/
	private static CLogger log = CLogger.getCLogger(QuickRegisterProduct.class);

	
	/**	Table Column Layout Info			*/
	private static ColumnInfo[] s_layout = new ColumnInfo[] 
	{
		new ColumnInfo(" ", "M_Product_ID", IDColumn.class),
		new ColumnInfo(Msg.translate(Env.getCtx(), "Value"), "Value", String.class),
		new ColumnInfo(Msg.translate(Env.getCtx(), "Name"), "Name", String.class),
		new ColumnInfo(Msg.translate(Env.getCtx(), "UPC"), "UPC", String.class), 
		new ColumnInfo(Msg.translate(Env.getCtx(), "SKU"), "SKU", String.class), 
		new ColumnInfo(Msg.translate(Env.getCtx(), "QtyAvailable"), "QtyAvailable", Double.class),
		new ColumnInfo(Msg.translate(Env.getCtx(), "QtyOnHand"), "QtyOnHand", Double.class),
		new ColumnInfo(Msg.translate(Env.getCtx(), "PriceStd"), "PriceStd", BigDecimal.class)
	};
	/**	From Clause							*/
	private static String s_sqlFrom = "RV_WarehousePrice";
	/** Where Clause						*/
	private static String s_sqlWhere = "IsActive='Y'"; 

	/**
	 * 	Set up Panel
	 */
	protected void init()
	{
		setLayout(new BorderLayout(5,5));
        
		//	North
		northPanel = new CPanel(new GridBagLayout());
		add (northPanel, BorderLayout.NORTH);
		northPanel.setBorder(new TitledBorder(Msg.getMsg(p_ctx, "Query")));
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.insets = QuickRegisterSubPanel.INSETS2;
		//
		gbc.gridy = 0;
		gbc.gridx = GridBagConstraints.RELATIVE;
		CLabel lvalue = new CLabel(Msg.translate(p_ctx, "Value"));
		gbc.anchor = GridBagConstraints.EAST;
		northPanel.add (lvalue, gbc);
		f_value = new CTextField(20);
		f_value.addKeyListener(this);
		lvalue.setLabelFor(f_value);
		gbc.anchor = GridBagConstraints.WEST;
		northPanel.add(f_value, gbc);
		f_value.addActionListener(this);
		//
		CLabel lupc = new CLabel(Msg.translate(p_ctx, "UPC"));
		gbc.anchor = GridBagConstraints.EAST;
		northPanel.add (lupc, gbc);
		f_upc = new CTextField(15);
		f_upc.addKeyListener(this);
		lupc.setLabelFor(f_upc);
		gbc.anchor = GridBagConstraints.WEST;
		northPanel.add(f_upc, gbc);
		f_upc.addActionListener(this);
		//
		gbc.gridy = 1;
		CLabel lname = new CLabel(Msg.translate(p_ctx, "Name"));
		gbc.anchor = GridBagConstraints.EAST;
		northPanel.add (lname, gbc);
		f_name = new CTextField(20);
		lname.setLabelFor(f_name);
		f_name.addKeyListener(this);
		gbc.anchor = GridBagConstraints.WEST;
		northPanel.add(f_name, gbc);
		f_name.addActionListener(this);
		//
		CLabel lsku = new CLabel(Msg.translate(p_ctx, "SKU"));
		gbc.anchor = GridBagConstraints.EAST;
		northPanel.add (lsku, gbc);
		f_sku = new CTextField(15);
		f_sku.addKeyListener(this);
		lsku.setLabelFor(f_sku);
		gbc.anchor = GridBagConstraints.WEST;
		northPanel.add(f_sku, gbc);
		f_sku.addActionListener(this);
		//
		gbc.gridy = 0;
		gbc.gridheight = 2;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.weightx = .1;
		f_up = createButtonAction("Previous", KeyStroke.getKeyStroke(KeyEvent.VK_UP, 0));
		northPanel.add(f_up, gbc);
		gbc.weightx = 0;
		f_down = createButtonAction("Next", KeyStroke.getKeyStroke(KeyEvent.VK_DOWN, 0));
		northPanel.add(f_down, gbc);
		
		//	Confirm
		confirm = new RegisterConfirmPanel (true, true, true, false, false, false, false);
		add (confirm, BorderLayout.SOUTH);
		confirm.addActionListener(this);

		//	Center
		m_table = new MiniTable();
		m_table.prepareTable (s_layout, s_sqlFrom, s_sqlWhere, false, "RV_WarehousePrice");
        Dimension size = m_table.getPreferredScrollableViewportSize();
        size.height = m_table.getRowHeight();
        m_table.setPreferredScrollableViewportSize(size);
		m_table.setRowSelectionAllowed(true);
		m_table.setColumnSelectionAllowed(false);
		m_table.setMultiSelection(false);
		m_table.addMouseListener(this);
		//
		m_table.addKeyListener(this);
		
		m_table.getSelectionModel().addListSelectionListener(this);
		enableButtons();
		centerScroll = new CScrollPane(m_table);
		add (centerScroll, BorderLayout.CENTER);
		
		p_QuickRegisterPanel.f_quickRegisterMenu.aSave.getButton().setEnabled(false);
	}	//	init
	/**
	 * 	Dispose
	 */
	public void dispose()
	{
		removeAll();
		northPanel = null;
		centerScroll = null;
		confirm = null;
		m_table = null;
	}	//	dispose
	
	/**
	 * 	Set Query Data
	 *	@param M_PriceList_Version_ID plv
	 *	@param M_Warehouse_ID wh
	 */
	public void setQueryData (int M_PriceList_Version_ID, int M_Warehouse_ID)
	{
		m_M_PriceList_Version_ID = M_PriceList_Version_ID;
		m_M_Warehouse_ID = M_Warehouse_ID;
	}	//	setQueryData
	
	/**
	 * 	Action Listener
	 *	@param e event
	 */
	public void actionPerformed (ActionEvent e)
	{
		log.info(e.getActionCommand());
		if ("Refresh".equals(e.getActionCommand())
				|| e.getSource() == f_value || e.getSource() == f_upc
				|| e.getSource() == f_name || e.getSource() == f_sku)
		{
			setResults(MWarehousePrice.find (p_ctx,
				m_M_PriceList_Version_ID, m_M_Warehouse_ID,
				f_value.getText(), f_name.getText(), f_upc.getText(), f_sku.getText(), null));
			f_value.requestFocus();
			return;
		}
		 if ("Reset".equals(e.getActionCommand()))
		{
			f_value.setText(null);
			f_name.setText(null);
			f_sku.setText(null);
			f_upc.setText(null);
			setResults(new MWarehousePrice[0]);
			f_value.requestFocus();
			return;
		}
		else if ("Previous".equalsIgnoreCase(e.getActionCommand()))
		{
			int rows = m_table.getRowCount();
			if (rows == 0)
				return;
			int row = m_table.getSelectedRow();
			row--;  
			if (row < 0)
				row = 0;
			m_table.getSelectionModel().setSelectionInterval(row, row);
			return;
		}
		else if ("Next".equalsIgnoreCase(e.getActionCommand()))
		{
			int rows = m_table.getRowCount();
			if (rows == 0)
				return;
			int row = m_table.getSelectedRow();
			row++;
			if (row >= rows)
				row = rows - 1;
			m_table.getSelectionModel().setSelectionInterval(row, row);
			return;
		} 
//		else if ("Cancel".equalsIgnoreCase(e.getActionCommand())){
			close();
//		}
		//	Exit
		
	}	//	actionPerformed
	
	/**
	 * 	Set/display Results
	 *	@param results results
	 */
	public void setResults (MWarehousePrice[] results)
	{
		m_table.loadTable(results);
		enableButtons();
		if(results.length != 0){
			m_table.requestFocus();
			m_table.getSelectionModel().setSelectionInterval(0, 0);
		}
	
		
	}	//	setResults
	
	/**
	 * 	Table selection changed
	 *	@param e event
	 */
	public void valueChanged (ListSelectionEvent e)
	{	
		if (e.getValueIsAdjusting())
			return;
	
		enableButtons();
		
		//close();
		
		
		
	}	//	valueChanged

	/**
	 * 	Enable/Set Buttons and set ID
	 */
	private void enableButtons()
	{
		m_M_Product_ID = -1;
		m_ProductName = null;
		m_Price = null;
		int row = m_table.getSelectedRow();
		boolean enabled = row != -1;
		if (enabled)
		{
			Integer ID = m_table.getSelectedRowKey();
			if (ID != null)
			{
				m_M_Product_ID = ID.intValue();
				m_ProductName = (String)m_table.getValueAt(row, 2);
				
				m_Price = (BigDecimal)m_table.getValueAt(row, 7);
				if(m_M_Product_ID != 0){
					clearM_AttributeSetInstance_ID(0,m_M_Product_ID);
//					executeQuery(m_M_Product_ID);
				
				}
			}
			
		}
		
		confirm.getOKButton().setEnabled(enabled);
		
		log.fine("M_Product_ID=" + m_M_Product_ID + " - " + m_ProductName + " - " + m_Price); 
	}	//	enableButtons
	
	/**
	 *  Query Info
	 */
	private void executeQuery( int M_PRODUCT_ID )
	{
		log.info("");
		int AD_Client_ID = Env.getCtx().getAD_Client_ID();
		//  Create SQL
		String  M_AttributeSetInstance_ID = "0";
		StringBuffer sql = new StringBuffer(
			"SELECT p.M_ATTRIBUTESETINSTANCE_ID "
			+ "FROM  AD_Org o, M_Product p "
			+ "WHERE p.AD_Org_ID = o.AD_Org_ID "
			+ " AND p.M_Product_ID = ? "
			);
		
		if (AD_Client_ID != 0)
			sql.append(" AND p.AD_Client_ID  = ").append(AD_Client_ID);
		sql.append(" ORDER BY p.Name");
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
			pstmt.setInt(1, M_PRODUCT_ID);
			ResultSet rs = pstmt.executeQuery();
			//
			while (rs.next())
			{
				if((rs.getString(1) != null)){
					  M_AttributeSetInstance_ID = rs.getString(1).toString(); //  M_AttributeSetInstance_ID
					if((!M_AttributeSetInstance_ID.equals("")) && (M_AttributeSetInstance_ID != null))
					setAttributeSetInstanceID(Integer.valueOf(M_AttributeSetInstance_ID),M_PRODUCT_ID);
				}
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql.toString(), e);
		}
	}
	/**
	 * 	Set M_AttributeSetInstance_ID
	 *	@param M_AttributeSetInstance_ID id
	 */
	public void setAttributeSetInstanceID (int M_AttributeSetInstance_ID,int M_Product_ID)
	{
			
			int  M_ProductBOM_ID =  Env.getCtx().getContextAsInt("M_ProductBOM_ID");		
			
			Map<String ,String> map = new HashMap<String ,String>();
			map.put("M_Product_ID", String.valueOf(M_Product_ID));
			map.put("M_ProductBOM_ID", String.valueOf(M_ProductBOM_ID));
			Env.getCtx().setContext(10, map);
			if(p_QuickRegisterPanel.f_product.getComponent(2) instanceof  VPAttribute){
				VPAttribute attri = (VPAttribute)p_QuickRegisterPanel.f_product.getComponent(2);
				if((M_AttributeSetInstance_ID != 0)&& (M_AttributeSetInstance_ID > 0)){
					try {
						attri.setValue(M_AttributeSetInstance_ID);
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
				
			}
		
	}	//	setM_AttributeSetInstance_ID
	/**
	 * 	Set M_AttributeSetInstance_ID
	 *	@param M_AttributeSetInstance_ID id
	 */
	public void clearM_AttributeSetInstance_ID (int M_AttributeSetInstance_ID,int M_Product_ID)
	{
			
			int  M_ProductBOM_ID =  Env.getCtx().getContextAsInt("M_ProductBOM_ID");		
			
			Map<String ,String> map = new HashMap<String ,String>();
			map.put("M_Product_ID", String.valueOf(M_Product_ID));
			map.put("M_ProductBOM_ID", String.valueOf(M_ProductBOM_ID));
			Env.getCtx().setContext(10, map);
			if(p_QuickRegisterPanel.f_product.getComponent(2) instanceof  VPAttribute){
				VPAttribute attri = (VPAttribute)p_QuickRegisterPanel.f_product.getComponent(2);
					try {
						attri.setValue(M_AttributeSetInstance_ID);
					} catch (Exception e) {
						e.printStackTrace();
					}
//				}
				
			}
		
	}	//	setM_AttributeSetInstance_ID


	/**
	 *  Mouse Clicked
	 *  @param e event
	 */
	public void mouseClicked(MouseEvent e)
	{
		//  Double click with selected row => exit
		if (e.getClickCount() > 1 && m_table.getSelectedRow() != -1)
		{
			enableButtons();
			close();
			
		}
	}   //  mouseClicked

	public void mouseEntered (MouseEvent e) {}
	public void mouseExited (MouseEvent e) {}
	public void mousePressed (MouseEvent e) {}
	public void mouseReleased (MouseEvent e) {}

	/**
	 * 	Close.
	 * 	Set Values on other panels and close
	 */
	private void close()
	{
	    log.fine("M_Product_ID=" + m_M_Product_ID); 
		
		if (m_M_Product_ID > 0)
		{
			p_QuickRegisterPanel.f_product.setM_Product_ID(m_M_Product_ID);
			p_QuickRegisterPanel.f_currentLine.setPrice(m_Price);
		}
		else
		{
			p_QuickRegisterPanel.f_product.setM_Product_ID(0);
			p_QuickRegisterPanel.f_currentLine.setPrice(Env.ZERO);
		}
		p_QuickRegisterPanel.closeQuery();
		p_QuickRegisterPanel.f_product.f_name.requestFocus();
//		p_QuickRegisterPanel.f_currentLine.f_price.setReadWrite(true);
	}	//	close
	
	
	/**
	 * 	Request Focus In Window
	 *	@return focus request
	 */
	public boolean requestFocusInWindow()
	{
		if (f_value != null)
			return f_value.requestFocusInWindow();
	    return super.requestFocusInWindow();
	}	//	requestFocusInWindow

	public void keyPressed(KeyEvent e) {
	}


	public void keyReleased(KeyEvent e) {
		
		if((e.getKeyCode() == KeyEvent.VK_SPACE)&&(e.getSource() == m_table ) ){
			
			enableButtons();
			close();
			p_QuickRegisterPanel.f_product.f_name.requestFocus();
			p_QuickRegisterPanel.f_product.setM_Product_ID(m_M_Product_ID);
		}else
		if((e.getKeyCode() == KeyEvent.VK_ESCAPE)&& (e.getSource() == m_table ) ){
		
			enableButtons();
			close();
			p_QuickRegisterPanel.f_product.f_name.requestFocus();
			p_QuickRegisterPanel.f_product.setM_Product_ID(m_M_Product_ID);
			
			return;
		}else if (( e.getSource() == f_value || e.getSource() == f_upc
				|| e.getSource() == f_name || e.getSource() == f_sku)&& e.getKeyCode() == KeyEvent.VK_ENTER )
		{
				setResults(MWarehousePrice.find (p_ctx,
					m_M_PriceList_Version_ID, m_M_Warehouse_ID,
					f_value.getText(), f_name.getText(), f_upc.getText(), f_sku.getText(), null));
				return;
		}
		if((this != null)&&(e.getSource() == KeyStroke.getKeyStroke(KeyEvent.VK_Z, Event.CTRL_MASK))){
			p_QuickRegisterPanel.closeQuery();
			p_QuickRegisterPanel.setVisible(false);
		}
	}

	public void keyTyped(KeyEvent e) {
	}
}	//	QuickRegisterQueryProduct
