/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.quickregister;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyVetoException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Level;

import javax.swing.DefaultComboBoxModel;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

import org.compiere.framework.Lookup;
import org.compiere.grid.ed.VBPartner;
import org.compiere.grid.ed.VComboBox;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerInfo;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCurrency;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MOrder;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MUser;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CMenuItem;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

/**
 *	SubBPartner  
 *	
 *  @author Horcha
 *  @version $Id: SubBPartner.java,v 1.3 2010/01/10 07:50:33 jrmt Exp $
 */
public class SubBPartner extends QuickRegisterSubPanel 
	implements ActionListener, FocusListener,KeyListener
{
	/**
	 * 	Constructor
	 *	@param QuickPanel QuickRegister Panel
	 */
	public SubBPartner (QuickRegisterPanel p_QuickPanel)
	{
		super (p_QuickPanel);
	}	//	p_QuickSubCustomer
	
	/**	Window No			*/
	private int         	m_WindowNo = 0;
	protected	CTextField		f_name;
	protected CButton 		f_bNew;
	protected CButton 		f_bEdit;
	protected CButton 		f_bSearch;
	/** Field Height (20)				 */
	public static int     		FIELD_HIGHT = 20;
	/** Display Length for Lookups (15)         */
	public final static int     DISPLAY_LENGTH = 15;
	/** The Value								*/
	private Object				m_value;
	/** Column Name								*/
	private String				m_columnName;
	/** Indicator that value is being set       */
	private volatile boolean 	m_settingValue = false;
	/** Indicator that docus is being set       */
	private volatile boolean 	m_settingFocus = false;
	/** Indicator - inserting new value			*/
	private volatile boolean	m_inserting = false;
	/** The Combo Box if not a Search Lookup    */
	private VComboBox			m_combo = new VComboBox();
	/** Search: The Editable Text Field         */
	private CTextField 			m_text = new CTextField (DISPLAY_LENGTH);
	/** Conbo Box Active						*/
	private boolean				m_comboActive = true;
	/** Lookup									*/
	private Lookup				m_lookup;
	/** Last Display							*/
	private String				m_lastDisplay = "";
	/** Search: The Button to open Editor   */
	private CButton				m_button = new CButton();
	/** The Combo Box if not a Search Lookup    */
	
//	protected VLookup 		f_bSearch;
	protected CComboBox		f_location;
	protected CComboBox		f_user;
	protected int			m_C_BPartner_ID;
	private CMenuItem		m_bpartnerUpdate;
	private String		m_tableName = null;
	private String		m_keyColumnName = null;
//	private Object 			m_C_BPartner_ID = null;
	
	private Object 			m_AD_Org_ID = null;
	protected Object 			m_C_Order_ID = null;
	private String 	m_constantValue = null;

    /** BPartner Query Window       */
    private QuickRegisterBPartner f_queryBPartner = new QuickRegisterBPartner (p_QuickRegisterPanel);

	/**	The Business Partner		*/
	private MBPartner	m_bpartner;
	/**	Price List Version to use	*/
	private int			m_M_PriceList_Version_ID = 0;
	/**	Logger			*/
	private static CLogger log = CLogger.getCLogger(SubBPartner.class);

	/**
	 * 	Initialize
	 */
	public void init()
	{
		TitledBorder border = new TitledBorder(Msg.translate(p_ctx, "C_BPartner_ID"));
		setBorder(border);
		
		//	Content
		setLayout(new GridBagLayout());
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.insets = INSETS1;
//		m_combo.addFocusListener(this);
		//	--
		f_bNew = createButtonAction("New", KeyStroke.getKeyStroke(KeyEvent.VK_F2, 0));
		MLookup bpL = MLookupFactory.get (Env.getCtx(), m_WindowNo, 2762, DisplayType.Search);
		new VLookup ("C_BPartner_ID", false, false, true, bpL);
		f_bNew.addKeyListener(this);
		gbc.gridx = 0;
		gbc.gridheight = 2;
		gbc.anchor = GridBagConstraints.WEST;
		add (f_bNew, gbc);
		f_bEdit = createButtonAction ("Edit", null);
		f_bEdit.addKeyListener(this);
		gbc.gridx = 1;
		add (f_bEdit, gbc);
		
		f_name = new CTextField("");
		f_name.setPreferredSize(new Dimension(200, 20));
		f_name.setName("Name");
		f_name.addActionListener(this);
		f_name.addFocusListener(this);
		f_name.addKeyListener(this);
		gbc.gridx = 2;
		gbc.gridy = 0;
		gbc.gridheight = 1;
		gbc.gridwidth = 2;
//		gbc.weightx = 0.5;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		add (f_name, gbc);
		//
		f_location = new CComboBox();
		f_location.setPreferredSize(new Dimension(100, 20));
		f_location.addKeyListener(this);
		gbc.gridx = 2;
		gbc.gridy = 1;
		gbc.weightx = 0;
		gbc.gridwidth = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.NONE;
		add (f_location, gbc);
		//
		f_user = new CComboBox();
		f_user.setPreferredSize(new Dimension(100, 20));
		f_user.addKeyListener(this);
		gbc.gridx = 3;
		gbc.gridy = 1;
		gbc.weightx = 1;
		gbc.gridwidth = 1;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.fill = GridBagConstraints.NONE;
		add (f_user, gbc);
		//
		f_bSearch = createButtonAction ("BPartner", KeyStroke.getKeyStroke(KeyEvent.VK_I, Event.SHIFT_MASK+Event.CTRL_MASK));
		f_bSearch.addKeyListener(this);
//		f_bSearch.addMouseListener(this);
		gbc.gridx = 4;
		gbc.gridy = 0;
		gbc.gridheight = 2;
		gbc.fill = GridBagConstraints.NONE;
		add (f_bSearch, gbc);
		
		
	}	//	init

	/**
	 * 	Dispose - Free Resources
	 */
	public void dispose()
	{
		if (f_name != null)
			f_name.removeFocusListener(this);
		f_name = null;
		removeAll();
		super.dispose();
	}	//	dispose

	/**************************************************************************
	 * 	Action Listener
	 *	@param e event
	 */
	public void actionPerformed (ActionEvent e)
	{
		String action = e.getActionCommand();
		if (action == null || action.length() == 0)
			return;
		log.info( "p_QuickSubCustomer - actionPerformed: " + action);
		//	New
		if (action.equals("New")){
			
			actionBPartner(true);
			if (m_C_BPartner_ID > 0)
			{
				setC_BPartner_ID(m_C_BPartner_ID);
			}
			else
			{
				setC_BPartner_ID(0);
			}
			return;
		}
		//	Edit
		else if (action.equals("Edit"))
		{
//			f_bEdit.setReadWrite(true);
			actionBPartner(false);
			return;
		}
		//	BPartner
		else if (action.equals("BPartner"))
		{
			p_QuickRegisterPanel.openQuery(f_queryBPartner);
			if(!f_name.getValue().equals(""))
//				(f_name.getValue());
			 	m_constantValue = f_name.getValue().toString();
			f_queryBPartner.f_name.setValue("");
			f_queryBPartner.f_value.setValue("");
			boolean  m_constantIsString = false;
			for (int i = 0; i < m_constantValue.length(); i++)
			{
				char c = m_constantValue.charAt(i);
				if (!(Character.isDigit(c) || c == '.'))	//	if a constant number, it must be with . (not ,)
				{
					m_constantIsString = true;
					
					f_queryBPartner.f_name.setValue(f_name.getValue());
					f_queryBPartner.f_name.requestFocus();
//					break;
				}
			}
				 if(!m_constantIsString){
					 f_queryBPartner.f_value.setValue(f_name.getValue());
						f_queryBPartner.f_value.requestFocus();
						
				}
				p_QuickRegisterPanel.f_product.setVisible(false);
				p_QuickRegisterPanel.f_currentLine.setVisible(false);
		}
		else if(e.getSource() == f_location){
			f_user.requestFocus();
		}
		else if(e.getSource() == f_user){
			p_QuickRegisterPanel.f_product.f_name.requestFocus();
		}
		//	Name
//		else if (e.getSource() == f_name)
//			findBPartner();
//			setOrderValue();
	}	//	actionPerformed
	/**
	 *	Set ReadWrite
	 *  @param value ReadWrite
	 */
	public void setReadWrite (boolean value)
	{
		boolean rw = value;
		if (m_lookup == null)
			rw = false;
		if (m_combo.isReadWrite() != value)
		{
			m_combo.setReadWrite(rw);
			setUI (false);
			if (m_comboActive)
				setValue (m_value);
		}
	}	//	setReadWrite
	/**
	 *  Set Content and Size of Components
	 *  @param initial if true, size and margins will be set
	 */
	private void setUI (boolean initial)
	{
		if (initial)
		{
			Dimension size = m_text.getPreferredSize();
			setPreferredSize(new Dimension(size));  //	causes r/o to be the same length
			m_combo.setPreferredSize(new Dimension(size));
			setMinimumSize(new Dimension (30, size.height));
			FIELD_HIGHT = size.height;
			//
			Dimension bSize = new Dimension(size.height, size.height);
			m_button.setPreferredSize (bSize);
		}

		//	What to show
		this.remove(m_combo);
		this.remove(m_button);
		this.remove(m_text);
		//
		if (!isReadWrite())			//	r/o - show text only
		{
			LookAndFeel.installBorder(this, "TextField.border");
			this.add(m_text, BorderLayout.CENTER);
			m_text.setReadWrite(false);
			m_combo.setReadWrite(false);
			m_comboActive = false;
		}
	    //	show combo if not Search
		else if (m_lookup != null && m_lookup.getDisplayType() != DisplayType.Search)
		{
			this.add(m_combo, BorderLayout.CENTER);
			m_comboActive = true;
		}
		else 						//	Search or unstable - show text & button
		{
			LookAndFeel.installBorder(this, "TextField.border");
//			this.add(m_text, BorderLayout.CENTER);
//			this.add(m_button, BorderLayout.EAST);
			m_text.setReadWrite (true);
			m_comboActive = false;
		}

		this.setBorder(null);
	}   //  setUI
	/**
	 *	Is it possible to edit
	 *  @return true, if editable
	 */
	public boolean isReadWrite()
	{
		return isEnabled();
	}   //  isReadWrite

	/**
	 *	Action - Special BPartner Screen
	 *  @param newRecord true if new record should be created
	 */
	private void actionBPartner (boolean newRecord)
	{
		VBPartner vbp = new VBPartner (Env.getFrame(this), m_WindowNo);
		int BPartner_ID = 0;
		//  if update, get current value
		if (!newRecord)
		{
				
				BPartner_ID = m_C_BPartner_ID;
		}

		vbp.loadBPartner (BPartner_ID);
		vbp.setVisible(true);
		//  get result
		int result = vbp.getC_BPartner_ID();
		if (result == 0					//	0 = not saved
			&& result == BPartner_ID)	//	the same
			return;
		m_C_BPartner_ID = result;

		actionCombo (new Integer(result));      //  data binding
	}	//	actionBPartner
	/**
	 *	Action - Combo.
	 *  <br>
	 *	== dataBinding == inform of new value
	 *  <pre>
	 *  VLookup.actionCombo
	 *      GridController.vetoableChange
	 *          GridTable.setValueAt
	 *              GridField.setValue
	 *                  VLookup.setValue
	 *          GridTab.dataStatusChanged
	 *  </pre>
	 *  @param value new value
	 */
	private void actionCombo (Object value)
	{
		log.fine("Value=" + value);
		try
		{
			// -> GridController.vetoableChange
			fireVetoableChange (m_columnName, null, value);
		}
		catch (PropertyVetoException pve)
		{
			log.log(Level.SEVERE, m_columnName, pve);
		}
		//  is the value updated ?
		boolean updated = false;
		if (value == null && m_value == null)
			updated = true;
		else if (value != null && value.equals(m_value))
			updated = true;
		if (!updated)
		{
			//  happens if VLookup is used outside of APanel/GridController (no property listener)
			log.fine(m_columnName + " - Value explicitly set - new=" + value + ", old=" + m_value);
			setValue(value);
		}
	}	//	actionCombo
	/**
	 *  Set Editor to value
	 *  @param value new Value
	 */
	public void setValue (Object value)
	{
		log.fine(m_columnName + "=" + value);
		m_settingValue = true;		//	disable actions
		m_value = value;

		//	Set both for switching
		m_combo.setValue (value);
		if (value == null)
		{
			m_text.setText (null);
			m_lastDisplay = "";
			m_settingValue = false;
			return;
		}
		if (m_lastDisplay.equals("<-1>"))
		{
			m_lastDisplay = "";
			m_value = null;
		}
		boolean notFound = m_lastDisplay.startsWith("<") && m_lastDisplay.endsWith(">");
		m_text.setText (m_lastDisplay);
		m_text.setCaretPosition (0); //	show beginning

		//	Nothing showing in Combo and should be showing
		if (m_combo.getSelectedItem() == null
				&& (m_comboActive || m_inserting ))
		{
			//  lookup found nothing too
			if (notFound)
			{
				log.finest(m_columnName + "=" + value + ": Not found - " + m_lastDisplay);
				m_combo.setValue (value);
				m_text.setText (m_lastDisplay);
				m_text.setCaretPosition (0);	//	show beginning
				notFound = m_lastDisplay.startsWith("<") && m_lastDisplay.endsWith(">");
			}
			if (notFound)	//	<key>
			{
				m_value = null;
				actionCombo (null);             //  data binding
				log.fine(m_columnName + "=" + value + ": Not found");
			}
			//  we have lookup
			else if (m_combo.getSelectedItem() == null)
			{
			}
			if (m_combo.getSelectedItem() == null)
			{
				log.info(m_columnName + "=" + value + ": not in Lookup - set to NULL");
				actionCombo (null);             //  data binding (calls setValue again)
				m_value = null;
			}
		}
		m_settingValue = false;
	}	//	setValue

	
	
	public void setOrderValue ( )
	{
		MOrder order = p_QuickRegisterPanel.f_currentLine.getOrder();
		
			p_QuickRegisterPanel.f_orderline.getF_orderNo().setValue(order.getDocumentNo());
			p_QuickRegisterPanel.f_orderline.getFBPartner().setValue(order.getPOReference());
			p_QuickRegisterPanel.f_orderline.f_descreption.setValue(order.getDescription());
			p_QuickRegisterPanel.f_lines.f_docStatus.setValue(order.getDocStatusName());
			p_QuickRegisterPanel.f_orderline.f_descreption.setEnabled(true);
			p_QuickRegisterPanel.f_product.f_bSearch.setEnabled(true);
			p_QuickRegisterPanel.f_product.f_name.setEnabled(true);
//			p_QuickRegisterPanel.f_currentLine.f_new.setEnabled(true);
			p_QuickRegisterPanel.f_currentLine.f_quantity.setEnabled(true);
			if (order.getAD_Org_ID() != 0)
				m_AD_Org_ID = order.getAD_Org_ID();
			if (order.getC_BPartner_ID() != 0)
			{
				m_C_BPartner_ID = order.getC_BPartner_ID();
//				fBPartner.setValue(m_C_BPartner_ID);	//	display value
			}
			if (order.getC_Order_ID()!=0)
			{
				m_C_Order_ID = order.getC_Order_ID();
			}
			
			executeQuery();
			
	}	//	focusGained
	/**
	 *  Query Info
	 */
	private void executeQuery()
	{
		log.info("");
		int AD_Client_ID = Env.getCtx().getAD_Client_ID();
		//  Create SQL
		StringBuffer sql = new StringBuffer(
			"SELECT C_Order_ID, o.Name, dt.C_DocType_ID, DocumentNo, bp.Name "
			+ "FROM C_ORDER ic, AD_Org o, C_BPartner bp, C_DocType dt "
			+ "WHERE ic.AD_Org_ID=o.AD_Org_ID"
			+ " AND ic.C_BPartner_ID=bp.C_BPartner_ID"
			+ " AND ic.C_DOCTYPETARGET_ID=dt.C_DocType_ID"
			+ " AND ic.AD_Client_ID=?"
			);
		
		if (m_C_BPartner_ID > 0)
			sql.append(" AND ic.C_BPartner_ID=").append(m_C_BPartner_ID);
		if (m_C_Order_ID != null)
			sql.append(" AND C_Order_ID=").append(m_C_Order_ID);
		
		sql.append(" ORDER BY o.Name,bp.Name,DateOrdered");
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
			pstmt.setInt(1, AD_Client_ID);
			ResultSet rs = pstmt.executeQuery();
			//
			while (rs.next())
			{
				p_QuickRegisterPanel.f_orderline.getF_docmentType().setValue(rs.getString(3)); 	//  DocType
				
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql.toString(), e);
		}
	}
	/**
	 * 	Focus Gained
	 *	@param e
	 */
	public void focusGained (FocusEvent e)
	{
		p_QuickRegisterPanel.f_lines.f_bEdit.setEnabled(false);
		p_QuickRegisterPanel.f_quickRegisterMenu.aNew.setEnabled(false);
		p_QuickRegisterPanel.f_quickRegisterMenu.aSave.setEnabled(true);
		p_QuickRegisterPanel.f_currentLine.f_new.setEnabled(false);
		f_bNew.setEnabled(true);
		f_bEdit.setEnabled(true);
		if (e.isTemporary() )
			return;
		if (e.getComponent() == m_combo || !SwingUtilities.isDescendingFrom(e.getComponent(), m_combo))
			return;
		if (m_lookup.isValidated() && !m_lookup.hasInactive())
			return;
	    
		//  prevents actionPerformed
		m_settingFocus = true;

		Object obj = m_lookup.getSelectedItem();
		log.config(m_columnName 
			+ " - Start    Count=" + m_combo.getItemCount() + ", Selected=" + obj);

		m_lookup.fillComboBox(isMandatory(), true, true, true);     //  only validated & active & temporary
		log.fine(m_columnName 
			+ " - Update   Count=" + m_combo.getItemCount() + ", Selected=" + m_lookup.getSelectedItem());
		m_lookup.setSelectedItem(obj);
		obj = m_lookup.getSelectedItem();
		log.fine(m_columnName 
			+ " - Selected Count=" + m_combo.getItemCount() + ", Selected=" + obj);
		m_settingFocus = false;
	}	//	focusGained
	/**
	 *	Is it mandatory
	 *  @return true if mandatory
	 */
	public boolean isMandatory()
	{
		return m_combo.isMandatory();
	}	//	isMandatory

	/**
	 * 	Focus Lost
	 *	@param e
	 */
	public void focusLost (FocusEvent e)
	{
		if (e.isTemporary())
			return;
		
		if (e.isTemporary() 
				|| m_lookup == null 
				|| !m_button.isEnabled() )	//	set by actionButton
				return;
			//	Text Lost focus
			if (e.getSource() == m_text)
			{
				String text = m_text.getText();
				log.config(m_columnName + " (Text) " + m_columnName + " = " + m_value + " - " + text);
				//	Skip if empty
				if ((m_value == null 
					&& m_text.getText().length() == 0))
					return;
				if (m_lastDisplay.equals(text))
					return;
				//
//				actionText();	//	re-display
				return;
			}
			//	Combo lost focus
			Object src = e.getSource();
			if (!(src == m_combo || src == m_combo.getEditor().getEditorComponent()))
				return;
			if (m_lookup.isValidated() && !m_lookup.hasInactive())
				return;
			//
			m_settingFocus = true;  //  prevents actionPerformed
			//
			log.config(m_columnName + " = " + m_combo.getSelectedItem());
			Object obj = m_combo.getSelectedItem();
			//	set original model
			if (!m_lookup.isValidated())
				m_lookup.fillComboBox(true);    //  previous selection
			//	Set value
			if (obj != null)
			{
				m_combo.setSelectedItem(obj);
				//	original model may not have item
				if (!m_combo.getSelectedItem().equals(obj))
				{
					log.fine(m_columnName + " - added to combo - " + obj);
					m_combo.addItem(obj);
					m_combo.setSelectedItem(obj);
				}
			}
			actionCombo(getValue());	// should not be required if movements do not fire value
			m_settingFocus = false;
		log.info(e.toString());
	}	//	focusLost
	/**
	 *	Return Editor value (Integer)
	 *  @return value
	 */
	public Object getValue()
	{
		if (m_comboActive)
			return m_combo.getValue ();
		return m_value;
	}	//	getValue


	

	


	


	/**
	 * 	Find/Set BPartner
	 */
	private void findBPartner()
	{
		String query = f_name.getText();
		if (query == null || query.length() == 0)
			return;
		query = query.toUpperCase();
		//	Test Number
		boolean allNumber = true;
		boolean noNumber = true;
		char[] qq = query.toCharArray();
		for (int i = 0; i < qq.length; i++)
		{
			if (Character.isDigit(qq[i]))
			{
				noNumber = false;
				break;
			}
		}
		try
		{
			Integer.parseInt(query);
		}
		catch (Exception e)
		{
			allNumber = false;
		}
		String Value = query;
		String Name = (allNumber ? null : query);
		String Contact = (allNumber ? null : query);
		String EMail = (query.indexOf("@") != -1 ? query : null); 
		String Phone = (noNumber ? null : query);
		String City = null;
		//
		MBPartnerInfo[] results = MBPartnerInfo.find(p_ctx, Value, Name, 
			Contact, EMail, Phone, City);
		
		//	Set Result
		if (results.length == 0)
		{
			setC_BPartner_ID(0);
		}
		else if (results.length == 1)
		{
			setC_BPartner_ID(results[0].getC_BPartner_ID());
			f_name.setText(results[0].getName());
			p_QuickRegisterPanel.f_product.f_name.requestFocus();
		}
		else	//	more than one
		{
			f_queryBPartner.setResults (results);
			p_QuickRegisterPanel.openQuery(f_queryBPartner);
			p_QuickRegisterPanel.f_product.setVisible(false);
			p_QuickRegisterPanel.f_currentLine.setVisible(false);
			if(!f_name.getValue().equals(""))
				f_queryBPartner.f_value.setValue(f_name.getValue());
			f_queryBPartner.f_value.requestFocus();
			
		}
	}	//	findBPartner


	/**************************************************************************
	 * 	Set BPartner
	 *	@param C_BPartner_ID id
	 */
	public void setC_BPartner_ID (int C_BPartner_ID)
	{
		log.fine( "PosSubCustomer.setC_BPartner_ID=" + C_BPartner_ID);
		if (C_BPartner_ID == 0)
			m_bpartner = null;
		else
		{
			m_bpartner = new MBPartner(p_ctx, C_BPartner_ID, null);
			if (m_bpartner.get_ID() == 0)
				m_bpartner = null;
		}

		//	Set Info
		if (m_bpartner != null)
		{
			f_name.setText(m_bpartner.getName());
			f_bEdit.setReadWrite(true);
		}
		else
		{
			f_name.setText(null);
			f_bEdit.setReadWrite(false);
		}
		//	Sets Currency
		m_M_PriceList_Version_ID = 0;
		getM_PriceList_Version_ID();
		fillCombos();
		p_QuickRegisterPanel.f_currentLine.setBPartner(); 
	}	//	setC_BPartner_ID

	/**
	 * 	Fill Combos (Location, User)
	 */
	private void fillCombos()
	{
		Vector<KeyNamePair> locationVector = new Vector<KeyNamePair>();
		if (m_bpartner != null)
		{
			MBPartnerLocation[] locations = m_bpartner.getLocations(false);
			for (int i = 0; i < locations.length; i++)
				locationVector.add(locations[i].getKeyNamePair());
		}
		DefaultComboBoxModel locationModel = new DefaultComboBoxModel(locationVector); 
		f_location.setModel(locationModel);
		//
		Vector<KeyNamePair> userVector = new Vector<KeyNamePair>();
		if (m_bpartner != null)
		{
			MUser[] users = m_bpartner.getContacts(false);
			for (int i = 0; i < users.length; i++)
				userVector.add(users[i].getKeyNamePair());
		}
		DefaultComboBoxModel userModel = new DefaultComboBoxModel(userVector); 
		f_user.setModel(userModel);
	}	//	fillCombos

	/**
	 * 	Get BPartner
	 *	@return C_BPartner_ID
	 */
	public int getC_BPartner_ID ()
	{
		if (m_bpartner != null)
			return m_bpartner.getC_BPartner_ID();
		return 0;
	}	//	getC_BPartner_ID

	/**
	 * 	Get BPartner
	 *	@return BPartner
	 */
	public MBPartner getBPartner ()
	{
		return m_bpartner;
	}	//	getBPartner
	
	/**
	 * 	Get BPartner Location
	 *	@return C_BPartner_Location_ID
	 */
	public int getC_BPartner_Location_ID ()
	{
		if (m_bpartner != null)
		{
			KeyNamePair pp = (KeyNamePair)f_location.getSelectedItem();
			if (pp != null)
				return pp.getKey();
		}
		return 0;
	}	//	getC_BPartner_Location_ID
	
	/**
	 * 	Get BPartner Contact
	 *	@return AD_User_ID
	 */
	public int getAD_User_ID ()
	{
		if (m_bpartner != null)
		{
			KeyNamePair pp = (KeyNamePair)f_user.getSelectedItem();
			if (pp != null)
				return pp.getKey();
		}
		return 0;
	}	//	getC_BPartner_Location_ID

	/**
	 * 	Get M_PriceList_Version_ID.
	 * 	Set Currency
	 *	@return plv
	 */
	public int getM_PriceList_Version_ID()
	{
		if (m_M_PriceList_Version_ID == 0)
		{
			int M_PriceList_ID = p_QuickRegister.getM_PriceList_ID();
			if (m_bpartner != null && m_bpartner.getM_PriceList_ID() != 0)
				M_PriceList_ID = m_bpartner.getM_PriceList_ID();
			MPriceList pl = MPriceList.get(p_ctx, M_PriceList_ID, null);
			p_QuickRegisterPanel.f_currentLine.setCurrency(MCurrency.getISO_Code(p_ctx, pl.getC_Currency_ID()));
			p_QuickRegisterPanel.setCurrencyPrecision(MCurrency.getStdPrecision(p_ctx, pl.getC_Currency_ID()));
			f_name.setToolTipText(pl.getName());
			//
			MPriceListVersion plv = pl.getPriceListVersion (p_QuickRegisterPanel.getToday());
			if (plv != null && plv.getM_PriceList_Version_ID() != 0)
				m_M_PriceList_Version_ID = plv.getM_PriceList_Version_ID();
		}
		return m_M_PriceList_Version_ID;
	}	//	getM_PriceList_Version_ID
	public void keyPressed(KeyEvent e) {
	}
	public void keyReleased(KeyEvent e) {
		if((e.getSource() == f_name)&&(e.getKeyCode() == KeyEvent.VK_ENTER)){
			p_QuickRegisterPanel.openQuery(f_queryBPartner);
			if(!f_name.getValue().equals(""))
			 	m_constantValue = f_name.getValue().toString();
			f_queryBPartner.f_name.setValue("");
			f_queryBPartner.f_value.setValue("");
			boolean  m_constantIsString = false;
			for (int i = 0; i < m_constantValue.length(); i++)
			{
				char c = m_constantValue.charAt(i);
				if (!(Character.isDigit(c) || c == '.'))	//	if a constant number, it must be with . (not ,)
				{
					m_constantIsString = true;
					
					f_queryBPartner.f_name.setValue(f_name.getValue());
					f_queryBPartner.f_name.requestFocus();
//					break;
				}
			}
				 if(!m_constantIsString){
					 f_queryBPartner.f_value.setValue(f_name.getValue());
						f_queryBPartner.f_value.requestFocus();
						
				}
				p_QuickRegisterPanel.f_product.setVisible(false);
				p_QuickRegisterPanel.f_currentLine.setVisible(false);
			
		}else if((e.getSource() == f_bSearch)&&(e.getKeyCode() == KeyEvent.VK_ENTER)){
			findBPartner();
			p_QuickRegisterPanel.openQuery(f_queryBPartner);
			f_queryBPartner.f_value.requestFocus();
			if(!f_name.getValue().equals(""))
				f_queryBPartner.f_value.setValue(f_name.getValue());
			p_QuickRegisterPanel.f_product.setVisible(false);
			p_QuickRegisterPanel.f_currentLine.setVisible(false);
		}
		else if((e.getSource()== f_bNew)&&(e.getKeyCode() == KeyEvent.VK_ENTER)){
//			
			actionBPartner(true);
			if (m_C_BPartner_ID > 0)
			{
				setC_BPartner_ID(m_C_BPartner_ID);
			}
			else
			{
				setC_BPartner_ID(0);
			}
			return;
		}else if((e.getSource()== f_bEdit)&&(e.getKeyCode() == KeyEvent.VK_ENTER)){
			actionBPartner(false);
			return;
		}
		else if((e.getKeyCode() == KeyEvent.VK_DOWN)&&(e.getSource()==f_bNew)){
			p_QuickRegisterPanel.f_bpartner.f_bNew.setEnabled(false);
			p_QuickRegisterPanel.f_bpartner.f_bEdit.setEnabled(false);
			p_QuickRegisterPanel.f_lines.f_bEdit.setEnabled(true);
			p_QuickRegisterPanel.f_quickRegisterMenu.aNew.setEnabled(true);
			p_QuickRegisterPanel.f_quickRegisterMenu.aSave.setEnabled(false);
			p_QuickRegisterPanel.f_currentLine.f_new.setEnabled(true);
			p_QuickRegisterPanel.f_product.f_bSearch.requestFocus();
			return;
		}else if((e.getKeyCode() == KeyEvent.VK_RIGHT)&&(e.getSource()==f_bNew)){
			f_bEdit.requestFocus();
			return;
		}
		else if((e.getKeyCode() == KeyEvent.VK_LEFT)&&(e.getSource()==f_bEdit)){
			f_bNew.requestFocus();
			return;
		}
		else if((e.getKeyCode() == KeyEvent.VK_RIGHT)&&(e.getSource()==f_bEdit)){
			f_name.requestFocus();
			return;
		}
		else if((e.getKeyCode() == KeyEvent.VK_LEFT)&&(e.getSource()==f_name)){
			f_bEdit.requestFocus();
			return;
		}
		else if((e.getKeyCode() == KeyEvent.VK_RIGHT)&&(e.getSource()==f_name)){
			f_bSearch.requestFocus();
			return;
		}
		else if((e.getKeyCode() == KeyEvent.VK_LEFT)&&(e.getSource()==f_bSearch)){
			f_name.requestFocus();
			return;
		}
		else if((e.getKeyCode() == KeyEvent.VK_RIGHT)&&(e.getSource()==f_bSearch)){
			p_QuickRegisterPanel.f_orderline.f_descreption.requestFocus();
			p_QuickRegisterPanel.f_bpartner.f_bNew.setEnabled(false);
			p_QuickRegisterPanel.f_bpartner.f_bEdit.setEnabled(false);
			p_QuickRegisterPanel.f_quickRegisterMenu.aNew.setEnabled(true);
			return;
		}
		else if((e.getKeyCode() == KeyEvent.VK_DOWN)&&(e.getSource()==f_name)){
			f_location.requestFocus();
			return;
		}
		else if((e.getKeyCode() == KeyEvent.VK_UP)&&(e.getSource()==f_location)){
			f_name.requestFocus();
			return;
		}
		else if((e.getKeyCode() == KeyEvent.VK_RIGHT)&&(e.getSource()==f_location)){
			f_user.requestFocus();
			return;
		}
		String str = "0";
		if(e.getSource() == f_name){
		if(str.equals("1")){
			if(e.getKeyCode() == KeyEvent.VK_F2){
				actionBPartner(true);
				if (m_C_BPartner_ID > 0)
				{
					setC_BPartner_ID(m_C_BPartner_ID);
				}
				else
				{
					setC_BPartner_ID(0);
				}
				return;
			}
		}
		}
	}

	public void keyTyped(KeyEvent e) {
	}
	
}	//	p_QuickSubCustomer
