/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.quickregister;

import java.awt.Dimension;
import java.awt.Event;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;

import org.compiere.apps.ADialog;
import org.compiere.grid.ed.VNumber;
import org.compiere.grid.ed.VPAttribute;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrderTax;
import org.compiere.model.MProduct;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;

/**
 * QuickRegister Current Line Sub Panel
 * 
 * @author Horcha
 * @version $Id: SubCurrentLine.java,v 1.3 2010/01/10 07:50:33 jrmt Exp $
 */
public class SubCurrentLine extends QuickRegisterSubPanel implements
		ActionListener, FocusListener,KeyListener,DataStatusListener {
	/**
	 * Constructor
	 * 
	 * @param quickRegisterPanel
	 *            QuickRegister Panel
	 */
	public SubCurrentLine(QuickRegisterPanel quickRegisterPanel) {
		super(quickRegisterPanel);
	} // QuickPanelSubCurrentLine

	protected CButton f_new;
	protected CButton f_reset;
	private CLabel f_currency;
	private CLabel firstSpace;
	private CLabel secondSpase;
	private CLabel thirdSpase;
	private CLabel f_line;
	private CLabel f_line_total;
	protected CTextField f_lineText;
	protected VNumber f_price;
	protected CTextField f_linetotal;
	private CLabel f_uom;
	protected VNumber f_quantity;
	private int selectRow = 0;
	protected MOrder m_order = null;
	 /** Product Query Window        */
    protected SubLines      f_lines = new SubLines (p_QuickRegisterPanel);
    protected int count = 1;
    private VPAttribute attrib = null;
	/** Logger */
	private static CLogger log = CLogger.getCLogger(SubCurrentLine.class);

	/**
	 * Initialize
	 */
	public void init() {
		// Title
		TitledBorder border = new TitledBorder(Msg.getMsg(Env.getCtx(),
				"CurrentLine"));
		setBorder(border);
		// Content
		setLayout(new GridBagLayout());
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.insets = INSETS2;
		gbc.gridy = 0;
		
		// QtyOrder
		f_line =new CLabel(Msg.translate(Env.getCtx(), "Line"), "");
		gbc.anchor = GridBagConstraints.EAST;
		gbc.weightx = .1; // 
		gbc.gridx = 1;
		gbc.gridy = 0;	
		gbc.anchor = GridBagConstraints.WEST;
		gbc.gridx = GridBagConstraints.RELATIVE;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		add(f_line, gbc);
		
		f_lineText= new  CTextField(" ");
		f_lineText.setHorizontalAlignment(CTextField.RIGHT);
		f_lineText.setEditable(false);
		gbc.gridx = 2;
		gbc.gridy = 0;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.gridx = GridBagConstraints.RELATIVE;
		gbc.weightx = 0;
		f_lineText.setPreferredSize(new Dimension(40, 20));
		add(f_lineText, gbc);
		
		firstSpace = new CLabel("");
		gbc.weightx = .05;
		gbc.gridx = 3;
		gbc.gridy = 0;
		add(firstSpace, gbc);
		
		
		
		// --
		f_quantity = new VNumber("QtyOrdered", false, false, true,
				DisplayType.Quantity, Msg.translate(Env.getCtx(), "QtyOrdered"));
		f_quantity.addActionListener(this);
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 0;
		f_quantity.setColumns(5, 25);
		gbc.gridx = 4;
		gbc.gridy = 0;
		f_quantity.setPreferredSize(new Dimension(70, 20));
		add(f_quantity, gbc);
		
		f_uom = new CLabel("  --");
		gbc.anchor = GridBagConstraints.EAST;
		gbc.weightx = 0;
		gbc.gridx = 5;
		gbc.gridy = 0;
		add(f_uom, gbc);
		
		
		
		secondSpase = new CLabel(" ");
		gbc.weightx = .05;
		gbc.gridx = 6;
		gbc.gridy = 0;
		add(secondSpase, gbc);
		
		f_price = new VNumber("PriceActual", false, false, true,
				DisplayType.Amount, Msg.translate(Env.getCtx(), "PriceActual"));
		f_price.setColumns(5, 25);
		f_price.setPreferredSize(new Dimension(70, 20));
		f_price.addActionListener(this);
		f_price.addFocusListener(this);
		gbc.gridx = 7;
		gbc.gridy = 0;
		gbc.weightx = 0;
		gbc.anchor = GridBagConstraints.WEST ;
		add(f_price, gbc);
		setPrice(Env.ZERO);
		
		f_currency = new CLabel("---");
		gbc.anchor = GridBagConstraints.EAST;
		gbc.weightx = 0;
		gbc.gridx = 8;
		gbc.gridy = 0;
		add(f_currency, gbc);
		
		
		thirdSpase = new CLabel("  ");
		gbc.anchor = GridBagConstraints.EAST;
		gbc.weightx = 0;
		gbc.gridx = 9;
		gbc.gridy = 0;
		add(thirdSpase, gbc);
		// --
		f_line_total =new CLabel(Msg.translate(Env.getCtx(), "LineNetAmt"), "");
		f_line_total.setHorizontalAlignment(CTextField.RIGHT);
		gbc.anchor = GridBagConstraints.EAST;
		gbc.gridx = GridBagConstraints.RELATIVE;
		gbc.weightx = 0;
		gbc.gridx = 10;
		add(f_line_total, gbc);
		
		f_linetotal= new  CTextField("");
		f_linetotal.setHorizontalAlignment(CTextField.RIGHT);
		f_linetotal.setEditable(false);
		f_linetotal.setPreferredSize(new Dimension(60, 20));
		f_linetotal.setValue("0.00");
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = .1;
		gbc.gridx = 11;
		gbc.fill = GridBagConstraints.NONE;
		add(f_linetotal, gbc);
		
		// --New
		f_new = createButtonAction("Save", KeyStroke.getKeyStroke(
				KeyEvent.VK_INSERT, Event.SHIFT_MASK));
		f_new.addKeyListener(this);
		f_new.setActionCommand("Enter");
		// gbc.gridx = 0;
		gbc.weightx = .1;
		gbc.gridx = 12;
		add(f_new, gbc);
		
	} // init

	/**
	 * Get Panel Position
	 */
	public GridBagConstraints getGridBagConstraints() {
		GridBagConstraints gbc = super.getGridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 1;
		return gbc;
	} // getGridBagConstraints

	/**
	 * Dispose - Free Resources
	 */
	public void dispose() {
		super.dispose();
	} // dispose
	/**
	 * 	Set M_AttributeSetInstance_ID
	 *	@param M_AttributeSetInstance_ID id
	 */
	public void setM_AttributeSetInstance_ID (int M_AttributeSetInstance_ID,int M_Product_ID)
	{
			int  M_ProductBOM_ID =  Env.getCtx().getContextAsInt("M_ProductBOM_ID");		
			
			Map<String ,String> map = new HashMap<String ,String>();
			map.put("M_AttributeSetInstance_ID", String.valueOf(M_AttributeSetInstance_ID));
			map.put("M_Product_ID", String.valueOf(M_Product_ID));
			map.put("M_ProductBOM_ID", String.valueOf(M_ProductBOM_ID));
			Env.getCtx().setContext(10, map);
	}

	/**
	 * Action Listener
	 * 
	 * @param e
	 *            event
	 */
	public void actionPerformed(ActionEvent e) {
		
		String action = e.getActionCommand();
		if (action == null || action.length() == 0)
			return;
		log.info("SubCurrentLine - actionPerformed: " + action);
		if (action.equals("New")){
		}
		else if (action.equals("Reset")){
			newLine();
		
		} else if ((e.getSource() == f_quantity)) {
			
			if (f_price.isReadWrite()) {
				f_price.requestFocus();
			} else {
				f_new.requestFocus();
			}
			return;
		}
		else if ((e.getSource() == f_price)) {
			f_new.requestFocus();
			return;
		}
		else if(e.getSource() == f_new) {
			
			int check = p_QuickRegisterPanel.f_product.newLinecheckProduct();
			if(check==1){
//				qtyFocus();
//				p_QuickRegisterPanel.f_lines.getM_table().requestFocus();
//				return;
			}else if(check==0){
				p_QuickRegisterPanel.f_product.f_name.requestFocus();
				return;
			}else if (check>1)
			{
				p_QuickRegisterPanel.f_product.newLinefindProduct();
				p_QuickRegisterPanel.f_product.f_queryProduct.f_value.requestFocus();
				p_QuickRegisterPanel.f_product.f_queryProduct.f_value.setValue(p_QuickRegisterPanel.f_product.f_name.getValue());
				return;
			}
			
			p_QuickRegisterPanel.f_lines.setVisible(true);
			p_QuickRegisterPanel.closeQuery();
			p_QuickRegisterPanel.m_southPanel.setVisible(true);
			p_QuickRegisterPanel.f_lines.getM_table().setVisible(true);
			p_QuickRegisterPanel.f_orderlines.setVisible(false);
			//new orderline
			if(p_QuickRegisterPanel.f_lines.checkEdit.equals("1")){
				boolean retValue = saveLine();
				if ( !retValue )
				{
					ADialog.error(p_QuickRegisterPanel.m_WindowNo, this, "SaveIgnored");
					p_QuickRegisterPanel.f_status.setStatusLine(Msg.getMsg(p_QuickRegisterPanel.m_ctx, "SaveIgnored"), true);
				}
				
//				p_QuickRegisterPanel.updateInfo();
				int rows = p_QuickRegisterPanel.f_lines.getM_table().getRowCount();
				if ( retValue ){
					p_QuickRegisterPanel.f_status.setStatusLine(Msg.getMsg(Env.getCtx(), "Records")+ "=" + rows);
				}
				
				if (rows == 0)
					return;
				int row = getSelectRow();
				
				p_QuickRegisterPanel.f_lines.getM_table().getSelectionModel()
						.setSelectionInterval(row, row);
				showCell(row, 0);
				setStatusValue();
				p_QuickRegisterPanel.f_product.f_name.requestFocus();
//				setSelectRow(0);
				p_QuickRegisterPanel.f_lines.checkEdit = "0";
				clearAttribute();
//				return;
			}
			//old orderline edit
			else if(p_QuickRegisterPanel.f_lines.checkEdit.equals("0")){
				boolean retValue = saveNewLine();
				//   if there is no previous error
				if ( !retValue )
				{
					ADialog.error(p_QuickRegisterPanel.m_WindowNo, this, "SaveIgnored");
					p_QuickRegisterPanel.f_status.setStatusLine(Msg.getMsg(p_QuickRegisterPanel.m_ctx, "SaveIgnored"), true);
				}
			
				p_QuickRegisterPanel.updateInfo();
				int rows = p_QuickRegisterPanel.f_lines.getM_table().getRowCount();
				//info
				if ( retValue ){
				p_QuickRegisterPanel.f_status.setStatusLine(Msg.getMsg(Env.getCtx(), "Records")+ "=" + rows);//Records
				}
			
				if (rows == 0)
					return;
//				int row = getSelectRow();
				rows--;
				p_QuickRegisterPanel.f_lines.getM_table().getSelectionModel()
						.setSelectionInterval(rows, rows);
				showCell(rows, 0);
				setStatusValue();
				p_QuickRegisterPanel.f_product.f_name.requestFocus();
				setSelectRow(0);
				clearAttribute();
//				return;
			}
			f_lineText.setValue("");
			f_linetotal.setValue("");
			f_price.setValue(Env.ZERO);
			f_quantity.setValue(Env.ONE);
			return;
		}
		
	} // actionPerformed
	
	/**************************************************************************
	 * Set clear attribute
	 * 
	 * @param 
	 *            
	 */
	public void clearAttribute( ) {
		if(p_QuickRegisterPanel.f_product.getComponent(2).getComponentAt(0, 0) instanceof  JTextField){
			JTextField text = (JTextField)p_QuickRegisterPanel.f_product.getComponent(2).getComponentAt(0, 0);
			text.setText("");
			}
		VPAttribute attri = (VPAttribute)p_QuickRegisterPanel.f_product.getComponent(2);
		Integer oldValue = (Integer)attri.getValue();
		if((oldValue != null)&& (oldValue > 0)){
//			int M_AttributeSetInstance_ID = oldValue;	
			try {
				attri.setValue(0);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	} // setCurrency

	/**************************************************************************
	 * Set Currency
	 * 
	 * @param currency
	 *            currency
	 */
	public void setCurrency(String currency) {
		if (currency == null)
			f_currency.setText("---");
		else
			f_currency.setText(currency);
	} // setCurrency

	/**
	 * Set UOM
	 * 
	 * @param UOM
	 *            UOM
	 */
	public void setUOM(String UOM) {
		if (UOM == null)
			f_uom.setText("--");
		else
			f_uom.setText(UOM);
	} // setUOM

	/**
	 * Set Price
	 * 
	 * @param price
	 *            price
	 */
	public void setPrice(BigDecimal price) {
		
		if (price == null)
			price = Env.ZERO;
		f_price.setPrecision(p_QuickRegisterPanel.getCurrencyPrecision());
		f_price.setValue(price);
		boolean rw =  p_QuickRegister.isModifyPrice();
		f_price.setReadWrite(rw);
	} // setPrice

	public void setQty(BigDecimal qty){
		if (qty == null)
			qty = Env.ZERO;
		f_quantity.setPrecision(p_QuickRegisterPanel.getCurrencyPrecision());
		f_quantity.setValue(qty);
	} // setPrice

	/**
	 * Get Price
	 * 
	 * @return price
	 */
	public BigDecimal getPrice() {
		 return (BigDecimal)f_price.getValue();
	} // getPrice

	/**
	 * Get Qty
	 * 
	 * @return qty
	 */
	public BigDecimal getQty() {
		return (BigDecimal) f_quantity.getValue();
	} // getPrice

	/**************************************************************************
	 * New Line
	 */
	public void newLine() {
		p_QuickRegisterPanel.f_product.setM_Product_ID(0);
		setQty(Env.ONE);
		setPrice(Env.ZERO);
		p_QuickRegisterPanel.f_lines.updateTable(m_order);
		p_QuickRegisterPanel.f_lines.setVisible(true);
		

	} // newLine

	/**
	 * Save Line
	 * 
	 * @return true if saved
	 */
	public boolean saveLine() {
		MProduct product = p_QuickRegisterPanel.f_product.getProduct();
		if (product == null)
			return false;
		BigDecimal QtyOrdered = getQty();
//		BigDecimal PriceActual = getPrice();
		BigDecimal PriceActual = (BigDecimal) f_price.getValue();
		MOrderLine line = createLine(product, QtyOrdered, PriceActual);
		
		if (line == null) {
			p_QuickRegisterPanel.f_product.f_name.requestFocus();
			return true;
		}
		if (!line.save())
			return false;
		newLine();
		

		return true;
	} // saveLine
	/**
	 * Save Line
	 * 
	 * @return true if saved
	 */
	public boolean saveNewLine() {
		MProduct product = p_QuickRegisterPanel.f_product.getProduct();
		if (product == null)
			return false;
		BigDecimal QtyOrdered = (BigDecimal) f_quantity.getValue();
		BigDecimal PriceActual = (BigDecimal) f_price.getValue();
		MOrderLine line = createNewLine(product, QtyOrdered, PriceActual);

		if (line == null) {
			p_QuickRegisterPanel.f_product.requestFocus();
			return false;
		}
		if (!line.save())
			return false;
		newLine();

		return true;
	} // saveLine
	

	/**
	 * to erase the lines from order
	 * 
	 * @return true if deleted
	 */
	public void deleteLine(int row) {
		if (m_order != null && row != -1) {
			MOrderLine[] lineas = m_order.getLines(true, null);
			int numLineas = lineas.length;
			if (numLineas > row) {
				// delete line from order - true only when DRAFT is not
				// PREPARE-IT()
				lineas[row].delete(true);
				for (int i = row; i < (numLineas - 1); i++)
					lineas[i] = lineas[i + 1];
				lineas[numLineas - 1] = null;
			}
		}
	} // deleteLine

	/**
	 * Delete order from database
	 */
	public void deleteOrder() {
		if (m_order != null) {
			if (m_order.getDocStatus().equals("DR")) {
				MOrderLine[] lineas = m_order.getLines();
				if (lineas != null) {
					int numLineas = lineas.length;
					if (numLineas > 0)
						for (int i = numLineas - 1; i >= 0; i--) {
							if (lineas[i] != null)
								deleteLine(i);
						}
				}

				MOrderTax[] taxs = m_order.getTaxes(true);
				if (taxs != null) {
					int numTax = taxs.length;
					if (numTax > 0)
						for (int i = taxs.length - 1; i >= 0; i--) {
							if (taxs[i] != null)
								taxs[i].delete(true);
							taxs[i] = null;
						}
				}
				lineas = m_order.getLines(true, null);
				m_order.delete(true);
			}
			m_order = null;
		}
	} // deleteOrder

	/**
	 * Create new order
	 */
	public void newOrder() {
		m_order = null;
		m_order = getOrder();
	}

	/**
	 * Get/create Header
	 * 
	 * @return header or null
	 */
	public MOrder getOrder() {
		if (m_order == null) {
			m_order = new MOrder(Env.getCtx(), 0, null);
			m_order.setAD_Org_ID(p_QuickRegister.getAD_Org_ID());
			m_order.setIsSOTrx(true);
			if (p_QuickRegister.getC_DocType_ID() != 0)
				m_order.setC_DocTypeTarget_ID(p_QuickRegister.getC_DocType_ID());
			else
				m_order.setC_DocTypeTarget_ID(MOrder.DocSubTypeSO_POS);
			MBPartner partner = p_QuickRegisterPanel.f_bpartner.getBPartner();
			if (partner == null || partner.get_ID() == 0)
				partner = p_QuickRegister.getBPartner();
			
			if (partner == null || partner.get_ID() == 0) {
				log.log(Level.SEVERE, "SubCurrentLine.getOrder - no BPartner");
				return null;
			}
			log.info("SubCurrentLine.getOrder -" + partner);
			m_order.setBPartner(partner);
			int id = p_QuickRegisterPanel.f_bpartner.getC_BPartner_Location_ID();
			if (id != 0)
				m_order.setC_BPartner_Location_ID(id);
			id = p_QuickRegisterPanel.f_bpartner.getAD_User_ID();
			if (id != 0)
				m_order.setAD_User_ID(id);
			//
			m_order.setM_PriceList_ID(p_QuickRegister.getM_PriceList_ID());
			m_order.setM_Warehouse_ID(p_QuickRegister.getM_Warehouse_ID());
			m_order.setSalesRep_ID(p_QuickRegister.getSalesRep_ID());
			p_QuickRegisterPanel.f_orderline.m_C_Order_ID = m_order.getC_Order_ID();
			if (!m_order.save())
				m_order = null;
		}
		return m_order;
	} // getHeader

	/**
	 * Set BPartner
	 */
	public void setBPartner() {
		if (m_order != null)
			if (m_order.getDocStatus().equals("DR")) {
				MBPartner partner = p_QuickRegisterPanel.f_bpartner.getBPartner();
				// get default from mpos if no selection make
				if (partner == null || partner.get_ID() == 0)
					partner = p_QuickRegister.getBPartner();
				if (partner == null || partner.get_ID() == 0) {
					log.warning("SubCurrentLine.getOrder - no BPartner");
				} else {
					log.info("SubCurrentLine.getOrder -" + partner);
					m_order.setBPartner(partner);
					MOrderLine[] lineas = m_order.getLines();
					for (int i = 0; i < lineas.length; i++) {
						lineas[i].setC_BPartner_ID(partner.getC_BPartner_ID());
						lineas[i].setTax();
						lineas[i].save();
					}
					m_order.save();
				}
			}
	}

	/**
	 * Create new Line
	 * 
	 * @return line or null
	 */
	public MOrderLine createLine(MProduct product, 
			BigDecimal QtyOrdered, BigDecimal PriceActual)
		{
			MOrder order = getOrder();
			if (order == null)
				return null;
			if (!order.getDocStatus().equals("DR"))
				return null;
			//add new line or increase qty
			// catch Exceptions at order.getLines()
			int numLineas = 0;
			MOrderLine[] lineas = null;
			try
			{
				lineas = order.getLines("","Order BY Line");
				numLineas = lineas.length;
				for (int i = 0; i < numLineas; i++)
				{
					if ((lineas[i].getM_Product_ID() == product.getM_Product_ID())&&(lineas[i].get_ID()== p_QuickRegisterPanel.f_lines.m_Line_ID))
					{
						//increase qty
//						Double current = lineas[i].getQtyEntered().doubleValue();
						Double toadd = QtyOrdered.doubleValue();
						Double priceActual = PriceActual.doubleValue();
//						 toadd = current + toadd;
						lineas[i].setQty(new BigDecimal(toadd));
						lineas[i].setPrice(new BigDecimal(priceActual)); //	sets List/limit
						if(p_QuickRegisterPanel.f_product.getComponent(2) instanceof  VPAttribute){
							VPAttribute attri = (VPAttribute)p_QuickRegisterPanel.f_product.getComponent(2);
							Integer oldValue = (Integer)attri.getValue();
							if((oldValue != null)&& (oldValue > 0)){
								int M_AttributeSetInstance_ID = oldValue;	
								try {
									lineas[i].setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
								} catch (Exception e) {
									e.printStackTrace();
								}
							}
							
						}
						lineas[i].save();
						selectRow = i;
						p_QuickRegisterPanel.f_lines.m_Line_ID = 0;
						return lineas[i];
					}
				}
			}
			catch (Exception e)
			{
				log.severe("Order lines cannot be created - " + e.getMessage());
			}
			selectRow = numLineas ;
			MOrderLine line = new MOrderLine (order);
			line.setProduct(product);
			line.setQty(QtyOrdered);
			line.setPrice(PriceActual);
			line.save();
			return line;
		}	//	getLine
	
	/**
	 * Create new Line
	 * 
	 * @return line or null
	 */
	public MOrderLine createNewLine(MProduct product, 
			BigDecimal QtyOrdered, BigDecimal PriceActual)
		{
			MOrder order = getOrder();
			if (order == null)
				return null;
			if (!order.getDocStatus().equals("DR"))
				return null;
			
			MOrderLine line = new MOrderLine (order);
			line.setProduct(product);
			line.setQty(QtyOrdered);
			line.setPrice(PriceActual);
			if(p_QuickRegisterPanel.f_product.getComponent(2) instanceof  VPAttribute){
				VPAttribute attri = (VPAttribute)p_QuickRegisterPanel.f_product.getComponent(2);
				Integer M_AttributeSetInstance_ID = (Integer)attri.getValue();
				if((M_AttributeSetInstance_ID != null)&&(M_AttributeSetInstance_ID != 0)&& (M_AttributeSetInstance_ID > 0)){
					try {
						line.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
					} catch (Exception e) {
						e.printStackTrace();
					}
				}else {
					attri.setEnabled(false);
				}
				
			}
			
			
			line.save();
			return line;
		}	//	getLine

	/**
	 * Create new Line
	 * 
	 * @return line or null
	 */
	public int isLineFind(MProduct product, BigDecimal QtyOrdered,
			BigDecimal PriceActual) {
		MOrder order = getOrder();
		if (order == null)
			return 0;
		if (!order.getDocStatus().equals("DR"))
			return 0;
		int numLineas = 0;
		MOrderLine[] lineas = null;
		lineas = order.getLines("", "");
		numLineas = lineas.length;

		return numLineas;
	} // getLine

	/**
	 * @param m_c_order_id
	 */
	public void setOldOrder(int m_c_order_id) {
		m_order = new MOrder(p_ctx, m_c_order_id, null);
		p_QuickRegisterPanel.updateInfo();
	}

	/**
	 * @param qty
	 *            set focus
	 */
	public void qtyFocus() {
		f_quantity.requestFocus();
		return ;
	}

	/**
	 * @param m_c_order_id
	 */
	public void setOrder(int m_c_order_id) {
		m_order = new MOrder(p_ctx, m_c_order_id, null);
	}
	
	public void focusMove() {
	}

	public void keyReleased(KeyEvent e) {
		
		if ((e.getSource() == f_price) &&
				(e.getKeyCode() == KeyEvent.VK_ENTER)){
			BigDecimal price = (BigDecimal) f_price.getValue();
			f_price.setValue(price);
			f_new.requestFocus();
		}
		else if ((e.getSource() == f_quantity) &&
		e.getKeyCode() == KeyEvent.VK_ENTER){	
			
		}
		else if ((e.getKeyCode() == KeyEvent.VK_ENTER && e.getSource() == f_new)&&(!p_QuickRegisterPanel.f_product.f_name.getValue().equals(""))) {
		
			p_QuickRegisterPanel.f_lines.setVisible(true);
			p_QuickRegisterPanel.f_lines.getM_table().setVisible(true);
			p_QuickRegisterPanel.f_orderlines.setVisible(false);
			p_QuickRegisterPanel.m_southPanel.setVisible(true);
			p_QuickRegisterPanel.closeQuery();
			//edit
			if(p_QuickRegisterPanel.f_lines.checkEdit.equals("1")){
				boolean retValue = saveLine();
				if ( !retValue )
				{
					ADialog.error(p_QuickRegisterPanel.m_WindowNo, this, "SaveIgnored");
					p_QuickRegisterPanel.f_status.setStatusLine(Msg.getMsg(p_QuickRegisterPanel.m_ctx, "SaveIgnored"), true);
				}
				clearAttribute();
				p_QuickRegisterPanel.updateInfo();
				int rows = p_QuickRegisterPanel.f_lines.getM_table().getRowCount();
				if ( retValue ){
					p_QuickRegisterPanel.f_status.setStatusLine(Msg.getMsg(Env.getCtx(), "Records")+ "=" + rows);
				}
				setStatusValue();
				if (rows == 0)
					return;
				int row = getSelectRow();
				
				p_QuickRegisterPanel.f_lines.getM_table().getSelectionModel()
						.setSelectionInterval(row, row);
				showCell(row, 0);
				p_QuickRegisterPanel.f_product.f_name.requestFocus();
				p_QuickRegisterPanel.f_lines.checkEdit = "0";
//				return;
			}
			//new Line
			else if(p_QuickRegisterPanel.f_lines.checkEdit.equals("0")){
				
			//  manually initiated
				boolean retValue = saveNewLine();
				//   if there is no previous error
				if ( !retValue )
				{
					ADialog.error(p_QuickRegisterPanel.m_WindowNo, this, "SaveIgnored");
					p_QuickRegisterPanel.f_status.setStatusLine(Msg.getMsg(p_QuickRegisterPanel.m_ctx, "SaveIgnored"), true);
				}
				p_QuickRegisterPanel.updateInfo();
				int rows = p_QuickRegisterPanel.f_lines.getM_table().getRowCount();
				if (rows == 0)
					return;
				//info
				clearAttribute();
				if ( retValue ){
					p_QuickRegisterPanel.f_status.setStatusLine(Msg.getMsg(Env.getCtx(), "Records")+ "=" + rows);
				}
				
				rows--;
				p_QuickRegisterPanel.f_lines.getM_table().getSelectionModel()
						.setSelectionInterval(rows, rows);
				showCell(rows, 0);
				p_QuickRegisterPanel.f_product.f_name.requestFocus();
				setStatusValue();
				setSelectRow(0);
				
			}
			f_lineText.setValue("");
			f_linetotal.setValue("");
			f_price.setValue(Env.ZERO);
			f_quantity.setValue(Env.ONE);
			return;
		}
		else if((e.getSource() == f_price)
				&&(e.getKeyCode() == KeyEvent.VK_RIGHT)){
			f_quantity.requestFocus();
		}
		else if ((e.getSource() == f_new) &&
				e.getKeyCode() == KeyEvent.VK_TAB){
			p_QuickRegisterPanel.f_product.f_name.requestFocus();
		}
		else if ((e.getSource() == f_new) &&
				(e.getKeyCode() == KeyEvent.VK_ENTER)&&(p_QuickRegisterPanel.f_product.f_name.getValue().equals(""))){
			p_QuickRegisterPanel.f_product.f_name.requestFocus();
		}
		else if((e.getSource() == f_new)
				&&(e.getKeyCode() == KeyEvent.VK_DOWN)){
			p_QuickRegisterPanel.f_lines.f_up.requestFocus();
		}
		else if((e.getSource() == f_new)
				&&(e.getKeyCode() == KeyEvent.VK_LEFT)){
			f_price.requestFocus();
		}
	}

	public void showCell(int row, int column) {
	    Rectangle rect = 
	    	p_QuickRegisterPanel.f_lines.getM_table().getCellRect(row, column, true);
		p_QuickRegisterPanel.f_lines.getM_table().scrollRectToVisible(rect);
	    }

	public void keyTyped(KeyEvent e) {
	}
	public int getSelectRow() {
		return selectRow;
	}
	public void setSelectRow(int selectRow) {
		this.selectRow = selectRow;
	}
	public void focusGained(FocusEvent e) {
	}
	public void focusLost(FocusEvent e) {
		if(e.getSource() == f_price){
			f_price.getField().getVO();
			f_price.getValue();
		}
	}
	public void keyPressed(KeyEvent e) {
	
	}
	public void setStatusValue()
	{
		int rows = p_QuickRegisterPanel.f_lines.getM_table().getRowCount();
		if(rows > 0 ){
			int row = p_QuickRegisterPanel.f_lines.getM_table().getSelectedRow();
			row ++;
			p_QuickRegisterPanel.f_status.setStatusDB("[" + row + "/" + rows + "]" );
		}
	}

	public void dataStatusChanged(DataStatusEvent e) {
		log.info(e.getMessage());
		String dbInfo = e.getMessage();
			dbInfo = "[ " + dbInfo + " ]";
			p_QuickRegisterPanel.f_status.setStatusDB(dbInfo, e);
		
	}
} // QuickRegisterSubCurrentLine
