/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.quickregister;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import org.compiere.framework.PO;
import org.compiere.grid.GridController;
import org.compiere.grid.ed.VNumber;
import org.compiere.grid.ed.VPAttribute;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MOrder;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;

/**
 *	QuickRegister All Lines Sub Panel
 *	
 *  @author Horcha
 *  @version $Id: SubLines.java,v 1.3 2010/01/10 07:50:34 jrmt Exp $
 */
public class SubLines extends QuickRegisterSubPanel implements ActionListener, 
		MouseListener, ListSelectionListener,KeyListener
{
	/**
	 * 	Constructor
	 *	@param quickRegisterPanel QuickRegister Panel
	 */
	public SubLines (QuickRegisterPanel quickRegisterPanel)
	{
		super (quickRegisterPanel);
	}	//	SubLines
	
	/** The Table					*/
	private MiniTable		m_table;
	private int				m_M_Product_ID;
	private String			m_ProductName;
	private String			m_Line;
	protected int		m_Line_ID;
	private String			m_LineTotal;
	private BigDecimal		m_Price;
	protected int checkup = 0;
	protected  CButton f_up;
	protected CButton 		f_bEdit;
	protected CButton f_delete;
	private CButton f_down;
	private BigDecimal m_Qty;
	protected CScrollPane scroll;
	protected String  checkEdit = "0";
	protected int newEditFlg = 0;
	/** The Query SQL				*/
	private String			m_sql;
	/**	Logger			*/
	private static CLogger log = CLogger.getCLogger(SubLines.class);
	private VNumber f_net;
	private VNumber f_tax;
	private VNumber f_total;
	private Object 			m_C_Order_ID = null;
	protected GridController gc = null;
	/** Current GridController                          */
	public VNumber getF_net() {
		return f_net;
	}
	public VNumber getF_total() {
		return f_total;
	}
	protected CTextField f_docStatus ;
	/**	Table Column Layout Info			*/
	private static ColumnInfo[] s_layout = new ColumnInfo[] 
	{
		new ColumnInfo(" ", "C_OrderLine_ID", IDColumn.class),
		new ColumnInfo(Msg.translate(Env.getCtx(), "Name"), "Name", String.class), 
		new ColumnInfo(Msg.translate(Env.getCtx(), "Line"), "Line", Integer.class),
		new ColumnInfo(Msg.translate(Env.getCtx(), "Qty"), "QtyOrdered", Double.class),
		new ColumnInfo(Msg.translate(Env.getCtx(), "C_UOM_ID"), "UOMSymbol", String.class), 
		new ColumnInfo(Msg.translate(Env.getCtx(), "PriceActual"), "PriceActual", BigDecimal.class), 
		new ColumnInfo(Msg.translate(Env.getCtx(), "LineNetAmt"), "LineNetAmt", BigDecimal.class), 
		new ColumnInfo(Msg.translate(Env.getCtx(), "C_Tax_ID"), "TaxIndicator", String.class), 
		new ColumnInfo(Msg.translate(Env.getCtx(), "Description"), "Description", String.class) 
	};
	/**	From Clause							*/
	private static String s_sqlFrom = "C_Order_LineTax_v";
	/** Where Clause						*/
	private static String s_sqlWhere = "C_Order_ID=? AND LineNetAmt<>0"; 

	/**
	 * 	Initialize
	 */
	public void init()
	{
		//	Title
		TitledBorder border = new TitledBorder(Msg.translate(Env.getCtx(), "C_OrderLine_ID"));
		setBorder(border);
		
		//	Content
		setLayout(new BorderLayout(2, 2));
		m_table = new MiniTable();
		 scroll = new CScrollPane(m_table);
		m_sql = m_table.prepareTable (s_layout, s_sqlFrom, 
			s_sqlWhere, false, "C_Order_LineTax_v")
			+ " ORDER BY Line";
		m_table.setRowSelectionAllowed(true);
		m_table.setColumnSelectionAllowed(false);
		m_table.setMultiSelection(false);
		m_table.addMouseListener(this);
		m_table.addKeyListener(this);
//		m_table.getSelectionModel().addListSelectionListener(this);
		scroll.setPreferredSize(new Dimension(100,100));
		add (scroll, BorderLayout.CENTER);
		
//		Right side
		CPanel right = new CPanel();
		add (right, BorderLayout.WEST);
		right.setLayout(new BoxLayout(right, BoxLayout.Y_AXIS));
		//
		right.add(Box.createGlue());
		f_up = createButtonAction("Previous", KeyStroke.getKeyStroke(KeyEvent.VK_UP, 0));
		f_up.addKeyListener(this);
		right.add (f_up);
		right.add(Box.createGlue());
		f_bEdit = createButtonAction ("Edit", null);
		f_bEdit.addKeyListener(this);
		right.add(f_bEdit);
		right.add(Box.createGlue());
		f_delete = createButtonAction("Delete", KeyStroke.getKeyStroke(KeyEvent.VK_DELETE, Event.SHIFT_MASK));
		f_delete.addKeyListener(this);
		right.add (f_delete);
		right.add(Box.createGlue());
		f_down = createButtonAction("Next", KeyStroke.getKeyStroke(KeyEvent.VK_DOWN, 0));
		f_down.addKeyListener(this);
		right.add (f_down);
		right.add(Box.createGlue());
		
		//	Summary
		FlowLayout summaryLayout = new FlowLayout(FlowLayout.LEADING, 2,0);
		CPanel summary = new CPanel(summaryLayout);
		add (summary, BorderLayout.SOUTH);
		//
		CLabel lNet = new CLabel (Msg.translate(Env.getCtx(), "TotalLines"));
		summary.add(lNet);
		f_net = new VNumber("TotalLines", false, true, false, DisplayType.Amount, "TotalLines");
		f_net.setColumns(6, 22);
		lNet.setLabelFor(f_net);
		summary.add(f_net);
		f_net.setValue (Env.ZERO);
		//
		CLabel lTax = new CLabel (Msg.translate(Env.getCtx(), "TaxAmt"));
		summary.add(lTax);
		f_tax = new VNumber("TaxAmt", false, true, false, DisplayType.Amount, "TaxAmt");
		f_tax.setColumns(6, 22);
		lTax.setLabelFor(f_tax);
		summary.add(f_tax);
		f_tax.setValue (Env.ZERO);
		//
		CLabel lTotal = new CLabel (Msg.translate(Env.getCtx(), "GrandTotal"));
		summary.add(lTotal);
		f_total = new VNumber("GrandTotal", false, true, false, DisplayType.Amount, "GrandTotal");
		f_total.setColumns(6, 22);
		lTotal.setLabelFor(f_total);
		summary.add(f_total);
		f_total.setValue (Env.ZERO);
		
		CLabel lDocumet = new CLabel (Msg.translate(Env.getCtx(), ""));
		
		lDocumet.setText(Msg.translate(Env.getCtx(), "DocStatus"));
		summary.add(lDocumet);
		
		f_docStatus = new CTextField(10);
		f_docStatus.setName("docmentNo");
		f_docStatus.setReadWrite(false);
		summary.add (f_docStatus);
		addMouseListener(this);
	}	//	init
	
	/**
	 * 	Dispose - Free Resources
	 */
	public void dispose()
	{
		super.dispose();
	}	//	dispose
	
	/**
	 * 	Action Listener
	 *	@param e event
	 */
	public void actionPerformed (ActionEvent e)
	{
		String action = e.getActionCommand();
		if (action == null || action.length() == 0)
			return;
		log.info( "SubLines - actionPerformed: " + action);
		if ("Previous".equalsIgnoreCase(e.getActionCommand()))
		{
			int rows = m_table.getRowCount();
			if (rows == 0){
				p_QuickRegisterPanel.f_product.f_name.requestFocus();
				return;
			}
				
			int row = m_table.getSelectedRow();
			row--;
			m_table.getSelectionModel().setSelectionInterval(row, row);
			m_table.getSelectionModel().getSelectionMode();
			showCell(row,0);
			clearValue();
			setStatusValue();
		}
		else if ("Next".equalsIgnoreCase(e.getActionCommand()))
		{
			int rows = m_table.getRowCount();
			if (rows == 0){
				p_QuickRegisterPanel.f_product.f_name.requestFocus();
				return;
			}
				
			int row = m_table.getSelectedRow();
			row++;
			if (row >= rows)
				row = rows - 1;
			m_table.getSelectionModel().setSelectionInterval(row, row);
			showCell(row,0);
			clearValue();
			setStatusValue();
		}
//		Delete
		else if (action.equals("Delete"))
		{
			//then  new order
			if(newEditFlg == 0){
				int rows = m_table.getRowCount();
				if (rows != 0)
				{
					int row = m_table.getSelectedRow();
					if (row != -1)
					{
						MOrder order = p_QuickRegisterPanel.f_currentLine.getOrder();
						if( MOrder.DOCSTATUS_Drafted.equals(order.getDocStatus()) ){
							p_QuickRegisterPanel.f_currentLine.deleteLine(row);
							updateTable(p_QuickRegisterPanel.f_currentLine.getOrder());
							p_QuickRegisterPanel.updateInfo();
						}
						p_QuickRegisterPanel.f_lines.getM_table().getSelectionModel()
						.setSelectionInterval(row, row);
					}
					rows--;
					if(rows == row){
						row--;
						if(row == -1 )
							row = 0;
						p_QuickRegisterPanel.f_lines.getM_table().getSelectionModel()
						.setSelectionInterval(row, row);
					}
					m_table.requestFocus();
				}else{
					p_QuickRegisterPanel.f_product.f_name.requestFocus();
				}
			}
			// then old order
			if(newEditFlg == 1){
				int rows = m_table.getRowCount();
				if (rows != 0) {
					int row = m_table.getSelectedRow();
					if (row != -1)
						{
//						int deleterow = m_table.getSelectedRow();
						int deleteOrderRow = p_QuickRegisterPanel.f_orderlines.m_table.getSelectedRow();
						String order_Idstr = p_QuickRegisterPanel.f_orderlines.m_table.getValueAt(deleteOrderRow, 0).toString();
						int equlsFlg = order_Idstr.indexOf('=');
						equlsFlg++;
						int pointFlg = order_Idstr.indexOf(',');
						int order_Id = Integer.valueOf(order_Idstr.substring(equlsFlg,
								pointFlg));
						MOrder order = new MOrder(p_QuickRegisterPanel.m_ctx,order_Id,null);
						String drStr = p_QuickRegisterPanel.f_lines.sqlCheckDR(order_Id);
						if (MOrder.DOCSTATUS_Drafted.equals(drStr)) {
							p_QuickRegisterPanel.f_currentLine.deleteLine(row);
							p_QuickRegisterPanel.f_lines.viewTable(Integer
									.valueOf(order_Id));
							updateTable(order);
							p_QuickRegisterPanel.updateInfo();
						}
							rows--;
							if(rows == row){
								row--;
								if(row == -1 )
									row = 0;
								p_QuickRegisterPanel.f_lines.getM_table().getSelectionModel()
								.setSelectionInterval(row, row);
							}
							m_table.requestFocus();
						
						}
				}
			}
			setStatusValue();
		}
		//Edit
		else if (action.equals("Edit")){
			
			int rows = m_table.getRowCount();
			
			if(rows > 0){
				
				enableButtons();
				p_QuickRegisterPanel.f_product.f_name.requestFocus();
				checkEdit = "1";
			}else {
				p_QuickRegisterPanel.f_product.f_name.requestFocus();
				checkEdit = "0";
			}
			
		}
		
	}	//	actionPerformed

	
	/**
	 * 	Table selection changed
	 *	@param e event
	 */
	public void valueChanged (ListSelectionEvent e)
	{
		if (e.getValueIsAdjusting())
			return;
		if ( m_table.getSelectedRow() != -1 )
		{
			m_table.setMultiSelection(true);
			setStatusValue();
		}
		
		
	}	//	valueChanged

	/**
	 *  Mouse Clicked
	 *  @param e event
	 */
	public void mouseClicked(MouseEvent e)
	{
		clearValue();
		clearAttribute() ;
		
	}   //  mouseClicked

	public void mouseEntered (MouseEvent e) {
		
		
		m_table.addMouseListener(new MouseAdapter() { 
			public void mouseClicked(MouseEvent evt) { 
				if ((evt.getClickCount() == 2) && (m_table.getSelectedRow() != -1)) {
					enableButtons();
					int order_ID = p_QuickRegisterPanel.f_currentLine.getOrder().getC_Order_ID();
					String  dw = p_QuickRegisterPanel.f_orderlines.sqlCheckDR(Integer.valueOf(order_ID));
					if(dw.equals("CO")){
					}else{
					p_QuickRegisterPanel.f_product.f_name.requestFocus();
					checkEdit = "1";
					}
//					p_QuickRegisterPanel.f_currentLine.f_price.setReadWrite(true);
					return;
				}
			}
		});
	}
	/**
	 * 	Focus Gained
	 *	@param e
	 */
	public void focusGained (FocusEvent e)
	{
		p_QuickRegisterPanel.f_bpartner.f_bEdit.setEnabled(false);
		p_QuickRegisterPanel.f_bpartner.f_bNew.setEnabled(false);
//		f_bNew.setEnabled(true);
		f_bEdit.setEnabled(true);
	}
	public void mouseExited (MouseEvent e) {
		
	}
	public void mousePressed (MouseEvent e) {
		
	}
	public void mouseReleased (MouseEvent e) {
		setStatusValue();
	}
	
	/**
	 * 	Update Table
	 *	@param order order
	 */
	public void updateTable (MOrder order)
	{
		int C_Order_ID = 0;
		if (order != null)
			C_Order_ID = order.getC_Order_ID();

		if (C_Order_ID == 0)
		{
			m_table.loadTable(new PO[0]);
			
			setSums(order);
		}
		
		PreparedStatement pstmt = null;
		try
		{
			pstmt = DB.prepareStatement (m_sql, null);
			pstmt.setInt (1, C_Order_ID);
			ResultSet rs = pstmt.executeQuery ();
			m_table.loadTable(rs);
			
//			
//			
			rs.close ();
			pstmt.close ();
			pstmt = null;
			
		}
		catch (Exception e)
		{
			log.log(Level.SEVERE, m_sql, e);
		}
		try
		{
			if (pstmt != null)
				pstmt.close ();
			pstmt = null;
		}
		catch (Exception e)
		{
			pstmt = null;
		}
		setSums(order);
		
		
	}	//	updateTable
	
	/**
	 * 	Update Table
	 *	@param order order
	 */
	public void delete_Order (String order_ID)
	{
		int C_Order_ID = 0;
		if (order_ID != null){
			C_Order_ID = Integer.valueOf(order_ID);
		
			PreparedStatement pstmt = null;
			try
			{
				pstmt = DB.prepareStatement (m_sql, null);
				pstmt.setInt (1, C_Order_ID);
				ResultSet rs = pstmt.executeQuery ();
				m_table.loadTable(rs);
				rs.close ();
				pstmt.close ();
				pstmt = null;
				
			}
			catch (Exception e)
			{
				log.log(Level.SEVERE, m_sql, e);
			}
			try
			{
				if (pstmt != null)
					pstmt.close ();
				pstmt = null;
			}
			catch (Exception e)
			{
				pstmt = null;
			}
		}
		
		
	}	//	updateTable
	
	/**
	 *  Query Info
	 */
	public String sqlCheckDR(int C_Order_ID)
	{
		
		
		log.info("");
		int AD_Client_ID = Env.getCtx().getAD_Client_ID();
		String dw ="";
		m_C_Order_ID =  C_Order_ID;
		//  Create SQL
		StringBuffer sql = new StringBuffer(
			"SELECT C_Order_ID, ic.DocStatus, DocumentNo, bp.Name "
			+ "FROM C_ORDER ic, AD_Org o, C_BPartner bp, C_DocType dt "
			+ "WHERE ic.AD_Org_ID=o.AD_Org_ID"
			+ " AND ic.C_BPartner_ID=bp.C_BPartner_ID"
			+ " AND ic.C_DOCTYPETARGET_ID=dt.C_DocType_ID"
			);
		
		if (m_C_Order_ID != null)
			sql.append(" AND ic.C_Order_ID = ").append(m_C_Order_ID);
		if (AD_Client_ID != 0)
			sql.append(" AND ic.AD_Client_ID = ").append(AD_Client_ID);
		
		try
		{
			PreparedStatement  pstmt = DB.prepareStatement(sql.toString(), null);
			ResultSet rs = pstmt.executeQuery(); 
			//
			while (rs.next())
			{
				try{
			dw = rs.getString(2).toString();              //  DocType
				}catch (Exception e){
					e.printStackTrace();
				}
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql.toString(), e);
		}
		return dw;
	}
	/**
	 * 	Update Table
	 *	@param order order
	 */
	public void viewTable (int C_Order_ID)
	{
		

		if (C_Order_ID == 0)
		{
			m_table.loadTable(new PO[0]);
			return;
		}else {
		
		PreparedStatement pstmt = null;
		try
		{
			pstmt = DB.prepareStatement (m_sql, null);
			pstmt.setInt (1, C_Order_ID);
			ResultSet rs = pstmt.executeQuery ();
			m_table.loadTable(rs);
			rs.close ();
			pstmt.close ();
			pstmt = null;
			
		}
		catch (Exception e)
		{
			log.log(Level.SEVERE, m_sql, e);
		}
		try
		{
			if (pstmt != null)
				pstmt.close ();
			pstmt = null;
		}
		catch (Exception e)
		{
			pstmt = null;
		}
		}		
	}	//	updateTable
	
	public void showCell(int row, int column) {
	    Rectangle rect = 
	    	m_table.getCellRect(row, column, true);
	    	m_table.scrollRectToVisible(rect);
	    }
	public MiniTable getM_table() {
		return m_table;
	}
	public void setM_table(MiniTable m_table) {
		this.m_table = m_table;
	}
	public int getM_M_Product_ID() {
		return m_M_Product_ID;
	}
	public void setM_M_Product_ID(int product_ID) {
		m_M_Product_ID = product_ID;
	}
	/**
	 * clearValue
	 * */
	public void clearValue() {
		p_QuickRegisterPanel.f_currentLine.f_lineText.setValue("");
		p_QuickRegisterPanel.f_currentLine.f_price.setValue(Env.ZERO);
		p_QuickRegisterPanel.f_currentLine.f_quantity.setValue(Env.ONE);
		p_QuickRegisterPanel.f_currentLine.f_linetotal.setValue("");
		p_QuickRegisterPanel.f_product.f_name.setValue("");
	}
	/**
	 * 	Set Sums from Table
	 */
	private void setSums(MOrder order)
	{
		f_net.setPrecision(p_QuickRegisterPanel.getCurrencyPrecision());
		f_total.setPrecision(p_QuickRegisterPanel.getCurrencyPrecision());
		f_tax.setPrecision(p_QuickRegisterPanel.getCurrencyPrecision());
		if (order == null)
		{
			f_net.setValue(Env.ZERO);
			f_total.setValue(Env.ZERO);
			f_tax.setValue(Env.ZERO);
		}
		else
		{
			p_QuickRegisterPanel.f_currentLine.setOrder(order.getC_Order_ID());
			f_net.setValue(order.getTotalLines());
			f_total.setValue(order.getGrandTotal());
			f_tax.setValue(order.getGrandTotal().subtract(order.getTotalLines()));
		}
	}	//	setSums
	
	protected void enableButtons()
	{
		m_M_Product_ID = -1;
		m_ProductName = null;
		m_Line = null;
		m_Line_ID = 0;
		m_LineTotal = null;
		m_Price = null;
		m_Qty = null;
		String  m_Line_IDStr ="";
		int row = m_table.getSelectedRow();
		boolean enabled = row != -1;
		if (enabled)
		{
			Integer ID = m_table.getSelectedRowKey();
			if (ID != null)
			{
				m_Price = (BigDecimal)m_table.getValueAt(row, 5);
				m_ProductName = (String)m_table.getValueAt(row, 1);
				m_Line = m_table.getValueAt(row, 2).toString();
				m_LineTotal = m_table.getValueAt(row, 6).toString();
				Double dd  = (Double)m_table.getValueAt(row, 3);
				m_Line_IDStr = m_table.getValueAt(row, 0).toString();
				int start = m_Line_IDStr.indexOf("=");
				start ++;
				int end = m_Line_IDStr.indexOf(",");
				m_Line_IDStr = m_Line_IDStr.substring(start, end);
				m_Line_ID = Integer.valueOf(m_Line_IDStr);
				executeQuery(m_Line_ID);
				
				p_QuickRegisterPanel.f_currentLine.setQty(new BigDecimal(dd));
				p_QuickRegisterPanel.f_currentLine.setPrice(m_Price);
//				p_QuickRegisterPanel.f_currentLine.f_price.setReadWrite(true);
				p_QuickRegisterPanel.f_currentLine.f_lineText.setValue(m_Line);
				p_QuickRegisterPanel.f_currentLine.f_linetotal.setValue(m_LineTotal);
				return;
			}
		}
		
		log.fine("M_Product_ID=" + m_M_Product_ID + " - " + m_ProductName + " - " + m_Price); 
	}	//	enableButtons
	/**************************************************************************
	 * Set clear attribute
	 * 
	 * @param 
	 *            
	 */
	public void clearAttribute() {
		if(p_QuickRegisterPanel.f_product.getComponent(2).getComponentAt(0, 0) instanceof  JTextField){
			JTextField text = (JTextField)p_QuickRegisterPanel.f_product.getComponent(2).getComponentAt(0, 0);
			text.setText("");
			}
		VPAttribute attri = (VPAttribute)p_QuickRegisterPanel.f_product.getComponent(2);
		if((attri.getValue() != null)&& (attri.getValue().equals("0"))){
		
			try {
				attri.setValue(0);
			} catch (Exception e) {
				
				e.printStackTrace();
			}
		}
	} // setCurrency
	/**
	 *  Query Info
	 */
	private void executeQuery( int C_OrderLine_ID )
	{
		log.info("");
		int AD_Client_ID = Env.getCtx().getAD_Client_ID();
		int AD_Org_ID = Env.getCtx().getAD_Org_ID();
		//  Create SQL
		String  M_product = "";
		String  attributeID ="0";
		StringBuffer sql = new StringBuffer(
			"SELECT p.M_PRODUCT_ID ,ol.M_ATTRIBUTESETINSTANCE_ID "
			+ "FROM   C_Order_LineTax_v p ,C_ORDERLINE ol "
			+ "WHERE 1=1 "
			+ " AND p.C_OrderLine_ID = ol.C_OrderLine_ID "
			+ " AND p.C_OrderLine_ID = ? "
			);
		
		if (AD_Client_ID != 0)
			sql.append(" AND p.AD_Client_ID  = ").append(AD_Client_ID);
		sql.append(" ORDER BY p.C_OrderLine_ID");
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
			pstmt.setInt(1, C_OrderLine_ID);
			ResultSet rs = pstmt.executeQuery();
			//
			while (rs.next())
			{
				if((rs.getString(1) != null)){
					M_product = rs.getString(1).toString(); //  M_product
					p_QuickRegisterPanel.f_product.setM_Product_ID(Integer.valueOf(M_product));
				}
				//set attributeText
				if((rs.getString(2) != null)){
					attributeID = rs.getString(2).toString(); //  M_product
					if(p_QuickRegisterPanel.f_product.getComponent(2) instanceof  VPAttribute){
						VPAttribute attri = (VPAttribute)p_QuickRegisterPanel.f_product.getComponent(2);
							try {
								attri.setValue(Integer.valueOf(attributeID));
							} catch (Exception e) {
								e.printStackTrace();
							}
						
					}
					
				}
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql.toString(), e);
		}
	}
	

	public void keyPressed(KeyEvent e) {
	}
	public void keyReleased(KeyEvent e) {
		 if ((e.getSource() == f_up )&&(e.getKeyCode() == KeyEvent.VK_ENTER)){
			int rows = m_table.getRowCount();
			if (rows == 0){
				p_QuickRegisterPanel.f_product.f_name.requestFocus();
				return;
			}
			int row = m_table.getSelectedRow();
			row--;
			showCell(row,0);
			if (row < 0){
				p_QuickRegisterPanel.f_product.f_name.requestFocus();
				row = 0;
			}
			m_table.getSelectionModel().setSelectionInterval(row, row);
			m_table.getSelectionModel().getSelectionMode();
			clearValue();
		}
		else if ((e.getSource() == f_down )&&(e.getKeyCode() == KeyEvent.VK_ENTER))
		{
			int rows = m_table.getRowCount();
			if (rows == 0){
				p_QuickRegisterPanel.f_product.f_name.requestFocus();
				return;
				}
			int row = m_table.getSelectedRow();
			
			row++;
			showCell(row,0);
			if (row >= rows)
				row = rows - 1;
			m_table.getSelectionModel().setSelectionInterval(row, row);
			clearValue();
			setStatusValue();
		}
		 //Delete
		else if ((e.getSource() == f_delete )&&(e.getKeyCode() == KeyEvent.VK_ENTER))
		{
			int rows = m_table.getRowCount();
			if (rows != 0)
			{
				int row = m_table.getSelectedRow();
				if (row != -1)
				{
					MOrder order = p_QuickRegisterPanel.f_currentLine.getOrder();
					if( MOrder.DOCSTATUS_Drafted.equals(order.getDocStatus()) ){
						p_QuickRegisterPanel.f_currentLine.deleteLine(row);
						updateTable(p_QuickRegisterPanel.f_currentLine.getOrder());
						p_QuickRegisterPanel.updateInfo();
					}
					p_QuickRegisterPanel.f_lines.getM_table().getSelectionModel()
					.setSelectionInterval(row, row);
				}
				rows--;
				if(rows == row){
					row--;
					p_QuickRegisterPanel.f_lines.getM_table().getSelectionModel()
					.setSelectionInterval(row, row);
					return;
				}
			}else{
				p_QuickRegisterPanel.f_product.f_name.requestFocus();
			}			
		}
		else if((e.getKeyCode() == KeyEvent.VK_ENTER)&&(e.getSource() == f_bEdit)){
			int rows = m_table.getRowCount();
			if(rows > 0){
				enableButtons();
				p_QuickRegisterPanel.f_product.f_name.requestFocus();
				checkEdit = "1";
			}else {
				p_QuickRegisterPanel.f_product.f_name.requestFocus();
			}
		}
		else if(e.getKeyCode() == KeyEvent.VK_SPACE){
			enableButtons();
			int order_ID = p_QuickRegisterPanel.f_currentLine.getOrder().getC_Order_ID();
			String  dw = p_QuickRegisterPanel.f_orderlines.sqlCheckDR(Integer.valueOf(order_ID));
			if(dw.equals("CO")){
			}else{
			p_QuickRegisterPanel.f_product.f_name.requestFocus();
			checkEdit = "1";
			}
			return;
		}
		else if((e.getSource() == f_up)
				&&(e.getKeyCode() == KeyEvent.VK_DOWN)){
			f_bEdit.requestFocus();
		}
		else if((e.getSource() == f_bEdit)
				&&(e.getKeyCode() == KeyEvent.VK_DOWN)){
			f_delete.requestFocus();
		}
		else if((e.getSource() == f_delete)
				&&(e.getKeyCode() == KeyEvent.VK_DOWN)){
			f_down.requestFocus();
		}
		else if((e.getSource() == f_down)
				&&(e.getKeyCode() == KeyEvent.VK_UP)){
			f_delete.requestFocus();
		}
		else if((e.getSource() == f_delete)
				&&(e.getKeyCode() == KeyEvent.VK_UP)){
			f_bEdit.requestFocus();
		}
		else if((e.getSource() == f_bEdit)
				&&(e.getKeyCode() == KeyEvent.VK_UP)){
			f_up.requestFocus();
		}
		else if((e.getKeyCode() == KeyEvent.VK_UP)&&(e.getSource() == f_up)){
			p_QuickRegisterPanel.f_product.f_name.requestFocus();
			return;
		}
			setStatusValue();
	}
	public void setStatusValue()
	{
		int rows = m_table.getRowCount();
		if(rows > 0 ){
			int row = m_table.getSelectedRow();
			row ++;
			p_QuickRegisterPanel.f_status.setStatusDB( "[" +row + "/" + rows + "]");
		}else if(rows == 0 ){
			p_QuickRegisterPanel.f_status.setStatusDB( "[" +0 + "/" + rows + "]");
		}
		
	}

	public void keyTyped(KeyEvent e) {
	}
	
}	//	SubLines
