/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.quickregister;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.logging.Level;

import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

import org.compiere.apps.ADialog;
import org.compiere.framework.Query;
import org.compiere.grid.GridController;
import org.compiere.grid.ed.VButton;
import org.compiere.grid.ed.VDocAction;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.GridTab;
import org.compiere.model.GridWindow;
import org.compiere.model.GridWindowVO;
import org.compiere.model.GridWorkbench;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerInfo;
import org.compiere.model.MCurrency;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MOrder;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MRefList;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CLabel;
import org.compiere.swing.CTextArea;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;

/**
 *	QuickRegister Order Sub Panel
 *	
 *  @author Horcha
 *  @version $Id: SubOrder.java,v 1.3 2010/01/10 07:50:34 jrmt Exp $
 */
public class SubOrder extends QuickRegisterSubPanel 
	implements ActionListener, FocusListener,KeyListener 
{
	/**
	 * 	Constructor
	 *	@param quickRegisterPanel QuickRegister Panel
	 */
	public SubOrder (QuickRegisterPanel quickRegisterPanel)
	{
		super (quickRegisterPanel);
	}	//	SubOrder

	protected	CTextField		f_orderNo;
	private MOrder m_order = null;
	protected CTextField f_customerNo;
	protected	VLookup		f_docmentType;
	
	protected	CTextArea	f_descreption;
//	protected CButton f_complete;
	protected VButton f_complete;
	
	private CLabel f_orderNolabel;
	private CLabel f_descreptionlabel;
	private CLabel f_customerlabel;
	private CLabel f_documetlabel;
    /** BPartner Query Window       */
    private QuickRegisterBPartner f_queryBPartner = new QuickRegisterBPartner (p_QuickRegisterPanel);
	/**	The Business Partner		*/
	private MBPartner	m_bpartner;
	/**	Price List Version to use	*/
	private int			m_M_PriceList_Version_ID = 0;
	/**	Window No			*/
	private int				m_C_BPartner_ID;
	private Object 			m_AD_Org_ID = null;
	protected int 			m_C_Order_ID ;
	protected GridWindowVO wVO = null; // Sales Order
	protected GridWindow mWindow = null;
	protected GridTab m_curTab = null;
	protected GridController gc = null;	//  Timing: ca. .1 sec
	protected CompiereColor cc = null;
	protected StringBuffer sbStart = null;
	protected StringBuffer sbEnd = null;
	protected StringBuffer sbCustomerStart = null;
	protected StringBuffer sbCustomerEnd = null;
	/** Workbench Model                                 */
	private GridWorkbench	m_mWorkbench;
	
	/**	Logger			*/
	private static CLogger log = CLogger.getCLogger(SubOrder.class);
	
	/**
	 * 	Initialize
	 */
	public void init()
	{
		//	Title
		TitledBorder border = new TitledBorder(Msg.translate(p_ctx, "C_Order_ID"));
		setBorder(border);
		
		//	Content
		setLayout(new GridBagLayout());
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.insets = INSETS2;
		gbc.gridy = 0;
		
		//	--
		f_orderNolabel = new CLabel();
		f_orderNolabel.setText(Msg.translate(Env.getCtx(), "C_Order_ID")+"No");
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.weightx = 0;
		add(f_orderNolabel, gbc);
		
		//
		f_orderNo = new CTextField(10);
		f_orderNo.setPreferredSize(new Dimension(70, 20));
		f_orderNo.setName("orderNo");
//		f_orderNo.setReadWrite(false);
		f_orderNo.setEditable(false);
//		f_orderNo.setSize(new Dimension(80, 20));
		gbc.gridx = 1;
		gbc.gridy = 0;
		gbc.gridheight = 1;
		gbc.gridwidth = 1;
		gbc.weightx = 0;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		add (f_orderNo, gbc);
		
//		--
		f_customerlabel = new CLabel();
		f_customerlabel.setText(Msg.translate(Env.getCtx(), "POReference"));
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.gridx = 2;
		gbc.gridy = 0;
		gbc.weightx = 0;
		add(f_customerlabel, gbc);
//		--
//		fBPartner = new VLookup ("C_BPartner_ID", false, false, true, bpL);
		f_customerNo  = new CTextField(10);
		f_customerNo.setPreferredSize(new Dimension(70, 20));
		f_customerNo.setName("customerNo");
//		fBPartner.setReadWrite(false);
		f_customerNo.setEditable(false);
		f_customerNo.addFocusListener(this);
//		fBPartner.setSize(new Dimension(100, 20));
		gbc.gridx = 3;
		gbc.gridy = 0;
		gbc.gridheight = 1;
		gbc.gridwidth = 1;
		gbc.weightx = 0;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		add (f_customerNo, gbc);
		
//		--
		f_documetlabel = new CLabel();
		f_documetlabel.setText(Msg.translate(Env.getCtx(), "C_DocType_ID"));
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.gridx = 4;
		gbc.gridy = 0;
		gbc.weightx = 0;
		add(f_documetlabel, gbc);
		
		MLookup orgL = MLookupFactory.get (Env.getCtx(), p_QuickRegisterPanel.m_WindowNo, 2173, DisplayType.Table);
		f_docmentType = new VLookup ("C_DocTypeTarget_ID", true, false, true, orgL);
		f_docmentType.setPreferredSize(new Dimension(100, 20));
		f_docmentType.setName("docmentType");
		f_docmentType.setReadWrite(false);
		gbc.gridx = 5;
		gbc.gridy = 0;
		gbc.gridheight = 1;
		gbc.gridwidth = 1;
		gbc.weightx = 0;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		add (f_docmentType, gbc);
//		--
		f_descreptionlabel = new CLabel();
		
		f_descreptionlabel.setText(Msg.translate(Env.getCtx(), "Description"));
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		
		gbc.gridx = 0;
		gbc.gridy = 1;
		gbc.gridwidth = 1;
		gbc.weightx = 1;
		add(f_descreptionlabel, gbc);
		
		
		f_descreption = new CTextArea();
		f_descreption.setPreferredSize(new Dimension(300, 40));
		f_descreption.setName("descreption");
		f_descreption.addKeyListener(this);
		f_descreption.addFocusListener(this);

		f_descreption.setReadWrite(true);
		gbc.gridx = 1;
		gbc.gridy = 1;
		gbc.gridheight = 2;
		gbc.gridwidth = 4;
		gbc.weightx = 3;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.anchor = GridBagConstraints.WEST;
		add (f_descreption, gbc); 
		//
		MRefList buttonRef = new MRefList(p_QuickRegisterPanel.m_ctx,131,null);
		f_complete = new VButton("DocAction",true,false,true,buttonRef.getListName(p_QuickRegisterPanel.m_ctx,135,"PR"),"","",104);
		f_complete.setActionCommand("complete");
		f_complete.addKeyListener(this);
		f_complete.addActionListener(this);
		gbc.gridx = 5;
		gbc.gridy = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.NONE;
		gbc.weightx = 0;
		add (f_complete, gbc);
	}	//	init
	public void setF_orderNo(CTextField no) {
		f_orderNo = no;
	}

	/**
	 * 	Dispose - Free Resources
	 */
	public void dispose()
	{
		if (f_orderNo != null)
			f_orderNo.removeFocusListener(this);
		f_orderNo = null;
		removeAll();
		super.dispose();
	}	//	dispose

	/**************************************************************************
	 * 	Action Listener
	 *	@param e event
	 */
	public void actionPerformed (ActionEvent e)
	{
		String action = e.getActionCommand();
		if (action == null || action.length() == 0)
			return;
		log.info( "SubOrder - actionPerformed: " + action);
		//	New
		if (action.equals("complete")){
			boolean startWOasking = false;
			boolean batch = false;
			wVO = GridWindowVO.create(p_QuickRegisterPanel.m_ctx, p_QuickRegisterPanel.m_WindowNo, 143); // Sales Order
			mWindow = new GridWindow (wVO);
			m_curTab = mWindow.getTab(0);
			m_curTab.query(1);
			
			int  m_C_Order_ID = p_QuickRegisterPanel.f_orderline.m_C_Order_ID;
			MOrder order = new MOrder(p_QuickRegisterPanel.m_ctx, m_C_Order_ID,null);
			Query query = Query.getEqualQuery ("C_Order_ID", m_C_Order_ID);
			m_curTab.setQuery(query);
			m_curTab.dataRefresh();
			m_curTab.setValue("DocStatus", order.getDocStatus());
			m_curTab.setValue("DocAction", order.getDocAction());
			//docStatus
			VDocAction vda = new VDocAction(p_QuickRegisterPanel.m_WindowNo, m_curTab, f_complete, m_C_Order_ID);
				//Something to select from?
			if (vda.getNumberOfOptions() == 0)
			{
				vda.dispose ();
				log.info("DocAction - No Options");
				return;
			}
			else
			{
				vda.setVisible(true);
				if (!vda.isStartProcess())
					return;
				batch = vda.isBatch();
				startWOasking = true;
				vda.dispose();
			}
			String DocAction = (String)m_curTab.getValue("DocAction");
			order.setDocAction(DocAction);
			order.processIt(DocAction);
			order.save();
			MRefList ref = new MRefList(p_QuickRegisterPanel.m_ctx,135,null);
			String strComplete = "";
			String strDocStuts = "";
			if(DocAction.equals("CO")){
				strComplete =  ref.getListName(p_QuickRegisterPanel.m_ctx,135,"CO");
				strDocStuts = ref.getListName(p_QuickRegisterPanel.m_ctx,131,"CO");
			}else if(DocAction.equals("PR")){
				strComplete = ref.getListName(p_QuickRegisterPanel.m_ctx,135,"PR");
				strDocStuts = ref.getListName(p_QuickRegisterPanel.m_ctx,131,"IP");
			}else if(DocAction.equals("CL")){
				strComplete = ref.getListName(p_QuickRegisterPanel.m_ctx,135,"CL");
				strDocStuts = ref.getListName(p_QuickRegisterPanel.m_ctx,131,"DR");
			}else if(DocAction.equals("VO")){
				strComplete = ref.getListName(p_QuickRegisterPanel.m_ctx,135,"--");
				strDocStuts = ref.getListName(p_QuickRegisterPanel.m_ctx,131,"VO");
			}
			f_complete.setText(strComplete);
			

			p_QuickRegisterPanel.f_lines.f_docStatus.setValue(strDocStuts);
			p_QuickRegisterPanel.f_product.f_name.setEnabled(false);
			p_QuickRegisterPanel.f_product.f_bSearch.setEnabled(false);
			p_QuickRegisterPanel.f_bpartner.f_name.setEnabled(false);
			p_QuickRegisterPanel.f_bpartner.f_bSearch.setEnabled(false);
			p_QuickRegisterPanel.f_bpartner.f_location.setEnabled(false);
			p_QuickRegisterPanel.f_bpartner.f_user.setEnabled(false);
			p_QuickRegisterPanel.f_currentLine.f_new.setEnabled(false);
			p_QuickRegisterPanel.f_quickRegisterMenu.aSave.setEnabled(false);
			p_QuickRegisterPanel.f_lines.f_delete.setEnabled(false);
		}
		else if(action.equals("descreption")){
			f_complete.requestFocus();	
		} else if (action.equals("Edit"))
		{
		}
		//	BPartner
		else if (action.equals("BPartner"))
		{
		}
		//	Name
		else if (e.getSource() == f_orderNo)
			findBPartner();
	}	//	actionPerformed
	/**
	 * 	Focus Gained
	 *	@param e
	 */
	public void focusGained (FocusEvent e)
	{
		if (e.isTemporary())
			return;
		else{
			if( e.getSource() instanceof  CTextField ) {
				 sbCustomerStart = new StringBuffer("");
				if((f_customerNo != null) && (!f_customerNo.getValue().toString().equals(""))){
					sbCustomerStart.append(f_customerNo.getValue().toString());
				}
			}
			if( e.getSource() instanceof  JTextArea ) {
				 sbStart = new StringBuffer("");
				if((f_descreption != null) && (!f_descreption.getValue().toString().equals(""))){
					sbStart.append(f_descreption.getValue().toString());
				}
			}
		}
		p_QuickRegisterPanel.f_bpartner.f_bNew.setEnabled(false);
		p_QuickRegisterPanel.f_bpartner.f_bEdit.setEnabled(false);
		p_QuickRegisterPanel.f_quickRegisterMenu.aNew.setEnabled(true);
		p_QuickRegisterPanel.f_currentLine.f_new.setEnabled(false);
		p_QuickRegisterPanel.f_quickRegisterMenu.aSave.setEnabled(true);
	}	//	focusGained

	/**
	 * 	Focus Lost
	 *	@param e
	 */
	public void focusLost (FocusEvent e)
	{
		if (e.isTemporary())
			return;
		else{
			if( e.getSource() instanceof  CTextField ) {
				 sbCustomerEnd = new StringBuffer("");
				if((f_customerNo != null) && (!f_customerNo.getValue().toString().equals(""))){
					sbCustomerEnd.append(f_customerNo.getValue().toString());
					p_QuickRegisterPanel.f_quickRegisterMenu.aSave.setEnabled(true);
					if(!sbCustomerStart.toString().equals(sbCustomerEnd.toString()))
						p_QuickRegisterPanel.f_quickRegisterMenu.aSave.setEnabled(true);
				}
			}
			if( e.getSource() instanceof  JTextArea ) {
				 sbEnd = new StringBuffer("");
				if((f_descreption != null) && (!f_descreption.getValue().toString().equals(""))){
					sbEnd.append(f_descreption.getValue().toString());
					p_QuickRegisterPanel.f_quickRegisterMenu.aSave.setEnabled(true);
					if(!sbEnd.toString().equals(sbStart.toString()))
						p_QuickRegisterPanel.f_quickRegisterMenu.aSave.setEnabled(true);
				}
			}
				
		}
		
	}	//	focusLost
	
	/**
	 * 	then new order save or updata order 
	 *	@param e
	 */
	public void orderUpdate ()
	{
		 m_order = null;
//		Trx trx = Trx.get(Trx.createTrxName("AL"), true);
		int orderId = p_QuickRegisterPanel.f_currentLine.getOrder().getC_Order_ID();
		if (orderId > 0){
			p_QuickRegisterPanel.f_currentLine.getOrder().setDescription((String)f_descreption.getText());
			p_QuickRegisterPanel.f_currentLine.getOrder().setPOReference(f_customerNo.getValue().toString());
			boolean retValue = p_QuickRegisterPanel.f_currentLine.getOrder().save();
			if ( !retValue )
			{
				ADialog.error(p_QuickRegisterPanel.m_WindowNo, this, "SaveIgnored");
				p_QuickRegisterPanel.f_status.setStatusLine(Msg.getMsg(p_QuickRegisterPanel.m_ctx, "SaveIgnored"), true);
			}
			if ( retValue )
			{
				p_QuickRegisterPanel.f_status.setStatusLine(Msg.getMsg(p_QuickRegisterPanel.m_ctx, "Save"));
				p_QuickRegisterPanel.f_quickRegisterMenu.aNew.setEnabled(true);
			}
			
			p_QuickRegisterPanel.f_orderlines.updateTable(p_QuickRegisterPanel.f_currentLine.getOrder());
			MOrder order = p_QuickRegisterPanel.f_currentLine.getOrder();
				
				if (order.getAD_Org_ID() != 0)
					m_AD_Org_ID = order.getAD_Org_ID();
				if (order.getC_BPartner_ID() != 0)
				{
					m_C_BPartner_ID = order.getC_BPartner_ID();
				}
				if (order.getC_Order_ID()!=0)
				{
					m_C_Order_ID = order.getC_Order_ID();
				}
				
//				executeQuery();
				order = p_QuickRegisterPanel.f_currentLine.getOrder();
				p_QuickRegisterPanel.f_orderline.getF_orderNo().setValue(order.getDocumentNo());
				p_QuickRegisterPanel.f_orderline.getFBPartner().setValue(order.getPOReference());
				p_QuickRegisterPanel.f_orderline.f_descreption.setValue(order.getDescription());
				p_QuickRegisterPanel.f_lines.f_docStatus.setValue(order.getDocStatusName());
				p_QuickRegisterPanel.f_product.f_name.setValue("");
				
				m_order = null;
				return;
			
		}else{
			return;
		}
		
		
	}	//	focusLost
	/**
	 * 	then old order save or updata order 
	 *	@param e
	 */
	public void oldOrderUpdate ()
	{
		 p_QuickRegisterPanel.f_currentLine.getOrder().setC_Order_ID(m_C_Order_ID);
		if (m_C_Order_ID > 0){
			p_QuickRegisterPanel.f_currentLine.getOrder().setDescription((String)f_descreption.getText());
			p_QuickRegisterPanel.f_currentLine.getOrder().setPOReference(f_customerNo.getValue().toString());
			boolean retValue = p_QuickRegisterPanel.f_currentLine.getOrder().save();
			if ( !retValue )
			{
				ADialog.error(p_QuickRegisterPanel.m_WindowNo, this, "SaveIgnored");
				p_QuickRegisterPanel.f_status.setStatusLine(Msg.getMsg(p_QuickRegisterPanel.m_ctx, "SaveIgnored"), true);
			}
			if ( retValue )
			{
				p_QuickRegisterPanel.f_status.setStatusLine(Msg.getMsg(p_QuickRegisterPanel.m_ctx, "Save"));
				p_QuickRegisterPanel.f_quickRegisterMenu.aNew.setEnabled(true);
			}
			
//			
				p_QuickRegisterPanel.f_product.f_name.setValue("");
				
				m_order = null;
				return;
			
		}else{
			return;
		}
		
		
	}	//	focusLost
	
	
	public VLookup getF_docmentType() {
		return f_docmentType;
	}


	public void setF_docmentType(VLookup type) {
		f_docmentType = type;
	}


	/**
	 * 	Find/Set BPartner
	 */
	private void findBPartner()
	{
		String query = f_orderNo.getText();
		if (query == null || query.length() == 0)
			return;
		query = query.toUpperCase();
		//	Test Number
		boolean allNumber = true;
		boolean noNumber = true;
		char[] qq = query.toCharArray();
		for (int i = 0; i < qq.length; i++)
		{
			if (Character.isDigit(qq[i]))
			{
				noNumber = false;
				break;
			}
		}
		try
		{
			Integer.parseInt(query);
		}
		catch (Exception e)
		{
			allNumber = false;
		}
		String Value = query;
		String Name = (allNumber ? null : query);
		String Contact = (allNumber ? null : query);
		String EMail = (query.indexOf("@") != -1 ? query : null); 
		String Phone = (noNumber ? null : query);
		String City = null;
		//
		MBPartnerInfo[] results = MBPartnerInfo.find(p_ctx, Value, Name, 
			Contact, EMail, Phone, City);
		
		//	Set Result
		if (results.length == 0)
		{
			setC_BPartner_ID(0);
		}
		else if (results.length == 1)
		{
			setC_BPartner_ID(results[0].getC_BPartner_ID());
			f_orderNo.setText(results[0].getName());
		}
		else	//	more than one
		{
			f_queryBPartner.setResults (results);
			p_QuickRegisterPanel.openQuery(f_queryBPartner);
		}
	}	//	findBPartner
	
	
	/**************************************************************************
	 * 	Set BPartner
	 *	@param C_BPartner_ID id
	 */
	public void setC_BPartner_ID (int C_BPartner_ID)
	{
		log.fine( "SubOrder.setC_BPartner_ID=" + C_BPartner_ID);
		if (C_BPartner_ID == 0)
			m_bpartner = null;
		else
		{
			m_bpartner = new MBPartner(p_ctx, C_BPartner_ID, null);
			if (m_bpartner.get_ID() == 0)
				m_bpartner = null;
		}
		
		//	Set Info
		if (m_bpartner != null)
		{
			f_orderNo.setText(m_bpartner.getName());
		}
		else
		{
			f_orderNo.setText(null);
		}
		//	Sets Currency
		m_M_PriceList_Version_ID = 0;
		getM_PriceList_Version_ID();
		p_QuickRegisterPanel.f_currentLine.setBPartner(); 
	}	//	setC_BPartner_ID

	/**
	 * 	Get BPartner
	 *	@return C_BPartner_ID
	 */
	public int getC_BPartner_ID ()
	{
		if (m_bpartner != null)
			return m_bpartner.getC_BPartner_ID();
		return 0;
	}	//	getC_BPartner_ID

	/**
	 * 	Get BPartner
	 *	@return BPartner
	 */
	public MBPartner getBPartner ()
	{
		return m_bpartner;
	}	//	getBPartner
	public CTextField getFBPartner() {
		return f_customerNo;
	}
	public void setFBPartner(CTextField partner) {
		f_customerNo = partner;
	}

	/**
	 * 	Get M_PriceList_Version_ID.
	 * 	Set Currency
	 *	@return plv
	 */
	public int getM_PriceList_Version_ID()
	{
		if (m_M_PriceList_Version_ID == 0)
		{
			int M_PriceList_ID = p_QuickRegister.getM_PriceList_ID();
			if (m_bpartner != null && m_bpartner.getM_PriceList_ID() != 0)
				M_PriceList_ID = m_bpartner.getM_PriceList_ID();
			//
			MPriceList pl = MPriceList.get(p_ctx, M_PriceList_ID, null);
			p_QuickRegisterPanel.f_currentLine.setCurrency(MCurrency.getISO_Code(p_ctx, pl.getC_Currency_ID()));
			p_QuickRegisterPanel.setCurrencyPrecision(MCurrency.getStdPrecision(p_ctx, pl.getC_Currency_ID()));
			f_orderNo.setToolTipText(pl.getName());
			//
			MPriceListVersion plv = pl.getPriceListVersion (p_QuickRegisterPanel.getToday());
			if (plv != null && plv.getM_PriceList_Version_ID() != 0)
				m_M_PriceList_Version_ID = plv.getM_PriceList_Version_ID();
		}
		return m_M_PriceList_Version_ID;
	}	//	getM_PriceList_Version_ID

	public void keyPressed(KeyEvent e) {
	}

	public void keyReleased(KeyEvent e) {
		if((e.getKeyCode() == KeyEvent.VK_ENTER ) &&
				(e.getSource() == f_complete)){
			boolean startWOasking = false;
			boolean batch = false;
			wVO = GridWindowVO.create(p_QuickRegisterPanel.m_ctx, p_QuickRegisterPanel.m_WindowNo, 143); // Sales Order
			mWindow = new GridWindow (wVO);
			m_curTab = mWindow.getTab(0);
			m_curTab.query(1);
			
			int  m_C_Order_ID = p_QuickRegisterPanel.f_orderline.m_C_Order_ID;
			MOrder order = new MOrder(p_QuickRegisterPanel.m_ctx, m_C_Order_ID,null);
			Query query = Query.getEqualQuery ("C_Order_ID", m_C_Order_ID);
			m_curTab.setQuery(query);
			m_curTab.dataRefresh();
			m_curTab.setValue("DocStatus", order.getDocStatus());
			m_curTab.setValue("DocAction", order.getDocAction());
			//docStatus
			VDocAction vda = new VDocAction(p_QuickRegisterPanel.m_WindowNo, m_curTab, f_complete, m_C_Order_ID);
				//Something to select from?
			if (vda.getNumberOfOptions() == 0)
			{
				vda.dispose ();
				log.info("DocAction - No Options");
				return;
			}
			else
			{
				vda.setVisible(true);
				if (!vda.isStartProcess())
					return;
				batch = vda.isBatch();
				startWOasking = true;
				vda.dispose();
			}
			String DocAction = (String)m_curTab.getValue("DocAction");
			order.setDocAction(DocAction);
			order.processIt(DocAction);
			order.save();
			MRefList ref = new MRefList(p_QuickRegisterPanel.m_ctx,135,null);
			String strCo = "";
			String strDoc = "";
			if(DocAction.equals("CO")){
				strCo =  ref.getListName(p_QuickRegisterPanel.m_ctx,135,"CO");
				strDoc = ref.getListName(p_QuickRegisterPanel.m_ctx,131,"CO");
			}else if(DocAction.equals("PR")){
				strCo = ref.getListName(p_QuickRegisterPanel.m_ctx,135,"PR");
				strDoc = ref.getListName(p_QuickRegisterPanel.m_ctx,131,"IP");
			}else if(DocAction.equals("CL")){
				strCo = ref.getListName(p_QuickRegisterPanel.m_ctx,135,"CL");
				strDoc = ref.getListName(p_QuickRegisterPanel.m_ctx,131,"DR");
			}else if(DocAction.equals("VO")){
				strCo = ref.getListName(p_QuickRegisterPanel.m_ctx,135,"--");
				strDoc = ref.getListName(p_QuickRegisterPanel.m_ctx,131,"VO");
			}
			f_complete.setText(strCo);
			p_QuickRegisterPanel.f_lines.f_docStatus.setValue(strDoc);
//			 orderUpdate();
			p_QuickRegisterPanel.f_product.f_name.setEnabled(false);
			p_QuickRegisterPanel.f_product.f_bSearch.setEnabled(false);
			p_QuickRegisterPanel.f_bpartner.f_name.setEnabled(false);
			p_QuickRegisterPanel.f_bpartner.f_bSearch.setEnabled(false);
			p_QuickRegisterPanel.f_bpartner.f_location.setEnabled(false);
			p_QuickRegisterPanel.f_bpartner.f_user.setEnabled(false);
			p_QuickRegisterPanel.f_currentLine.f_new.setEnabled(false);
			p_QuickRegisterPanel.f_quickRegisterMenu.aSave.setEnabled(false);
			p_QuickRegisterPanel.f_lines.f_delete.setEnabled(false);
		}
		 
		else if((e.getKeyCode() == KeyEvent.VK_RIGHT) &&(e.getSource()instanceof JTextArea)&&(f_descreption.getValue().equals(""))){
			f_complete.requestFocus();
		}
		else if((e.getKeyCode() == KeyEvent.VK_LEFT )&&(e.getSource()==f_complete)){
			f_descreption.requestFocus();
		}
		else if((e.getKeyCode() == KeyEvent.VK_LEFT )&&(e.getSource() instanceof JTextArea)&&(f_descreption.getValue().equals(""))){
			p_QuickRegisterPanel.f_bpartner.f_bSearch.requestFocus();
			p_QuickRegisterPanel.f_bpartner.f_bNew.setEnabled(true);
			p_QuickRegisterPanel.f_bpartner.f_bEdit.setEnabled(true);
			p_QuickRegisterPanel.f_quickRegisterMenu.aNew.setEnabled(false);
		}
	}

	public void keyTyped(KeyEvent e) {
	}
	public CTextField getF_orderNo() {
		return f_orderNo;
	}
	/**
	 * Save Line
	 * 
	 * @return true if saved
	 */
	public boolean saveOrderLine() {
		MOrder product = getOrder();
		if (product == null)
			return false;
		String orderNo =  p_QuickRegisterPanel.f_orderline.f_orderNo.getValue().toString();
		String bpantner = p_QuickRegisterPanel.f_orderline.f_customerNo.getValue().toString();
		String docType = p_QuickRegisterPanel.f_orderline.f_docmentType.getValue().toString();
		String docStatus = p_QuickRegisterPanel.f_lines.f_docStatus.getValue().toString();
//		MOrderLine line = createOrderLines(orderNo, bpantner, docType,docStatus);
		newOrderLine();
		return true;
		
	} // saveLine
	public void newOrderLine() {
		p_QuickRegisterPanel.f_orderlines.updateTable(m_order);

	} // newLine
	/**
	 * Get/create Header
	 * 
	 * @return header or null
	 */
	public MOrder getOrder() {
		if (m_order == null) {
			m_order = new MOrder(Env.getCtx(), 0, null);
			m_order.setAD_Org_ID(p_QuickRegister.getAD_Org_ID());
			m_order.setIsSOTrx(true);
			if (p_QuickRegister.getC_DocType_ID() != 0)
				m_order.setC_DocTypeTarget_ID(p_QuickRegister.getC_DocType_ID());
			else
				m_order.setC_DocTypeTarget_ID(MOrder.DocSubTypeSO_POS);
			MBPartner partner = p_QuickRegisterPanel.f_bpartner.getBPartner();
			if (partner == null || partner.get_ID() == 0)
				partner = p_QuickRegister.getBPartner();
			if (partner == null || partner.get_ID() == 0) {
				log.log(Level.SEVERE, "SubCurrentLine.getOrder - no BPartner");
				return null;
			}
			log.info("SubCurrentLine.getOrder -" + partner);
			m_order.setBPartner(partner);
			int id = p_QuickRegisterPanel.f_bpartner.getC_BPartner_Location_ID();
			if (id != 0)
				m_order.setC_BPartner_Location_ID(id);
			id = p_QuickRegisterPanel.f_bpartner.getAD_User_ID();
			if (id != 0)
				m_order.setAD_User_ID(id);
			//
			m_order.setM_PriceList_ID(p_QuickRegister.getM_PriceList_ID());
			m_order.setM_Warehouse_ID(p_QuickRegister.getM_Warehouse_ID());
			m_order.setSalesRep_ID(p_QuickRegister.getSalesRep_ID());
			if (!m_order.save())
				m_order = null;
		}
		return m_order;
	} // getHeader

	public void dataStatusChanged(DataStatusEvent e) {
		
	}
	public void vetoableChange(PropertyChangeEvent evt)
			throws PropertyVetoException {
		p_QuickRegisterPanel.f_quickRegisterMenu.aSave.setEnabled(true);
		
	}
	public void mouseClicked(MouseEvent e) {
		
	}
	public void mouseEntered(MouseEvent e) {
		
	}

	public void mouseExited(MouseEvent e) {
		
	}

	public void mousePressed(MouseEvent e) {
		
	}

	public void mouseReleased(MouseEvent e) {
		
	}
	
}	//	SubOrder
