/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.quickregister;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;

import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import org.compiere.framework.PO;
import org.compiere.framework.Query;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MOrder;
import org.compiere.model.MRefList;
import org.compiere.swing.CScrollPane;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

/**
 *	QuickRegister All OrderLines Sub Panel
 *	
 *  @author Horcha
 *  @version $Id: SubOrderLines.java,v 1.3 2010/01/10 07:50:34 jrmt Exp $
 */
public class SubOrderLines extends QuickRegisterSubPanel implements ActionListener, 
		MouseListener, ListSelectionListener,KeyListener
{
	/**
	 * 	Constructor
	 *	@param quickRegisterPanel QuickRegister Panel
	 */
	public SubOrderLines (QuickRegisterPanel quickRegisterPanel)
	{
		super (quickRegisterPanel);
	}	//	SubLines
	
	/** The Table					*/
	protected MiniTable	m_table;
	private int	m_M_Product_ID;
	protected int m_Line_ID;
	protected int checkup = 0;
	protected CScrollPane scroll;
	protected String  checkEdit = "0";
	/** mouse decide inter */
	protected int checkClick = 0;
	/** The Query SQL				*/
	private String			m_sql;
	/**	Logger			*/
	private static CLogger log = CLogger.getCLogger(SubOrderLines.class);
	private Object 			m_C_Order_ID = null;
	protected CTextField f_docStatus ;
	/**	Table Column Layout Info	*/
	private static ColumnInfo[] s_layout = new ColumnInfo[] 
	{
		new ColumnInfo("", "C_Order_ID", IDColumn.class),
		new ColumnInfo(Msg.translate(Env.getCtx(), "DOCUMENTNO"), "DocumentNo", String.class),
		new ColumnInfo(Msg.translate(Env.getCtx(), "C_DOCTYPE_ID"), "C_DOCTYPENAME", String.class), 
		new ColumnInfo(Msg.translate(Env.getCtx(), "DATEORDERED"), "DATEORDERED", String.class),
		new ColumnInfo(Msg.translate(Env.getCtx(), "C_BPARTNER_ID"), "C_BPARTNERNAME", String.class),
		new ColumnInfo(Msg.translate(Env.getCtx(), "C_BPartner_Location_ID"), "C_BPARTNER_LOCATIONNAME", String.class),
		new ColumnInfo(Msg.translate(Env.getCtx(), "POREFERENCE"), "POReference", String.class), 
		new ColumnInfo(Msg.translate(Env.getCtx(), "PAYMENTTERM"), "PAYMENTRULENAME", String.class),
		new ColumnInfo(Msg.translate(Env.getCtx(), "DOCSTATUS"), "DOCSTATUSNAME", String.class), 
		new ColumnInfo(Msg.translate(Env.getCtx(), "GRANDTOTAL"), "GrandTotal", BigDecimal.class),
		new ColumnInfo(Msg.translate(Env.getCtx(), "M_Warehouse_ID"), "M_WAREHOUSENAME", String.class),
		new ColumnInfo(Msg.translate(Env.getCtx(), "Description"), "Description", String.class)
	};
	/**	From Clause							*/
	private static String s_sqlFrom_Base = "C_ORDER_QUICKREGISTER_V";
	private static String s_sqlFrom_Other = "C_ORDER_QUICKREGISTER_VT";
	/** Where Clause						*/
	private static String s_sqlWhere = " 1=1 "; 

	/**
	 * 	Initialize
	 */
	public void init()
	{
		//	Title
		TitledBorder border = new TitledBorder(Msg.translate(Env.getCtx(), "C_Order_ID"));
		setBorder(border);
		//	Content
		setLayout(new BorderLayout(5, 5));
		
		m_table = new MiniTable();
		 scroll = new CScrollPane(m_table);
		String AD_Language = Env.getAD_Language(Env.getCtx());
		if( "en_US".equals(AD_Language))
			m_sql = m_table.prepareTable (s_layout, s_sqlFrom_Base, 
			s_sqlWhere, false, "C_ORDER_QUICKREGISTER_V");
		else {
			s_sqlWhere = s_sqlWhere + " AND AD_Language='"+AD_Language+"' ";
			m_sql = m_table.prepareTable (s_layout, s_sqlFrom_Other, 
					s_sqlWhere, false, "C_ORDER_QUICKREGISTER_VT");
		}
		m_table.setRowSelectionAllowed(true);
		m_table.setColumnSelectionAllowed(false);
		m_table.setMultiSelection(false);
		m_table.addMouseListener(this);
		m_table.addKeyListener(this);
		scroll.setPreferredSize(new Dimension(100,100));
		add (scroll, BorderLayout.CENTER);
	}	//	init
	
	/**
	 * 	Dispose - Free Resources
	 */
	public void dispose()
	{
		super.dispose();
	}	//	dispose
	
	/**
	 * 	Action Listener
	 *	@param e event
	 */
	public void actionPerformed (ActionEvent e)
	{
		String action = e.getActionCommand();
		if (action == null || action.length() == 0)
			return;
	}	//	actionPerformed
	
	/**
	 * 	Table selection changed
	 *	@param e event
	 */
	public void valueChanged (ListSelectionEvent e)
	{
		if (e.getValueIsAdjusting())
			return;
		if ( m_table.getSelectedRow() != -1 )
		{
			m_table.setMultiSelection(true);
			setStatusValue();
		}
	}	//	valueChanged

	/**
	 *  Mouse Clicked
	 *  @param e event
	 */
	public void mouseClicked(MouseEvent e)
	{}   //  mouseClicked

	public void mouseEntered (MouseEvent e) {
		
		m_table.addMouseListener(new MouseAdapter() { 
			public void mouseClicked(MouseEvent evt) { 
			
				if ((evt.getClickCount() == 2)&& (m_table.getSelectedRow() != -1)) {
						setValue();
						clearValue();
						return;
					}
			}
		});
	}
	public void mouseExited (MouseEvent e) {}
	public void mousePressed (MouseEvent e) {
		setStatusValue();
	}
	public void mouseReleased (MouseEvent e) {
	}
	
	/**
	 * 	Update Table
	 *	@param order order
	 */
	public void updateTable (MOrder order)
	{
		int C_Order_ID = 0;
		int C_BPARTNER_ID = 0;
		if (order != null)
			C_BPARTNER_ID = order.getC_BPartner_ID();

		if (C_Order_ID == 0)
		{
			m_table.loadTable(new PO[0]);
			
//			setSums(order);
		}
		
		PreparedStatement pstmt = null;
		try
		{
			StringBuffer sql = new StringBuffer(m_sql);
			sql.append(" and rownum <=5000 ");
			pstmt = DB.prepareStatement (sql.toString(), null);
			ResultSet rs = pstmt.executeQuery ();
			m_table.loadTable(rs);
			
			rs.close ();
			pstmt.close ();
			pstmt = null;
			
		}
		catch (Exception e)
		{
			log.log(Level.SEVERE, m_sql, e);
		}
		try
		{
			if (pstmt != null)
				pstmt.close ();
			pstmt = null;
		}
		catch (Exception e)
		{
			pstmt = null;
		}
		
		
	}	//	updateTable
	
	/**
	 * 	Update Table
	 *	@param order order
	 */
	public void updateTable (Query query )
	{
		
		PreparedStatement pstmt = null;
		try
		{
			StringBuffer sql = new StringBuffer(m_sql);
			if (query != null ){ //&& query.isActive()
				if(!query.getWhereClause().equals("")){
				sql.append(" and ");
				sql.append(query.getWhereClause().toString());
				}
			}
			pstmt = DB.prepareStatement (sql.toString(), null);
			ResultSet rs = pstmt.executeQuery ();
			m_table.loadTable(rs);
//			
			rs.close ();
			pstmt.close ();
			pstmt = null;
			
		}
		catch (Exception e)
		{
			log.log(Level.SEVERE, m_sql, e);
		}
		try
		{
			if (pstmt != null)
				pstmt.close ();
			pstmt = null;
		}
		catch (Exception e)
		{
			pstmt = null;
		}
		
		
	}	//	updateTable
	
	/**
	 * 	Update Table
	 *	@param order order
	 */
	public void delete_Order (String order_ID)
	{
		int C_Order_ID = 0;
		if (order_ID != null){
			C_Order_ID = Integer.valueOf(order_ID);
		
			PreparedStatement pstmt = null;
			try
			{
				pstmt = DB.prepareStatement (m_sql, null);
				pstmt.setInt (1, C_Order_ID);
				ResultSet rs = pstmt.executeQuery ();
				m_table.loadTable(rs);
				rs.close ();
				pstmt.close ();
				pstmt = null;
				
			}
			catch (Exception e)
			{
				log.log(Level.SEVERE, m_sql, e);
			}
			try
			{
				if (pstmt != null)
					pstmt.close ();
				pstmt = null;
			}
			catch (Exception e)
			{
				pstmt = null;
			}
		}
		
		
	}	//	updateTable
	
	/**
	 *  Query Info
	 */
	public String sqlCheckDR(int C_Order_ID)
	{
		
		
		log.info("");
		int AD_Client_ID = Env.getCtx().getAD_Client_ID();
		String dw ="";
		m_C_Order_ID =  C_Order_ID;
		//  Create SQL
		StringBuffer sql = new StringBuffer(
			"SELECT C_Order_ID, ic.DocStatus, DocumentNo, bp.Name "
			+ "FROM C_ORDER ic, AD_Org o, C_BPartner bp, C_DocType dt "
			+ "WHERE ic.AD_Org_ID=o.AD_Org_ID"
			+ " AND ic.C_BPartner_ID=bp.C_BPartner_ID"
			+ " AND ic.C_DOCTYPETARGET_ID=dt.C_DocType_ID"
			);
		if (m_C_Order_ID != null)
			sql.append(" AND ic.C_Order_ID = ").append(m_C_Order_ID);
		if (AD_Client_ID != 0)
			sql.append(" AND ic.AD_Client_ID = ").append(AD_Client_ID);
		
		try
		{
			PreparedStatement  pstmt = DB.prepareStatement(sql.toString(), null);
			ResultSet rs = pstmt.executeQuery(); 
			//
			while (rs.next())
			{
				try{
			dw = rs.getString(2).toString();              //  DocType
				}catch (Exception e){
					e.printStackTrace();
				}
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql.toString(), e);
		}
		return dw;
	}
	/**
	 * 	Update Table
	 *	@param order order
	 */
	public void viewTable ()
	{
		
		PreparedStatement pstmt = null;
		try
		{
			pstmt = DB.prepareStatement (m_sql, null);
			ResultSet rs = pstmt.executeQuery ();
			m_table.loadTable(rs);
//			
//			
			rs.close ();
			pstmt.close ();
			pstmt = null;
			
		}
		catch (Exception e)
		{
			log.log(Level.SEVERE, m_sql, e);
		}
		try
		{
			if (pstmt != null)
				pstmt.close ();
			pstmt = null;
		}
		catch (Exception e)
		{
			pstmt = null;
		}
	}	//	updateTable
	
	public void showCell(int row, int column) {
	    Rectangle rect = 
	    	m_table.getCellRect(row, column, true);
	    	m_table.scrollRectToVisible(rect);
	    }
	public MiniTable getM_table() {
		return m_table;
	}
	public void setM_table(MiniTable m_table) {
		this.m_table = m_table;
	}
	public int getM_M_Product_ID() {
		return m_M_Product_ID;
	}
	public void setM_M_Product_ID(int product_ID) {
		m_M_Product_ID = product_ID;
	}
	/**
	 * clearValue
	 * */
	public void clearValue() {
		p_QuickRegisterPanel.f_currentLine.f_lineText.setValue("");
		p_QuickRegisterPanel.f_currentLine.f_price.setValue(Env.ZERO);
		p_QuickRegisterPanel.f_currentLine.f_quantity.setValue(Env.ONE);
		p_QuickRegisterPanel.f_currentLine.f_linetotal.setValue("");
		p_QuickRegisterPanel.f_product.f_name.setValue("");
	}
	
	public void keyPressed(KeyEvent e) {
	}
	public void keyReleased(KeyEvent e) {
		 if((e.getKeyCode() == KeyEvent.VK_SPACE)&&(e.getSource() == m_table)){
			
			 setValue();
		 }else {
			 setStatusValue();
		 }
		 
	}

	public void keyTyped(KeyEvent e) {
	}
	public void setStatusValue()
	{
		int rows = m_table.getRowCount();
		if(rows > 0 ){
			int row = m_table.getSelectedRow();
			row ++;
			p_QuickRegisterPanel.f_status.setStatusDB( "[" +row + "/" + rows + "]");
		}else if(rows == 0 ){
			p_QuickRegisterPanel.f_status.setStatusDB( "[" + 0 + "/" + rows + "]");
		}
		
	}
	
	/**
	 *	set liens  value 
	 * */
	public void setValue(){
		String order_ID = "";
		String orderNo = "";
		String customerNo = "";
		String customerID = "";
		String Description = "";
		String Location = "";
		BigDecimal totalValues = Env.ZERO;
		int  docType = 0;
		String docstuts = "";
		int rowSelect = p_QuickRegisterPanel.f_orderlines.getM_table()
				.getSelectedRow();
		//into orderliens
		if ((rowSelect != -1) && (checkClick == 0)) {
			checkClick = 1;
			p_QuickRegisterPanel.f_quickRegisterMenu.mutultiFlg = "1";
			p_QuickRegisterPanel.f_bpartner.setVisible(true);
			p_QuickRegisterPanel.f_orderline.setVisible(true);
			p_QuickRegisterPanel.f_orderline.f_descreption.setReadWrite(true);
			p_QuickRegisterPanel.f_orderline.f_customerNo.setReadWrite(true);
			p_QuickRegisterPanel.f_orderline.f_complete.setEnabled(true);
			p_QuickRegisterPanel.f_product.setVisible(true);
			p_QuickRegisterPanel.f_currentLine.setVisible(true);
			p_QuickRegisterPanel.f_quickRegisterMenu.aNew.setEnabled(true);
			p_QuickRegisterPanel.f_quickRegisterMenu.aDelete.setEnabled(false);
			p_QuickRegisterPanel.f_quickRegisterMenu.aFirst.setEnabled(false);
			p_QuickRegisterPanel.f_quickRegisterMenu.aNext.setEnabled(false);
			p_QuickRegisterPanel.f_quickRegisterMenu.aPrevious.setEnabled(false);
			p_QuickRegisterPanel.f_quickRegisterMenu.aLast.setEnabled(false);
			p_QuickRegisterPanel.f_quickRegisterMenu.aRefresh.setEnabled(true);
			p_QuickRegisterPanel.f_orderlines.setVisible(false);
			p_QuickRegisterPanel.f_quickRegisterMenu.aMulti.setPressed(true);
			
			if(p_QuickRegisterPanel.f_lines != null)
				p_QuickRegisterPanel.f_lines.newEditFlg = 1;
			if(p_QuickRegisterPanel.f_orderlines.getM_table().getValueAt(rowSelect, 1) != null)
				orderNo = p_QuickRegisterPanel.f_orderlines.getM_table().getValueAt(rowSelect, 1).toString();
			if(p_QuickRegisterPanel.f_orderlines.getM_table().getValueAt(rowSelect, 0) != null)
				order_ID = p_QuickRegisterPanel.f_orderlines.getM_table().getValueAt(rowSelect, 0).toString();
			if(p_QuickRegisterPanel.f_orderlines.getM_table().getValueAt(rowSelect, 4) != null)
				customerID = p_QuickRegisterPanel.f_orderlines.getM_table().getValueAt(rowSelect, 4).toString();
			if(p_QuickRegisterPanel.f_orderlines.getM_table().getValueAt(rowSelect, 5) != null)
				Location = p_QuickRegisterPanel.f_orderlines.getM_table().getValueAt(rowSelect, 5).toString();
			if(p_QuickRegisterPanel.f_orderlines.getM_table().getValueAt(rowSelect, 9) != null)
				totalValues = (BigDecimal) p_QuickRegisterPanel.f_orderlines.getM_table().getValueAt(rowSelect, 9);
			if(p_QuickRegisterPanel.f_orderlines.getM_table().getValueAt(rowSelect, 8) != null)
				docstuts = p_QuickRegisterPanel.f_orderlines.getM_table().getValueAt(rowSelect, 8).toString();
			if(p_QuickRegisterPanel.f_orderlines.getM_table().getValueAt(rowSelect, 6) != null)
				customerNo = p_QuickRegisterPanel.f_orderlines.getM_table().getValueAt(rowSelect, 6).toString();
			if(p_QuickRegisterPanel.f_orderlines.getM_table().getValueAt(rowSelect, 11)!= null)
			Description = p_QuickRegisterPanel.f_orderlines.getM_table().getValueAt(rowSelect, 11).toString();
			if (order_ID != null) {
				
				int equlsFlg = order_ID.indexOf('=');
				equlsFlg++;
				int pointFlg = order_ID.indexOf(',');
				order_ID = order_ID.substring(equlsFlg, pointFlg);
				p_QuickRegisterPanel.f_orderlines.setVisible(false);
				p_QuickRegisterPanel.f_lines.setVisible(true);
				p_QuickRegisterPanel.f_lines.viewTable(Integer
						.valueOf(order_ID));
				MOrder order = new MOrder(p_QuickRegisterPanel.m_ctx, Integer
						.valueOf(order_ID),null);
				
				//set button name
				String docAction = "";
				String str = "";
				docAction = order.getDocAction();
				MRefList ref = new MRefList(p_QuickRegisterPanel.m_ctx,135,null);
				if(docAction.equals("CO")){
					str =  ref.getListName(p_QuickRegisterPanel.m_ctx,135,"CO");
				}else if(docAction.equals("PR")){
					str = ref.getListName(p_QuickRegisterPanel.m_ctx,135,"PR");
				}else if(docAction.equals("CL")){
					str = ref.getListName(p_QuickRegisterPanel.m_ctx,135,"CL");
				}else if(docAction.equals("--")){
					str = ref.getListName(p_QuickRegisterPanel.m_ctx,135,"--");
				}
				p_QuickRegisterPanel.f_orderline.f_complete.setText(str);
				
				docType = order.getC_DocType_ID();
				int rows = p_QuickRegisterPanel.f_lines.getM_table().getRowCount();
				p_QuickRegisterPanel.f_status.setStatusLine(Msg.getMsg(Env.getCtx(), "Records")+ "=" + rows);
				if (rows != 0) {
					
					p_QuickRegisterPanel.f_lines.getM_table()
							.getSelectionModel().setSelectionInterval(1, 0);
					p_QuickRegisterPanel.f_lines.getM_table().requestFocus();
					p_QuickRegisterPanel.f_status.setStatusDB("[" + "1" + "/" + rows + "]");
				}else {
					p_QuickRegisterPanel.f_status.setStatusDB("[" + "0" + "/" + rows + "]");
					
				}
				setTotalValues(customerID,Location,orderNo,customerNo,totalValues, docType,docstuts,Description);
				p_QuickRegisterPanel.f_quickRegisterMenu.setEnableFunction(order_ID);
			} 
		} 
	}
	/**
	 * setTotalValues
	 */
	public void setTotalValues(String customerID,String Location,String orderNo,String customerNo,BigDecimal totalValue, int docType,String docstuts,String Description) {
		if (totalValue != null) {
			p_QuickRegisterPanel.f_lines.getF_total().setValue(totalValue);
			p_QuickRegisterPanel.f_lines.getF_net().setValue(totalValue);

		}
		if ((!customerID.equals(""))&& (customerID != null))
			p_QuickRegisterPanel.f_bpartner.f_name.setValue(customerID);
		if ((!Location.equals(""))&& (Location != null))
			p_QuickRegisterPanel.f_bpartner.f_location.setValue(Location);
		if (docstuts != null)
			p_QuickRegisterPanel.f_lines.f_docStatus.setValue(docstuts);
		if (docType != 0)
			p_QuickRegisterPanel.f_orderline.f_docmentType.setValue(docType);
		if(orderNo != null)
			p_QuickRegisterPanel.f_orderline.f_orderNo.setValue(orderNo);
		if(customerNo != null)
			p_QuickRegisterPanel.f_orderline.f_customerNo.setValue(customerNo.toString());
		if(Description != null)
			p_QuickRegisterPanel.f_orderline.f_descreption.setValue(Description);

	} // attachment
}	//	SubLines
