/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.quickregister;

import java.awt.Dimension;
import java.awt.Event;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.logging.Level;

import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;

import org.compiere.grid.ed.VPAttribute;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrder;
import org.compiere.model.MPAttributeLookup;
import org.compiere.model.MProduct;
import org.compiere.model.MWarehousePrice;
import org.compiere.swing.CButton;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

/**
 *	QuickRegister Product Sub Panel.
 *	Responsible for Product Selection and maintaining
 *	M_Product_ID, Name, UOM
 *	and setting Price
 *	
 *  @author Horcha
 *  @version $Id: SubProduct.java,v 1.3 2010/01/10 07:50:34 jrmt Exp $
 */
public class SubProduct extends QuickRegisterSubPanel 
	implements ActionListener, FocusListener,KeyListener
{
	/**
	 * 	Constructor
	 *	@param quickRegisterPanel QuickRegister Panel
	 */
	public SubProduct (QuickRegisterPanel quickRegisterPanel)
	{
		super (quickRegisterPanel);
	}	//	SubProduct
	protected CTextField	f_name;
	protected CButton			f_bSearch;
	/**	The Product					*/
	private MProduct		m_product = null; 
	/** Warehouse					*/
	private int 			m_M_Warehouse_ID;
	
	/** PLV							*/
	private int 			m_M_PriceList_Version_ID;
	private MOrder		m_order = null;
	protected MPAttributeLookup attributeLookup = null;
	protected VPAttribute attrib = null;
//	
    /** Product Query Window        */
    protected QuickRegisterProduct      f_queryProduct = new QuickRegisterProduct (p_QuickRegisterPanel);
	/**	Logger			*/
	private static CLogger log = CLogger.getCLogger(SubProduct.class);
	
	/**
	 * 	Initialize
	 */
	public void init()
	{
		//	Title
		TitledBorder border = new TitledBorder(Msg.translate(p_ctx, "M_Product_ID"));
		setBorder(border);
		
		//	Content
		setLayout(new GridBagLayout());
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.insets = INSETS2;
		//	--f_name
		//f_name = new VText("Name", false, false, false, 20, 255);
		
		f_bSearch = createButtonAction ("Product", KeyStroke.getKeyStroke(KeyEvent.VK_I, Event.CTRL_MASK));
//		f_bSearch.setPreferredSize(new Dimension(45, 40));
		f_bSearch.addKeyListener(this);
		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.NONE;
		gbc.weightx = 0;
		add (f_bSearch, gbc);
		
		f_name = new CTextField();
		f_name.setActionCommand("Name");
//		 setDefaultCloseOperation();
		f_name.setPreferredSize(new Dimension(80, 35));
		gbc.anchor = GridBagConstraints.WEST;
		f_name.addActionListener(this);
//		f_name = new CTextField("Name");
//		f_name.setName("Name");
		gbc.gridx = 1;
		gbc.gridy = 0;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.weightx = 0.1;
		add (f_name, gbc);
		f_name.addActionListener(this);
		f_name.addFocusListener(this);
		f_name.addKeyListener(this);
		
		//Attribute
		attributeLookup =  new MPAttributeLookup (p_ctx,p_QuickRegisterPanel.m_WindowNo);
		attrib = new VPAttribute (true, false, true, p_QuickRegisterPanel.m_WindowNo,attributeLookup);
//		attrib.setName(Msg.translate(Env.getCtx(),"M_AttributeSetInstance_ID"));
//		attrib.setName("M_AttributeSetInstance_ID");
//						M_AttributeSetInstance_ID
		attrib.setValue(0);
		attrib.setPreferredSize(new Dimension(50, 35));
//		attrib.addVetoableChangeListener(this);
		gbc.gridx = 2;
		gbc.gridy = 0;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.weightx = 0.1;
		add (attrib, gbc);
		
	}	//	init
	
	/**
	 * 	Get Panel Position
	 */
	public GridBagConstraints getGridBagConstraints()
	{
		GridBagConstraints gbc = super.getGridBagConstraints();
		gbc.gridx = 1;
		gbc.gridy = 1;
		return gbc;
	}	//	getGridBagConstraints
	
	/**
	 * 	Dispose - Free Resources
	 */
	public void dispose()
	{
		if (f_name != null)
			f_name.removeFocusListener(this);
		removeAll();
		super.dispose();
	}	//	dispose


	/**************************************************************************
	 * 	Action Listener
	 *	@param e event
	 */
	public void actionPerformed (ActionEvent e)
	{
		String action = e.getActionCommand();
		
//		boolean flg = p_QuickRegisterPanel.f_currentLine.isLine();

//		if(flg && p_QuickRegisterPanel.f_product.f_name.getValue().equals("")
//				&& (e.getSource() == f_name)){
//			p_QuickRegisterPanel.f_lines.getM_table().requestFocus();
//			return;
//		}
//		else if(!flg&& (!p_QuickRegisterPanel.f_product.f_name.getValue().equals(""))
//				&& (e.getSource() == f_name)) {
//			setParameter();
////			p_QuickRegisterPanel.openQuery(f_queryProduct);
//		}
//		else 
//		if(!flg&& (!p_QuickRegisterPanel.f_product.f_name.getValue().equals(""))){
//			if(checkProduct()){
//				p_QuickRegisterPanel.f_currentLine.qtyFocus();
//				return;
//			}else {
//				f_name.requestFocus();
//			}
//		}else if(flg && (!p_QuickRegisterPanel.f_product.f_name.getValue().equals(""))) {
//			
//			p_QuickRegisterPanel.f_currentLine.qtyFocus();
//			return;
//		}
//		else if ((e.getSource() == f_name) && (p_QuickRegisterPanel.f_product.f_name.getValue().equals("")))
//			findProduct();
		 if (action.equals("Product"))
			{
				setParameter();
				p_QuickRegisterPanel.openQuery(f_queryProduct);
				f_queryProduct.f_value.requestFocus();
				return;
			}
		
//		String action = e.getActionCommand();
//		if (action == null || action.length() == 0)
//			return;
//		log.info( "SubProduct - actionPerformed: " + action);
//		//	Product
//		if (action.equals("Name")){
//			setParameter();
//			p_QuickRegisterPanel.openQuery(f_queryProduct);
//		}else
//		if (action.equals("Product"))
//		{
//			setParameter();
//			p_QuickRegisterPanel.openQuery(f_queryProduct);
//		}
//		//	Name
//		else if (e.getSource() == f_name){
//			setParameter();
//			p_QuickRegisterPanel.openQuery(f_queryProduct);
//		}
//			findProduct();
	}	//	actionPerformed
	
	/**
	 * 	Get/create Header
	 *	@return header or null
	 */
	public MOrder getOrder()
	{
		if (m_order == null)
		{
			m_order = new MOrder(Env.getCtx(), 0, null);
			m_order.setAD_Org_ID(p_QuickRegister.getAD_Org_ID());
			m_order.setIsSOTrx(true);
			if (p_QuickRegister.getC_DocType_ID() != 0)
				m_order.setC_DocTypeTarget_ID(p_QuickRegister.getC_DocType_ID());
			else
				m_order.setC_DocTypeTarget_ID(MOrder.DocSubTypeSO_POS);
			MBPartner partner = p_QuickRegisterPanel.f_bpartner.getBPartner(); 
			if (partner == null || partner.get_ID() == 0)
				partner = p_QuickRegister.getBPartner();
			if (partner == null || partner.get_ID() == 0)
			{
				log.log(Level.SEVERE, "SubCurrentLine.getOrder - no BPartner");
				return null;
			}
			log.info( "SubCurrentLine.getOrder -" + partner);
			m_order.setBPartner(partner);
			int id = p_QuickRegisterPanel.f_bpartner.getC_BPartner_Location_ID();
			if (id != 0)
				m_order.setC_BPartner_Location_ID(id);
			id = p_QuickRegisterPanel.f_bpartner.getAD_User_ID();
			if (id != 0)
				m_order.setAD_User_ID(id);
			//
			m_order.setM_PriceList_ID(p_QuickRegister.getM_PriceList_ID());
			m_order.setM_Warehouse_ID(p_QuickRegister.getM_Warehouse_ID());
			m_order.setSalesRep_ID(p_QuickRegister.getSalesRep_ID());
			if (!m_order.save())
				m_order = null;
		}
		return m_order;
	}	//	getHeader
	

	/**
	 * 	Focus Gained
	 *	@param e
	 */
	public void focusGained (FocusEvent e)
	{
		p_QuickRegisterPanel.f_bpartner.f_bEdit.setEnabled(false);
		p_QuickRegisterPanel.f_bpartner.f_bNew.setEnabled(false);
		p_QuickRegisterPanel.f_lines.f_bEdit.setEnabled(true);
		p_QuickRegisterPanel.f_quickRegisterMenu.aNew.setEnabled(true);
		p_QuickRegisterPanel.f_quickRegisterMenu.aSave.setEnabled(false);
		p_QuickRegisterPanel.f_currentLine.f_new.setEnabled(true);
	}

	/**
	 * 	Focus Lost
	 *	@param e
	 */
	public void focusLost (FocusEvent e)
	{
		if (e.isTemporary())
			return;
//		p_QuickRegisterPanel.f_currentLine.f_lineText.setValue("");
//		p_QuickRegisterPanel.f_currentLine.f_linetotal.setValue("");
//		p_QuickRegisterPanel.f_currentLine.f_price.setValue(Env.ZERO);
//		p_QuickRegisterPanel.f_currentLine.f_quantity.setValue(Env.ONE);
		int check = p_QuickRegisterPanel.f_product.checkProduct();
		if(check==1){
//			p_QuickRegisterPanel.f_currentLine.qtyFocus();
//			p_QuickRegisterPanel.f_lines.getM_table().requestFocus();
//			return;
		}else if(check==0){
			p_QuickRegisterPanel.f_product.f_name.requestFocus();
			return;
		}else if (check>1)
		{
			p_QuickRegisterPanel.f_product.findProduct();
			p_QuickRegisterPanel.f_product.f_queryProduct.f_value.requestFocus();
			p_QuickRegisterPanel.f_product.f_queryProduct.f_value.setValue(p_QuickRegisterPanel.f_product.f_name.getValue());
			return;
		}
		log.info( "SubProduct - focusLost");
		
	}	//	focusLost

	/**
	 * 	Set Query Paramter
	 */
	private void setParameter()
	{
		//	What PriceList ?
		m_M_Warehouse_ID = p_QuickRegister.getM_Warehouse_ID();
		m_M_PriceList_Version_ID = p_QuickRegisterPanel.f_bpartner.getM_PriceList_Version_ID();
		f_queryProduct.setQueryData(m_M_PriceList_Version_ID, m_M_Warehouse_ID);
	}	//	setParameter
	/**************************************************************************
	 * 	Find/Set Product & Price
	 */
	protected void findProduct()
	{
		String query = f_name.getText();
		if (query == null || query.length() == 0)
			return;
		query = query.toUpperCase();
		//	Test Number
		boolean allNumber = true;
		try
		{
			Integer.parseInt(query);
		}
		catch (Exception e)
		{
			allNumber = false;
		}
		String Value = query;
		String Name = query;
		String UPC = (allNumber ? query : null);
		String SKU = (allNumber ? query : null);
		
		MWarehousePrice[] results = null;
		setParameter();
		//
		
		results = MWarehousePrice.find (p_ctx,
			m_M_PriceList_Version_ID, m_M_Warehouse_ID,
			Value, Name, UPC, SKU, null);
		
		//	Set Result
		if (results.length == 0)
		{
			setM_Product_ID(0);
			p_QuickRegisterPanel.f_currentLine.setPrice(Env.ZERO);
		}
		else if (results.length == 1)
		{
			setM_Product_ID(results[0].getM_Product_ID());
			f_name.setText(results[0].getName());
			p_QuickRegisterPanel.f_currentLine.setPrice(results[0].getPriceStd());
		}
		else	//	more than one
		{
			f_queryProduct.setResults (results);
			p_QuickRegisterPanel.openQuery(f_queryProduct);
			
		}
//		setM_AttributeSetInstance_ID(results[0].getM_AttributeSetInstance_ID());
	}	//	findProduc
	/**
	 *  Query Info
	 */
//	private void executeQuery( int M_PRODUCT_ID )
//	{
//		log.info("");
//		int AD_Client_ID = Env.getCtx().getAD_Client_ID();
//		//  Create SQL
//		StringBuffer sql = new StringBuffer(
//			"SELECT p.M_ATTRIBUTESETINSTANCE_ID "
//			+ "FROM C_ORDER ic, AD_Org o, M_Product p "
//			+ "WHERE ic.AD_Org_ID=o.AD_Org_ID AND p.AD_Org_ID = ic.AD_Org_ID "
//			+ " AND ic.AD_Client_ID=p.AD_Client_ID AND ic.AD_Org_ID = p.AD_Org_ID "
//			+ " AND p.M_Product_ID =? "
//			);
//		
//		if (p_QuickRegisterPanel.f_bpartner.m_C_BPartner_ID > 0)
//			sql.append(" AND ic.C_BPartner_ID = ").append(p_QuickRegisterPanel.f_bpartner.m_C_BPartner_ID);
//		if (p_QuickRegisterPanel.f_bpartner.m_C_Order_ID != null)
//			sql.append(" AND ic.C_Order_ID = ").append(p_QuickRegisterPanel.f_bpartner.m_C_Order_ID);
//		if (AD_Client_ID != 0)
//			sql.append(" AND ic.AD_Client_ID = ").append(AD_Client_ID);
//		
//		sql.append(" ORDER BY p.Name");
//		try
//		{
//			PreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
//			pstmt.setInt(1, M_PRODUCT_ID);
//			ResultSet rs = pstmt.executeQuery();
//			//
//			while (rs.next())
//			{
//				String  M_AttributeSetInstance_ID = rs.getString(0).toString(); //  M_AttributeSetInstance_ID
//				if((!M_AttributeSetInstance_ID.equals("")) && (M_AttributeSetInstance_ID != null))
//				setM_AttributeSetInstance_ID(Integer.valueOf(M_AttributeSetInstance_ID));
//			}
//			rs.close();
//			pstmt.close();
//		}
//		catch (SQLException e)
//		{
//			log.log(Level.SEVERE, sql.toString(), e);
//		}
//	}
//	/**
//	 * 	Set M_AttributeSetInstance_ID
//	 *	@param M_AttributeSetInstance_ID id
//	 */
//	public void setM_AttributeSetInstance_ID (int M_AttributeSetInstance_ID)
//	{
//		if (M_AttributeSetInstance_ID == 0)		//	 0 is valid ID
//			
//			Env.getCtx().setContext("M_AttributeSetInstance_ID", new Integer(0));
//		else
//			Env.getCtx().setContext("M_AttributeSetInstance_ID", M_AttributeSetInstance_ID);
//	}	//	setM_AttributeSetInstance_ID
	/**************************************************************************
	 * 	Find/Set Product & Price
	 */
	protected int checkProduct()
	{
		String query = f_name.getText();
			
		query = query.toUpperCase();
		//	Test Number
		boolean allNumber = true;
		int result = 0;
		try
		{
			Integer.parseInt(query);
		}
		catch (Exception e)
		{
			allNumber = false;
		}
		String Value = query;
		String Name = query;
		String UPC = (allNumber ? query : null);
		String SKU = (allNumber ? query : null);
		
		MWarehousePrice[] results = null;
		setParameter();
		//
		results = MWarehousePrice.find (p_ctx,
			m_M_PriceList_Version_ID, m_M_Warehouse_ID,
			Value, Name, UPC, SKU, null);
		
		//	Set Result
		if (results.length == 0)
		{
			setM_Product_ID(0);
			p_QuickRegisterPanel.f_currentLine.setPrice(Env.ZERO);
			return result;
		}
		else if ((results.length == 1)&&(!p_QuickRegisterPanel.f_lines.checkEdit.equals("1")))
		{
			setM_Product_ID(results[0].getM_Product_ID());
			f_name.setText(results[0].getName());
			p_QuickRegisterPanel.f_currentLine.setPrice(results[0].getPriceStd());
//			p_QuickRegisterPanel.f_currentLine.f_price.setReadWrite(true);
			return result = 1;
		}
		else	//	more than one
		{
			f_queryProduct.setResults (results);
			return result = results.length;
		}
		
	}	//	findProduct
	/**************************************************************************
	 * 	newOrderline check  Product
	 */
	protected int newLinecheckProduct()
	{
		String query = f_name.getText();
			
		query = query.toUpperCase();
		//	Test Number
		boolean allNumber = true;
		int result = 0;
		try
		{
			Integer.parseInt(query);
		}
		catch (Exception e)
		{
			allNumber = false;
		}
		String Value = query;
		String Name = query;
		String UPC = (allNumber ? query : null);
		String SKU = (allNumber ? query : null);
		
		MWarehousePrice[] results = null;
		setParameter();
		//
		results = MWarehousePrice.find (p_ctx,
			m_M_PriceList_Version_ID, m_M_Warehouse_ID,
			Value, Name, UPC, SKU, null);
		
		//	Set Result
		if (results.length == 0)
		{
			setM_Product_ID(0);
			p_QuickRegisterPanel.f_currentLine.setPrice(Env.ZERO);
			return result;
		}
		else if (results.length == 1)
		{
			setM_Product_ID(results[0].getM_Product_ID());
			return result = 1;
		}
		else	//	more than one
		{
			f_queryProduct.setResults (results);
			return result = results.length;
		}
	}	//	findProduct
	/**************************************************************************
	 * 	Find/Set Product & Price
	 */
	protected void newLinefindProduct()
	{
		String query = f_name.getText();
		if (query == null || query.length() == 0)
			return;
		query = query.toUpperCase();
		//	Test Number
		boolean allNumber = true;
		try
		{
			Integer.parseInt(query);
		}
		catch (Exception e)
		{
			allNumber = false;
		}
		String Value = query;
		String Name = query;
		String UPC = (allNumber ? query : null);
		String SKU = (allNumber ? query : null);
		
		MWarehousePrice[] results = null;
		setParameter();
		//
		results = MWarehousePrice.find (p_ctx,
			m_M_PriceList_Version_ID, m_M_Warehouse_ID,
			Value, Name, UPC, SKU, null);
		
		//	Set Result
		if (results.length == 0)
		{
			setM_Product_ID(0);
			p_QuickRegisterPanel.f_currentLine.setPrice(Env.ZERO);
		}
		else if (results.length == 1)
		{
			setM_Product_ID(results[0].getM_Product_ID());
			f_name.setText(results[0].getName());
		}
		else	//	more than one
		{
			f_queryProduct.setResults (results);
			p_QuickRegisterPanel.openQuery(f_queryProduct);
			
		}
	}	//	findProduc
	/**************************************************************************


	/**
	 * 	Set Price for defined product 
	 */
	public void setPrice()
	{
		if (m_product == null)
			return;
		//
		setParameter();
		MWarehousePrice result = MWarehousePrice.get (m_product,
			m_M_PriceList_Version_ID, m_M_Warehouse_ID, null);
		if (result != null)
			p_QuickRegisterPanel.f_currentLine.setPrice(result.getPriceStd());
	}	//	setPrice
	
	/**************************************************************************
	 * 	Set Product
	 *	@param M_Product_ID id
	 */
	public void setM_Product_ID (int M_Product_ID)
	{
		log.fine( "SubProduct.setM_Product_ID=" + M_Product_ID);
		if (M_Product_ID <= 0)
			m_product = null;
		else
		{
			m_product = MProduct.get(p_ctx, M_Product_ID);
			if (m_product.get_ID() == 0)
				m_product = null;
		}
		//	Set String Info
		if (m_product != null)
		{
			f_name.setText(m_product.getName());
			f_name.setToolTipText(m_product.getDescription());
			p_QuickRegisterPanel.f_currentLine.setUOM(m_product.getUOMSymbol());
		}
		else
		{
			f_name.setText(null);
			f_name.setToolTipText(null);
			p_QuickRegisterPanel.f_currentLine.setUOM(null);
		}
	}	//	setM_Product_ID
	
	/**
	 * 	Get Product
	 *	@return M_Product_ID
	 */
	public int getM_Product_ID ()
	{
		if (m_product != null)
			return m_product.getM_Product_ID();
		return 0;
	}	//	getM_Product_ID
	
	/**
	 * 	Get UOM
	 *	@return C_UOM_ID
	 */
	public int getC_UOM_ID ()
	{
		if (m_product != null)
			return m_product.getC_UOM_ID();
		return 0;
	}	//	getC_UOM_ID

	/**
	 * 	Get Product Name
	 *	@return name of product
	 */
	public String getProductName()
	{
		if (m_product != null)
			return m_product.getName();
		return "";
	}	//	getProductName
	
	/**
	 * 	Get Product
	 *	@return product
	 */
	public MProduct getProduct()
	{
		return m_product;
	}	//	getProduct

	public void keyPressed(KeyEvent e) {
		
	}

	public void keyReleased(KeyEvent e) {
		//check orderLine Table
		 if( (!p_QuickRegisterPanel.f_product.f_name.getValue().equals(""))&&(e.getKeyCode() == KeyEvent.VK_ENTER )) {
			if(checkProduct()==1){
				p_QuickRegisterPanel.f_currentLine.qtyFocus();
				return;
			}else if(checkProduct()==0){
				f_name.requestFocus();
				return;
			}else if (checkProduct()>1)
			{
				findProduct();
				f_queryProduct.f_value.requestFocus();
				f_queryProduct.f_value.setValue(f_name.getValue());
				return;
			}
		}else
		if( (!p_QuickRegisterPanel.f_product.f_name.getValue().equals(""))&&(e.getKeyCode() == KeyEvent.VK_ENTER )){
			p_QuickRegisterPanel.f_lines.getM_table().requestFocus();
			return;
		}
		else if((f_name.getValue().equals(""))&&(e.getKeyCode() == KeyEvent.VK_ENTER)){
			f_name.requestFocus();
			return;
		}
		else if((f_queryProduct != null)&&(e.getSource() == KeyStroke.getKeyStroke(KeyEvent.VK_Z, Event.CTRL_MASK))){
			p_QuickRegisterPanel.closeQuery();
		}else if( (e.getSource()==f_name)&&(e.getKeyCode() == KeyEvent.VK_DOWN )){
			p_QuickRegisterPanel.f_lines.getM_table().requestFocus();
			p_QuickRegisterPanel.f_lines.checkup ++;
			int rows = p_QuickRegisterPanel.f_lines.getM_table().getRowCount();
			if(rows >=1 ){
				p_QuickRegisterPanel.f_lines.getM_table().getSelectionModel()
				.setSelectionInterval(0, 0);
			}
			return;
		}else if((p_QuickRegisterPanel.f_product.f_name.getValue().equals(""))&&
				(e.getKeyCode() == KeyEvent.VK_LEFT)&&(e.getSource()==f_name)){
			f_bSearch.requestFocus();
			return;
		}
		else if((e.getKeyCode() == KeyEvent.VK_RIGHT)&&(e.getSource()==f_name)){
			if(p_QuickRegisterPanel.f_product.getComponent(2) instanceof  VPAttribute){
				VPAttribute attri = (VPAttribute)p_QuickRegisterPanel.f_product.getComponent(2);
				attri.requestFocus();
				if(p_QuickRegisterPanel.f_product.getComponent(2).getComponentAt(10, 10) instanceof  CButton)
				{
				CButton btn = (CButton)p_QuickRegisterPanel.f_product.getComponent(2).getComponentAt(0, 1);
				btn.requestFocus();
				}
			}
			
			return;
		}
		
		
		else if((e.getKeyCode() == KeyEvent.VK_RIGHT)&&(e.getSource()==f_bSearch)){
			f_name.requestFocus();
			return;
		}else if((e.getKeyCode() == KeyEvent.VK_UP)&&(e.getSource()==f_bSearch)){
			p_QuickRegisterPanel.f_bpartner.f_bNew.setEnabled(true);
			p_QuickRegisterPanel.f_bpartner.f_bEdit.setEnabled(true);
			p_QuickRegisterPanel.f_lines.f_bEdit.setEnabled(false);
			p_QuickRegisterPanel.f_quickRegisterMenu.aNew.setEnabled(false);
			p_QuickRegisterPanel.f_quickRegisterMenu.aSave.setEnabled(true);
			p_QuickRegisterPanel.f_currentLine.f_new.setEnabled(false);
			p_QuickRegisterPanel.f_bpartner.f_bNew.requestFocus();
			
			return;
		}
		else if((e.getKeyCode() == KeyEvent.VK_DOWN)&&(e.getSource()==f_bSearch)){
			p_QuickRegisterPanel.f_lines.f_up.requestFocus();
			return;
		}
		if(f_name.getValue().equals("")){
			p_QuickRegisterPanel.f_lines.checkEdit = "0";
		}
		 if((e.getKeyCode() == KeyEvent.VK_F2)){
			 f_name.requestFocus();
			return;
		}
	
	}

	public void keyTyped(KeyEvent e) {
	}
}	//	SubProduct
