/**
 * 
 */
package org.compiere.vos;

import java.io.Serializable;

/**
 * @author gwu
 *
 */
public class UWindowID implements Serializable
{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	public static final int WINDOW_START_ID = 0;
	public static final int FORM_START_ID = 10000;
	public static final int OTHER_START_ID = 100000;
	private static final int INFO_START_ID = 200000;
	
	
	public static final int FORM_PAYMENT_SELECTION = 107;
	public static final int FORM_GENERATE_INVOICE = 100;
	public static final int FORM_GENERATE_SHIPMENT = 110;
	public static final int FORM_IMPORT_FILE = 101;
	public static final int FORM_SETUP = 102;
	public static final int FORM_MATERIAL_TRX = 103;
	public static final int FORM_PAYMENT_ALLOCATION = 104;
	public static final int FORM_BOM_DROP = 114;
	public static final int FORM_IMPORT_FILE_LOADER = 101;	

	public static final int OTHER_HOME = 1;
	public static final int OTHER_PRINT_FORMAT = 2;
	
	
	/**
	 * AD_Form_ID 108 = org.compiere.apps.form.VMatch
	 */
	public static final int FORM_INVOICE_MATCHING = 108;


	public static final int FORM_DOCACTION_DIALOG = 400;
	public static final int FORM_PAYMENT_DIALOG = 401;
	public static final int FORM_ACCT_VIEWER = 402;
	
	public static final int CREATE_FROM_SHIPMENT = 403;
	public static final int CREATE_FROM_INVOICE = 404;
	public static final int CREATE_FROM_BANK_STATEMENT = 405;
	public static final int CREATE_FROM_PAYMENT_SELECTION = 406;
	public static final int CREATE_BUSINESS_PARTNER = 420; 
	public static final int CREATE_LOCATION = 421;
	public static final int PATTRIBUTE_WINDOW = 422;

	public static final int INFO_PRODUCT = 101;
	public static final int INFO_PATTRIBUTE_INSTANCE = 116;
	

	
	int m_U_Window_ID = 0;
	int m_mode = 0;
	FieldVO m_fieldVO = null;
	
	
	
	public UWindowID()
	{
	}

	
	/**
	 * Don't call this directly; instead, use one of the factory methods UWindowID.get<i>x</i>().
	 * @param U_Window_ID
	 * @param mode
	 */
	private UWindowID( int U_Window_ID, int mode )
	{
		this.m_U_Window_ID = U_Window_ID;
		this.m_mode = mode;
	}

	public FieldVO getFieldVO()
	{
		return m_fieldVO;
	}
	
	
	public static UWindowID getWindow( int AD_Window_ID )
	{
		return new UWindowID( AD_Window_ID + WINDOW_START_ID, 0 );		
	}

	public static UWindowID getForm( int AD_Form_ID, int mode )
	{
		return new UWindowID( AD_Form_ID + FORM_START_ID, mode );
	}
	
	public static UWindowID getInfoWindow( int AD_InfoWindow_ID )
	{
		return new UWindowID( AD_InfoWindow_ID + INFO_START_ID, 0 );
	}
	
	public static UWindowID getOther( int other_ID )
	{
		return new UWindowID( other_ID + OTHER_START_ID, 0 );
	}
	
	public int getAD_Form_ID()
	{
		//System.out.println("ID is:"+(m_U_Window_ID - FORM_START_ID));
		return m_U_Window_ID - FORM_START_ID;
	}
	
	public int getU_Window_ID()
	{
		return m_U_Window_ID;
	}

	public int getAD_Window_ID()
	{
		return m_U_Window_ID - WINDOW_START_ID;
	}

	public int getAD_InfoWindow_ID()
	{
		return m_U_Window_ID - INFO_START_ID;
	}  
	
	public int getOther_ID()
	{
		return m_U_Window_ID - OTHER_START_ID;
	}
	

	public int getMode()
	{
		return m_mode;
	}



	public void setMode( int mode )
	{
		m_mode = mode;
	}

	public static UWindowID getFromNode( NodeVO node )
	{
		UWindowID uid = null;
		switch( node.nodeType )
		{
		case NodeVO.TYPE_WINDOW:
			uid = UWindowID.getWindow( node.entityID );
			break;
		case NodeVO.TYPE_REPORT:
			break;
		case NodeVO.TYPE_PROCESS:
			uid = new UWindowID( node.entityID, 0 );
			break;
		case NodeVO.TYPE_WORKFLOW:
			break;
		case NodeVO.TYPE_WORKBENCH:
			break;
		case NodeVO.TYPE_SETVARIABLE:
			break;
		case NodeVO.TYPE_USERCHOICE:
			break;
		case NodeVO.TYPE_DOCACTION:
			break;
		case NodeVO.TYPE_ENTITY:
			break;
		case NodeVO.TYPE_COMPONENT:
			break;
		case NodeVO.TYPE_FORM:
			uid = UWindowID.getForm( node.entityID, 0 );
			break;
		case NodeVO.TYPE_TASK:	
			break;
		case NodeVO.TYPE_REQUESTS:
			break;
		case NodeVO.TYPE_NOTES:
			break;
		case NodeVO.TYPE_OTHER:
			uid = UWindowID.getOther( node.entityID );
			break;
		}
		
		return uid;
	}


	public void setFieldVO( FieldVO fieldVO )
	{
		m_fieldVO = fieldVO;
	}



}
