/**
 * 
 */
package com.ampiere.search;

import java.io.Serializable;

import org.apache.ecs.AlignType;

/**
 * @author Shinjirito
 */
public class ComponentBean implements Serializable {
	private static final long serialVersionUID = 7313168303543242433L;
	public static final int TYPE_BR = 0;
	public static final int TYPE_LABEL = 1;
	public static final int TYPE_NUMBER = 2;
	public static final int TYPE_TEXT = 3;
	public static final int TYPE_SELECT = 4;
	public static final int TYPE_DATE = 5;
	public static final int TYPE_CHECKBOX = 6;
	public static final int TYPE_LOOKUP = 7;
	private int type;
	private Object content;
	private String label;
	private String toolTipText;
	private String align;
	private String valign;
	private int width;
	private int colSpan = 1;
	private int rowSpan = 1;

	/**
	 * Constructor
	 */
	public ComponentBean() {
		this.type = 0;
		this.label = "";
		this.content = null;
		this.align = AlignType.LEFT;
		this.valign = AlignType.MIDDLE;
		this.toolTipText = "";
		this.width = 0;
	}

	/**
	 * Constructor
	 */
	public ComponentBean(int type) {
		this.type = type;
		this.label = "";
		this.content = null;
		this.align = AlignType.LEFT;
		this.valign = AlignType.MIDDLE;
		this.toolTipText = "";
		this.width = 0;
	}

	/**
	 * Constructor
	 */
	public ComponentBean(String label, int type, Object content, String align, String valign, String toolTipText, int width) {
		this.type = type;
		this.label = label;
		this.content = content;
		this.align = align;
		this.valign = valign;
		this.toolTipText = toolTipText;
		this.width = width;
	}

	public Object getContent() {
		if (content == null) {
			return "";
		}

		return content;
	}
	public void setContent(Object content) {
		this.content = content;
	}
	public int getType() {
		return type;
	}
	public void setType(int type) {
		this.type = type;
	}
	public String getToolTipText() {
		return toolTipText;
	}
	public void setToolTipText(String toolTipText) {
		this.toolTipText = toolTipText;
	}

	public String getAlign() {
		return align;
	}

	public void setAlign(String align) {
		this.align = align;
	}

	public String getValign() {
		return valign;
	}

	public void setValign(String valign) {
		this.valign = valign;
	}

	public int getWidth() {
		return width;
	}

	public void setWidth(int width) {
		this.width = width;
	}

	public int getColSpan() {
		return colSpan;
	}

	public void setColSpan(int colSpan) {
		this.colSpan = colSpan;
	}

	public int getRowSpan() {
		return rowSpan;
	}

	public void setRowSpan(int rowSpan) {
		this.rowSpan = rowSpan;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}
}
