/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.search;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;

import javax.servlet.http.HttpServletRequest;

import org.apache.ecs.AlignType;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Msg;
import org.compiere.util.WebSessionCtx;


/**
 *  View Assignments and optionally create Resource Assigments
 *
 *  @author     Jorg Janke
 *  @version    $Id: InfoAssignment.java,v 1.3 2010/05/05 10:05:42 clmg Exp $
 */
public class InfoAssignment extends Info
{
	/**  Array of Column Info    */
	private Info_Column[] s_assignmentLayout = null;

	/**
	 *  Constructor
	 *  @param WindowNo WindowNo
	 *  @param  value   Query value Name or Value if contains numbers
	 *  @param multiSelection multiple selection
	 *  @param whereClause where clause
	 */
	public InfoAssignment (int WindowNo, String value, boolean multiSelection, String whereClause, Ctx ctx)
	{
		super(WindowNo, "ra", "S_ResourceAssigment_ID", multiSelection, whereClause, ctx);
		log.info(value);

		title = Msg.translate(ctx, "InfoAssignment");

		/**  Array of Column Info    */
		int i = 0;
		s_assignmentLayout = new Info_Column [8];
		columnAttrList = new ArrayList<Integer>();
		s_assignmentLayout[i++] = new Info_Column(" ", "ra.S_ResourceAssignment_ID", IDColumn.class);
		columnAttrList.add(1);
		s_assignmentLayout[i++] = new Info_Column(Msg.translate(ctx, "S_ResourceType_ID"), "rt.Name", String.class);
		columnAttrList.add(1);
		s_assignmentLayout[i++] = new Info_Column(Msg.translate(ctx, "S_Resource_ID"), "r.Name", String.class);
		columnAttrList.add(1);
		s_assignmentLayout[i++] = new Info_Column(Msg.translate(ctx, "AssignDateFrom"), "ra.AssignDateFrom", Timestamp.class);
		columnAttrList.add(1);
		s_assignmentLayout[i++] = new Info_Column(Msg.translate(ctx, "Qty"), "ra.Qty", Double.class);
		columnAttrList.add(0);
		s_assignmentLayout[i++] = new Info_Column(Msg.translate(ctx, "C_UOM_ID"), "uom.UOMSymbol", String.class);
		columnAttrList.add(0);
		s_assignmentLayout[i++] = new Info_Column(Msg.translate(ctx, "AssignDateTo"), "ra.AssignDateTo", Timestamp.class);
		columnAttrList.add(0);
		s_assignmentLayout[i++] = new Info_Column(Msg.translate(ctx, "IsConfirmed"), "ra.IsConfirmed", Boolean.class);
		columnAttrList.add(0);

		statInit(ctx);
		initInfo();

		p_loadedOK = true;
	}	// InfoAssignment

	/**
	 *	Static Setup - add fields to parameterPanel.
	 *  <pre>
	 * 		ResourceType	Resource	DateTimeFrom	DateTimeTo	New
	 *  </pre>
	 */
	private void statInit(Ctx ctx)
	{
		// First Row
		// int AD_Column_ID = 6851;	//	S_Resource.S_ResourceType_ID
//		MLookup lookupResType = MLookupFactory.get (ctx, p_WindowNo, 0, 6851, DisplayType.TableDir);
		MLookup lookupResType = MLookupFactory.get (ctx, p_WindowNo, 6851, DisplayType.TableDir);
		componentList.add(new ComponentBean(Msg.translate(ctx, "S_ResourceType_ID"), ComponentBean.TYPE_LABEL, "", AlignType.RIGHT, AlignType.MIDDLE, "", 0));
		componentMapping.put("S_ResourceType_ID", new Integer(componentList.size()));
		componentList.add(new ComponentBean("", ComponentBean.TYPE_SELECT, getTableDirectList(lookupResType), AlignType.LEFT, AlignType.MIDDLE, "", 218));

		// AD_Column_ID = 6826;		//	S_ResourceAssignment.S_Resource_ID
//		MLookup lookupRes = MLookupFactory.get (ctx, p_WindowNo, 0, 6826, DisplayType.TableDir);
		MLookup lookupRes = MLookupFactory.get (ctx, p_WindowNo, 6826, DisplayType.TableDir);
		componentList.add(new ComponentBean(Msg.translate(ctx, "S_Resource_ID"), ComponentBean.TYPE_LABEL, "", AlignType.RIGHT, AlignType.MIDDLE, "", 0));
		componentMapping.put("S_Resource_ID", new Integer(componentList.size()));
		componentList.add(new ComponentBean("", ComponentBean.TYPE_SELECT, getTableDirectList(lookupRes), AlignType.LEFT, AlignType.MIDDLE, "", 218));

		componentList.add(new ComponentBean(ComponentBean.TYPE_BR));

		// 2nd Row
		componentList.add(new ComponentBean(Msg.translate(ctx, "DateFrom"), ComponentBean.TYPE_LABEL, "", AlignType.RIGHT, AlignType.MIDDLE, "", 0));
		componentMapping.put("DateFrom", new Integer(componentList.size()));
		componentList.add(new ComponentBean(Msg.translate(ctx, "DateFrom"), ComponentBean.TYPE_DATE, "", AlignType.LEFT, AlignType.MIDDLE, "", 198));
		componentList.add(new ComponentBean(Msg.translate(ctx, "DateTo"), ComponentBean.TYPE_LABEL, "", AlignType.RIGHT, AlignType.MIDDLE, "", 0));
		componentMapping.put("DateTo", new Integer(componentList.size()));
		componentList.add(new ComponentBean(Msg.translate(ctx, "DateTo"), ComponentBean.TYPE_DATE, "", AlignType.LEFT, AlignType.MIDDLE, "", 198));

//		parameterPanel.add(bNew, null);
	}	//	statInit

	/**
 	 * SELECT rt.Name, r.Name, ra.AssignDateFrom, ra.AssignDateTo, ra.Qty, uom.UOMSymbol, ra.IsConfirmed
	 * FROM S_ResourceAssignment ra, S_ResourceType rt, S_Resource r, C_UOM uom
	 * WHERE ra.IsActive='Y'
	 * AND ra.S_Resource_ID=r.S_Resource_ID
	 * AND r.S_ResourceType_ID=rt.S_ResourceType_ID
	 * AND rt.C_UOM_ID=uom.C_UOM_ID
	 */

	/** From Clause             */
	private static String s_assignmentFROM =
		"S_ResourceAssignment ra, S_ResourceType rt, S_Resource r, C_UOM uom";
	private static String s_assignmentWHERE =
		"ra.IsActive='Y' AND ra.S_Resource_ID=r.S_Resource_ID "
		+ "AND r.S_ResourceType_ID=rt.S_ResourceType_ID AND rt.C_UOM_ID=uom.C_UOM_ID";

	/**
	 *	Dynamic Init
	 *  @param value value
	 *  @param whereClause where clause
	 */
	private void initInfo()
	{
		//  C_BPartner bp, AD_User c, C_BPartner_Location l, C_Location a

		//	Create Grid
		StringBuffer where = new StringBuffer(s_assignmentWHERE);
		if (p_whereClause != null && p_whereClause.length() > 0)
			where.append(" AND ").append(p_whereClause);

		//
		prepareTable(s_assignmentLayout, s_assignmentFROM,
			where.toString(),
			"rt.Name,r.Name,ra.AssignDateFrom");
	}	//	initInfo

	/**
	 *	Construct SQL Where Clause and define parameters.
	 *  (setParameters needs to set parameters)
	 *  Includes first AND
	 *  @return sql
	 */
	protected String createQuery(Hashtable valueMapping, SimpleDateFormat dateFormat) {
		StringBuffer sql = new StringBuffer();

		// S_ResourceType_ID
		String s = getComponetValue(valueMapping, "S_ResourceType_ID");
		if (s != null)
		{
			sql.append(" AND rt.S_ResourceType_ID=");
			sql.append(Integer.parseInt(s));
		}

		// S_Resource_ID
		s = getComponetValue(valueMapping, "S_Resource_ID");
		if (s != null)
		{
			sql.append(" AND r.S_Resource_ID=");;
			sql.append(Integer.parseInt(s));
		}

		// Transaction date
		String from = getComponetValue(valueMapping, "DateFrom");
		if (from != null)
		{
			Timestamp fromT = null;
			try {
				if (from != null) {
					Date d = dateFormat.parse(from);
					fromT = new Timestamp(d.getTime());
				}
			} catch (Exception e) {
				log.log(Level.SEVERE, "InfoAssignment : createQuery : Date convert error ", e);
			}

			if (fromT != null) {
				sql.append(" AND TRUNC(ra.AssignDateFrom)>=");
				sql.append(DB.TO_DATE(fromT, false));
			}
		}

		// Transaction date
		String to = getComponetValue(valueMapping, "DateTo");
		if (to != null)
		{
			Timestamp toT = null;
			try {
				if (to != null) {
					Date d = dateFormat.parse(to);
					toT = new Timestamp(d.getTime());
				}
			} catch (Exception e) {
				log.log(Level.SEVERE, "InfoAssignment : createQuery : Date convert error ", e);
			}

			if (toT != null) {
				sql.append(" AND TRUNC(ra.AssignDateTo)<=");
				sql.append(DB.TO_DATE(toT, false));
			}
		}

		return sql.toString();
	}	//	createQuery

	/**
	 *  Set Parameters for Query
	 *	To be overwritten by concrete classes
	 *  @param pstmt pstmt
	 *  @param forCount for counting records
	 *  @throws SQLException
	 */
	void setParameters (PreparedStatement pstmt, boolean forCount) throws SQLException
	{
	}

	/**************************************************************************
	 *  Get dynamic WHERE part of SQL
	 *	To be overwritten by concrete classes
	 *  @return WHERE clause
	 */
	protected String getSQLWhere() {
		if (p_sqlWhere != null && p_sqlWhere.length() > 0) {
			return p_sqlWhere;
		}
		return "";
	}
	
	/**
	 * Set query parameters
	 */
	public void setQueryParas(WebSessionCtx wsc1, HttpServletRequest request) {
	}	//	setQueryParas
}   //  InfoAssignment
