/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.search;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.logging.Level;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.apache.ecs.AlignType;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.WebSessionCtx;

import com.ampiere.util.Constants;
import com.jware.util.StringToIntConverter;

/**
 *  Info InOut
 *
 *  @author Jorg Janke
 *  @version  $Id: InfoInOut.java,v 1.4 2010/05/05 10:05:42 clmg Exp $
 */
public class InfoInOut extends Info
{
	/**  Array of Column Info    */
	private Info_Column[] s_inoutLayout = null;
	
	String fDocumentNo = null;
	String fDescription = null;
	String fPOReference = null;
	String fBPartner_ID = null;
	String fOrder_ID = null;	
	String fDateFrom = null;
	String fDateTo = null;
	String fAmtFrom = null;
	String fAmtTo = null;
	String fIsSOTrx = null;
	String fIsPaid = null;
	WebSessionCtx wsc = null;

	/**
	 *  Detail Protected Contructor
	 *  @param frame parent frame
	 *  @param modal modal
	 *  @param WindowNo window no
	 *  @param value query value
	 *  @param multiSelection multiple selections
	 *  @param whereClause where clause
	 */
	public InfoInOut(int WindowNo, String value, boolean multiSelection, String whereClause, Ctx ctx)
	{
		super (WindowNo, "i", "M_InOut_ID", multiSelection, whereClause, ctx);

		log.info( "InfoInOut");
		title = Msg.translate(ctx, "InfoInOut");

		/**  Array of Column Info    */
		int i = 0;
		s_inoutLayout = new Info_Column [7];
		columnAttrList = new ArrayList<Integer>();
		s_inoutLayout[i++] = new Info_Column(Msg.translate(ctx, "Select"), "i.M_InOut_ID", IDColumn.class);
		columnAttrList.add(1);
		s_inoutLayout[i++] = new Info_Column(Msg.translate(ctx, "C_BPartner_ID"), "(SELECT Name FROM C_BPartner bp WHERE bp.C_BPartner_ID=i.C_BPartner_ID)", String.class);
		columnAttrList.add(1);
		s_inoutLayout[i++] = new Info_Column(Msg.translate(ctx, "MovementDate"), "i.MovementDate", Timestamp.class);
		columnAttrList.add(1);
		s_inoutLayout[i++] = new Info_Column(Msg.translate(ctx, "DocumentNo"), "i.DocumentNo", String.class);
		columnAttrList.add(1);
		s_inoutLayout[i++] = new Info_Column(Msg.translate(ctx, "Description"), "i.Description", String.class);
		columnAttrList.add(0);
		s_inoutLayout[i++] = new Info_Column(Msg.translate(ctx, "POReference"), "i.POReference", String.class);
		columnAttrList.add(0);
		s_inoutLayout[i++] = new Info_Column(Msg.translate(ctx, "IsSOTrx"), "i.IsSOTrx", Boolean.class);
		columnAttrList.add(0);

		//
		try
		{
			String s = "";
			if (value != null && value.length() > 0) {
				s = value;
			}
			statInit(ctx, s);
			p_loadedOK = initInfo();
		}
		catch (Exception e)
		{
			return;
		}
	}   //  InfoInOut

	/**
	 *	Static Setup - add fields to parameterPanel
	 *  @throws Exception if Lookups cannot be initialized
	 */
	private void statInit(Ctx ctx, String value) throws Exception
	{
		// First Row
		componentList.add(new ComponentBean(Msg.translate(ctx, "DocumentNo"), ComponentBean.TYPE_LABEL, "", AlignType.RIGHT, AlignType.MIDDLE, "", 0));
		componentMapping.put("DocumentNo", new Integer(componentList.size()));
		componentList.add(new ComponentBean("", ComponentBean.TYPE_TEXT, value, AlignType.LEFT, AlignType.MIDDLE, "", 220));

//		fBPartner_ID = new VLookup("C_BPartner_ID", false, false, true, MLookupFactory.get (ctx, p_WindowNo, 0, 3499, DisplayType.Search));
		componentList.add(new ComponentBean(Msg.translate(ctx, "BPartner"), ComponentBean.TYPE_LABEL, "", AlignType.RIGHT, AlignType.MIDDLE, "", 0));
		componentMapping.put("C_BPartner_ID", new Integer(componentList.size()));
		componentList.add(new ComponentBean("C_BPartner_ID", ComponentBean.TYPE_LOOKUP, "", AlignType.LEFT, AlignType.MIDDLE, "", 198));

//		fIsSOTrx.setSelected(!"N".equals(Env.getContext(ctx, p_WindowNo, "IsSOTrx")));
//		String isSOTrx = ("N".equals(Env.getContext(ctx, p_WindowNo, "IsSOTrx")) ? "N" : "Y");
		String isSOTrx = ("N".equals(ctx.getContext(p_WindowNo, "IsSOTrx")) ? "N" : "Y");
		componentMapping.put("IsSOTrx", new Integer(componentList.size()));
		ComponentBean bean = new ComponentBean(Msg.translate(ctx, "IsSOTrx"), ComponentBean.TYPE_CHECKBOX, isSOTrx, AlignType.LEFT, AlignType.MIDDLE, "", 0);
		bean.setColSpan(2);
		componentList.add(bean);

		componentList.add(new ComponentBean(ComponentBean.TYPE_BR));

		// 2nd Row
		componentList.add(new ComponentBean(Msg.translate(ctx, "Description"), ComponentBean.TYPE_LABEL, "", AlignType.RIGHT, AlignType.MIDDLE, "", 0));
		componentMapping.put("Description", new Integer(componentList.size()));
		componentList.add(new ComponentBean("", ComponentBean.TYPE_TEXT, "", AlignType.LEFT, AlignType.MIDDLE, "", 220));

		componentList.add(new ComponentBean(Msg.translate(ctx, "MovementDate"), ComponentBean.TYPE_LABEL, "", AlignType.RIGHT, AlignType.MIDDLE, "", 0));
		componentMapping.put("DateFrom", new Integer(componentList.size()));
		componentList.add(new ComponentBean(Msg.translate(ctx, "DateFrom"), ComponentBean.TYPE_DATE, "", AlignType.LEFT, AlignType.MIDDLE, "", 198));
		componentList.add(new ComponentBean("-", ComponentBean.TYPE_LABEL, "", AlignType.CENTER, AlignType.MIDDLE, "", 0));
		componentMapping.put("DateTo", new Integer(componentList.size()));
		componentList.add(new ComponentBean(Msg.translate(ctx, "DateTo"), ComponentBean.TYPE_DATE, "", AlignType.LEFT, AlignType.MIDDLE, "", 198));

		componentList.add(new ComponentBean(ComponentBean.TYPE_BR));

		// 3rd Row
		componentList.add(new ComponentBean(Msg.translate(ctx, "POReference"), ComponentBean.TYPE_LABEL, "", AlignType.RIGHT, AlignType.MIDDLE, "", 0));
		componentMapping.put("POReference", new Integer(componentList.size()));
		componentList.add(new ComponentBean("", ComponentBean.TYPE_TEXT, "", AlignType.LEFT, AlignType.MIDDLE, "", 220));
	}	//	statInit

	/**
	 *	General Init
	 *	@return true, if success
	 */
	private boolean initInfo ()
	{
		//  prepare table
		StringBuffer where = new StringBuffer("i.IsActive='Y'");
		if (p_whereClause.length() > 0)
			where.append(" AND ").append(Util.replace(p_whereClause, "M_InOut.", "i."));
		prepareTable(s_inoutLayout,
			" M_InOut i",
			where.toString(),
			"2,3,4");

		return true;
	}	//	initInfo

	/**
	 *	Construct SQL Where Clause and define parameters.
	 *  (setParameters needs to set parameters)
	 *  Includes first AND
	 *  @return sql
	 */
	protected String createQuery(Hashtable valueMapping, SimpleDateFormat dateFormat) {
		StringBuffer sql = new StringBuffer();

		// DocumentNo
		String s = getComponetValue(valueMapping, "DocumentNo");
		if (s != null)
		{
			s = s.toUpperCase();
			if (! s.endsWith("%"))
				s += "%";
			sql.append(" AND UPPER(i.DocumentNo) LIKE ");
			sql.append(DB.TO_STRING(s));
		}

		// Description
		s = getComponetValue(valueMapping, "Description");
		if (s != null)
		{
			s = s.toUpperCase();
			if (! s.endsWith("%"))
				s += "%";
			sql.append(" AND UPPER(i.Description) LIKE ");
			sql.append(DB.TO_STRING(s));
		}

		// POReference
		s = getComponetValue(valueMapping, "POReference");
		if (s != null)
		{
			s = s.toUpperCase();
			if (! s.endsWith("%"))
				s += "%";
			sql.append(" AND UPPER(i.POReference) LIKE ");
			sql.append(DB.TO_STRING(s));
		}

		// Business Partner
		s = getComponetValue(valueMapping, "C_BPartner_ID");
		if (s != null)
		{
			sql.append(" AND i.C_BPartner_ID=");
			sql.append(Integer.parseInt(s));
		}

		// Ordered date
		String from = getComponetValue(valueMapping, "DateFrom");
		String to = getComponetValue(valueMapping, "DateTo");
		if (from != null || to != null)
		{
			Timestamp fromT = null;
			Timestamp toT = null;
			try {
				if (from != null) {
					Date d = dateFormat.parse(from);
					fromT = new Timestamp(d.getTime());
				}
				if (to != null) {
					Date d = dateFormat.parse(to);
					toT = new Timestamp(d.getTime());
				}
			} catch (Exception e) {
				log.log(Level.SEVERE, "InfoInOut : createQuery : Date convert error ", e);
			}

			if (fromT == null && toT != null) {
				sql.append(" AND TRUNC(i.MovementDate) <= ");
				sql.append(DB.TO_DATE(toT, true));
			} else if (fromT != null && toT == null) {
				sql.append(" AND TRUNC(i.MovementDate) >= ");
				sql.append(DB.TO_DATE(fromT, true));
			} else if (from != null && to != null) {
				sql.append(" AND TRUNC(i.MovementDate) BETWEEN ");
				sql.append(DB.TO_DATE(fromT, true));
				sql.append(" AND ");
				sql.append(DB.TO_DATE(toT, true));
			}
		}

		// Is transaction
		s = getComponetValue(valueMapping, "IsSOTrx");
		if (s != null)
		{
			s = s.toUpperCase();
			sql.append(" AND i.IsSOTrx=");
			sql.append("'" + s + "'");
		}

		return sql.toString();
	}

	/**
	 *  Set Parameters for Query.
	 *  (as defined in getSQLWhere)
	 *  @param pstmt statement
	 *  @param forCount for counting records
	 *  @throws SQLException
	 */
	void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException
	{
		int index = 1;
		if (!StringUtils.isEmpty(fDocumentNo))
			pstmt.setString(index++, getSQLText(fDocumentNo));
		if (!StringUtils.isEmpty(fDescription))
			pstmt.setString(index++, getSQLText(fDescription));
		if (!StringUtils.isEmpty(fPOReference))
			pstmt.setString(index++, getSQLText(fPOReference));
		//
		if (!StringUtils.isEmpty(fBPartner_ID))
		{
			Integer bp = StringToIntConverter.StringToInt(fBPartner_ID);
			pstmt.setInt(index++, bp.intValue());
			log.fine("BPartner=" + bp);
		}
		//
		if (!StringUtils.isEmpty(fDateFrom) || !StringUtils.isEmpty(fDateTo))
		{
			try{
				Timestamp from = null;
				Timestamp to = null;
				try{
					from = new Timestamp(wsc.dateFormat.parse(fDateFrom).getTime());
				}catch (Exception e){
					from = null;
				}
				try{
					to = new Timestamp(wsc.dateFormat.parse(fDateTo).getTime());
				}catch (Exception e){
					to = null;
				}

				log.fine("Date From=" + from + ", To=" + to);
				if (from == null && to != null)
					pstmt.setTimestamp(index++, to);
				else if (from != null && to == null)
					pstmt.setTimestamp(index++, from);
				else if (from != null && to != null)
				{
					pstmt.setTimestamp(index++, from);
					pstmt.setTimestamp(index++, to);
				}
			}catch(Exception e){
				;
			}
		}
		pstmt.setString(index++, Constants.ENABLED.equals(fIsSOTrx) ? "Y" : "N");
	}   //  setParameters

	/**
	 *  Get SQL WHERE parameter
	 *  @param f field
	 *  @return sql part
	 */
	private String getSQLText (String f)
	{
		String s = f.toUpperCase();
		if (!s.endsWith("%"))
			s += "%";
		log.fine("String=" + s);
		return s;
	}   //  getSQLText
	
	/**************************************************************************
	 *  Get dynamic WHERE part of SQL
	 *	To be overwritten by concrete classes
	 *  @return WHERE clause
	 */
	protected String getSQLWhere() {
		StringBuffer sql = new StringBuffer();
		if (!StringUtils.isEmpty(fDocumentNo))
			sql.append(" AND UPPER(i.DocumentNo) LIKE ?");
		if (!StringUtils.isEmpty(fDescription))
			sql.append(" AND UPPER(i.Description) LIKE ?");
		if (!StringUtils.isEmpty(fPOReference))
			sql.append(" AND UPPER(i.POReference) LIKE ?");		
		if (!StringUtils.isEmpty(fBPartner_ID))
			sql.append(" AND i.C_BPartner_ID=?");
		//
		if (!StringUtils.isEmpty(fOrder_ID))
			sql.append(" AND i.C_Order_ID=?");
		//
		//
		if (!StringUtils.isEmpty(fDateFrom) || !StringUtils.isEmpty(fDateTo))
		{
			try{
				Timestamp from = null;
				Timestamp to = null;
				try{
					from = new Timestamp(wsc.dateFormat.parse(fDateFrom).getTime());
				}catch (Exception e){
					from = null;
				}
				try{
					to = new Timestamp(wsc.dateFormat.parse(fDateTo).getTime());
				}catch (Exception e){
					to = null;
				}

				if (from == null && to != null)
					sql.append(" AND TRUNC(i.MovementDate,'DD') <= ?");
				else if (from != null && to == null)
					sql.append(" AND TRUNC(i.MovementDate,'DD') >= ?");
				else if (from != null && to != null)
					sql.append(" AND TRUNC(i.MovementDate,'DD') BETWEEN ? AND ?");
			}catch(Exception e){
				;
			}
		}
		sql.append(" AND i.IsSOTrx=?");

	//	log.fine( "InfoInvoice.setWhereClause", sql.toString());
		return sql.toString();
	}
	/**
	 * Set query parameters
	 */
	public void setQueryParas(WebSessionCtx wsc1, HttpServletRequest request) {
		fDocumentNo = request.getParameter("documentNo");
		fDescription = request.getParameter("description");
		fPOReference = request.getParameter("poReference");;
		fBPartner_ID = request.getParameter("cbpartnerId");
		fDateFrom = request.getParameter("dateFrom");
		fDateTo = request.getParameter("dateTo");
		fAmtFrom = request.getParameter("amountFrom");
		fAmtTo = request.getParameter("amountTo");
		wsc = wsc1;
		fIsSOTrx = wsc1.ctx.isSOTrx(p_WindowNo)?Constants.ENABLED:Constants.DISABLED;
	}	//	setQueryParas
}   //  InfoInOut
