/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.search;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DB;


/**
 *	Display Product Attribute Instance Info
 *
 *  @author     Jorg Janke
 *  @version    $Id: PAttributeInstance.java,v 1.3 2010/03/30 03:37:32 siqin Exp $
 */
public class PAttributeInstance 
{
//	private ColumnInfo[] s_layout = null; 
	private List instanceList = null;

	public List getInstanceList() {
		return instanceList;
	}

	public void setInstanceList(List instanceList) {
		this.instanceList = instanceList;
	}

	/**
	 * 	Constructor
	 * 	@param parent frame parent
	 * 	@param title title
	 * 	@param M_Warehouse_ID warehouse key name pair
	 * 	@param M_Locator_ID locator
	 * 	@param M_Product_ID product key name pair
	 * 	@param C_BPartner_ID bp
	 */
	public PAttributeInstance(Ctx ctx, String title, int M_Warehouse_ID, int M_Locator_ID, int M_Product_ID, int C_BPartner_ID)
	{
		/**	Table Column Layout Info			*/
/*
		s_layout = new ColumnInfo[] 
		{
			new ColumnInfo(" ", "s.M_AttributeSetInstance_ID", IDColumn.class),
			new ColumnInfo(Msg.translate(ctx, "Description"), "asi.Description", String.class),
			new ColumnInfo(Msg.translate(ctx, "Lot"), "asi.Lot", String.class),
			new ColumnInfo(Msg.translate(ctx, "SerNo"), "asi.SerNo", String.class), 
			new ColumnInfo(Msg.translate(ctx, "GuaranteeDate"), "asi.GuaranteeDate", Timestamp.class),
			new ColumnInfo(Msg.translate(ctx, "M_Locator_ID"), "l.Value", KeyNamePair.class, "s.M_Locator_ID"),
			new ColumnInfo(Msg.translate(ctx, "QtyOnHand"), "s.QtyOnHand", Double.class),
			new ColumnInfo(Msg.translate(ctx, "QtyReserved"), "s.QtyReserved", Double.class),
			new ColumnInfo(Msg.translate(ctx, "QtyOrdered"), "s.QtyOrdered", Double.class),
			//	See RV_Storage
			new ColumnInfo(Msg.translate(ctx, "GoodForDays"), "(TRUNC(asi.GuaranteeDate)-TRUNC(SysDate))-p.GuaranteeDaysMin", Integer.class, true, true, null),
			new ColumnInfo(Msg.translate(ctx, "ShelfLifeDays"), "TRUNC(asi.GuaranteeDate)-TRUNC(SysDate)", Integer.class),
			new ColumnInfo(Msg.translate(ctx, "ShelfLifeRemainingPct"), "CASE WHEN p.GuaranteeDays > 0 THEN TRUNC(((TRUNC(asi.GuaranteeDate)-TRUNC(SysDate))/p.GuaranteeDays)*100) ELSE 0 END", Integer.class),
		};
*/

		instanceList = init(ctx, M_Warehouse_ID, M_Locator_ID, M_Product_ID, C_BPartner_ID);
	}	//	PAttributeInstance

	/**
	 * 	Initialization
	 *	@param M_Warehouse_ID wh
	 *	@param M_Locator_ID loc
	 *	@param M_Product_ID product
	 *	@param C_BPartner_ID partner
	 */
	private List init (Ctx ctx, int M_Warehouse_ID, int M_Locator_ID, int M_Product_ID, int C_BPartner_ID)
	{
		List ret_list = null;
		log.info("M_Warehouse_ID=" + M_Warehouse_ID 
			+ ", M_Locator_ID=" + M_Locator_ID
			+ ", M_Product_ID=" + M_Product_ID);
		m_M_Warehouse_ID = M_Warehouse_ID;
//		m_M_Locator_ID = M_Locator_ID;
		m_M_Product_ID = M_Product_ID;
		try
		{
			ret_list = dynInit(ctx,C_BPartner_ID);
		}
		catch (Exception e)
		{
			log.log(Level.SEVERE, "", e);
		}
		return ret_list;
	}	// init	

	//	Parameter
	private int			 		m_M_Warehouse_ID;
//	private int			 		m_M_Locator_ID;
	private int			 		m_M_Product_ID;
	//
	private int					m_M_AttributeSetInstance_ID = -1;
	private String				m_M_AttributeSetInstanceName = null;
	private String				m_sql;
	/**	Logger			*/
	private static CLogger log = CLogger.getCLogger(PAttributeInstance.class);

	/**	From Clause							*/
	private static String s_sqlFrom = "M_Storage s"
		+ " INNER JOIN M_Locator l ON (s.M_Locator_ID=l.M_Locator_ID)"
		+ " INNER JOIN M_Product p ON (s.M_Product_ID=p.M_Product_ID)"
		+ " LEFT OUTER JOIN M_AttributeSetInstance asi ON (s.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID)";
	/** Where Clause						*/
	private static String s_sqlWhere = "l.M_Warehouse_ID=? AND s.M_Product_ID=?"; 

//	private String	m_sqlNonZero = " AND (s.QtyOnHand<>0 OR s.QtyReserved<>0 OR s.QtyOrdered<>0)";
	private String	m_sqlMinLife = "";

	/**
	 * 	Dynamic Init
	 */
	private List dynInit(Ctx ctx,int C_BPartner_ID)
	{
		log.config("C_BPartner_ID=" + C_BPartner_ID);
		if (C_BPartner_ID != 0)
		{
			int ShelfLifeMinPct = 0;
			int ShelfLifeMinDays = 0;
			String sql = "SELECT bp.ShelfLifeMinPct, bpp.ShelfLifeMinPct, bpp.ShelfLifeMinDays "
				+ "FROM C_BPartner bp "
				+ " LEFT OUTER JOIN C_BPartner_Product bpp"
				+	" ON (bp.C_BPartner_ID=bpp.C_BPartner_ID AND bpp.M_Product_ID=?) "
				+ "WHERE bp.C_BPartner_ID=?";
			PreparedStatement pstmt = null;
			try
			{
				pstmt = DB.prepareStatement(sql, null);
				pstmt.setInt(1, m_M_Product_ID);
				pstmt.setInt(2, C_BPartner_ID);
				ResultSet rs = pstmt.executeQuery();
				if (rs.next())
				{
					ShelfLifeMinPct = rs.getInt(1);		//	BP
					int pct = rs.getInt(2);				//	BP_P
					if (pct > 0)	//	overwrite
						ShelfLifeMinDays = pct;
					ShelfLifeMinDays = rs.getInt(3);
				}
				rs.close();
				pstmt.close();
				pstmt = null;
			}
			catch (Exception e)
			{
				log.log(Level.SEVERE, sql, e);
			}
			try
			{
				if (pstmt != null)
					pstmt.close();
				pstmt = null;
			}
			catch (Exception e)
			{
				pstmt = null;
			}
			if (ShelfLifeMinPct > 0)
			{
				m_sqlMinLife = " AND COALESCE(TRUNC(((TRUNC(asi.GuaranteeDate)-TRUNC(SysDate))/p.GuaranteeDays)*100),0)>=" + ShelfLifeMinPct;
				log.config( "PAttributeInstance.dynInit - ShelfLifeMinPct=" + ShelfLifeMinPct);
			}
			if (ShelfLifeMinDays > 0)
			{
				m_sqlMinLife += " AND COALESCE((TRUNC(asi.GuaranteeDate)-TRUNC(SysDate)),0)>=" + ShelfLifeMinDays;
				log.config( "PAttributeInstance.dynInit - ShelfLifeMinDays=" + ShelfLifeMinDays);
			}
		}	//	BPartner != 0


		String m_sql = prepareTable (ctx, s_sqlFrom, s_sqlWhere)
			+ " ORDER BY asi.GuaranteeDate, s.QtyOnHand";	//	oldest, smallest first


		//
		return refresh(m_sql);
	}	//	dynInit

	/**
	 * 	Refresh Query
	 */
	private List refresh(String m_sql)
	{
		String sql = m_sql;
		List ret_list = null;
/*
		int pos = m_sql.lastIndexOf(" ORDER BY ");
		if (!showAll.isSelected())
		{
			sql = m_sql.substring(0, pos) 
				+ m_sqlNonZero;
			if (m_sqlMinLife.length() > 0)
				sql += m_sqlMinLife;
			sql += m_sql.substring(pos);
		}
&&&&&&
*/

		//
		log.finest(sql);
		PreparedStatement pstmt = null;
		try
		{
			pstmt = DB.prepareStatement(sql, null);
			pstmt.setInt(1, m_M_Warehouse_ID);
			pstmt.setInt(2, m_M_Product_ID);
			ResultSet rs = pstmt.executeQuery();
			
			ret_list =  loadTable(rs);
			
/*
			m_table.loadTable(rs);
&&&&&&
*/

			rs.close();
			pstmt.close();
			pstmt = null;
		}
		catch (Exception e)
		{
			log.log(Level.SEVERE, sql, e);
		}
		try
		{
			if (pstmt != null)
				pstmt.close();
			pstmt = null;
		}
		catch (Exception e)
		{
			pstmt = null;
		}
		
		return ret_list;
	}	//	refresh

	/**
	 * 	Get Attribute Set Instance
	 *	@return M_AttributeSetInstance_ID or -1
	 */
	public int getM_AttributeSetInstance_ID()
	{
		return m_M_AttributeSetInstance_ID;
	}	//	getM_AttributeSetInstance_ID

	/**
	 * 	Get Instance Name
	 * 	@return Instance Name
	 */
	public String getM_AttributeSetInstanceName()
	{
		return m_M_AttributeSetInstanceName;
	}	//	getM_AttributeSetInstanceName
	
	/**************************************************************************
	 *  Prepare Table and return SQL
	 *
	 *  @param layout    array of column info
	 *  @param from      SQL FROM content
	 *  @param where     SQL WHERE content
	 *  @param multiSelection multiple selections
	 *  @param tableName table name
	 *  @return SQL
	 */
	public String prepareTable(Ctx ctx,String from, String where)
	{
		//
		StringBuffer sql = new StringBuffer ("SELECT ");
		//  add columns & sql

/*
SELECT s.M_AttributeSetInstance_ID,
	asi.Description,
	asi.Lot,
	asi.SerNo,
	asi.GuaranteeDate,
	l.Value,
	s.M_Locator_ID,
	s.QtyOnHand,
	s.QtyReserved,
	s.QtyOrdered,
	daysBetween(TRUNC(asi.GuaranteeDate, 'DD'), TRUNC(SysDate, 'DD')) - p.GuaranteeDaysMin,
	daysBetween(TRUNC(asi.GuaranteeDate, 'DD'), TRUNC(SysDate, 'DD')),
	CASE WHEN p.GuaranteeDays > 0 THEN daysBetween(TRUNC(asi.GuaranteeDate,
			'DD'), TRUNC(SysDate, 'DD')) / p.GuaranteeDays * 100 ELSE 0 END
 */

		sql.append( " s.M_AttributeSetInstance_ID, ");
		sql.append( " s.asi.Description, ");		
		sql.append( " asi.Lot, ");
		sql.append( " asi.SerNo,");		
		sql.append( " asi.GuaranteeDate, ");
		sql.append( " l.Value, ");		
		sql.append( " s.M_Locator_ID, ");
		sql.append( " s.QtyOnHand,");
		
		sql.append( " s.QtyReserved, ");
		sql.append( " s.QtyOrdered, ");		
		sql.append( " daysBetween(TRUNC(asi.GuaranteeDate, 'DD'), TRUNC(SysDate, 'DD')) - p.GuaranteeDaysMin, ");
		sql.append( " daysBetween(TRUNC(asi.GuaranteeDate, 'DD'), TRUNC(SysDate, 'DD')),");		
		sql.append( " CASE WHEN p.GuaranteeDays > 0 THEN daysBetween(TRUNC(asi.GuaranteeDate, ");
		sql.append( " 'DD'), TRUNC(SysDate, 'DD')) / p.GuaranteeDays * 100 ELSE 0 END ");
		
		sql.append( " FROM ").append(from);
		sql.append(" WHERE ").append(where);

		
		//	org.compiere.apps.form.VMatch.dynInit calls routine for initial init only
		if (from.length() == 0)
			return sql.toString();
		//
		String finalSQL = MRole.getDefault(ctx,false).addAccessSQL(sql.toString(), 
				"s", MRole.SQL_FULLYQUALIFIED, MRole.SQL_RO);
		log.finest(finalSQL);
		return finalSQL;
	}   //  prepareTable
	
	/**************************************************************************
	 *	Load Table from ResultSet - The ResultSet is not closed
	 *
	 *  @param rs ResultSet with the column layout defined in prepareTable
	 */
	public List loadTable(ResultSet rs)
	{
		List instanceList = new ArrayList();
		try
		{
			while (rs.next())
			{
				PAttributeInstanceVO vo = new PAttributeInstanceVO();				
				int colOffset = 1;  //  columns start with 1
				for (int col = 0; col < 12; col++)
				{
					Object data = null;
					int colIndex = col + colOffset;
					
					if (col == 0)
						data = new IDColumn(rs.getInt(colIndex));
					else if (false)
						data = new Boolean(rs.getString(colIndex).equals("Y"));
					else if (col == 4)
						data = rs.getTimestamp(colIndex);
					else if (false)
						data = rs.getBigDecimal(colIndex);
					else if (col == 6 || col == 7 || col == 8)
						data = new Double(rs.getDouble(colIndex));
					else if (col == 9 || col == 10 || col == 11)
						data = new Integer(rs.getInt(colIndex));
					else if (col == 5)
					{
						String display = rs.getString(colIndex);
						int key = rs.getInt(colIndex+1);
						data = display;
						colOffset++;
					}
					else
					{
						String s = rs.getString(colIndex);
						if (s != null)
							data = s.trim();	//	problems with NCHAR
					}
					
					if(col == 0){
						IDColumn dataColumn = (IDColumn)data;
						vo.setAttributeSetInstanceId(String.valueOf(dataColumn.getRecord_ID()));
					}else if(col == 1){
						vo.setDescription(data.toString());
					}else if(col == 2){
						vo.setLot(data.toString());
					}else if(col == 3){
						vo.setSerNo(data.toString());
					}else if(col == 4){
						vo.setGuaranteeDate(data.toString());
					}else if(col == 5){
						vo.setMlocatorId(data.toString());
					}else if(col == 6){
						vo.setQtyOnHand(data.toString());
					}else if(col == 7){
						vo.setQtyReserved(data.toString());
					}else if(col == 8){
						vo.setQtyOrdered(data.toString());
					}else if(col == 9){
						vo.setGoodForDays(data.toString());
					}else if(col == 10){
						vo.setShelfLifeDays(data.toString());
					}else if(col == 11){
						vo.setShelfLifeRemainingPct(data.toString());
					}
				}
				
				instanceList.add(vo);
			}
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, "", e);
		}
		return instanceList;
	}	//	loadTable
}	//	PAttributeInstance
