/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package com.ampiere.util;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;

import javax.servlet.http.HttpServletRequest;

import org.compiere.framework.Query;
import org.compiere.model.GridTab;
import org.compiere.model.MAsset;
import org.compiere.model.MBPartner;
import org.compiere.model.MCampaign;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

import com.ampiere.web.servlet.WWindowStatus;

/**
 *	Application Zoom Across Launcher.
 *  Called from APanel; Queries available Zoom Targets for Table.
 *	
 *  @author Jorg Janke
 *  @version $Id: WRequest.java,v 1.2 2010/03/27 10:29:48 clmg Exp $
 */
public class WRequest
{
	/**
	 *	Constructor
	 *  @param invoker component to display popup (optional)
	 *  @param tableName table name
	 *  @param query query
	 */
	public WRequest (String tableName, Query query, int curWindow_ID, WWindowStatus ws)
	{
		log.config("TableName=" + tableName + " - " + query);
		m_query = query;
		
		//	See What is there
		//getZoomTargets (tableName, curWindow_ID, ws);
		
		m_query.setRecordCount(1);	//	guess
	}	//	AReport

	/**	The Query						*/
	private Query	 	m_query;



	/**	The Option List					*/
	private ArrayList<KeyNamePair>	m_list = new ArrayList<KeyNamePair>();
	/**	Logger			*/
	private static CLogger log = CLogger.getCLogger(WRequest.class);

	/**
	 * 	Display Request Options - New/Existing.
	 * 	@param invoker button
	 */
	public static ArrayList<ValueNamePair> getRequests (HttpServletRequest request, WWindowStatus ws)
	{
		ArrayList<ValueNamePair> requestList = new ArrayList();
		
	  	WebSessionCtx wsc = WebSessionCtx.get(request);
		
		int m_AD_Table_ID = ws.getCurTab().getAD_Table_ID();
		int m_Record_ID = ws.getCurTab().getRecord_ID();
		int activeCount = 0;
		int inactiveCount = 0;
		StringBuffer m_where = new StringBuffer();
		m_where.append("(AD_Table_ID=").append(m_AD_Table_ID)
			.append(" AND Record_ID=").append(m_Record_ID)
			.append(")");
		//
		if (m_AD_Table_ID == MUser.Table_ID)
			m_where.append(" OR AD_User_ID=").append(m_Record_ID)
				.append(" OR SalesRep_ID=").append(m_Record_ID);
		else if (m_AD_Table_ID == MBPartner.Table_ID)
			m_where.append(" OR C_BPartner_ID=").append(m_Record_ID);
		else if (m_AD_Table_ID == MOrder.Table_ID)
			m_where.append(" OR C_Order_ID=").append(m_Record_ID);
		else if (m_AD_Table_ID == MInvoice.Table_ID)
			m_where.append(" OR C_Invoice_ID=").append(m_Record_ID);
		else if (m_AD_Table_ID == MPayment.Table_ID)
			m_where.append(" OR C_Payment_ID=").append(m_Record_ID);
		else if (m_AD_Table_ID == MProduct.Table_ID)
			m_where.append(" OR M_Product_ID=").append(m_Record_ID);
		else if (m_AD_Table_ID == MProject.Table_ID)
			m_where.append(" OR C_Project_ID=").append(m_Record_ID);
		else if (m_AD_Table_ID == MCampaign.Table_ID)
			m_where.append(" OR C_Campaign_ID=").append(m_Record_ID);
		else if (m_AD_Table_ID == MAsset.Table_ID)
			m_where.append(" OR A_Asset_ID=").append(m_Record_ID);
		//
		String sql = "SELECT Processed, COUNT(*) "
			+ "FROM R_Request WHERE " + m_where 
			+ " GROUP BY Processed "
			+ "ORDER BY Processed DESC";
		PreparedStatement pstmt = null;
		try
		{
			pstmt = DB.prepareStatement (sql, null);
			ResultSet rs = pstmt.executeQuery ();
			while (rs.next ())
			{
				if ("Y".equals(rs.getString(1)))
					inactiveCount = rs.getInt(2);
				else
					activeCount += rs.getInt(2);
			}
			rs.close ();
			pstmt.close ();
			pstmt = null;
		}
		catch (Exception e)
		{
			log.log(Level.SEVERE, sql, e);
		}
		try
		{
			if (pstmt != null)
				pstmt.close ();
			pstmt = null;
		}
		catch (Exception e)
		{
			pstmt = null;
		}

		//
		//create list
		int AD_Window_ID = 232;		//	232=all - 201=my
		String newRequest = Msg.getMsg(wsc.ctx, "RequestNew");
		int m_C_BPartner_ID = 0;
		if(ws.getCurTab().getValue("C_BPartner_ID")!=null){
			m_C_BPartner_ID = (Integer)ws.getCurTab().getValue("C_BPartner_ID");
		}
		
		String createNewWhereCaluse = m_where + "&" + Constants.CREATE_NEW + "=" + Constants.ENABLED 
			+ "&" + Constants.REFERENCE + "=" 
			+ "m_AD_Table_ID:" + m_AD_Table_ID + ","
			+ "m_Record_ID:" + m_Record_ID + ","
			+ "m_C_BPartner_ID:" + m_C_BPartner_ID;		
		
		ValueNamePair pp = new ValueNamePair (createNewWhereCaluse, newRequest);
		requestList.add(pp);
		
		Query queryActive = null;
		if (activeCount > 0)
		{
			//create menu Item
			String m_active = Msg.getMsg(wsc.ctx, "RequestActive") + " (" + activeCount + ")";
			queryActive = new Query("");
			String where = "(" + m_where + ") AND Processed='N'";
			queryActive.addRestriction(where);
			
			pp = new ValueNamePair (where, m_active);
			requestList.add(pp);			
		}
		Query queryAll = null;
		if (inactiveCount > 0)
		{
			String m_all = Msg.getMsg(wsc.ctx, "RequestAll") + " (" + (activeCount + inactiveCount) + ")";
			queryAll = new Query("");
			queryAll.addRestriction(m_where.toString());
			
			pp = new ValueNamePair (m_where.toString(), m_all);
			requestList.add(pp);
			//set activFlag to false (show all)
		}
		

		return requestList;
		//
	}	//	get Requests
	
	/**
	 * 	Listner
	 *	@param e event
	 */
	public void actionPerformed (HttpServletRequest request)
	{
		WWindowStatus ws = WWindowStatus.get(request);
		int m_AD_Table_ID = WebUtil.getParameterAsInt(request, "m_AD_Table_ID");
		int m_Record_ID = WebUtil.getParameterAsInt(request, "m_Record_ID");
		int m_C_BPartner_ID = WebUtil.getParameterAsInt(request, "m_C_BPartner_ID");
		
		Query query = null;
		String actionCommand = WebUtil.getParameter(request, "actionFlag");
		String m_where = WebUtil.getParameter(request, "m_where");
		if ("Y".equals(actionCommand))
		{
			query = new Query("");
			String where = "(" + m_where + ") AND Processed='N'";
			query.addRestriction(where);
		}
		else if ("N".equals(actionCommand))
		{
			query = new Query("");
			query.addRestriction(m_where.toString());
		}
		//
		int AD_Window_ID = 232;		//	232=all - 201=my
		
		//	New - set Table/Record
		if ("New".equals(actionCommand))
		{
			GridTab tab = ws.getCurTab();
			tab.dataNew (false);
			tab.setValue("AD_Table_ID", new Integer(m_AD_Table_ID));
			tab.setValue("Record_ID", new Integer(m_Record_ID));
			//
			if (m_C_BPartner_ID != 0)
				tab.setValue("C_BPartner_ID", new Integer(m_C_BPartner_ID));
			//
			if (m_AD_Table_ID == MBPartner.Table_ID)
				tab.setValue("C_BPartner_ID", new Integer(m_Record_ID));
			else if (m_AD_Table_ID == MUser.Table_ID)
				tab.setValue("AD_User_ID", new Integer(m_Record_ID));
			//
			else if (m_AD_Table_ID == MProject.Table_ID)
				tab.setValue("C_Project_ID", new Integer(m_Record_ID));
			else if (m_AD_Table_ID == MAsset.Table_ID)
				tab.setValue("A_Asset_ID", new Integer(m_Record_ID));
			//
			else if (m_AD_Table_ID == MOrder.Table_ID)
				tab.setValue("C_Order_ID", new Integer(m_Record_ID));
			else if (m_AD_Table_ID == MInvoice.Table_ID)
				tab.setValue("C_Invoice_ID", new Integer(m_Record_ID));
			//
			else if (m_AD_Table_ID == MProduct.Table_ID)
				tab.setValue("M_Product_ID", new Integer(m_Record_ID));
			else if (m_AD_Table_ID == MPayment.Table_ID)
				tab.setValue("C_Payment_ID", new Integer(m_Record_ID));
			//
			else if (m_AD_Table_ID == MInOut.Table_ID)
				tab.setValue("M_InOut_ID", new Integer(m_Record_ID));
			//
			else if (m_AD_Table_ID == MCampaign.Table_ID)
				tab.setValue("C_Campaign_ID", new Integer(m_Record_ID));
		}
	}	//	actionPerformed
	
}	//	AZoom
