/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package com.ampiere.util;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;

import org.compiere.framework.Query;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;

import com.ampiere.web.servlet.WWindowStatus;

/**
 *	Application Zoom Across Launcher.
 *  Called from APanel; Queries available Zoom Targets for Table.
 *	
 *  @author Jorg Janke
 *  @version $Id: WZoomAcross.java,v 1.2 2010/03/24 11:21:20 siqin Exp $
 */
public class WZoomAcross
{
	/**
	 *	Constructor
	 *  @param invoker component to display popup (optional)
	 *  @param tableName table name
	 *  @param query query
	 */
	public WZoomAcross (String tableName, Query query, int curWindow_ID, WWindowStatus ws)
	{
		log.config("TableName=" + tableName + " - " + query);
		m_query = query;
		
		//	See What is there
		getZoomTargets (tableName, curWindow_ID, ws);
		
		m_query.setRecordCount(1);	//	guess
	}	//	AReport

	/**	The Query						*/
	private Query	 	m_query;



	/**	The Option List					*/
	private ArrayList<KeyNamePair>	m_list = new ArrayList<KeyNamePair>();
	/**	Logger			*/
	private static CLogger log = CLogger.getCLogger(WZoomAcross.class);

	/**
	 * 	Get the Zomm Targets for the table.
	 *  Fill the list and the popup menu
	 *  @param invoker component to display popup (optional)
	 * 	@param tableName table
	 */
 private void getZoomTargets (String tableName, int curWindow_ID, WWindowStatus ws)
	{
		String sql = "SELECT DISTINCT t.AD_Table_ID, t.TableName "
			+ "FROM AD_Table t "
			+ "WHERE EXISTS (SELECT 1 FROM AD_Tab tt "
				+ "WHERE tt.AD_Table_ID = t.AD_Table_ID AND tt.SeqNo=10) "
			+ " AND t.AD_Table_ID IN "
				+ "(SELECT AD_Table_ID FROM AD_Column "
				+ "WHERE ColumnName=?) " 
			+ "AND TableName NOT LIKE 'I%'"
			+ "AND TableName NOT LIKE ? "
			+ "ORDER BY 1";
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql, null);
			int index = 1;
			pstmt.setString (index++, tableName + "_ID");
			pstmt.setString (index++, tableName);
			ResultSet rs = pstmt.executeQuery();
			while (rs.next())
			{
				ArrayList<KeyNamePair>	zoomList = new ArrayList<KeyNamePair>();
				String targetTableName = rs.getString(2);
				zoomList= WZoomTarget.getZoomTargets(targetTableName, curWindow_ID, m_query.getWhereClause(), ws);
				
				if(zoomList != null)
				{
					for(int i=0;i<zoomList.size();i++)
					{
						KeyNamePair pp = zoomList.get(i);
						if(!m_list.contains(pp))
						{
							m_list.add(pp);
						}
					}
				}
			
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql, e);
		}

		//	No Zoom
		if (m_list.size() == 0)
		{
			//no zoom
		}
		else{
			//construct zoom menu
		}
	}	//	getZoomTargets
 
	/**
	 * 	Zoom Across Menu
	 */
	public static ArrayList<KeyNamePair> cmd_zoomAcross(WWindowStatus ws)
	{
		int record_ID = ws.getCurTab().getRecord_ID();
		log.info("ID=" + record_ID);
		if (record_ID <= 0)
			return null;

		//	Query
		Query query = new Query();
		//	Current row
		String link = ws.getCurTab().getKeyColumnName();
		//	Link for detail records
		if (link.length() == 0)
			link = ws.getCurTab().getLinkColumnName();
		if (link.length() != 0)
		{
			if (link.endsWith("_ID"))
				query.addRestriction(link, Query.EQUAL,
					new Integer(ws.ctx.getContextAsInt(ws.getCurTab().getWindowNo(), link)));
			else
				query.addRestriction(link, Query.EQUAL,
						ws.ctx.getContext( ws.getCurTab().getWindowNo(), link));
		}
		WZoomAcross zoom = new WZoomAcross (ws.getCurTab().getTableName(), query, ws.getCurTab().getAD_Window_ID(), ws);
		return zoom.m_list;
	}	//	cmd_zoomAcross
	
}	//	AZoom
