/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.web.servlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.br;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.font;
import org.apache.ecs.xhtml.i;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.Compiere;
import org.compiere.db.CConnection;
import org.compiere.model.MClient;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;
import org.compiere.util.ZipUtil;

import com.qoppa.pdf.Document;

/**
 *	Web (window) Help
 *	
 *  @author Siqin
 *  @version $Id: WAbout.java,v 1.4 2010/04/05 09:42:49 siqin Exp $
 */
public class WAbout extends HttpServlet
{
	private static final long serialVersionUID = -8195647187230888285L;
	/**	Logger			*/
	protected CLogger	log = CLogger.getCLogger(getClass());

	public static final int WINDOW_WIDTH=420;
	public static final int WINDOW_HEIGHT=580;
	public static final String WEB_NL="<br>";

	/**
	 * Initialize global variables
	 */
	public void init(ServletConfig config)
		throws ServletException
	{
		super.init(config);
		if (!WebEnv.initWeb(config))
			throw new ServletException("WAbout.init");
	}   //  init

	/**
	 * Process the HTTP Get request
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException {

		log.fine("doGet");

		WebSessionCtx wsc = WebSessionCtx.get(request); 
		if (wsc == null ) {
			WebUtil.createTimeoutPage(request, response, this, null);
			return;
		}

		WebDoc doc = WebDoc.createPopup( Msg.translate(wsc.ctx, "About") );
		
		table info = new table();
		info.setStyle( "margin:10px 10px 10px 10px;" );
		info.setAlign( "center" );
		tr line = new tr();

		td item = new td();
		item.setStyle( "text-align:center;" );
		item.addElement( new img (WebEnv.getImageDirectory("Compiere120x30.png"), "") );
		item.addElement( new br() );
		font f = new font();
		f.setColor( "#0000FF" );
		f.addElement( new i(Compiere.getSubtitle() ));
		item.addElement( f );
		line.addElement( item );

		item = new td();
		item.setStyle( "text-align:center" );
		item.addElement( " Smart ERP & CRM Business Solution " );
		item.addElement( new br() );
		item.addElement( Compiere.COPYRIGHT );
		item.addElement( new br() );
		item.addElement( Compiere.MAIN_VERSION + " @ " + Compiere.DATE_VERSION );
		item.addElement( new br() );
		f = new font();
		f.setColor( "#0000FF" );
		f.addElement(Compiere.getURL());
		a link = new a(Compiere.getURL(),f);
		link.setTarget( a.TARGET_BLANK );
		item.addElement( link );
		item.addElement( new br() );
		item.addElement( new br() );
		line.addElement( item );
		info.addElement( line );
		
		line = new tr();
		item = new td();
		item.setColSpan( 2 );
		item.setStyle( "background-color:#aaaaaa" );
		div layout = new div();
		layout.setStyle( "overflow:auto;" );
		layout.addElement( getInfo( wsc.ctx,null,true ).toString() );
		item.addElement( layout );
		line.addElement( item );
		info.addElement( line );

		doc.getTable().addElement( info );

		WebUtil.createResponse(request, response, this, null, doc, false);
	}   //  doGet

	/**
	 *  Process the HTTP Post request
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException
	{
		WebDoc doc = WebDoc.create ("About - Post - Not Implemented");
		WebUtil.createResponse(request, response, this, null, doc, false);
	}   //  doPost

	/**
	 *  Get Compiere System Info
	 *  @param sb buffer to append or null
	 *  @return Info as multiple Line String
	 */
	public static StringBuffer getInfo (Ctx ctx, StringBuffer sb, boolean isWeb ) {
		String NL=Env.NL;
		if ( isWeb ) {
			NL=WEB_NL;
		}
		if (sb == null)
			sb = new StringBuffer();
		final String eq = " = ";
		sb.append(Msg.translate(ctx, Compiere.NAME))
			.append(" ").append(Compiere.MAIN_VERSION).append("_").append(Compiere.DATE_VERSION)
			.append(Msg.translate(ctx, "Implementation" ) + ":").append(Compiere.getImplementationVersion()).append(NL);
		sb.append(Msg.translate(ctx, "Host")).append(eq)        .append(getServerInfo(ctx)).append(NL);
		sb.append(Msg.translate(ctx, "Database")).append(eq)    .append(getDatabaseInfo(ctx)).append(NL);
		sb.append(Msg.translate(ctx, "Schema")).append(eq)      .append(CConnection.get().getDbUid()).append(NL);
		//
		sb.append(Msg.translate(ctx, "AD_User_ID")).append(eq)  .append(ctx.getContext("#AD_User_Name")).append(NL);
		sb.append(Msg.translate(ctx, "AD_Role_ID")).append(eq)  .append(ctx.getContext("#AD_Role_Name")).append(NL);
		//
		sb.append(Msg.translate(ctx, "AD_Client_ID")).append(eq).append(ctx.getContext("#AD_Client_Name")).append(NL);
		sb.append(Msg.translate(ctx, "AD_Org_ID")).append(eq)   .append(ctx.getContext("#AD_Org_Name")).append(NL);
		//
		sb.append(Msg.translate(ctx, "Date")).append(eq)        .append(ctx.getContext("#Date")).append(NL);
		sb.append(Msg.translate(ctx, "Printer")).append(eq)     .append(ctx.getPrinterName()).append(NL);
		//
		Manifest mf = ZipUtil.getManifest("CClient.jar");
		if (mf == null)
			mf = ZipUtil.getManifest("CTools.jar");
		if (mf != null)
		{
			Attributes atts = mf.getMainAttributes();
			if (atts != null)
			{
				Iterator<?> it = atts.keySet().iterator();
				while (it.hasNext())
				{
					Object key = it.next();
					if (key.toString().startsWith("Impl") || key.toString().startsWith("Spec"))
						sb.append(key).append(eq).append(atts.get(key)).append(NL);
				}
			}
		}
		sb.append(Msg.translate(ctx, "CompiereHome" ) + " = ").append(Compiere.getCompiereHome()).append(NL);
		sb.append(Env.getLanguage(ctx)).append(NL);
		MClient client = MClient.get(ctx);
		sb.append(client).append(NL);
		sb.append(Msg.translate(ctx, "IsMultiLingualDocument"))
			.append(eq).append(client.isMultiLingualDocument()).append(NL);
		sb.append(Msg.translate(ctx, "BaseLanguage") + " = ").append(Env.isBaseLanguage(ctx, "AD_Window"))
			.append("/").append(Env.isBaseLanguage(ctx, "C_UOM")).append(NL);
		//TODO clmg
//		sb.append(SysEnv.getInfo(null)).append(NL);
		sb.append("PDF " + Msg.translate(ctx, "License") + "=").append(Document.isLicensed()).append(NL); 
		sb.append(Compiere.getJavaInfo()).append(NL);
		sb.append(Compiere.getOSInfo());
		//
		return sb;
	}   //  getInfo

	/**
	 *  Get Server Info.
	 *  @return host : port (NotActive) via CMhost : port
	 */
	private static String getServerInfo(Ctx ctx)
	{
		StringBuffer sb = new StringBuffer();
		CConnection cc = CConnection.get();
		//  Host
		sb.append(cc.getAppsHost()).append(" : ")
			.append(cc.getAppsPort())
			.append(" (");

		//  Server
		if (cc.isAppsServerOK(false))
			sb.append(CConnection.get().getServerVersion());
		else
			sb.append(Msg.translate(ctx, "NotActive"));
		//
		sb.append(")\n  ");
		//
		boolean remoteObjects = DB.isRemoteObjects();
		boolean remoteProcess = DB.isRemoteProcess();
		String realCP = CConnection.PROFILE_LAN;
		if (cc.isRMIoverHTTP() && cc.isAppsServerOK(false))
			realCP = CConnection.PROFILE_WAN;
		else if (remoteObjects && remoteProcess)
			realCP = CConnection.PROFILE_VPN;
		else if (remoteProcess)
			realCP = CConnection.PROFILE_TERMINAL;
		sb.append(cc.getConnectionProfileText(realCP));
		sb.append(": Tunnel=").append(cc.isRMIoverHTTP() && cc.isAppsServerOK(false))
			.append(", Objects=").append(remoteObjects)
			.append(", Process=").append(remoteProcess);

		return sb.toString();
	}   //  getServerInfo

	/**
	 *  Get Database Info
	 *  @return host : port : sid
	 */
	private static String getDatabaseInfo(Ctx ctx)
	{
		StringBuffer sb = new StringBuffer();
		sb.append(CConnection.get().getDbHost()).append(" : ")
			.append(CConnection.get().getDbPort()).append(" / ")
			.append(CConnection.get().getDbName());
		//  Connection Manager
		if (CConnection.get().isViaFirewall())
			sb.append(Msg.translate(ctx, "via")).append(" ")
				.append(CConnection.get().getFwHost()).append(" : ")
				.append(CConnection.get().getFwPort());

		return sb.toString();
	}   //  getDatabaseInfo
	
	/**
	 * 
	 * @param ctx
	 * @param sb
	 * @param isWeb
	 * @return
	 */
	public static StringBuffer getBrowserInfo(HttpServletRequest request, StringBuffer sb, boolean isWeb ) {
		String NL=Env.NL;
		if ( isWeb ) {
			NL=WEB_NL;
		}
		if (sb == null)
			sb = new StringBuffer();
		final String eq = " = ";

		sb.append( "Character Encoding " + eq + request.getCharacterEncoding() + NL );
		sb.append( "Request URI " + eq + request.getRequestURI() + NL );
		sb.append( "Servlet Path " + eq + request.getServletPath() + NL );
		sb.append( "Path Info " + eq + request.getPathInfo() + NL );
		sb.append( "Method " + eq + request.getMethod() + NL );
		sb.append( "Path Translate " + eq + request.getPathTranslated() + NL );
		sb.append( "Query String " + eq + request.getQueryString() + NL );
		sb.append( "Remote Address " + eq + request.getRemoteAddr() + NL );
		sb.append( "Remote Host " + eq + request.getRemoteHost() + NL );
		sb.append( "Remote User " + eq + request.getRemoteUser() + NL );
		sb.append( "Session ID " + eq + request.getRequestedSessionId() + NL );
		sb.append( "Scheme " + eq + request.getScheme() + NL );
		sb.append( "Server Name " + eq + request.getServerName() + NL );
		sb.append( "Server Port " + eq + String.valueOf(request.getServerPort()) + NL );
		sb.append( "Secure " + eq + request.isSecure() + NL );
		sb.append( "UserPrincipal " + eq + request.getUserPrincipal() + NL );
		sb.append( "AuthType " + eq + request.getAuthType() + NL );
		sb.append( "Locale " + eq + request.getLocale().toString() + NL );

		Enumeration<?> names = request.getHeaderNames();
		while (names.hasMoreElements()) {
			String name = (String)names.nextElement();
			sb.append( name + eq + request.getHeader(name) + NL );
		}

		names = request.getAttributeNames();
		while (names.hasMoreElements()) {
			String name = (String)names.nextElement();
			sb.append( name + eq + request.getHeader(name) + NL );
		}

		names = request.getParameterNames();
		while (names.hasMoreElements()) {
			String name = (String)names.nextElement();
			sb.append( name + eq + request.getHeader(name) + NL );
		}

		names = request.getAttributeNames();
		while (names.hasMoreElements()) {
			String name = (String)names.nextElement();
			sb.append( name + eq + request.getHeader(name) + NL );
		}

		Cookie[] ccc = request.getCookies();
		if (ccc != null) {
			sb.append( "Cookies:" + NL );
			for (int i = 0; i < ccc.length; i++) {
				sb.append( "\tName" + eq + ccc[i].getName() + NL );
				sb.append( "\tValue" + eq + ccc[i].getValue() + NL );
				sb.append( "\tDomain" + eq + ccc[i].getDomain() + NL );
				sb.append( "\tPath" + eq + ccc[i].getPath() + NL );
				sb.append( "\tMaxAge" + eq + ccc[i].getMaxAge() + NL );
			}
		}

		names = request.getLocales();
		while (names.hasMoreElements()) {
			sb.append( "Local" + eq + names.nextElement() + NL );
		}

		return sb;
	}

}	//	WAbout
