/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.web.servlet;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.NumberUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ecs.AlignType;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.button;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.tr;
import org.compiere.common.constants.DisplayTypeConstants;
import org.compiere.framework.Lookup;
import org.compiere.framework.Query;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridWindow;
import org.compiere.model.GridWindowVO;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;
import org.w3c.dom.Document;

import com.ampiere.util.AWebUtil;
import com.ampiere.util.AmpiereUtil;
import com.ampiere.util.Constants;
import com.jware.util.StringToIntConverter;

/**
 *  WAccount Servlet.
 *  <p>
 *  The servlet is invoked by a parent window via
 *  <code>
 *  WAccount?FormName=formName%ColumnName=columnName
 *  </code>
 *  and assumes that in the opening window/form there are two fields
 *  <code>
 *  opener.document.formName.columnName - The (hidden) field for the ID
 *  opener.document.formName.columnNameD - The display field for the value
 *  </code>
 *  When selecting an entry, the window is closed and the value of the two fields set.
 *
 *  @author Jorg Janke
 *  @version  $Id: WAccount.java,v 1.7 2010/05/22 08:34:43 clmg Exp $
 */
public class WAccount extends HttpServlet
{
	private static final long serialVersionUID = -6348547380305885368L;
	protected static final String FORM_NAME   = "WForm";
	private static final String P_Command   = "PCommand";
	/** Hidden Parameter - Changed Field for Callout/etc.	*/
	private static final String P_ChangedColumn = "ChangedColumn";
	
	private static final String M_ACCT_SCHEMA = "MAcctSchema";
	private static final String M_QUERY = "m_query";
	
	private GridWindow    		   m_mWindow = null;
	private GridTab                m_mTab = null;
	
	private static final String  GET_PARAMS_ACTION = "1";
	
	String f_Alias = null;
	String f_SubAcct_ID = null;
	String f_M_Product_ID = null;
	String f_C_BPartner_ID = null;
	String f_AD_OrgTrx_ID = null;
	String f_C_LocFrom_ID = null;
	String f_C_LocTo_ID = null;
	String f_C_SalesRegion_ID = null;
	String f_C_Project_ID = null;
	String f_C_Campaign_ID = null;
	String f_C_Activity_ID = null;
	String f_User1_ID = null;
	String f_User2_ID = null;
	String f_AD_Org_ID = null;
	String f_Account_ID = null;
	String f_Combination = null;
	String f_Description = null;
	int num = 0;
	tr globalLine = null;
	ArrayList<String> searchElementList = new ArrayList();	
	MAcctSchema s_AcctSchema;
	String script = null;
	boolean showResult = false;
	/**
	 * Initialize global variables
	 *
	 * @param config
	 * @throws ServletException
	 */
	public void init(ServletConfig config) throws ServletException
	{
		super.init(config);
		if (!WebEnv.initWeb(config))
			throw new ServletException("WAccount.init");
	}   //  init
	
	/**	Logger			*/
	private static CLogger log = CLogger.getCLogger(WAccount.class);

	/**
	 * Process the HTTP Get request - initial Start
	 * Needs to have parameters FormName and ColumnName
	 *
	 * @param request
	 * @param response
	 * @throws ServletException
	 * @throws IOException
	 */
	public void doGet (HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException
	{
		request.setCharacterEncoding("UTF-8"); 
		num = 0;
		script = "";
		setParameters(request);
		log.config( "WAccount.doGet");
		WebSessionCtx wsc = WebSessionCtx.get(request); 
		WWindowStatus ws = WWindowStatus.get(request);
		if (wsc == null || ws == null)
		{
			WebUtil.createTimeoutPage(request, response, this, null);
			return;
		}

		//  Get Mandatory Parameters
//		String formName = WebUtil.getParameter (request, "formName");
		String columnName = WebUtil.getParameter (request, "columnName");
		String actionType = request.getParameter(Constants.ACTION_TYPE);
		//
		if(GET_PARAMS_ACTION.equals(actionType)){
			showResult = false;
			Document xml_doc = getParamsXml(request);
			AWebUtil.createCalloutAjaxResponse(response, xml_doc);
			return;
		}
		
		GridField mField = ws.curTab.getField(columnName);
		log.config("ColumnName=" + columnName + ", MField=" + mField.toString());
		if (mField == null || columnName == null || columnName.equals(""))
		{
			WebUtil.createTimeoutPage(request, response, this,  
				Msg.getMsg(wsc.ctx, "ParameterMissing"));
			return;
		}

		String target = columnName;
			
		int noFields = ws.curTab.getFieldCount();
		for (int i = 0; i < noFields; i++)
		{
			GridField field = ws.curTab.getField(i);
			String columnNameTemp = field.getColumnName();

			if(	columnNameTemp .equals( "AD_Org_ID")){
				field.setValueValidate(request.getParameter("AD_Org_ID"),false);
				break;
			}
		}

		//  Create Document
		WebDoc doc = WebDoc.createWindow (mField.getHeader());
		doc.getHead().addElement(new script((Element)null, "js/account.js"));
		
	    StringBuffer sb = new StringBuffer();
	    sb.append("function selectAccount(columnName, key, value) {\n")
	        .append("    if (! checkParent(window)) {\n")
	        .append("        window.close();\n")
	        .append("		return;\n")
	        .append("	}\n")
	        .append("    var targetObj = null;\n")
	        .append("    var updateObj = null;\n")
	        .append("    if (window.opener.top.WWindow) {\n")
	        .append("    	targetObj = (window.opener.top.WWindow.document.getElementById(columnName + 'D'));\n")
	        .append("    	updateObj = (window.opener.top.WWindow.document.getElementById(columnName + 'F'));\n")
	        .append("    } else {\n")
	        .append("	    targetObj = (window.opener.top.document.getElementById(columnName + 'D'));\n")
	        .append("	    updateObj = (window.opener.top.document.getElementById(columnName + 'F'));\n")
	        .append("    }\n")
	        .append("    if (targetObj != null && updateObj != null) {\n")
	        .append("        targetObj.value = key;\n")
	        .append("        updateObj.value = value;\n")
	        .append("        startUpdate(updateObj);\n")
	        .append("    }\n")
	        .append("    window.close();\n")
	        .append("    window.opener.focus();\n")
	        .append("}\n");
		doc.getHead().addElement(new script(sb.toString()));
	    sb = new StringBuffer();
	    sb.append("function resetAccount(columnName) {\n")
	        .append("    selectAccount(columnName, '', '');\n")
	        .append("}\n");
		doc.getHead().addElement(new script(sb.toString()));

		body body = doc.getBody();
		if(!"C_ValidCombination_ID".equals(target)){
			body.setOnBlur("self.focus();");
		}
		
		body.addElement(searchTable(request,wsc,ws, mField, target));
		if("Save".equals(request.getParameter(P_Command))){
			String err_msg = null;
			err_msg = action_Save(request);
			if(StringUtils.isEmpty(err_msg)){
				String msg = WebEnv.NBSP + WebEnv.NBSP + "<font color='Red'>Your data has been successfully saved.</font>";
				body.addElement(msg);
			}else{
				String msg = WebEnv.NBSP + WebEnv.NBSP + "<font color='Red'>" + err_msg + "</font>";
				body.addElement(msg);
			}
		}
		
		div divBody = (div)new div().setID("body");
		
		//get combinationId 
		if(!StringUtils.isEmpty(request.getParameter("combinationId"))
				&& showResult == false){
			int m_C_AcctSchema_ID = wsc.ctx.getContextAsInt("$C_AcctSchema_ID");
			loadInfo(StringToIntConverter.StringToInt(request.getParameter("combinationId")), m_C_AcctSchema_ID);
			showResult = true;
		}
		
		//refresh
		action_Find(request, true);
		
		//show result
		if(showResult){
			divBody.addElement(fillTable(ws, mField, target));			
			showResult = false;
			if(!StringUtils.isEmpty(getFirstItemId(request, mField))){
				body.setOnLoad("getParamsRequest(" + getFirstItemId(request, mField) + ", '1');");
			}
		}else{
			divBody.addElement(new table().addElement(new tr().addElement(new td())));
		}
		
		body.addElement(divBody);

		WebUtil.createResponse (request, response, this, null, doc, false);
	}   //  doGet

	

	/**
	 *  Process the HTTP Post request - perform doGet
	 *  @param request
	 *  @param response
	 *  @throws ServletException
	 *  @throws IOException
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
	{
		log.config( "WAccount.doPost");
		showResult = true;
		doGet(request, response);
	}   //  doPost
	
	private String getFirstItemId(HttpServletRequest request, GridField mField){
		WWindowStatus ws = WWindowStatus.get(request);
		String id = "";
		//  Fill & list options
		Lookup lookup = mField.getLookup();
		
		if(m_mTab.getRowCount() > 0){
			m_mTab.navigate(0);
			Object key = m_mTab.getField("C_ValidCombination_ID").getValue();
			KeyNamePair np = (KeyNamePair)lookup.get(key);
			id = String.valueOf(np.getKey()); 
		}
		return id;
	}

	/*************************************************************************/

	/**
	 *  Fill Table (Generic)
	 *
	 * @param ws        WindowStatus
	 * @param mField    the Field
	 * @param target    target field string
	 * @return  Table with selection
	 */
	private table fillTable (WWindowStatus ws, GridField mField, String target)
	{
		table table = new table();
		table.setStyle("margin-top: 20px;");
		tr line = new tr();
		line.addElement(new th("&nbsp"));
		
		if(m_mTab.getRowCount() > 0){
			for(int i=0; i<searchElementList.size(); i++){
				String element = searchElementList.get(i);
				line.addElement(new th(Msg.translate(ws.ctx, element)).setStyle("text-align: center;"));
			}
			table.setBorder(1);
		}		

		table.addElement(line);
		
		//  Fill & list options
		Lookup lookup = mField.getLookup();
		lookup.fillComboBox(mField.isMandatory(false), true, true, true);   //  no context check
		
		for (int lineNo = 0; lineNo < m_mTab.getRowCount(); lineNo++)
		{
			//  Row
			m_mTab.navigate(lineNo);
			Object key = m_mTab.getField("C_ValidCombination_ID").getValue();
			KeyNamePair np = (KeyNamePair)lookup.get(key);
			button button = new button();
			button.addElement("&gt;");
			StringBuffer script = new StringBuffer("selectAccount('" + target + "', '" + np.getKey() + "', '" + np.getName() + "');");
			button.setOnClick(script.toString());
			//
			line = new tr();
			line.setOnClick("getParamsRequest(" + np.getKey() + ", '1');");
			line.setOnMouseOver("this.style.backgroundColor = 'red';");
			line.setOnMouseOut("this.style.backgroundColor = 'transparent';");
			line.addElement(new td(button));
			
			for(int i=0; i<searchElementList.size(); i++){
				String element = searchElementList.get(i);
				String searchField = "";
				try{
					searchField = m_mTab.getField(element).getValue().toString();
				}catch(Exception e){
					;
				}
				line.addElement(new td(searchField));
			}
			
			table.addElement(line);
		}
			
		//  Restore
		lookup.fillComboBox(true);
		return table;
	}   //  fillTable
	
	
	private form searchTable(HttpServletRequest request , WebSessionCtx wsc ,WWindowStatus ws, GridField mField, String target){
		form f ;

		int m_WindowNo = ws.getCurTab().getWindowNo() + 1;
		GridWindowVO mWindowVO = GridWindowVO.create (wsc.ctx, m_WindowNo, 153, 0);
		ws = new WWindowStatus(mWindowVO);
		m_mWindow = new GridWindow (mWindowVO);	
		
		f = getSR_Form (request, wsc, ws);
		
		f.addElement(new input("hidden", P_ChangedColumn, ""));    // 
		
		return f;
	}
	
	private form getSR_Form (HttpServletRequest request, WebSessionCtx wsc, WWindowStatus ws)
	{
		HttpSession session = request.getSession();
		log.fine("Tab=" + ws.curTab.getTabNo());
		searchElementList.clear();
		/***********************************************************************
		 * For all Fields
		 */

		div divBody = (div)new div().setID("body");
		table table = new table("0", "5", "5", "100%", null).setAlign(AlignType.CENTER);
		divBody.addElement(table);
		// table.setBorder(1).setBorderColor("#00FF00"); // debug field lines
		StringBuffer scriptSrc = new StringBuffer();
		//

		wsc.ctx.setContext(ws.curTab.getWindowNo(), "Record_ID", ws.curTab
				.getRecord_ID());

		int m_WindowNo = m_mWindow.getWindowNo();
		int m_C_AcctSchema_ID = wsc.ctx.getContextAsInt("$C_AcctSchema_ID");
		s_AcctSchema = new MAcctSchema (wsc.ctx, m_C_AcctSchema_ID, null);
		session.setAttribute(M_ACCT_SCHEMA, s_AcctSchema); //sessionにセットして、getParamsXmlのときつかう。
		//	Alias
		if (s_AcctSchema.isHasAlias())
		{
			String columnName = "Alias";
			table = addSearchElement(request, columnName, table);
		}	//	Alias

		//	Combination
		GridField combination = m_mTab.getField("Combination");
		table = addSearchElement(request, "Combination", table);

		/**
		 *	Create Fields in Element Order
		 */
		MAcctSchemaElement[] elements = s_AcctSchema.getAcctSchemaElements();
		for (int i = 0; i < elements.length; i++)
		{
			MAcctSchemaElement ase = elements[i];
			String type = ase.getElementType();
			boolean isMandatory = ase.isMandatory();
			//
			if (type.equals(MAcctSchemaElement.ELEMENTTYPE_Organization))
			{
				table = addSearchElement(request, "AD_Org_ID", table);
			}
			else if (type.equals(MAcctSchemaElement.ELEMENTTYPE_Account))
			{
				table = addSearchElement(request, "Account_ID", table);
			}
			else if (type.equals(MAcctSchemaElement.ELEMENTTYPE_SubAccount))
			{
				table = addSearchElement(request, "C_SubAcct_ID", table);
			}
			else if (type.equals(MAcctSchemaElement.ELEMENTTYPE_Product))
			{
				table = addSearchElement(request, "M_Product_ID", table);
			}
			else if (type.equals(MAcctSchemaElement.ELEMENTTYPE_BPartner))
			{
				table = addSearchElement(request, "C_BPartner_ID", table);
			}
			else if (type.equals(MAcctSchemaElement.ELEMENTTYPE_Campaign))
			{
				table = addSearchElement(request, "C_Campaign_ID", table);
			}
			else if (type.equals(MAcctSchemaElement.ELEMENTTYPE_LocationFrom))
			{
				table = addSearchElement(request, "C_LocFrom_ID", table);
			}
			else if (type.equals(MAcctSchemaElement.ELEMENTTYPE_LocationTo))
			{
				table = addSearchElement(request, "C_LocTo_ID", table);
			}
			else if (type.equals(MAcctSchemaElement.ELEMENTTYPE_Project))
			{
				table = addSearchElement(request, "C_Project_ID", table);
			}
			else if (type.equals(MAcctSchemaElement.ELEMENTTYPE_SalesRegion))
			{
				table = addSearchElement(request, "C_SalesRegion_ID", table);
			}
			else if (type.equals(MAcctSchemaElement.ELEMENTTYPE_OrgTrx))
			{
				table = addSearchElement(request, "AD_OrgTrx_ID", table);
			}
			else if (type.equals(MAcctSchemaElement.ELEMENTTYPE_Activity))
			{
				table = addSearchElement(request, "C_Activity_ID", table);
			}
			//	User1
			else if (type.equals(MAcctSchemaElement.ELEMENTTYPE_UserList1))
			{
				table = addSearchElement(request, "User1_ID", table);
			}
			else if (type.equals(MAcctSchemaElement.ELEMENTTYPE_UserList2))
			{
				table = addSearchElement(request, "User2_ID", table);
			}
		}	//	Create Fields in Element Order		

		if (scriptSrc.length() > 0)
			table.addElement(new script(scriptSrc.toString()));

		// Status Line
		int rowNo = ws.curTab.getCurrentRow();

		form myForm = new form();
		myForm.setTarget("_self");
		myForm.setID("WWindow" + ws.mWindow.getAD_Window_ID());
		myForm.setName(FORM_NAME);

		td toolbar = new td(null, AlignType.RIGHT, AlignType.MIDDLE, true);
		String AD_Language = Env.getAD_Language(ws.ctx);

		toolbar.addElement(createImage(AD_Language, "Save", "Save", null, true,
				false));
		toolbar.addElement(createImage(AD_Language, "Refresh", "Refresh", null, true,
				false));
		img refreshImg = createImage(AD_Language, "Ignore", "Ignore", null, true,
				false);
		refreshImg.setOnClick(script + "return false;");
		toolbar.addElement(refreshImg);		

		table toolTable = new table("0", "0", "5", "100%", null);
		toolTable.setID("WWindow.topTable");
		toolTable.addElement(new tr(toolbar));
		

		table.addElement(new input(input.TYPE_HIDDEN, P_Command, ""));
		myForm.addElement(divBody);
		myForm.addElement(toolTable);

		return myForm;
	}	// getSR_Form
	
	private table addSearchElement(HttpServletRequest request, String columnName, table table){
		HttpSession session = request.getSession();
		searchElementList.add(columnName);
		WebSessionCtx wsc = WebSessionCtx.get(request); 
		WWindowStatus ws = WWindowStatus.get(request);
		m_mTab = m_mWindow.getTab(0);
		session.setAttribute("m_mTab", m_mTab);
		GridField field = m_mTab.getField(columnName);

		if(num%2 == 0){
			globalLine = new tr();
		}
		num++;
		
		/**
		 * Get Data and convert to String (singleRow)
		 */
		Object oldStr = request.getParameter(columnName);
//		Object oData = ws.curTab.getValue(field);
		Object oData = request.getParameter(columnName);
		oData = (oData != null) ? oData : oldStr;
		oData = (oData != null && oData.equals("")) ? null : oData;
		//
		boolean hasDependents = ws.curTab.hasDependants(columnName);
		if (columnName.equals("Account_ID")
				&& request.getParameter("Account_ID") != null
				&& request.getParameter("Account_ID").equals("")
				&& "Save".equals(request.getParameter(P_Command))) {
			field.setErrorValue("");
		}

		String changeColum = request.getParameter(P_ChangedColumn);
		
		String param = request.getParameter("Account_ID");
		
		boolean changeColumFlag = false;
		
		String p_command = request.getParameter(P_Command);
		
		if ("C_SubAcct_ID".equals(field.getColumnName())
				&& ("Account_ID".equals(changeColum)
						|| "Save".equals(p_command) || "Find".equals(p_command))) {
			changeColumFlag = true;
		}
			//c_elementvalue_id
		addField(wsc, globalLine, field, oData, hasDependents, false,changeColumFlag,param);		

		table.addElement(globalLine);
		
		return table;
	}
	
	private void addField (WebSessionCtx wsc, tr line, GridField field, 
			Object oData, boolean hasDependents, boolean readOnly,boolean changeColumFlag,String param)
		{
			String columnName = field.getColumnName();
			//  Any Error?
			boolean error = field.isErrorValue();
			if (error)
				oData = field.getErrorValue();
			
			
			int dt = field.getDisplayType();
			boolean hasCallout = field.getCallout().length() > 0;

			int display_length = field.getDisplayLength();
			display_length = 20;
			
			/**
			 *  HTML Label Element
			 *      ID = ID_columnName
			 *
			 *  HTML Input Elements
			 *      NAME = columnName
			 *      ID = ID_columnName
			 */
			WebField wField = new WebField (field.getWindowNo(), wsc,
				columnName, field.getHeader(), field.getDescription(),
				dt, field.getFieldLength(), display_length * 12, field.isLongField(),
				// readOnly context check, mandatory no context check,  
				readOnly, field.isMandatory(false), error, 
				hasDependents, hasCallout, field.getAD_Process_ID(), field.isEncryptedField());
			
			if(changeColumFlag){
				line.addElement(wField.getLabel().setStyle("text-align:right;"));
				//line.addElement(addFieldCallOut(param,line));
			}else{
				line.addElement(wField.getLabel().setStyle("text-align:right;"))
				.addElement(wField.getField(field.getLookup(), oData, field.getAD_Column_ID()));
			}
			
			addCleanScript(field); //add initializing script	
		}	//	addField
	
	void addCleanScript(GridField field){
		int m_displayType = field.getDisplayType();
		String m_columnName = field.getColumnName();
		String defalueName = m_columnName + "F";
		String split_char = "|";
		if (m_displayType == DisplayType.Search || m_displayType == DisplayType.Location
				|| m_displayType == DisplayType.Account || m_displayType == DisplayType.PAttribute) // clmg
																									// 2009/04/19
		{
			script += getDefaultFieldInitScript(m_columnName + "D");
			script += getDefaultFieldInitScript(m_columnName + "F");
		} else {
			if (DisplayType.isLookup(m_displayType) || m_displayType == DisplayType.Locator) {
				script += getSelectFieldInitScript(m_columnName);				
			} else if (m_displayType == DisplayType.YesNo) {
				script += getCheckFieldInitScript(defalueName);
			} else if (m_displayType == DisplayType.Button) {
				script += getDefaultFieldInitScript(m_columnName + "D");
				script += getDefaultFieldInitScript(m_columnName + "F");
			} else if (DisplayType.isDate(m_displayType)) {
				script += getDefaultFieldInitScript(defalueName);	
			} else if (DisplayType.isNumeric(m_displayType)) {
				script += getDefaultFieldInitScript(defalueName);	
			} else if (m_displayType == DisplayType.Text) { // Strings
				script += getDefaultFieldInitScript(defalueName);	
			} else if (m_displayType == DisplayType.TextLong) {
				script += getDefaultFieldInitScript(defalueName);	
			} else if (m_displayType == DisplayType.Memo) {
				script += getDefaultFieldInitScript(defalueName);	
			} else {
				script += getDefaultFieldInitScript(defalueName);	
			}
		}
	}
	
	String getDefaultFieldInitScript(String id){
		return "document.getElementById('" + id + "').value='';";		 
	}
	
	String getSelectFieldInitScript(String id){
		String src = "document.getElementById('" + id + "').selectedIndex = -1;";
		return src;
	}
	String getCheckFieldInitScript(String id){
		String src = "document.getElementById('" + id + "').checked = false;";
		return src;
	}

	private static img createImage (String AD_Language, String name, String id, String js_command, boolean enabled, boolean pressed)
	{
		StringBuffer imgName = new StringBuffer(name);
		if (!enabled)
			imgName.append("D");
		else if (pressed)
			imgName.append("X");
		imgName.append("24.gif");
		//
		img img = new img (WebEnv.getImageDirectory(imgName.toString()), name);
		if (enabled)
			img.setAlt(Msg.getMsg(AD_Language, name));  //  Translate ToolTip

		if (enabled) {
			if (!pressed) {
				img.setClass("imgButton");
			}
			else
			{
				img.setClass("imgButtonPressed");
			}
			img.setOnMouseOver("btnMouseOver('" + id + "');");
			img.setOnMouseOut("btnMouseOut('" + id + "');");
		} else {
			img.setClass("imgButtonD");
		}
		img.setID(id);
		img.setStyle("");
		if (js_command == null){
			js_command = FORM_NAME + ".submit();";
			if (js_command.length() > 0 && enabled )
				img.setOnClick("if( submitting!=true ){ submitting=true; document." + FORM_NAME + "." + P_Command + ".value='" + name + "';" + js_command + "}; return false;");
		} else {
			if (js_command.length() > 0 && enabled )
				img.setOnClick("document." + FORM_NAME + "." + P_Command + ".value='" + name + "';" + js_command);
		}
		//
		return img;
	}   //  createImage

   //c_subacct  
   private String addFieldCallOut(String param,tr line){
	   ArrayList<KeyNamePair> list = new ArrayList<KeyNamePair>();
	   try {
			StringBuffer sql = new StringBuffer(
					"SELECT subacct.NAME, subacct.c_subacct_id");
			sql.append("  FROM c_subacct subacct");
			sql.append(" WHERE subacct.c_elementvalue_id = ?");
			PreparedStatement prep = DB.prepareStatement(sql.toString(), null);
			prep.setString(1, param);
			ResultSet rs = prep.executeQuery();
			while (rs.next())
				list.add(new KeyNamePair(rs.getInt(2), rs.getString(1)));

			
		} catch (Exception e) {
		log.log(Level.SEVERE, "WAccount.addFieldCallOut is error ", e);
	}
		return createHtml(list);
	}
   
   //create c_subacct html to web
   private String createHtml(ArrayList<KeyNamePair> list){
	  StringBuffer str= new StringBuffer("<td valign=\"middle\" align=\"left\">");
	  str.append("<select id=\"C_SubAcct_ID\" name=\"C_SubAcct_ID\">");
      for (int i = 0; i < list.size(); i++) {
    	  KeyNamePair keyPair  =   (KeyNamePair)list.get(i);
    	  str.append("<option value='"+keyPair.getKey()+"'>");  
    	  str.append(keyPair.getName());  
    	  str.append("</option>"); 
	}
	  str.append("</select>");
	  str.append("</td>");
	return str.toString();
	   
   }
   
	/**
	 *	Create/Save Account
	 */
	private String action_Save(HttpServletRequest request)
	{
		String err_msg = null;
		WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);
		HttpSession session = request.getSession();
		int m_WindowNo = ws.getCurTab().getWindowNo();
		int m_AD_Client_ID = wsc.ctx.getContextAsInt( m_WindowNo, "AD_Client_ID");
		String f_Alias = request.getParameter("Alias");
		String f_SubAcct_ID = request.getParameter("C_SubAcct_ID");
		String f_M_Product_ID = request.getParameter("M_Product_ID");
		String f_C_BPartner_ID = request.getParameter("C_BPartner_ID");
		String f_AD_OrgTrx_ID = request.getParameter("AD_OrgTrx_ID");
		String f_C_LocFrom_ID = request.getParameter("C_LocFrom_ID");
		String f_C_LocTo_ID = request.getParameter("C_LocTo_ID");
		String f_C_SalesRegion_ID = request.getParameter("C_SalesRegion_ID");
		String f_C_Project_ID = request.getParameter("C_Project_ID");
		String f_C_Campaign_ID = request.getParameter("C_Campaign_ID");
		String f_C_Activity_ID = request.getParameter("C_Activity_ID");
		String f_User1_ID = request.getParameter("User1_ID");
		String f_User2_ID = request.getParameter("User2_ID");
		String f_AD_Org_ID = request.getParameter("AD_Org_ID");
		String f_Account_ID = request.getParameter("Account_ID");
		
		
		log.info("");
		/**
		 *	Check completeness (mandatory fields) ... and for duplicates
		 */
		StringBuffer sb = new StringBuffer();
		StringBuffer sql = new StringBuffer ("SELECT C_ValidCombination_ID, Alias FROM C_ValidCombination WHERE ");
		Object value = null;
		if (s_AcctSchema.isHasAlias())
		{
			value = request.getParameter("Alias");
			if (value == null)
				sb.append(Msg.translate(wsc.ctx, "Alias")).append(", ");
		}
		MAcctSchemaElement[] elements = s_AcctSchema.getAcctSchemaElements();
		for (int i = 0; i < elements.length; i++)
		{
			MAcctSchemaElement ase = elements[i];
			String type = ase.getElementType();
			//
			if (type.equals(MAcctSchemaElement.ELEMENTTYPE_Organization))
			{
				value = request.getParameter("AD_Org_ID");
				sql.append("AD_Org_ID");
				if (value == null)
					sql.append(" IS NULL AND ");
				else
					sql.append("=").append(value).append(" AND ");
			}
			else if (type.equals(MAcctSchemaElement.ELEMENTTYPE_Account))
			{
				value = request.getParameter("Account_ID");
				sql.append("Account_ID");
				if (value == null)
					sql.append(" IS NULL AND ");
				else
					sql.append("=").append(value).append(" AND ");
			}
			else if (type.equals(MAcctSchemaElement.ELEMENTTYPE_SubAccount))
			{
				value = request.getParameter("C_SubAcct_ID");
				sql.append("C_SubAcct_ID");
				if (value == null)
					sql.append(" IS NULL AND ");
				else
					sql.append("=").append(value).append(" AND ");
			}
			else if (type.equals(MAcctSchemaElement.ELEMENTTYPE_Product))
			{
				value = request.getParameter("M_Product_ID");
				sql.append("M_Product_ID");
				if (value == null)
					sql.append(" IS NULL AND ");
				else
					sql.append("=").append(value).append(" AND ");
			}
			else if (type.equals(MAcctSchemaElement.ELEMENTTYPE_BPartner))
			{
				value = request.getParameter("C_BPartner_ID");
				sql.append("C_BPartner_ID");
				if (value == null)
					sql.append(" IS NULL AND ");
				else
					sql.append("=").append(value).append(" AND ");
			}
			else if (type.equals(MAcctSchemaElement.ELEMENTTYPE_Campaign))
			{
				value = request.getParameter("C_Campaign_ID");
				sql.append("C_Campaign_ID");
				if (value == null)
					sql.append(" IS NULL AND ");
				else
					sql.append("=").append(value).append(" AND ");
			}
			else if (type.equals(MAcctSchemaElement.ELEMENTTYPE_LocationFrom))
			{
				value = request.getParameter("C_LocFrom_ID");
				sql.append("C_LocFrom_ID");
				if (value == null)
					sql.append(" IS NULL AND ");
				else
					sql.append("=").append(value).append(" AND ");
			}
			else if (type.equals(MAcctSchemaElement.ELEMENTTYPE_LocationTo))
			{
				value = request.getParameter("C_LocTo_ID");
				sql.append("C_LocTo_ID");
				if (value == null)
					sql.append(" IS NULL AND ");
				else
					sql.append("=").append(value).append(" AND ");
			}
			else if (type.equals(MAcctSchemaElement.ELEMENTTYPE_Project))
			{
				value = request.getParameter("C_Project_ID");
				sql.append("C_Project_ID");
				if (value == null)
					sql.append(" IS NULL AND ");
				else
					sql.append("=").append(value).append(" AND ");
			}
			else if (type.equals(MAcctSchemaElement.ELEMENTTYPE_SalesRegion))
			{
				value = request.getParameter("C_SalesRegion_ID");
				sql.append("C_SalesRegion_ID");
				if (value == null)
					sql.append(" IS NULL AND ");
				else
					sql.append("=").append(value).append(" AND ");
			}
			else if (type.equals(MAcctSchemaElement.ELEMENTTYPE_OrgTrx))
			{
				value = request.getParameter("AD_OrgTrx_ID");
				sql.append("AD_OrgTrx_ID");
				if (value == null)
					sql.append(" IS NULL AND ");
				else
					sql.append("=").append(value).append(" AND ");
			}
			else if (type.equals(MAcctSchemaElement.ELEMENTTYPE_Activity))
			{
				value = request.getParameter("C_Activity_ID");
				sql.append("C_Activity_ID");
				if (value == null)
					sql.append(" IS NULL AND ");
				else
					sql.append("=").append(value).append(" AND ");
			}
			else if (type.equals(MAcctSchemaElement.ELEMENTTYPE_UserList1))
			{
				value = request.getParameter("User1_ID");
				sql.append("User1_ID");
				if (value == null)
					sql.append(" IS NULL AND ");
				else
					sql.append("=").append(value).append(" AND ");
			}
			else if (type.equals(MAcctSchemaElement.ELEMENTTYPE_UserList2))
			{
				value = request.getParameter("User2_ID");
				sql.append("User2_ID");
				if (value == null)
					sql.append(" IS NULL AND ");
				else
					sql.append("=").append(value).append(" AND ");
			}
			//
			if (ase.isMandatory() && value == null)
				sb.append(ase.getName()).append(", ");
		}	//	Fields in Element Order

		if (sb.length() != 0)
		{
			err_msg = AWebUtil.info(request, "FillMandatory", sb.substring(0, sb.length()-2));
			return err_msg;
		}
		if (StringUtils.isEmpty(request.getParameter("AD_Org_ID")))
		{
			err_msg = AWebUtil.info(request, "FillMandatory", Msg.getElement(wsc.ctx, "AD_Org_ID"));
			return err_msg;
		}
		if (StringUtils.isEmpty(request.getParameter("Account_ID")))
		{
			err_msg = AWebUtil.info(request, "FillMandatory", Msg.getElement(wsc.ctx, "Account_ID"));
			return err_msg;
		}

		
		/**
		 *	Check if already exists
		 */
		sql.append("AD_Client_ID=? AND C_AcctSchema_ID=?");
		log.fine("Check = " + sql.toString());
		int IDvalue = 0;
		String Alias = null;
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
			pstmt.setInt(1, m_AD_Client_ID);
			pstmt.setInt(2, s_AcctSchema.getC_AcctSchema_ID());
			ResultSet rs = pstmt.executeQuery();
			if (rs.next())
			{
				IDvalue = rs.getInt(1);
				Alias = rs.getString(2);
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql.toString(), e);
			IDvalue = 0;
		}
		log.fine("ID=" + IDvalue + ", Alias=" + Alias);

		if (Alias == null)
			Alias = "";

		//	We have an account like this already - check alias
		if (IDvalue != 0 && s_AcctSchema.isHasAlias()
			&& !Alias.equals(f_Alias))
		{
			sql = new StringBuffer("UPDATE C_ValidCombination SET Alias=");
			if (StringUtils.isEmpty(f_Alias))
				sql.append("NULL");
			else
				sql.append("'").append(f_Alias).append("'");
			sql.append(" WHERE C_ValidCombination_ID=").append(IDvalue);
			int i = 0;
			try
			{
				java.sql.Statement stmt = DB.createStatement();
				i = stmt.executeUpdate(sql.toString());
				stmt.close();
			}
			catch (SQLException e)
			{
				log.log(Level.SEVERE, sql.toString(), e);
			}
			if (i == 0)
				;//TODO
				//ADialog.error(m_WindowNo, this, "AccountNotUpdated");
		}

		//	load and display
		if (IDvalue != 0)
		{
			loadInfo (IDvalue, s_AcctSchema.getC_AcctSchema_ID());
			action_Find (request, false);
			return err_msg;
		}

		log.config("New");
		Alias = null;
		if (f_Alias != null)
			Alias = f_Alias;
		int C_SubAcct_ID = 0;
		if (!StringUtils.isEmpty(f_SubAcct_ID))
			C_SubAcct_ID = StringToIntConverter.StringToInt(f_SubAcct_ID);
		int M_Product_ID = 0;
		if (!StringUtils.isEmpty(f_M_Product_ID))
			M_Product_ID = StringToIntConverter.StringToInt(f_M_Product_ID);
		int C_BPartner_ID = 0;
		if (!StringUtils.isEmpty(f_C_BPartner_ID))
			C_BPartner_ID = StringToIntConverter.StringToInt(f_C_BPartner_ID);
		int AD_OrgTrx_ID = 0;
		if (!StringUtils.isEmpty(f_AD_OrgTrx_ID))
			AD_OrgTrx_ID = StringToIntConverter.StringToInt(f_AD_OrgTrx_ID);
		int C_LocFrom_ID = 0;
		if (!StringUtils.isEmpty(f_C_LocFrom_ID))
			C_LocFrom_ID = StringToIntConverter.StringToInt(f_C_LocFrom_ID);
		int C_LocTo_ID = 0;
		if (!StringUtils.isEmpty(f_C_LocTo_ID))
			C_LocTo_ID = StringToIntConverter.StringToInt(f_C_LocTo_ID);
		int C_SRegion_ID = 0;
		if (!StringUtils.isEmpty(f_C_SalesRegion_ID))
			C_SRegion_ID = StringToIntConverter.StringToInt(f_C_SalesRegion_ID);
		int C_Project_ID = 0;
		if (!StringUtils.isEmpty(f_C_Project_ID))
			C_Project_ID=  StringToIntConverter.StringToInt(f_C_Project_ID);
		int C_Campaign_ID = 0;
		if (!StringUtils.isEmpty(f_C_Campaign_ID))
			C_Campaign_ID = StringToIntConverter.StringToInt(f_C_Campaign_ID);
		int C_Activity_ID = 0;
		if (!StringUtils.isEmpty(f_C_Activity_ID))
			C_Activity_ID = StringToIntConverter.StringToInt(f_C_Activity_ID);
		int User1_ID = 0;
		if (!StringUtils.isEmpty(f_User1_ID))
			User1_ID = StringToIntConverter.StringToInt(f_User1_ID);
		int User2_ID = 0;
		if (!StringUtils.isEmpty(f_User2_ID))
			User2_ID = StringToIntConverter.StringToInt(f_User2_ID);

		int AD_Org_ID = StringToIntConverter.StringToInt(f_AD_Org_ID);
		int Account_ID = StringToIntConverter.StringToInt(f_Account_ID);
		MAccount acct = MAccount.get (wsc.ctx, m_AD_Client_ID, 
				AD_Org_ID, s_AcctSchema.getC_AcctSchema_ID(), 
				Account_ID, C_SubAcct_ID,
			M_Product_ID, C_BPartner_ID, AD_OrgTrx_ID,
			C_LocFrom_ID, C_LocTo_ID, C_SRegion_ID, 
			C_Project_ID, C_Campaign_ID, C_Activity_ID, 
			User1_ID, User2_ID, 0, 0);
		if (acct != null && acct.get_ID() == 0)
			acct.save();

		//  Show Info
		if (acct == null || acct.get_ID() == 0)
			loadInfo (0, 0);
		else
		{
			//	Update Account with optional Alias
			if (Alias != null && Alias.length() > 0)
			{
				acct.setAlias(Alias);
				acct.save();
			}
			loadInfo (acct.get_ID(), s_AcctSchema.getC_AcctSchema_ID());
		}
		action_Find (request, false);
		
		return err_msg;
	}	//	action_Save

	/**
	 *	Load Information
	 *  @param C_ValidCombination_ID valid combination
	 *  @param C_AcctSchema_ID acct schema
	 */
	private void loadInfo (int C_ValidCombination_ID, int C_AcctSchema_ID)
	{
		log.fine("C_ValidCombination_ID=" + C_ValidCombination_ID);
		String sql = "SELECT * FROM C_ValidCombination WHERE C_ValidCombination_ID=? AND C_AcctSchema_ID=?";
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql, null);
			pstmt.setInt(1, C_ValidCombination_ID);
			pstmt.setInt(2, C_AcctSchema_ID);
			ResultSet rs = pstmt.executeQuery();
			if (rs.next())
			{
				if (f_Alias != null)
					f_Alias = rs.getString("Alias");
				f_Combination = rs.getString("Combination");
				//
				f_AD_Org_ID = loadInfoOf (rs, "AD_Org_ID");
				f_Account_ID = loadInfoOf (rs, "Account_ID");
				f_SubAcct_ID = loadInfoOf (rs, "C_SubAcct_ID");
				//
				f_M_Product_ID = loadInfoOf (rs, "M_Product_ID");
				f_C_BPartner_ID = loadInfoOf (rs, "C_BPartner_ID");
				f_C_Campaign_ID = loadInfoOf (rs, "C_Campaign_ID");
				f_C_LocFrom_ID = loadInfoOf (rs, "C_LocFrom_ID");
				f_C_LocTo_ID = loadInfoOf (rs, "C_LocTo_ID");
				f_C_Project_ID = loadInfoOf (rs, "C_Project_ID");
				f_C_SalesRegion_ID = loadInfoOf (rs, "C_SalesRegion_ID");
				f_AD_OrgTrx_ID = loadInfoOf (rs, "AD_OrgTrx_ID");
				f_C_Activity_ID = loadInfoOf (rs, "C_Activity_ID");
				f_User1_ID = loadInfoOf (rs, "User1_ID");
				f_User2_ID = loadInfoOf (rs, "User2_ID");
				//
				f_Description = rs.getString("Description");
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql, e);
		}
	}	//	loadInfo
	
	/**
	 *	Set Value of Editor
	 *  @param rs result set
	 *  @param editor editor
	 *  @param name name
	 *  @throws SQLException
	 */
	private String loadInfoOf (ResultSet rs, String name) throws SQLException
	{
		String str = null;
		int intValue = rs.getInt(name);
		if (rs.wasNull())
			str = null;
		else
			str = String.valueOf(intValue);
		
		return str;
	}	//	loadInfoOf
	
	/**
	 *	Action Find.
	 *	- create where clause
	 *	- query database
	 *  @param includeAliasCombination include alias combination
	 */
	private void action_Find (HttpServletRequest request, boolean includeAliasCombination)
	{
	  	WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);
		HttpSession session = request.getSession();
		
		log.info("");

		//	Create where Clause
		Query query = null;
		Query m_query = (Query)session.getAttribute(M_QUERY);
		if (m_query != null)
			query = m_query.deepCopy();
		else
			query = new Query();
		//	Alias
		if (includeAliasCombination && !StringUtils.isEmpty(f_Alias))
		{
			String value = f_Alias.toUpperCase();
			if (!value.endsWith("%"))
				value += "%";
			query.addRestriction("UPPER(Alias)", Query.LIKE, value);
		}
		//	Combination (mandatory)
		if (includeAliasCombination && !StringUtils.isEmpty(f_Combination))
		{
			String value = f_Combination.toUpperCase();
			if (!value.endsWith("%"))
				value += "%";
			query.addRestriction("UPPER(Combination)", Query.LIKE, value);
		}
		//	Org (mandatory)
		if (!StringUtils.isEmpty(f_AD_Org_ID))
			query.addRestriction("AD_Org_ID", Query.EQUAL, f_AD_Org_ID);
		//	Account (mandatory)
		if (!StringUtils.isEmpty(f_Account_ID))
			query.addRestriction("Account_ID", Query.EQUAL, f_Account_ID);
		if (!StringUtils.isEmpty(f_SubAcct_ID))
			query.addRestriction("C_SubAcct_ID", Query.EQUAL, f_SubAcct_ID);

		//	Product
		if (!StringUtils.isEmpty(f_M_Product_ID))
			query.addRestriction("M_Product_ID", Query.EQUAL, f_M_Product_ID);
		//	BPartner
		if (!StringUtils.isEmpty(f_C_BPartner_ID))
			query.addRestriction("C_BPartner_ID", Query.EQUAL, f_C_BPartner_ID);
		//	Campaign
		if (!StringUtils.isEmpty(f_C_Campaign_ID))
			query.addRestriction("C_Campaign_ID", Query.EQUAL, f_C_Campaign_ID);
		//	Loc From
		if (!StringUtils.isEmpty(f_C_LocFrom_ID))
			query.addRestriction("C_LocFrom_ID", Query.EQUAL, f_C_LocFrom_ID);
		//	Loc To
		if (!StringUtils.isEmpty(f_C_LocTo_ID))
			query.addRestriction("C_LocTo_ID", Query.EQUAL, f_C_LocTo_ID);
		//	Project
		if (!StringUtils.isEmpty(f_C_Project_ID))
			query.addRestriction("C_Project_ID", Query.EQUAL, f_C_Project_ID);
		//	SRegion
		if (!StringUtils.isEmpty(f_C_SalesRegion_ID))
			query.addRestriction("C_SalesRegion_ID", Query.EQUAL, f_C_SalesRegion_ID);
		//	Org Trx
		if (!StringUtils.isEmpty(f_AD_OrgTrx_ID))
			query.addRestriction("AD_OrgTrx_ID", Query.EQUAL, f_AD_OrgTrx_ID);
		//	Activity
		if (!StringUtils.isEmpty(f_C_Activity_ID))
			query.addRestriction("C_Activity_ID", Query.EQUAL, f_C_Activity_ID);
		//	User 1
		if (!StringUtils.isEmpty(f_User1_ID))
			query.addRestriction("User1_ID", Query.EQUAL, f_User1_ID);
		//	User 2
		if (!StringUtils.isEmpty(f_User2_ID))
			query.addRestriction("User2_ID", Query.EQUAL, f_User2_ID);

		//	Query
		m_mTab.setQuery(query);
		m_mTab.query(0);
	}	//	action_Find
		
	void setParameters(HttpServletRequest request){
		f_Alias = request.getParameter("Alias");
		f_Combination = request.getParameter("Combination");
		f_SubAcct_ID = request.getParameter("C_SubAcct_ID");
		f_M_Product_ID = request.getParameter("M_Product_ID");
		f_C_BPartner_ID = request.getParameter("C_BPartner_ID");
		f_AD_OrgTrx_ID = request.getParameter("AD_OrgTrx_ID");
		f_C_LocFrom_ID = request.getParameter("C_LocFrom_ID");
		f_C_LocTo_ID = request.getParameter("C_LocTo_ID");
		f_C_SalesRegion_ID = request.getParameter("C_SalesRegion_ID");
		f_C_Project_ID = request.getParameter("C_Project_ID");
		f_C_Campaign_ID = request.getParameter("C_Campaign_ID");
		f_C_Activity_ID = request.getParameter("C_Activity_ID");
		f_User1_ID = request.getParameter("User1_ID");
		f_User2_ID = request.getParameter("User2_ID");
		f_AD_Org_ID = request.getParameter("AD_Org_ID");
		f_Account_ID = request.getParameter("Account_ID");
	}
	
	Document getParamsXml(HttpServletRequest request){
		WebSessionCtx wsc = WebSessionCtx.get(request);
		String param_key = request.getParameter("key");
		Document document = AmpiereUtil.CreateNewDocument(request);
		HttpSession session = request.getSession();
		MAcctSchema	s_AcctSchema = (MAcctSchema)session.getAttribute(M_ACCT_SCHEMA);
		GridTab m_mTab = (GridTab)session.getAttribute("m_mTab");
		tr line = new tr();
		for (int lineNo = 0; lineNo < m_mTab.getRowCount(); lineNo++)
		{
			//  Row
			m_mTab.navigate(lineNo);
			String oneKey = m_mTab.getField("C_ValidCombination_ID").getValue().toString();			
			if(param_key.equals(oneKey)){
				for(int i=0; i<searchElementList.size(); i++){
					String searchElement = searchElementList.get(i);
					String searchField = "";
					try{
						searchField = m_mTab.getField(searchElement).getValue().toString();
					}catch(Exception e){
						;
					}
					line.addElement(new td(searchField));
					
					//from here
					GridField field = m_mTab.getField(searchElement);
					org.w3c.dom.Element elements = (org.w3c.dom.Element)document.getFirstChild();
					if(DisplayType.isLookup(field.getDisplayType())
							&& field.getDisplayType() != DisplayTypeConstants.Search){
						//set select options
						Object[] list = field.getLookup().getData(true, true, false, false).toArray();    //clmg 2009/03/10
						org.w3c.dom.Element element = document.createElement(Constants.ELEMENT);
						document.getFirstChild().appendChild(element);						

						org.w3c.dom.Element elm_id=document.createElement(Constants.ID);
						String objId = getHtmlObjectName(field);
						elm_id.appendChild(document.createTextNode(objId));
						element.appendChild(elm_id);

						org.w3c.dom.Element elm_lookup=document.createElement(Constants.LOOKUP);
						element.appendChild(elm_lookup);
						elm_lookup.appendChild(document.createTextNode(Constants.ENABLED));

						org.w3c.dom.Element elm_visibility=document.createElement(Constants.VISIBILITY);
						element.appendChild(elm_visibility);
						elm_visibility.appendChild(document.createTextNode(Constants.ENABLED));

						org.w3c.dom.Element elm_newValue=document.createElement(Constants.NEW_VALUE);
						element.appendChild(elm_newValue);

						for(int p=0; p<list.length; p++){

							String key = "";
							String value = "";
							
							//null項目追加
							if(p == 0){
								org.w3c.dom.Element elm_item=document.createElement(Constants.ITEM);
								elm_newValue.appendChild(elm_item);
								//<key>
								org.w3c.dom.Element elm_key=document.createElement(Constants.KEY);
								elm_item.appendChild(elm_key);
								elm_key.appendChild(document.createTextNode(String.valueOf(key)));
								//<value>
								org.w3c.dom.Element elm_value=document.createElement(Constants.VALUE);
								elm_item.appendChild(elm_value);
								elm_value.appendChild(document.createTextNode(value));
							}


							boolean isNumber = list[0] instanceof KeyNamePair;
							if (isNumber)
							{
								KeyNamePair onePair = (KeyNamePair)list[p];
								key = String.valueOf(onePair.getKey());
								value = onePair.getName();
							}
							else
							{
								ValueNamePair onePair = (ValueNamePair)list[p];
								key = onePair.getValue();
								value = onePair.getName();
							}

							//list
							//<name>
							org.w3c.dom.Element elm_item=document.createElement(Constants.ITEM);
							elm_newValue.appendChild(elm_item);
							//<key>
							org.w3c.dom.Element elm_key=document.createElement(Constants.KEY);
							elm_item.appendChild(elm_key);
							elm_key.appendChild(document.createTextNode(String.valueOf(key)));
							//<value>
							org.w3c.dom.Element elm_value=document.createElement(Constants.VALUE);
							elm_item.appendChild(elm_value);
							elm_value.appendChild(document.createTextNode(value));
						}

						org.w3c.dom.Element elm_readonly=document.createElement(Constants.READONLY);
						element.appendChild(elm_readonly);
						elm_readonly.appendChild(document.createTextNode(Constants.NO));

						org.w3c.dom.Element elm_type=document.createElement(Constants.TYPE);
						element.appendChild(elm_type);
						elm_type.appendChild(document.createTextNode(Constants.ENABLED));
					}
					//

					if (field.isDisplayed(true))
					{

						Object newValue = field.getValue();


//						if(newValue==null && oldValue==null
//								|| newValue==null && oldValue!=null
//								|| newValue!=null && oldValue==null
//								|| !newValue.equals(oldValue)){
						if(true){
							// display and reset value
							//ルート要素に子ノード(lastnameタグ)を追加する
							org.w3c.dom.Element element = document.createElement(Constants.ELEMENT);
							elements.appendChild(element);

							/**
							 *  data elment below
							 */
							//CHECK BOX のルールは。。TODO
//							if(field.getDisplayType() != DisplayType.YesNo){
							org.w3c.dom.Element elm_id=document.createElement(Constants.ID);
							element.appendChild(elm_id);
							String objId = getHtmlObjectName(field);
							elm_id.appendChild(document.createTextNode(objId));

							org.w3c.dom.Element elm_lookup=document.createElement(Constants.LOOKUP);
							element.appendChild(elm_lookup);
							elm_lookup.appendChild(document.createTextNode(Constants.DISABLED));

							org.w3c.dom.Element elm_visibility=document.createElement(Constants.VISIBILITY);
							element.appendChild(elm_visibility);
							elm_visibility.appendChild(document.createTextNode(Constants.ENABLED));

							org.w3c.dom.Element elm_newValue=document.createElement(Constants.NEW_VALUE);
							element.appendChild(elm_newValue);
							String newValue_str = AWebUtil.toString(newValue, wsc, field.getDisplayType(), field.getColumnName(), field);
							elm_newValue.appendChild(document.createTextNode(newValue_str));

							org.w3c.dom.Element elm_readonly=document.createElement(Constants.READONLY);
							element.appendChild(elm_readonly);
							elm_readonly.appendChild(document.createTextNode(Constants.NO));


							org.w3c.dom.Element elm_type=document.createElement(Constants.TYPE);
							element.appendChild(elm_type);
							if(field.getDisplayType() == DisplayType.YesNo) {
								//|| field.getDisplayType() == DisplayType.Button){
								//if that is a checkbox, no need to change the value
								elm_type.appendChild(document.createTextNode(Constants.DISABLED));
							}else{
								elm_type.appendChild(document.createTextNode(Constants.ENABLED));
							}

							/**
							 * The display field       Name=columnName, ID=FcolumnName
							 * Show display field
							 * clmg 2009/03/10
							 */
							if (field.getDisplayType() == DisplayType.Search
									|| field.getDisplayType() == DisplayType.Location
									|| field.getDisplayType() == DisplayType.Account)
							{
								objId = field.getColumnName() + "F";								
								AWebUtil.createDisplayElement(document, elements, objId
										, field, Constants.NO, true);

								objId = field.getColumnName() + "B";
								AWebUtil.createDisplayElement(document, elements, objId
										, field, Constants.NO, true);
							}							
						}
					}
				}
			}

		}
		
		return document;
	}
	
	/**
	 * GridFieldによりhtml objectをゲットする。
	 * 主にはDisplayTypeにより、きめられること。
	 */
	private String getHtmlObjectName(GridField field){
		int m_displayType = field.getDisplayType();
		String m_columnName = field.getColumnName();
		String htmlObjId = "";
		if (m_displayType == DisplayType.Search
				|| m_displayType == DisplayType.Location
				|| m_displayType == DisplayType.Account
				|| m_displayType == DisplayType.PAttribute)
			{
				htmlObjId = (m_columnName + "D");
			} else {
				if (DisplayType.isLookup(m_displayType)
					|| m_displayType == DisplayType.Locator) {
					htmlObjId = (m_columnName);
				} else if (m_displayType == DisplayType.YesNo) {
					htmlObjId = (m_columnName + "F");
				} else if (m_displayType == DisplayType.Button) {
					htmlObjId = (m_columnName);
				} else if (DisplayType.isDate(m_displayType)) {
					htmlObjId = (m_columnName + "F");
				} else if (DisplayType.isNumeric(m_displayType)) {
					htmlObjId = (m_columnName + "F");
				} else if (m_displayType == DisplayType.Text) {	// Strings
					htmlObjId = (m_columnName + "F");
				} else if (m_displayType == DisplayType.TextLong) {
					htmlObjId = (m_columnName + "F");
				} else if (m_displayType == DisplayType.Memo) {
					htmlObjId = (m_columnName + "F");
				} else {
					htmlObjId = (m_columnName + "F");
				}
			}
		return htmlObjId;
	}
}   //  WAccount

