/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.web.servlet;

import java.io.IOException;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.commons.lang.StringUtils;
import org.apache.ecs.AlignType;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.span;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.textarea;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.FileUpload;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebUtil;
import org.w3c.dom.Document;

import com.ampiere.util.AWebUtil;
import com.ampiere.util.AmpiereUtil;
import com.ampiere.util.Constants;
import com.jware.util.StringToIntConverter;



/**
 *	HTML UI Attachment
 *	
 *  @author Jorg Janke
 *  @version $Id: WAttachment.java,v 1.8 2010/05/04 04:16:41 clmg Exp $
 */
public class WAttachment extends HttpServlet
{
	private static final long serialVersionUID = 7585292696988042858L;
	/**	Logger			*/
	private static CLogger	log = CLogger.getCLogger(WAttachment.class);
	
	/**	ACTIONS			*/
	private static String	UPLOAD_ACTION = "1";
	private static String	SELECT_ACTION = "2";
	private static String	DELETE_ACTION = "3";
	private static String	EXPORT_ACTION = "4";
	private static String	SAVE_ACTION = "5";
	private static String	DELETE_ENTIRE_ACTION = "6";
	private static String	ATTACHMENT = "attachment";
	
	/**
	 * Initialize global variables
	 */
	public void init(ServletConfig config)
		throws ServletException
	{
		super.init(config);
		if (!WebEnv.initWeb(config))
			throw new ServletException("WAttachment.init");
	}   //  init

	public static final String  P_Attachment_ID	= "AD_Attachment_ID";
	public static final String	P_ATTACHMENT_INDEX = "AttachmentIndex";
	public static final String	P_TEXTMSG = "TextMsg";

	
	/**
	 * 	Process the HTTP Get request.
	 * 	Initial display and streaming 
	 *  @param request request
	 *  @param response response
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException
	{
		log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
		HttpSession session = request.getSession(false);
		WWindowStatus ws = WWindowStatus.get(request);
		WebDoc doc = null;
		if (session == null || ws == null)
		{
			doc = WebDoc.createPopup ("No Context");
//			doc.addPopupClose();
			table bottomTable = new table("0", "0", "0", "100%", null);
			bottomTable.addElement(new tr().addElement(AmpiereUtil.createButtons(ws.ctx, false)));
			doc.getBody().addElement(bottomTable);
		}
		else
		{
			String error = null;
			int AD_Attachment_ID = WebUtil.getParameterAsInt(request, P_Attachment_ID);
			if (AD_Attachment_ID != 0)
			{
				int attachmentIndex = WebUtil.getParameterAsInt(request, P_ATTACHMENT_INDEX);
				if (attachmentIndex != 0)
				{
					error = streamAttachment (AD_Attachment_ID, attachmentIndex, response, ws);
					if (error == null)
						return;
				}
			}
			
			//export action 
			String actionType = WebUtil.getParameter(request, Constants.ACTION_TYPE);
			if(EXPORT_ACTION.equals(actionType)){
				AD_Attachment_ID = ws.curTab.getAD_AttachmentID();
				int attachmentIndex = WebUtil.getParameterAsInt(request, P_ATTACHMENT_INDEX);
				error = streamAttachment (AD_Attachment_ID, attachmentIndex, response, ws);
				return;	
			}
			
			doc = createPage (request, ws.ctx, ws.curTab.getAD_AttachmentID(),
				ws.curTab.getAD_Table_ID(), ws.curTab.getRecord_ID(), error);
		}
		

		
		//
		WebUtil.createResponse(request, response, this, null, doc, false);
	}   //  doGet


	/**
	 *  Process the HTTP Post request.
	 *  Update Attachment
	 *  @param request request
	 *  @parem response response
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException
	{
		log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
		HttpSession session = request.getSession();
		WWindowStatus ws = WWindowStatus.get(request);
		//
		WebDoc doc = null;
		if (ws == null)
			doc = WebDoc.create ("Help - No Context");
		else
		{
			String actionType = WebUtil.getParameter(request, Constants.ACTION_TYPE);
			int AD_Attachment_ID = ws.curTab.getAD_AttachmentID();
			int attachmentIndex = StringToIntConverter.StringToInt(WebUtil.getParameter(request, P_ATTACHMENT_INDEX));
			if(UPLOAD_ACTION.equals(actionType)){
				String error = processPost (request, response, ws);
				Document xml_doc = getDoc(request, error);
				AWebUtil.createCalloutAjaxResponse(response, xml_doc);
				return;
			}else if(SELECT_ACTION.equals(actionType)){
				Document xml_doc = getDoc(request, null);
				AWebUtil.createCalloutAjaxResponse(response, xml_doc);
				return;
			}else if(DELETE_ACTION.equals(actionType)){
				String error = deleteAttachment (request);
				Document xml_doc = getDoc(request, error);
				AWebUtil.createCalloutAjaxResponse(response, xml_doc);
				return;
			}else if(SAVE_ACTION.equals(actionType)){
				String msg = WebUtil.getParameter(request, P_TEXTMSG);
				MAttachment attachment = (MAttachment)session.getAttribute(ATTACHMENT);
				attachment.setTextMsg(msg);
				attachment.save();
				Document xml_doc = getDoc(request, null);
				AWebUtil.createCalloutAjaxResponse(response, xml_doc);
				return;
			}else if(DELETE_ENTIRE_ACTION.equals(actionType)){
				deleteEntireAttachment(request);
				Document xml_doc = getCloseDoc(request);
				AWebUtil.createCalloutAjaxResponse(response, xml_doc);
				return;
			}
		}
		//
		WebUtil.createResponse(request, response, this, null, doc, false);
	}   //  doPost

	/**
	 * 	Create Attachment Page
	 * 	@param ctx context
	 *	@param AD_Attachment_ID id for existing attachment
	 *	@param AD_Table_ID table for new attachment
	 *	@param Record_ID record for new attachment
	 *	@param error optional error message
	 *	@return WebDoc
	 */
	private WebDoc createPage (HttpServletRequest request, Ctx ctx, int AD_Attachment_ID,
		int AD_Table_ID, int Record_ID, String error)
	{
		HttpSession session = request.getSession();
		WebDoc doc = WebDoc.createWindow (Msg.translate(ctx, "AD_Attachment_ID"));
		AmpiereUtil.addProcessMsg(request, doc);
		doc.getHead().addElement(new script((Element)null, WebEnv.getBaseDirectory("js/attachment.js")));
		doc.getHead().addElement(new script((Element)null, WebEnv.getBaseDirectory("js/search.js")));
		doc.getHead().addElement(new script((Element)null, WebEnv.getBaseDirectory("js/protocalendar-js-1.1.0/javascripts/prototype.js")));
		doc.getHead().addElement(new script((Element)null, WebEnv.getBaseDirectory("js/protocalendar-js-1.1.0/javascripts/effects.js")));		
		
		table table = new table().setAlign(AlignType.CENTER);
		table.setBorder(0);
		table.setCellSpacing(5);
		doc.getBody().addElement(table);
		form upload = new form("WAttachment", form.METHOD_POST, form.ENC_UPLOAD);
		upload.setID("attachmentForm");
		table.addElement(upload);
		
		//
		if (error != null)
		{
			upload.addElement(new tr()
				.addElement(new td ("popupHeader", AlignType.RIGHT, AlignType.TOP, false, null))
				.addElement(new td ("popupHeader", AlignType.LEFT, AlignType.TOP, false, 
					new p(error, AlignType.LEFT).setClass("Cerror"))));	//	window.css
		}

		MAttachment attachment = null;
		if (AD_Attachment_ID != 0)
			attachment = new MAttachment(ctx, AD_Attachment_ID, null);
		else
			attachment = new MAttachment (ctx, AD_Table_ID, Record_ID, null);
		
		session.setAttribute("attachment", attachment);
		
		MAttachmentEntry[] entries = attachment.getEntries();
		MAttachmentEntry currentEntry = null;
		if(entries.length > 0){
			currentEntry = entries[0];
		}
		
		//
		tr tr = new tr();
//		td left = new td("popupCenter", AlignType.RIGHT, AlignType.TOP, false,
//			new label("TextMsg", "T", Msg.translate(ctx, "TextMsg")));
		td left = new td();
		td right = new td("popupCenter", AlignType.LEFT, AlignType.TOP, false);
		tr.addElement(left);
		tr.addElement(right);		
		upload.addElement(tr);
		
		//left
		table ltable = new table().setAlign(AlignType.CENTER);
		ltable.setBorder(0);
		ltable.setCellSpacing(0);	
		left.addElement(ltable);
		
		//left
		{
			td ltd1 = new td();
			ltable.addElement(new tr().addElement(ltd1));
			img deleteButton = new img(WebEnv.getImageDirectory("Delete32.png"), "Delete");
			deleteButton.setAlt("Delete");
			deleteButton.setTitle("Delete");
			deleteButton.setOnClick("deleteAttachment()");	
			ltd1.addElement(deleteButton);
			
			img exportButton = new img(WebEnv.getImageDirectory("Export32.png"), "Export");
			exportButton.setAlt("Export");
			exportButton.setTitle("Export");
			exportButton.setOnClick("exportAttachment()");	
			ltd1.addElement(exportButton);
			
			textarea info = new textarea("infoarea", 5, 40);
			if(currentEntry!=null){
				info.addElement(currentEntry.toStringX());
			}else{
				info.addElement("");
			}
			
			info.setID("infoarea");
			info.setReadOnly(true);
			td ltd2 = new td();
			ltd2.addElement(info);
			ltable.addElement(new tr().addElement(ltd2));
		}
		
		//right
		{
			//	Text Message Update
			table rtable = new table().setAlign(AlignType.CENTER);
			rtable.setBorder(0);
			rtable.setCellSpacing(5);
			right.addElement(rtable);
			

			upload.addElement(new input (input.TYPE_HIDDEN, P_Attachment_ID, AD_Attachment_ID));
			upload.addElement(new input (input.TYPE_HIDDEN, "AD_Table_ID", AD_Table_ID));
			upload.addElement(new input (input.TYPE_HIDDEN, "Record_ID", Record_ID));
			//upload.addElement(new input (input.TYPE_HIDDEN, P_ATTACHMENT_INDEX, 0).setID(P_ATTACHMENT_INDEX)); //clmg 2009/04/13
			upload.addElement(new input (input.TYPE_HIDDEN, P_Attachment_ID, AD_Attachment_ID));
			upload.addElement(new input (input.TYPE_HIDDEN, "AD_Table_ID", AD_Table_ID));
			upload.addElement(new input (input.TYPE_HIDDEN, "Record_ID", Record_ID));			
			
			//	Existing Links
			p p = new p();
			option[] options = new option[entries.length];
			
			for (int i = 0; i < entries.length; i++)
			{
				MAttachmentEntry entry = entries[i];
				options[i] = new option(String.valueOf(i+1)).addElement(entry.getName());
				if(i==0){
					options[i].setSelected(true);
				}
			}		
			select entriesSelect = new select(P_ATTACHMENT_INDEX,options);
			entriesSelect.setID(P_ATTACHMENT_INDEX);
			entriesSelect.setOnChange("selectAttachment();");
			
			td rtd1 = new td();
			rtd1.addElement(entriesSelect);
			rtable.addElement(new tr().addElement(rtd1));
			rtable.addElement(new tr().addElement(new td().addElement(WebDoc.NBSP)));
			
			//テキスト
			textarea msg = new textarea(P_TEXTMSG, 5, 40);
			msg.addElement(attachment.getTextMsg());
			msg.setID(P_TEXTMSG);
			td rtd2 = new td();
			rtd2.addElement(msg);
			rtable.addElement(new tr().addElement(rtd2));
			
			td uploadTd = new td();
			uploadTd.addElement(new label ("File").setFor("file").setID("sourcefile"));
			uploadTd.addElement(new input (input.TYPE_FILE, "file", "").setSize(40).setID("sourcefile"));
			input ok = new input (input.TYPE_BUTTON, "upload", "Upload");
			ok.setOnClick("uploadAttachment();");
			uploadTd.addElement(ok);
			rtable.addElement(new tr().addElement(uploadTd));
		}
	
		//	Footer
		table bottomTable = new table().setAlign(AlignType.CENTER);
		bottomTable.setBorder(0);
		bottomTable.setCellSpacing(5);

		td delEntireTd =  (td)new td().setClass("button-box");
		img delEntireButton = new img(WebEnv.getImageDirectory("Delete32.png"), "Delete");
		delEntireButton.setAlt("Delete Entire Attachment");
		delEntireButton.setTitle("Delete Entire Attachment");
		delEntireButton.setOnClick("deleteEntireAttachment()");
		delEntireTd.addElement(delEntireButton);
		
		td tdButton = (td)new td().setClass("button-box");
		input ok = AmpiereUtil.createImageButton(ctx, "Ok", "");
		ok.setOnClick("saveAttachment();");
		tdButton.addElement(ok);
		tdButton.addElement(new span("OK"));

		input cancel = AmpiereUtil.createImageButton(ctx, "Cancel", 
				"window.opener.top.WWindow.document.WForm.PCommand.value='Refresh';" +
		"window.opener.top.WWindow.document.WForm.submit();window.close();");
		tdButton.addElement(cancel);
		tdButton.addElement(new span("キャンセル"));

		tr lastTr = (tr)new tr();
		lastTr.addElement(delEntireTd);
		lastTr.addElement(tdButton);
		bottomTable.addElement(lastTr);
		doc.getBody().addElement(bottomTable);

		//親windowを更新したい場合
		//doc.getBody().setOnUnload("window.opener.location.reload();");
		
		return doc;
	}	//	createPage

	/**
	 * 	Stream Attachment Entry  
	 *	@param AD_Attachment_ID attachment
	 *	@param attachmentIndex index
	 *	@param response response
	 *	@param ws status
	 *	@return error message
	 */
	private String streamAttachment (int AD_Attachment_ID, int attachmentIndex,  
		HttpServletResponse response, WWindowStatus ws)
	{
		log.info("AD_Attachment_ID=" + AD_Attachment_ID 
			+ ", AttachmentIndex=" + attachmentIndex);

		MAttachment attachment = new MAttachment(ws.ctx, AD_Attachment_ID, null);
		if (attachment.get_ID() == 0)
		{
			log.fine("No Attachment AD_Attachment_ID=" + AD_Attachment_ID);
			return "Attachment not found";
		}
		
		//	Make sure it's the right attachment
		if (ws.curTab.getAD_AttachmentID() != AD_Attachment_ID)
		{
			log.warning ("Tab AD_Attachment_ID="
				+ ws.curTab.getAD_AttachmentID() + " <> " + AD_Attachment_ID);
			return "Your Attachment not found";
		}
		//	Stream it
		return WebUtil.streamAttachment (response, attachment, attachmentIndex);
	}	//	streamAttachment

	/**
	 * 	Process Post.
	 * 	Update / Create Attachment
	 * 	Upload Attachment Entry  
	 *	@param request request
	 *	@param response response
	 *	@return error message
	 */
	private String processPost (HttpServletRequest request, 
		HttpServletResponse response, WWindowStatus ws)
	{
		HttpSession session = request.getSession();
		
		int AD_Attachment_ID = 0;
		int AD_Table_ID = 0;
		int Record_ID = 0;
		String textMsg = null;
		FileUpload upload = null;
		
		//	URL Encrypted
		if (request.getContentType().equals(form.ENC_DEFAULT))
		{
			AD_Attachment_ID = WebUtil.getParameterAsInt(request, P_Attachment_ID);
			AD_Table_ID = WebUtil.getParameterAsInt(request, "AD_Table_ID");
			Record_ID = WebUtil.getParameterAsInt(request, "Record_ID");
			textMsg = WebUtil.getParameter (request, P_TEXTMSG);
		}
		else
		{
			upload = new FileUpload(request);
			String error = upload.getError();
			if (error != null)
			{
				log.warning("pocessPost - " + error);
				return error;
			}
//			AD_Attachment_ID = upload.getParameterAsInt(P_Attachment_ID);
			AD_Attachment_ID = ws.curTab.getAD_AttachmentID();
			AD_Table_ID = upload.getParameterAsInt("AD_Table_ID");
			Record_ID = upload.getParameterAsInt("Record_ID");
		}
	//	AmpiereWebEnv.dump(request);
		log.info("processPost - AD_Attachment_ID=" + AD_Attachment_ID 
			+ ", AD_Table_ID=" + AD_Table_ID + ", Record_ID=" + Record_ID
			+ " - Upload=" + upload);
		
		//	Check if you own the attachment
//		if (ws.curTab.getAD_AttachmentID() != AD_Attachment_ID)
//			return "Your Attachment not found";
		//	Check if we can save
		if (AD_Attachment_ID != 0 && Record_ID == 0)
			return "Need to save record first";

		MAttachment attachment = null;
		if (AD_Attachment_ID == 0)
			attachment = new MAttachment (ws.ctx, AD_Table_ID, Record_ID, null);
		else
			attachment = new MAttachment (ws.ctx, AD_Attachment_ID, null);
		
		//	Update Attachment Text
		if (textMsg != null)
			attachment.setTextMsg(textMsg);
		
		//	Create Attachment
		if (upload != null)
			attachment.addEntry(upload.getFileName(), upload.getData());
		
		//clmg 2009/04/10 do not delete this because it is mandatory
		if(attachment.getEntryCount()==0){
			;
		}
		
		//	Save and update
		if (attachment.save())
			ws.curTab.loadAttachments();	//	update Tab
		else
			return "Attachment not saved";	
		
		session.setAttribute(ATTACHMENT, attachment);
		
		//	OK
		return null;
	}	//	processPost
	
	private String deleteAttachment(HttpServletRequest request){
		HttpSession session = request.getSession();
		MAttachment attachment = (MAttachment)session.getAttribute(ATTACHMENT);
		attachment.deleteEntry(StringToIntConverter.StringToInt(
					(String)request.getParameter(P_ATTACHMENT_INDEX))-1);
		attachment.save();
		session.setAttribute(ATTACHMENT, attachment);
		
		return null;
	}
	
	Document getDoc(HttpServletRequest request, String error){
		HttpSession session = request.getSession();
		WWindowStatus ws = WWindowStatus.get(request);
		
		int AD_Attachment_ID = ws.curTab.getAD_AttachmentID();
		MAttachment attachment = (MAttachment)session.getAttribute(ATTACHMENT);
		MAttachmentEntry[] entries = attachment.getEntries();
		
		int attachmentIndex = WebUtil.getParameterAsInt(request, P_ATTACHMENT_INDEX);
		if(attachmentIndex > entries.length){
			attachmentIndex = entries.length;
		}
		if(attachmentIndex > 0){
			attachmentIndex -=1;
		}
				
		Document document = null;

		try{
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			//ビルダーからDOMを取得する
			document = builder.newDocument();

			org.w3c.dom.Element elements = document.createElement(Constants.ELEMENTS);
			document.appendChild(elements);

			org.w3c.dom.Element element = document.createElement(Constants.ELEMENT);
			elements.appendChild(element);

			org.w3c.dom.Element elm_id=document.createElement(Constants.ID);
			elm_id.appendChild(document.createTextNode(P_ATTACHMENT_INDEX));
			element.appendChild(elm_id);

			org.w3c.dom.Element elm_lookup=document.createElement(Constants.LOOKUP);
			element.appendChild(elm_lookup);
			elm_lookup.appendChild(document.createTextNode(Constants.ENABLED));

			org.w3c.dom.Element  elm_newValue=document.createElement(Constants.NEW_VALUE);
			element.appendChild(elm_newValue);

			//list (attachments)
			for (int i = 0; i < entries.length; i++)
			{
				org.w3c.dom.Element elm_item=document.createElement(Constants.ITEM);
				elm_newValue.appendChild(elm_item);
				//list
				//<name>
				MAttachmentEntry entry = entries[i];
				String key = String.valueOf(i+1);
				String value = entry.getName();					

				//<key>
				org.w3c.dom.Element elm_key=document.createElement(Constants.KEY);
				elm_item.appendChild(elm_key);
				elm_key.appendChild(document.createTextNode(String.valueOf(key)));
				//<value>
				org.w3c.dom.Element elm_value=document.createElement(Constants.VALUE);
				elm_item.appendChild(elm_value);
				elm_value.appendChild(document.createTextNode(value));
			}

			//current attachment information
			org.w3c.dom.Element element2 = document.createElement(Constants.ELEMENT);
			elements.appendChild(element2);

			org.w3c.dom.Element elm_id2=document.createElement(Constants.ID);
			elm_id2.appendChild(document.createTextNode("infoarea"));
			element2.appendChild(elm_id2);

			org.w3c.dom.Element elm_lookup2=document.createElement(Constants.LOOKUP);
			element2.appendChild(elm_lookup2);
			elm_lookup2.appendChild(document.createTextNode(Constants.DISABLED));

			org.w3c.dom.Element  elm_newValue2=document.createElement(Constants.NEW_VALUE);
			element2.appendChild(elm_newValue2);
			String newValue_str2 = "";
			try{
				newValue_str2 = entries[attachmentIndex].toStringX();
			}catch(Exception e){
				;
			}

			elm_newValue2.appendChild(document.createTextNode(newValue_str2));

			//current attachment message
			org.w3c.dom.Element element3 = document.createElement(Constants.ELEMENT);
			elements.appendChild(element3);

			org.w3c.dom.Element elm_id3=document.createElement(Constants.ID);
			elm_id3.appendChild(document.createTextNode("TextMsg"));
			element3.appendChild(elm_id3);

			org.w3c.dom.Element elm_lookup3=document.createElement(Constants.LOOKUP);
			element3.appendChild(elm_lookup3);
			elm_lookup3.appendChild(document.createTextNode(Constants.DISABLED));

			org.w3c.dom.Element  elm_newValue3=document.createElement(Constants.NEW_VALUE);
			element3.appendChild(elm_newValue3);
			String newValue_str3 = "";
			if(!StringUtils.isEmpty(attachment.getTextMsg())){
				newValue_str3 = attachment.getTextMsg();
			}
			elm_newValue3.appendChild(document.createTextNode(newValue_str3));
			
			//current selected index
			org.w3c.dom.Element element4 = document.createElement(Constants.ELEMENT);
			elements.appendChild(element4);

			org.w3c.dom.Element elm_id4=document.createElement(Constants.ID);
			elm_id4.appendChild(document.createTextNode("AttachmentSelectedIndex"));
			element4.appendChild(elm_id4);

			org.w3c.dom.Element elm_lookup4=document.createElement(Constants.LOOKUP);
			element4.appendChild(elm_lookup4);
			elm_lookup4.appendChild(document.createTextNode(Constants.DISABLED));

			org.w3c.dom.Element  elm_newValue4=document.createElement(Constants.NEW_VALUE);
			element4.appendChild(elm_newValue4);
			int selectedIndex = WebUtil.getParameterAsInt(request, P_ATTACHMENT_INDEX);
			if(selectedIndex <= 0){
				selectedIndex = 1;
			}else if(selectedIndex > entries.length){
				selectedIndex = entries.length;
			}
			String newValue_str4 = String.valueOf(selectedIndex);
			elm_newValue4.appendChild(document.createTextNode(newValue_str4));
			
			if(!StringUtils.isEmpty(error)){
				org.w3c.dom.Element element5 = document.createElement(Constants.ELEMENT);
				elements.appendChild(element5);
				org.w3c.dom.Element elementScript = document.createElement(Constants.SCRIPT);
				element5.appendChild(elementScript);
				elementScript.appendChild(document.createTextNode(error));
			}

		}catch(Exception e){
			;
		}
		
		return document;
	}
	
	/**
	 *	Delete entire Attachment
	 */
	private void deleteEntireAttachment(HttpServletRequest request)
	{
		HttpSession session = request.getSession();
		WWindowStatus ws = WWindowStatus.get(request);	
		MAttachment m_attachment = (MAttachment)session.getAttribute(ATTACHMENT);
		m_attachment.delete(true);
		session.setAttribute(ATTACHMENT, null);
		ws.curTab.loadAttachments();
	}	//	deleteAttachment
	
	Document getCloseDoc(HttpServletRequest request){
		HttpSession session = request.getSession();
		WWindowStatus ws = WWindowStatus.get(request);		
				
		Document document = null;

		try{
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			//ビルダーからDOMを取得する
			document = builder.newDocument();

			org.w3c.dom.Element elements = document.createElement(Constants.ELEMENTS);
			document.appendChild(elements);

			org.w3c.dom.Element element = document.createElement(Constants.ELEMENT);
			elements.appendChild(element);

			org.w3c.dom.Element elm_id=document.createElement("closeWindow");
			elm_id.appendChild(document.createTextNode("closeWindow"));
			element.appendChild(elm_id);

		}catch(Exception e){
			;
		}
		
		return document;
	}
		
}	//	WAttachment
