/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.web.servlet;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Date;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.ecs.AlignType;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.span;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.MAttribute;
import org.compiere.model.MAttributeInstance;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MAttributeValue;
import org.compiere.model.MLot;
import org.compiere.model.MLotCtl;
import org.compiere.model.MProduct;
import org.compiere.model.MRole;
import org.compiere.model.MSerNoCtl;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;
import org.w3c.dom.Document;

import com.ampiere.util.AWebUtil;
import com.ampiere.util.AmpiereUtil;
import com.ampiere.util.Constants;



/**
 *	HTML UI Attachment
 *	
 *  @author Jorg Janke
 *  @version $Id: WAttributeSet.java,v 1.6 2010/05/05 05:15:57 siqin Exp $
 */
public class WAttributeSet extends HttpServlet
{
	private static final long serialVersionUID = 7585292696988042858L;
	/**	Logger			*/
	private static CLogger	log = CLogger.getCLogger(WAttributeSet.class);

	/**
	 * Initialize global variables
	 */
	public void init(ServletConfig config)
		throws ServletException
	{
		super.init(config);
		if (!WebEnv.initWeb(config))
			throw new ServletException("WAttributeSet.init");
	}   //  init

	public static final String  P_Attachment_ID	= "AD_Attachment_ID";
	public static final String	P_ATTACHMENT_INDEX = "AttachmentIndex";
	public static final String	P_TEXTMSG = "TextMsg";
	
	public static final int		INSTANCE_VALUE_LENGTH = 40;
	private int					m_AD_Column_ID = 0;
	
	public static final int	 m_displayLength = 256;
	public static final String	 ACTION_TYPE = "actionType";
	public static final String	 ACTION_NEWLOT = "NEWLOT";
	public static final String	 ACTION_NEWSERNO = "NEWSERNO";
	public static final String	 ACTION_SAVE_SELECTION = "saveSelection";
	public static final String	 ACTION_SELECT_INSTANCE_ID = "selectInstanceId";
	public static final String	 SELECT_LOT_ID = "M_Lot_ID";
	public static final String	 SELECT_SERNO_ID = "SerNoF";

	
	/**
	 * 	Process the HTTP Get request.
	 * 	Initial display and streaming 
	 *  @param request request
	 *  @param response response
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException
	{
		log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
		HttpSession session = request.getSession(false);
		WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);
		WebDoc doc = null;
		
		int	m_WindowNo = ws.curTab.getWindowNo();
		boolean productWindow = m_AD_Column_ID == 8418;		//	HARDCODED
		int M_Product_ID = ws.ctx.getContextAsInt(m_WindowNo,"M_Product_ID");
		int M_ProductBOM_ID = ws.ctx.getContextAsInt(m_WindowNo,"M_ProductBOM_ID");
		int C_BPartner_ID = ws.ctx.getContextAsInt(m_WindowNo, "C_BPartner_ID");
		int oldValue = ws.ctx.getContextAsInt(m_WindowNo, "M_AttributeSetInstance_ID");
		int M_AttributeSetInstance_ID = oldValue;
		
		//	Exclude ability to enter ASI
		boolean exclude = true;
		if (M_Product_ID != 0)
		{
			MProduct product = MProduct.get(ws.ctx, M_Product_ID);
			int M_AttributeSet_ID = product.getM_AttributeSet_ID();
			if (M_AttributeSet_ID != 0)
			{
				MAttributeSet mas = MAttributeSet.get(ws.ctx, M_AttributeSet_ID);
				exclude = mas.excludeEntry(m_AD_Column_ID, ws.ctx.isSOTrx());
			}
		}
		
		boolean changed = false;
		if (M_ProductBOM_ID != 0)	//	Use BOM Component
			M_Product_ID = M_ProductBOM_ID;
		//	
		if (!productWindow && (M_Product_ID == 0 || exclude))
		{
			changed = true;
			ws.ctx.setContext(m_WindowNo, "M_AttributeSetInstance_ID", (String)null);
			M_AttributeSetInstance_ID = 0;
		}
		else
		{

//			VPAttributeDialog vad = new VPAttributeDialog (Env.getFrame (this), 
//				M_AttributeSetInstance_ID, M_Product_ID, m_C_BPartner_ID,
//				productWindow, m_AD_Column_ID, m_WindowNo);
//			if (vad.isChanged())
//			{
//				m_text.setText(vad.getM_AttributeSetInstanceName());
//				M_AttributeSetInstance_ID = vad.getM_AttributeSetInstance_ID();
//				changed = true;
//			}
		}
		
		
		if (session == null || ws == null)
		{
			doc = WebDoc.createPopup ("No Context");
//			doc.addPopupClose();
			table bottomTable = new table("0", "0", "0", "100%", null);
			bottomTable.addElement(new tr().addElement(AmpiereUtil.createButtons(ws.ctx, false)));
			doc.getBody().addElement(bottomTable);
		}
		else
		{
			String error = null;

			//			doc = createPage (ws.ctx, M_AttributeSetInstance_ID, M_Product_ID, m_C_BPartner_ID,
			//					productWindow, m_AD_Column_ID, m_WindowNo, error);
			request.setAttribute("BODY_ID", "popup");
			doc = WebDoc.createPopup (Msg.translate(ws.ctx, "M_AttributeSetInstance_ID"), request);
			AmpiereUtil.addDatePicker(doc.getHead(), wsc);
			doc.getHead().addElement(new script((Element)null, WebEnv.getBaseDirectory("js/wAttributeSet.js")));
			td center = doc.addWindowCenter(false);
			div divBody = (div)new div().setID("body");
			center.addElement(divBody);
			form myForm = new form ("WAttributeSet").setName("WAttributeSet" + M_AttributeSetInstance_ID);
			divBody.addElement(myForm);
			
			table myTable = new table("0", "0", "5", "100%", null);
			myTable.setStyle("margin-bottom:40px");
			myForm.addElement(myTable);

			initAttributes (myTable, wsc, ws.ctx, M_AttributeSetInstance_ID, 
					M_Product_ID, C_BPartner_ID, 
					productWindow, m_AD_Column_ID, m_WindowNo, error);
			
			addButton(divBody);
		}
		//
		WebUtil.createResponse(request, response, this, null, doc, false);
	}   //  doGet


	/**
	 *  Process the HTTP Post request.
	 *  Update Attachment
	 *  @param request request
	 *  @parem response response
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException
	{
		log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
//		HttpSession sess = request.getSession(false);
		WWindowStatus ws = WWindowStatus.get(request);
		//
		
		//for ajax action (New Lot or New SerNo)
		HttpSession session = request.getSession(false);
		WebSessionCtx wsc = WebSessionCtx.get(request);
		int	m_WindowNo = ws.curTab.getWindowNo();
		boolean productWindow = m_AD_Column_ID == 8418;		//	HARDCODED
		int M_Product_ID = ws.ctx.getContextAsInt(m_WindowNo,"M_Product_ID");
		int C_BPartner_ID = ws.ctx.getContextAsInt(m_WindowNo, "C_BPartner_ID");
		int oldValue = ws.ctx.getContextAsInt(m_WindowNo, "M_AttributeSetInstance_ID");
		int M_AttributeSetInstance_ID = oldValue;
		MAttributeSetInstance m_masi = MAttributeSetInstance.get(ws.ctx, M_AttributeSetInstance_ID, M_Product_ID);
		String actionType = request.getParameter(ACTION_TYPE);
		Document xml_doc = null;

		if (ACTION_NEWLOT.equals(actionType))
		{
			KeyNamePair pp = m_masi.createLot(M_Product_ID);
			if (pp != null)
			{
				xml_doc = get_New_Item(SELECT_LOT_ID, pp.getKey(), pp.getName());
			}
		}else if (ACTION_NEWSERNO.equals(actionType))
		{
			String newSerNo = m_masi.getSerNo(true);
			if (newSerNo != null)
			{
				xml_doc = get_New_Item(SELECT_SERNO_ID, -1, newSerNo);
//				fieldLot.addItem(pp);
//				fieldLot.setSelectedItem(pp);				
			}
		}else if (ACTION_SAVE_SELECTION.equals(actionType)){
			xml_doc =  get_Save_Selection_Result(request);
		}else if(ACTION_SELECT_INSTANCE_ID.equals(actionType)){
			String newValue = request.getParameter("instanceId");
			ws.ctx.setContext(m_WindowNo, "M_AttributeSetInstance_ID", newValue);
		}
		
		if(ACTION_NEWLOT.equals(actionType) 
				|| ACTION_NEWSERNO.equals(actionType)
				|| ACTION_SAVE_SELECTION.equals(actionType)){
			AWebUtil.createCalloutAjaxResponse(response, xml_doc);
		}else{
			WebDoc doc = null;
			if (ws == null)
				doc = WebDoc.create ("Help - No Context");
			else
			{

			}
			//
			WebUtil.createResponse(request, response, this, null, doc, false);
		}
		
		//

	}   //  doPost
	
	private  Document get_New_Item (String selectObjId, int key, String value)
	{
		Document document = null;
		try{
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			//ビルダーからDOMを取得する
			document = builder.newDocument();

			//XMLのルート要素(userタグ)を追加する
			org.w3c.dom.Element elements = document.createElement(Constants.ELEMENTS);
			document.appendChild(elements);   
			org.w3c.dom.Element element = document.createElement(Constants.ELEMENT);
			elements.appendChild(element);

			org.w3c.dom.Element elm_id=document.createElement(Constants.ID);
			elm_id.appendChild(document.createTextNode(selectObjId));
			element.appendChild(elm_id);

			org.w3c.dom.Element elm_key=document.createElement(Constants.KEY);
			elm_key.appendChild(document.createTextNode(String.valueOf(key)));
			element.appendChild(elm_key);

			org.w3c.dom.Element elm_value=document.createElement(Constants.VALUE);
			element.appendChild(elm_value);
			elm_value.appendChild(document.createTextNode(value));

		}catch(Exception e){
			log.warning( "Document get_New_Item (String selectObjId, KeyNamePair pp) error" );
		}
		return document;
	}
	
	private  Document get_Save_Selection_Result (HttpServletRequest request)
	{
		Document document = null;
		WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);		
		boolean m_productWindow = m_AD_Column_ID == 8418;		//	HARDCODED
		int	m_WindowNo = ws.curTab.getWindowNo();
		int M_Product_ID = ws.ctx.getContextAsInt(m_WindowNo,"M_Product_ID");
		int oldValue = ws.ctx.getContextAsInt(m_WindowNo, "M_AttributeSetInstance_ID");
		int m_M_AttributeSetInstance_ID = oldValue;
		String m_M_AttributeSetInstanceName = null;
		MAttributeSetInstance m_masi = MAttributeSetInstance.get(ws.ctx, m_M_AttributeSetInstance_ID, M_Product_ID);	
		MAttributeSet as = m_masi.getMAttributeSet();
		if (as == null)
			return null;

		// get request parameter
		String	fieldLotString	= request.getParameter("Lot");
		String	fieldSerNo	= request.getParameter("SerNo");
		String	fieldGuaranteeDate	= request.getParameter("GuaranteeDate");


		//
		Boolean m_changed = false;
		String mandatory = "";
		String alertScript = null;
		if (!m_productWindow && as.isLot())
		{
			log.fine("Lot=" + fieldLotString);
			String text = fieldLotString;
			m_masi.setLot (text);
			if (as.isLotMandatory() && (text == null || text.length() == 0))
				mandatory += " - " + Msg.translate(ws.ctx, "Lot");
			m_changed = true;
		}	//	Lot
		if (!m_productWindow && as.isSerNo())
		{
			log.fine("SerNo=" + fieldSerNo);
			String text = fieldSerNo;
			m_masi.setSerNo(text);
			if (as.isSerNoMandatory() && (text == null || text.length() == 0))
				mandatory += " - " + Msg.translate(ws.ctx, "SerNo");
			m_changed = true;
		}	//	SerNo
		if (!m_productWindow && as.isGuaranteeDate())
		{
			log.fine("GuaranteeDate=" + fieldGuaranteeDate);
			Timestamp ts = null;
			try{
				java.util.Date d = null;
				d = wsc.dateFormat.parse(fieldGuaranteeDate);
				ts = new Timestamp(d.getTime());
			}catch(Exception e){
				;
			}
			m_masi.setGuaranteeDate(ts);
			if (as.isGuaranteeDateMandatory() && ts == null)
				mandatory += " - " + Msg.translate(wsc.ctx, "GuaranteeDate");
			m_changed = true;
		}	//	GuaranteeDate

		//	***	Save Attributes ***
		//	New Instance
		if (m_changed || m_masi.getM_AttributeSetInstance_ID() == 0)
		{
			m_masi.save ();
			m_M_AttributeSetInstance_ID = m_masi.getM_AttributeSetInstance_ID ();
			m_M_AttributeSetInstanceName = m_masi.getDescription();
		}

		//	Save Instance Attributes
		MAttribute[] attributes = as.getMAttributes(!m_productWindow);
		for (int i = 0; i < attributes.length; i++)
		{
			if (MAttribute.ATTRIBUTEVALUETYPE_List.equals(attributes[i].getAttributeValueType()))
			{
				//					CComboBox editor = (CComboBox)m_editors.get(i);
				MAttributeValue[] values = attributes[i].getMAttributeValues();	//	optional = null
				String reqAttr = (String)request.getParameter(attributes[i].getName());
				MAttributeValue value = null;
				for (int a = 0; a < values.length; a ++){
					if(values[a]==null){
						continue;
					}
					if(values[a].getValue().equals(reqAttr)){
						value = values[a];
						break;
					}
				}
				log.fine(attributes[i].getName() + "=" + value);
				if (attributes[i].isMandatory() && value == null)
					mandatory += " - " + attributes[i].getName();
				attributes[i].setMAttributeInstance(m_M_AttributeSetInstance_ID, value);
			}
			else if (MAttribute.ATTRIBUTEVALUETYPE_Number.equals(attributes[i].getAttributeValueType()))
			{
				BigDecimal value =  new BigDecimal((String)request.getParameter(attributes[i].getName()));
				log.fine(attributes[i].getName() + "=" + value);
				if (attributes[i].isMandatory() && value == null)
					mandatory += " - " + attributes[i].getName();
				attributes[i].setMAttributeInstance(m_M_AttributeSetInstance_ID, value);
			}
			else
			{
				String value = (String)(Object)request.getParameter(attributes[i].getName());
				log.fine(attributes[i].getName() + "=" + value);
				if (attributes[i].isMandatory() && (value == null || value.length() == 0))
					mandatory += " - " + attributes[i].getName();
				attributes[i].setMAttributeInstance(m_M_AttributeSetInstance_ID, value);
			}
			m_changed = true;
		}	//	for all attributes

		//	Save Model
		if (m_changed)
		{
			m_masi.setDescription ();
			m_masi.save ();
		}
		m_M_AttributeSetInstance_ID = m_masi.getM_AttributeSetInstance_ID ();
		m_M_AttributeSetInstanceName = m_masi.getDescription();
		//
		if (mandatory.length() > 0)
		{
			alertScript = generateErrorScript(ws, m_WindowNo, "FillMandatory", mandatory);
		}

		try{		
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			//ビルダーからDOMを取得する
			document = builder.newDocument();

			//XMLのルート要素(userタグ)を追加する
			org.w3c.dom.Element elements = document.createElement(Constants.ELEMENTS);
			document.appendChild(elements);   
			
			org.w3c.dom.Element element = document.createElement(Constants.ELEMENT);
			elements.appendChild(element);
			org.w3c.dom.Element elm_id=document.createElement(Constants.ID);
			elm_id.appendChild(document.createTextNode("M_AttributeSetInstance_IDF"));
			element.appendChild(elm_id);
			org.w3c.dom.Element elm_key=document.createElement(Constants.KEY);
			elm_key.appendChild(document.createTextNode(m_M_AttributeSetInstanceName));
			element.appendChild(elm_key);
			org.w3c.dom.Element elm_value=document.createElement(Constants.VALUE);
			element.appendChild(elm_value);
			elm_value.appendChild(document.createTextNode(m_M_AttributeSetInstanceName));
			
			//new AttributeInstanceId below
			org.w3c.dom.Element elementAttributeInstanceId = document.createElement(Constants.ELEMENT);
			elements.appendChild(elementAttributeInstanceId);
			org.w3c.dom.Element Attribute_id=document.createElement(Constants.ID);
			Attribute_id.appendChild(document.createTextNode("M_AttributeSetInstance_IDD"));
			elementAttributeInstanceId.appendChild(Attribute_id);
			org.w3c.dom.Element Attribute_key=document.createElement(Constants.KEY);
			Attribute_key.appendChild(document.createTextNode(String.valueOf(m_M_AttributeSetInstance_ID)));
			elementAttributeInstanceId.appendChild(Attribute_key);
			org.w3c.dom.Element Attribute_value=document.createElement(Constants.VALUE);
			elementAttributeInstanceId.appendChild(Attribute_value);
			Attribute_value.appendChild(document.createTextNode(String.valueOf(m_M_AttributeSetInstance_ID)));

			//error script 
			if(alertScript!=null){
				org.w3c.dom.Element scriptElement = document.createElement(Constants.SCRIPT);
				elements.appendChild(scriptElement);				
				org.w3c.dom.Element elm=document.createElement(Constants.ITEM);
				elm.appendChild(document.createTextNode(alertScript));
				scriptElement.appendChild(elm);
			}

		}catch(Exception e){
			log.warning("Document get_New_Item (String selectObjId, KeyNamePair pp) error");
		}
		return document;
	}

	/**
	 * 	Create Attachment Page
	 * 	@param ctx context
	 *	@param AD_Attachment_ID id for existing attachment
	 *	@param AD_Table_ID table for new attachment
	 *	@param Record_ID record for new attachment
	 *	@param error optional error message
	 *	@return WebDoc
	 */
	private WebDoc createPage (Ctx ctx, int M_AttributeSetInstance_ID, 
			int M_Product_ID, int C_BPartner_ID, 
			boolean productWindow, int AD_Column_ID, int WindowNo, String error)
	{
		WebDoc doc = WebDoc.createPopup (Msg.translate(ctx, "AD_Attachment_ID"));
		table table = doc.getTable();
		//
		if (error != null)
		{
			table.addElement(new tr()
				.addElement(new td ("popupHeader", AlignType.RIGHT, AlignType.TOP, false, null))
				.addElement(new td ("popupHeader", AlignType.LEFT, AlignType.TOP, false, 
					new p(error, AlignType.LEFT).setClass("Cerror"))));	//	window.css
		}
		


		return doc;
	}	//	createPage

	
	/**
	 *	Dyanmic Init.
	 *  @return true if initialized
	 */
	private boolean initAttributes (table myTable, WebSessionCtx wsc, Ctx ctx, int m_M_AttributeSetInstance_ID, 
			int m_M_Product_ID, int C_BPartner_ID, 
			boolean m_productWindow, int AD_Column_ID, int m_WindowNo, String error)
	{
		if (m_M_Product_ID == 0)
			return false;
			
		//	Get Model
		MAttributeSetInstance m_masi = MAttributeSetInstance.get(ctx, m_M_AttributeSetInstance_ID, m_M_Product_ID);
		if (m_masi == null)
		{
			log.severe ("No Model for M_AttributeSetInstance_ID=" + m_M_AttributeSetInstance_ID + ", M_Product_ID=" + m_M_Product_ID);
			return false;
		}
		ctx.setContext(m_WindowNo, "M_AttributeSet_ID", m_masi.getM_AttributeSet_ID());

		//	Get Attribute Set
		MAttributeSet as = m_masi.getMAttributeSet();
		//	Product has no Attribute Set
		if (as == null)		
		{
//			ADialog.error(m_WindowNo, this, "PAttributeNoAttributeSet"); //TODO clmg
			return false;
		}
		//	Product has no Instance Attributes
		if (!m_productWindow && !as.isInstanceAttribute())
		{
//			ADialog.error(m_WindowNo, this, "PAttributeNoInstanceAttribute"); //TODO clmg
			return false;
		}
		
		table table = myTable;
		table.setCellSpacing(10);
		//既存attributesetから選択するためのhidden objects
		input hiddenInstanceDescription = new input (input.TYPE_HIDDEN, "newInstanceDescription", "");
		hiddenInstanceDescription.setID("newInstanceDescription");	
		hiddenInstanceDescription.setOnChange("setParentDescription();");
		table.addElement(hiddenInstanceDescription);		
		input hiddenInstanceId = new input (input.TYPE_HIDDEN, "newInstanceId", "");
		hiddenInstanceId.setID("newInstanceId");
		table.addElement(hiddenInstanceId);
		
		tr tr = new tr();
		td left = new td();
		td middle = new td();
		td right= new td();
		input cb = new input (input.TYPE_CHECKBOX, "cbNewEdit", "Y");
		cb.setID("cbNewEdit" + "F");		
		
		//	Show Product Attributes
		if (m_productWindow)
		{
			MAttribute[] attributes = as.getMAttributes (false);
			log.fine ("Product Attributes=" + attributes.length);
			for (int i = 0; i < attributes.length; i++)
				addAttributeLine(wsc, attributes[i], true, !m_productWindow, myTable,
						m_M_AttributeSetInstance_ID, m_M_Product_ID,
						C_BPartner_ID, m_productWindow, AD_Column_ID,
						m_WindowNo, error);
		}
		else	//	Set Instance Attributes
		{
			//	New/Edit - Selection
			if (m_M_AttributeSetInstance_ID == 0){		//	new
				label myLabel = new label("cbNewEdit"+"F", null, Util.maskHTML(Msg.getMsg(ctx, "NewRecord")));
				cb.setChecked(true).addElement(myLabel);
			}	
			else{
				label myLabel = new label("cbNewEdit"+"F", null, Util.maskHTML(Msg.getMsg(ctx, "EditRecord")));
				cb.setChecked(true).addElement(myLabel);
			}
			String onClick = "enableDisableNewRecord();";
			cb.setOnClick(onClick);
			left.addElement(cb);
			
	        input cbNewEdit = new input(input.TYPE_BUTTON, "SelectExisting", Msg.getMsg (ctx, "SelectExisting"));
	        cbNewEdit.setID("SelectExisting");
	        cbNewEdit.setOnClick("startLookupPAttributeInstance(" + m_WindowNo + ");");
			middle.addElement(cbNewEdit);
			
			tr.addElement(left).addElement(middle).addElement(right);
			table.addElement(tr);

			//	All Attributes
			MAttribute[] attributes = as.getMAttributes (true);
			log.fine ("Instance Attributes=" + attributes.length);
			for (int i = 0; i < attributes.length; i++)
				addAttributeLine (wsc, attributes[i], false, false, myTable,
						m_M_AttributeSetInstance_ID, m_M_Product_ID,
						C_BPartner_ID, m_productWindow, AD_Column_ID,
						m_WindowNo, error);
		}
		
//		//	Lot
		if (!m_productWindow && as.isLot())
		{
			String m_columnName = "Lot";
			input fieldLotString = new input(input.TYPE_TEXT, "Lot", Util.maskHTML(m_masi.getLot()));
			fieldLotString.setID(m_columnName + "F");
			fieldLotString.addAttribute("style","width:" + ( m_displayLength ) + "px;");
//			string.setMaxlength(m_fieldLength);//TODO
			//
			fieldLotString.setDisabled(false);
			fieldLotString.setReadOnly(true);
			if (error!=null)
				fieldLotString.setClass(WebField.C_ERROR);
			else if (false)
				fieldLotString.setClass(WebField.C_MANDATORY);
			//
//			if (m_hasDependents || m_hasCallout)
//				string.setOnChange("startUpdate(this);");
			
			tr = new tr();
			left = new td();
			middle = new td();
			right= new td();
			label label = new label (m_columnName).addElement(Msg.translate(ctx, "Lot"));
			left.addElement(label);
			middle.addElement(fieldLotString);
			tr.addElement(left).addElement(middle).addElement(right);
			table.addElement(tr);

			String sql = "SELECT M_Lot_ID, Name "
				+ "FROM M_Lot l "
				+ "WHERE EXISTS (SELECT M_Product_ID FROM M_Product p "
					+ "WHERE p.M_AttributeSet_ID=" + m_masi.getM_AttributeSet_ID()
					+ " AND p.M_Product_ID=l.M_Product_ID)";
			KeyNamePair[] keynamepair = DB.getKeyNamePairs(sql, true);
			option[] options = new option[keynamepair.length];
			for(int o=0; o<keynamepair.length; o++){
				if(keynamepair[o]==null){
					options[o] = new option("").addElement("");
				}else{
					options[o] = new option(String.valueOf(keynamepair[o].getKey())).addElement(keynamepair[o].getName());
					if(m_masi.getM_Lot_ID() != 0 && m_masi.getM_Lot_ID() == keynamepair[o].getKey()){
						options[o].setSelected(true);
					}
				}
			}
			
			//
			tr = new tr();
			left = new td();
			middle = new td();
			right= new td();
			
			m_columnName = "M_Lot_ID";
			
			select sel = new select(m_columnName, options);
			sel.setID(m_columnName);
	        sel.addAttribute("style","width:" + ( m_displayLength ) + "px;");
	        sel.setOnChange("setLotNum();");
			boolean found = false;

//			if (readOnly)
//				sel.setDisabled(true);			
			label = new label (m_columnName).addElement(Msg.translate(ctx, "M_Lot_ID"));
			
			left.addElement(label);
			middle.addElement(sel);			
			
//			fieldLot.addActionListener(this); //TODO
			//	New Lot Button
			if (m_masi.getMAttributeSet().getM_LotCtl_ID() != 0)
			{
				if (MRole.getDefault(ctx,false).isTableAccess(MLot.Table_ID, false)
					&& MRole.getDefault(ctx,false).isTableAccess(MLotCtl.Table_ID, false)
					&& !m_masi.isExcludeLot(m_AD_Column_ID, wsc.ctx.isSOTrx(m_WindowNo)))
				{
			        input newLotButton = new input(input.TYPE_BUTTON, "NewLot", Msg.getMsg (ctx, "New"));
			        newLotButton.setID("NewLot");
			        newLotButton.setOnClick("requestNewNumber('" + ACTION_NEWLOT + "');");			        
					right.addElement(newLotButton);
				}
			}
			tr.addElement(left).addElement(middle).addElement(right);
			table.addElement(tr);
//
//            //  Popup
//            fieldLot.addMouseListener(new MouseAdapter()
//            {
//                public void mouseClicked(MouseEvent e)
//                {
//                    if (SwingUtilities.isRightMouseButton(e))
//                        m_popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
//                }
//            });
//            
//            String actionKey = getClass().getName() + "_popop";
//            InputMap iMap = fieldLot.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
//            KeyStroke ks = KeyStroke.getKeyStroke(KeyEvent.VK_SPACE, KeyEvent.CTRL_MASK);
//            iMap.put(ks, actionKey);
//            fieldLot.getActionMap().put(actionKey, new AbstractAction()
//            {
//                public void actionPerformed(ActionEvent e)
//                {
//                    Component comp = (Component)e.getSource();
//                    m_popupMenu.show(comp, 10, 10);
//                }
//            });
//
//			mZoom = new CMenuItem(Msg.getMsg(ctx, "Zoom"), Env.getImageIcon("Zoom16.gif"));
//			mZoom.addActionListener(this);
//			m_popupMenu.add(mZoom);
		}	//	Lot
//
//		//	SerNo
		if (!m_productWindow && as.isSerNo())
		{
			tr = new tr();
			left = new td();
			middle = new td();
			right= new td();
			
			label label = new label ("SerNo" + "F").addElement(Msg.translate(ctx, "SerNo"));
			label.setID("SerNo" + "L");
			left.addElement(label);
			
			input fieldSerNo = new input(input.TYPE_TEXT, "SerNo", AmpiereUtil.maskHtmlCR(m_masi.getSerNo()));
			fieldSerNo.setID("SerNo" + "F");
			fieldSerNo.addAttribute("style","width:" + ( m_displayLength ) + "px;");
			fieldSerNo.setMaxlength(20);			
			middle.addElement(fieldSerNo);
			
			//	New SerNo Button
			if (m_masi.getMAttributeSet().getM_SerNoCtl_ID() != 0)
			{
				if (MRole.getDefault(ctx,false).isTableAccess(MSerNoCtl.Table_ID, false)
					&& !m_masi.isExcludeSerNo(m_AD_Column_ID, wsc.ctx.isSOTrx(m_WindowNo)))
				{
			        input newSerNobutton = new input(input.TYPE_BUTTON, "NewSerNo", Msg.getMsg (ctx, "New"));
			        newSerNobutton.setID("NewSerNo");
			        newSerNobutton.setOnClick("requestNewNumber('" + ACTION_NEWSERNO + "');");	
					right.addElement(newSerNobutton);
				}
			}
			tr.addElement(left).addElement(middle).addElement(right);
			table.addElement(tr);	
			
		}	//	SerNo
//
//		//	GuaranteeDate
		if (!m_productWindow && as.isGuaranteeDate())
		{
			tr = new tr();
			left = new td();
			middle = new td();
			right= new td();
			
			String m_columnName = "GuaranteeDate";
			label label = new label ("GuaranteeDate" + "F").addElement(Msg.translate(ctx, "GuaranteeDate"));
			label.setID("GuaranteeDate" + "L");
			left.addElement(label);
			
			Date data = null;
			if (m_M_AttributeSetInstance_ID == 0)
				data = m_masi.getGuaranteeDate(true);
			else
				data = m_masi.getGuaranteeDate();
			
			String formattedData = "";
			if(data!=null){
				formattedData = wsc.dateFormat.format(data);
			}			
			input string = new input(input.TYPE_TEXT, m_columnName, formattedData);
			String script_change_Flag = "setChangeFlag();";
			string.setOnChange(script_change_Flag);			
			string.setID(m_columnName + "F");
			string.setSize(m_displayLength);
			string.setMaxlength(20);
			string.addAttribute("style","width:" + ( m_displayLength ) + "px;");
			middle.addElement(string);
			
			div dateTimePickerScriptDiv = new div();//clmg 2009/03/08			
			img button = null;
			if (true) { //if (! m_readOnly) {
				// Show image button when field is editable
				String gif = "Calendar16.png";
				button = new img(WebEnv.getImageDirectory(gif), m_columnName);				
				button.setID(m_columnName + "B");
				button.setClass("popupButton");
				String onClick = ""; //clmg 2009/03/06
				String inputBoxId = m_columnName + "F";
				String buttonId = m_columnName + "B";
				AmpiereUtil.addDatePickerScript(dateTimePickerScriptDiv, inputBoxId, buttonId, wsc.language);
			}
			if (button != null) {
				middle.addElement(button);
				button.setOnClick(script_change_Flag);
				middle.addElement(dateTimePickerScriptDiv);
			}
			tr.addElement(left).addElement(middle).addElement(right);
			table.addElement(tr);
		}	//	GuaranteeDate
//
//		if (m_row == 0)
//		{
//			ADialog.error(m_WindowNo, this, "PAttributeNoInfo");
//			return false;
//		}
//
//		//	New/Edit Window
//		if (!m_productWindow)
//		{
//			cbNewEdit.setSelected(m_M_AttributeSetInstance_ID == 0);
//			cmd_newEdit();
//		}
//
//		//	Attrribute Set Instance Description
		
		tr = new tr();
		left = new td();
		middle = new td();
		right= new td();
		
		String m_columnName = "Description";
		label label = new label (m_columnName + "F").addElement(Msg.translate(ctx, m_columnName));
		label.setID(m_columnName + "L");
		left.addElement(label);
		
		input fieldDescription = new input(input.TYPE_TEXT, m_columnName, m_masi.getDescription());
		String script_change_Flag = "setChangeFlag();";
		fieldDescription.setOnChange(script_change_Flag);			
		fieldDescription.setID(m_columnName + "F");
		fieldDescription.setSize(m_displayLength);
		fieldDescription.setMaxlength(20);
		fieldDescription.addAttribute("style","width:" + ( m_displayLength ) + "px;");
		fieldDescription.setDisabled(true);
		middle.addElement(fieldDescription);
		tr.addElement(left).addElement(middle).addElement(right);
		table.addElement(tr);
		


//		//	Window usually to wide (??)
//		Dimension dd = centerPanel.getPreferredSize();
//		dd.width = Math.min(500, dd.width);
//		centerPanel.setPreferredSize(dd);
		return true;
	}	//	initAttribute

	/**
	 * 	Add Attribute Line
	 *	@param attribute attribute
	 * 	@param product product level attribute
	 * 	@param readOnly value is read only
	 */
	private void addAttributeLine (WebSessionCtx m_wsc, MAttribute attribute, boolean product, boolean readOnly, table myTable, 
			int m_M_AttributeSetInstance_ID, 
			int m_M_Product_ID, int C_BPartner_ID, 
			boolean m_productWindow, int AD_Column_ID, int m_WindowNo, String error)
	{
		log.fine(attribute + ", Product=" + product + ", R/O=" + readOnly);
		table tb = myTable;
		
		tr newTr = new tr();
		td left = new td();
		td middle = new td();
		td right = new td();
		newTr.addElement(left);
		newTr.addElement(middle);
		newTr.addElement(right);
		
		tb.addElement(newTr);
		
		
		label label = new label (attribute.getName()).addElement(attribute.getName());
		if (product)
//			label.setFont(new Font(label.getFont().getFontName(), Font.BOLD, label.getFont().getSize()));
		if (attribute.getDescription() != null)
			label.setOnMouseOver(attribute.getDescription());
		left.addElement(label);
		//
		
		String m_columnName = attribute.getName();
		
		MAttributeInstance instance = attribute.getMAttributeInstance (m_M_AttributeSetInstance_ID);
		if (MAttribute.ATTRIBUTEVALUETYPE_List.equals(attribute.getAttributeValueType()))
		{
			MAttributeValue[] values = attribute.getMAttributeValues();	//	optional = null
			option[] options = new option[values.length];
			for(int o=0; o<values.length; o++){
				if(values[o]==null){
					options[o] = new option("").addElement("");
				}else{
					options[o] = new option(values[o].getValue()).addElement(values[o].getName());
					if(instance!=null && values[o].getName().equals(instance.getValue())){
						options[o].setSelected(true);
					}
				}
			}
			select sel = new select(m_columnName, options);
			sel.setID(m_columnName);
	        sel.addAttribute("style","width:" + ( m_displayLength ) + "px;");
			boolean found = false;

			if (readOnly)
				sel.setDisabled(true);
			
			middle.addElement(sel);
			
		}
		else if (MAttribute.ATTRIBUTEVALUETYPE_Number.equals(attribute.getAttributeValueType()))
		{
			String formattedData = null;
			DecimalFormat decimalFormat = null;
			decimalFormat = m_wsc.numberFormat;	
			Object data = null;
			if (instance != null)
				data = instance.getValueNumber();
			else
				data = Env.ZERO;
			
			formattedData = m_wsc.numberFormat.format(data);
			
			input string = new input(input.TYPE_TEXT, m_columnName, formattedData);
			string.setID(m_columnName + "F");
			string.addAttribute("style","width:" + ( m_displayLength ) + "px;");
//			if (attribute.getm_fieldLength > 0)
//				string.setMaxlength(m_fieldLength); //TODO
			//
			string.setDisabled(readOnly);
			if (error!=null)
				string.setClass(WebField.C_ERROR);
			else if (attribute.isMandatory())
				string.setClass(WebField.C_MANDATORY);
			
			middle.addElement(string);

		}
		else	//	Text Field
		{
			String data = null;
			if (instance != null)
				data = instance.getValue();
			else
				data = "";
			
			input string = new input(input.TYPE_TEXT, m_columnName, Util.maskHTML(data));
			string.setID(m_columnName + "F");
			string.addAttribute("style","width:" + ( m_displayLength ) + "px;");
			string.setMaxlength(INSTANCE_VALUE_LENGTH);
			//
			string.setDisabled(readOnly);
			if (error!=null)
				string.setClass(WebField.C_ERROR);
			else if (attribute.isMandatory())
				string.setClass(WebField.C_MANDATORY);

			middle.addElement(string);
		}
	}	//	addAttributeLine
	
	private String generateErrorScript (WWindowStatus ws, int WindowNo, String AD_Message, String msg){
		StringBuffer strBuf = new StringBuffer();
		if (AD_Message != null && !AD_Message.equals(""))
			strBuf.append(Msg.getMsg(ws.ctx, AD_Message));
		if (msg != null && msg.length() > 0)
			strBuf.append("\\n").append(msg);
		return ("alert('" + strBuf.toString() + "');");
	}
	
	private void addButton(div divBody){
		td tdButton = new td().setColSpan(3);
		tdButton.setClass("lbl");
		img ok = new img(WebEnv.getImageDirectory("Ok32.png"), "OK");
		ok.setOnClick("saveSelection(this);");
		ok.setAlt("OK");
		ok.setTitle("OK");
		tdButton.addElement(ok);
		tdButton.addElement(new span("OK"));
		img cancel = new img(WebEnv.getImageDirectory("Cancel32.png"), "キャンセル");
		cancel.setOnClick("window.close(); return false;");
		cancel.setAlt("キャンセル");
		cancel.setTitle("キャンセル");
		tdButton.addElement(cancel);
		tdButton.addElement(new span("キャンセル"));
		div buttonDiv = (div)new div().setClass("bottomMenuRight");
		table buttonTable = new table();
		divBody.addElement(buttonDiv);		
		buttonDiv.addElement(buttonTable);
		buttonTable.addElement(new tr().addElement(tdButton));
	}

}	//	WAttachment
