/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.web.servlet;

import java.io.IOException;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.ecs.AlignType;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MLocation;
import org.compiere.model.MRole;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

import com.ampiere.util.AmpiereUtil;
import com.jware.util.StringToIntConverter;

/**
 *	HTML Find UI.
 *  @author Siqine
 *  @version  $Id: WBPartner.java,v 1.4 2010/03/30 03:37:32 siqin Exp $
 */
public class WBPartner extends HttpServlet {
    /**  */
	private static final long serialVersionUID = 6617424544044122702L;
	/**	Logger. */
    private CLogger log = CLogger.getCLogger(getClass());
    
	/** The Name of the Editor      */
	public static final String      NAME = "BPartner";

	/**
	 * Initialize global variables.
     * @param config config
     * @throws ServletException ServletException
	 */
	public final void init(final ServletConfig config)
		throws ServletException	{
		super.init(config);
		if (!WebEnv.initWeb(config)) {
			throw new ServletException("WProcess.init");
        }
	}   //  init

	/**
	 * Process the HTTP Get request Initial Call.
     * @param request request
     * @param response response
     * @throws ServletException ServletException
     * @throws IOException IOException
	 */
	public final void doGet(final HttpServletRequest request, final HttpServletResponse response)
		throws ServletException, IOException {

        //  Get Session attributes
	  	WebSessionCtx wsc = WebSessionCtx.get(request);
		if (wsc == null) {
			WebUtil.createTimeoutPage(request, response, this, null);
			return;
		}
		
		WebDoc doc = createBPartnerPage(request);

		if (doc == null) {
			doc = WebDoc.createWindow("Error");
		}

		// Add body onUnload event, close all popup window when unload 
		doc.getBody().setOnUnload("closeMyChildren();");

		//
		WebUtil.createResponse(request, response, this, null, doc, false);
	}   //  doGet


	/**
	 * Process the HTTP Post request. Get Parameters and Process.
     * @param request request
     * @param response response
     * @throws ServletException ServletException
     * @throws IOException IOException
	 */
	public final void doPost(final HttpServletRequest request, final HttpServletResponse response)
		throws ServletException, IOException {

        //  Get Session attributes
	  	WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);
		if (wsc == null) {
			WebUtil.createTimeoutPage(request, response, this, null);
			return;
		}
		
		MBPartner m_partner = null;
		//	***** Business Partner *****
		int C_BPartner_ID = StringToIntConverter.StringToInt(WebUtil.getParameter(request, "C_BPartner_ID"));
		if(C_BPartner_ID != 0){
			m_partner = new MBPartner (ws.ctx, C_BPartner_ID, null);
		}
		
		if (m_partner == null)
		{
			int m_WindowNo = 0;
			int AD_Client_ID = ws.ctx.getAD_Client_ID();
			m_partner = MBPartner.getTemplate(ws.ctx, AD_Client_ID);
			boolean isSOTrx = ws.ctx.isSOTrx(m_WindowNo);
			m_partner.setIsCustomer (isSOTrx);
			m_partner.setIsVendor (!isSOTrx);
		}
		
		actionSave(request, m_partner);

		WebDoc doc = WebDoc.createWindow(Msg.getMsg(ws.ctx, NAME));
		
		doc.getBody().setOnLoad("updateParentBPartner('" + m_partner.getC_BPartner_ID() + "','" + m_partner.getName() + "');return false;");

		WebUtil.createResponse(request, response, this, null, doc, false);
	}   //  doPost

	/**
	 * 	Create Find Page.
	 *	@param request request
	 *	@return Page
	 */
	private WebDoc createBPartnerPage(final HttpServletRequest request) {
	  	WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);
		
		String bpartner_id = WebUtil.getParameter(request, "bpartnerID"); //input
		boolean newRecord = StringUtils.isEmpty(bpartner_id)?true:false;
		String columnName = WebUtil.getParameter(request, "columnName"); //input
		int m_WindowNo = ws.mWindow.getWindowNo();
		
		boolean m_readOnly = !MRole.getDefault(wsc.ctx,false).canUpdate(
			ws.ctx.getAD_Client_ID(), ws.ctx.getAD_Org_ID(), 
			MBPartner.Table_ID, 0, false);
		
		int C_BPartner_ID = 0;
		//  if update, get current value
		if (!newRecord)
		{
			C_BPartner_ID = StringToIntConverter.StringToInt(bpartner_id);
		}

		WebDoc doc = WebDoc.createWindow(Msg.getMsg(ws.ctx, NAME));
		
		form myForm = new form(request.getRequestURI());
		myForm.setID("WBPartner");
		table myTable = new table();
		myTable.setAlign("CENTER");
		div divBody = (div)new div().setID("body"); //clmg 2009/02/24
		divBody.addElement(myTable);//clmg 2009/02/24		
		
		String V_searchKey = "";
		String V_Greeting = "";  
		String V_Name = "";
		String V_Name2 = "";
		String V_Contact = "";
		String V_GreetingC = "";
		String V_Title = "";
		String V_EMail = "";
		String V_C_Location_ID = "";
		String V_C_Location_Display = "";
		String V_Phone = "";
		String V_Phone2 = "";
		String V_Fax = "";
			
		if(C_BPartner_ID != 0){
			
			MBPartner m_partner = new MBPartner (ws.ctx, C_BPartner_ID, null);
			//	BPartner - Load values
			
			V_searchKey = m_partner.getValue();
			V_Greeting = String.valueOf(m_partner.getC_Greeting_ID());
			V_Name = m_partner.getName();
			V_Name2 = m_partner.getName2();

			//	Contact - Load values
			MBPartnerLocation m_pLocation = m_partner.getLocation(
				ws.ctx.getContextAsInt( m_WindowNo, "C_BPartner_Location_ID"));
			if (m_pLocation != null)
			{
				int location = m_pLocation.getC_Location_ID();
				V_C_Location_ID = String.valueOf(new Integer(location));
				String tmp = m_pLocation.toString();
				V_C_Location_Display = m_pLocation.getLocation(true).toString();
				//
				V_Phone = m_pLocation.getPhone();
				V_Phone2 = m_pLocation.getPhone2();
				V_Fax = m_pLocation.getFax();
			}
			//	User - Load values
			MUser m_user = m_partner.getContact(
				ws.ctx.getContextAsInt( m_WindowNo, "AD_User_ID"));
			if (m_user != null)
			{
				V_GreetingC = String.valueOf(m_user.getC_Greeting_ID());
				V_Contact = m_user.getName();
				V_Title = m_user.getTitle();
				V_EMail = m_user.getEMail();
				//
				V_Phone = m_user.getPhone();
				V_Phone2 = m_user.getPhone2();
				V_Fax = m_user.getFax();
			}
		}
				
		//hidden bpartnerId
		input hiddBpartnerId = new input(input.TYPE_HIDDEN, "C_BPartner_ID", C_BPartner_ID);
		hiddBpartnerId.setID("C_BPartner_ID");
		myForm.addElement(hiddBpartnerId);		
		
		tr myTr = new tr(new td(WebDoc.NBSP).setColSpan(2));
		myTable.addElement(getStringTr(request, "Value", "searchKey", V_searchKey));
		//		Greeting Business Partner
		myTable.addElement(getSelectTr (request, "Greeting", "Greeting", V_Greeting));		
//		Name
		myTable.addElement(getStringTr(request, "Name", "Name", V_Name));
//		Name2		
		myTable.addElement(getStringTr(request, "Name2", "Name2", V_Name2));
//		Contact
		myTable.addElement(getStringTr(request, "Contact", "Contact", V_Contact));
//		Greeting Contact
		myTable.addElement(getSelectTr (request, "Greeting", "GreetingC", V_GreetingC));
//		Title
		myTable.addElement(getStringTr(request, "Title", "Title", V_Title));
//		Email
		myTable.addElement(getStringTr(request, "EMail", "EMail", V_EMail));
//		Location
		boolean ro = m_readOnly;
		if (!ro)
			ro = !MRole.getDefault(wsc.ctx,false).canUpdate(
				ws.ctx.getAD_Client_ID(),ws.ctx.getAD_Org_ID(), 
				MBPartnerLocation.Table_ID, 0, false);
		if (!ro)
			ro = !MRole.getDefault(wsc.ctx,false).canUpdate(
				ws.ctx.getAD_Client_ID(), ws.ctx.getAD_Org_ID(), 
				MLocation.Table_ID, 0, false);
		
		myTable.addElement(getLocationField (request, "C_Location_ID", V_C_Location_Display, 
				"C_Location_ID", V_C_Location_ID));
		
		//	Phone		
		myTable.addElement(getStringTr(request, "Phone", "Phone", V_Phone));
		//	Phone2
		myTable.addElement(getStringTr(request, "Phone2", "Phone2", V_Phone2));
		//	Fax
		myTable.addElement(getStringTr(request, "Fax", "Fax", V_Fax));
		
		div divButtonBox = (div)new div().setClass("button-box");	
		img cancel = new img(WebEnv.getImageDirectory("Cancel32.png"), "Cancel");
		cancel.setOnClick("window.close(); return false;");
		divButtonBox.addElement(cancel);
		cancel.setID("btn_cancel");
		input submit = new input(input.TYPE_IMAGE, "btn_submit", "OK");
		submit.setSrc(WebEnv.getImageDirectory("Ok32.png"));
		submit.setID("btn_submit");
		submit.setOnClick("checkBPartner();return false;");
		divButtonBox.addElement(submit);		

		myTr = new tr();
		myTable.addElement(myTr);
		myTr.addElement(new td());
		td buttonTd = new td();
		buttonTd.setAlign(AlignType.RIGHT);
		buttonTd.addElement(divButtonBox);
		myTr.addElement(buttonTd);
		
		myForm.addElement(divBody);
		doc.getBody().addElement(myForm);

		return doc;
	}	//	createFindPage

	
	public tr getStringTr(HttpServletRequest request, String lableName, String textName, String value){
		WWindowStatus ws = WWindowStatus.get(request);
		tr myTr = new tr();
		myTr.addElement(new td().addElement(Msg.translate(ws.ctx, lableName)));
		input inputbox = new input(input.TYPE_TEXT, textName, value);
		inputbox.setID(textName);
		inputbox.setSize(64);
		myTr.addElement(new td().addElement(inputbox));
		return myTr;
	}
	
	/**
	 * 	Get Select Field
	 *	@param lookup lookup
	 *	@param dataValue default value
	 *	@return selction td
	 */
	private tr getSelectTr (HttpServletRequest request, String labelName, String selName, String value)
	{
		WWindowStatus ws = WWindowStatus.get(request);
		tr myTr = new tr();
		
		String sql = "SELECT C_Greeting_ID, Name FROM C_Greeting WHERE IsActive='Y' ORDER BY 2";
		sql = MRole.getDefault(ws.ctx, true).addAccessSQL(sql, "C_Greeting", MRole.SQL_NOTQUALIFIED, MRole.SQL_RO);
		KeyNamePair[] list = DB.getKeyNamePairs(sql, true);	
		option[] options = new option[list.length];
		int selectedIndex = -1;
		for(int i=0; i<list.length; i++){
			KeyNamePair p = (KeyNamePair)list[i];
			options[i] = new option(String.valueOf(p.getKey())).addElement(p.getName());
			if(StringToIntConverter.StringToInt(value) == p.getKey()){
				options[i].setSelected(true);
			}
		}

		select sel = new select(selName, options);
		sel.setID(selName);
		
		myTr.addElement(new td().addElement(Msg.translate(ws.ctx, labelName)));
		td selTd = new td().addElement(sel).setAlign(AlignType.LEFT).setVAlign(AlignType.TOP);
		selTd.setID(selName);
		myTr.addElement(selTd);
		
		return myTr;
	}	//	getSelectField
	
	/**
	 * 	Get Popup Field ( location, account, ..)
	 *	@param dataDisplay data to be displayed
	 *	@param dataValue data of value field
	 *	@return td
	 */
	private tr getLocationField (HttpServletRequest request, String labelName, String dataDisplay, 
			String m_columnName, String dataValue)
	{
		WWindowStatus ws = WWindowStatus.get(request);
		int m_windowNo = ws.mWindow.getWindowNo();
		
		tr myTr = new tr();
		myTr.addElement(new td().addElement(Msg.translate(ws.ctx, labelName)));
		
		//  The hidden data field        Name=columnName
		input hidden = new input (input.TYPE_HIDDEN, m_columnName, dataValue);
		hidden.setID(m_columnName + "D");

		//  The display field       Name=columnName, ID=FcolumnName
		input display = new input(input.TYPE_TEXT, m_columnName + "F", AmpiereUtil.maskHtmlCR(dataDisplay));
		display.setID(m_columnName + "F");
		//display.setReadOnly(true);
		int m_displayLength = 50;
		display.setSize(m_displayLength);
		display.setSize(60);
		
		img button = null;
		String gif = "Location16.gif";

		button = new img(WebEnv.getImageDirectory(gif), m_columnName);
		button.setID(m_columnName + "B");
		button.setClass("popupButton");
		String onClick = "";
		
		String AD_Column_ID = "0";
		String col = "dummy";
		
		if(StringUtils.isEmpty(dataValue)){
			dataValue = "0"; // to avoid syntax
		}
		
		onClick = "startLocation('" + m_columnName + "'," + m_windowNo + "," + dataValue + ",'" + col + "',null);";
		display.setReadOnly(true);
		button.setOnClick(onClick + "return false;");

		td tdLocation = new td().addElement(hidden).addElement(display).addElement(button);
		myTr.addElement(tdLocation);
		
		return myTr;
	}	//	getPopupField
	/**
	 *	Save.
	 *	Checks mandatory fields and saves Partner, Contact and Location
	 * 	@return true if saved
	 */
	private boolean actionSave(HttpServletRequest request, MBPartner m_partner)
	{
		WWindowStatus ws = WWindowStatus.get(request);
		int m_WindowNo = ws.mWindow.getWindowNo();

		//	***** Business Partner *****
		if (m_partner == null)
		{
			int AD_Client_ID = ws.ctx.getAD_Client_ID();
			m_partner = MBPartner.getTemplate(ws.ctx, AD_Client_ID);
			boolean isSOTrx = ws.ctx.isSOTrx(m_WindowNo);
			m_partner.setIsCustomer (isSOTrx);
			m_partner.setIsVendor (!isSOTrx);
		}
		
		String V_searchKey = WebUtil.getParameter(request, "searchKey");
		String V_Greeting = WebUtil.getParameter(request, "Greeting");  
		String V_Name = WebUtil.getParameter(request, "Name");
		String V_Name2 = WebUtil.getParameter(request, "Name2");
		String V_Contact = WebUtil.getParameter(request, "Contact");
		String V_GreetingC = WebUtil.getParameter(request, "GreetingC");
		String V_Title = WebUtil.getParameter(request, "Title");
		String V_EMail = WebUtil.getParameter(request, "EMail");
		String V_C_Location_ID = WebUtil.getParameter(request, "C_Location_ID");
		String V_C_Location_Display = WebUtil.getParameter(request, "");
		String V_Phone = WebUtil.getParameter(request, "Phone");
		String V_Phone2 = WebUtil.getParameter(request, "Phone2");
		String V_Fax = WebUtil.getParameter(request, "Fax");
		
		//	Check Value
		String value = V_searchKey;
		if (value == null || value.length() == 0)
		{
			//	get Table Documet No
			value = DB.getDocumentNo (ws.ctx.getAD_Client_ID(), "C_BPartner", null);
		}
		m_partner.setValue(value);
		//
		m_partner.setName(V_Name);
		m_partner.setName2(V_Name2);
		m_partner.setC_Greeting_ID(StringToIntConverter.StringToInt(V_Greeting));
		m_partner.save();
		
		//	***** Business Partner - Location *****
		//	Contact - Load values
		MBPartnerLocation m_pLocation = m_partner.getLocation(
			ws.ctx.getContextAsInt( m_WindowNo, "C_BPartner_Location_ID"));
		
		if (m_pLocation == null)
			m_pLocation = new MBPartnerLocation(m_partner);
		m_pLocation.setC_Location_ID(StringToIntConverter.StringToInt(V_C_Location_ID));
		//
		m_pLocation.setPhone(V_Phone);
		m_pLocation.setPhone2(V_Phone2);
		m_pLocation.setFax(V_Fax);
		if (m_pLocation.save())
			log.fine("C_BPartner_Location_ID=" + m_pLocation.getC_BPartner_Location_ID());
			
		//	***** Business Partner - User *****
		String contact = V_Contact;
		String email = V_EMail;
		MUser m_user = m_partner.getContact(
				ws.ctx.getContextAsInt( m_WindowNo, "AD_User_ID"));
		if (m_user == null && (contact.length() > 0 || email.length() > 0))
			m_user = new MUser (m_partner);
		if (m_user != null)
		{
			if (contact.length() == 0)
				contact = V_Name;
			m_user.setName(contact);
			m_user.setEMail(email);
			m_user.setTitle(V_Title);
			m_user.setC_Greeting_ID(StringToIntConverter.StringToInt(V_GreetingC));
			//
			m_user.setPhone(V_Phone);
			m_user.setPhone2(V_Phone2);
			m_user.setFax(V_Fax);
			if (m_user.save())
				log.fine("AD_User_ID=" + m_user.getAD_User_ID());
		}
		return true;
	}	//	actionSave	
}   //  WFind
