/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.web.servlet;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.ecs.Element;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.textarea;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.MClient;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

import com.ampiere.util.AmpiereUtil;

/**
 * 
 * @author Siqin
 *
 */
public class WEMail extends HttpServlet {

	/** serialVersionUID */
	private static final long serialVersionUID = -4841905070456127217L;

	/**	Logger. */
    private CLogger log = CLogger.getCLogger(getClass());

	public static final int WINDOW_WIDTH=600;
	public static final int WINDOW_HEIGHT=500;
	private static final int INPUT_LENGTH=WINDOW_WIDTH - 65;
	
	private static final String FROM = "from";
	private static final String TO = "AD_User_ID";
	private static final String TO_NAME = "emailAddress";
	private static final String SUBJECT = "subject";
	private static final String BODY = "body";

	private static final String FORM_NAME   = "WForm";

	public static final String EMAIL_TYPE = "emailType";
	public static final String EMAIL_TYPE_TRACE = "emailTypeTrace";
	public static final String EMAIL_TYPE_SUPPORT = "emailTypeSupport";

	public static final String POST_TYPE = "postType";
	public static final String POST_TYPE_GET_ADDRESS = "postTypeGetAddress";
	public static final String POST_TYPE_SEND_EMAIL = "postTypeSendEMail";

	/**
	 * Initialize global variables.
     * @param config config
     * @throws ServletException ServletException
	 */
	public void init(ServletConfig config)
		throws ServletException	{
		super.init(config);
		log.info( "WEMail.init" );
		if (!WebEnv.initWeb(config)) {
			throw new ServletException("WEMail.init");
        }
	}   //  init

	/**
	 * Process the HTTP Get request Initial Call.
     * @param request request
     * @param response response
     * @throws ServletException ServletException
     * @throws IOException IOException
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException {

		log.info( "WEMail.doGet" );

		WebSessionCtx wsc = WebSessionCtx.get(request);
		if (wsc == null) {
			WebUtil.createTimeoutPage(request, response, this, null);
			return;
		}

		WebDoc doc = WebDoc.createPopup( Msg.translate(wsc.ctx, "EMail") );
		doc.getHead().addElement(new script((Element)null, "js/email.js"));

		String fromAddress = "**Invalid**";
		boolean canSendEMail = false;
		MUser user = MUser.get(wsc.ctx);
		if (user != null && user.isEMailValid() && user.isCanSendEMail()) {
			fromAddress = user.getEMail();
			canSendEMail = true;
		}

		table layout = new table();
		layout.setStyle( "margin:10px;border-collapse:separate;border-spacing:5px;" );

		// from
		tr line = new tr();
		line.addElement( new td( Msg.translate(wsc.ctx, "From") ) );
		input from = new input(input.TYPE_TEXT, FROM, fromAddress );
		from.setStyle( "width:" + INPUT_LENGTH + "px;" );
		from.setReadOnly(true);
		line.addElement( new td( from ) );
		layout.addElement( line );

		// to
		line = new tr();
		line.addElement( new td( Msg.translate(wsc.ctx, "To") ) );
		td item = new td();
		input to = new input(input.TYPE_HIDDEN, TO, "" );
		to.setID( TO + "D" );
		to.setOnChange( "onUserChange('" + TO + "');" );
		item.addElement( to );
		to = new input(input.TYPE_TEXT, TO, "" );
		to.setID( TO + "F" );
		to.setStyle( "width:" + (INPUT_LENGTH-30) + "px;" );
		to.setOnChange( "setChangeFlag();startUpdate(this);" );
		to.setReadOnly(true);
		item.addElement( to );
		img iBtn = new img( WebEnv.DIR_BASE + "/images/PickOpen16.gif", TO);
		iBtn.setClass( "popupButton" );
		iBtn.setID( TO + "B" );
		iBtn.setAlt( Msg.translate(wsc.ctx, TO) );
		iBtn.setTitle( Msg.translate(wsc.ctx, TO) );
		iBtn.setOnClick( "startLookup('" + TO + "',0,212,'" + TO + "', 'N',null);return false;" );
		item.addElement( iBtn );
		line.addElement( item );
		layout.addElement( line );

		// to name
		line = new tr();
		line.addElement( new td( Msg.translate(wsc.ctx, "") ) );
		input toName = new input(input.TYPE_TEXT, TO_NAME, "" );
		toName.setID( TO_NAME );
		toName.setStyle( "width:" + INPUT_LENGTH + "px;" );
		toName.setReadOnly(true);
		line.addElement( new td( toName ) );
		layout.addElement( line );

		// subject
		line = new tr();
		line.addElement( new td( Msg.translate(wsc.ctx, "Subject") ) );
		input subject = new input(input.TYPE_TEXT, SUBJECT, Env.getHeader(wsc.ctx, 0) );
		subject.setStyle( "width:" + INPUT_LENGTH + "px;" );
		subject.setID( SUBJECT );
		line.addElement( new td( subject ) );
		layout.addElement( line );

		// body
		line = new tr();
		item = new td();
		item.setColSpan(2);
		textarea infoArea = new textarea();
		infoArea.setName( BODY );
		infoArea.setID( BODY );
		infoArea.setStyle( "width:" + (INPUT_LENGTH + 35) + "px;height:" + (WINDOW_HEIGHT - 200) + "px;" );
		infoArea.addElement( WAbout.getInfo(wsc.ctx,null,false).toString() + Env.NL );
		infoArea.addElement( "-------------------------------------------------------------" + Env.NL );
		infoArea.addElement( WAbout.getBrowserInfo( request, null, false ).toString() );
		infoArea.addElement( "-------------------------------------------------------------" + Env.NL );
		String[] context = wsc.ctx.getEntireContext();
		for (int i = 0; i < context.length; i++) {
			infoArea.addElement( context[i] + Env.NL  );
		}
		item.addElement( infoArea );
		line.addElement( item );
		layout.addElement( line );

		line = new tr();
		item = new td();
		item.setColSpan(2);
		item.setAlign( "right" );
		input cancel = AmpiereUtil.createImageButton(wsc.ctx, "Cancel", "window.close();");
		item.addElement(cancel);
		input ok = AmpiereUtil.createImageButton(wsc.ctx, "Ok", "submitForm();");
		if ( canSendEMail ) {
			ok.setDisabled( false );
		} else {
			ok.setDisabled( true );
		}
		item.addElement(ok);
		line.addElement( item );
		layout.addElement( line );

		form mForm = new form();
		mForm.setMethod( form.METHOD_POST );
		mForm.setID(FORM_NAME);
		mForm.setName(FORM_NAME);
		mForm.addElement( layout );

		doc.getTable().addElement( mForm );

		WebUtil.createResponse(request, response, this, null, doc, false);
	}   //  doGet

	/**
	 * Process the HTTP Post request. Get Parameters and Process.
     * @param request request
     * @param response response
     * @throws ServletException ServletException
     * @throws IOException IOException
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException {

		log.info( "WEMail.doPost" );

		WebSessionCtx wsc = WebSessionCtx.get(request);
		if (wsc == null) {
			WebUtil.createTimeoutPage(request, response, this, null);
			return;
		}

		String context = "";
		String postType = WebUtil.getParameter(request, POST_TYPE);
		if ( POST_TYPE_SEND_EMAIL.equals( postType ) ) {
			int userId		= WebUtil.getParameterAsInt(request, TO);
			if ( userId > 0 ) {
				MUser fromUser	= MUser.get(wsc.ctx);
				MUser toUser 	= MUser.get(wsc.ctx,userId);
				String subject	= WebUtil.getParameter(request, SUBJECT);
				String body		= WebUtil.getParameter(request, BODY);
		
				EMail mail = MClient.get(wsc.ctx).createEMail(fromUser, toUser, subject, body);
				String result = mail.send();
				if ( result != null ) {
					context = result;
				}
			}
		} else if ( POST_TYPE_GET_ADDRESS.equals( postType ) ) {
			int userId = WebUtil.getParameterAsInt(request, TO);
			if ( userId > 0 ) {
				MUser user = MUser.get(wsc.ctx, userId);
				if ( user != null ) {
					context = user.getEMail();
				}
			}
		}

		response.setHeader("Cache-Control", "no-cache");
		response.setContentType("text/html; charset=UTF-8");
		PrintWriter out = response.getWriter();
		out.write( context );
		out.flush();
		out.close();

	}   //  doPost

}   //  WEMail
