/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.web.servlet;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.logging.Level;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.impexp.ImpFormat;
import org.compiere.impexp.ImpFormatRow;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.Msg;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ampiere.util.Constants;
import com.ampiere.util.FileUpload;
import com.sun.org.apache.xml.internal.serializer.OutputPropertiesFactory;



/**
 *	HTML UI Attachment
 *	
 *  @author Jorg Janke
 *  @version $Id: WFileImport.java,v 1.5 2010/05/05 05:15:57 siqin Exp $
 */
public class WFileImport extends HttpServlet
{
	private static final long serialVersionUID = 7585292696988042858L;
	/**	Logger			*/
	private static CLogger	log = CLogger.getCLogger(WFileImport.class);

	/**
	 * Initialize global variables
	 */
	public void init(ServletConfig config)
		throws ServletException
	{
		super.init(config);
		if (!WebEnv.initWeb(config))
			throw new ServletException("WAttachment.init");
	}   //  init

	public static final String  M_DATA = "m_data";
	public static final String  ACTION_TYPE	= "actionType";
	public static final String	B_FILE = "1";
	public static final String	PICK_FORMAT = "2";
	public static final String	B_NEXT = "3";
	public static final String	B_PREV = "4";
	public static final String	A_OK = "5";
	public static final String 	s_none = "----";
	public static final String  M_RECORD = "m_record";
	public static final String  M_LABELS = "m_labels";
	public static final String  M_FIELDS = "m_fields";
	public static final String  M_FORMAT = "m_format";

	
	/**
	 * 	Process the HTTP Get request.
	 * 	Initial display and streaming 
	 *  @param request request
	 *  @param response response
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException
	{

	}   //  doGet


	/**
	 *  Process the HTTP Post request.
	 *  Update Attachment
	 *  @param request request
	 *  @parem response response
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException
	{
		
        //201001
	  	WebSessionCtx wsc = WebSessionCtx.get(request);
		if (wsc == null) {
			WebUtil.createTimeoutPage(request, response, this, null);
			return;
		}
		//---201001
		
		log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
//		HttpSession sess = request.getSession(false);
		WWindowStatus ws = WWindowStatus.get(request);
		//

		String actionType = request.getParameter(ACTION_TYPE);
		if(B_FILE.equals(actionType)){
			//command loadFile
			ArrayList<String> response_array = cmd_loadFile (request);		
			Document responseDocument = generateContentXML(request, response_array);
			createAjaxResponse(response, responseDocument);
		}else if(PICK_FORMAT.equals(actionType)){
			//cmd_loadFormat
			Document doc = cmd_loadFormat(request);
			createAjaxResponse(response, doc);		
		}else if(B_NEXT.equals(actionType)){
			Document doc = cmd_applyFormat(request, true);
			createAjaxResponse(response, doc);			
		}else if(B_PREV.equals(actionType)){
			Document doc = cmd_applyFormat(request, false);
			createAjaxResponse(response, doc);			
		}else if(A_OK.equals(actionType)){
			String msg = cmd_process(request);
			response.setContentType("text/html; charset=UTF-8");
			response.getOutputStream().print(msg);	
		}

		return;
	}   //  doPost

	/**************************************************************************
	 *	Load File
	 */
	private ArrayList<String> cmd_loadFile(HttpServletRequest request)
	{
		
		ArrayList<String>	m_data = new ArrayList<String>();
		
		FileUpload upload = null;
		upload = new FileUpload(request, 2000);
		String error = upload.getError();
		if (error != null)
		{
			log.warning("cmd_loadFile - " + error);
		}
		
		try
		{
			//  see NaturalAccountMap
			BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(upload.getData()), "UTF-8"));

			//	not safe see p108 Network pgm
			String s = null;
			while ((s = in.readLine()) != null)
			{
				m_data.add(s);

			}
			in.close();
		}
		catch (Exception e)
		{
			;
		} 

		request.getSession().setAttribute(M_DATA, m_data);
		return m_data;
		
	}	//	cmd_loadFile   
	
	public static void setResponse(HttpServletResponse response,ArrayList<String> response_array){
		response.addHeader("pragma", "no-store,no-cache");//HTTP 1.0
	    response.addHeader("cache-control", "no-cache, no-store,must-revalidate, max-age=-1"); // HTTP 1.1
	    response.addHeader("expires", "-1");
		try {
			response.getOutputStream().print(generateResponseText(response_array));
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public static String generateResponseText(ArrayList<String> arr) throws UnsupportedEncodingException{
		String resp_arr = "";
		String split_arr = "**";
		for(int i=0; i<arr.size(); i++ ){
			if(i!=0){
				resp_arr += "</br>";
			}
					
			resp_arr+= arr.get(i);
		}			
		//return URLEncoder.encode(resp_arr, "UTF-8");
		return resp_arr;
	}
	
	public static Document generateContentXML(HttpServletRequest request, ArrayList<String> arr){
		Document document = null;

		try{
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			//ビルダーからDOMを取得する
			document = builder.newDocument();


			//XMLのルート要素(userタグ)を追加する
			Element elements = document.createElement(Constants.LINES);
			document.appendChild(elements);
			
			StringBuffer contentBuffer = new StringBuffer();
			
			for(int i=0; i<arr.size(); i++ ){
				if(i!=0){
					contentBuffer.append("\n");
				}
				contentBuffer.append(arr.get(i));
			}
			Element element = document.createElement(Constants.LINE);
			String limitedContent = contentBuffer.toString();
			final int responseLimit = 4000;
			if(limitedContent!=null && limitedContent.length() > responseLimit){
				limitedContent = limitedContent.substring(0,responseLimit);
			}
			element.appendChild(document.createTextNode(limitedContent));
			elements.appendChild(element);
			

			ArrayList<String> m_data = (ArrayList<String>)request.getSession().getAttribute(M_DATA);
			int index = 1;	//	second line as first may be heading
			if (m_data.size() == 1)
				index = 0;
			int length = 0;
			if (m_data.size() > 0)
					length = m_data.get(index).toString().length();
			
			Element msg = document.createElement(Constants.MSG);
			WebSessionCtx wsc = WebSessionCtx.get(request);
			Ctx ctx = wsc.ctx;
			String msg_str = Msg.getMsg(ctx, "Records") + "=" + m_data.size()
				+ ", " + Msg.getMsg(ctx, "Length") + "=" + length + "   ";	
			msg.appendChild(document.createTextNode(msg_str));
			elements.appendChild(msg);
			
		}catch(Exception e){
			
		}
		return document;
	}
	
	public static void createAjaxResponse (HttpServletResponse response, Document document) throws IOException
	{

		response.setContentType("text/xml; charset=UTF-8");
		response.addHeader("pragma", "no-store,no-cache");//HTTP 1.0
		response.addHeader("cache-control", "no-cache, no-store,must-revalidate, max-age=-1"); // HTTP 1.1
		response.addHeader("expires", "-1");

		PrintWriter out = null;
		out = response.getWriter();
		try {			
	
			System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
			TransformerFactory tfactory = TransformerFactory.newInstance();
			Transformer transformer = tfactory.newTransformer();

			// インデントを行う
			transformer.setOutputProperty(OutputKeys.INDENT, "yes");
			transformer.setOutputProperty(OutputKeys.METHOD, "xml");
			// インデントの文字数
			transformer.setOutputProperty(OutputPropertiesFactory.S_KEY_INDENT_AMOUNT,
			"2");

			transformer.transform(new DOMSource(document), new StreamResult(out));

			//for test, to insure the output xml is right
			    		File outfile = new File("D:/test.xml");
			    		transformer.transform(new DOMSource(document), new StreamResult(outfile)); 

		} catch(Exception e)
		{
			log.warning("error---- createCalloutAjaxResponse");;
		}

	}   //  createResponse	
	
	/**
	 *	Load Format
	 */
	private Document cmd_loadFormat(HttpServletRequest request)
	{
		//
		HttpSession session = request.getSession();
		String formatName = request.getParameter("impFormat");
		if (formatName.equals(s_none))
			return null;
		ImpFormat m_format = ImpFormat.load (formatName);
		if (m_format == null)
		{
			//return error using alert
			return null;
		}

		//	pointers
		int size = m_format.getRowCount();
		String[] m_labels = new String[size];
		String[] m_fields = new String[size];
		for (int i = 0; i < size; i++)
		{
			ImpFormatRow row = m_format.getRow(i);
			m_labels[i] = row.getColumnName();
			//
			int length = row.getEndNo() - row.getStartNo();
			if (length <= 5)
				length = 5;
			else if (length > 20)
				length = 20;
			m_fields[i] = "";
		}
		int m_record = -1; 
		session.setAttribute(M_RECORD, m_record);
		session.setAttribute(M_LABELS, m_labels);
		session.setAttribute(M_FIELDS, m_fields);	
		session.setAttribute(M_FORMAT, m_format);
		
		return generateFieldsXML(request, m_labels, m_fields, "-");
		
	}	//	cmd_format
	
	public static Document generateFormatXML(HttpServletRequest request, String[] m_labels, String[] m_fields){
		Document document = null;

		try{
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			//ビルダーからDOMを取得する
			document = builder.newDocument();


			//XMLのルート要素(userタグ)を追加する
			Element elements = document.createElement(Constants.FIELDS);
			document.appendChild(elements);
			
			StringBuffer contentBuffer = new StringBuffer();
			
			for(int i=0; i<m_labels.length; i++ ){
				Element element = document.createElement(Constants.FIELD);
				
				Element label=document.createElement(Constants.KEY);
				label.appendChild(document.createTextNode(m_labels[i]));
				element.appendChild(label);
				
				Element text=document.createElement(Constants.VALUE);
				text.appendChild(document.createTextNode(m_fields[i]));
				element.appendChild(text);
				
				elements.appendChild(element);				
			}			
		}catch(Exception e){
			
		}
		return document;
	}

	public static Document generateFieldsXML(HttpServletRequest request, String[] m_labels, 
			String[] m_fields, String recordNum){
		table table = new table();
		
		tr first = new tr();
		tr second = new tr();		
		
		for(int i=0; i<m_labels.length; i++ ){
			td td = new td();
			td.addElement(m_labels[i]);
			first.addElement(td);
		}
		table.addElement(first);
		
		for(int i=0; i<m_fields.length; i++ ){
			td td = new td();
			input text  = new input("text", m_labels[i], m_fields[i]);
			td.addElement(text);
			second.addElement(td);
		}
		table.addElement(second);
		
		Document document = null;

		try{
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			//ビルダーからDOMを取得する
			document = builder.newDocument();


			//XMLのルート要素(userタグ)を追加する
			Element elements = document.createElement(Constants.ELEMENTS);
			document.appendChild(elements);
			
			Element html=document.createElement(Constants.HTML);
			html.appendChild(document.createTextNode(table.toString()));
			elements.appendChild(html);

			Element recordNumObj=document.createElement(Constants.RECORD_NUM);
			recordNumObj.appendChild(document.createTextNode(recordNum));
			elements.appendChild(recordNumObj);
		}catch(Exception e){
			;
		}
		
		return document;
	}
	
	/**
	 *	Apply Current Pattern
	 *  @param next next
	 */	
	private Document cmd_applyFormat (HttpServletRequest request, boolean next)
	{
		HttpSession session = request.getSession();
		ImpFormat 		m_format;		
		m_format = (ImpFormat)session.getAttribute(M_FORMAT);
		int m_record = (Integer)session.getAttribute(M_RECORD);
		ArrayList<String> m_data = (ArrayList<String>)request.getSession().getAttribute(M_DATA);
		String[] m_labels = (String[])session.getAttribute(M_LABELS);
		String[] m_fields = (String[])session.getAttribute(M_FIELDS);
		
		if (m_format == null)
			return null;
		
		if(m_data == null){
			return null;
		}

		//	set position
		if (next)
			m_record++;
		else
			m_record--;
		if (m_record < 0)
			m_record = 0;
		else if (m_record >= m_data.size())
			m_record = m_data.size() - 1;
		
		session.setAttribute(M_RECORD, m_record);
		//record.setText(" " + String.valueOf(m_record+1) + " ");
		//	Line Info
		String[] lInfo = m_format.parseLine(m_data.get(m_record).toString(), false, true, false);	//	no label, trace, no ignore
		int size = m_format.getRowCount();
		if (lInfo.length != size)
			log.log(Level.SEVERE, "FormatElements=" + size + " != Fields=" + lInfo.length);
		for (int i = 0; i < size; i++)
		{
			m_fields[i] = lInfo[i];
		}
		return generateFieldsXML(request, m_labels, m_fields, String.valueOf(m_record));
		
	}	//	cmd_applyFormat	
	
	/**************************************************************************
	 *	Process File
	 */
	private String cmd_process(HttpServletRequest request)
	{		
		HttpSession session = request.getSession();
		ImpFormat 		m_format;		
		m_format = (ImpFormat)session.getAttribute(M_FORMAT);
		ArrayList<String> m_data = (ArrayList<String>)request.getSession().getAttribute(M_DATA);
		
		if (m_format == null)
		{
			return null;
		}
		
		//print out the message
		WebSessionCtx wsc = WebSessionCtx.get(request);
		Ctx ctx = wsc.ctx;

		//	For all rows - update/insert DB table
		int row = 0;
		int imported = 0;
		for (row = 0; row < m_data.size(); row++)
			if (m_format.updateDB(ctx, m_data.get(row).toString(), null))
				imported++;
		//
		
		StringBuffer out = new StringBuffer();
		String AD_Message = "FileImportR/I";
		String msg = row + " / " + imported + "#";
		if (AD_Message != null && !AD_Message.equals(""))
			out.append(Msg.getMsg(ctx, AD_Message));
		if (msg != null && msg.length() > 0)
			out.append("\n").append(msg);
		
		return out.toString();
	}	//	cmd_process	
	
}	//	WAttachment
