/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.web.servlet;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.commons.lang.StringUtils;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.li;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.span;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.apache.ecs.xhtml.ul;
import org.compiere.framework.Lookup;
import org.compiere.framework.Query;
import org.compiere.model.GridField;
import org.compiere.model.MLocator;
import org.compiere.model.MRole;
import org.compiere.model.MUserQuery;
import org.compiere.model.MUserQueryLine;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Null;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;
import org.w3c.dom.Document;

import com.ampiere.util.AWebUtil;
import com.ampiere.util.AdvancedRow;
import com.ampiere.util.AmpiereUtil;
import com.ampiere.util.Constants;
import com.jware.util.StringToIntConverter;

/**
 * 
 * @author clmg
 *
 */
public class WFindAdvanced extends HttpServlet {
    /**  */
	private static final long serialVersionUID = 6617424544044122702L;
	/**	Logger. */
    private CLogger log = CLogger.getCLogger(getClass());
	/** Error Indicator                     */
	private static final String ERROR       = " ERROR! ";
    
    private int TABNO = 99;
    private String QUERY_ENTRY_DIV = "queryEntryDiv";
    private String SAVED_QUERY_LOAD_ACTION = "1";
    private String SAVED_QUERY_DELETE_ACTION = "2";
    private String COLUMN_ACTION = "3";
    private String OPERATOR_ACTION = "4";
    private String DELETE_ROW_ACTION = "5";
    private String SAVE_ROW_ACTION = "6";
    private String REFRESH_ACTION = "7";
    private String OK_ACTION = "8";
    
    private String COLUMN_ID = "columnId";
    private String OPERATOR_ID = "operatorId";
    private String QUERY_VALUE_1 = "queryValue1";
    private String QUERY_VALUE_2 = "queryValue2";
    private String QUERY_VALUE_DISPLAY_1 = "queryValueDisplay1";
    private String QUERY_VALUE_DISPLAY_2 = "queryValueDisplay2";    
    private String QUERY_DISPLAY_1 = "queryDisplay1";
    private String QUERY_DISPLAY_2 = "queryDisplay2";
    private String QUERY_ID = "queryId";
    private String QUERY_NAME = "queryName";
    private String QUERY_ENTRY_INDEX = "queryEntryIndex";
    
    private String DELETE_ROW_BUTTON = "deleteRowButton";
    private String SAVE_ROW_BUTTON = "saveRowButton";
    private String DELETE_QUERY_BUTTON = "delteQueryButton";    
    
    private String ADVANCED_DATA = "advancedData";
    private int DEFAULT_DISPLAY_LENGTH = 20 * 8; // default length;
    
    private String RETURN_FALSE = "return false;"; // default length;

	/**
	 * Initialize global variables.
     * @param config config
     * @throws ServletException ServletException
	 */
	public void init(ServletConfig config)
		throws ServletException	{
		super.init(config);
		if (!WebEnv.initWeb(config)) {
			throw new ServletException("WProcess.init");
        }
	}   //  init

	/**
	 * Process the HTTP Get request Initial Call.
     * @param request request
     * @param response response
     * @throws ServletException ServletException
     * @throws IOException IOException
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException {
		HttpSession session  = request.getSession();
        //  Get Session attributes
	  	WebSessionCtx wsc = WebSessionCtx.get(request);
		if (wsc == null) {
			WebUtil.createTimeoutPage(request, response, this, null);
			return;
		}
		
		WebDoc doc = createFindPage(request);
		session.setAttribute(ADVANCED_DATA, null);

		if (doc == null) {
			doc = WebDoc.createWindow("Error");
		}

		// Add body onUnload event, close all popup window when unload 
		doc.getBody().setOnUnload("closeMyChildren();");

		//
		WebUtil.createResponse(request, response, this, null, doc, false);
	}   //  doGet


	/**
	 * Process the HTTP Post request. Get Parameters and Process.
     * @param request request
     * @param response response
     * @throws ServletException ServletException
     * @throws IOException IOException
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException
{

        //  Get Session attributes
	  	WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);
		if (wsc == null) {
			WebUtil.createTimeoutPage(request, response, this, null);
			return;
		}
		
		Document xml_doc = processAction(request);
		
		AWebUtil.createCalloutAjaxResponse(response, xml_doc);

	}   //  doPost

	/**
	 * 	Create Find Page.
	 *	@param request request
	 *	@return Page
	 */
	private WebDoc createFindPage(HttpServletRequest request) {
	  	WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);

		WebDoc doc = WebDoc.createWindow( ws.mWindow.getName() + " - " + ws.curTab.getName() );		
		
		AmpiereUtil.addProcessMsg(request, doc);
		
		addTabFind(request, doc);
		
		// For date picker
		AmpiereUtil.addDatePicker(doc.getHead(), wsc);
		
		//add script
		doc.getHead().addElement(new script((Element)null, WebEnv.getBaseDirectory("js/findAdvanced.js")));
		doc.getHead().addElement(new script((Element)null, WebEnv.getBaseDirectory("js/search.js")));
		//doc.getHead().addElement(new link("css/displaytag.css","stylesheet","text/css"));

		String actionName = request.getRequestURI();
		int pos = actionName.indexOf("Advanced");
		actionName = actionName.substring(0, pos);
		form myForm = new form(actionName);
		myForm.setName("findAdvancedForm");
		myForm.setID("findAdvancedForm");
		
		div divBody = (div)new div().setID("body");
		
		addSavedQueryTable(request, divBody);
		addAdvancedEntry(request, divBody);
		addValueEditor(request, divBody);
		addButtons(request, divBody);
		
		table myTable = new table();
		myTable.setAlign("CENTER");
		divBody.addElement(myTable);
		
		table historyTable = WFind.getHistoryTable(request);
		divBody.addElement(historyTable);
		
		myForm.addElement(divBody);
		doc.getBody().addElement(myForm);

		return doc;
	}	//	createFindPage
	
	/**
	 *	Add Field to Line.
	 *  @param wsc session context
	 *  @param line format element
	 *  @param field field
     *  @param oData original data
     *  @param readOnly readOnly
	 *  @param hasDependents has Callout function(s)
	 */
	private void addField(
			WebSessionCtx wsc,
			tr line,
			GridField field,
			Object oData,
			boolean hasDependents,
			boolean readOnly
			) {
		String columnName = field.getColumnName();
		//  Any Error?
        Object data = oData;
		boolean error = field.isErrorValue();
		if (error) {
            log.log(Level.SEVERE, oData.toString());
            data = field.getErrorValue();
        }
		int dt = field.getDisplayType();
		boolean hasCallout = field.getCallout().length() > 0;

		/**
		 *  HTML Label Element
		 *      ID = ID_columnName
		 *
		 *  HTML Input Elements
		 *      NAME = columnName
		 *      ID = ID_columnName
		 */
		
		int display_length = field.getDisplayLength();
//		if( display_length > 40 ){
//			display_length = 48;
//		} else {
//			display_length = 20;			
//		}
		
		if( display_length > 500 ){
			display_length = 550;
		} else {
			display_length = 200;			
		}
				
		WebField wField = new WebField(
                field.getWindowNo(),
                wsc,
                columnName,
                field.getHeader(),
                field.getDescription(),
                dt,
                field.getFieldLength(),
                display_length,
                field.isLongField(),
                readOnly,
                field.isMandatory(false),
                error,
                hasDependents,
                hasCallout,
                field.getAD_Process_ID(),
                field.isEncryptedField());

		line.addElement(wField.getLabel());
		line.addElement(wField.getField(field.getLookup(), data, field.getAD_Column_ID()));
	}	//	addField
	
	void addTabFind(HttpServletRequest request, WebDoc doc){
        //  Get Session attributes
	  	WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);
		
		String msgFind = Msg.getMsg(wsc.ctx,"Find");
		String msgFindAdvanced = Msg.getMsg(wsc.ctx,"Advanced");
		
		div tabbar = (div)new div().setID("menu_tab");
		ul tabTable = new ul();

		boolean currentTab = false;

		for (int i = 0; i < 2; i++)
		{
			String tabMouseOver = "";
			String tabMouseOut = "";
			String tabLeftId = "tabLeftId_" + Integer.toString(i);
			String tabRightId = "tabRightId_" + Integer.toString(i);
			String tabLeftClass = "tabLeft";
			String tabRightClass = "tabRight";

			span big;
			if(i == 0){
				big = new span(msgFind); 
			}else{
				big = new span(msgFindAdvanced);
			}
			
			if (1 == i) {
				big.setClass("tabSelected");

				tabLeftClass += "Sel";
				tabRightClass += "Sel";
				currentTab = true;
			}
			else 
			{
				big.setClass("tab");
				big.setOnClick("window.location.href = 'WFind?windowId=" + ws.getCurTab().getAD_Window_ID() 
					+ "&windowNo=" + ws.getCurTab().getWindowNo() + "'");

				tabMouseOver = "tabMouseOver('" + tabLeftId + "', '" + tabRightId + "');";
				tabMouseOut = "tabMouseOut('" + tabLeftId + "', '" + tabRightId + "');";
			}
			
			if ( i != 1 ) {
				currentTab = false;
			}

			span tabTdLeft = new span(WebEnv.NBSP);
			tabTdLeft.setClass(tabLeftClass);

			li tabTdRight = (li)new li().setClass(tabRightClass); //clmg 2009/02/10
			tabTdLeft.setID(tabLeftId);
			tabTdRight.setID(tabRightId);
			if (i == 0) {
				tabMouseOver += "status='" + msgFind + "';return true;";
			}else{
				tabMouseOver += "status='" + msgFindAdvanced + "';return true;";
			}
			
			if (tabMouseOver != null && ! "".equals(tabMouseOver)) {
				big.setOnMouseOver(tabMouseOver);
			}
			
			if (tabMouseOut != null && ! "".equals(tabMouseOut)) {
				tabMouseOut += "status='" + ws.curTab.getName() + "';return true;";
				big.setOnMouseOut(tabMouseOut);
			}
			
			tabTable.addElement(tabTdRight);
			tabTdRight.addElement(tabTdLeft);
			tabTdRight.addElement(big);
			tabTdRight.setStyle("");
		}

		tabbar.addElement(tabTable);
		doc.getBody().addElement(tabbar);
	}

	/**
	 * getSavedQueryList
	 * @param request
	 * @return ArrayList<ValueNamePair>
	 */
    private ArrayList<ValueNamePair> getSavedQueryList(HttpServletRequest request){
    	WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);
		int m_AD_Tab_ID = ws.curTab.getAD_Tab_ID();
		int m_AD_Table_ID = ws.curTab.getAD_Table_ID();
		ArrayList<ValueNamePair> savedQueryList = new ArrayList();
		ValueNamePair pp = new ValueNamePair("", "");
		savedQueryList.add(pp);
		
    	MUserQuery[] queries = MUserQuery.get (wsc.ctx, m_AD_Tab_ID, m_AD_Table_ID);
		for(int i = 0; i < queries.length; i++){
			MUserQuery query = queries[i];
			pp = new ValueNamePair(query.getCode(), query.getName());
			savedQueryList.add(pp);
		}
		return savedQueryList;
    }
    
    static private option[] getSavedQueryOptions(HttpServletRequest request){
    	return getSavedQueryOptions(request, null);
    }
    
    /**
     * getSavedQueryOptions 
     * @param request
     * @return option[]
     */
    static public option[] getSavedQueryOptions(HttpServletRequest request, String msg){
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	WWindowStatus ws = WWindowStatus.get(request);
    	int m_AD_Tab_ID = ws.curTab.getAD_Tab_ID();
    	int m_AD_Table_ID = ws.curTab.getAD_Table_ID();

    	MUserQuery[] queries = MUserQuery.get (wsc.ctx, m_AD_Tab_ID, m_AD_Table_ID);
    	option[] options = new option[queries.length + 1];
    	if(!StringUtils.isEmpty(msg)){
    		options[0] = new option("").addElement(msg);
    	}else{
    		options[0] = new option("").addElement("");
    	}
    	

    	for(int i = 0; i < queries.length; i++){
    		MUserQuery query = queries[i];
    		options[i + 1] = new option(query.getCode()).addElement(query.getName());
    	}
    	return options;
    }
    
    /**
     * addSavedQueryTable
     * @param request
     * @param divBody
     */
    void addSavedQueryTable(HttpServletRequest request, div divBody){
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	WWindowStatus ws = WWindowStatus.get(request);
    	
		table savedQueryTable = new table("0", "0", "5", "100%", null);
		divBody.addElement(savedQueryTable);
		td sqtd1 = (td) new td().setStyle("min-width:80px;");
		td sqtd2 = (td) new td().setStyle("min-width:80px;");
		td sqtd3 = (td) new td().setStyle("min-width:80px;");
		td sqtd4 = (td) new td().setStyle("min-width:80px;");
		
		//td 1
		sqtd1.addElement(Msg.getMsg(wsc.ctx, "GetSavedQuery"));
		//td 2
		select sel = new select(QUERY_ID, getSavedQueryOptions(request)); 
		sel.setID(QUERY_ID);
		sel.setOnChange("processAction('" + SAVED_QUERY_LOAD_ACTION + "');" + RETURN_FALSE);
		sel.addAttribute("style", "width:" + (DEFAULT_DISPLAY_LENGTH) + "px;");
		sqtd2.addElement(sel);
		img deleteButton = new img(WebEnv.getImageDirectory("Delete16.png"), Msg.getMsg(wsc.ctx, "QueryDelete"));
		deleteButton.setID(DELETE_QUERY_BUTTON);
		deleteButton.setOnClick("processAction('" + SAVED_QUERY_DELETE_ACTION + "');" + RETURN_FALSE);
		sqtd2.addElement(deleteButton);
		//td 3
		sqtd3.addElement(WebEnv.NBSP + WebEnv.NBSP + Msg.getMsg(wsc.ctx,"QueryName"));
		sqtd3.setStyle("text-align:right;");
		//td 4
		input queryName = new input(input.TYPE_TEXT, QUERY_NAME, "");
		queryName.setID(QUERY_NAME);
		queryName.addAttribute("style", "width:" + (DEFAULT_DISPLAY_LENGTH) + "px;");
		sqtd4.addElement(queryName);
		//add tr
		tr sqtr = new tr();
		sqtr.addElement(sqtd1).addElement(sqtd2).addElement(sqtd3).addElement(sqtd4);
		savedQueryTable.addElement(sqtr);
    }
    
    void addAdvancedEntry(HttpServletRequest request, div divBody){
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	WWindowStatus ws = WWindowStatus.get(request);
    	
		//entry div
		div entryDiv = new div();
		entryDiv.setStyle("min-height:100px;");
		entryDiv.setID(QUERY_ENTRY_DIV);
		divBody.addElement(entryDiv);
    	
		table entryTable = new table("1", "0", "5", "100%", null);
		//entryTable.setClass("displaytag");
		entryTable.setStyle("margin-top: 50px;");
		//entryTable.setStyle("margin-bottom: 20px;");
		entryTable.setBorderColor("#7F9DB9");
		entryDiv.addElement(entryTable);
		td sqtd1 = (td) new td().setStyle("min-width:80px;");
		td sqtd2 = (td) new td().setStyle("min-width:80px;");
		td sqtd3 = (td) new td().setStyle("min-width:80px;");
		td sqtd4 = (td) new td().setStyle("min-width:80px;");
		
		//td 1
		sqtd1.addElement(Msg.translate(wsc.ctx,"AD_Column_ID"));
		//td 2
		sqtd2.addElement(Msg.translate(wsc.ctx,"Operator"));
		//td 3
		sqtd3.addElement(Msg.translate(wsc.ctx,"QueryValue"));
		//td 4
		sqtd4.addElement(Msg.translate(wsc.ctx,"QueryValue2"));
		//add tr
		tr sqtr = new tr();
		sqtr.addElement(sqtd1).addElement(sqtd2).addElement(sqtd3).addElement(sqtd4);
		entryTable.addElement(sqtr);
    }
    
    void addValueEditor(HttpServletRequest request, div divBody){
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	WWindowStatus ws = WWindowStatus.get(request);
    	
		table entryTable = new table("0", "0", "5", "100%", null);
		entryTable.setStyle("margin-top: 20px;");
		divBody.addElement(entryTable);
		td sqtd1 = (td) new td().setStyle("min-width:80px;");
		td sqtd2 = (td) new td().setStyle("min-width:80px;");
		td sqtd3 = (td) new td().setStyle("min-width:80px;");
		td sqtd4 = (td) new td().setStyle("min-width:80px;");
		td sqtd5 = (td) new td().setStyle("min-width:80px;");
		
		//td 1
		sqtd1.addElement(Msg.translate(wsc.ctx,"AD_Column_ID"));
		//td 2
		sqtd2.addElement(Msg.translate(wsc.ctx,"Operator"));
		//td 3
		sqtd3.addElement(Msg.translate(wsc.ctx,"QueryValue"));
		//td 4
		sqtd4.addElement(Msg.translate(wsc.ctx,"QueryValue2"));
		//td 5
		img deleteButton = new img(WebEnv.getImageDirectory("Delete16.png"), Msg.getMsg(wsc.ctx, "QueryDeleteRow"));
		deleteButton.setID(DELETE_ROW_BUTTON);
		deleteButton.setOnClick("processAction('" + DELETE_ROW_ACTION + "');" + RETURN_FALSE);
		sqtd5.addElement(deleteButton);
		//add tr
		tr sqtr = new tr();
		sqtr.addElement(sqtd1).addElement(sqtd2).addElement(sqtd3).addElement(sqtd4).addElement(sqtd5);
		entryTable.addElement(sqtr);
		
		td qetd1 = (td) new td().setStyle("min-width:80px;");
		td qetd2 = (td) new td().setStyle("min-width:80px;");
		td qetd3 = (td) new td().setStyle("min-width:80px;");
		td qetd4 = (td) new td().setStyle("min-width:80px;");
		td qetd5 = (td) new td().setStyle("min-width:80px;");
		
		//td 1
		div columnDiv = (div) new div().setID("columnDiv");
		select selColumn = new select(COLUMN_ID, getcolumnOptions(request));
		selColumn.setID(COLUMN_ID);
		selColumn.setOnChange("processAction('" + COLUMN_ACTION + "');" + RETURN_FALSE);
		columnDiv.addElement(selColumn);
		qetd1.addElement(columnDiv);
		//td 2
		div operatorDiv = (div) new div().setID("operatorDiv");
		select selOperator = new select(OPERATOR_ID, new option[1]);
		selOperator.setID(OPERATOR_ID);
		selOperator.setOnChange("processAction('" + OPERATOR_ACTION + "');" + RETURN_FALSE);
		selOperator.setDisabled(true);
		operatorDiv.addElement(selOperator);
		qetd2.addElement(operatorDiv);
		//td 3
		div queryValueDiv1 = (div) new div().setID("queryValueDiv1");
		input queryValue1 = new input(input.TYPE_TEXT, QUERY_VALUE_1, "");
		queryValue1.setID(QUERY_VALUE_1);
		queryValue1.setReadOnly(true);
		queryValueDiv1.addElement(queryValue1);
		qetd3.addElement(queryValueDiv1);
				
		//td 4
		div queryValueDiv2 = (div) new div().setID("queryValueDiv2");
		input queryValue2 = new input(input.TYPE_TEXT, QUERY_VALUE_2, "");
		queryValue2.setID(QUERY_VALUE_2);
//		queryValue2.setReadOnly(true);
		queryValueDiv2.addElement(queryValue2);
		qetd4.addElement(queryValueDiv2);
		//td 5
		img saveButton = new img(WebEnv.getImageDirectory("Save16.png"), Msg.getMsg(wsc.ctx, "QuerySaveRow"));
		saveButton.setID(SAVE_ROW_BUTTON);
		saveButton.setOnClick("processAction('" + SAVE_ROW_ACTION + "');" + RETURN_FALSE);
		qetd5.addElement(saveButton);
		//add tr
		tr sqtr2 = new tr();
		sqtr2.addElement(qetd1).addElement(qetd2).addElement(qetd3).addElement(qetd4).addElement(qetd5);
		entryTable.addElement(sqtr2);
    } 
    
    /**
     * getcolumnOptions
     * @param request
     * @return
     */
    option[] getcolumnOptions(HttpServletRequest request){
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	WWindowStatus ws = WWindowStatus.get(request);
    	
    	GridField[] m_findFields = GridField.createFields(
                wsc.ctx, ws.curTab.getWindowNo(), 0, ws.curTab.getAD_Tab_ID(), 0);
    	
		ArrayList<ValueNamePair> items = new ArrayList<ValueNamePair>();
		for (int c = 0; c < m_findFields.length; c++)
		{
			GridField field = m_findFields[c];
			if (field.isEncrypted())
				continue;
			String columnName = field.getColumnName();
			String header = field.getHeader();
			if (header == null || header.length() == 0)
			{
				header = Msg.getElement(wsc.ctx, columnName);
				if (header == null || header.length() == 0)
					continue;
			}
			if (field.isKey())
				header += (" (ID)");
			
			ValueNamePair pp = new ValueNamePair(columnName, header);
			items.add(pp);
		}
		
    	option[] options = new option[items.size() + 1];
    	options[0] = new option("").addElement("");

    	for(int i = 0; i < items.size(); i++){
    		ValueNamePair tmp = items.get(i);
    		options[i + 1] = new option(tmp.getValue()).addElement(tmp.getName());
    	}
    	
    	return options;
    }
    
    void addButtons(HttpServletRequest request, div divBody){
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	WWindowStatus ws = WWindowStatus.get(request);
    	
		table bottomTable = new table("0", "0", "0", "100%", null);
		
		td tdRefresh = (td)new td().setClass("button-box");
		input refresh = AmpiereUtil.createImageButton(wsc.ctx, "Refresh", "");
		refresh.setOnClick("processAction('" + REFRESH_ACTION + "');" + RETURN_FALSE);
		tdRefresh.addElement(refresh);
		
		td tdButton = (td)new td().setClass("button-box");
		
		input cancel = AmpiereUtil.createImageButton(wsc.ctx, "Cancel", 
				"window.close();" + RETURN_FALSE);
		tdButton.addElement(cancel);
		
		input ok = AmpiereUtil.createImageButton(wsc.ctx, "Ok", "");
		ok.setOnClick("processAction('" + OK_ACTION + "');" + RETURN_FALSE);
		tdButton.addElement(ok);

		tr lastTr = (tr)new tr();
		lastTr.addElement(tdRefresh);
		lastTr.addElement(tdButton);
		bottomTable.addElement(lastTr);
		divBody.addElement(bottomTable);
    }
    
    Document processAction(HttpServletRequest request){
		HttpSession session = request.getSession();
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	WWindowStatus ws = WWindowStatus.get(request);
    	
    	Document document = null;
    	
    	String actionType = request.getParameter(Constants.ACTION_TYPE);

    	if(SAVED_QUERY_LOAD_ACTION.equals(actionType)){
    		document = cmd_savedQueryLoad(request);
    	}else if(SAVED_QUERY_DELETE_ACTION.equals(actionType)){
    		document = cmd_savedQueryDelete(request);
    	}else if(COLUMN_ACTION.equals(actionType)){
    		document = processColumnAction(request);
    	}else if(OPERATOR_ACTION.equals(actionType)){
    		document = processOperatorAction(request);
    	}else if(DELETE_ROW_ACTION.equals(actionType)){
    		document = cmd_deleteRow(request);
    	}else if(SAVE_ROW_ACTION.equals(actionType)){
    		document = cmd_saveRow(request);
    	}else if(REFRESH_ACTION.equals(actionType)){
    		document = cmd_refresh(request);
    	}else if(OK_ACTION.equals(actionType)){
    		document = cmd_okAdvanced(request);
    	}
    	
    	return document;
    }
    
    Document processColumnAction(HttpServletRequest request){
		HttpSession session = request.getSession();
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	WWindowStatus ws = WWindowStatus.get(request);
    	List<ValueNamePair> operatorList = new ArrayList();
    	
    	org.w3c.dom.Element queryValue1Element = null;
    	Document document = null;
    	
    	try{
    		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    		DocumentBuilder builder = factory.newDocumentBuilder();
    		//ビルダーからDOMを取得する
    		document = builder.newDocument();
    		
    		org.w3c.dom.Element elements = document.createElement(Constants.ELEMENTS);
    		document.appendChild(elements);
        	
    		String columnName = WebUtil.getParameter(request, COLUMN_ID);
    		if (columnName != null)
    		{
    			log.config("Column=" + columnName);
    			if (columnName.endsWith("_ID") || columnName.endsWith("_Acct"))
    				operatorList = Arrays.asList(Query.OPERATORS_ID);
    			else if (columnName.startsWith("Is"))
    				operatorList = Arrays.asList(Query.OPERATORS_YN);
    			else
    				operatorList = Arrays.asList(Query.OPERATORS);
    			
    			document = getOperatorDoc(document, request, operatorList);
    			
    			GridField field = getTargetMField(request, columnName);
    			document = getEditor(document, request, field, 
    					"queryValueDiv1", "queryValue1", QUERY_VALUE_DISPLAY_1, Constants.NO);
    		}   			
    			
    	}catch(Exception e){
    		;
    	}
		
		return document;
    }

	public Document getOperatorDoc (Document document, HttpServletRequest request, List<ValueNamePair> operatorList)
	{
		org.w3c.dom.Element element = document.createElement(Constants.ELEMENT);
		document.getFirstChild().appendChild(element);

		org.w3c.dom.Element elm_id=document.createElement(Constants.ID);
		String objId = OPERATOR_ID;
		elm_id.appendChild(document.createTextNode(objId));
		element.appendChild(elm_id);

		org.w3c.dom.Element elm_lookup=document.createElement(Constants.LOOKUP);
		element.appendChild(elm_lookup);
		elm_lookup.appendChild(document.createTextNode(Constants.ENABLED));

		org.w3c.dom.Element elm_visibility=document.createElement(Constants.VISIBILITY);
		element.appendChild(elm_visibility);
		elm_visibility.appendChild(document.createTextNode(Constants.ENABLED));

		org.w3c.dom.Element elm_newValue=document.createElement(Constants.NEW_VALUE);
		element.appendChild(elm_newValue);
		
		for(int p = 0; p < operatorList.size(); p++){

			String key = "";
			String value = "";

			ValueNamePair onePair = operatorList.get(p);
			key = onePair.getValue();
			value = onePair.getName();

			//list
			//<name>
			org.w3c.dom.Element elm_item=document.createElement(Constants.ITEM);
			elm_newValue.appendChild(elm_item);
			//<key>
			org.w3c.dom.Element elm_key=document.createElement(Constants.KEY);
			elm_item.appendChild(elm_key);
			elm_key.appendChild(document.createTextNode(String.valueOf(key)));
			//<value>
			org.w3c.dom.Element elm_value=document.createElement(Constants.VALUE);
			elm_item.appendChild(elm_value);
			elm_value.appendChild(document.createTextNode(value));
		}
		

		org.w3c.dom.Element elm_readonly=document.createElement(Constants.READONLY);
		element.appendChild(elm_readonly);
		elm_readonly.appendChild(document.createTextNode(Constants.NO));

		org.w3c.dom.Element elm_type=document.createElement(Constants.TYPE);
		element.appendChild(elm_type);
		elm_type.appendChild(document.createTextNode(Constants.ENABLED));
		
		return document;
	}
    
	/**
	 * 	Set Editor
	 *	@param field field
	 */
	public Document getEditor (Document document, HttpServletRequest request, GridField field, 
			String queryDivId, String queryValueId, String queryValueDisplayId, String readOnly)
	{
		String columnName = "";
		if (field != null)
		{
			columnName = field.getColumnName();
			if (field.isKey())
				;//TODO
				// m_editor = new VNumber(columnName, false, false, true, DisplayType.Integer, columnName);
			else
				;
				//m_editor = VEditorFactory.getEditor(null, field, true, true);
		}
		document = getField(document, request, field, queryDivId, queryValueId, queryValueDisplayId, readOnly);
		return document;
	}	//	setEditor

	
	public Document getField(Document document, HttpServletRequest request, GridField mField, 
			String queryDivId, String queryValueId, String queryValueDisplayId, String readOnly){
		HttpSession session = request.getSession();
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	WWindowStatus ws = WWindowStatus.get(request);
    	
		Lookup lookup = mField.getLookup();
		Object data = "";
		int AD_Column_ID = mField.getAD_Column_ID();
		String onclick = ""; 
		td tdRet = null;
		String dataValue = (data == null) ? "" : data.toString();
		int m_displayType = mField.getDisplayType();
		
		String elementHtml = "";
		String scriptSrc = "";
		//
		if (m_displayType == DisplayType.Search || m_displayType == DisplayType.Location
				|| m_displayType == DisplayType.Account || m_displayType == DisplayType.PAttribute)
		{
			String dataDisplay = "";
			if (lookup != null && data != null)
				dataDisplay = lookup.getDisplay(data);
				elementHtml = getPopupField(request, queryValueId, mField, dataDisplay, dataValue, AD_Column_ID, lookup, onclick);
		} else {
			if (DisplayType.isLookup(m_displayType) || m_displayType == DisplayType.Locator) {
				elementHtml = getSelectField(request, queryValueId, mField, lookup, dataValue, queryValueDisplayId);
			}
			else if (m_displayType == DisplayType.YesNo) {
				elementHtml = getCheckField(request, queryValueId, mField, dataValue);
			}else if (DisplayType.isDate(m_displayType)) {
				elementHtml = getDateField(request, queryValueId, mField, dataValue);
				scriptSrc = getLoadCalendarScript(request, queryValueId, mField, dataValue);
			} else {
				elementHtml = getStringField(request, queryValueId, mField, dataValue);
			}
		}

		org.w3c.dom.Element element = null;

		try{

			
			element = document.createElement(Constants.ELEMENT);
			document.getFirstChild().appendChild(element);

			org.w3c.dom.Element elm_id=document.createElement(Constants.ID);
			String objId = queryDivId;
			elm_id.appendChild(document.createTextNode(objId));
			element.appendChild(elm_id);

			org.w3c.dom.Element elm_lookup=document.createElement(Constants.LOOKUP);
			element.appendChild(elm_lookup);
			elm_lookup.appendChild(document.createTextNode(Constants.LOOKUP_HTML));

			org.w3c.dom.Element elm_visibility=document.createElement(Constants.VISIBILITY);
			element.appendChild(elm_visibility);
			elm_visibility.appendChild(document.createTextNode(Constants.ENABLED));

			org.w3c.dom.Element elm_newValue=document.createElement(Constants.NEW_VALUE);
			element.appendChild(elm_newValue);
			elm_newValue.appendChild(document.createTextNode(elementHtml));

			org.w3c.dom.Element elm_readonly=document.createElement(Constants.READONLY);
			element.appendChild(elm_readonly);
			elm_readonly.appendChild(document.createTextNode(readOnly));

			org.w3c.dom.Element elm_type=document.createElement(Constants.TYPE);
			element.appendChild(elm_type);
			elm_type.appendChild(document.createTextNode(Constants.ENABLED));
			
			//load Calendar
			if(!StringUtils.isEmpty(scriptSrc)){
				org.w3c.dom.Element elementScript = document.createElement(Constants.ELEMENT);
				document.getFirstChild().appendChild(elementScript);

				org.w3c.dom.Element elm_id_script = document.createElement(Constants.ID);
				String objIdScript = queryDivId;
				elm_id_script.appendChild(document.createTextNode(objIdScript));
				elementScript.appendChild(elm_id_script);

				org.w3c.dom.Element elm_lookup_script = document.createElement(Constants.LOOKUP);
				elementScript.appendChild(elm_lookup_script);
				elm_lookup_script.appendChild(document.createTextNode(Constants.LOOKUP_HTML));

				org.w3c.dom.Element elm_visibility_script = document.createElement(Constants.VISIBILITY);
				elementScript.appendChild(elm_visibility_script);
				elm_visibility_script.appendChild(document.createTextNode(Constants.ENABLED));

				org.w3c.dom.Element elm_newValue_script = document.createElement(Constants.NEW_VALUE);
				elementScript.appendChild(elm_newValue_script);
				elm_newValue_script.appendChild(document.createTextNode(scriptSrc));

				org.w3c.dom.Element elm_readonly_script = document.createElement(Constants.READONLY);
				elementScript.appendChild(elm_readonly_script);
				elm_readonly_script.appendChild(document.createTextNode(readOnly));

				org.w3c.dom.Element elm_type_script = document.createElement(Constants.TYPE);
				elementScript.appendChild(elm_type_script);
				elm_type_script.appendChild(document.createTextNode(Constants.SCRIPT));
			}
		}catch(Exception e){
			;
		}	
		
		return document;
	} // getField
	
	private String getPopupField(HttpServletRequest request, String m_columnName, GridField mField, String dataDisplay, String dataValue, 
			int AD_Column_ID, Lookup lookup, String onclick) {
		
		HttpSession session = request.getSession();
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	WWindowStatus ws = WWindowStatus.get(request);
		
		// The hidden data field Name=columnName
		input hidden = new input(input.TYPE_HIDDEN, m_columnName, dataValue);
		hidden.setID(m_columnName + "D");
		int m_displayLength = 20 * 8; // default length;
		int m_displayType = mField.getDisplayType();
		String m_description = mField.getDescription();

		// The display field Name=columnName, ID=FcolumnName
		input display = new input(input.TYPE_TEXT, m_columnName, AmpiereUtil.maskHtmlCR(dataDisplay));//2010/03/02
		display.setID(m_columnName + "F");

		display.addAttribute("style", "width:" + (m_displayLength) + "px;");

		img button = null;
		// Show image button when field is editable

		// The button Name=columnName, ID=BcolumnName
		String gif = "PickOpen16.gif";
		if (m_displayType == DisplayType.Location)
			gif = "Location16.gif";
		else if (m_displayType == DisplayType.Account)
			gif = "Account16.gif";
		else if (m_columnName.equals("C_BPartner_ID"))
			gif = "BPartner16.png";
		else if (m_columnName.equals("M_Product_ID"))
			gif = "Product16.png";
		else if (m_columnName.equals("M_AttributeSetInstance_ID"))
			gif = "PAttribute16.png";

		button = new img(WebEnv.getImageDirectory(gif), m_columnName);
		button.setID(m_columnName + "B");
		button.setClass("popupButton");
		String onClick = "";
		String col = lookup.getColumnName();
		if (col != null && col.indexOf(".") >= 0) {
			col = col.substring(col.indexOf(".") + 1);
		}
		if (m_displayType == DisplayType.Location) {
			onClick = "startLocation('" + m_columnName + "'," + ws.getCurTab().getWindowNo() + "," + AD_Column_ID + ",'" + col
			+ "',null);";
			display.setReadOnly(true);
		} else if (m_displayType == DisplayType.Account) {
			onClick = "startAccount('" + m_columnName + "',null);";
		} else if (m_columnName.equals("M_AttributeSetInstance_ID")) { // clmg
			// 2009/04/25
			onClick = "startPopup('WAttributeSet');";
		} else {
			onClick = "startLookup('" + m_columnName + "'," + ws.getCurTab().getWindowNo() + "," + AD_Column_ID + ",'" + col
			+ "', 'N',null);";
		}

		if (!StringUtils.isEmpty(onclick)) {
			onClick = onclick;
		}

		button.setOnClick(onClick + "return false;");

		if (m_description != null)
			button.setTitle(Util.maskHTML(m_description));

		display.setOnChange("startUpdate(this);");

		StringBuffer htmlBuff = new StringBuffer();
		htmlBuff.append(hidden.toString());
		htmlBuff.append(display.toString());
		htmlBuff.append(button.toString());
		String html = htmlBuff.toString();

		return html;
	} // getPopupField	
	
	private String getSelectField(HttpServletRequest request, String m_columnName, GridField mField, 
			Lookup lookup, String dataValue, String queryValueDisplayId) {
    	int m_displayLength = 20 * 8; // ;
    	
		select sel = new select(m_columnName, getOptions(mField, lookup, dataValue));		
		sel.setID(m_columnName);
		sel.setOnChange("startUpdate(this);");
		sel.setOnChange("");//TODO
		sel.addAttribute("style", "width:" + (m_displayLength) + "px;");

		StringBuffer htmlBuff = new StringBuffer();
		htmlBuff.append(sel.toString());
		String html = htmlBuff.toString();

		return html;
	} // getSelectField	
    
	private String getCheckField(HttpServletRequest request, String m_columnName, GridField mField, String data) {
		String m_name = mField.getColumnName();
		boolean check = data != null && (data.equals("true") || data.equals("Y"));
		input cb = new input(input.TYPE_CHECKBOX, m_columnName, "true").setChecked(check);
		label myLabel = new label(m_columnName + "F", null, Util.maskHTML(m_name));
		myLabel.setID(m_columnName + "L");
		cb.addElement(myLabel);

		cb.setID(m_columnName + "F");
		cb.setOnClick("startUpdate(this);"); 
		
		StringBuffer htmlBuff = new StringBuffer();
		htmlBuff.append(cb.toString());
		String html = htmlBuff.toString();
		
		return html;
	} // getCheckField	
	
	private String getDateField(HttpServletRequest request, String m_columnName, GridField mField, String data) {
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	WWindowStatus ws = WWindowStatus.get(request);
    	int m_windowNo = ws.getCurTab().getWindowNo();
    	int m_displayLength = 20 * 8; // 
    	
    	int m_displayType = mField.getDisplayType();
    	int m_fieldLength = mField.getFieldLength();
    	String m_description = mField.getDescription();
    	
		String formattedData = "";

		input string = new input(input.TYPE_TEXT, m_columnName, formattedData);

		string.setID(m_columnName + "F");
		string.setSize(m_displayLength);
		if (m_fieldLength >= 10)
			string.setMaxlength(m_fieldLength);
		//
		string.setDisabled(false);
		string.setReadOnly(false);

		string.addAttribute("style", "width:" + (m_displayLength) + "px;");

		div dateTimePickerScriptDiv = new div();

		img button = null;

		// Show image button when field is editable
		String gif = "Calendar16.png";
		button = new img(WebEnv.getImageDirectory(gif), m_columnName);

		button.setID(m_columnName + "B");
		button.setClass("popupButton");

		String onClick = "";
		String inputBoxId = m_columnName + "F";
		String buttonId = m_columnName + "B";
		if (m_displayType == DisplayType.DateTime) {
			// Date+Timeの場合
			AmpiereUtil.addDateTimePickerScript(dateTimePickerScriptDiv, inputBoxId, buttonId, wsc.language);
		} else {
			AmpiereUtil.addDatePickerScript(dateTimePickerScriptDiv, inputBoxId, buttonId, wsc.language);
		}

		if (m_description != null)
			button.setTitle(Util.maskHTML(m_description));
		
		StringBuffer htmlBuff = new StringBuffer();
		htmlBuff.append(string.toString());
		htmlBuff.append(button.toString());
		htmlBuff.append(dateTimePickerScriptDiv.toString());
		String html = htmlBuff.toString();
		
		return html;
	} // getDateField	
	
	private String getLoadCalendarScript(HttpServletRequest request, String m_columnName, GridField mField, String data) {
		WebSessionCtx wsc = WebSessionCtx.get(request);
    	int m_displayType = mField.getDisplayType();
    	String locadCalendarScript = "";

    	div dateTimePickerScriptDiv = new div();
		String inputBoxId = m_columnName + "F";
		String buttonId = m_columnName + "B";
		
		if (m_displayType == DisplayType.DateTime) {
			// Date+Timeの場合
			locadCalendarScript = AmpiereUtil.getLoadCalendarDateTimePickerScript(dateTimePickerScriptDiv, inputBoxId, buttonId, wsc.language);
		} else {
			locadCalendarScript =  AmpiereUtil.getLoadCalendarDatePickerScript(dateTimePickerScriptDiv, inputBoxId, buttonId, wsc.language);
		}
		
		return locadCalendarScript;
	} // getDateField		
	
	private String getStringField(HttpServletRequest request, String m_columnName, GridField mField, String data) {
		int m_displayLength = 20 * 8; // 
    	int m_displayType = mField.getDisplayType();
    	int m_fieldLength = mField.getFieldLength();
		input string = new input(input.TYPE_TEXT, m_columnName, AmpiereUtil.maskHtmlCR(data));
		string.setID(m_columnName + "F");
		if (m_displayLength > 128) {
			string.setSize(128);
		} else {
			string.setSize(m_displayLength);
		}
		if (m_fieldLength > 0)
			string.setMaxlength(m_fieldLength);
		//
		string.setDisabled(false);
		string.addAttribute("style", "width:" + (m_displayLength) + "px;");

		StringBuffer htmlBuff = new StringBuffer();
		htmlBuff.append(string.toString());
		String html = htmlBuff.toString();
		
		return html;
	} // getStringField	
	
    Document processOperatorAction(HttpServletRequest request){
		HttpSession session = request.getSession();
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	WWindowStatus ws = WWindowStatus.get(request);
    	Document document = null;
    	
    	try{
    		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    		DocumentBuilder builder = factory.newDocumentBuilder();
    		//ビルダーからDOMを取得する
    		document = builder.newDocument();
    		
    		org.w3c.dom.Element elements = document.createElement(Constants.ELEMENTS);
    		document.appendChild(elements);
    	}catch(Exception e){
    		;
    	}
    	
    	String op = WebUtil.getParameter(request, OPERATOR_ID);
    	if (op != null)
    	{
    		log.config("Operator: " + op);
    		if (Query.BETWEEN.equals(op))
    		{
    			String columnName = WebUtil.getParameter(request, COLUMN_ID);    			
    			GridField field = getTargetMField(request, columnName);
    			document = getEditor(document, request, field, 
    					"queryValueDiv2", "queryValue2", QUERY_VALUE_DISPLAY_2, Constants.NO);
    		}
    	}
    	else
    	{
			String columnName = WebUtil.getParameter(request, COLUMN_ID);			
			GridField field = getTargetMField(request, columnName);
			document = getEditor(document, request, field, 
					"queryValueDiv2", "queryValue2", QUERY_VALUE_DISPLAY_2, Constants.YES); //readonly
    	}
	
		return document;
    }    
    
	/**
	 * 	Save Advanced Row
	 * 	@return true if row saved
	 */
	private Document cmd_refresh(HttpServletRequest request)
	{    	
		WWindowStatus ws = WWindowStatus.get(request);
		
		Document document = null;		
    	document = cmd_saveRow(request);
		Query query = getQueryAdvanced(request);
		String alert_msg = "";
		int m_total = getNoOfRecords(request, query, true);
		MRole role = MRole.getDefault(ws.ctx,false); 
		//	No Records
		if (m_total == 0)
			alert_msg = AWebUtil.info(request, "FindZeroRecords", null);
		//	More then allowed
		else if (query != null && role.isQueryMax(m_total))
			alert_msg = AWebUtil.info(request, "FindOverMax", m_total + " > " + role.getMaxQueryRecords());
		else
			log.config("#" + m_total);
		
		//refresh query
		if(StringUtils.isEmpty(alert_msg)){
			if (query != null && query.isActive())
				ws.curTab.setQuery(query);
			else 
				ws.curTab.setQuery(null);
			ws.curTab.query(0);
		}

		//build document below
    	try{    		    		
    		org.w3c.dom.Element element = document.createElement(Constants.ELEMENT);
			document.getFirstChild().appendChild(element);

			if(StringUtils.isEmpty(alert_msg)){
				//refresh parent window
				org.w3c.dom.Element elm_id=document.createElement(Constants.ID);
				String objId = QUERY_ENTRY_DIV; //ここはなんでもいい。とりあえず、nullにしたくないため。
				elm_id.appendChild(document.createTextNode(objId));
				element.appendChild(elm_id);

				org.w3c.dom.Element elm_lookup=document.createElement(Constants.LOOKUP);
				element.appendChild(elm_lookup);
				elm_lookup.appendChild(document.createTextNode(Constants.DISABLED));

				org.w3c.dom.Element elm_visibility=document.createElement(Constants.VISIBILITY);
				element.appendChild(elm_visibility);
				elm_visibility.appendChild(document.createTextNode(Constants.ENABLED));

				org.w3c.dom.Element elm_newValue=document.createElement(Constants.NEW_VALUE);
				element.appendChild(elm_newValue);
				StringBuffer sb = new StringBuffer();
				sb.append("window.opener.onunload='';");
				sb.append("window.opener.document.WForm.PCommand.value='Refresh';");
				sb.append("window.opener.document.WForm.submit();");
				elm_newValue.appendChild(document.createTextNode(sb.toString()));

				org.w3c.dom.Element elm_readonly=document.createElement(Constants.READONLY);
				element.appendChild(elm_readonly);
				elm_readonly.appendChild(document.createTextNode(Constants.NO));

				org.w3c.dom.Element elm_type=document.createElement(Constants.TYPE);
				element.appendChild(elm_type);
				elm_type.appendChild(document.createTextNode(Constants.SCRIPT));
			}else{
				//alert
				org.w3c.dom.Element elm_id=document.createElement(Constants.ID);
				String objId = QUERY_ENTRY_DIV; //ここはなんでもいい。とりあえず、nullにしたくないため。
				elm_id.appendChild(document.createTextNode(objId));
				element.appendChild(elm_id);

				org.w3c.dom.Element elm_lookup=document.createElement(Constants.LOOKUP);
				element.appendChild(elm_lookup);
				elm_lookup.appendChild(document.createTextNode(Constants.DISABLED));

				org.w3c.dom.Element elm_visibility=document.createElement(Constants.VISIBILITY);
				element.appendChild(elm_visibility);
				elm_visibility.appendChild(document.createTextNode(Constants.ENABLED));

				org.w3c.dom.Element elm_newValue=document.createElement(Constants.NEW_VALUE);
				element.appendChild(elm_newValue);
				StringBuffer sb = new StringBuffer();
				sb.append("alert('" + alert_msg + "');");
				elm_newValue.appendChild(document.createTextNode(sb.toString()));

				org.w3c.dom.Element elm_readonly=document.createElement(Constants.READONLY);
				element.appendChild(elm_readonly);
				elm_readonly.appendChild(document.createTextNode(Constants.NO));

				org.w3c.dom.Element elm_type=document.createElement(Constants.TYPE);
				element.appendChild(elm_type);
				elm_type.appendChild(document.createTextNode(Constants.SCRIPT));
			}

    	}catch(Exception e){
    		;
    	}
		
		return document;
	}	//	cmd_saveRow  
    
	/**
	 * 	Save Advanced Row
	 * 	@return true if row saved
	 */
	private Document cmd_saveRow(HttpServletRequest request)
	{
		HttpSession session = request.getSession();
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	WWindowStatus ws = WWindowStatus.get(request);
    	
    	Document document = null;
    	
    	try{
    		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    		DocumentBuilder builder = factory.newDocumentBuilder();
    		//ビルダーからDOMを取得する
    		document = builder.newDocument();
    		
    		org.w3c.dom.Element elements = document.createElement(Constants.ELEMENTS);
    		document.appendChild(elements);
    	}catch(Exception e){
    		;
    	}
    	
		
    	String column = WebUtil.getParameter(request, COLUMN_ID);
		if (StringUtils.isEmpty(column))
			return document;
		
		GridField field = getTargetMField(request, column);
		int m_displayType = field.getDisplayType();
		//
		String op = WebUtil.getParameter(request, OPERATOR_ID);
		//	Value
		String value = WebUtil.getParameter(request, QUERY_VALUE_1);
		String valueDisplay = WebUtil.getParameter(request, QUERY_VALUE_1);
		if((DisplayType.isLookup(m_displayType) || m_displayType == DisplayType.Locator)){
			valueDisplay = getValueDisplay(field, field.getLookup(), value);

		}else if(DisplayType.YesNo == m_displayType){
			value = "true".equals(value) ? "Y" : "N";
		}
		
		if(StringUtils.isEmpty(valueDisplay)){
			valueDisplay = value;
		}
		
		ValueNamePair v = null;
		
		if (value == null 
				|| "-1".equals(value) && (DisplayType.isLookup(m_displayType) || m_displayType == DisplayType.Locator))
		{
			if (Query.EQUAL.equals(op) || Query.NOT_EQUAL.equals(op))
				v = new ValueNamePair(Null.NULLString, "NULL");
			else
			{
				return document;
			}
		}
		else
		{
			v = new ValueNamePair(value.toString(), valueDisplay);
		}
		
		//	Value 2
		ValueNamePair v2 = null;
		if (Query.BETWEEN.equals(op))
		{			
			String value2 = WebUtil.getParameter(request, QUERY_VALUE_2);
			String value2Display = WebUtil.getParameter(request, QUERY_VALUE_2);
			if((DisplayType.isLookup(m_displayType) || m_displayType == DisplayType.Locator)){
				value2Display = getValueDisplay(field, field.getLookup(), value2);
				if(StringUtils.isEmpty(valueDisplay)){
					valueDisplay = value;
				}
			}
			if (value2 == null)
				return document;
			else if ("-1".equals(value) && (DisplayType.isLookup(m_displayType) || m_displayType == DisplayType.Locator)){
				//value display
				value2Display = getValueDisplay(field, field.getLookup(), value2);
			}
			else
			{
				v2 = new ValueNamePair(value2.toString(), value2Display);
			}
		}
		
		AdvancedRow row = new AdvancedRow(getColumnValueNamePair(request, column), getOperatorValueNamePair(op), v, v2);
		Vector<AdvancedRow> advancedData = (Vector<AdvancedRow>)session.getAttribute(ADVANCED_DATA);
		if(advancedData == null){
			advancedData = new Vector<AdvancedRow>();
		}
		advancedData.add(row);
		session.setAttribute(ADVANCED_DATA, advancedData);

		//build document below
    	try{
			document = addAdvancedData(document, request);
    	}catch(Exception e){
    		;
    	}
		
		return document;
	}	//	cmd_saveRow  
	
	private String getValueDisplay(GridField mField, Lookup lookup, String dataValue) {
		int m_displayType = mField.getDisplayType();
		String valueDisplay = "";
		if (lookup == null)
			return valueDisplay;
		//
		Object[] list = lookup.getData(false, true, false, false).toArray(); 
		
		int size = list.length;
		if (size <= 0) {
			// Force load for display
			list = lookup.getData(false, true, true, true).toArray();
			size = list.length;
		}
		option[] options = new option[size];
		for (int i = 0; i < size; i++) {
			boolean isNumber = list[0] instanceof KeyNamePair;
			String key = null;
			if (m_displayType == DisplayType.Locator && !isNumber)
			{
				MLocator loc = (MLocator) list[i];
				key = String.valueOf(loc.getM_Locator_ID());
				String name = AmpiereUtil.maskHTML(loc.getValue());
				if (dataValue.equals(key)){
					valueDisplay = name;
					break;
				}
			} else if (isNumber) {
				KeyNamePair p = (KeyNamePair) list[i];
				key = String.valueOf(p.getKey());
				String name = AmpiereUtil.maskHTML(p.getName());
				if (dataValue.equals(key)){
					valueDisplay = name;
					break;
				}
			} else {
				ValueNamePair p = (ValueNamePair) list[i];
				key = p.getValue();
				if (key == null || key.length() == 0)
					key = "";
				String name = p.getName();
				if (name == null || name.length() == 0)
					name = " ";
				name = AmpiereUtil.maskHTML(name);
				if (dataValue.equals(key)){
					valueDisplay = name;
					break;
				}
			}
		}
		return valueDisplay;
	} // getOptions		
	
	private Document addAdvancedData(Document document, HttpServletRequest request){
		//build document below
    	try{    		    		
    		org.w3c.dom.Element element = document.createElement(Constants.ELEMENT);
			document.getFirstChild().appendChild(element);

			org.w3c.dom.Element elm_id=document.createElement(Constants.ID);
			String objId = QUERY_ENTRY_DIV;
			elm_id.appendChild(document.createTextNode(objId));
			element.appendChild(elm_id);

			org.w3c.dom.Element elm_lookup=document.createElement(Constants.LOOKUP);
			element.appendChild(elm_lookup);
			elm_lookup.appendChild(document.createTextNode(Constants.LOOKUP_HTML));

			org.w3c.dom.Element elm_visibility=document.createElement(Constants.VISIBILITY);
			element.appendChild(elm_visibility);
			elm_visibility.appendChild(document.createTextNode(Constants.ENABLED));

			org.w3c.dom.Element elm_newValue=document.createElement(Constants.NEW_VALUE);
			element.appendChild(elm_newValue);
			String advancedDateHtml = getAdvancedDateHtml(request);
			elm_newValue.appendChild(document.createTextNode(advancedDateHtml));

			org.w3c.dom.Element elm_readonly=document.createElement(Constants.READONLY);
			element.appendChild(elm_readonly);
			elm_readonly.appendChild(document.createTextNode(Constants.NO));

			org.w3c.dom.Element elm_type=document.createElement(Constants.TYPE);
			element.appendChild(elm_type);
			elm_type.appendChild(document.createTextNode(Constants.ENABLED));
    	}catch(Exception e){
    		;
    	}
    	return document;
	}
	
	private String getAdvancedDateHtml(HttpServletRequest request) {
		HttpSession session = request.getSession();
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	WWindowStatus ws = WWindowStatus.get(request);
    	int m_displayLength = 20 * 8; // ;
    	
		Vector<AdvancedRow> advancedData = (Vector<AdvancedRow>)session.getAttribute(ADVANCED_DATA);
		if(advancedData == null || advancedData.size() == 0){
			return "</br>";
		}
    	
		table advancedDataTable = new table("1", "0", "5", "100%", null);
		advancedDataTable.setStyle("margin-top: 30px;");
		//advancedDataTable.setStyle("margin-bottom: 20px;");
		advancedDataTable.setBorderColor("#7F9DB9");
		//advancedDataTable.setClass("displaytag");
		td sqtd0 = (td) new td().setStyle("min-width:20px;");
		td sqtd1 = (td) new td().setStyle("min-width:80px;");
		td sqtd2 = (td) new td().setStyle("min-width:80px;");
		td sqtd3 = (td) new td().setStyle("min-width:80px;");
		td sqtd4 = (td) new td().setStyle("min-width:80px;");
		
		//td 0
		sqtd0.addElement("");
		//td 1
		sqtd1.addElement(Msg.translate(wsc.ctx,"AD_Column_ID"));
		//td 2
		sqtd2.addElement(Msg.translate(wsc.ctx,"Operator"));
		//td 3
		sqtd3.addElement(Msg.translate(wsc.ctx,"QueryValue"));
		//td 4
		sqtd4.addElement(Msg.translate(wsc.ctx,"QueryValue2"));
		//add tr
		tr sqtr = new tr();
		sqtr.addElement(sqtd0).addElement(sqtd1).addElement(sqtd2).addElement(sqtd3).addElement(sqtd4);
		advancedDataTable.addElement(sqtr);
		
		for (int i = 0; i < advancedData.size(); i++) {
			tr rowTr = new tr();
			advancedDataTable.addElement(rowTr);
			td td0 = (td) new td().setStyle("min-width:20px;");
			td td1 = (td) new td().setStyle("min-width:80px;");
			td td2 = (td) new td().setStyle("min-width:80px;");
			td td3 = (td) new td().setStyle("min-width:80px;");
			td td4 = (td) new td().setStyle("min-width:80px;");
			rowTr.addElement(td0).addElement(td1).addElement(td2).addElement(td3).addElement(td4);
			
			//td0
			input rowIndex = new input(input.TYPE_RADIO, QUERY_ENTRY_INDEX, i);
			td0.addElement(rowIndex);			

			AdvancedRow row = advancedData.get(i);
			//td1--td4 advanced data below
			String column = row.getColumn().getName();
			td1.addElement(column);
			rowTr.addElement(td1);
			//td2
			String operator = row.getOperator().getName();
			td2.addElement(operator);
			rowTr.addElement(td2);
			//td3
			String value = Null.NULLString;
			if(row.getValue()!=null){
				value = row.getValue().getName();
			}				
			td3.addElement(value);
			rowTr.addElement(td3);
			//td4
			String value2 = "";
			if(row.getValue2()!=null){
				value2 = row.getValue2().getName();
			}
			td4.addElement(value2);
			rowTr.addElement(td4);
		}
		
		StringBuffer htmlBuff = new StringBuffer();
		htmlBuff.append(advancedDataTable.toString());
		String html = htmlBuff.toString();

		return html;
	} // getSelectField	
	
	private ValueNamePair getOperatorValueNamePair(String value){
		ValueNamePair[] operators = Query.OPERATORS;
		ValueNamePair operator = null;
		for (int i = 0; i < operators.length; i++) {
			if(operators[i].getValue().equals(value)){
				operator = operators[i];
				break;
			}
		}
		return operator;
	}
	
    private ValueNamePair getColumnValueNamePair(HttpServletRequest request, String value){
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	WWindowStatus ws = WWindowStatus.get(request);
    	GridField[] m_findFields = GridField.createFields(
                wsc.ctx, ws.curTab.getWindowNo(), 0, ws.curTab.getAD_Tab_ID(), 0);
    	ValueNamePair pair = null;

    	for(int i = 0; i < m_findFields.length; i++){
    		GridField field = m_findFields[i];
    		if(field.getColumnName().equals(value)){
    			pair = new ValueNamePair(value, field.getHeader());
    			break;
    		}
    	}
    	return pair;
    }
	
	/**
	 * 	Delete selected Advanced Row
	 */
	private Document cmd_deleteRow(HttpServletRequest request)
	{
		HttpSession session = request.getSession();
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	WWindowStatus ws = WWindowStatus.get(request);	
    	
    	Document document = null;
    	try{
    		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    		DocumentBuilder builder = factory.newDocumentBuilder();
    		//ビルダーからDOMを取得する
    		document = builder.newDocument();
    		
    		org.w3c.dom.Element elements = document.createElement(Constants.ELEMENTS);
    		document.appendChild(elements);
    	}catch(Exception e){
    		;
    	}
    	
		int index = StringToIntConverter.StringToInt(WebUtil.getParameter(request, QUERY_ENTRY_INDEX));
		log.info("#" + index);
		if (index == -1)
			return document;

		//TODO delete
		Vector<AdvancedRow> advancedData = (Vector<AdvancedRow>)session.getAttribute(ADVANCED_DATA);
		if(advancedData!=null){
			advancedData.remove(index);
		}
		session.setAttribute(ADVANCED_DATA, advancedData);
		document = addAdvancedData(document, request);
		
		return document;		
	}	//	cmd_deleteRow
	
	/**
	 * 	Get Query from Advanced Tab
	 *	@return query
	 */
	private Query getQueryAdvanced(HttpServletRequest request)
	{
		HttpSession session = request.getSession();
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	WWindowStatus ws = WWindowStatus.get(request);	
    	String m_tableName = ws.getCurTab().getTableName();
    	
		Query query = new Query(m_tableName);
		Vector<AdvancedRow> advancedData = (Vector<AdvancedRow>)session.getAttribute(ADVANCED_DATA);
		if(advancedData == null){
			return null;
		}
		for (int i = 0; i < advancedData.size(); i++)
		{
			AdvancedRow row = advancedData.get(i);
			//	Column
			ValueNamePair column = row.getColumn();
			String infoName = column.getName();
			String columnName = column.getValue();
			GridField field = getTargetMField(request, columnName);
			String columnSQL = field.getColumnSQL(false);
			//	Op
			String operator = row.getOperator().getValue();

			//	Value	******
			ValueNamePair value = row.getValue();
			Object parsedValue = parseValue(request, field, value);
			String infoDisplay = null;
			if (value == null)
			{
				if (Query.BETWEEN.equals(operator))
					continue;	//	no null in between
				parsedValue = Null.NULLString;
				infoDisplay = "NULL";
			}
			else
				infoDisplay = value.getName();
			//	Value2	******
			if (Query.BETWEEN.equals(operator))
			{
				ValueNamePair value2 = row.getValue2();
				if (value2 == null)
					continue;
				Object parsedValue2 = parseValue(request, field, value2);
				String infoDisplay_to = value2.getName();
				if (parsedValue2 == null)
					continue;
				query.addRangeRestriction(columnSQL, parsedValue, parsedValue2,
					infoName, infoDisplay, infoDisplay_to);
			}
			else
				query.addRestriction(columnSQL, operator, parsedValue,
					infoName, infoDisplay);
		}
		return query;
	}	//	getQueryAdvanced
		
	/**
	 * 	Get Target MField
	 * 	@param columnName column name
	 * 	@return MField
	 */
	private GridField getTargetMField (HttpServletRequest request, String columnName)
	{
		HttpSession session = request.getSession();
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	WWindowStatus ws = WWindowStatus.get(request);	
    	
		GridField[] findFields = GridField.createFields(
                wsc.ctx, ws.curTab.getWindowNo(), 0, ws.curTab.getAD_Tab_ID(), 0);
		if (columnName == null)
			return null;
		for (int c = 0; c < findFields.length; c++)
		{
			GridField field = findFields[c];
			if (columnName.equals(field.getColumnName()))
				return field;
		}
		return null;
	}	//	getTargetMField    	
	
	/**
	 * 	Parse Value
	 * 	@param field column
	 * 	@param in value
	 * 	@return data type corrected value
	 */
	private Object parseValue (HttpServletRequest request, GridField field, ValueNamePair pp)
	{
		WebSessionCtx wsc = WebSessionCtx.get(request);
		
		if (pp == null)
			return null;
		int dt = field.getDisplayType();
		String in = pp.getValue();
		if (in == null || in.equals(Null.NULLString))
			return null;
		try
		{
			//	Return Integer
			if (dt == DisplayType.Integer
				|| (DisplayType.isID(dt) && field.getColumnName().endsWith("_ID")))
			{
				int i = Integer.parseInt(in);
				return new Integer(i);
			}
			//	Return BigDecimal
			else if (DisplayType.isNumeric(dt))
			{
				return DisplayType.getNumberFormat(dt).parse(in);
			}
			//	Return Timestamp
			else if (DisplayType.isDate(dt))
			{
				Timestamp ts = null;
				try
				{
					java.util.Date d = null;
					if (dt == DisplayType.Date)
						d = wsc.dateFormat.parse(in);
					else
						d = wsc.dateTimeFormat.parse(in);
					ts = new Timestamp(d.getTime());
				}
				catch (Exception e)
				{
					log.warning("Date: " + field.getColumnName() + "=" + in + ERROR);
					return ERROR;
				}
				log.fine("Date: " + field.getColumnName() + "=" + in + " -> " + ts);
				return ts;
			}
		}
		catch (Exception ex)
		{
			log.log(Level.WARNING, "Object=" + in, ex);
			String error = ex.getLocalizedMessage();
			if (error == null || error.length() == 0)
				error = ex.toString();
			StringBuffer errMsg = new StringBuffer();
			errMsg.append(field.getColumnName()).append(" = ").append(in).append(" - ").append(error);
			//
			return null;
		}

		return in;
	}	//	parseValue
	

	/**
	 * 	Load saved Query - Advanced
	 */
	private Document cmd_savedQueryLoad(HttpServletRequest request)
	{
		HttpSession session = request.getSession();
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	WWindowStatus ws = WWindowStatus.get(request);
    	
		Document document = null;
		try{
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			//ビルダーからDOMを取得する
			document = builder.newDocument();

			org.w3c.dom.Element elements = document.createElement(Constants.ELEMENTS);
			document.appendChild(elements);
		}catch(Exception e){
			;
		}
		
		session.setAttribute(ADVANCED_DATA, null);
		
		MUserQuery uq = getSelectedQuery(request);
		if (uq == null)
		{
			addAdvancedData(document, request);
			addQueryName(document, request, "");
			return document;
		}
		log.info(uq.toStringX());
		Vector<AdvancedRow> advancedData = new Vector<AdvancedRow>();
		
		//	Load Info Table
		Vector<AdvancedRow> ad = reloadAdvancedRow(uq);
		
		
		if (ad != null)
		{
			for (int i = 0; i < ad.size(); i++)
            {
	            AdvancedRow row = ad.get(i);
				advancedData.add(row);
            }
		}
		session.setAttribute(ADVANCED_DATA, advancedData);
		
		//
		try{
			addAdvancedData(document, request);
			addQueryName(document, request, uq.getName());

		}catch(Exception e){
			;
		}
		
		return document;
		
	}	//	cmd_savedQueryLoad   
	
	Vector<AdvancedRow> reloadAdvancedRow(MUserQuery query){
		Vector<AdvancedRow> retValue = new Vector<AdvancedRow>();
		MUserQueryLine[] lines = query.getLines(true);
		for (int i = 0; i < lines.length; i++)
		{
			MUserQueryLine line = lines[i];
			ValueNamePair column = new ValueNamePair(line.getKeyValue(), line.getKeyName());
			ValueNamePair operator = line.getOperatorPair();
			ValueNamePair value = new ValueNamePair(line.getValue1Value(), line.getValue1Name());
			ValueNamePair value2 = null;
			if (line.getValue2Value() != null)
				value2 = new ValueNamePair(line.getValue2Value(), line.getValue2Name());
			//
			AdvancedRow row = new AdvancedRow(column, operator, value, value2);
			retValue.add(row);
		}
		return retValue;
	}
	
	private Document addQueryName(Document document, HttpServletRequest request, String queryName){
		//build document below
    	try{    		    		
    		org.w3c.dom.Element element = document.createElement(Constants.ELEMENT);
			document.getFirstChild().appendChild(element);

			org.w3c.dom.Element elm_id=document.createElement(Constants.ID);
			String objId = QUERY_NAME;
			elm_id.appendChild(document.createTextNode(objId));
			element.appendChild(elm_id);

			org.w3c.dom.Element elm_lookup=document.createElement(Constants.LOOKUP);
			element.appendChild(elm_lookup);
			elm_lookup.appendChild(document.createTextNode(Constants.DISABLED));

			org.w3c.dom.Element elm_visibility=document.createElement(Constants.VISIBILITY);
			element.appendChild(elm_visibility);
			elm_visibility.appendChild(document.createTextNode(Constants.ENABLED));

			org.w3c.dom.Element elm_newValue=document.createElement(Constants.NEW_VALUE);
			element.appendChild(elm_newValue);
			elm_newValue.appendChild(document.createTextNode(queryName));

			org.w3c.dom.Element elm_readonly=document.createElement(Constants.READONLY);
			element.appendChild(elm_readonly);
			elm_readonly.appendChild(document.createTextNode(Constants.NO));

			org.w3c.dom.Element elm_type=document.createElement(Constants.TYPE);
			element.appendChild(elm_type);
			elm_type.appendChild(document.createTextNode(Constants.ENABLED));
    	}catch(Exception e){
    		;
    	}
    	return document;
	}
	
	/**
	 *	Delete User Query
	 */
	private Document cmd_savedQueryDelete(HttpServletRequest request)
	{
		HttpSession session = request.getSession();
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	WWindowStatus ws = WWindowStatus.get(request);	
    	String result_msg = "";
    	
    	Document document = null;
		try{
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			//ビルダーからDOMを取得する
			document = builder.newDocument();

			org.w3c.dom.Element elements = document.createElement(Constants.ELEMENTS);
			document.appendChild(elements);
		}catch(Exception e){
			;
		}
    	
		MUserQuery uq = getSelectedQuery(request);
		if (uq == null)
			return document;
		
		log.info(uq.toStringX());
		String name = uq.getName(); 
		if (uq.delete(true))
		{
			result_msg = AWebUtil.info(request, "Deleted", name);
			session.setAttribute(ADVANCED_DATA, null);
			addAdvancedData(document, request);
			addQueryName(document, request, "");
			addSavedQuery(document, request);
		}
		else
			result_msg = AWebUtil.info(request, "DeleteError", null);
		
		
		
		return document;
	}	//	cmd_delete
	
	Document addResultMessage(Document document, HttpServletRequest request, String result_msg){
		//build document below
    	try{
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			//ビルダーからDOMを取得する
			document = builder.newDocument();
			org.w3c.dom.Element elements = document.createElement(Constants.ELEMENTS);
			document.appendChild(elements);
			
    		org.w3c.dom.Element element = document.createElement(Constants.ELEMENT);
			document.getFirstChild().appendChild(element);

			org.w3c.dom.Element elm_id=document.createElement(Constants.ID);
			String objId = QUERY_ENTRY_DIV; //ここはなんでもいい。とりあえず、nullにしたくないため。
			elm_id.appendChild(document.createTextNode(objId));
			element.appendChild(elm_id);

			org.w3c.dom.Element elm_lookup=document.createElement(Constants.LOOKUP);
			element.appendChild(elm_lookup);
			elm_lookup.appendChild(document.createTextNode(Constants.DISABLED));

			org.w3c.dom.Element elm_visibility=document.createElement(Constants.VISIBILITY);
			element.appendChild(elm_visibility);
			elm_visibility.appendChild(document.createTextNode(Constants.ENABLED));

			org.w3c.dom.Element elm_newValue=document.createElement(Constants.NEW_VALUE);
			element.appendChild(elm_newValue);
			StringBuffer sb = new StringBuffer();
			if(!StringUtils.isEmpty(result_msg)){
				sb.append("alert('" + result_msg + "');window.close();");
			}
			elm_newValue.appendChild(document.createTextNode(sb.toString()));

			org.w3c.dom.Element elm_readonly=document.createElement(Constants.READONLY);
			element.appendChild(elm_readonly);
			elm_readonly.appendChild(document.createTextNode(Constants.NO));

			org.w3c.dom.Element elm_type=document.createElement(Constants.TYPE);
			element.appendChild(elm_type);
			elm_type.appendChild(document.createTextNode(Constants.SCRIPT));
    	}catch(Exception e){
    		;
    	}
    	
    	return document;
	}
	
	private Document addSavedQuery(Document document, HttpServletRequest request){
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	WWindowStatus ws = WWindowStatus.get(request);	
		//build document below
    	try{    		    		
    		org.w3c.dom.Element element = document.createElement(Constants.ELEMENT);
			document.getFirstChild().appendChild(element);

			org.w3c.dom.Element elm_id=document.createElement(Constants.ID);
			String objId = QUERY_ID;
			elm_id.appendChild(document.createTextNode(objId));
			element.appendChild(elm_id);

			org.w3c.dom.Element elm_lookup=document.createElement(Constants.LOOKUP);
			element.appendChild(elm_lookup);
			elm_lookup.appendChild(document.createTextNode(Constants.ENABLED));

			org.w3c.dom.Element elm_visibility=document.createElement(Constants.VISIBILITY);
			element.appendChild(elm_visibility);
			elm_visibility.appendChild(document.createTextNode(Constants.ENABLED));

			org.w3c.dom.Element elm_newValue=document.createElement(Constants.NEW_VALUE);
			element.appendChild(elm_newValue);
			
			MUserQuery[] queries = MUserQuery.get(wsc.ctx, ws.getCurTab()
					.getAD_Tab_ID(), ws.getCurTab().getAD_Table_ID());
			
			String key = "";
			String value = "";

			// blank option
			// <name>
			org.w3c.dom.Element elm_item = document.createElement(Constants.ITEM);
			elm_newValue.appendChild(elm_item);
			// <key>
			org.w3c.dom.Element elm_key = document.createElement(Constants.KEY);
			elm_item.appendChild(elm_key);
			elm_key.appendChild(document.createTextNode(String.valueOf(key)));
			// <value>
			org.w3c.dom.Element elm_value = document
					.createElement(Constants.VALUE);
			elm_item.appendChild(elm_value);
			elm_value.appendChild(document.createTextNode(value));
			
			for (int p = 0; p < queries.length; p++) {
				key = queries[p].getCode();
				value = queries[p].getName();
				// list
				// <name>
				elm_item = document
						.createElement(Constants.ITEM);
				elm_newValue.appendChild(elm_item);
				// <key>
				elm_key = document.createElement(Constants.KEY);
				elm_item.appendChild(elm_key);
				elm_key.appendChild(document.createTextNode(String.valueOf(key)));
				// <value>
				elm_value = document.createElement(Constants.VALUE);
				elm_item.appendChild(elm_value);
				elm_value.appendChild(document.createTextNode(value));
			}

			org.w3c.dom.Element elm_readonly=document.createElement(Constants.READONLY);
			element.appendChild(elm_readonly);
			elm_readonly.appendChild(document.createTextNode(Constants.NO));

			org.w3c.dom.Element elm_type=document.createElement(Constants.TYPE);
			element.appendChild(elm_type);
			elm_type.appendChild(document.createTextNode(Constants.ENABLED));
    	}catch(Exception e){
    		;
    	}
    	return document;
	}
	
	MUserQuery getSelectedQuery(HttpServletRequest request){
		HttpSession session = request.getSession();
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	WWindowStatus ws = WWindowStatus.get(request);
    	
		String queryCode = WebUtil.getParameter(request, QUERY_ID);
		MUserQuery[] queries = MUserQuery.get (wsc.ctx, ws.getCurTab().getAD_Tab_ID(), ws.getCurTab().getAD_Table_ID());
		MUserQuery uq = null;
		for(int i = 0; i < queries.length; i++){
			MUserQuery query = queries[i];
			if(query.getCode().equals(queryCode)){
				uq = query;
				break;
			}
		}
		return uq;
	}
	
	/**
	 *	Advanced OK Button pressed
	 */
	private Document cmd_okAdvanced(HttpServletRequest request)
	{
		WWindowStatus ws = WWindowStatus.get(request);
		Document document = null;
		
		//	save pending
		String result_msg = cmd_saveAdvanced(request);
		Query query = getQueryAdvanced(request);
		//refresh query
		if (query != null && query.isActive())
			ws.curTab.setQuery(query);
		else 
			ws.curTab.setQuery(null);
		ws.curTab.query(0);

		//build document below
    	try{
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			//ビルダーからDOMを取得する
			document = builder.newDocument();
			org.w3c.dom.Element elements = document.createElement(Constants.ELEMENTS);
			document.appendChild(elements);
			
    		org.w3c.dom.Element element = document.createElement(Constants.ELEMENT);
			document.getFirstChild().appendChild(element);

			org.w3c.dom.Element elm_id=document.createElement(Constants.ID);
			String objId = QUERY_ENTRY_DIV; //ここはなんでもいい。とりあえず、nullにしたくないため。
			elm_id.appendChild(document.createTextNode(objId));
			element.appendChild(elm_id);

			org.w3c.dom.Element elm_lookup=document.createElement(Constants.LOOKUP);
			element.appendChild(elm_lookup);
			elm_lookup.appendChild(document.createTextNode(Constants.DISABLED));

			org.w3c.dom.Element elm_visibility=document.createElement(Constants.VISIBILITY);
			element.appendChild(elm_visibility);
			elm_visibility.appendChild(document.createTextNode(Constants.ENABLED));

			org.w3c.dom.Element elm_newValue=document.createElement(Constants.NEW_VALUE);
			element.appendChild(elm_newValue);
			StringBuffer sb = new StringBuffer();
			sb.append("window.opener.onunload='';");
			sb.append("window.opener.document.WForm.PCommand.value='Refresh';");
			sb.append("window.opener.document.WForm.submit();");
			if(!StringUtils.isEmpty(result_msg)){
				sb.append("alert('" + result_msg + "');window.close();");
			}else{
				sb.append("window.close();");
			}
			elm_newValue.appendChild(document.createTextNode(sb.toString()));

			org.w3c.dom.Element elm_readonly=document.createElement(Constants.READONLY);
			element.appendChild(elm_readonly);
			elm_readonly.appendChild(document.createTextNode(Constants.NO));

			org.w3c.dom.Element elm_type=document.createElement(Constants.TYPE);
			element.appendChild(elm_type);
			elm_type.appendChild(document.createTextNode(Constants.SCRIPT));
    	}catch(Exception e){
    		;
    	}
		
		return document;
		

	}	//	cmd_ok_Advanced	
	
	/**
	 *	Save (Advanced)
	 */
	private String cmd_saveAdvanced(HttpServletRequest request)
	{
		HttpSession session = request.getSession();
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	WWindowStatus ws = WWindowStatus.get(request);
    	int m_AD_Tab_ID = ws.getCurTab().getAD_Tab_ID();
    	int m_AD_Table_ID = ws.getCurTab().getAD_Table_ID();
    	String msg = "";
		
		log.fine("");
		//
		cmd_saveRow(request);	//	unsaved 
		Query m_query = getQueryAdvanced(request);
		if (m_query == null 
				|| m_query.getRestrictionCount() == 0)
			return msg;
		String where = m_query.getWhereClause();

		String name = WebUtil.getParameter(request, QUERY_NAME);
		if (name != null && name.length() == 0)
			name = null;
		
		Vector<AdvancedRow> advancedData = (Vector<AdvancedRow>)session.getAttribute(ADVANCED_DATA);
		if(advancedData == null){
			advancedData = new Vector<AdvancedRow>();
		}
		
		//	Update Existing Query
		MUserQuery uq = getSelectedQuery(request);
		if (uq != null)
		{
			if (name != null)
				uq.setName(name);
			uq.setCode (where);
			uq.setAD_Tab_ID	(m_AD_Tab_ID);
			uq.setAD_Table_ID (m_AD_Table_ID);
			//
			if (uq.save())
			{
				AdvancedRow.store(uq, advancedData);
				msg = AWebUtil.info(request, "Updated", uq.getName());
			}
			else
				msg = AWebUtil.info(request, "SaveError", uq.getName());
		}
		else if (name != null)
		{
			uq = new MUserQuery (wsc.ctx, 0, null);
			uq.setName(name);
			uq.setCode (where);
			uq.setAD_Tab_ID	(m_AD_Tab_ID);
			uq.setAD_Table_ID (m_AD_Table_ID);
			//
			if (uq.save())
			{
				AdvancedRow.store(uq, advancedData);
				msg = AWebUtil.info(request, "Saved", uq.getName());
			}
			else
				msg = AWebUtil.info(request, "SaveError", uq.getName());
		}
		
		return msg;
	}	//	cmd_save	
    
	/**
	 *	Get the number of records of target tab
	 *  @param query where clause for target tab
	 * 	@param alertZeroRecords show dialog if there are no records
	 *  @return number of selected records
	 */
	private int getNoOfRecords (HttpServletRequest request, Query query, boolean alertZeroRecords)
	{
		HttpSession session = request.getSession();
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	WWindowStatus ws = WWindowStatus.get(request);
    	String m_tableName = ws.getCurTab().getTableName();
    	int m_targetWindowNo = ws.getCurTab().getAD_Table_ID();
    	
		log.config(query == null ? "" : query.toString());
		StringBuffer sql = new StringBuffer("SELECT COUNT(*) FROM ");
		sql.append(m_tableName);
		boolean hasWhere = false;
		String m_whereExtended = "";//TODO
		if (m_whereExtended != null && m_whereExtended.length() > 0)
		{
			sql.append(" WHERE ").append(m_whereExtended);
			hasWhere = true;
		}
		if (query != null && query.isActive())
		{
			if (hasWhere)
				sql.append(" AND ");
			else
				sql.append(" WHERE ");
			sql.append(query.getWhereClause());
		}
		//	Add Access
		String finalSQL = MRole.getDefault(wsc.ctx,false).addAccessSQL(sql.toString(), 
			m_tableName, MRole.SQL_NOTQUALIFIED, MRole.SQL_RO);
		finalSQL = Env.parseContext(wsc.ctx, m_targetWindowNo, finalSQL, false);
		wsc.ctx.setContext(m_targetWindowNo, TABNO, "FindSQL", finalSQL);

		//  Execute Qusery
		int m_total = 999999;
		try
		{
			Statement stmt = DB.createStatement();
			ResultSet rs = stmt.executeQuery(finalSQL);
			if (rs.next())
				m_total = rs.getInt(1);
			rs.close();
			stmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, finalSQL, e);
		}
		return m_total;
	}	//	getNoOfRecords	
	
	private option[] getOptions(GridField mField, Lookup lookup, String dataValue) {
		int m_displayType = mField.getDisplayType();
		
		if (lookup == null)
			return new option[0];
		//
		Object[] list = lookup.getData(false, true, false, false).toArray(); 
		
		int size = list.length;
		if (size <= 0) {
			// Force load for display
			list = lookup.getData(false, true, true, true).toArray();
			size = list.length;
		}
		option[] options = new option[size];
		for (int i = 0; i < size; i++) {
			boolean isNumber = list[0] instanceof KeyNamePair;
			String key = null;
			// if (m_displayType == DisplayType.Locator)
			// 修正理由：　前はObject型でしたが、3.0でNamePairに変わりました。MLocatorLookup.getData参考。
			if (m_displayType == DisplayType.Locator && !isNumber)
			{
				MLocator loc = (MLocator) list[i];
				key = String.valueOf(loc.getM_Locator_ID());
				String name = AmpiereUtil.maskHTML(loc.getValue());
				options[i] = new option(key).addElement(name);
			} else if (isNumber) {
				KeyNamePair p = (KeyNamePair) list[i];
				key = String.valueOf(p.getKey());
				String name = AmpiereUtil.maskHTML(p.getName());
				options[i] = new option(key).addElement(name);
			} else {
				ValueNamePair p = (ValueNamePair) list[i];
				key = p.getValue();
				if (key == null || key.length() == 0)
					key = "";
				String name = p.getName();
				if (name == null || name.length() == 0)
					name = " ";
				name = AmpiereUtil.maskHTML(name);
				options[i] = new option(key).addElement(name);
			}
			if (dataValue.equals(key))
				options[i].setSelected(true);
		}
		return options;
	} // getOptions	
	
	/**
	 * Fill m_Values with Ref_List values
	 * 
	 * @param AD_Reference_ID
	 *            reference
	 */
	private String readReferenceName(HttpServletRequest request, int AD_Reference_ID, String value) {
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	WWindowStatus ws = WWindowStatus.get(request);
		String name = value;
		String SQL;
		if (Env.isBaseLanguage(wsc.ctx, "AD_Ref_List"))
			SQL = "SELECT Name FROM AD_Ref_List WHERE AD_Reference_ID=? AND VALUE=?";
		else
			SQL = "SELECT t.Name FROM AD_Ref_List l, AD_Ref_List_Trl t " + "WHERE l.AD_Ref_List_ID=t.AD_Ref_List_ID"
					+ " AND t.AD_Language='" + Env.getAD_Language(wsc.ctx) + "'" + " AND l.AD_Reference_ID=?"
					+ " AND l.VALUE=?";
		try {
			PreparedStatement pstmt = DB.prepareStatement(SQL, null);
			pstmt.setInt(1, AD_Reference_ID);
			pstmt.setString(2, value);
			ResultSet rs = pstmt.executeQuery();
			if (rs.next()) {
				name = rs.getString(1);
			}
			rs.close();
			pstmt.close();
		} catch (SQLException e) {
		}

		return name;
	} // readReference	
	
    Document getDoc(HttpServletRequest request){
		HttpSession session = request.getSession();
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	WWindowStatus ws = WWindowStatus.get(request);
    	
		Document document = null;

		try{
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			//ビルダーからDOMを取得する
			document = builder.newDocument();

			org.w3c.dom.Element elements = document.createElement(Constants.ELEMENTS);
			document.appendChild(elements);


		}catch(Exception e){
			;
		}
		
		return document;
    }
}   //  WFind
