/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.web.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.util.JRLoader;

import org.compiere.framework.Query;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Language;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

import com.ampiere.util.JasperUtils;

/**
 *  Web WJasperReport Document Page.
 *  
 *  @author Siqin
 *  @version  $Id: WJasperReport.java,v 1.4 2010/03/24 11:21:27 siqin Exp $
 */
public class WJasperReport extends HttpServlet {

    /** Serial Version UID. */
	private static final long serialVersionUID = -4091247707448190302L;

	/**	Logger. */
    private CLogger log = CLogger.getCLogger(getClass());

    /**
	 *	Initialize.
	 *  @param config confif
	 *  @throws ServletException ServletException
	 */
	public final void init(final ServletConfig config) throws ServletException {
		super.init(config);
		if (!WebEnv.initWeb(config)) {
			throw new ServletException("WJasperReport.init");
        }
	}	//	init

	/**
	 * Get Servlet information.
	 * @return servlet info
	 */
	public final String getServletInfo() {
		return "Ampiere Web WJasperReport Window";
	}

	/**
	 *	Clean up.
	 */
	public final void destroy() {
		log.info("destroy");
		super.destroy();
	}

	/**
	 *	Process the HTTP Get request - forward to Post.
	 *  @param request request
	 *  @param response response
	 *  @throws ServletException ServletException
	 *  @throws IOException IOException
	 */
	public final void doGet(final HttpServletRequest request, final HttpServletResponse response)
    throws ServletException, IOException {
		log.info("doGet");

		Language oldLogin = Language.getLoginLanguage();
		
		WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }

        String sessionId = request.getSession().getId();

        WWindowStatus ws = WWindowStatus.get(request);

		Language.setLoginLanguage(wsc.language);

        int printFormatID = new Integer(request.getParameter("PrintFormat"));
		String fileName = JasperUtils.toJasperXML(printFormatID,sessionId,ws.ctx);
		if ( fileName != null ) {
			HashMap<String,Object> param = new HashMap<String,Object>();
	        int pInstanceId = WebUtil.getParameterAsInt(request, "AD_PInstance_ID");
	        if ( pInstanceId > 0 ) {
				MPInstance inst = new MPInstance( ws.ctx, pInstanceId, null );
				MPInstancePara[] params = inst.getParameters();
				for (int i = 0; i < params.length; i++) {
					if ( "AD_Jasperformat_ID".equals( params[i].getParameterName() )  ) {
						if ( params[i].getP_Number() != null ) {
							params[i].delete(true);
						}
					}
				}
				Query query = Query.get ( ws.ctx, pInstanceId, "");
	        	param.put( "PARAM", query.toString() );
	        } else {
	        	param.put( "RECORD_ID", ws.curTab.getRecord_ID() );
	        }
			param.put( "SUBREPORT_DIR", JasperUtils.JASPERREPORT_PATH + "/" + sessionId );
			try {
		    	JasperReport jasperReport = (JasperReport)JRLoader.loadObject ( fileName );
		    	JasperPrint JasperPrint = JasperFillManager.fillReport(jasperReport, param, DB.getConnectionRO() );
		        makeDownloadFile(JasperPrint, request, response, wsc.language);
			} catch (Exception e) {
				log.log(Level.SEVERE, "RecordId="+ws.curTab.getRecord_ID() , e);
			}
		}
		Language.setLoginLanguage(oldLogin);

	}

	/**
	 *	Process the HTTP Post request.
	 *
	 *  @param request request
	 *  @param response response
	 *  @throws ServletException ServletException
	 *  @throws IOException IOException
	 */
	public final void doPost(final HttpServletRequest request, final HttpServletResponse response) 
	throws ServletException, IOException {
		log.info("doPost");
	}

    /**
     * Make download file.
     * @param reportEngine report engine
     * @param request request
     * @param response response
     * @param language language
     * @return result
     */
    private boolean makeDownloadFile(
            final JasperPrint jasperPrint,
            final HttpServletRequest request,
            final HttpServletResponse response,
            final Language language) {

        boolean result = true;

        try {
            ServletOutputStream ouputStream = response.getOutputStream();
            if (request.getParameter("FileFormat").equals("pdf")) {
                response.setContentType("application/pdf");
                response.setHeader("Content-Disposition", "inline; filename=" + request.getParameter("PrintFormatName") + ".pdf");
                response.setHeader("Content-Description", "File download for PDF.");
                JRPdfExporter exporter = new JRPdfExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, ouputStream );
                exporter.exportReport();
            } else if (request.getParameter("FileFormat").equals("html")) {
                response.setContentType("text/html; charset=UTF-8");
                response.setHeader("Content-Disposition", "inline; filename=" + request.getParameter("PrintFormatName") + ".html");
                response.setHeader("Content-Description", "File download for HTML.");
            	JRHtmlExporter exporter = new JRHtmlExporter();
            	exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
            	exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, ouputStream );
            	exporter.exportReport();
            } else if (request.getParameter("FileFormat").equals("xls")) {
                response.setContentType("application/vnd.ms-excel");
                response.setHeader("Content-Disposition", "inline; filename=" + request.getParameter("PrintFormatName") + ".xls");
                response.setHeader("Content-Description", "File download for HTML.");
                JRXlsExporter exporter = new JRXlsExporter();
            	exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
            	exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, ouputStream );
            	exporter.exportReport();
            } else {
                result = false;
            }
            ouputStream.flush();
            ouputStream.close();
        } catch (Exception e) {
            log.log(Level.SEVERE, "ReportEngine", e);
            result = false;
        }

        return result;
    }
}
