/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.web.servlet;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.ecs.AlignType;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.area;
import org.apache.ecs.xhtml.b;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.br;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.map;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.span;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.framework.Query;
import org.compiere.framework.ZoomTarget;
import org.compiere.model.MAchievement;
import org.compiere.model.MGoal;
import org.compiere.model.MMeasureCalc;
import org.compiere.model.MProjectType;
import org.compiere.model.MRequestType;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

import com.ampiere.util.BarGraph;
import com.ampiere.util.BarGraphColumn;
import com.ampiere.util.GraphUtil;

/**
 * Web Window Servlet
 * 
 * @author SiqinBilige
 * @version $Id: WPerformanceBar.java,v 1.5 2010/06/15 07:01:45 jrmt Exp $
 */
public class WPerformanceBar extends HttpServlet {

	/** serialVersionUID */
	private static final long serialVersionUID = -8472078781140462598L;

	/** Logger */
	protected static CLogger log = CLogger.getCLogger(WPerformanceBar.class);

	/**
	 * Initialize global variables
	 * 
	 * @param config
	 * @throws ServletException
	 */
	public void init(ServletConfig config) throws ServletException {
		super.init(config);
		if (!WebEnv.initWeb(config))
			throw new ServletException("WPerformanceBar.init");
	} // init

	/**
	 * Get Servlet information
	 * 
	 * @return info
	 */
	public String getServletInfo() {
		return "Compiere Web Window";
	} // getServletInfo

	/**
	 * Clean up resources
	 */
	public void destroy() {
		log.fine("destroy");
	} // destroy

	/**
	 * Perfomancee HTTP Get request - Initial Call.
	 * 
	 * @param request
	 * @param response
	 * @throws ServletException
	 * @throws IOException
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {

		log.info(this.getClass().getName() + ".doGet");

		// Get Session attributes
		WebSessionCtx wsc = WebSessionCtx.get(request);
		if (wsc == null) {
			WebUtil.createTimeoutPage(request, response, this, null);
			return;
		}

		int goalId = WebUtil.getParameterAsInt(request, WPerformanceImage.GOAL_ID_NAME );
		MGoal[] goals = MGoal.getUserGoals(wsc.ctx, wsc.ctx.getAD_Role_ID(), wsc.ctx.getAD_User_ID());
		for (int i = 0; i < goals.length; i++) {
			if ( goalId == goals[i].get_ID() ) {
				WebDoc doc = WebDoc.createWindow(goals[i].getName(), request);
				doc.getTable().addElement(new tr().addElement( new td(null, AlignType.LEFT, AlignType.TOP,true, WWindow.createMenuDiv(wsc,null))));
				doc.getHead().addElement(new script( WWindow.makeMenuItemScript( wsc,null ) ));
				doc.getBody().setOnLoad( "displayMenu();" );
				body bdy = doc.getBody();
				bdy.addElement( "<br>" );
				img performance = new img(WebEnv.DIR_BASE + "/WPerformanceImage?"
						+ WPerformanceImage.IMAGE_TYPE_NAME + "=" + WPerformanceImage.IMAGE_TYPE_BAR + "&"
						+ WPerformanceImage.GOAL_ID_NAME + "=" + goals[i].get_ID());
				performance.setUseMap( "#map" + goals[i].get_ID() );
				bdy.addElement(performance);
				map goalMap = new map();
				goalMap.setName( "map" + goals[i].get_ID() );
				
		        Dimension size = new Dimension( 600,400 );
		        BarGraph barGraph = new BarGraph( goals[i] );
				Font font = barGraph.getFont();
				FontMetrics fm = barGraph.getFontMetrics(font);
				int fontHeight = fm.getHeight();
				//
				int yAxis_X = fontHeight+10;				//	|
				int xAxis_Y = size.height-fontHeight-10;	//	-
				Point point0_0 = new Point(yAxis_X, xAxis_Y);

				//	Find Max
				double maxValue = 0;
		        Component[] data = barGraph.getComponents();
				for (int j = 0; j < data.length; j++) {
					BarGraphColumn column = (BarGraphColumn)data[j];
					maxValue = Math.max(maxValue, column.getValue());
				}

				double graphHeight = size.height - (size.height-point0_0.y) - (2*WPerformanceImage.YGAP);
				double graphWidth = size.width - point0_0.x - WPerformanceImage.XGAP;
				double columnWidth = (graphWidth - (WPerformanceImage.XGAP*data.length)) / data.length;
				columnWidth = Math.min(30, columnWidth);
				columnWidth = Math.max(fontHeight, columnWidth);

				int x = point0_0.x + (2*WPerformanceImage.XGAP);
				//	Set Values
				for (int j = 0; j < data.length; j++) {
					BarGraphColumn column = (BarGraphColumn)data[j];
					double multiplier = column.getValue() / maxValue;
					double height = graphHeight * multiplier;
					column.setColHeight(height);
					column.setColWidth(columnWidth);
					Dimension ps = column.getPreferredSize();
					column.setBackground(GraphUtil.getBackground(j));
					//
					int y = point0_0.y - ps.height - WPerformanceImage.YGAP;
					column.setLocation(x, y);
					column.setBounds(x, y, ps.width, ps.height);

					BarGraphColumn bgc = column;
					Query query = null;
					if (bgc.getAchievement() != null)	//	Single Achievement
					{
						MAchievement a = bgc.getAchievement();
						query = Query.getEqualQuery("PA_Measure_ID", a.getPA_Measure_ID());
					}
					else if (bgc.getGoal() != null)		//	Multiple Achievements 
					{
						MGoal goal = bgc.getGoal();
						query = Query.getEqualQuery("PA_Measure_ID", goal.getPA_Measure_ID());
					}
					else if (bgc.getMeasureCalc() != null)	//	Document
					{
						MMeasureCalc mc = bgc.getMeasureCalc();
						query = mc.getQuery(goals[i].getRestrictions(false), 
							bgc.getMeasureDisplay(), bgc.getDate(), 
							MRole.getDefault(wsc.ctx,false));	//	logged in role
					}
					else if (bgc.getProjectType() != null)	//	Document
					{
						MProjectType pt = bgc.getProjectType();
						query = pt.getQuery(goals[i].getRestrictions(false), 
							bgc.getMeasureDisplay(), bgc.getDate(), bgc.getID(), 
							MRole.getDefault(wsc.ctx,false));	//	logged in role
					}
					else if (bgc.getRequestType() != null)	//	Document
					{
						MRequestType rt = bgc.getRequestType();
						query = rt.getQuery(goals[i].getRestrictions(false), 
							bgc.getMeasureDisplay(), bgc.getDate(), bgc.getID(),
							MRole.getDefault(wsc.ctx,false));	//	logged in role
					}

					String TableName = query.getTableName();
					int AD_Window_ID = 0;
					int PO_Window_ID = 0;
					String sql = "SELECT AD_Window_ID, PO_Window_ID FROM AD_Table WHERE TableName=?";
					try {
						PreparedStatement pstmt = DB.prepareStatement(sql, null);
						pstmt.setString(1, TableName);
						ResultSet rs = pstmt.executeQuery();
						if (rs.next()) {
							AD_Window_ID = rs.getInt(1);
							PO_Window_ID = rs.getInt(2);
						}
						rs.close();
						pstmt.close();
					} catch (SQLException e) {
						log.log(Level.SEVERE, sql, e);
					}

					//	PO Zoom ?
					boolean isSOTrx = true;
					if (PO_Window_ID != 0) {
						AD_Window_ID=ZoomTarget.getZoomAD_Window_ID(TableName, 0, query.getWhereClause(), isSOTrx);
					}

					Rectangle bounds = column.getBounds();
					String bound = bounds.x + "," + bounds.y + "," + (bounds.x + bounds.width) + "," + (bounds.y + bounds.height );
					String url = WebEnv.DIR_BASE + "/WWindow" +
							"?AD_Window_ID=" + AD_Window_ID +
							"&" + WPerformanceImage.GOAL_ID_NAME + "=" + goals[i].get_ID() +
							"&" + WPerformanceImage.GOAL_COLUMN_INDEX_NAME + "=" + j ;
			        area columnArea = new area( "rect", bound, url );
			        columnArea.setAlt( column.getName() );
			        columnArea.setTitle( column.getName() );
			        goalMap.addElement( columnArea );
					x += ps.width + WPerformanceImage.XGAP;
				}
				data = null;
				barGraph = null;
				
				bdy.addElement(goalMap);

				bdy.addElement(new br("both"));
				bdy.addElement(new br("both"));
				bdy.addElement(new span( "&nbsp;&nbsp;&nbsp;&nbsp;" ));
				a aPerformance = new a().setHref("WPerformanceMeter");
				aPerformance.addElement(new b(new span( Msg.translate( wsc.ctx, "Performance") )));
				bdy.addElement(aPerformance);

				WebUtil.createResponse(request, response, this, null, doc, false);
			}
		}

		log.fine("Fini");
	} // doGet

	/**************************************************************************
	 * Process the HTTP Post request
	 * 
	 * @param request
	 *            request
	 * @param response
	 *            response
	 * @throws ServletException
	 * @throws IOException
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		log.fine("doPost");
	} // doPost

} // WPerformanceBar

