/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.web.servlet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.compiere.model.MGoal;
import org.compiere.util.CLogger;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

import com.ampiere.util.BarGraph;
import com.ampiere.util.BarGraphColumn;
import com.ampiere.util.GraphUtil;
import com.ampiere.util.PerformanceIndicator;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;


/**
 *  Web Window Servlet
 *
 *  @author SiqinBilige
 *  @version  $Id: WPerformanceImage.java,v 1.2 2010/06/15 07:01:45 jrmt Exp $
 */
public class WPerformanceImage extends HttpServlet {

	/** serialVersionUID */
	private static final long serialVersionUID = 7084180807338904934L;

	/**	Logger			*/
	protected static CLogger	log = CLogger.getCLogger(WPerformanceImage.class);

	public static final String IMAGE_TYPE_NAME = "IMAGE_TYPE_NAME";
	public static final String IMAGE_TYPE_METER = "IMAGE_TYPE_METER";
	public static final String IMAGE_TYPE_BAR = "IMAGE_TYPE_BAR";

	public static final String GOAL_ID_NAME = "GOAL_ID";
	public static final String GOAL_COLUMN_INDEX_NAME = "GOAL_COLUMN_INDEX";
	/** Gap between columns		*/
	public static final int			XGAP = 2;
	/** Gap to Axix				*/
	public static final int			YGAP = 1;

    private static final AffineTransform s_affineTransform = new AffineTransform(); 


    /**
	 *  Initialize global variables
	 *  @param config
	 *  @throws ServletException
	 */
	public void init(ServletConfig config) throws ServletException
	{
		super.init (config);
		if (!WebEnv.initWeb(config))
			throw new ServletException("WPerformanceImage.init");
	}   //  init

	/**
	 * Get Servlet information
	 * @return info
	 */
	public String getServletInfo()
	{
		return "Compiere Web Window";
	}	//	getServletInfo

	/**
	 * Clean up resources
	 */
	public void destroy()
	{
		log.fine("destroy");
	}   //  destroy

	/**
	 *  Perfomancee HTTP Get request - Initial Call.
	 *  @param request
	 *  @param response
	 *  @throws ServletException
	 *  @throws IOException
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException {

		log.info( this.getClass().getName() + ".doGet" );

		//  Get Session attributes
		WebSessionCtx wsc = WebSessionCtx.get(request);
		if (wsc == null) {
			WebUtil.createTimeoutPage(request, response, this, null);
			return;
		}

		String imageType = WebUtil.getParameter(request, IMAGE_TYPE_NAME );
		if ( imageType == null ) {
			return;
		}
		int goalId = WebUtil.getParameterAsInt(request, GOAL_ID_NAME );
		MGoal[] goals = MGoal.getUserGoals(wsc.ctx, wsc.ctx.getAD_Role_ID(), wsc.ctx.getAD_User_ID());
		for (int i = 0; i < goals.length; i++) {
			if ( goalId == goals[i].get_ID() ) {

				BufferedImage image = null;
				if ( IMAGE_TYPE_METER.equals( imageType ) ) {
					PerformanceIndicator pi = new PerformanceIndicator(goals[i]);
					pi.setOpaque(false);
					pi.setSize(360, 180);
			        Dimension size = pi.getSize();
			        image = new BufferedImage(size.width, size.height, BufferedImage.TYPE_INT_RGB);
			        Graphics2D g2 = image.createGraphics();
			        g2.setBackground( Color.WHITE );
			        g2.clearRect(0, 0, size.width,size.height);
			        pi.paint(g2);
				} else if ( IMAGE_TYPE_BAR.equals( imageType ) ) {
			        Dimension size = new Dimension( 600,400 );
			        image = new BufferedImage(size.width, size.height, BufferedImage.TYPE_INT_RGB);
			        Graphics2D g2 = image.createGraphics();
			        g2.setBackground( Color.WHITE );
			        g2.clearRect(0, 0, size.width,size.height);
			        // pi.paint(g2);

			        BarGraph barGraph = new BarGraph( goals[i] );
					Font font = barGraph.getFont();
					FontMetrics fm = g2.getFontMetrics(font);
					int fontHeight = fm.getHeight();
					//
					int yAxis_X = fontHeight+10;				//	|
					int xAxis_Y = size.height-fontHeight-10;	//	-
					Point point0_0 = new Point(yAxis_X, xAxis_Y);
					
					//	Paint X axis
					g2.setColor(Color.black);
					g2.drawLine(yAxis_X, xAxis_Y, size.width-5, xAxis_Y);
					g2.setFont(font);
					g2.drawString(goals[i].getXAxisText(), yAxis_X, xAxis_Y+fontHeight);
					
					//	Paint Y axis
					g2.drawLine(yAxis_X, 5, yAxis_X, xAxis_Y);
					AffineTransform transform = AffineTransform.getRotateInstance(Math.PI*3/2);
					font = font.deriveFont(transform);
					g2.setFont(font);
					g2.drawString(goals[i].getName(), yAxis_X-fontHeight+10, xAxis_Y);

			        Component[] data = barGraph.getComponents();

					//	Find Max
					double maxValue = 0;
					for (int j = 0; j < data.length; j++)
					{
						BarGraphColumn column = (BarGraphColumn)data[j];
						maxValue = Math.max(maxValue, column.getValue());
					}

					double graphHeight = size.height - (size.height-point0_0.y) - (2*YGAP);
					double graphWidth = size.width - point0_0.x - XGAP;
					double columnWidth = (graphWidth - (XGAP*data.length)) / data.length;
					columnWidth = Math.min(30, columnWidth);
					columnWidth = Math.max(fontHeight, columnWidth);

					log.fine("Height=" + graphHeight + ", MaxValue=" + maxValue 
						+ ", Width=" + graphWidth + ", ColumnWidth=" + columnWidth);
					
					int x = point0_0.x + (2*XGAP);
					//	Set Values
					for (int j = 0; j < data.length; j++)
					{
						BarGraphColumn column = (BarGraphColumn)data[j];
						double multiplier = column.getValue() / maxValue;
						double height = graphHeight * multiplier;
						column.setColHeight(height);
						column.setColWidth(columnWidth);
						Dimension ps = column.getPreferredSize();
						column.setBackground(GraphUtil.getBackground(j));
						//
						int y = point0_0.y - ps.height - YGAP;
						column.setLocation(x, y);
						column.setBounds(x, y, ps.width, ps.height);

				        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);

				        Rectangle bounds = column.getBounds();
				        // draw boxes for 3d effect
				        g2.setColor(column.getBackground());
				        g2.fill3DRect(bounds.x, bounds.y, bounds.width, bounds.height, true);

						//	Paint Label & Value
						g2.setPaint(column.getForeground());
						//
						s_affineTransform.setToRotation(Math.PI*3/2);
						font = font.deriveFont(s_affineTransform);
						g2.setFont(font);
						//
						int x1 = bounds.x + (fontHeight - 2)/2;
						if (x1 < fontHeight)
							x1 = fontHeight - 2 ;
						int y1 = size.height - yAxis_X ;
						g2.drawString(column.getName(), x1+10, y1-5);

						x += ps.width + XGAP;
						log.finer(i + " - " + ((int)(multiplier*100)) + "% - " + column.getBounds());
					}
				}

		        ByteArrayOutputStream os = new ByteArrayOutputStream();
		        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder(os);
		        JPEGEncodeParam params = encoder.getDefaultJPEGEncodeParam(image);
		        params.setQuality(1.0f, false);
		        encoder.encode(image, params);

		        byte [] imageData = os.toByteArray();			

				response.setContentType("image/jpg");
				response.addHeader("Content-Disposition", "inline; filename=" + goals[i].get_ID() + ".jpg");
				OutputStream out = null;
				try {
					out = response.getOutputStream();
					for (int j = 0; j < imageData.length; j++) {
						out.write(imageData[j]);
					}
				} finally {
					if (out != null) {
						out.flush();
						out.close();
					}
				}
				imageData = null;
				image = null;
				break;

			}
		}

		log.fine("Fini");
	}   //  doGet

	/**************************************************************************
	 *  Process the HTTP Post request
	 *
	 *  @param request request
	 *  @param response response
	 *  @throws ServletException
	 *  @throws IOException
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException {
		log.fine("doPost");
	}   //  doPost

}   //  WPerformanceImage

