/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.web.servlet;

import java.io.IOException;
import java.text.DecimalFormat;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.ecs.AlignType;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.br;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.MGoal;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

/**
 * Web Window Servlet
 * 
 * @author SiqinBilige
 * @version $Id: WPerformanceMeter.java,v 1.5 2010/06/15 07:01:45 jrmt Exp $
 */
public class WPerformanceMeter extends HttpServlet {

	/** serialVersionUID */
	private static final long serialVersionUID = -8472078781140462598L;

	/** Logger */
	protected static CLogger log = CLogger.getCLogger(WPerformanceMeter.class);

	/**
	 * Initialize global variables
	 * 
	 * @param config
	 * @throws ServletException
	 */
	public void init(ServletConfig config) throws ServletException {
		super.init(config);
		if (!WebEnv.initWeb(config))
			throw new ServletException("WPerformanceImage.init");
	} // init

	/**
	 * Get Servlet information
	 * 
	 * @return info
	 */
	public String getServletInfo() {
		return "Compiere Web Window";
	} // getServletInfo

	/**
	 * Clean up resources
	 */
	public void destroy() {
		log.fine("destroy");
	} // destroy

	/**
	 * Perfomancee HTTP Get request - Initial Call.
	 * 
	 * @param request
	 * @param response
	 * @throws ServletException
	 * @throws IOException
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {

		log.info(this.getClass().getName() + ".doGet");

		// Get Session attributes
		WebSessionCtx wsc = WebSessionCtx.get(request);
		if (wsc == null) {
			WebUtil.createTimeoutPage(request, response, this, null);
			return;
		}

		String windowTitle = Msg.translate(wsc.ctx, "Performance");

		WebDoc doc = WebDoc.createWindow(windowTitle, request);
		doc.getTable().addElement(new tr().addElement( new td(null, AlignType.LEFT, AlignType.TOP,true, WWindow.createMenuDiv(wsc,null))));
		doc.getHead().addElement(new script( WWindow.makeMenuItemScript( wsc,null ) ));
		doc.getBody().setOnLoad( "displayMenu();" );
		body bdy = doc.getBody();
		bdy.addElement( "<br>" );
		MGoal[] goals = MGoal.getUserGoals(wsc.ctx, wsc.ctx.getAD_Role_ID(), wsc.ctx.getAD_User_ID());
		for (int i = 0; i < goals.length; i++) {
			img performance = new img(WebEnv.DIR_BASE + "/WPerformanceImage?"
					+ WPerformanceImage.IMAGE_TYPE_NAME + "=" + WPerformanceImage.IMAGE_TYPE_METER + "&"
					+ WPerformanceImage.GOAL_ID_NAME + "=" + goals[i].get_ID());
			performance.setBorder(0);

			DecimalFormat s_format = DisplayType.getNumberFormat(DisplayType.Integer);
			StringBuilder text = new StringBuilder();
			if (goals[i].getDescription() != null) {
				text.append(goals[i].getDescription());
			} else {
				text.append(goals[i].getName());
			}
			text.append(": ");
			text.append(s_format.format(goals[i].getMeasureActual()));
			if (goals[i].isTarget()) {
				text.append(" / ").append(
						s_format.format(goals[i].getMeasureTarget()));
			}
			performance.setTitle(text.toString());
			performance.setOnClick("top.frames['WWindow'].location.href='" + WebEnv.DIR_BASE +  "/WPerformanceBar?" + WPerformanceImage.GOAL_ID_NAME + "=" + goals[i].get_ID() + "';");
			bdy.addElement(performance);
			if ( i > 0 && ( (i+1)%2 == 0 ) ) {
				bdy.addElement( new br( "both" ) );
			}
		}

		log.fine("Fini");
		WebUtil.createResponse(request, response, this, null, doc, false);
	} // doGet

	/**************************************************************************
	 * Process the HTTP Post request
	 * 
	 * @param request
	 *            request
	 * @param response
	 *            response
	 * @throws ServletException
	 * @throws IOException
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		log.fine("doPost");
	} // doPost

} // WPerformanceMeter

