/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.web.servlet;

import java.io.IOException;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.GridField;
import org.compiere.model.MPreference;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

import com.ampiere.util.Constants;

/**
 *	HTML Find UI.
 *  @author Siqine
 *  @version  $Id: WPreference.java,v 1.3 2010/05/05 06:03:40 clmg Exp $
 */
public class WPreference extends HttpServlet {
    /**  */
	private static final long serialVersionUID = 6617424544044122702L;
	/**	Logger. */
    private CLogger log = CLogger.getCLogger(getClass());
    
	/** The Name of the Editor      */
	public static final String      NAME = "ValuePreference";

	/**
	 * Initialize global variables.
     * @param config config
     * @throws ServletException ServletException
	 */
	public final void init(final ServletConfig config)
		throws ServletException	{
		super.init(config);
		if (!WebEnv.initWeb(config)) {
			throw new ServletException("WProcess.init");
        }
	}   //  init

	/**
	 * Process the HTTP Get request Initial Call.
     * @param request request
     * @param response response
     * @throws ServletException ServletException
     * @throws IOException IOException
	 */
	public final void doGet(final HttpServletRequest request, final HttpServletResponse response)
		throws ServletException, IOException {

        //  Get Session attributes
	  	WebSessionCtx wsc = WebSessionCtx.get(request);
		if (wsc == null) {
			WebUtil.createTimeoutPage(request, response, this, null);
			return;
		}
		
		WebDoc doc = createPreferencePage(request);

		if (doc == null) {
			doc = WebDoc.createWindow("Error");
		}

		// Add body onUnload event, close all popup window when unload 
		doc.getBody().setOnUnload("closeMyChildren();");

		//
		WebUtil.createResponse(request, response, this, null, doc, false);
	}   //  doGet


	/**
	 * Process the HTTP Post request. Get Parameters and Process.
     * @param request request
     * @param response response
     * @throws ServletException ServletException
     * @throws IOException IOException
	 */
	public final void doPost(final HttpServletRequest request, final HttpServletResponse response)
		throws ServletException, IOException {

        //  Get Session attributes
	  	WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);
		if (wsc == null) {
			WebUtil.createTimeoutPage(request, response, this, null);
			return;
		}

		WebDoc doc = WebDoc.createWindow(Msg.getMsg(ws.ctx, NAME));
		
		td msg = doc.addWindowCenter(false);
		//	Info
		p p = new p();
		
		
		String actionType = WebUtil.getParameter(request, "btn_submit")!=null?"submitAction":"deleteAction";
		if("submitAction".equals(actionType)){
			boolean result = save(request);
			p.addElement(Msg.translate(ws.ctx, "ValuePreferenceInserted"));
		}else{
			boolean result = delete(request);
			p.addElement(Msg.translate(ws.ctx, "ValuePreferenceDeleted"));
		}
		
		msg.addElement(p);
		
		td botton = doc.addWindowCenter(true);
		input ok = new input(input.TYPE_IMAGE, "btn_ok", "OK");
		ok.setSrc(WebEnv.getImageDirectory("Ok32.png"));
		ok.setID("btn_ok");
		ok.setOnClick("window.close();return false;");
		botton.addElement(ok);

		WebUtil.createResponse(request, response, this, null, doc, false);
	}   //  doPost

	/**
	 * 	Create Find Page.
	 *	@param request request
	 *	@return Page
	 */
	private WebDoc createPreferencePage(final HttpServletRequest request) {
	  	WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);
		
		String aValue = WebUtil.getParameter(request, "aValue"); //input
		String aDisplayValue = WebUtil.getParameter(request, "aDisplayValue"); //input
		String columnName = WebUtil.getParameter(request, "columnName"); //input
		GridField currentField = ws.curTab.getField(columnName);

		
		
		if (!ws.curTab.getField(columnName).isEditable(false))
		{
			log.info("Field not editable (R/O)");
			return null;
		}
		
		//  Set Value/DisplayValue
		String Value = null;
		String DisplayValue = null;

		//  Get from mField
		//  AD_Window_ID, DisplayAttribute, Attribute, DisplayType, AD_Referenece_ID
		int AD_Window_ID = currentField.getAD_Window_ID();
		String Attribute = currentField.getColumnName();
		String DisplayAttribute = currentField.getHeader();
		int displayType = currentField.getDisplayType();
		int AD_Reference_ID = 0;
		int WindowNo = currentField.getWindowNo();
		
		if ("Value".equals(Attribute) || "DocumentNo".equals(Attribute))
		{
			log.info("No Preference for: " + Attribute);
			return null;
		}

		//  Get from Environment (WindowNo)
		//  AD_Client_ID, AD_Org_ID, AD_User_ID, Frame
		int AD_Client_ID = ws.ctx.getAD_Client_ID();
		int AD_Org_ID =  ws.ctx.getContextAsInt( WindowNo, "AD_Org_ID");
		int AD_User_ID =  ws.ctx.getAD_User_ID();

		//  Create Editor
//		ValuePreference vp = new ValuePreference (frame, WindowNo,
//			AD_Client_ID, AD_Org_ID, AD_User_ID, AD_Window_ID,
//			Attribute, DisplayAttribute, Value, DisplayValue,
//			displayType, AD_Reference_ID);
		
//		cbClient.setEnabled(false);
//		cbClient.setSelected(true);

		WebDoc doc = WebDoc.createWindow(Msg.getMsg(ws.ctx, NAME) + " " + DisplayAttribute);
		
		form myForm = new form(request.getRequestURI());
		myForm.setID("WFind");
		table myTable = new table();
		myTable.setAlign("CENTER");
		div divBody = (div)new div().setID("body"); //clmg 2009/02/24
		divBody.addElement(myTable);//clmg 2009/02/24
		
		
		tr myTr = new tr(new td(WebDoc.NBSP).setColSpan(3));
		myTable.addElement(myTr);
		myTr.addElement(new td().addElement(Msg.translate(ws.ctx, "Attribute")));
		myTr.addElement(new td().addElement(DisplayAttribute));
		input hiddenAttribute = new input(input.TYPE_HIDDEN, "Attribute", Attribute);
		hiddenAttribute.setID("Attribute");
		myTr.addElement(new td().addElement(Attribute).addElement(hiddenAttribute));

		
		myTr = new tr(new td(WebDoc.NBSP).setColSpan(3));
		myTable.addElement(myTr);
		myTr.addElement(new td().addElement(Msg.translate(ws.ctx, "Value")));
		myTr.addElement(new td().addElement(aDisplayValue));
		input hiddenAValue = new input(input.TYPE_HIDDEN, "aValue", aValue);
		hiddenAValue.setID("aValue");
		myTr.addElement(new td().addElement(aValue).addElement(hiddenAValue));
		
		
		
		//client 
		myTr = new tr(new td(WebDoc.NBSP).setColSpan(3));
		myTable.addElement(myTr);
		myTr.addElement(new td().addElement(Msg.getMsg(ws.ctx, "ValuePreferenceSetFor")));
		td checkboxTd = new td();
		input cbClient = new input(input.TYPE_CHECKBOX, "cbrClient", "");
		cbClient.setID("cbClient");
		cbClient.setChecked(true);
		cbClient.setDisabled(true);
		label clientLabel = new label("cbrClient", null, Msg.translate(Env.getAD_Language(ws.ctx), ws.ctx.isSOTrx(), "AD_Client_ID"));
		clientLabel.setID("cbrClient" + "L");
		cbClient.addElement(clientLabel);
		checkboxTd.addElement(cbClient);
		
		//組織
		input cbOrg = new input(input.TYPE_CHECKBOX, "cbOrg", Constants.DISABLED);
		cbOrg.setID("cbOrg");
		label orgLabel = new label("cbOrg", null, Msg.translate(Env.getAD_Language(ws.ctx), ws.ctx.isSOTrx(), "AD_Org_ID"));
		orgLabel.setID("cbOrg" + "L");
		cbOrg.addElement(orgLabel);
		checkboxTd.addElement(cbOrg);
		
		if (MRole.PREFERENCETYPE_Client.equals(MRole.getDefault(wsc.ctx, true).getPreferenceType())){
		}
		else
		{
			cbOrg.setDisabled(true);
			cbOrg.setChecked(true);
		}
		
		
		//ユーザー連絡先
		input cbUser = new input(input.TYPE_CHECKBOX, "cbUser", Constants.ENABLED);
		cbUser.setID("cbUser");
		cbUser.setChecked(true);
		label userLabel = new label("cbUser", null, Msg.translate(Env.getAD_Language(ws.ctx), ws.ctx.isSOTrx(), "AD_User_ID"));
		userLabel.setID("cbUser" + "L");
		cbUser.addElement(userLabel);
		checkboxTd.addElement(cbUser);
		//	Can Change User
		if (MRole.PREFERENCETYPE_Client.equals(MRole.getDefault(wsc.ctx, true).getPreferenceType())
			|| MRole.PREFERENCETYPE_Organization.equals(MRole.getDefault(wsc.ctx, true).getPreferenceType()))
		{
		}
		else
		{
			cbUser.setDisabled(true);
			cbUser.setChecked(true);
		}		
		
		//window
		input cbWindow = new input(input.TYPE_CHECKBOX, "cbWindow", Constants.ENABLED);
		cbWindow.setID("cbWindow");
		cbWindow.setChecked(true);
		label windowLabel = new label("cbWindow", null, Msg.translate(Env.getAD_Language(ws.ctx), ws.ctx.isSOTrx(), "AD_Window_ID"));
		windowLabel.setID("cbWindow" + "L");
		cbWindow.addElement(windowLabel);
		checkboxTd.addElement(cbWindow);
		//always can change window
		cbWindow.setDisabled(false);
		cbWindow.setChecked(true);
		
		myTr.addElement(checkboxTd);
		myTr.addElement(new td().addElement(""));
		
		//button
		myTr = new tr(new td(WebDoc.NBSP).setColSpan(3));
		myTable.addElement(myTr);
		input delete = new input(input.TYPE_IMAGE, "btn_delete", "OK");
		delete.setSrc(WebEnv.getImageDirectory("Delete32.png"));
		delete.setID("btn_delete");
		myTr.addElement(new td().addElement(delete));
		
		myTr.addElement(new td());
		
		div divButtonBox = (div)new div().setClass("button-box");
		input cancel = new input(input.TYPE_IMAGE, "btn_cancel", "Cancel");
		cancel.setID("btn_cancel");
		cancel.setSrc(WebEnv.getImageDirectory("Cancel32.png"));
		cancel.setOnClick("window.close();return false;");
		divButtonBox.addElement(cancel);
		
		input submit = new input(input.TYPE_IMAGE, "btn_submit", "OK");
		submit.setSrc(WebEnv.getImageDirectory("Ok32.png"));
		submit.setID("btn_submit");
		divButtonBox.addElement(submit);		

		
		myTr.addElement(new td().addElement(divButtonBox)); //clmg
		
		myForm.addElement(divBody); //clmg 2009/02/24
		doc.getBody().addElement(myForm);

		return doc;
	}	//	createFindPage
	

	/**
	 *  Save to Disk
	 *  @return true if inserted or updated
	 */
	public boolean save(HttpServletRequest request)
	{
	  	WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);
		
		String m_Value = WebUtil.getParameter(request, "aValue");		
		String cbClient = WebUtil.getParameter(request, "cbClient");
		String cbOrg = WebUtil.getParameter(request, "cbOrg");
		String cbUser = WebUtil.getParameter(request, "cbUser");
		String cbWindow = WebUtil.getParameter(request, "cbWindow");
		String m_Attribute = WebUtil.getParameter(request, "Attribute");

		//	Handle NULL
		if (m_Value == null || m_Value.length() == 0)
		{
			return false;
		}
		//	No Variables (SQL)
		else if (m_Value.indexOf("@") != -1)
		{
			return false;
		}

		boolean success = false;
		int AD_Preference_ID = getAD_Preference_ID(request);
		MPreference pref = new MPreference(ws.ctx, AD_Preference_ID, null);
		if (AD_Preference_ID == 0) //	New
		{
			int Client_ID = ws.ctx.getAD_Client_ID();
			int Org_ID = Constants.ENABLED.equals(cbOrg) ? ws.ctx.getAD_Org_ID() : 0;
			pref.setClientOrg(Client_ID, Org_ID);
			//
			if (Constants.ENABLED.equals(cbWindow))
				pref.setAD_Window_ID(ws.mWindow.getAD_Window_ID());
			if (Constants.ENABLED.equals(cbUser))
				pref.setAD_User_ID(ws.ctx.getAD_User_ID());
			pref.setAttribute(m_Attribute);
		}
		pref.setValue(m_Value);
		
		success = pref.save();
		if (success)
		{
			String contextKey = null;
			if (Constants.ENABLED.equals(cbWindow))
				contextKey = "P" + ws.mWindow.getAD_Window_ID() + "|" + m_Attribute;
			else
				contextKey = "P|" + m_Attribute;
			
			ws.ctx.setContext(contextKey, m_Value);
		}
		
		return success;
	}   //  insert	
	
	/**
	 * 	Get AD_Preference_ID based on selection
	 *	@return id or 0
	 */
	private int getAD_Preference_ID(HttpServletRequest request)
	{
	  	WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);
		
		String cbClient = WebUtil.getParameter(request, "cbClient");
		String cbOrg = WebUtil.getParameter(request, "cbOrg");
		String cbUser = WebUtil.getParameter(request, "cbUser");
		String cbWindow = WebUtil.getParameter(request, "cbWindow");
		String m_Attribute = WebUtil.getParameter(request, "Attribute");
		
		
		StringBuffer sql = new StringBuffer ("SELECT AD_Preference_ID FROM AD_Preference WHERE ");
		//	Client
		sql.append("AD_Client_ID=").append(ws.ctx.getAD_Client_ID());
		//	Org
		sql.append(" AND AD_Org_ID=").append(Constants.ENABLED.equals(cbOrg) ? ws.ctx.getAD_Org_ID() : 0);
		//	Optional User
		if (Constants.ENABLED.equals(cbUser))
			sql.append(" AND AD_User_ID=").append(ws.ctx.getAD_User_ID());
		else
			sql.append(" AND AD_User_ID IS NULL");
		//	Optional Window
		if (Constants.ENABLED.equals(cbWindow))
			sql.append(" AND AD_Window_ID=").append(ws.mWindow.getAD_Window_ID());
		else
			sql.append(" AND AD_Window_ID IS NULL");
		//	Attribute (Key)
		sql.append(" AND Attribute='").append(m_Attribute).append("'");
		//
		log.finest(sql.toString());
		int id = DB.getSQLValue(null, sql.toString());
		if (id < 0)
			id = 0;
		return id;
	}	//	getAD_Preference_ID
	
	/**
	 *  Delete Preference
	 *  @return number of rows deleted
	 */
	public boolean delete(HttpServletRequest request)
	{
	  	WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);
		
		String cbClient = WebUtil.getParameter(request, "cbClient");
		String cbOrg = WebUtil.getParameter(request, "cbOrg");
		String cbUser = WebUtil.getParameter(request, "cbUser");
		String cbWindow = WebUtil.getParameter(request, "cbWindow");
		String m_Attribute = WebUtil.getParameter(request, "Attribute");
		
		boolean success = false;
		int AD_Preference_ID = getAD_Preference_ID(request);
		if (AD_Preference_ID > 0)
		{
			MPreference pref = new MPreference(ws.ctx, AD_Preference_ID, null);
			success = pref.delete(true);
			if (success){
				String contextKey = null;
				if (Constants.ENABLED.equals(cbWindow))
					contextKey = "P" + ws.mWindow.getAD_Window_ID() + "|" + m_Attribute;
				else
					contextKey = "P|" + m_Attribute;
				ws.ctx.setContext(contextKey, (String)null);
			}
		}
		return success;
	}   //  delete	
}   //  WFind
