/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.web.servlet;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.ecs.AlignType;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.framework.PrintInfo;
import org.compiere.framework.Query;
import org.compiere.model.MPInstance;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MProcess;
import org.compiere.model.MRole;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

import com.ampiere.util.AmpiereUtil;

/**
 * Web Print Document Page.
 * @author Siqin
 * @version  $Id: WPrint.java,v 1.10 2010/05/16 10:14:01 clmg Exp $
 */
public class WPrint extends HttpServlet {
    /** Serial Version UID. */
    private static final long serialVersionUID = -66341541642842506L;
    /** Logger. */
    private CLogger log = CLogger.getCLogger(getClass());

    public static final String PRINT_FORMAT = "PrintFormat";
    public static final String FILE_FORMAT = "FileFormat";
    public static final String FILE_FORMAT_PDF	= "pdf";
    public static final String FILE_FORMAT_PS	= "ps";
    public static final String FILE_FORMAT_XML	= "xml";
    public static final String FILE_FORMAT_HTML	= "html";
    public static final String FILE_FORMAT_TXT	= "txt";
    public static final String FILE_FORMAT_SSV	= "ssv";
    public static final String FILE_FORMAT_CSV	= "csv";
    public static final String FILE_FORMAT_SAVE = "SaveFile";
    /**
     * Initialize.
     * @param config confif
     * @throws ServletException ServletException
     */
    public final void init(final ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WPrint.init");
        }
    }    //    init

    /**
     * Get Servlet information.
     * @return servlet info
     */
    public final String getServletInfo() {
        return "Ampiere Web Print Window";
    }

    /**
     * Clean up.
     */
    public final void destroy() {
        log.info("destroy");
        super.destroy();
    }

    /**
     *  Process the HTTP Get request - forward to Post.
     *  @param request request
     *  @param response response
     *  @throws ServletException ServletException
     *  @throws IOException IOException
     */
    public final void doGet(
            final HttpServletRequest request,
            final HttpServletResponse response) 
        throws ServletException, IOException {
        log.info("doGet");

        //  Get Session attributes
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        
        WWindowStatus ws = WWindowStatus.get(request);

//        int processId = Env.getContextAsInt(wsc.ctx, "AD_Process_ID");
//        int pInstanceId = Env.getContextAsInt(wsc.ctx, "AD_PInstance_ID");
        int processId = wsc.ctx.getContextAsInt("AD_Process_ID");
        int pInstanceId = wsc.ctx.getContextAsInt("AD_PInstance_ID");
        
        MProcess process = MProcess.get(wsc.ctx, processId);
        
        //  Create Process Instance
        MPInstance pInstance = new MPInstance(wsc.ctx, pInstanceId, null);
        //
        ProcessInfo processInfo = new ProcessInfo(process.getName(), process.getAD_Process_ID());
//        processInfo.setAD_User_ID(Env.getAD_User_ID(wsc.ctx));
//        processInfo.setAD_Client_ID(Env.getAD_Client_ID(wsc.ctx));
        processInfo.setAD_User_ID(wsc.ctx.getAD_User_ID());
        processInfo.setAD_Client_ID(wsc.ctx.getAD_Client_ID());
        processInfo.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
        processInfo.setRecord_ID(pInstance.getRecord_ID());
        if (ws != null) {
            processInfo.setRecord_ID(ws.curTab.getRecord_ID());
        }
        
        ReportEngine re = null;
        if (processInfo.getAD_Process_ID() == 110) {
            //  C_Order
            re = ReportEngine.get(wsc.ctx, ReportEngine.ORDER, processInfo.getRecord_ID());
        } else if (processInfo.getAD_Process_ID() == 116) {
            //  C_Invoice
            re = ReportEngine.get(wsc.ctx, ReportEngine.INVOICE, processInfo.getRecord_ID());
        } else if (processInfo.getAD_Process_ID() == 117) {
            //  M_InOut
            re = ReportEngine.get(wsc.ctx, ReportEngine.SHIPMENT, processInfo.getRecord_ID());
        } else if (processInfo.getAD_Process_ID() == 217) {
            //  C_Project
            re = ReportEngine.get(wsc.ctx, ReportEngine.PROJECT, processInfo.getRecord_ID());
        } else if (processInfo.getAD_Process_ID() == 276) {
            //  C_RfQResponse
            re = ReportEngine.get(wsc.ctx, ReportEngine.RFQ, processInfo.getRecord_ID());
        } else if (processInfo.getAD_Process_ID() == 313) {
            //  C_Payment
            int paySelectionCheckId = 0;
            MPaySelectionCheck psc = MPaySelectionCheck.getOfPayment(wsc.ctx, processInfo.getRecord_ID(), null);
            if (psc != null) {
                paySelectionCheckId = psc.getC_PaySelectionCheck_ID();
            } else {
                psc = MPaySelectionCheck.createForPayment(wsc.ctx, processInfo.getRecord_ID(), null);
                if (psc != null) {
                    paySelectionCheckId = psc.getC_PaySelectionCheck_ID();
                }
            }
            re = ReportEngine.get(wsc.ctx, ReportEngine.CHECK, paySelectionCheckId);
        } else if (processInfo.getAD_Process_ID() == 159) {
            //  Dunning
            re = ReportEngine.get(wsc.ctx, ReportEngine.DUNNING, processInfo.getRecord_ID());
        } else if (processInfo.getAD_Process_ID() == 202        //  Financial Report
                || processInfo.getAD_Process_ID() == 204) {     //  Financial Statement
            //  Create Query from Parameters
            String tableName = processInfo.getAD_Process_ID() == 202 ? "T_Report" : "T_ReportStatement";
//            MQuery query = MQuery.get(wsc.ctx, processInfo.getAD_PInstance_ID(), tableName);
            Query query = Query.get(wsc.ctx, processInfo.getAD_PInstance_ID(), tableName);

            //  Get PrintFormat
            MPrintFormat format = (MPrintFormat) processInfo.getTransientObject();
            if (format == null) {
                format = (MPrintFormat) processInfo.getSerializableObject();
            }

            if (format == null) {
                log.log(Level.SEVERE, "startFinReport - No PrintFormat");
                return;
            }
            PrintInfo info = new PrintInfo(processInfo);

            re = new ReportEngine(wsc.ctx, format, query, info);
        } else {
            re = ReportEngine.get(wsc.ctx, processInfo);
        }

        int tableId = re.getPrintFormat().getAD_Table_ID();
        String title = "";
        try{
        	title = ws.curTab.getName() + " : ";
        }catch(Exception e){
        	;
        }
        title += Msg.getMsg(wsc.ctx , "Report");

        WebDoc doc = WebDoc.createWindow(title);

        //  Set Title of main window
        doc.getBody().addElement( new script("top.document.title='" + title + "';"));

        // For date picker
        AmpiereUtil.addDatePicker(doc.getHead(), wsc);

        td center = doc.addWindowCenter(false);

        form myForm = new form("WPrint").setName("WPrint");
        table myTable = new table("0", "0", "5", "100%", null);
        myTable.setID("WPrint");
        myTable.setStyle( "border-collapse:separate;border-spacing:20px;" );

        tr line;
        // Print format
        line = new tr();
        // Print format label
        line.addElement(new td().addElement( Msg.translate(wsc.ctx, "AD_PrintFormat_ID")).setAlign(AlignType.RIGHT));
        // Print format selection
        ArrayList < String > ids = new ArrayList < String > ();
        ArrayList < String > names = new ArrayList < String > ();
        String sql = MRole.getDefault(wsc.ctx,false).addAccessSQL(
                "SELECT AD_PrintFormat_ID, Name, AD_Client_ID "
                    + "FROM AD_PrintFormat "
                    + "WHERE AD_Table_ID=? AND ISACTIVE='Y' "
                    + "ORDER BY AD_Client_ID DESC, IsDefault DESC, Name",
                "AD_PrintFormat", MRole.SQL_NOTQUALIFIED, MRole.SQL_RO);
        try {
            PreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, tableId);
            ResultSet rs = pstmt.executeQuery();

            while (rs.next()) {
                ids.add(rs.getString(1));
                names.add(rs.getString(2));
            }
            rs.close();
            pstmt.close();
        } catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        
        option [] options = new option[ids.size()];
        for (int i = 0; i < ids.size(); i++) {
            options[i] = new option(ids.get(i)).addElement(names.get(i));
            if ( re.getPrintFormat().getAD_PrintFormat_ID() == Integer.valueOf(ids.get(i)).intValue() ) {
            	options[i].setSelected(true);
            }
        }
        line.addElement( new td().addElement( new select(PRINT_FORMAT, options).setID(PRINT_FORMAT)));
        myTable.addElement(line);

        // Export file type
        line = new tr();
        // File format label
        line.addElement(new td().addElement( Msg.translate(wsc.ctx, "Export")).setAlign(AlignType.RIGHT));
        // File format selections
        options = new option[7];
        options[0] = new option(FILE_FORMAT_PDF).addElement(Msg.getMsg(wsc.ctx, "FilePDF"));
        options[1] = new option(FILE_FORMAT_PS).addElement(Msg.getMsg(wsc.ctx, "FilePS"));
        options[2] = new option(FILE_FORMAT_XML).addElement(Msg.getMsg(wsc.ctx, "FileXML"));
        options[3] = new option(FILE_FORMAT_HTML).addElement(Msg.getMsg(wsc.ctx, "FileHTML"));
        options[4] = new option(FILE_FORMAT_TXT).addElement(Msg.getMsg(wsc.ctx, "FileTXT"));
        options[5] = new option(FILE_FORMAT_SSV).addElement(Msg.getMsg(wsc.ctx, "FileSSV"));
        options[6] = new option(FILE_FORMAT_CSV).addElement(Msg.getMsg(wsc.ctx, "FileCSV"));
        options[0].setSelected(true);
        line.addElement( new td( new select(FILE_FORMAT, options).setID(FILE_FORMAT) ) );
        myTable.addElement(line);

        line = new tr();
		line.addElement( new td() );
		input checkBox = new input(input.TYPE_CHECKBOX, FILE_FORMAT_SAVE, "false");
		checkBox.setID( FILE_FORMAT_SAVE );
		checkBox.setChecked( false );
		label checkBoxLabel = new label(FILE_FORMAT_SAVE, null, Util.maskHTML(Msg.getMsg(wsc.ctx, FILE_FORMAT_SAVE,true)));
		checkBox.addElement(checkBoxLabel);
		line.addElement( new td( checkBox ) );
        myTable.addElement(line);

        // Submit botton
        line = new tr();
        line.addElement(new td(WebEnv.NBSP).setColSpan(2));
        myTable.addElement(line);

        // Submit botton
        line = new tr();
        input bt = new input( input.TYPE_BUTTON, "Export", Msg.translate(wsc.ctx, "Start"));
        StringBuffer sb = new StringBuffer();
        sb.append("openPrintWindow('/compiere/ampiere/WPrintReport");
        sb.append("?" + PRINT_FORMAT + "='+document.WPrint." + PRINT_FORMAT + ".value+");
        sb.append("'&" + FILE_FORMAT + "='+document.WPrint." + FILE_FORMAT + ".value+");
        sb.append("'&" + FILE_FORMAT_SAVE + "='+document.WPrint." + FILE_FORMAT_SAVE + ".checked");
        sb.append(",'' );");
        bt.setOnClick(sb.toString());
        line.addElement( new td(null, AlignType.CENTER, AlignType.MIDDLE, false, bt).setColSpan(2));
        //  Submit
        myTable.addElement(line);
        myForm.addElement(myTable);
        center.addElement(myForm);

        // Add body onUnload event, close all popup window when unload 
        doc.getBody().setOnUnload("closeMyChildren();");

        //
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    /**
     *    Process the HTTP Post request.
     *
     *  @param request request
     *  @param response response
     *  @throws ServletException ServletException
     *  @throws IOException IOException
     */
    public final void doPost(
            final HttpServletRequest request,
            final HttpServletResponse response) 
        throws ServletException, IOException {
        log.info("doPost");
    }

}
