/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.web.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.b;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.em;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.li;
import org.apache.ecs.xhtml.link;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.textarea;
import org.apache.ecs.xhtml.tr;
import org.apache.ecs.xhtml.ul;
import org.compiere.model.MRole;
import org.compiere.model.MUser;
import org.compiere.model.MUserPreference;
import org.compiere.util.CLogErrorBuffer;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

import com.ampiere.util.AmpiereUtil;

/**
 * 
 * @author Siqin
 *
 */
public class WToolsPreference extends HttpServlet {

	/** serialVersionUID */
	private static final long serialVersionUID = -4841905070456127217L;

	/**	Logger. */
    private CLogger log = CLogger.getCLogger(getClass());

	public static final int WINDOW_WIDTH=680;
	public static final int WINDOW_HEIGHT=520;
	private static final int TAB_HEIGHT = WINDOW_HEIGHT - 165;
	private static final String TAB_STYLE = "height:" + TAB_HEIGHT + ";";
	private static final String INFO_AREA_STYLE = "width:" + ( WINDOW_WIDTH - 60 ) + "px;height:80px;";

	private static final String POST_TYPE_NAME="postType";
	private static final String POST_TYPE_LOG="postTypelog";
	private static final String POST_TYPE_SAVE="postTypeSave";
	private static final String BTN_TYPE_NAME="btnType";
	private static final String BTN_TYPE_LOG="btnTypeLog";
	private static final String BTN_TYPE_RESET="btnTypeReset";
	private static final String ERROR_ONLY_NAME="errorOnly";

	private static final String AUTOCOMMIT = "AutoCommit";
	private static final String SHOWACCTTAB = "ShowAcctTab";
	private static final String SHOWTRLTAB = "ShowTrlTab";
	private static final String SHOWADVANCEDTAB = "ShowAdvancedTab";
	private static final String DATE = "Date";

	private static final String FORM_NAME   = "WForm";

	/**
	 * Initialize global variables.
     * @param config config
     * @throws ServletException ServletException
	 */
	public void init(ServletConfig config)
		throws ServletException	{
		super.init(config);
		log.info( "WToolsPreference.init" );
		if (!WebEnv.initWeb(config)) {
			throw new ServletException("WToolsPreference.init");
        }
	}   //  init

	/**
	 * Process the HTTP Get request Initial Call.
     * @param request request
     * @param response response
     * @throws ServletException ServletException
     * @throws IOException IOException
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException {

		log.info( "WToolsPreference.doGet" );

		WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);
		if (wsc == null) {
			WebUtil.createTimeoutPage(request, response, this, null);
			return;
		}

		WebDoc doc = WebDoc.createPopup( Msg.translate(wsc.ctx, "Preference") );

		// For date picker
		AmpiereUtil.addDatePicker(doc.getHead(), wsc);

		// yui tabview element
		doc.getHead().addElement(new link("js/yui_2.6.0/yui/build/tabview/assets/skins/sam/tabview.css", link.REL_STYLESHEET, link.TYPE_CSS));
		doc.getHead().addElement(new script((Element)null, "js/yui_2.6.0/yui/build/yahoo-dom-event/yahoo-dom-event.js"));
		doc.getHead().addElement(new script((Element)null, "js/yui_2.6.0/yui/build/connection/connection.js"));
		doc.getHead().addElement(new script((Element)null, "js/yui_2.6.0/yui/build/element/element-beta.js"));
		doc.getHead().addElement(new script((Element)null, "js/yui_2.6.0/yui/build/tabview/tabview.js"));
		doc.getHead().addElement(new script((Element)null, "js/preference.js"));

		table layout = new table();
		layout.setBorder( 1 );
		layout.setStyle( "margin:10px 10px 10px 10px;background-color:#edf5ff;width:100%;" );

		div tabPanel = new div();
		tabPanel.setID( "tabPanel" );
		tabPanel.setClass( "yui-navset" );
		doc.getBody().addElement( layout.addElement( new tr( new td( tabPanel ) ) ) );

		ul nav = new ul();
		nav.setClass( "yui-nav" );
		tabPanel.addElement( nav );

		li tab = new li();
		tab.setClass( "selected" );
		tab.addElement( new a( "#tabPreference", new em(Msg.translate(wsc.ctx, "Preference") ) ) );
		nav.addElement( tab );

		tab = new li();
		tab.addElement( new a( "#tabContext", new em(Msg.translate(wsc.ctx, "Context") ) ) );
		nav.addElement( tab );

		tab = new li();
		tab.addElement( new a( "#tabError", new em(Msg.translate(wsc.ctx, "Error") ) ) );
		nav.addElement( tab );

		div content = new div();
		content.setClass( "yui-content" );
		tabPanel.addElement( content );

		content.addElement( createPreferenceDiv(wsc) );
		content.addElement( createContextDiv(wsc) );
		content.addElement( createErrorDiv(wsc) );

		tr line = new tr();
		td item = new td();
		item.setAlign( "right" );
		
		input cancel = AmpiereUtil.createImageButton(wsc.ctx, "Cancel", "window.close();");
		item.addElement(cancel);
		
		input ok = AmpiereUtil.createImageButton(wsc.ctx, "Ok", "submitForm();");
		item.addElement(ok);
		item.addElement( "&nbsp;&nbsp;" );
		line.addElement( item );
		layout.addElement( line );

		line = new tr();
		item = new td();
		StringBuffer status = new StringBuffer("#");
		status.append(wsc.ctx.size());
		status.append(" - ");
		status.append(Msg.translate(wsc.ctx, "AD_Window_ID"));
		status.append("=");
		int windowNo = 0;
		if ( ws != null ) {
			windowNo = ws.mWindow.getWindowNo();
		}
		status.append( windowNo );
		item.addElement( status.toString() );
		line.addElement( item );
		layout.addElement( line );
		
		doc.getBody().addElement( layout );
		
		doc.getBody().setClass( "yui-skin-sam" );
		doc.getBody().setOnLoad("var tabs = new YAHOO.widget.TabView('tabPanel');");

		WebUtil.createResponse(request, response, this, null, doc, false);
	}   //  doGet

	/**
	 * Process the HTTP Post request. Get Parameters and Process.
     * @param request request
     * @param response response
     * @throws ServletException ServletException
     * @throws IOException IOException
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException {

		log.info( "WToolsPreference.doPost" );

		WebSessionCtx wsc = WebSessionCtx.get(request);
		if (wsc == null) {
			WebUtil.createTimeoutPage(request, response, this, null);
			return;
		}

		String context = "";
		String postType = WebUtil.getParameter(request, POST_TYPE_NAME );
		if ( POST_TYPE_LOG.equals( postType ) ) {
			String btnType = WebUtil.getParameter(request, BTN_TYPE_NAME);
			boolean errorOnly = "true".equals( WebUtil.getParameter(request, ERROR_ONLY_NAME) )?true:false;
			if ( BTN_TYPE_RESET.equals( btnType ) ) {
				CLogErrorBuffer.get(true).resetBuffer(errorOnly);
				context = getLogTable( wsc,errorOnly ).toString();
			} else if ( BTN_TYPE_LOG.equals( btnType ) ) {
				context = getLogTable( wsc,errorOnly ).toString();
			} else {
				context = getLogTable( wsc,true ).toString();
			}
		} else if ( POST_TYPE_SAVE.equals( postType ) ) {

			MUserPreference m_preference = MUser.get(wsc.ctx).getPreference();

			// AutoCommit
			m_preference.setIsAutoCommit(WebUtil.getParameterAsBoolean(request, AUTOCOMMIT));

			//	Show Acct Tab
			m_preference.setIsShowAcct(WebUtil.getParameterAsBoolean(request, SHOWACCTTAB));
			wsc.ctx.setContext("#ShowAcct", (WebUtil.getParameterAsBoolean(request, SHOWACCTTAB)));

			//	Show Trl Tab
			m_preference.setIsShowTrl(WebUtil.getParameterAsBoolean(request, SHOWTRLTAB));
			wsc.ctx.setContext("#ShowTrl", (WebUtil.getParameterAsBoolean(request, SHOWTRLTAB)));

			//	Show Advanced Tab
			m_preference.setIsShowAdvanced(WebUtil.getParameterAsBoolean(request, SHOWADVANCEDTAB));
			wsc.ctx.setContext("#ShowAdvanced", (WebUtil.getParameterAsBoolean(request, SHOWADVANCEDTAB)));

			//  Date (remove seconds)
			java.sql.Timestamp ts = WebUtil.getParameterAsDate(request, DATE);
			if (ts != null) {
				wsc.ctx.setContext("#Date", ts);
			}

			m_preference.save();
		}

		response.setHeader("Cache-Control", "no-cache");
		response.setContentType("text/html; charset=UTF-8");
		PrintWriter out = response.getWriter();
		out.write( context );
		out.flush();
		out.close();

	}   //  doPost

	private div createPreferenceDiv(WebSessionCtx wsc) {

		MUser user = MUser.get(wsc.ctx);

		div divPreference = new div();
		divPreference.setStyle( TAB_STYLE + "px;width:" + ( WINDOW_WIDTH - 40 ) + "px;"  );

		table layout = new table();
		layout.setStyle( "border-collapse:separate;border-spacing:20px;" );

		// infoArea
		td item = new td();
		item.setColSpan(3);
		textarea infoArea = new textarea();
		infoArea.setStyle( INFO_AREA_STYLE );
		infoArea.setReadOnly( true );
		infoArea.addElement( WAbout.getInfo(wsc.ctx,null,false).toString() );
		item.addElement( infoArea );
		tr line = new tr();
		line.addElement( item );
		layout.addElement( line );

		// user interface , role
		line = new tr();
		line.addElement( new td() );

		item = new td();
		input btn = new input(input.TYPE_BUTTON, "UITheme", Msg.getMsg(wsc.ctx, "UITheme",true));
		btn.setStyle( "width:200px" );
		item.addElement( btn );
		line.addElement( item );

		item = new td();
		item.setAlign( "right" );
		btn = new input(input.TYPE_BUTTON, "AD_Role_ID", Msg.translate(wsc.ctx, "AD_Role_ID"));
		btn.setOnClick( "alert('" + Msg.translate(wsc.ctx, "RoleInfo") + "\\r\\n\\r\\n" + MRole.getDefault(wsc.ctx,false).toStringX(wsc.ctx).replaceAll( Env.NL , "\\\\r\\\\n") + "');" );
		item.addElement( btn );
		line.addElement( item );
		layout.addElement( line );

		// AutoCommit, ShowAdvancedTab
		line = new tr();
		line.addElement( new td() );

		item = new td();
		input checkBox = new input(input.TYPE_CHECKBOX, AUTOCOMMIT, "true");
		checkBox.setID( AUTOCOMMIT );
		checkBox.setChecked( wsc.ctx.isAutoCommit() );
		label checkBoxLabel = new label(AUTOCOMMIT, null, Util.maskHTML(Msg.getMsg(wsc.ctx, AUTOCOMMIT,true)));
		checkBox.addElement(checkBoxLabel);
		item.addElement( checkBox );
		line.addElement( item );

		item = new td();
		checkBox = new input(input.TYPE_CHECKBOX, SHOWADVANCEDTAB, "true");
		checkBox.setID( SHOWADVANCEDTAB );
		checkBox.setChecked( user.getPreference().isShowAdvanced() );
		checkBoxLabel = new label(SHOWADVANCEDTAB, null, Util.maskHTML(Msg.getMsg(wsc.ctx, SHOWADVANCEDTAB,true)));
		checkBox.addElement(checkBoxLabel);
		item.addElement( checkBox );
		line.addElement( item );
		layout.addElement( line );

		// ShowAcctTab, ShowTrlTab
		line = new tr();
		line.addElement( new td() );

		item = new td();
		checkBox = new input(input.TYPE_CHECKBOX, SHOWACCTTAB, "true");
		checkBox.setID( SHOWACCTTAB );
		if (MRole.getDefault(wsc.ctx,false).isShowAcct()) {
			checkBox.setChecked(user.getPreference().isShowAcct());
		} else {
			checkBox.setChecked(false);
			checkBox.setDisabled(true);
		}
		checkBoxLabel = new label(SHOWACCTTAB, null, Util.maskHTML(Msg.getMsg(wsc.ctx, SHOWACCTTAB,true)));
		checkBox.addElement(checkBoxLabel);
		item.addElement( checkBox );
		line.addElement( item );

		item = new td();
		checkBox = new input(input.TYPE_CHECKBOX, SHOWTRLTAB, "true");
		checkBox.setID( SHOWTRLTAB );
		checkBox.setChecked( user.getPreference().isShowTrl() );
		checkBoxLabel = new label(SHOWTRLTAB, null, Util.maskHTML(Msg.getMsg(wsc.ctx, SHOWTRLTAB,true)));
		checkBox.addElement(checkBoxLabel);
		item.addElement( checkBox );
		line.addElement( item );
		layout.addElement( line );

		// Date
		line = new tr();
		line.addElement( new td(Msg.getMsg(wsc.ctx, DATE,true)) );

		item = new td();
		input date = new input(input.TYPE_TEXT, DATE, wsc.dateFormat.format(wsc.ctx.getContextAsTime("#Date") ) ).setSize(20).setMaxlength(10);
		date.setID( DATE + "F");
		item.addElement( date );
		img button = new img(WebEnv.getImageDirectory("Calendar16.png"), DATE + "B");
		button.setID( DATE + "B" );
		item.addElement( button );
		div dateTimePickerScriptDiv = new div();
		AmpiereUtil.addDatePickerScript(dateTimePickerScriptDiv, DATE + "F", DATE + "B", wsc.language);
		item.addElement( dateTimePickerScriptDiv );
		line.addElement( item );

		item = new td();
		line.addElement( item );
		layout.addElement( line );

		form mForm = new form();
		mForm.setMethod( form.METHOD_POST );
		mForm.setID(FORM_NAME);
		mForm.setName(FORM_NAME);
		mForm.addElement( layout );

		divPreference.addElement( mForm );

		return divPreference;
	}

	private div createContextDiv(WebSessionCtx wsc) {
		div divContext = new div();
		divContext.setStyle( TAB_STYLE + "px;width:100%;overflow:auto;" );
		String[] context = wsc.ctx.getEntireContext();
		ul panal = new ul();
		divContext.addElement( panal );
		for (int i = 0; i < context.length; i++) {
			panal.addElement( new li( context[i] ) );
		}

		return divContext;
	}

	private div createErrorDiv(WebSessionCtx wsc) {
		div divError = new div();
		divError.setStyle( TAB_STYLE + "px;width:100%;" );

		table layout = new table();
		layout.setBorder(1);
		layout.setStyle( "width:100%;" );
		divError.addElement( layout );

		div logInfo = new div();
		logInfo.setID( "logInfo" );
		logInfo.setStyle( "width:100%;height:" + (TAB_HEIGHT-35) + "px;overflow:auto;" );
		logInfo.addElement( getLogTable( wsc,true ) );
		layout.addElement( new tr( new td( logInfo ) ) );

		td item = new td();
		item.setAlign( "right" );
		input btn = new input(input.TYPE_BUTTON, "All", Msg.getMsg(wsc.ctx, "All",true));
		btn.setOnClick( "logTypeFlag='false';onBtnLog('btnTypeLog',logTypeFlag);" );
		btn.setStyle( "width:80px;" );
		item.addElement( btn );
		btn = new input(input.TYPE_BUTTON, "ErrorsOnly", Msg.getMsg(wsc.ctx, "ErrorsOnly",true));
		btn.setStyle( "width:80px;" );
		btn.setOnClick( "logTypeFlag='true';onBtnLog('btnTypeLog',logTypeFlag);" );
		item.addElement( btn );
		btn = new input(input.TYPE_BUTTON, "Reset", Msg.getMsg(wsc.ctx, "Reset",true));
		btn.setStyle( "width:80px;" );
		btn.setOnClick( "onBtnLog('btnTypeReset',logTypeFlag);" );
		item.addElement( btn );
		btn = new input(input.TYPE_BUTTON, "SendEMail", Msg.getMsg(wsc.ctx, "SendEMail",true));
		btn.setStyle( "width:80px;" );
		StringBuffer parameter = new StringBuffer();
		parameter.append( "channelmode=no," );
		parameter.append( "directories=no," );
		parameter.append( "fullscreen=no," );
		parameter.append( "location=no," );
		parameter.append( "menubar=no," );
		parameter.append( "resizable=no," );
		parameter.append( "scrollbars=no," );
		parameter.append( "status=no," );
		parameter.append( "titlebar=no," );
		parameter.append( "toolbar=no" );
		StringBuffer sb = new StringBuffer();
		sb.append("openWindow('WEMail?" + WEMail.EMAIL_TYPE + "=" + WEMail.EMAIL_TYPE_SUPPORT + "','" +
				Msg.translate(wsc.ctx, "EMailSupport") + "','" +
				parameter.toString() + "'," +
				WEMail.WINDOW_WIDTH + "," +
				WEMail.WINDOW_HEIGHT + ");" );
		btn.setOnClick( sb.toString() );
		item.addElement( btn );
		btn = new input(input.TYPE_BUTTON, "SaveFile", Msg.getMsg(wsc.ctx, "SaveFile",true));
		btn.setStyle( "width:120px;" );
		item.addElement( btn );

		layout.addElement( new tr( item ) );
		
		return divError;
	}

	private table getLogTable( WebSessionCtx wsc, boolean errorOnly ) {
		
		table list = new table();
		list.setStyle( "width:100%;" );
		list.setBorder(1);
		tr line = new tr();
		
		try{
			Vector<String> columnNames = CLogErrorBuffer.get(true).getColumnNames(wsc.ctx);
			for (String title : columnNames) {
				td headItem = new td();
				headItem.setAlign("center");
				headItem.addElement( new b( title ) );
				line.addElement( headItem );
			}
			list.addElement( line );

			Vector<Vector<Object>> datas = CLogErrorBuffer.get(true).getLogData(errorOnly);
			for (Vector <Object> data : datas) {
				line = new tr();
				for (Object item : data) {
					line.addElement( new td( item == null ? "":item.toString() ) );
				}
				list.addElement( line );
			}
		}catch(Exception e){
			line.addElement( new td() );
			list.addElement( line );
		}

		return list;
	}

}   //  WToolsPreference
