/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.web.servlet;

import java.util.*;
import javax.servlet.http.*;
import org.compiere.model.*;
import org.compiere.util.Ctx;

import com.ampiere.util.Constants;
import com.jware.util.StringToIntConverter;


/**
 *  WWindow Status Information (Value Object)
 *
 *  @author Jorg Janke
 *  @version  $Id: WWindowStatus.java,v 1.2 2009/09/26 11:01:16 clmg Exp $
 */
public class WWindowStatus
{
	/**
	 * 	Get Web Window Status.
	 	WWindowStatus ws = WWindowStatus.get(ctx);
	 *	@param request request
	 *	@return ctx or null
	 */
	public static WWindowStatus get (HttpServletRequest request, int windowId, int windowNo)
	{
		HttpSession session = request.getSession(false);
		if (session == null)
			return null;
		Map windowStatusMap = (Map)session.getAttribute(NAME);
		WWindowStatus wstatus = null;
		if(windowStatusMap!=null){
			wstatus = (WWindowStatus)windowStatusMap.get(windowId+"|"+windowNo);
		}
		return wstatus;
	}	//	get
	
//	public static WWindowStatus get (HttpServletRequest request)
//	{
//		HttpSession session = request.getSession(false);
//		if (session == null)
//			return null;
//		int windowId = StringToIntConverter.StringToInt(request.getParameter(Constants.WINDOW_ID));zz
//		int menuId = StringToIntConverter.StringToInt(request.getParameter(Constants.MENU_ID));
//		if(windowId==0){
//			if(menuId==0){
//				windowId = StringToIntConverter.StringToInt((String)session.getAttribute(Constants.WINDOW_ID));
//			}
//			if(windowId==0){
//				return null;	
//			}		
//		}
//		session.setAttribute(Constants.WINDOW_ID, String.valueOf(windowId));
//		return get(request, windowId);
//	}	//	get
	
	public static WWindowStatus get (HttpServletRequest request)
	{
		HttpSession session = request.getSession(false);
		if (session == null)
			return null;
		int windowId = StringToIntConverter.StringToInt(request.getParameter(Constants.WINDOW_ID));
		int windowNo = StringToIntConverter.StringToInt(request.getParameter(Constants.WINDOW_NO));
		int menuId = StringToIntConverter.StringToInt(request.getParameter(Constants.MENU_ID));
		if(windowId==0){
			if(menuId==0){
				windowId = StringToIntConverter.StringToInt((String)session.getAttribute(Constants.WINDOW_ID));
				windowNo = StringToIntConverter.StringToInt((String)session.getAttribute(Constants.WINDOW_NO));
			}
			if(windowId==0){
				return null;	
			}		
		}
		session.setAttribute(Constants.WINDOW_ID, String.valueOf(windowId));
		session.setAttribute(Constants.WINDOW_NO, String.valueOf(windowNo));
		return get(request, windowId, windowNo);
	}	//	get
	
	public static void set (HttpServletRequest request, int windowId, WWindowStatus wstatus)
	{
		set(request, windowId, wstatus.curTab.getWindowNo(), wstatus);
	}	//	get	
	
	public static void set (HttpServletRequest request, int windowId, int windowNo, WWindowStatus wstatus)
	{
		HttpSession session = request.getSession(false);
		if (session == null)
			return;
		Map windowStatusMap = (Map)session.getAttribute(NAME);
		if(windowStatusMap==null){
			windowStatusMap = new HashMap();
		}
		windowStatusMap.put(windowId+"|"+windowNo, wstatus);
		session.setAttribute(Constants.WINDOW_ID, String.valueOf(windowId));
		session.setAttribute(Constants.WINDOW_NO, String.valueOf(windowNo));
		session.setAttribute(NAME, windowStatusMap);
	}	//	get	
	
	//clean corresponding element from windowStatusMap
	//windowを閉じるとき呼ばれる。
	public static void clean (HttpServletRequest request, int windowId, int windowNo)
	{
		HttpSession session = request.getSession(false);
		if (session == null)
			return;
		Map windowStatusMap = (Map)session.getAttribute(NAME);
		if(windowStatusMap==null){
			return;
		}
		windowStatusMap.remove(windowId+"|"+windowNo);
		session.setAttribute(NAME, windowStatusMap);
	}	//	get	
	
	/**************************************************************************
	 *  Constructor - First Tab - First Row - Single Row.
	 *  <br>
	 *  Initialize Formats
	 *  @param mWindowVO window VO
	 */
	public WWindowStatus (GridWindowVO mWindowVO)
	{
//		mWindow = new MWindow(mWindowVO);
		mWindow = new GridWindow(mWindowVO);
		curTab = mWindow.getTab(0);
		curTab.setSingleRow(true);
		//
		ctx = mWindowVO.ctx;
	}   //  WWindowStatus

	/**	Session Attribute Name			*/
	public static final String NAME	= "WWindowStatus"; 
	
	/** The MWindow                 */
//	protected MWindow       mWindow;
	protected GridWindow       mWindow;
	/** The current MTab            */
	protected GridTab          curTab;

	/** Window Context 				*/
	public Ctx    ctx = null;
	
	private String    target = null;

	public String getTarget() {
		return target;
	}

	public void setTarget(String target) {
		this.target = target;
	}

	/**
	 *  String representation
	 *  @return String representation
	 */
	public String toString()
	{
		if (mWindow != null && curTab != null) {
			return "WWindowStatus[" + mWindow + " - " + curTab + "]";
		} else {
			return "WWindowStatus";
		}
	}   //  toString

	/**
	 * Get current tab
	 * @return
	 */
	public GridTab getCurTab() {
		return curTab;
	}
}   //  WWindowStatus
