/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.web.servlet;

import java.io.IOException;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.ecs.AlignType;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.apache.ecs.xhtml.ul;
import org.compiere.model.MForm;
import org.compiere.model.MMenu;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWorkflow;


/**
 *
 *
 *  @author Siqin
 *  @version  $Id: WWorkflow.java,v 1.3 2010/04/07 10:22:49 siqin Exp $
 */
public class WWorkflow extends HttpServlet
{
	private static final long serialVersionUID = 716400326045758093L;


	/**
	 * Initialize global variables
	 */
	public void init(ServletConfig config)
		throws ServletException
	{
		super.init(config);
		if (!WebEnv.initWeb(config))
			throw new ServletException("WWorkflow.init");
	}   //  init

	/**
	 * Process the HTTP Get request
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException {

		WebSessionCtx wsc = WebSessionCtx.get(request);
		if (wsc == null) {
			WebUtil.createTimeoutPage(request, response, this, null);
			return;
		}

		String title = Msg.translate(wsc.ctx,"AD_Workflow_ID");
		int AD_Menu_ID = WebUtil.getParameterAsInt(request, "AD_Menu_ID");
		ul list = new ul();
		MMenu menu = new MMenu( wsc.ctx,AD_Menu_ID,null);
		if ( "F".equals( menu.getAction() ) ) {
			int AD_Workflow_ID = menu.getAD_Workflow_ID();
			if ( AD_Workflow_ID > 0 ) {
				int AD_Client_ID = wsc.ctx.getAD_Client_ID();
				MWorkflow wf = new MWorkflow (wsc.ctx, AD_Workflow_ID, null);
				title = wf.getName(true);
				MWFNode[] nodes = wf.getNodes(true, AD_Client_ID);
				for (int i = 0; i < nodes.length; i++) {
					list.addElement( createItem(nodes[i],wsc.ctx,i) );
				}
			}
		}

		div layout = new div();
		layout.setStyle( "margin:20px;" );
		layout.addElement( list );
		WebDoc doc = WebDoc.createWindow(title);
		doc.getTable().addElement(new tr().addElement( new td(null, AlignType.LEFT, AlignType.TOP,true, WWindow.createMenuDiv(wsc,null))));
		doc.getHead().addElement(new script( WWindow.makeMenuItemScript( wsc,null ) ));
		doc.getBody().setOnLoad( "displayMenu();" );
		doc.getTable().addElement( new tr( new td( layout ) ) );

		WebUtil.createResponse(request, response, this, null, doc, false);
	}   //  doGet


	/**
	 *  Process the HTTP Post request
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException
	{
		WebDoc doc = WebDoc.create ("WWorkflow - Post - Not Implemented Yet");
		//
		WebUtil.createResponse(request, response, this, null, doc, false);
	}   //  doPost

	/**
	 *  Print Item
	 *  @param MWFNode node
	 */
	private String createItem(MWFNode node, Ctx ctx, int i) {
		StringBuffer sb = new StringBuffer();
		String sql = "SELECT AD_MENU_ID FROM AD_MENU WHERE ";
		String servletName = "";
		String css = "border: solid 1px #9CBBD0;padding: 5 5 5 25px;cursor: pointer;width:150px;height:32px;";
		int AD_Menu_ID = 0;
		if ("W".equals(node.getAction())) {
			css += "background: url(" + WebEnv.DIR_BASE + "/images/menuicons/mWindow.png) no-repeat 5px 5px #E7F2F9;";
			servletName = "WWindow";
			AD_Menu_ID = DB.getSQLValue(null, sql + "AD_Window_ID=?", node.getAD_Window_ID());
		} else if ("X".equals(node.getAction())) {
			css += "background: url(" + WebEnv.DIR_BASE + "/images/menuicons/mWindow.png) no-repeat 5px 5px #E7F2F9;";
			servletName = "WForm";
			MForm form = new MForm(ctx, node.getAD_Form_ID(), null);
			if (form.getJSPURL() != null && form.getJSPURL().length() > 0) {
				servletName = form.getJSPURL();
			}
			AD_Menu_ID = DB.getSQLValue(null, sql + "AD_Form_ID=?", node.getAD_Form_ID());
		} else if ("R".equals(node.getAction())) {
			css += "background: url(" + WebEnv.DIR_BASE + "/images/menuicons/mReport.png) no-repeat 5px 5px #E7F2F9;";
			servletName = "WReport";
			AD_Menu_ID = DB.getSQLValue(null, sql + "AD_Process_ID=?", node.getAD_Process_ID());
		} else if ("P".equals(node.getAction())) {
			css += "background: url(" + WebEnv.DIR_BASE + "/images/menuicons/mProcess.png) no-repeat 5px 5px #E7F2F9;";
			servletName = "WProcess";
			AD_Menu_ID = DB.getSQLValue(null, sql + "AD_Process_ID=?", node.getAD_Process_ID());
		} else if ("F".equals(node.getAction())) {
			css += "background: url(" + WebEnv.DIR_BASE + "/images/menuicons/mWorkflow.png) no-repeat 5px 5px #E7F2F9;";
			servletName = "WWorkflow";
			AD_Menu_ID = DB.getSQLValue(null, sql + "AD_Workflow_ID=?", node.getAD_Workflow_ID());
		} else if ("T".equals(node.getAction())) {
			css += "background: url(" + WebEnv.DIR_BASE + "/images/menuicons/mProcess.png) no-repeat 5px 5px #E7F2F9;";
			servletName = "WTask";
			AD_Menu_ID = DB.getSQLValue(null, sql + "AD_Task_ID=?", node.getAD_Task_ID());
		} else {
			servletName = "WError";
		}

		String name = node.getName(true).replace('\'', ' ').replace('"', ' ');
		String description = node.getDescription(true).replace('\'', ' ')
				.replace('"', ' ');
		description += Env.NL;
		description += node.getHelp(true).replace('\'', ' ').replace('"', ' ');
		if ( i > 0 ) {
			sb.append( "<li style='padding:0px;width:180px;height:16px;background: url(" + WebEnv.DIR_BASE + "/images/Next16.png) no-repeat center center;'></li>");
		}
		sb.append("<li style='" + css + "' id=\"" + node.get_ID() + "\"><a href=\"");
		sb.append(WebEnv.getBaseDirectory(servletName));

		sb.append("?AD_Menu_ID=");
		sb.append(AD_Menu_ID);

		// remaining a tag
		div text = new div();
		text.setStyle( "width:100%;height:100%;" );
		sb.append( "\" title=\"" + description + "\" onClick=\"showLoadingWindow('" + WebEnv.getBaseDirectory("") + "')\">").append(text.addElement(name)).append("</a></li>");

		return sb.toString();

	} // createItem

}   //  WWorkflow
