/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.web.servlet;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;

import org.apache.commons.lang.StringUtils;
import org.apache.ecs.AlignType;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.li;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.textarea;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.ul;
import org.compiere.framework.Lookup;
import org.compiere.framework.Query;
import org.compiere.model.MLocator;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;

import com.ampiere.util.AmpiereUtil;
import com.ampiere.util.Constants;

/**
 * Web Field.
 * 
 * @author Jorg Janke
 * @version $Id: WebField.java,v 1.25 2010/05/22 08:34:43 clmg Exp $
 */
public class WebField {
	/**
	 * Web Field
	 * 
	 * @param wsc
	 *            session context
	 * @param columnName
	 *            column
	 * @param name
	 *            label
	 * @param description
	 *            description
	 * @param displayType
	 *            display type
	 * @param fieldLength
	 *            field length
	 * @param displayLength
	 *            optional display length
	 * @param longField
	 *            if true spans 3 columns
	 * @param readOnly
	 *            read only
	 * @param mandatory
	 *            mandatory
	 * @param error
	 *            erro status
	 * @param hasDependents
	 *            has dependent fields
	 * @param hasCallout
	 *            has callout functions
	 * @param AD_Process_ID
	 *            process id
	 */
	public WebField(int windowNo, WebSessionCtx wsc, String columnName, String name, String description,
			int displayType, int fieldLength, int displayLength, boolean longField, boolean readOnly,
			boolean mandatory, boolean error, boolean hasDependents, boolean hasCallout, int AD_Process_ID,
			boolean encryptedField) {
		super();
		m_windowNo = windowNo;
		m_wsc = wsc;
		m_columnName = columnName;
		if (name == null || name.length() == 0)
			m_name = columnName;
		else
			m_name = name;
		if (description != null && description.length() > 0)
			m_description = description;
		//
		m_displayType = displayType;
		m_fieldLength = fieldLength;
		m_displayLength = displayLength;
		if (m_displayLength == 0)
			m_displayLength = 20 * 16; // default length
		m_longField = longField;
		//
		m_readOnly = readOnly;
		m_mandatory = mandatory;
		m_error = error;
		m_hasDependents = hasDependents;
		m_hasCallout = hasCallout;
		m_processId = AD_Process_ID;
		m_encryptedField = encryptedField;
	} // WebField

	/** CSS Field Mandatory Class */
	public static final String C_MANDATORY = "Cmandatory";
	/** CSS Field Error Class */
	public static final String C_ERROR = "Cerror";

	/** Web Session Context */
	private WebSessionCtx m_wsc;

	private int m_windowNo;
	private String m_columnName;
	private String m_name;
	private String m_description;
	//
	private int m_displayType;
	private int m_fieldLength;
	private int m_displayLength;
	private boolean m_longField;
	//
	private boolean m_readOnly;
	private boolean m_mandatory;
	private boolean m_error;
	private boolean m_hasDependents;
	private boolean m_hasCallout;
	private int m_processId;
	private boolean m_encryptedField;

	/**
	 * Get the field Label
	 * 
	 * @return label
	 */
	// public td getLabel()
	public th getLabel() {
		if (m_displayType == DisplayType.YesNo)
			// return new td(WebEnv.NBSP);
			return new th(WebEnv.NBSP); // clmg 2009/02/10
		//
		label myLabel = new label(m_columnName + "F", null, Util.maskHTML(m_name));
		myLabel.setID(m_columnName + "L");
		if (m_description != null)
			myLabel.setTitle(Util.maskHTML(m_description));
		//
		// clmg 2009/02/10
		// td td = new td()
		th td = new th() // clmg 2009/02/10
				.addElement(myLabel);
		// .setAlign(AlignType.RIGHT)
		// .setVAlign(AlignType.TOP);
		// td.setVAlign(AlignType.MIDDLE);
		// td.setNoWrap(true);
		// --

		return td;
	} // getLabel

	public th getZoomLabel(int windowId, String columnName, String value, WWindowStatus ws) {
		//
		label myLabel = new label(m_columnName + "F", null, Util.maskHTML("　　" + m_name));
		myLabel.setID(m_columnName + "L");
		if (m_description != null)
			myLabel.setTitle(Util.maskHTML(m_description));

		String menuId = "zm_" + columnName; // zm_(zoom menu) + columnName

		a zoomWindwoLink = new a();
		zoomWindwoLink.setOnMouseOver("this.style.textDecoration='underline'");
		zoomWindwoLink.setOnMouseOut("this.style.textDecoration='none';mclosetime();");
		zoomWindwoLink.setOnClick("mopen('" + menuId + "')");
		zoomWindwoLink.addElement(myLabel);

		String zoomUrl = "WWindow?windowId=" + String.valueOf(windowId) + "&columnName=" + columnName + "&value="
				+ value;

		// zoomWindwoLink.setTarget("_BLANK");

		th td = new th().addElement(zoomWindwoLink);

		ul menuUl = (ul) new ul().setClass("zoomMenu");
		li menLi = (li) new li();
		td.addElement(menuUl);
		menuUl.addElement(menLi);
		menuUl.setStyle("align: right; position: absolute;");
		boolean bpartnerFlag = false;
		if (columnName.equals("C_BPartner_ID")) {
			bpartnerFlag = true;
		}
		div menuDiv = getMenuDiv(menuId, zoomUrl, columnName, "openPreferenceWindow", ws, bpartnerFlag);
		menLi.addElement(menuDiv);
		return td;
	} // getZoomLabel

	public static li getZoomAcross(img img, ArrayList<KeyNamePair> zoomList, WWindowStatus ws) {
		//
		String menuId = "za_" + ws.curTab.getKeyColumnName(); // zm_(zoom menu)
																// + columnName

		img.setOnMouseOver("this.style.textDecoration='underline'");
		img.setOnMouseOut("this.style.textDecoration='none';mclosetime();");
		img.setOnClick("mopen('" + menuId + "')");

		Query query = new Query();
		// Current row
		String link = ws.getCurTab().getKeyColumnName();
		// Link for detail records
		if (link.length() == 0)
			link = ws.getCurTab().getLinkColumnName();
		if (link.length() != 0) {
			if (link.endsWith("_ID"))
				query.addRestriction(link, Query.EQUAL, new Integer(ws.ctx.getContextAsInt(
						ws.getCurTab().getWindowNo(), link)));
			else
				query.addRestriction(link, Query.EQUAL, ws.ctx.getContext(ws.getCurTab().getWindowNo(), link));
		}

		String[] arr = query.toString().split("=");

		String queryStr = "columnName=" + String.valueOf(arr[0]) + "&value=" + arr[1];

		li td = (li) new li();
		td.addElement(img);
		ul menuUl = (ul) new ul().setClass("zoomMenu");
		li menLi = (li) new li();
		td.addElement(menuUl);
		menuUl.addElement(menLi);
		menuUl.setStyle("align: right; position: absolute;");
		div menuDiv = getZoomAcrossMenuDiv(menuId, zoomList, queryStr);
		menLi.addElement(menuDiv);
		return td;
	} // getZoomAcross

	public static div getZoomAcrossMenuDiv(String menuId, ArrayList<KeyNamePair> zoomList, String queryStr) {

		div menuDiv = (div) new div().setID(menuId);
		menuDiv.setOnMouseOver("mcancelclosetime()");
		menuDiv.setOnMouseOut("mclosetime()");
		menuDiv.setStyle("visibility:hidden");

		ul ul = new ul();
		for (int i = 0; i < zoomList.size(); i++) {
			li li = new li();
			KeyNamePair pp = zoomList.get(i);
			String zoomUrl = "WWindow?windowId=" + String.valueOf(pp.getKey()) + "&" + queryStr;
			a a_zoom = (a) new a(zoomUrl, pp.getName());
			a_zoom.setTarget("_BLANK");
			li.addElement(a_zoom);
			ul.addElement(li);

		}
		menuDiv.addElement(ul);

		return menuDiv;
	}

	public static li getRequestLi(img img, ArrayList<ValueNamePair> zoomList, WWindowStatus ws) {
		//
		String menuId = "rl_" + ws.curTab.getKeyColumnName(); // rl_ + columnName

		img.setOnMouseOver("this.style.textDecoration='underline'");
		img.setOnMouseOut("this.style.textDecoration='none';mclosetime();");
		img.setOnClick("mopen('" + menuId + "')");
		
		li td = (li) new li();
		td.addElement(img);
		ul menuUl = (ul) new ul().setClass("zoomMenu");
		li menLi = (li) new li();
		td.addElement(menuUl);
		menuUl.addElement(menLi);
		menuUl.setStyle("align: right; position: absolute;");
		div menuDiv = getRequestMenuDiv(menuId, zoomList);
		menLi.addElement(menuDiv);
		return td;
	} // 
	
	public static div getRequestMenuDiv(String menuId, ArrayList<ValueNamePair> requestList) {

		div menuDiv = (div) new div().setID(menuId);
		menuDiv.setOnMouseOver("mcancelclosetime()");
		menuDiv.setOnMouseOut("mclosetime()");
		menuDiv.setStyle("visibility:hidden");

		int AD_Window_ID = 232;		//	232=all - 201=my
		
		ul ul = new ul();
		for (int i = 0; i < requestList.size(); i++) {
			li li = new li();
			ValueNamePair pp = requestList.get(i);
			String zoomUrl = "WWindow?windowId=" + String.valueOf(AD_Window_ID) + "&" 
			+ Constants.QUERY + "=" + pp.getValue();
			a a_zoom = (a) new a(zoomUrl, pp.getName());
			a_zoom.setTarget("_BLANK");
			li.addElement(a_zoom);
			ul.addElement(li);
		}
		menuDiv.addElement(ul);

		return menuDiv;
	}	

	/**
	 * Zoom, refresh用のmenu作成
	 */
	public script getMenuScript(String labelId, String menuId) {
		//
		StringBuffer sb = new StringBuffer();
		sb.append("YAHOO.util.Event.onContentReady(\"").append(labelId).append("\",function() {").append(
				"des = document.getElementById(\"").append(labelId).append("\");").append("xPos = findXPos(des);")
				.append("yPos = findYPos(des);").append("var " + menuId + " = new YAHOO.widget.Menu(\"").append(menuId)
				.append("\", {xy: [xPos, yPos]});").append(menuId + ".render();").append(
						"YAHOO.util.Event.addListener(\"").append(labelId).append("\", \"click\", function() {")
				.append(menuId + ".show();").append("});").append("});");

		return new script(sb.toString());
	} // getZoomLabel

	public div getMenuDiv(String menuId, String zoomUrl, String refreshColumnName, String valuePreferenceUrl,
			WWindowStatus ws, boolean bpartnerFlag) {

		div menuDiv = (div) new div().setID(menuId);
		menuDiv.setOnMouseOver("mcancelclosetime()");
		menuDiv.setOnMouseOut("mclosetime()");
		menuDiv.setStyle("visibility:hidden");

		if (zoomUrl != null) {
			a a_zoom = (a) new a(zoomUrl, Msg.translate(ws.ctx, "Zoom") + "<br/>");
			a_zoom.setTarget("_BLANK");
			// a_zoom.setStyle("background-color: #FFFF66"); modified by yoshida
			// 090929
			menuDiv.addElement(a_zoom);
		}

		if (refreshColumnName != null) {
			label a_refresh = (label) new label().addElement(Msg.translate(ws.ctx, "Refresh") + "<br/>");
			a_refresh.setOnClick("startRefresh(" + refreshColumnName + ");");
			// a_refresh.setStyle("background-color: #FFFF66"); modified by
			// yoshida 090929
			menuDiv.addElement(a_refresh);
		}
		//
		// VBPartner quick entry link
		if (bpartnerFlag == true) {
			label m_bpartnerNew = (label) new label().addElement(Msg.translate(ws.ctx, "New") + "<br/>");
			m_bpartnerNew.setOnClick("openBPartnerWindow(" + refreshColumnName + ");");
			// m_bpartnerNew.setStyle("background-color: #FFFF66"); modified by
			// yoshida 090929
			menuDiv.addElement(m_bpartnerNew);

			label m_bpartnerUpdate = (label) new label().addElement(Msg.translate(ws.ctx, "Update") + "<br/>");
			m_bpartnerUpdate.setOnClick("openBPartnerWindow(" + refreshColumnName + ");");
			// m_bpartnerUpdate.setStyle("background-color: #FFFF66"); modified
			// by yoshida 090929
			menuDiv.addElement(m_bpartnerUpdate);
		}

		if (valuePreferenceUrl != null) {
			label a_valuePrefrence = (label) new label().addElement(Msg.translate(ws.ctx, "ValuePreference") + "<br/>");
			a_valuePrefrence.setOnClick("openPreferenceWindow(" + refreshColumnName + ");");
			// a_valuePrefrence.setStyle("background-color: #FFFF66"); modified
			// by yoshida 090929
			menuDiv.addElement(a_valuePrefrence);
		}

		return menuDiv;
	}

	public static li getWorkFlow(img img, WWindowStatus ws) {
		int s_workflow_Window_ID = 297; // fallback HARDCODED

		int AD_Table_ID = ws.curTab.getAD_Table_ID();
		int Record_ID = ws.curTab.getRecord_ID();
		// WWindow?windowId=109&columnName=AD_Client_ID&value=11
		String url = "WWindow?windowId=" + s_workflow_Window_ID + "&" + Constants.WORKFLOW_QUERY + "="
				+ Constants.ENABLED + "&AD_Table_ID=" + AD_Table_ID + "&Record_ID=" + Record_ID;
		li td = (li) new li();
		img.setOnClick("startPopup('" + url + "')");
		td.addElement(img);
		return td;
	} // getZoomAcross

	/**
	 * Create Left Top aligned TD
	 * 
	 * @param element
	 *            element
	 * @return td table data
	 */
	private td createTD(Element element) {
		td td = new td().addElement(element).setAlign(AlignType.LEFT).setVAlign(AlignType.TOP);
		if (m_longField)
			td.setColSpan(3);
		return td;
	} // createTD

	/**
	 * Get Field
	 * 
	 * @param lookup
	 *            lookup
	 * @param data
	 *            data
	 * @return field
	 */
	public td getField(Lookup lookup, Object data, int AD_Column_ID) {
		return getField(lookup, data, AD_Column_ID, null);
	}

	public td getField(Lookup lookup, Object data, int AD_Column_ID, String onclick) {
		td tdRet = null;
		String dataValue = (data == null) ? "" : data.toString();
		//
		if (m_displayType == DisplayType.Search || m_displayType == DisplayType.Location
				|| m_displayType == DisplayType.Account || m_displayType == DisplayType.PAttribute) // clmg
																									// 2009/04/19
		{
			String dataDisplay = "";
			if (lookup != null && data != null)
				dataDisplay = lookup.getDisplay(data);
			tdRet = getPopupField(dataDisplay, dataValue, AD_Column_ID, lookup, onclick);
		} else {
			if (DisplayType.isLookup(m_displayType) || m_displayType == DisplayType.Locator) {
				tdRet = getSelectField(lookup, dataValue);
			} else if (m_displayType == DisplayType.YesNo) {
				tdRet = getCheckField(dataValue);
			} else if (m_displayType == DisplayType.Button) {
				tdRet = getButtonField(dataValue);
			} else if (DisplayType.isDate(m_displayType)) {
				tdRet = getDateField(data);
			} else if (DisplayType.isNumeric(m_displayType)) {
				tdRet = getNumberField(data);
			} else if (m_displayType == DisplayType.Text) { // Strings
				tdRet = getTextField(dataValue, 3);
			} else if (m_displayType == DisplayType.TextLong) {
				tdRet = getTextField(dataValue, 10);
			} else if (m_displayType == DisplayType.Memo) {
				tdRet = getTextField(dataValue, 15);
			} else {
				tdRet = getStringField(dataValue);
			}
		}
		tdRet.setVAlign(AlignType.MIDDLE);
		return tdRet;
	} // getField

	/**
	 * Create String Field
	 * 
	 * @param data
	 *            initial value
	 * @return td
	 */
	private td getStringField(String data) {
		input string = new input(input.TYPE_TEXT, m_columnName, AmpiereUtil.maskHtmlCR(data));
		string.setID(m_columnName + "F");
		if (m_displayLength > 128) {
			string.setSize(128);
		} else {
			string.setSize(m_displayLength);
		}
		if (m_fieldLength > 0)
			string.setMaxlength(m_fieldLength);
		//
		string.setDisabled(m_readOnly);
		if (m_error)
			string.setClass(C_ERROR);
		else if (m_mandatory)
			string.setClass(C_MANDATORY);
		//
		// if (m_hasDependents || m_hasCallout)
		// string.setOnChange("startUpdate(this);");
		// string.setOnChange("dynDisplay();");
		//
		// clmg 2009/03/27
		String script_change_Flag = "setChangeFlag();";
		if (m_hasDependents || m_hasCallout) {
			string.setOnChange(script_change_Flag + "startUpdate(this);");
		} else {
			string.setOnChange(script_change_Flag);
		}

		if (m_encryptedField) {
			string.setType(input.TYPE_PASSWORD);
		}

		string.addAttribute("style", "width:" + (m_displayLength) + "px;");

		return createTD(string);
	} // getStringField

	/**
	 * Create Text Field
	 * 
	 * @param data
	 *            initial value
	 * @param rows
	 *            no of rows
	 * @return td
	 */
	private td getTextField(String data, int rows) {
		textarea text = new textarea(m_columnName, rows, m_displayLength).addElement(AmpiereUtil.maskHtmlCR(data));
		text.setID(m_columnName + "F");
		text.setDisabled(m_readOnly);
		if (m_error)
			text.setClass(C_ERROR);
		else if (m_mandatory)
			text.setClass(C_MANDATORY);
		//
		// if (m_hasDependents || m_hasCallout)
		// text.setOnChange("startUpdate(this);");
		// clmg 2009/03/27
		String script_change_Flag = "setChangeFlag();";
		if (m_hasDependents || m_hasCallout) {
			text.setOnChange(script_change_Flag + "startUpdate(this);");
		} else {
			text.setOnChange(script_change_Flag);
		}

		text.addAttribute("style", "width:" + (m_displayLength) + "px;");

		//
		return createTD(text);
	} // getTextField

	/**
	 * Create Date Field
	 * 
	 * @param data
	 *            initial value
	 * @return td
	 */
	private td getDateField(Object data) {
		String formattedData = "";
		if (data == null)
			;
		else if (m_displayType == DisplayType.DateTime)
			formattedData = m_wsc.dateTimeFormat.format(data);
		else
			formattedData = m_wsc.dateFormat.format(data);

		input string = new input(input.TYPE_TEXT, m_columnName, formattedData);
		// clmg 2009/03/27
		String script_change_Flag = "setChangeFlag();";
		string.setOnChange(script_change_Flag);

		string.setID(m_columnName + "F");
		string.setSize(m_displayLength);
		if (m_fieldLength >= 10)
			string.setMaxlength(m_fieldLength);
		//
		string.setDisabled(m_readOnly);
		if (m_error)
			string.setClass(C_ERROR);
		else if (m_mandatory)
			string.setClass(C_MANDATORY);
		//
		// clmg 2009/03/06
		if (m_displayType == DisplayType.DateTime) {
			// Date+Timeの場合

		} else {
			// string.setOnChange("checkDateValidation(this, paraInvalidDateMsg);startUpdate(this);");
		}

		string.setReadOnly(m_readOnly);

		string.addAttribute("style", "width:" + (m_displayLength) + "px;");

		div dateTimePickerScriptDiv = new div();// clmg 2009/03/08

		img button = null;
		if (!m_readOnly) {
			// Show image button when field is editable
			String gif = "Calendar16.png";
			button = new img(WebEnv.getImageDirectory(gif), m_columnName);

			button.setID(m_columnName + "B");
			button.setClass("popupButton");

			String inputBoxId = m_columnName + "F";
			String buttonId = m_columnName + "B";
			if (m_displayType == DisplayType.DateTime) {
				// Date+Timeの場合
				AmpiereUtil.addDateTimePickerScript(dateTimePickerScriptDiv, inputBoxId, buttonId, m_wsc.language);
			} else {
				// onClick = "recDate_onclick_function('" + m_columnName + "F" +
				// "', null, paraMonths, paraShortMonths, paraWeeks, paraShortWeeks, paraDateFormat);";
				// button.setOnClick(onClick + "return false;");
				AmpiereUtil.addDatePickerScript(dateTimePickerScriptDiv, inputBoxId, buttonId, m_wsc.language);
			}

			if (m_description != null)
				button.setTitle(Util.maskHTML(m_description));
		}

		td tdRet = createTD(string);
		if (button != null) {
			tdRet.addElement(button);
			// clmg 2009/03/27
			button.setOnClick(script_change_Flag);
			// clmg 2009/03/08
			tdRet.addElement(dateTimePickerScriptDiv);
		}
		return tdRet;
	} // getDateField

	/**
	 * Create Number Field
	 * 
	 * @param data
	 *            initial value
	 * @return td
	 */
	private td getNumberField(Object data) {
		String formattedData = null;
		DecimalFormat decimalFormat = null;
		if (data == null)
			formattedData = "";
		else if (m_displayType == DisplayType.Amount) {
			decimalFormat = m_wsc.amountFormat;
		} else if (m_displayType == DisplayType.Number)
			decimalFormat = m_wsc.numberFormat;
		// else if (m_displayType == DisplayType.CostPrice)
		// decimalFormat = m_wsc.costPriceFormat;
		else if (m_displayType == DisplayType.Quantity)
			decimalFormat = m_wsc.quantityFormat;
		else if (m_displayType == DisplayType.Integer)
			decimalFormat = m_wsc.integerFormat;
		else
			formattedData = data.toString();

		if (formattedData == null) {
			BigDecimal bd = new BigDecimal(0);
			try {
				bd = new BigDecimal(data.toString());
			} catch (NumberFormatException e) {
				bd = new BigDecimal(0);
			}
			bd = bd.setScale(decimalFormat.getMaximumFractionDigits(), BigDecimal.ROUND_HALF_UP);
			formattedData = decimalFormat.format(bd);
		}

		//
		input string = new input(input.TYPE_TEXT, m_columnName, formattedData);
		string.setID(m_columnName + "F");
		string.setSize(m_displayLength);
		if (m_fieldLength > 0)
			string.setMaxlength(m_fieldLength);
		//
		string.setDisabled(m_readOnly);
		if (m_error)
			string.setClass(C_ERROR);
		else if (m_mandatory)
			string.setClass(C_MANDATORY);
		//
		// if (m_hasDependents || m_hasCallout)
		// string.setOnChange("startUpdate(this);");
		// clmg 2009/03/27
		String script_change_Flag = "setChangeFlag();";
		if (m_hasDependents || m_hasCallout) {
			string.setOnChange(script_change_Flag + "startUpdate(this);");
		} else {
			string.setOnChange(script_change_Flag);
		}

		string.addAttribute("style", "width:" + (m_displayLength) + "px;");

		td tdRet = createTD(string);

		if (!m_readOnly) {
			// Show image button when field is editable
			img button = null;
			String gif = "Calculator16.png";
			button = new img(WebEnv.getImageDirectory(gif), m_columnName);
			button.setID(m_columnName + "B");
			button.setClass("popupButton");
			button.setOnClick( "javascript:TCR.TCRPopup(document.getElementById('" + m_columnName + "F'));" );
			if (m_description != null) {
				button.setTitle(Util.maskHTML(m_description));
			}
			tdRet.addElement(button);
		}

		return tdRet;

	} // getNumberField

	/**
	 * Create Checkbox Field
	 * 
	 * @param data
	 *            initial value
	 * @return td
	 */
	private td getCheckField(String data) {
		boolean check = data != null && (data.equals("true") || data.equals("Y"));
		//
		// input cb = new input (input.TYPE_CHECKBOX, m_columnName, "true")
		// .setChecked(check)
		// .addElement(m_name);
		input cb = new input(input.TYPE_CHECKBOX, m_columnName, "true").setChecked(check);
		label myLabel = new label(m_columnName + "F", null, Util.maskHTML(m_name));
		myLabel.setID(m_columnName + "L");
		cb.addElement(myLabel);

		cb.setID(m_columnName + "F");
		cb.setDisabled(m_readOnly);
		if (m_error)
			cb.setClass(C_ERROR);
		// else if (m_mandatory) // looks odd
		// cb.setClass(C_MANDATORY);
		//
		// if (m_hasDependents || m_hasCallout)
		// cb.setOnClick("startUpdate(this);");
		String script_change_Flag = "setChangeFlag();";
		if (m_hasDependents || m_hasCallout) {
			cb.setOnClick(script_change_Flag + "startUpdate(this);"); // clmg
																		// 2009/04/02
		} else {
			cb.setOnClick(script_change_Flag);
		}
		//
		return createTD(cb);
	} // getCheckField

	private td getPopupField(String dataDisplay, String dataValue, int AD_Column_ID, Lookup lookup, String onclick) {
		// The hidden data field Name=columnName
		input hidden = new input(input.TYPE_HIDDEN, m_columnName, dataValue);
		hidden.setID(m_columnName + "D");

		// The display field Name=columnName, ID=FcolumnName
		input display = new input(input.TYPE_TEXT, m_columnName, AmpiereUtil.maskHtmlCR(dataDisplay));//2010/03/02
		display.setID(m_columnName + "F");
		display.setReadOnly(m_readOnly);
		display.setSize(m_displayLength);
		display.setDisabled(m_readOnly);

		display.addAttribute("style", "width:" + (m_displayLength) + "px;");

		img button = null;
		if (!m_readOnly) {
			// Show image button when field is editable

			// The button Name=columnName, ID=BcolumnName
			String gif = "PickOpen16.gif";
			if (m_displayType == DisplayType.Location)
				gif = "Location16.gif";
			else if (m_displayType == DisplayType.Account)
				gif = "Account16.gif";
			else if (m_columnName.equals("C_BPartner_ID"))
				gif = "BPartner16.png";
			else if (m_columnName.equals("M_Product_ID"))
				gif = "Product16.png";
			else if (m_columnName.equals("M_AttributeSetInstance_ID"))
				gif = "PAttribute16.png";

			button = new img(WebEnv.getImageDirectory(gif), m_columnName);
			button.setID(m_columnName + "B");
			button.setClass("popupButton");
			String onClick = "";
			String col = lookup.getColumnName();
			if (col != null && col.indexOf(".") >= 0) {
				col = col.substring(col.indexOf(".") + 1);
			}
			if (m_displayType == DisplayType.Location) {
				onClick = "startLocation('" + m_columnName + "'," + m_windowNo + "," + AD_Column_ID + ",'" + col
						+ "',null);";
				display.setReadOnly(true);
			} else if (m_displayType == DisplayType.Account) {
				String Combination = "";
				if(!StringUtils.isEmpty(dataValue)){
					Combination = dataValue;
				}
				onClick = "startAccount('" + m_columnName + "','" + Combination + "');";
			} else if (m_columnName.equals("M_AttributeSetInstance_ID")) { // clmg
																			// 2009/04/25
				onClick = "startPopup('WAttributeSet');";
			} else {
				onClick = "startLookup('" + m_columnName + "'," + m_windowNo + "," + AD_Column_ID + ",'" + col
						+ "', 'N',null);";
			}

			if (onclick != null) {
				onClick = onclick;
			}

			button.setOnClick(onClick + "return false;");

			if (m_description != null)
				button.setTitle(Util.maskHTML(m_description));
		} else {
			// disabled のときは作って表示しない。　//clmg 2009/03/10
			String gif = "PickOpen16.gif";
			if (m_displayType == DisplayType.Location)
				gif = "Location16.gif";
			else if (m_displayType == DisplayType.Account)
				gif = "Account16.gif";
			else if (m_columnName.equals("C_BPartner_ID"))
				gif = "BPartner16.png";
			else if (m_columnName.equals("M_Product_ID"))
				gif = "Product16.png";
			button = new img(WebEnv.getImageDirectory(gif), m_columnName);
			button.setID(m_columnName + "B");
			button.setClass("popupButton");
			String onClick = "";
			String col = lookup.getColumnName();
			if (col != null && col.indexOf(".") >= 0) {
				col = col.substring(col.indexOf(".") + 1);
			}
			if (m_displayType == DisplayType.Location) {
				onClick = "startLocation('" + m_columnName + "'," + m_windowNo + "," + AD_Column_ID + ",'" + col
						+ "',null);";
				display.setReadOnly(true);
			} else if (m_displayType == DisplayType.Account) {
				onClick = "startAccount('" + m_columnName + "',null);";
			} else {
				onClick = "startLookup('" + m_columnName + "'," + m_windowNo + "," + AD_Column_ID + ",'" + col
						+ "', 'N',null);";
			}

			if (onclick != null) {
				onClick = onclick;
			}

			button.setOnClick(onClick + "return false;");
			button.setClass("imgButtonD");// clmg 2009/03/22

			if (m_description != null)
				button.setTitle(Util.maskHTML(m_description));

		}

		//
		if (m_error)
			display.setClass(C_ERROR);
		else if (m_mandatory)
			display.setClass(C_MANDATORY);
		//
		// if (m_hasDependents || m_hasCallout || ! m_readOnly)
		// display.setOnChange("startUpdate(this);");
		//
		// clmg 2009/03/27
		String script_change_Flag = "setChangeFlag();";
		if (m_hasDependents || m_hasCallout || !m_readOnly) {
			display.setOnChange(script_change_Flag + "startUpdate(this);");
		} else {
			display.setOnChange(script_change_Flag);
		}

		td tdRet = createTD(hidden).addElement(display);
		if (button != null) {
			tdRet.addElement(button);
		}
		return tdRet;
	} // getPopupField

	/**
	 * Get Select Field
	 * 
	 * @param lookup
	 *            lookup
	 * @param dataValue
	 *            default value
	 * @return selction td
	 */
	private td getSelectField(Lookup lookup, String dataValue) {
		select sel = new select(m_columnName, getOptions(lookup, dataValue));
		sel.setID(m_columnName);
		sel.setDisabled(m_readOnly);
		if (m_error)
			sel.setClass(C_ERROR);
		else if (m_mandatory)
			sel.setClass(C_MANDATORY);
		//
		// sel.setOnChange("startUpdate(this);");
		// clmg 2009/03/27
		String script_change_Flag = "setChangeFlag();";
		if (m_hasDependents || m_hasCallout) {
			sel.setOnChange(script_change_Flag + "startUpdate(this);");
		} else {
			sel.setOnChange(script_change_Flag);
		}

		sel.addAttribute("style", "width:" + (m_displayLength) + "px;");

		return createTD(sel);
	} // getSelectField

	/**
	 * Get Array of options
	 * 
	 * @param lookup
	 *            lookup
	 * @param dataValue
	 *            default value
	 * @return selction td
	 */
	private option[] getOptions(Lookup lookup, String dataValue) {
		if (lookup == null)
			return new option[0];
		//
		Object[] list = lookup.getData(m_mandatory, true, !m_readOnly, false).toArray(); // if
																							// r/o
																							// also
																							// inactive
		int size = list.length;
		if (size <= 0) {
			// Force load for display
			list = lookup.getData(m_mandatory, true, true, true).toArray();
			size = list.length;
		}
		option[] options = new option[size + 1];
		options[0] = new option("").addElement("");
		
		for (int i = 0; i < size; i++) {
			boolean isNumber = list[0] instanceof KeyNamePair;
			String key = null;
			// if (m_displayType == DisplayType.Locator)
			// 修正理由：　前はObject型でしたが、3.0でNamePairに変わりました。MLocatorLookup.getData参考。
			if (m_displayType == DisplayType.Locator && !isNumber) // clmg
																	// 2009/03/09　　
			{
				MLocator loc = (MLocator) list[i];
				key = String.valueOf(loc.getM_Locator_ID());
				String name = AmpiereUtil.maskHTML(loc.getValue());
				options[i + 1] = new option(key).addElement(name);
			} else if (isNumber) {
				KeyNamePair p = (KeyNamePair) list[i];
				key = String.valueOf(p.getKey());
				String name = AmpiereUtil.maskHTML(p.getName());
				options[i + 1] = new option(key).addElement(name);
			} else {
				ValueNamePair p = (ValueNamePair) list[i];
				key = p.getValue();
				if (key == null || key.length() == 0)
					key = "";
				String name = p.getName();
				if (name == null || name.length() == 0)
					name = " ";
				name = AmpiereUtil.maskHTML(name);
				options[i + 1] = new option(key).addElement(name);
			}
			if (dataValue.equals(key))
				options[i + 1].setSelected(true);
		}
		return options;
	} // getOptions

	/**
	 * Get Button Field
	 * 
	 * @return Button
	 */
	private td getButtonField(String data) {
		String header = m_name;
		// Special Buttons
		if (m_columnName.equals("PaymentRule")) {
			// readReference(195);
			header = readReferenceName(195, data);
		} else if (m_columnName.equals("DocAction")) {
			// readReference(135);
			header = readReferenceName(135, data);
		} else if (m_columnName.equals("Posted")) {
			// readReference(234);
			header = readReferenceName(234, data);
		}

		// input button = new input(input.TYPE_BUTTON, m_columnName,
		// Util.maskHTML(m_name));
		input button = new input(input.TYPE_BUTTON, m_columnName, Util.maskHTML(header));
		button.setID(m_columnName);

		// Disable payment rule now
		if (m_columnName.indexOf("PaymentRule") >= 0) {
			m_readOnly = true;
		}

		button.setDisabled(true);
		// int needSave = Env.getContextAsInt(m_wsc.ctx, m_windowNo,
		// "NeedSave");
		int needSave = m_wsc.ctx.getContextAsInt(m_windowNo, "NeedSave");
		if (!m_readOnly && needSave == 0) {
			// Editable
			// int AD_Table_ID = Env.getContextAsInt(m_wsc.ctx, m_windowNo,
			// "BaseTable_ID");
			// int record_ID = Env.getContextAsInt(m_wsc.ctx, m_windowNo,
			// "Record_ID");
			int AD_Table_ID = m_wsc.ctx.getContextAsInt(m_windowNo, "BaseTable_ID");
			int record_ID = m_wsc.ctx.getContextAsInt(m_windowNo, "Record_ID");
			button.setOnClick("startButton('" + m_columnName + "', " + m_windowNo + ", " + m_processId + ", "
					+ AD_Table_ID + ", " + record_ID + ");");
			button.setDisabled(false);
		}
		return createTD(button).setAlign(AlignType.LEFT); // overwrite
	} // getButtonField

	/**
	 * Fill m_Values with Ref_List values
	 * 
	 * @param AD_Reference_ID
	 *            reference
	 */
	private String readReferenceName(int AD_Reference_ID, String value) {
		String name = value;
		String SQL;
		if (Env.isBaseLanguage(m_wsc.ctx, "AD_Ref_List"))
			SQL = "SELECT Name FROM AD_Ref_List WHERE AD_Reference_ID=? AND VALUE=?";
		else
			SQL = "SELECT t.Name FROM AD_Ref_List l, AD_Ref_List_Trl t " + "WHERE l.AD_Ref_List_ID=t.AD_Ref_List_ID"
					+ " AND t.AD_Language='" + Env.getAD_Language(m_wsc.ctx) + "'" + " AND l.AD_Reference_ID=?"
					+ " AND l.VALUE=?";
		try {
			PreparedStatement pstmt = DB.prepareStatement(SQL, null);
			pstmt.setInt(1, AD_Reference_ID);
			pstmt.setString(2, value);
			ResultSet rs = pstmt.executeQuery();
			if (rs.next()) {
				name = rs.getString(1);
			}
			rs.close();
			pstmt.close();
		} catch (SQLException e) {
		}

		return name;
	} // readReference

} // WebField
