/**
 * 
 */
package com.ampiere.web.struts.ajax;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.compiere.util.CLogger;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Login;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

import com.ampiere.dto.SimpleBean;
import com.ampiere.util.ajax.AjaxXmlItemBuilder;
import com.ampiere.util.ajax.AjaxXmlMultiItemsBuider;
import com.ampiere.web.servlet.WLogin;
import com.ampiere.web.servlet.WWindowStatus;

/**
 * @author bato
 *  @version  $Id: WLoginAjaxAction.java,v 1.1 2008/09/30 12:26:09 clmg Exp $
 */
public class WLoginAjaxAction extends BaseAjaxActionEx {

	protected CLogger log = CLogger.getCLogger(this.getClass());

	/**
	 * do login second page select list.
	 * @see com.ampiere.web.struts.ajax.BaseAjaxActionEx#getXmlContent(org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, java.util.Map)
	 */
	@Override
	public String getXmlContent(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response, Map param)
			throws Exception {
		//  Get Session Info >> direct copy code from Mr. Jorg Janke
		WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);
		if (wsc == null || ws == null)    //  ws can be null for Login
			;

		Login login = new Login(wsc.ctx);
		
		String strRole = WebUtil.getParameter (request, "role");
		String strClient = WebUtil.getParameter (request, "client");
		String strOrg = WebUtil.getParameter (request, "org");

		List listClient = null;
		List listOrg = null;
		List listWarehouse = null;

		if (strRole!=null && strRole.length()>0 ){
			KeyNamePair[] clients = makeClients(login, strRole);
			listClient = makeList(clients);
			KeyNamePair[] orgs = null;
			//use top of Clients to make list of Org.
			if (clients == null || clients.length<1){
				listOrg = makeList(null);
			}else{
				orgs = makeOrgs(login, clients[0].getID());
				listOrg = makeList(orgs);
			}
			//use top of Org to make list of Warehouse.
			if (orgs == null || orgs.length<1){
				listWarehouse = makeList(null);
			}else{
				KeyNamePair[] whs = makeWarehouses(login, orgs[0].getID());
				listWarehouse = makeList(whs);				
			}
		}else if (strClient!=null && strClient.length()>0 ){
			KeyNamePair[] orgs = makeOrgs(login, strClient);
			listOrg = makeList(orgs);
			//use top of Org to make list of Warehouse.
			if (orgs == null || orgs.length<1){
				listWarehouse = makeList(null);
			}else{
				KeyNamePair[] whs = makeWarehouses(login, orgs[0].getID());
				listWarehouse = makeList(whs);				
			}
		}else if (strOrg!=null && strOrg.length()>0 ){
			KeyNamePair[] whs = makeWarehouses(login, strOrg);
			listWarehouse = makeList(whs);
		}
		
		// Make the target xml
		String  strRVal = "";
	    try {
	    	AjaxXmlItemBuilder ajaxBuilder = null;
	    	AjaxXmlMultiItemsBuider ajaxXmlCalloutBuider = new AjaxXmlMultiItemsBuider();
	    	if (listClient!=null){
		    	ajaxBuilder = new AjaxXmlItemBuilder();
		    	ajaxBuilder.putInfo("tagname", "select" );
		    	ajaxBuilder.putInfo("type", "none" );
		    	ajaxBuilder.putInfo("id", WLogin.P_CLIENT + "F" );//Get HTML ID
		    	ajaxBuilder.addItems(listClient, "value", "key");
		    	ajaxXmlCalloutBuider.addTarget(ajaxBuilder);
	    	}
	    	if (listOrg!=null){
		    	ajaxBuilder = new AjaxXmlItemBuilder();
		    	ajaxBuilder.putInfo("tagname", "select" );
		    	ajaxBuilder.putInfo("type", "none" );
		    	ajaxBuilder.putInfo("id", WLogin.P_ORG + "F" );//Get HTML ID
		    	ajaxBuilder.addItems(listOrg, "value", "key");
		    	ajaxXmlCalloutBuider.addTarget(ajaxBuilder);
	    	}
	    	if (listWarehouse!=null){
		    	ajaxBuilder = new AjaxXmlItemBuilder();
		    	ajaxBuilder.putInfo("tagname", "select" );
		    	ajaxBuilder.putInfo("type", "none" );
		    	ajaxBuilder.putInfo("id", WLogin.P_WAREHOUSE + "F" );//Get HTML ID
		    	ajaxBuilder.addItems(listWarehouse, "value", "key");
		    	ajaxXmlCalloutBuider.addTarget(ajaxBuilder);
	    	}
	    	strRVal = ajaxXmlCalloutBuider.toString();
	    }catch (Exception e) {
	    	log.log(Level.WARNING,"On get Organization.",e);
		}

	    return strRVal;
	}

	/**
	 * make Clients
	 * @param login
	 * @param strRole
	 * @return
	 */
	private KeyNamePair[] makeClients(Login login, String strRole){
		KeyNamePair[] clients = null;
		try {
			clients = login.getClients (
					new KeyNamePair(Integer.parseInt(strRole) , strRole));			
		} catch (Exception e) {
	    	log.log(Level.WARNING,"On get Client. Role=" + strRole ,e);
		}
		return clients;
	}
	
	/**
	 * make Orgs
	 * @param login
	 * @param strClient
	 * @return
	 */
	private KeyNamePair[] makeOrgs(Login login, String strClient){
		KeyNamePair[] orgs = null;
		try {
			orgs = login.getOrgs (
					new KeyNamePair(Integer.parseInt(strClient) , strClient));
		} catch (Exception e) {
	    	log.log(Level.WARNING,"On get Org. Client=" + strClient ,e);
		}
		return orgs;
		
	}
	
	/**
	 * make Warehouses
	 * @param login
	 * @param strOrg
	 * @return
	 */
	private KeyNamePair[] makeWarehouses(Login login, String strOrg){
		KeyNamePair[] whs = null;
		try {
			whs = login.getWarehouses (
					new KeyNamePair(Integer.parseInt(strOrg) , strOrg));
		} catch (Exception e) {
	    	log.log(Level.WARNING,"On get Warehouse. Org=" + strOrg ,e);
		}
		return whs;
		
	}
	
	/**
	 * make option list
	 * @param pKeyPair
	 * @return Option List
	 */
	private List makeList(KeyNamePair[] pKeyPair ){

		List<SimpleBean> list = new ArrayList<SimpleBean>();

		if (pKeyPair != null)
			for (int i = 0; i < pKeyPair.length; i++)
			{
				KeyNamePair p = pKeyPair[i];
				SimpleBean bean = new SimpleBean( String.valueOf(p.getKey()), p.getName() );
				list.add(bean);
			}
		return list;
	}
	
}
