package com.ampiere.web.struts.form;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.framework.Lookup;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPayment;
import org.compiere.model.MRole;
import org.compiere.model.MStorage;
import org.compiere.process.DocAction;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.WebSessionCtx;

import com.ampiere.util.Constants;
import com.jware.util.StringToIntConverter;

/**
 * @author clmg
 */
public class AllocationAction extends Action {

    /** Logger. */
    private CLogger log = CLogger.getCLogger(this.getClass());
    
    /** Matching List Forward. */
    private static final String MATCHING_LIST = "matchinglist";

    /** Action Form. */
    private static final String ACTION_FORM = "MatchingForm";

    /** Global Error Forward. */
    private static final String ERROR_FORWARD = "error";

    /** Invoice. */
    private static final int        MATCH_INVOICE = 0;
    /** Shipment. */
    private static final int        MATCH_SHIPMENT = 1;
    /** Order. */
    private static final int        MATCH_ORDER = 2;
    
    private static final String        CALCULATE_ACTION = "1";
    private static final String        MATCH_FROM_DATA_LIST = "MATCH_FROM_DATA_LIST";
    private static final String        MATCH_TO_DATA_LIST = "MATCH_TO_DATA_LIST";
    private static final String        ALLOCATE_DATE = "ALLOCATE_DATE";

    private StringBuffer    m_sql = null;
    private String          m_dateColumn = "";
    private String          m_qtyColumn = "";
    private String          m_groupBy = "";
    /**
     * Action execute.
     * @param mapping mapping
     * @param form form
     * @param request request
     * @param response response
     * @throws Exception Exception
     * @return ActionForward
     * @see org.apache.struts.action.Action#execute(
     *      org.apache.struts.action.ActionMapping,
     *      org.apache.struts.action.ActionForm,
     *      javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse)
     */
    public final ActionForward execute(
            final ActionMapping mapping,
            final ActionForm form,
            final HttpServletRequest request,
            final HttpServletResponse response)
    throws Exception {
    	
		//201001 
        WebSessionCtx wscTest = WebSessionCtx.get(request); 
        if (wscTest == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute(Constants.SESSION_TIMEOUT_INFO, "Session Time Out. Please login again.");
            return mapping.findForward(Constants.SESSION_TIMEOUT);
        }
        //--201001	     	

        log.fine("Begin " + this.getClass().getName() + ";execute");
        HttpSession session = request.getSession();

        WebSessionCtx wsc = WebSessionCtx.get(request); 
        if (wsc == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }

        ActionForward actionForward = mapping.findForward(MATCHING_LIST);
        
        AllocationForm myForm =
            (AllocationForm) form;
        
        String actionType = request.getParameter(Constants.ACTION_TYPE);
        
        if(CALCULATE_ACTION.equals(actionType)){
        	String[] response_array=new String[8];
        	
        	String column = myForm.getChangedColumn();
        	if(column.indexOf("payment")>=0){
        		int index = StringToIntConverter.StringToInt(column.replace("payment", ""));
        		selectUnselectPayment(request, myForm, index, response_array);
        	}else if(column.indexOf("invoice")>=0){
        		int index = StringToIntConverter.StringToInt(column.replace("invoice", ""));
        		selectUnselectInvoice(request, myForm, index, response_array);
        	}else if (column.indexOf("invoice")>=0){
        		int index = 1;
        		
        	}
        	calculate(myForm, request, response, response_array);
    		setResponse(response, response_array);
        	return null;
        }

        String column = myForm.getChangedColumn();
        if (column.equals("currency")) {
            // Match From changed.
            search(wsc, myForm);            
            searchTo(wsc, myForm);
            actionForward = mapping.findForward(MATCHING_LIST);
        } else if (column.equals("businessPartnerName")) {
            // Business Partner Name chenged.
            Lookup lookup = null;
            try {
                lookup = MLookupFactory.get(
                        wsc.ctx,
                        0,
                        3499,
                        DisplayType.TableDir,
                        wsc.language,
                        "C_BPartner_ID",
                        0,
                        false,
                        "UPPER(NAME) LIKE '" + myForm.getBusinessPartnerName().toUpperCase() + "%' ");

                Iterator keyNames = lookup.getData(true, false, true, false).iterator();
                KeyNamePair keyName;
                if (keyNames.hasNext()) {
                    keyName = (KeyNamePair) keyNames.next();
                    myForm.setBusinessPartnerId(keyName.getKey());
                    myForm.setBusinessPartnerName(keyName.getName());
                } else {
                    myForm.setBusinessPartnerId(999999999);
                }
            } catch (Exception e) {
                log.log(Level.SEVERE, "MLookupFactory.get AD_Column_ID=" + 3499, e);
            }

            search(wsc, myForm);            
            searchTo(wsc, myForm);
            actionForward = mapping.findForward(MATCHING_LIST);
        } else if (column.equals("search")) {
            // 
            myForm.setMatchFromCurrentId(0);
            myForm.setMatchToIdList(null);
            myForm.setMatchFromCurrentBusinessPartnerId(-1);
            search(wsc, myForm);            
            searchTo(wsc, myForm);
            actionForward = mapping.findForward(MATCHING_LIST);
        } else if (column.equals("process")) {
            // Process
            saveData(request, myForm);
            // Search
            search(wsc, myForm);            
            searchTo(wsc, myForm);
            actionForward = mapping.findForward(MATCHING_LIST);
        } else{
            search(wsc, myForm);            
            searchTo(wsc, myForm);
        }
        
        myForm.setChangedColumn(null);
        myForm.setMatchFromIdList(null);
        myForm.setMatchToIdList(null);
        myForm.setMatchDifferenceCount("0.0");
        // Save form to request.
        request.setAttribute(ACTION_FORM, myForm);
        session.setAttribute(MATCH_FROM_DATA_LIST, myForm.getMatchFromDataList());
        session.setAttribute(MATCH_TO_DATA_LIST, myForm.getMatchToDataList());

        log.fine("End " + this.getClass().getName() + ";execute");

        return actionForward;
    }
    
    /**
     * Search.
     * @param wsc context
     * @param form Action From
     */
    private void search(
            final WebSessionCtx wsc,
            final AllocationForm form) {
    	
    	int m_C_Currency_ID = StringToIntConverter.StringToInt(form.getCurrency());
    	int m_C_BPartner_ID = form.getBusinessPartnerId();
    	int AD_Role_ID = wsc.ctx.getAD_Role_ID();
    	int AD_User_ID = wsc.ctx.getAD_User_ID();
    	MRole role = MRole.get( wsc.ctx, AD_Role_ID, AD_User_ID, false); 
    	boolean isMultiCurrencySelected = Constants.ON.equals(form.getMultiCurrency());
    	int index = 1; // position 0 is used to store column names.
    	
        ArrayList < HashMap > dataList = new ArrayList < HashMap > ();
        HashMap < String, Object > data = new HashMap < String, Object > ();
        int count = 0;
    	
		/********************************
		 *  Load unallocated Payments
		 *      1-TrxDate, 2-DocumentNo, (3-Currency, 4-PayAmt,)
		 *      5-ConvAmt, 6-ConvOpen, 7-Allocated
		 */
		
		StringBuffer sql = new StringBuffer("SELECT p.DateTrx,p.DocumentNo,p.C_Payment_ID,"  //  1..3
			+ "c.ISO_Code,p.PayAmt,"                            //  4..5
			/*//jz
			+ "currencyConvert(p.PayAmt,p.C_Currency_ID,?,p.DateTrx,p.C_ConversionType_ID,p.AD_Client_ID,p.AD_Org_ID),"//  6   #1
			+ "currencyConvert(paymentAvailable(C_Payment_ID),p.C_Currency_ID,?,p.DateTrx,p.C_ConversionType_ID,p.AD_Client_ID,p.AD_Org_ID),"  //  7   #2
			*/
			+ "currencyConvert(p.PayAmt,p.C_Currency_ID," + m_C_Currency_ID + ",p.DateTrx,p.C_ConversionType_ID,p.AD_Client_ID,p.AD_Org_ID),"//  6   #1
			+ "currencyConvert(paymentAvailable(C_Payment_ID),p.C_Currency_ID," + m_C_Currency_ID + ",p.DateTrx,p.C_ConversionType_ID,p.AD_Client_ID,p.AD_Org_ID),"  //  7   #2
			+ "p.MultiplierAP "
			+ "FROM C_Payment_v p"		//	Corrected for AP/AR
			+ " INNER JOIN C_Currency c ON (p.C_Currency_ID=c.C_Currency_ID) "
			+ "WHERE p.IsAllocated='N' AND p.Processed='Y'"
			+ " AND p.C_Charge_ID IS NULL"		//	Prepayments OK
			+ " AND p.C_BPartner_ID=?");                   		//      #3
		if (!isMultiCurrencySelected)
			sql.append(" AND p.C_Currency_ID=?");				//      #4
		sql.append(" ORDER BY p.DateTrx,p.DocumentNo");
		
		sql = new StringBuffer( role.addAccessSQL( sql.toString(), "p", MRole.SQL_FULLYQUALIFIED, MRole.SQL_RO ) );
		
		log.fine("PaySQL=" + sql.toString());
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
			/*
			pstmt.setInt(1, m_C_Currency_ID);
			pstmt.setInt(2, m_C_Currency_ID);
			pstmt.setInt(3, m_C_BPartner_ID);
			if (!multiCurrency.isSelected())
				pstmt.setInt(4, m_C_Currency_ID);
				*/
			pstmt.setInt(1, m_C_BPartner_ID);
			if (!isMultiCurrencySelected)
				pstmt.setInt(2, m_C_Currency_ID);
			ResultSet rs = pstmt.executeQuery();
			while (rs.next())
			{
                count++;
                if (count == 1 && form.getMatchFromCurrentId() <= 0) {
//                    form.setMatchFromCurrentId(rs.getInt(1));
//                    form.setMatchFromCurrentLine(rs.getInt(7));
//                    form.setMatchFromCurrentBusinessPartnerId(rs.getInt(5));
                }

                data = new HashMap < String, Object > ();
                // Row Type
                if ((count % 2) == 0) {
                	data.put("RowType", "even");
                } else {
                	data.put("RowType", "odd");
                }
                // ID
		        data.put("ID", index);       //  position of the current entry
		        index++;
                // Date
                data.put("Date", wsc.dateFormat.format(rs.getTimestamp(1)));
                // Document Number
                data.put("DocumentNo", rs.getString(2));
                data.put("PaymentID", rs.getString(3));
				if (isMultiCurrencySelected)
				{
					data.put("TrxCurrency", rs.getString(4));
					data.put("Amount", rs.getBigDecimal(5));
				}
                // Business Partner Name
                data.put("ConvertedAmount", rs.getBigDecimal(6));
				BigDecimal available = rs.getBigDecimal(7);
				if (available == null || available.signum() == 0)	//	nothing available
					continue;
				data.put("OpenAmt", available);				//  4/6-ConvOpen/Available
				data.put("AppliedAmt", Env.ZERO);					//  5/7-Payment
                dataList.add(data);
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql.toString(), e);
		}

        form.setMatchFromDataList(dataList);
    }   //  cmd_search

    /**
     * Search To.
     * @param wsc context
     * @param form Action From
     */
    private void searchTo(
            final WebSessionCtx wsc,
            final AllocationForm form) {
    	
    	int m_C_Currency_ID = StringToIntConverter.StringToInt(form.getCurrency());
    	int m_C_BPartner_ID = form.getBusinessPartnerId();
    	int AD_Role_ID = wsc.ctx.getAD_Role_ID();
    	int AD_User_ID = wsc.ctx.getAD_User_ID();
    	MRole role = MRole.get( wsc.ctx, AD_Role_ID, AD_User_ID, false); 
    	boolean isMultiCurrencySelected = Constants.ON.equals(form.getMultiCurrency());
    	int index = 1; // position 0 is used to store column names.
    	
        ArrayList < HashMap > dataList = new ArrayList < HashMap > ();
        HashMap < String, Object > data = new HashMap < String, Object > ();
        int count = 0;
		//  Date
        Timestamp date = null;
		if (!StringUtils.isEmpty(form.getDate()))
		{
			try{
				
				try{
					date = new Timestamp(wsc.dateFormat.parse(form.getDate()).getTime());
				}catch (Exception e){
					date = null;
				}
			}catch(Exception e){
				;
			}
		}else{
			date = new Timestamp(new Date().getTime());
		}
    	
		/********************************
		 *  Load unpaid Invoices
		 *      1-TrxDate, 2-Value, (3-Currency, 4-InvAmt,)
		 *      5-ConvAmt, 6-ConvOpen, 7-ConvDisc, 8-WriteOff, 9-Applied
		 * 
		 SELECT i.DateInvoiced,i.DocumentNo,i.C_Invoice_ID,c.ISO_Code,
		 i.GrandTotal*i.MultiplierAP "GrandTotal", 
		 currencyConvert(i.GrandTotal*i.MultiplierAP,i.C_Currency_ID,i.C_Currency_ID,i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID) "GrandTotal $", 
		 invoiceOpen(C_Invoice_ID,C_InvoicePaySchedule_ID) "Open",
		 currencyConvert(invoiceOpen(C_Invoice_ID,C_InvoicePaySchedule_ID),i.C_Currency_ID,i.C_Currency_ID,i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*i.MultiplierAP "Open $", 
		 invoiceDiscount(i.C_Invoice_ID,SysDate,C_InvoicePaySchedule_ID) "Discount",
		 currencyConvert(invoiceDiscount(i.C_Invoice_ID,SysDate,C_InvoicePaySchedule_ID),i.C_Currency_ID,i.C_Currency_ID,i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*i.Multiplier*i.MultiplierAP "Discount $",
		 i.MultiplierAP, i.Multiplier 
		 FROM C_Invoice_v i INNER JOIN C_Currency c ON (i.C_Currency_ID=c.C_Currency_ID) 
		 WHERE -- i.IsPaid='N' AND i.Processed='Y' AND i.C_BPartner_ID=1000001
		 */
        StringBuffer sql = new StringBuffer("SELECT i.DateInvoiced,i.DocumentNo,i.C_Invoice_ID," //  1..3
			+ "c.ISO_Code,i.GrandTotal*i.MultiplierAP, "                            //  4..5    Orig Currency
			/*//jz
			+ "currencyConvert(i.GrandTotal*i.MultiplierAP,i.C_Currency_ID,?,i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID), " //  6   #1  Converted
			+ "currencyConvert(invoiceOpen(C_Invoice_ID,C_InvoicePaySchedule_ID),i.C_Currency_ID,?,i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*i.MultiplierAP, "  //  7   #2  Converted Open
			+ "currencyConvert(invoiceDiscount"                               //  8       AllowedDiscount
			+ "(i.C_Invoice_ID,?,C_InvoicePaySchedule_ID),i.C_Currency_ID,?,i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*i.Multiplier*i.MultiplierAP,"               //  #3, #4
			*/
			+ "currencyConvert(i.GrandTotal*i.MultiplierAP,i.C_Currency_ID," + m_C_Currency_ID + ",i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID), " //  6   #1  Converted
			+ "currencyConvert(invoiceOpen(C_Invoice_ID,C_InvoicePaySchedule_ID),i.C_Currency_ID," + m_C_Currency_ID + ",i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*i.MultiplierAP, "  //  7   #2  Converted Open
			+ "currencyConvert(invoiceDiscount"                               //  8       AllowedDiscount
			+ "(i.C_Invoice_ID," + DB.TO_DATE(date) + ",C_InvoicePaySchedule_ID),i.C_Currency_ID," + m_C_Currency_ID + ",i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*i.Multiplier*i.MultiplierAP,"               //  #3, #4
			+ "i.MultiplierAP "
			+ "FROM C_Invoice_v i"		//  corrected for CM/Split
			+ " INNER JOIN C_Currency c ON (i.C_Currency_ID=c.C_Currency_ID) "
			+ "WHERE i.IsPaid='N' AND i.Processed='Y'"
			+ " AND i.C_BPartner_ID=?");                                            //  #5
		if (!isMultiCurrencySelected)
			sql.append(" AND i.C_Currency_ID=?");                                   //  #6
		sql.append(" ORDER BY i.DateInvoiced, i.DocumentNo");

		sql = new StringBuffer( role.addAccessSQL( sql.toString(), "i", MRole.SQL_FULLYQUALIFIED, MRole.SQL_RO ) );
		
		log.fine("InvSQL=" + sql.toString());
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
			/*//jz
			pstmt.setInt(1, m_C_Currency_ID);
			pstmt.setInt(2, m_C_Currency_ID);
			pstmt.setTimestamp(3, (Timestamp)dateField.getValue());
			pstmt.setInt(4, m_C_Currency_ID);
			pstmt.setInt(5, m_C_BPartner_ID);
			if (!multiCurrency.isSelected())
				pstmt.setInt(6, m_C_Currency_ID);
				*/
			pstmt.setInt(1, m_C_BPartner_ID);
			if (!isMultiCurrencySelected)
				pstmt.setInt(2, m_C_Currency_ID);
			ResultSet rs = pstmt.executeQuery();
			while (rs.next())
			{
				data = new HashMap < String, Object > ();
				count++; 
		        // Row Type
		        if ((count % 2) == 0) {
		        	data.put("RowType", "even");
		        } else {
		        	data.put("RowType", "odd");
		        }
				//data.put(new Boolean(false));       //  0-Selection
		        data.put("ID", index);       //  position of the current entry
		        index++;
				data.put("Date", rs.getTimestamp(1));//  1-TrxDate
                // Document Number
                data.put("DocumentNo", rs.getString(2)); //  2-Value
                data.put("InvoiceID", rs.getString(3));
				if (isMultiCurrencySelected)
				{
					data.put("TrxCurrency", rs.getString(4));//  3-Currency
					data.put("Amount", rs.getBigDecimal(5));//  4-Orig Amount
				}
				data.put("ConvertedAmount", rs.getBigDecimal(6));//  3/5-ConvAmt				
				BigDecimal open = rs.getBigDecimal(7);
				if (open == null)		//	no conversion rate
					open = Env.ZERO;
				data.put("OpenAmt", open);//  4/6-ConvOpen
				BigDecimal discount = rs.getBigDecimal(8);
				if (discount == null)	//	no concersion rate
					discount = Env.ZERO;
				data.put("Discount", discount);//  5/7-ConvAllowedDisc
				data.put("WriteOff", Env.ZERO);//  6/8-WriteOff
				data.put("AppliedAmt", Env.ZERO);//  6/8-WriteOff
//				line.add(rs.getBigDecimal(9));		//	8/10-Multiplier
				//	Add when open <> 0 (i.e. not if no conversion rate)
				if (Env.ZERO.compareTo(open) != 0)
					dataList.add(data);
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql.toString(), e);
		}

        form.setMatchToDataList(dataList);
        
//        String [] ids = form.getMatchToIdList();
//        double matching = 0;
//        if (ids != null && ids.length != 0) {
//            for ( int i = 0; i < ids.length; i++ ) {
//                String [] id = ids[i].split("\\|");
//                if (form.getMatchMode() == 0) {
//                    matching += Double.parseDouble(id[3]);
//                }
//                matching -= Double.parseDouble(id[4]);
//            }
//            form.setProcessButtonDisabled("false");
//        } else {
//            form.setProcessButtonDisabled("true");
//        }
//
//        form.setMatchingCount(wsc.numberFormat.format(matching));
//        form.setMatchDifferenceCount(wsc.numberFormat.format(qty-matching));
    }   //  seachTo

    /**
     *  Create Matching Record
     *  @param wsc context
     *  @param invoice true if matching invoice false if matching PO
     *  @param M_InOutLine_ID shipment line
     *  @param Line_ID C_InvoiceLine_ID or C_OrderLine_ID
     *  @param qty quantity
     *  @return true if created
     */
    private boolean createMatchRecord (
            WebSessionCtx wsc,
            boolean invoice,
            int M_InOutLine_ID,
            int Line_ID,
            BigDecimal qty) {

        if (qty.compareTo(Env.ZERO) == 0)
            return true;

        log.fine("IsInvoice=" + invoice
            + ", M_InOutLine_ID=" + M_InOutLine_ID + ", Line_ID=" + Line_ID
            + ", Qty=" + qty);

        //
        boolean success = false;
        MInOutLine sLine = new MInOutLine (wsc.ctx, M_InOutLine_ID, null);
        if (invoice) {    //  Shipment - Invoice
            //  Update Invoice Line
            MInvoiceLine iLine = new MInvoiceLine (wsc.ctx, Line_ID, null);
            iLine.setM_InOutLine_ID(M_InOutLine_ID);
            if (sLine.getC_OrderLine_ID() != 0)
                iLine.setC_OrderLine_ID(sLine.getC_OrderLine_ID());
            iLine.save();
            //  Create Shipment - Invoice Link
            if (iLine.getM_Product_ID() != 0) {
                MMatchInv match = new MMatchInv (iLine, null, qty);
                match.setM_InOutLine_ID(M_InOutLine_ID);
                if (match.save())
                    success = true;
                else
                    log.log(Level.SEVERE, "Inv Match not created: " + match);
            } else {
                success = true;
            }

            //  Create PO - Invoice Link = corrects PO
            if (iLine.getC_OrderLine_ID() != 0 && iLine.getM_Product_ID() != 0)
            {
                MMatchPO matchPO = MMatchPO.create(iLine, sLine, null, qty);
                matchPO.setC_InvoiceLine_ID(iLine);
                matchPO.setM_InOutLine_ID(M_InOutLine_ID);
                if (!matchPO.save()) {
                    log.log(Level.SEVERE, "PO(Inv) Match not created: " + matchPO);
                }
            }
        } else {   //  Shipment - Order
            //  Update Shipment Line
            sLine.setC_OrderLine_ID(Line_ID);
            sLine.save();
            //  Update Order Line
            MOrderLine oLine = new MOrderLine(wsc.ctx, Line_ID, null);
            if (oLine.get_ID() != 0) {   //  other in MInOut.completeIt
                oLine.setQtyReserved(oLine.getQtyReserved().subtract(qty));
                if(!oLine.save()) {
                    log.severe("QtyReserved not updated - C_OrderLine_ID=" + Line_ID);
                }
            }

            //  Create PO - Shipment Link
            if (sLine.getM_Product_ID() != 0) {
                MMatchPO match = new MMatchPO (sLine, null, qty);
                if (!match.save()) {
                    log.log(Level.SEVERE, "PO Match not created: " + match);
                } else {
                    success = true;
                    //  Correct Ordered Qty for Stocked Products (see MOrder.reserveStock / MInOut.processIt)
                    if (sLine.getProduct() != null && sLine.getProduct().isStocked()) {
                        success = MStorage.add(
                                wsc.ctx,
                                sLine.getM_Warehouse_ID(), 
                                sLine.getM_Locator_ID(), 
                                sLine.getM_Product_ID(), 
                                sLine.getM_AttributeSetInstance_ID(),
                                oLine.getM_AttributeSetInstance_ID(), 
                                null,
                                null,
                                qty.negate(),
                                null
                                );
                    }
                }
            }
            else
                success = true;
        }
        return success;
    }   //  createMatchRecord
    
	/**
	 *  Calculate Allocation info
	 */
	private void calculate (AllocationForm myForm, HttpServletRequest request,
            HttpServletResponse response, String[] response_array)
	{
		HttpSession session = request.getSession();
		WebSessionCtx wsc = WebSessionCtx.get(request); 
		
		//
		DecimalFormat format = DisplayType.getNumberFormat(DisplayType.Amount);
		Timestamp allocDate = null;

		ArrayList paymentList = (ArrayList)session.getAttribute(MATCH_FROM_DATA_LIST);
		ArrayList invoiceList = (ArrayList)session.getAttribute(MATCH_TO_DATA_LIST);	
		String [] selectedPaymentIds = myForm.getMatchFromIdList();
		String [] selectedInvoiceIds = myForm.getMatchToIdList();		
		
		HashMap < String, Object > currentPayment = (HashMap)paymentList.get(0);
		HashMap < String, Object > currentInvoice = (HashMap)invoiceList.get(0);
		
		boolean multiCurrency = false;
		if(Constants.ON.equals(myForm.getMultiCurrency())){
			multiCurrency = true;
		}

		//  Payment
		BigDecimal totalPay = new BigDecimal(0.0);
		int rows = 0;
		if(myForm.getMatchFromIdList()!=null){
			rows = myForm.getMatchFromIdList().length;
		}
		int m_noPayments = 0;
		for (int i = 0; i < rows; i++)
		{
			String index = selectedPaymentIds[i];
			currentPayment = (HashMap)paymentList.get(StringToIntConverter.StringToInt(index));

			Timestamp ts = null;
			try{
				ts = new Timestamp((wsc.dateFormat.parse(currentPayment.get("Date").toString())).getTime());	
			}catch(Exception e){
				;
			}
			
			allocDate = TimeUtil.max(allocDate, ts);
			BigDecimal bd = BigDecimal.valueOf(0);
			bd = (BigDecimal)currentPayment.get("OpenAmt");
			
			totalPay = totalPay.add(bd);  //  Applied Pay
			m_noPayments++;
		
		}

		//  Invoices
		BigDecimal totalInv = new BigDecimal(0.0);
		rows = 0;
		if(myForm.getMatchToIdList()!=null){
			rows = myForm.getMatchToIdList().length;
		}
		int m_noInvoices = 0;
		
		for (int i = 0; i < rows; i++)
		{
			String index = selectedInvoiceIds[i];
			currentInvoice = (HashMap)invoiceList.get(StringToIntConverter.StringToInt(index));

			Timestamp ts = null;
			try{
				ts = new Timestamp((wsc.dateFormat.parse(currentPayment.get("Date").toString())).getTime());	
			}catch(Exception e){
				;
			}
			allocDate = TimeUtil.max(allocDate, ts);
			BigDecimal bd = (BigDecimal)currentInvoice.get("OpenAmt");			
			totalInv = totalInv.add(bd);  //  Applied Inv
			m_noInvoices++;
		
		}

		//	Set AllocationDate
		if (allocDate != null)
			session.setAttribute(ALLOCATE_DATE, allocDate);
		//  Set Allocation Currency
//		allocCurrencyLabel.setText(currencyPick.getDisplay());
		//  Difference
		BigDecimal difference = totalPay.subtract(totalInv);
//		differenceField.setText(format.format(difference));
		String enableAllocateButton = "";
		if (difference.compareTo(new BigDecimal(0.0)) == 0)
			enableAllocateButton = Constants.ENABLED;
		else
			enableAllocateButton = Constants.DISABLED;
		
		if(selectedPaymentIds==null && selectedInvoiceIds ==null){
			enableAllocateButton = Constants.DISABLED;
		}
		
		response_array[0] = enableAllocateButton;
		response_array[1] = difference.toString();
		response_array[2] = String.valueOf(m_noPayments) + " - "
			+ Msg.getMsg(wsc.ctx, "Sum") + "  " + format.format(totalPay) + " ";
		response_array[3] = String.valueOf(m_noInvoices) + " - "
			+ Msg.getMsg(wsc.ctx, "Sum") + "  " + format.format(totalInv) + " ";
	}   //  calculate

	/**************************************************************************
	 *  Save Data
	 */
	private void saveData(HttpServletRequest request, AllocationForm myForm)
	{
		HttpSession session = request.getSession();
		WebSessionCtx wsc = WebSessionCtx.get(request);
		ArrayList paymentListAll = (ArrayList)session.getAttribute(MATCH_FROM_DATA_LIST);
		ArrayList invoiceListAll = (ArrayList)session.getAttribute(MATCH_TO_DATA_LIST);	
		String [] selectedPaymentIds = myForm.getMatchFromIdList();
		String [] selectedInvoiceIds = myForm.getMatchToIdList();		
		
		int m_noPayments = 0;
		int m_noInvoices = 0;
		
		if(selectedPaymentIds!=null){
			m_noPayments += selectedPaymentIds.length;
		}
		
		if(selectedInvoiceIds!=null){
			m_noInvoices += selectedInvoiceIds.length;
		}
		
		//  fixed fields
		int AD_Client_ID = wsc.ctx.getAD_Client_ID();
		int AD_Org_ID = wsc.ctx.getAD_Org_ID();
		int C_BPartner_ID = myForm.getBusinessPartnerId();
		int C_Order_ID = 0;
		int C_CashLine_ID = 0;
		Timestamp DateTrx = (Timestamp)session.getAttribute(ALLOCATE_DATE);
		int C_Currency_ID = StringToIntConverter.StringToInt(myForm.getCurrency());	//	the allocation currency
		//
		if (AD_Org_ID == 0)
		{
			Ctx ctx = wsc.ctx;
			StringBuffer out = new StringBuffer();
			String AD_Message = "Org0NotAllowed";
			if (AD_Message != null && !AD_Message.equals(""))
				out.append(Msg.getMsg(ctx, AD_Message));
			request.setAttribute(Constants.WARNING_INFO, out.toString());
			return;
		}
		//
		log.config("Client=" + AD_Client_ID + ", Org=" + AD_Org_ID
			+ ", BPartner=" + C_BPartner_ID + ", Date=" + DateTrx);
		
		Trx trx = Trx.get(Trx.createTrxName("AL"), true);

		/**
		 * Generation of allocations:               amount/discount/writeOff
		 *  - if there is one payment -- one line per invoice is generated
		 *    with both the Invoice and Payment reference
		 *      Pay=80  Inv=100 Disc=10 WOff=10 =>  80/10/10    Pay#1   Inv#1
		 *    or
		 *      Pay=160 Inv=100 Disc=10 WOff=10 =>  80/10/10    Pay#1   Inv#1
		 *      Pay=160 Inv=100 Disc=10 WOff=10 =>  80/10/10    Pay#1   Inv#2
		 *
		 *  - if there are multiple payment lines -- the amounts are allocated
		 *    starting with the first payment and payment
		 *      Pay=60  Inv=100 Disc=10 WOff=10 =>  60/10/10    Pay#1   Inv#1
		 *      Pay=100 Inv=100 Disc=10 WOff=10 =>  20/0/0      Pay#2   Inv#1
		 *      Pay=100 Inv=100 Disc=10 WOff=10 =>  80/10/10    Pay#2   Inv#2
		 *
		 *  - if you apply a credit memo to an invoice
		 *              Inv=10  Disc=0  WOff=0  =>  10/0/0              Inv#1
		 *              Inv=-10 Disc=0  WOff=0  =>  -10/0/0             Inv#2
		 *
		 *  - if you want to write off a (partial) invoice without applying,
		 *    enter zero in applied
		 *              Inv=10  Disc=1  WOff=9  =>  0/1/9               Inv#1
		 *  Issues
		 *  - you cannot write-off a payment
		 */

		//  Payment - Loop and add them to paymentList/amountList
		ArrayList<Integer> paymentList = new ArrayList<Integer>(m_noPayments);
		ArrayList<BigDecimal> amountList = new ArrayList<BigDecimal>(m_noPayments);
		BigDecimal paymentAppliedAmt = Env.ZERO;
		for (int i = 0; i < m_noPayments; i++)
		{
			String index = selectedPaymentIds[i];
			HashMap < String, Object > currentPayment = (HashMap)paymentListAll.get(StringToIntConverter.StringToInt(index));
			//  Payment line is selected

			Integer C_Payment_ID = StringToIntConverter.StringToInt((String)currentPayment.get("PaymentID"));
			paymentList.add(C_Payment_ID);
			//
			BigDecimal PaymentAmt = (BigDecimal)currentPayment.get("AppliedAmt");  //  Applied Payment
			amountList.add(PaymentAmt);
			//
			paymentAppliedAmt = paymentAppliedAmt.add(PaymentAmt);
			//
			log.fine("C_Payment_ID=" + C_Payment_ID 
					+ " - PaymentAmt=" + PaymentAmt); // + " * " + Multiplier + " = " + PaymentAmtAbs);

		}

		//  Invoices - Loop and generate alloctions
		int iRows = selectedInvoiceIds.length;
		BigDecimal totalAppliedAmt = Env.ZERO;
		
		//	Create Allocation - but don't save yet
		MAllocationHdr alloc = new MAllocationHdr (wsc.ctx, true,	//	manual
				DateTrx, C_Currency_ID, wsc.ctx.getContext("#AD_User_Name"), trx.getTrxName());
		alloc.setAD_Org_ID(AD_Org_ID);
		
		//	For all invoices
		int invoiceLines = 0;
		for (int i = 0; i < iRows; i++)
		{
			//  Invoice line is selected
			String index = selectedInvoiceIds[i];
			HashMap < String, Object > currentInvoice = (HashMap)invoiceListAll.get(StringToIntConverter.StringToInt(index));
			invoiceLines++;
			int C_Invoice_ID = StringToIntConverter.StringToInt((String)currentInvoice.get("InvoiceID"));
			BigDecimal AppliedAmt = (BigDecimal)currentInvoice.get("AppliedAmt");
			//  semi-fixed fields (reset after first invoice)
			BigDecimal DiscountAmt = (BigDecimal)currentInvoice.get("Discount");
			BigDecimal WriteOffAmt = (BigDecimal)currentInvoice.get("WriteOff");
			//	OverUnderAmt needs to be in Allocation Currency
			BigDecimal OverUnderAmt = ((BigDecimal)currentInvoice.get("OpenAmt"))
			.subtract(AppliedAmt).subtract(DiscountAmt).subtract(WriteOffAmt);

			log.config("Invoice #" + i + " - AppliedAmt=" + AppliedAmt);// + " -> " + AppliedAbs);
			//  loop through all payments until invoice applied
			int noPayments = 0;
			for (int j = 0; j < paymentList.size() && AppliedAmt.signum() != 0; j++)
			{
				int C_Payment_ID = ((Integer)paymentList.get(j)).intValue();
				BigDecimal PaymentAmt = (BigDecimal)amountList.get(j);
				if (PaymentAmt.signum() != 0)
				{
					log.config(".. with payment #" + j + ", Amt=" + PaymentAmt);
					noPayments++;
					//  use Invoice Applied Amt
					BigDecimal amount = AppliedAmt;
					log.fine("C_Payment_ID=" + C_Payment_ID + ", C_Invoice_ID=" + C_Invoice_ID
							+ ", Amount=" + amount + ", Discount=" + DiscountAmt + ", WriteOff=" + WriteOffAmt);

					//	Allocation Header
					if (alloc.get_ID() == 0 && !alloc.save())
					{
						log.log(Level.SEVERE, "Allocation not created");
						return;
					}
					//	Allocation Line
					MAllocationLine aLine = new MAllocationLine (alloc, amount, 
							DiscountAmt, WriteOffAmt, OverUnderAmt);
					aLine.setDocInfo(C_BPartner_ID, C_Order_ID, C_Invoice_ID);
					aLine.setPaymentInfo(C_Payment_ID, C_CashLine_ID);
					if (!aLine.save())
						log.log(Level.SEVERE, "Allocation Line not written - Invoice=" + C_Invoice_ID);

					//  Apply Discounts and WriteOff only first time
					DiscountAmt = Env.ZERO;
					WriteOffAmt = Env.ZERO;
					//  subtract amount from Payment/Invoice
					AppliedAmt = AppliedAmt.subtract(amount);
					PaymentAmt = PaymentAmt.subtract(amount);
					log.fine("Allocation Amount=" + amount + " - Remaining  Applied=" + AppliedAmt + ", Payment=" + PaymentAmt);
					amountList.set(j, PaymentAmt);  //  update
				}	//	for all applied amounts
			}	//	noop through payments for invoice

			//  No Payments allocated and none existing (e.g. Inv/CM)
			if (noPayments == 0 && paymentList.size() == 0)
			{
				int C_Payment_ID = 0;
				log.config(" ... no payment - TotalApplied=" + totalAppliedAmt);
				//  Create Allocation
				log.fine("C_Payment_ID=" + C_Payment_ID + ", C_Invoice_ID=" + C_Invoice_ID
						+ ", Amount=" + AppliedAmt + ", Discount=" + DiscountAmt + ", WriteOff=" + WriteOffAmt);

				//	Allocation Header
				if (alloc.get_ID() == 0 && !alloc.save())
				{
					log.log(Level.SEVERE, "Allocation not created");
					return;
				}
				//	Allocation Line
				MAllocationLine aLine = new MAllocationLine (alloc, AppliedAmt, 
						DiscountAmt, WriteOffAmt, OverUnderAmt);
				aLine.setDocInfo(C_BPartner_ID, C_Order_ID, C_Invoice_ID);
				aLine.setPaymentInfo(C_Payment_ID, C_CashLine_ID);
				if (!aLine.save(trx.getTrxName()))
					log.log(Level.SEVERE, "Allocation Line not written - Invoice=" + C_Invoice_ID);

				log.fine("Allocation Amount=" + AppliedAmt);
			}
			totalAppliedAmt = totalAppliedAmt.add(AppliedAmt);
			log.config("TotalRemaining=" + totalAppliedAmt);
		}   //  invoice loop

		
		//	Only Payments and total of 0 (e.g. Payment/Reversal)
		if (invoiceLines == 0 && paymentList.size() > 0 
			&& paymentAppliedAmt.signum() == 0)
		{
			for (int i = 0; i < paymentList.size(); i++)
			{
				int C_Payment_ID = ((Integer)paymentList.get(i)).intValue();
				BigDecimal PaymentAmt = (BigDecimal)amountList.get(i);
			//	BigDecimal PaymentMultiplier = (BigDecimal)multiplierList.get(i);
			//	BigDecimal PaymentAbs = PaymentAmt.multiply(PaymentMultiplier);
				log.fine("Payment=" + C_Payment_ID  
						+ ", Amount=" + PaymentAmt);// + ", Abs=" + PaymentAbs);

				//	Allocation Header
				if (alloc.get_ID() == 0 && !alloc.save())
				{
					log.log(Level.SEVERE, "Allocation not created");
					return;
				}
				//	Allocation Line
				MAllocationLine aLine = new MAllocationLine (alloc, PaymentAmt, 
					Env.ZERO, Env.ZERO, Env.ZERO);
				aLine.setDocInfo(C_BPartner_ID, 0, 0);
				aLine.setPaymentInfo(C_Payment_ID, 0);
				if (!aLine.save(trx.getTrxName()))
					log.log(Level.SEVERE, "Allocation Line not saved - Payment=" + C_Payment_ID);
			}
		}	//	onlyPayments
		
		
		if (totalAppliedAmt.signum() != 0)
			log.log(Level.SEVERE, "Remaining TotalAppliedAmt=" + totalAppliedAmt);

		//	Should start WF
		if (alloc.get_ID() != 0)
		{
			alloc.processIt(DocAction.ACTION_Complete);
			alloc.save();
		}
		
		//  Test/Set IsPaid for Invoice - requires that allocation is posted
		for (int i = 0; i < iRows; i++)
		{
			//  Invoice line is selected
			String index = selectedInvoiceIds[i];
			HashMap < String, Object > currentInvoice = (HashMap)invoiceListAll.get(StringToIntConverter.StringToInt(index));
			invoiceLines++;
			int C_Invoice_ID = StringToIntConverter.StringToInt((String)currentInvoice.get("InvoiceID"));
			String sql = "SELECT invoiceOpen(C_Invoice_ID, 0) "
				+ "FROM C_Invoice WHERE C_Invoice_ID=?";
			BigDecimal open = DB.getSQLValueBD(trx.getTrxName(), sql, C_Invoice_ID);
			if (open != null && open.signum() == 0)
			{
				sql = "UPDATE C_Invoice SET IsPaid='Y' "
					+ "WHERE C_Invoice_ID=" + C_Invoice_ID;
				int no = DB.executeUpdate(sql, trx.getTrxName());
				log.config("Invoice #" + i + " is paid");
			}
			else
				log.config("Invoice #" + i + " is not paid - " + open);
		}
		//  Test/Set Payment is fully allocated
		for (int i = 0; i < paymentList.size(); i++)
		{
			int C_Payment_ID = ((Integer)paymentList.get(i)).intValue();
			MPayment pay = new MPayment (wsc.ctx, C_Payment_ID, trx.getTrxName());
			if (pay.testAllocation())
				pay.save();
			log.config("Payment #" + i + (pay.isAllocated() ? " not" : " is") 
				+ " fully allocated");
		}
		paymentList.clear();
		amountList.clear();
		trx.commit();
		trx.close();
	}   //  saveData	
	
	public static void setResponse(HttpServletResponse response, String[] response_array){
		response.addHeader("pragma", "no-store,no-cache");//HTTP 1.0
	    response.addHeader("cache-control", "no-cache, no-store,must-revalidate, max-age=-1"); // HTTP 1.1
	    response.addHeader("expires", "-1");
		try {
			response.getOutputStream().print(generateResponseText(response_array));
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public static String generateResponseText(String[] arr) throws UnsupportedEncodingException{
		String resp_arr = "";
		String split_arr = "**";
		for(int i=0; i<arr.length; i++ ){
			if(i!=0){
				resp_arr += "**";
			}
			if(!StringUtils.isEmpty(arr[i])){				
				resp_arr+= arr[i];
			}
		}			
		return URLEncoder.encode(resp_arr, "UTF-8");
	}
	
	public static void selectUnselectPayment(HttpServletRequest request, AllocationForm myForm, int index, String[] response_array){
		HttpSession session = request.getSession();
		WebSessionCtx wsc = WebSessionCtx.get(request);
		ArrayList paymentListAll = (ArrayList)session.getAttribute(MATCH_FROM_DATA_LIST);
		String [] selectedPaymentIds = myForm.getMatchFromIdList();
		
		HashMap < String, Object > currentPayment = (HashMap)paymentListAll.get(index);
		
		boolean isSelected =  false;
		if(selectedPaymentIds!=null){
			for(int i=0; i < selectedPaymentIds.length; i++){
				if(String.valueOf(index).equals(selectedPaymentIds[i])){
					isSelected = true;
					break;
				}
			}
		}
		//  selected - set payment amount
		if (isSelected)
		{
			BigDecimal amount = (BigDecimal)currentPayment.get("OpenAmt");   //  Open Amount
			currentPayment.put("AppliedAmt", amount);
		}
		else    //  de-selected
			currentPayment.put("AppliedAmt",Env.ZERO);
		
		response_array[4] = "paymentAppliedAmt" + index + "," 
			+ (BigDecimal)currentPayment.get("AppliedAmt");
	}
	
	public static void selectUnselectInvoice(HttpServletRequest request, AllocationForm myForm, 
			int index, String[] response_array){
		HttpSession session = request.getSession();
		WebSessionCtx wsc = WebSessionCtx.get(request);
		ArrayList invoiceListAll = (ArrayList)session.getAttribute(MATCH_TO_DATA_LIST);
		String [] selectedInvoiceIds = myForm.getMatchToIdList();
		
		HashMap < String, Object > currentInvoice = (HashMap)invoiceListAll.get(index);
		
		boolean isSelected =  false;
		if(selectedInvoiceIds!=null){
			for(int i=0; i < selectedInvoiceIds.length; i++){
				if(String.valueOf(index).equals(selectedInvoiceIds[i])){
					isSelected = true;
					break;
				}
			}
		}

		//  selected - set applied amount
		if (isSelected)
		{
			BigDecimal amount = (BigDecimal)currentInvoice.get("OpenAmt");    //  Open Amount
			amount = amount.subtract((BigDecimal)currentInvoice.get("Discount"));
			currentInvoice.put("WriteOff", Env.ZERO);     //  to be sure
			currentInvoice.put("AppliedAmt", amount);
		}
		else    //  de-selected
		{
			currentInvoice.put("WriteOff", Env.ZERO);     //  to be sure
			currentInvoice.put("AppliedAmt", Env.ZERO);
		}
		response_array[5] = "invoiceDiscount" + index + "," 
			+ (BigDecimal)currentInvoice.get("Discount");
		response_array[6] = "invoiceWriteOff" + index + "," 
			+ (BigDecimal)currentInvoice.get("WriteOff");
		response_array[7] = "invoiceAppliedAmt" + index + "," 
			+ (BigDecimal)currentInvoice.get("AppliedAmt");
	}	
	
	public static void autoWriteOff(HttpServletRequest request, AllocationForm myForm, 
			int index, String[] response_array){
		HttpSession session = request.getSession();
		WebSessionCtx wsc = WebSessionCtx.get(request);
		ArrayList invoiceListAll = (ArrayList)session.getAttribute(MATCH_TO_DATA_LIST);
		String [] selectedInvoiceIds = myForm.getMatchToIdList();
		
		HashMap < String, Object > currentInvoice = (HashMap)invoiceListAll.get(index);
		
		boolean isSelected =  false;
		if(selectedInvoiceIds!=null){
			for(int i=0; i < selectedInvoiceIds.length; i++){
				if(String.valueOf(index).equals(selectedInvoiceIds[i])){
					isSelected = true;
					break;
				}
			}
		}

//		if (Constants.ON.equals(myForm.getIsAutoWriteOffEnabled()))
//		{
//			TableModel invoice = invoiceTable.getModel();
//			//  if applied entered, adjust writeOff
//			if (col == i_applied)
//			{
//				BigDecimal openAmount = (BigDecimal)invoice.getValueAt(row, i_open);    //  Open Amount
//				BigDecimal amount = openAmount.subtract((BigDecimal)invoice.getValueAt(row, i_discount));
//				amount = amount.subtract((BigDecimal)invoice.getValueAt(row, i_applied));
//				invoice.setValueAt(amount, row, i_writeOff);
//				//	Warning if > 30%
//				if (amount.doubleValue()/openAmount.doubleValue() > .30)
//					ADialog.warn(m_WindowNo, this, "AllocationWriteOffWarn");
//			}
//			else    //  adjust applied
//			{
//				BigDecimal amount = (BigDecimal)invoice.getValueAt(row, i_open);    //  Open Amount
////				amount = amount.subtract((BigDecimal)invoice.getValueAt(row, i_discount));
////				amount = amount.subtract((BigDecimal)invoice.getValueAt(row, i_writeOff));
//				amount = amount.subtract((BigDecimal.valueOf(100)));
//				amount = amount.subtract((BigDecimal)invoice.getValueAt(row, i_writeOff));
//				invoice.setValueAt(amount, row, i_applied);
//			}
//		}
		
		response_array[5] = "invoiceDiscount" + index + "," 
			+ (BigDecimal)currentInvoice.get("Discount");
		response_array[6] = "invoiceWriteOff" + index + "," 
			+ (BigDecimal)currentInvoice.get("WriteOff");
		response_array[7] = "invoiceAppliedAmt" + index + "," 
			+ (BigDecimal)currentInvoice.get("AppliedAmt");
	}

}
