package com.ampiere.web.struts.form;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MForm;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.WebSessionCtx;

import com.ampiere.util.Constants;
import com.ampiere.web.servlet.WWindowStatus;

/**
 * @author clmg
 */
public class ArchiveView extends Action {

    /** Logger. */
    private CLogger log = CLogger.getCLogger(this.getClass());    
    
    /** SUCCESS FORWARD. */
    private static final String SUCCESS = "success";

    /** Action Form. */
    private static final String ACTION_FORM = "ArchiveViewForm";

    /** Global Error Forward. */
    private static final String ERROR_FORWARD = "error";

    /** Form ID. */
    private static final int FORM_ID = 118;

    /**
     * Action execute.
     * @param mapping mapping
     * @param actionForm actionForm
     * @param request request
     * @param response response
     * @throws Exception Exception
     * @return ActionForward
     * @see org.apache.struts.action.Action#execute(
     *      org.apache.struts.action.ActionMapping,
     *      org.apache.struts.action.ActionForm,
     *      javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse)
     */
    public final ActionForward execute(
            final ActionMapping mapping,
            final ActionForm actionForm,
            final HttpServletRequest request,
            final HttpServletResponse response)
    throws Exception {
    	
        WebSessionCtx wscTest = WebSessionCtx.get(request); 
        if (wscTest == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute(Constants.SESSION_TIMEOUT_INFO, "Session Time Out. Please login again.");
            return mapping.findForward(Constants.SESSION_TIMEOUT);
        }

		String doQurey = "0";
		HttpSession session = request.getSession();
		
		WebSessionCtx wsc = WebSessionCtx.get(request); 
		WWindowStatus ws = WWindowStatus.get(request);
		if (wsc == null) {
			log.log(Level.SEVERE, "Session Time Out.");
			return mapping.findForward(ERROR_FORWARD);
		}

		MForm form = getForm(wsc.ctx, FORM_ID);
		wsc.ctx.setContext("FormName", form.getName());

		ArchiveViewForm archiveViewForm =
			(ArchiveViewForm) request.getAttribute(ACTION_FORM);
		if (archiveViewForm == null) {
			archiveViewForm = (ArchiveViewForm) actionForm;
			if (archiveViewForm == null) {
				archiveViewForm = new ArchiveViewForm();
			}
		}
		archiveViewForm.statInit(wsc.ctx);
	
		// Set search info form
		archiveViewForm.setTitle(Msg.getMsg(wsc.ctx, "Archive"));
		List processList = getProcessList(request);
		List tableList = getTableList(request);
		List userList = getUserList(request);
		
		session.setAttribute("processList", processList);
		session.setAttribute("tableList", tableList);
		session.setAttribute("userList", userList);		
		
		session.setAttribute(ACTION_FORM, archiveViewForm);	

		return mapping.findForward("success");
    }    
   
    /**
     *  Get Form from Form ID.
     *  @param ctx Properties
     *  @param formId Form ID
     *  @return form
     */
    private MForm getForm(final Ctx ctx, final int formId) {

        // Get Form from Form ID
        MForm form = new MForm(ctx, formId, null);
        
        boolean trl = !Env.isBaseLanguage(ctx, "AD_Form");
        if (trl) {
            String sql = "SELECT t.Name, t.Description, t.Help "
                       + "FROM AD_Form f INNER JOIN AD_Form_Trl t"
                       + " ON (f.AD_Form_ID=t.AD_Form_ID AND AD_Language=?)"
                       + "WHERE f.AD_Form_ID=?";
            try {
                PreparedStatement pstmt = DB.prepareStatement(sql, null);
                if (trl) {
                    pstmt.setString(1, Env.getAD_Language(ctx));
                    pstmt.setInt(2, formId);

                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next()) {
                        form.setName(rs.getString(1));
                        form.setDescription(rs.getString(2));
                        form.setHelp(rs.getString(3));
                    }
                    rs.close();
                    pstmt.close();
                }
            } catch (SQLException e) {
                log.log(Level.SEVERE, sql, e);
            }
        }

        return form;
    }   //  getForm

    /**
     * getProcessList
     * @param request
     * @return
     */
    private List<KeyNamePair> getProcessList(HttpServletRequest request){
		WebSessionCtx wsc = WebSessionCtx.get(request);
		List<KeyNamePair> keynameList = new ArrayList();
		int AD_Role_ID = wsc.ctx.getAD_Role_ID();
		//	Processes
		String sql = "SELECT DISTINCT p.AD_Process_ID, p.Name "
			+ "FROM AD_Process p INNER JOIN AD_Process_Access pa ON (p.AD_Process_ID=pa.AD_Process_ID) "
			+ "WHERE pa.AD_Role_ID=" + AD_Role_ID
			+ " AND p.IsReport='Y' AND p.IsActive='Y' AND pa.IsActive='Y' "
			+ "ORDER BY 2"; 
		KeyNamePair[] keynameArray = DB.getKeyNamePairs(sql, true);
		keynameList = Arrays.asList(keynameArray);
    	return keynameList;
    }

    /**
     * getTableList
     * @param request
     * @return
     */
    private List<KeyNamePair> getTableList(HttpServletRequest request){
		WebSessionCtx wsc = WebSessionCtx.get(request);
		int AD_Role_ID = wsc.ctx.getAD_Role_ID();
		List<KeyNamePair> tableList = new ArrayList();
		//	Tables
		String sql = "SELECT DISTINCT t.AD_Table_ID, t.Name "
			+ "FROM AD_Table t INNER JOIN AD_Tab tab ON (tab.AD_Table_ID=t.AD_Table_ID)"
			+ " INNER JOIN AD_Window_Access wa ON (tab.AD_Window_ID=wa.AD_Window_ID) "
			+ "WHERE wa.AD_Role_ID=" + AD_Role_ID
			+ " AND t.IsActive='Y' AND tab.IsActive='Y' "
			+ "ORDER BY 2";
		KeyNamePair[] keynameArray = DB.getKeyNamePairs(sql, true);
		tableList = Arrays.asList(keynameArray);
    	return tableList;
    }
    
    /**
     * getTableList
     * @param request
     * @return
     */
    private List<KeyNamePair> getUserList(HttpServletRequest request){
		WebSessionCtx wsc = WebSessionCtx.get(request);
		int AD_Role_ID = wsc.ctx.getAD_Role_ID();
		List<KeyNamePair> userList = new ArrayList();
		//	Internal Users
		String sql = "SELECT AD_User_ID, Name "
			+ "FROM AD_User u WHERE EXISTS "
				+"(SELECT * FROM AD_User_Roles ur WHERE u.AD_User_ID=ur.AD_User_ID) "
			+ "ORDER BY 2";
		KeyNamePair[] keynameArray = DB.getKeyNamePairs(sql, true);
		userList = Arrays.asList(keynameArray);
    	return userList;
    }
}
