package com.ampiere.web.struts.form;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.logging.Level;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MArchive;
import org.compiere.model.MBPartner;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.WebSessionCtx;

import com.ampiere.util.Constants;
import com.jware.util.StringToIntConverter;

/**
 * @author clmg
 */
public class ArchiveViewExportAction extends Action {

    /** Logger. */
    private CLogger log = CLogger.getCLogger(this.getClass());

    /** Action Form. */
    private static final String ACTION_FORM = "ArchiveViewForm";

    /** Global Error Forward. */
    private static final String ERROR_FORWARD = "error";

    private static final String ARICHIVES = "ARICHIVES";
    
    /** Form ID. */
    private static final int FORM_ID = 118;
	
    /**
     * Action execute.
     * @param mapping mapping
     * @param form form
     * @param request request
     * @param response response
     * @throws Exception Exception
     * @return ActionForward
     * @see org.apache.struts.action.Action#execute(
     *      org.apache.struts.action.ActionMapping,
     *      org.apache.struts.action.ActionForm,
     *      javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse)
     */
    public final ActionForward execute(
            final ActionMapping mapping,
            final ActionForm form,
            final HttpServletRequest request,
            final HttpServletResponse response)
    throws Exception {
    	
		//201001 
        WebSessionCtx wscTest = WebSessionCtx.get(request); 
        if (wscTest == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute(Constants.SESSION_TIMEOUT_INFO, "Session Time Out. Please login again.");
            return mapping.findForward(Constants.SESSION_TIMEOUT);
        }
        //--201001	 

    	HttpSession session = request.getSession();

        WebSessionCtx wsc = WebSessionCtx.get(request); 
        if (wsc == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        
        ArchiveViewForm archiveViewForm = (ArchiveViewForm)session.getAttribute(ACTION_FORM);
        if(archiveViewForm == null){
        	return null;
        }
        
        archiveViewForm.setTitle(Msg.getMsg(wsc.ctx, "Archive"));
        
        request.setAttribute(ACTION_FORM, archiveViewForm);
        
        {        	
        	try{
            	MArchive[] archives = cmd_query(request, archiveViewForm);
            	if(archives!=null && archives.length > 0){
            		int archiveIndex = StringToIntConverter.StringToInt(archiveViewForm.getArchiveIndex());
                    byte[] bytBuffer = archives[archiveIndex].getBinaryData();
                    createResponse(response, bytBuffer, archives[archiveIndex].getName());
            	}
        	}catch(Exception e){
        		return null;
        	}
        	
            return null;
        }


        //return mapping.findForward("success");
    }

	/**************************************************************************
	 * 	Create Query
	 */
	private MArchive[] cmd_query(HttpServletRequest request, ArchiveViewForm archiveViewForm)
	{
		WebSessionCtx wsc = WebSessionCtx.get(request);
		StringBuffer sql = new StringBuffer();
		boolean reports = Constants.ON.equals(archiveViewForm.getIsReport())?true:false;
		MRole role = MRole.getDefault(wsc.ctx,false);
		if (!role.isCanReport())
		{
			log.warning("User/Role cannot Report AD_User_ID=" + wsc.ctx.getAD_User_ID());
			return null;
		}
		sql.append(" AND IsReport=").append(reports ? "'Y'" : "'N'");
		
		//	Process
		if (reports)
		{
			if (StringToIntConverter.StringToInt(archiveViewForm.getProcess()) > 0)
				sql.append(" AND AD_Process_ID=").append(archiveViewForm.getProcess());
		}
		
		//	Table
		int m_AD_Table_ID = StringToIntConverter.StringToInt(archiveViewForm.getTable());
		int m_Record_ID = 0;
		if (m_AD_Table_ID > 0)
		{
			sql.append(" AND ((AD_Table_ID=").append(m_AD_Table_ID);
			if (m_Record_ID > 0)
				sql.append(" AND Record_ID=").append(m_Record_ID);
			sql.append(")");
			if (m_AD_Table_ID == MBPartner.Table_ID && m_Record_ID > 0)
				sql.append(" OR C_BPartner_ID=").append(m_Record_ID);
			sql.append(")");
			//	Reset for query
			m_AD_Table_ID = 0;
			m_Record_ID = 0;
		}
		else
		{
			if (m_AD_Table_ID > 0)
				sql.append(" AND AD_Table_ID=").append(m_AD_Table_ID);
		}
		
		//	Business Partner
		if (!reports)
		{
			String bpartnerId = archiveViewForm.getBpartnerId();
			if (!StringUtils.isEmpty(bpartnerId))
				sql.append(" AND C_BPartner_ID=").append(bpartnerId);
			else
				sql.append(" AND C_BPartner_ID IS NOT NULL");
		}
		
		//	Name
		String ss = archiveViewForm.getName();
		if (ss != null && ss.length() > 0)
		{
			if (ss.indexOf("%") != -1 || ss.indexOf("_") != -1)
				sql.append(" AND Name LIKE ").append(DB.TO_STRING(ss));
			else
				sql.append(" AND Name=").append(DB.TO_STRING(ss));
		}
		
		//	Description
		ss = archiveViewForm.getDescription();
		if (ss != null && ss.length() > 0)
		{
			if (ss.indexOf("%") != -1 || ss.indexOf("_") != -1)
				sql.append(" AND Description LIKE ").append(DB.TO_STRING(ss));
			else
				sql.append(" AND Description=").append(DB.TO_STRING(ss));
		}

		//	Help
		ss = archiveViewForm.getHelp();
		if (ss != null && ss.length() > 0)
		{
			if (ss.indexOf("%") != -1 || ss.indexOf("_") != -1)
				sql.append(" AND Help LIKE ").append(DB.TO_STRING(ss));
			else
				sql.append(" AND Help=").append(DB.TO_STRING(ss));
		}

		//	CreatedBy
		int userId = StringToIntConverter.StringToInt(archiveViewForm.getCreatedBy());
		if (userId > 0)
			sql.append(" AND CreatedBy=").append(userId);
		
		//	Created
		//  DateFrom
		String fDateFrom = archiveViewForm.getCreatedFrom();		
		if (!StringUtils.isEmpty(fDateFrom))
		{
			try{
				Timestamp from = null;
				try{
					from = new Timestamp(wsc.dateFormat.parse(fDateFrom).getTime());
				}catch (Exception e){
					from = null;
				}
				if (from != null)
					sql.append(" AND Created>=").append(DB.TO_DATE(from, true));
			}catch(Exception e){
				;
			}
		}
		//  DateTO
		String fDateTo = archiveViewForm.getCreatedTo();		
		if (!StringUtils.isEmpty(fDateTo))
		{
			try{
				Timestamp to = null;
				try{
					to = new Timestamp(wsc.dateFormat.parse(fDateTo).getTime());
				}catch (Exception e){
					to = null;
				}
				sql.append(" AND Created<").append(DB.TO_DATE(TimeUtil.addDays(to,1), true));
			}catch(Exception e){
				;
			}
		}
		
		log.fine(sql.toString());
		
		//	Process Access
		sql.append(" AND (AD_Process_ID IS NULL OR AD_Process_ID IN "
			+ "(SELECT AD_Process_ID FROM AD_Process_Access WHERE AD_Role_ID=")
			.append(role.getAD_Role_ID()).append("))");
		//	Table Access
		sql.append(" AND (AD_Table_ID IS NULL "
			+ "OR (AD_Table_ID IS NOT NULL AND AD_Process_ID IS NOT NULL) "	//	Menu Reports 
			+ "OR AD_Table_ID IN "
			+ "(SELECT t.AD_Table_ID FROM AD_Tab t"
			+ " INNER JOIN AD_Window_Access wa ON (t.AD_Window_ID=wa.AD_Window_ID) "
			+ "WHERE wa.AD_Role_ID=").append(role.getAD_Role_ID()).append("))");
		log.finest(sql.toString());
		//
		MArchive[] m_archives = MArchive.get(wsc.ctx, sql.toString());
		log.info("Length=" + m_archives.length);
		return m_archives;
	}	//	cmd_query
	
	
	public static void createResponse (HttpServletResponse response, 
			byte[] bytBuffer, String name) throws IOException
		{
			response.setHeader("Cache-Control", "no-cache");
	        response.setContentType("application/pdf");
	        response.setHeader("Content-Disposition", "attachement; filename=" + name + ".pdf");
	        response.setHeader("Content-Description", "File download for PDF.");

			//  print document
            ServletOutputStream ouputStream = response.getOutputStream();
            ouputStream.write(bytBuffer);
            ouputStream.flush();
            ouputStream.close();
		}   //  createResponse	
}
