package com.ampiere.web.struts.form;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MAttribute;
import org.compiere.model.MForm;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.WebSessionCtx;

import com.ampiere.util.Constants;
import com.ampiere.web.servlet.WWindowStatus;

/**
 * @author clmg
 */
public class AttributeGrid extends Action {

    /** Logger. */
    private CLogger log = CLogger.getCLogger(this.getClass());    
    
    /** SUCCESS FORWARD. */
    private static final String SUCCESS = "success";

    /** Action Form. */
    private static final String ACTION_FORM = "AttributeGridForm";

    /** Global Error Forward. */
    private static final String ERROR_FORWARD = "error";

    /** Form ID. */
    private static final int FORM_ID = 120;

    /**
     * Action execute.
     * @param mapping mapping
     * @param actionForm actionForm
     * @param request request
     * @param response response
     * @throws Exception Exception
     * @return ActionForward
     * @see org.apache.struts.action.Action#execute(
     *      org.apache.struts.action.ActionMapping,
     *      org.apache.struts.action.ActionForm,
     *      javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse)
     */
    public final ActionForward execute(
            final ActionMapping mapping,
            final ActionForm actionForm,
            final HttpServletRequest request,
            final HttpServletResponse response)
    throws Exception {
    	
        WebSessionCtx wscTest = WebSessionCtx.get(request); 
        if (wscTest == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute(Constants.SESSION_TIMEOUT_INFO, "Session Time Out. Please login again.");
            return mapping.findForward(Constants.SESSION_TIMEOUT);
        }

		String doQurey = "0";
		HttpSession session = request.getSession();
		
		WebSessionCtx wsc = WebSessionCtx.get(request); 
		WWindowStatus ws = WWindowStatus.get(request);
		if (wsc == null) {
			log.log(Level.SEVERE, "Session Time Out.");
			return mapping.findForward(ERROR_FORWARD);
		}

		MForm form = getForm(wsc.ctx, FORM_ID);
		wsc.ctx.setContext("FormName", form.getName());

		AttributeGridForm attributeGridForm =
			(AttributeGridForm) request.getAttribute(ACTION_FORM);
		if (attributeGridForm == null) {
			attributeGridForm = (AttributeGridForm) actionForm;
			if (attributeGridForm == null) {
				attributeGridForm = new AttributeGridForm();
			}
		}
		attributeGridForm.statInit(wsc.ctx);

		//get attributeList
		ArrayList<KeyNamePair> attributeList = getAttributeList(request);
		session.setAttribute("attributeList", attributeList);

		//get priceList
		ArrayList<KeyNamePair> pricelistList = getPricelistList(request);
		session.setAttribute("pricelistList",pricelistList);
		
		//get warehouseList
		ArrayList<KeyNamePair> warehouseList = getWarehouseList(request);
		session.setAttribute("warehouseList", warehouseList);
		
		// Set search info form
		attributeGridForm.setTitle(Msg.getMsg(wsc.ctx, "AttributeGrid"));
		session.setAttribute("attributeGridForm", attributeGridForm);	

		return mapping.findForward("success");
    }    
   
    /**
     *  Get Form from Form ID.
     *  @param ctx Properties
     *  @param formId Form ID
     *  @return form
     */
    private MForm getForm(final Ctx ctx, final int formId) {

        // Get Form from Form ID
        MForm form = new MForm(ctx, formId, null);
        
        boolean trl = !Env.isBaseLanguage(ctx, "AD_Form");
        if (trl) {
            String sql = "SELECT t.Name, t.Description, t.Help "
                       + "FROM AD_Form f INNER JOIN AD_Form_Trl t"
                       + " ON (f.AD_Form_ID=t.AD_Form_ID AND AD_Language=?)"
                       + "WHERE f.AD_Form_ID=?";
            try {
                PreparedStatement pstmt = DB.prepareStatement(sql, null);
                if (trl) {
                    pstmt.setString(1, Env.getAD_Language(ctx));
                    pstmt.setInt(2, formId);

                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next()) {
                        form.setName(rs.getString(1));
                        form.setDescription(rs.getString(2));
                        form.setHelp(rs.getString(3));
                    }
                    rs.close();
                    pstmt.close();
                }
            } catch (SQLException e) {
                log.log(Level.SEVERE, sql, e);
            }
        }

        return form;
    }   //  getForm

    /**
     * getAttributeList
     * @param request
     * @return
     */
    private ArrayList<KeyNamePair> getAttributeList(HttpServletRequest request){
    	WebSessionCtx wsc = WebSessionCtx.get(request); 
    	MAttribute[] m_attributes = MAttribute.getOfClient(wsc.ctx, true, true);
    	ArrayList<KeyNamePair> attributeList = new ArrayList();
    	attributeList.add(new KeyNamePair(0,""));
    	for (int i = 0; i < m_attributes.length; i++)
    		attributeList.add(m_attributes[i].getKeyNamePair());

    	return attributeList;
    }
    
    /**
     * getPriceList
     * @param request
     * @return
     */
    private ArrayList<KeyNamePair> getPricelistList(HttpServletRequest request){
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	ArrayList<KeyNamePair> priceList = new ArrayList();
		//	Price List
		String sql = "SELECT M_PriceList_Version.M_PriceList_Version_ID,"
			+ " M_PriceList_Version.Name || ' (' || c.Iso_Code || ')' AS ValueName "
			+ "FROM M_PriceList_Version, M_PriceList pl, C_Currency c "
			+ "WHERE M_PriceList_Version.M_PriceList_ID=pl.M_PriceList_ID"
			+ " AND pl.C_Currency_ID=c.C_Currency_ID"
			+ " AND M_PriceList_Version.IsActive='Y' AND pl.IsActive='Y'";
		//	Add Access & Order
		sql = MRole.getDefault(wsc.ctx,false).addAccessSQL (sql, "M_PriceList_Version", true, false)	// fully qualidfied - RO 
			+ " ORDER BY M_PriceList_Version.Name";
		try
		{
			priceList.add(new KeyNamePair (0, ""));
			PreparedStatement pstmt = DB.prepareStatement(sql, null);
			ResultSet rs = pstmt.executeQuery();
			while (rs.next())
			{
				KeyNamePair kn = new KeyNamePair (rs.getInt(1), rs.getString(2));
				priceList.add(kn);
			}
			rs.close();
			pstmt.close();
		}catch(Exception e){
			;
		}

    	return priceList;
    }
    
    /**
     * getWarehouseList
     * @param request
     * @return
     */
    private ArrayList<KeyNamePair> getWarehouseList(HttpServletRequest request){
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	ArrayList<KeyNamePair> warehouseList = new ArrayList();
		//	Warehouse
    	String sql = "SELECT M_Warehouse_ID, Value || ' - ' || Name AS ValueName "
			+ "FROM M_Warehouse "
			+ "WHERE IsActive='Y'";
		sql = MRole.getDefault(wsc.ctx,false).addAccessSQL (sql,
				"M_Warehouse", MRole.SQL_NOTQUALIFIED, MRole.SQL_RO)
			+ " ORDER BY Value";
		try
		{
			warehouseList.add(new KeyNamePair (0, ""));
			PreparedStatement pstmt = DB.prepareStatement(sql, null);
			ResultSet rs = pstmt.executeQuery();
			while (rs.next())
			{
				KeyNamePair kn = new KeyNamePair
					(rs.getInt("M_Warehouse_ID"), rs.getString("ValueName"));
				warehouseList.add(kn);
			}
			rs.close();
			pstmt.close();
		}catch(Exception e){
			;
		}

    	return warehouseList;
    }

}
