package com.ampiere.web.struts.form;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.swing.BorderFactory;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MAttribute;
import org.compiere.model.MAttributeValue;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MRole;
import org.compiere.model.MStorage;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Msg;
import org.compiere.util.WebSessionCtx;

import com.ampiere.util.Constants;
import com.ampiere.web.struts.form.AttributeGridForm.AttributeGridRow;
import com.ampiere.web.struts.form.AttributeGridForm.GridValue;
import com.jware.util.StringToIntConverter;

/**
 * @author clmg
 */
public class AttributeGridAction extends Action {

    /** Logger. */
    private CLogger log = CLogger.getCLogger(this.getClass());

    /** Action Form. */
    private static final String ACTION_FORM = "AttributeGridForm";

    /** Global Error Forward. */
    private static final String ERROR_FORWARD = "error";

    /** Form ID. */
    private static final int FORM_ID = 120;
    
	/** Price List Version	*/
	private DecimalFormat	m_price = DisplayType.getNumberFormat(DisplayType.CostPrice);
	/** Warehouse			*/
	private DecimalFormat	m_qty = DisplayType.getNumberFormat(DisplayType.Quantity);
	
    /**
     * Action execute.
     * @param mapping mapping
     * @param form form
     * @param request request
     * @param response response
     * @throws Exception Exception
     * @return ActionForward
     * @see org.apache.struts.action.Action#execute(
     *      org.apache.struts.action.ActionMapping,
     *      org.apache.struts.action.ActionForm,
     *      javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse)
     */
    public final ActionForward execute(
            final ActionMapping mapping,
            final ActionForm form,
            final HttpServletRequest request,
            final HttpServletResponse response)
    throws Exception {
    	
		//201001 
        WebSessionCtx wscTest = WebSessionCtx.get(request); 
        if (wscTest == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute(Constants.SESSION_TIMEOUT_INFO, "Session Time Out. Please login again.");
            return mapping.findForward(Constants.SESSION_TIMEOUT);
        }
        //--201001	 

    	HttpSession session = request.getSession();

        WebSessionCtx wsc = WebSessionCtx.get(request); 
        if (wsc == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        
        AttributeGridForm attributeGridForm =  (AttributeGridForm)form;
        List attributeGridRowList =  createGrid(request, attributeGridForm);
        attributeGridForm.setAttributeRowList(attributeGridRowList);
        attributeGridForm.setTitle(Msg.getMsg(wsc.ctx, "AttributeGrid"));
        
        request.setAttribute(ACTION_FORM, attributeGridForm);

        return mapping.findForward("success");
    }
    
	/**
	 * 	Create Grid
	 */
	private List createGrid(HttpServletRequest request, AttributeGridForm attributeGridForm)
	{
		WebSessionCtx wsc = WebSessionCtx.get(request); 
		List attributeRowList = new ArrayList();
		if (StringUtils.isEmpty(attributeGridForm.getAttribute1())
				|| attributeGridForm.getAttribute1().equals(attributeGridForm.getAttribute2()))
			return null;		//	init

		int m_M_PriceList_Version_ID = StringToIntConverter.StringToInt(attributeGridForm.getPricelist());
		int m_M_Warehouse_ID = StringToIntConverter.StringToInt(attributeGridForm.getWarehouse());;
		
		MAttribute[] m_attributes = MAttribute.getOfClient(wsc.ctx, true, true);
		
		//	x dimension
		int cols = 2;
		MAttribute mAttribute1 = getMAttribute(m_attributes, attributeGridForm.getAttribute1());
		MAttributeValue[] xValues = mAttribute1.getMAttributeValues();
		if (xValues != null)
		{
			cols = xValues.length;
			log.info("X - " + mAttribute1.getName() + " #" + xValues.length);
		}
		
		//	y dimension
		int rows = 2;
		MAttribute mAttribute2 = getMAttribute(m_attributes, attributeGridForm.getAttribute2());
		MAttributeValue[] yValues = mAttribute2.getMAttributeValues();
		if (yValues != null)
		{
			rows = yValues.length;
			log.info("Y - " + mAttribute2.getName() + " #" + yValues.length);
		}
		
		log.info("Rows=" + rows + " - Cols=" + cols);
		for (int row = 0; row < rows; row++)
		{
			 
			AttributeGridRow oneRow = attributeGridForm.new AttributeGridRow();
			for (int col = 0; col < cols; col++)
			{
				MAttributeValue xValue = null;
				if (xValues != null)
					xValue = xValues[col];
				MAttributeValue yValue = null;
				if (yValues != null)
					yValue = yValues[row];
			//	log.fine("Row=" + row + " - Col=" + col);
				//
				GridValue gridValue = attributeGridForm.new GridValue();
				if (row == 0 && col == 0)
				{
					if (xValues != null)
						gridValue.getValueList().add("       " + mAttribute1.getName());
					if (yValues != null)
						gridValue.getValueList().add(mAttribute2.getName());
				}
				else if (row == 0)	//	column labels
				{
					if (xValue != null)
					{
						gridValue.getValueList().add(xValue.getName());
					}
					else
						gridValue.getValueList().add("");
				}
				else if (col == 0)	//	row labels
				{
					if (yValue != null)
						gridValue.getValueList().add(yValue.getName());
					else
						gridValue.getValueList().add("");
				}
				else
				{
					gridValue = getGridElement (xValue, yValue, request, attributeGridForm);
				}
				oneRow.getColumnList().add(gridValue);
			}
			if(attributeRowList == null){
				attributeRowList = new ArrayList();
			}
			attributeRowList.add(oneRow);
		}

		return attributeRowList;
	}	//	createGrid
	
	/**
	 * 	Get Grid Element
	 *	@param xValue X value
	 *	@param yValue Y value
	 *	@return Panel with Info
	 */
	private GridValue getGridElement (MAttributeValue xValue, MAttributeValue yValue,
			HttpServletRequest request, AttributeGridForm attributeGridForm)
	{
		WebSessionCtx wsc = WebSessionCtx.get(request); 
		GridValue gridValue = attributeGridForm.new GridValue();
		String sql = "SELECT * FROM M_Product WHERE IsActive='Y'";
		//	Product Attributes
		if (xValue != null)
			sql += " AND M_AttributeSetInstance_ID IN "
				+ "(SELECT M_AttributeSetInstance_ID "
				+ "FROM M_AttributeInstance "
				+ "WHERE M_Attribute_ID=" + xValue.getM_Attribute_ID()
				+ " AND M_AttributeValue_ID=" + xValue.getM_AttributeValue_ID() + ")"; 
		if (yValue != null)
			sql += " AND M_AttributeSetInstance_ID IN "
				+ "(SELECT M_AttributeSetInstance_ID "
				+ "FROM M_AttributeInstance "
				+ "WHERE M_Attribute_ID=" + yValue.getM_Attribute_ID()
				+ " AND M_AttributeValue_ID=" + yValue.getM_AttributeValue_ID() + ")"; 
		sql = MRole.getDefault(wsc.ctx,false).addAccessSQL(sql, "M_Product", 
			MRole.SQL_NOTQUALIFIED, MRole.SQL_RO);
		PreparedStatement pstmt = null;
		int noProducts = 0;
		try
		{
			pstmt = DB.prepareStatement (sql, null);
			ResultSet rs = pstmt.executeQuery ();
			while (rs.next ())
			{
				MProduct product = new MProduct(wsc.ctx, rs, null);
				addProduct (gridValue, product, request, attributeGridForm);
				noProducts++;
			}
			rs.close ();
			pstmt.close ();
			pstmt = null;
		}
		catch (Exception e)
		{
			log.log (Level.SEVERE, sql, e);
		}
		try
		{
			if (pstmt != null)
				pstmt.close ();
			pstmt = null;
		}
		catch (Exception e)
		{
			pstmt = null;
		}
	
		return gridValue;
	}	//	getGridElement
	
	/**
	 * 	Add Product
	 *	@param element panel
	 *	@param product product
	 */
	private void addProduct(GridValue gridValue, MProduct product,
			HttpServletRequest request, AttributeGridForm attributeGridForm)
	{
		WebSessionCtx wsc = WebSessionCtx.get(request);

		StringBuffer gridValueBuffer = new StringBuffer();
		
		Insets ii = new Insets(2,4,2,4);
		int M_Product_ID = product.getM_Product_ID();
		CPanel pe = new CPanel();
		pe.setBorder(BorderFactory.createLineBorder(Color.BLUE, 1));
		pe.setLayout(new GridBagLayout());
		int m_M_PriceList_Version_ID = StringToIntConverter.StringToInt(attributeGridForm.getPricelist());
		int m_M_Warehouse_ID = StringToIntConverter.StringToInt(attributeGridForm.getWarehouse());;
		
		//	Product Value - Price
		gridValueBuffer.append(product.getValue());
		String formatted = "";
		if (m_M_PriceList_Version_ID != 0)
		{
			MProductPrice pp = MProductPrice.get(wsc.ctx, m_M_PriceList_Version_ID, M_Product_ID, null);
			if (pp != null)
			{
				BigDecimal price = pp.getPriceStd();
				formatted = m_price.format(price);
			}
			else
				formatted = "-";
		}
		gridValueBuffer.append(formatted);
		gridValue.getValueList().add(gridValueBuffer.toString());
		
		gridValueBuffer = new StringBuffer();
		//	Product Name - Qty
		gridValueBuffer.append(product.getName());
		formatted = "";
		if (m_M_Warehouse_ID != 0)
		{
			BigDecimal qty = MStorage.getQtyAvailable(m_M_Warehouse_ID, M_Product_ID, 0, null);
			if (qty == null)
				formatted = "-";
			else
				formatted = m_qty.format(qty);
		}
		gridValueBuffer.append(formatted);

		gridValue.getValueList().add(gridValueBuffer.toString());
	}	//	addProduct    
    /**
     * getAttribute
     * @param m_attributes, key
     * @return MAttribute
     */
    private MAttribute getMAttribute(MAttribute[] m_attributes, String key){
    	MAttribute mAttribute = null;
    	for (int i = 0; i < m_attributes.length; i++){
    		if(StringToIntConverter.StringToInt(key) == m_attributes[i].getKeyNamePair().getKey()){
    			mAttribute = m_attributes[i];
    			break;
    		}
    	}
    	return mAttribute;
    }
}
