package com.ampiere.web.struts.form;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Level;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.util.CLogger;
import org.compiere.util.FileUpload;
import org.compiere.util.WebSessionCtx;

import com.ampiere.util.Constants;

/**
 * @author clmg
 */
public class FileImportAction extends Action {

    /** Logger. */
    private CLogger log = CLogger.getCLogger(this.getClass());
    
    /** Order List Forward. */
    private static final String ORDER_LIST = "orderlist";

    /** Shipment List Forward. */
    private static final String SHIPMENT_LIST = "shipmentlist";

    /** Action Form. */
    private static final String ACTION_FORM = "GenerateShipmentFromOrderForm";

    /** Global Error Forward. */
    private static final String ERROR_FORWARD = "error";

    /** C_OrderLine.M_Warehouse_ID. */
    private static final int ORDER_BUSINESS_PARTNER_COLUMN_ID = 2762;

    /** Form ID. */
    private static final int FORM_ID = 110;

    /**
     * Action execute.
     * @param mapping mapping
     * @param form form
     * @param request request
     * @param response response
     * @throws Exception Exception
     * @return ActionForward
     * @see org.apache.struts.action.Action#execute(
     *      org.apache.struts.action.ActionMapping,
     *      org.apache.struts.action.ActionForm,
     *      javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse)
     */
    public final ActionForward execute(
            final ActionMapping mapping,
            final ActionForm form,
            final HttpServletRequest request,
            final HttpServletResponse response)
    throws Exception {
    	
		//201001 
        WebSessionCtx wscTest = WebSessionCtx.get(request); 
        if (wscTest == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute(Constants.SESSION_TIMEOUT_INFO, "Session Time Out. Please login again.");
            return mapping.findForward(Constants.SESSION_TIMEOUT);
        }
        //--201001	 

        log.fine("Begin " + this.getClass().getName() + ";execute");

        WebSessionCtx wsc = WebSessionCtx.get(request); 
        if (wsc == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        
        FileImportForm myForm =
            (FileImportForm) request.getAttribute(ACTION_FORM);
//        if (myForm == null) {
//            myForm = (GenerateShipmentFromOrderForm) form;
//        }
//
//        if (myForm == null) {
//            myForm = new GenerateShipmentFromOrderForm();
//        }
        
        cmd_loadFile(request);
 
        
        // Save form to request.
        request.setAttribute(ACTION_FORM, myForm);

        log.fine("End " + this.getClass().getName() + ";execute");

        return mapping.findForward("success");
    }
    
	/**************************************************************************
	 *	Load File
	 */
	private void cmd_loadFile(HttpServletRequest request)
	{
		ArrayList<String>	m_data = new ArrayList<String>();
		
		FileUpload upload = null;
		upload = new FileUpload(request);
		String error = upload.getError();
		if (error != null)
		{
			log.warning("cmd_loadFile - " + error);
		}
		
		try
		{
			//  see NaturalAccountMap
			BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(upload.getData())));

			//	not safe see p108 Network pgm
			String s = null;
			while ((s = in.readLine()) != null)
			{
				m_data.add(s);

			}
			in.close();
		}
		catch (Exception e)
		{
			log.log(Level.SEVERE, "", e);
		}
		
		//	Create Attachment
//		if (upload != null)
//			attachment.addEntry(upload.getFileName(), upload.getData());


	}	//	cmd_loadFile    

}
