package com.ampiere.web.struts.form;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MForm;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.ValueNamePair;
import org.compiere.util.WebSessionCtx;

import com.ampiere.util.Constants;
import com.ampiere.web.servlet.WWindowStatus;
import com.jware.util.StringToIntConverter;

/**
 * @author clmg
 */
public class PayPrint extends Action {

    /** Logger. */
    private CLogger log = CLogger.getCLogger(this.getClass());
    
    /** SUCCESS FORWARD. */
    private static final String SUCCESS = "success";

    /** Global Error Forward. */
    private static final String ERROR_FORWARD = "error";
    
    /** Alert Info. */
    private static final String WARNING_INFO = "warningInfo";

    /** Form ID. */
    private static final int FORM_ID = 106;

    /**
     * Action execute.
     * @param mapping mapping
     * @param actionForm actionForm
     * @param request request
     * @param response response
     * @throws Exception Exception
     * @return ActionForward
     * @see org.apache.struts.action.Action#execute(
     *      org.apache.struts.action.ActionMapping,
     *      org.apache.struts.action.ActionForm,
     *      javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse)
     */
    public final ActionForward execute(
            final ActionMapping mapping,
            final ActionForm actionForm,
            final HttpServletRequest request,
            final HttpServletResponse response)
    throws Exception {
    	
		//201001 
        WebSessionCtx wscTest = WebSessionCtx.get(request); 
        if (wscTest == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute(Constants.SESSION_TIMEOUT_INFO, "Session Time Out. Please login again.");
            return mapping.findForward(Constants.SESSION_TIMEOUT);
        }
        //--201001	 

		String doQurey = "0";
		HttpSession session = request.getSession();
		
		WebSessionCtx wsc = WebSessionCtx.get(request); 
		WWindowStatus ws = WWindowStatus.get(request);
		if (wsc == null) {
			log.log(Level.SEVERE, "Session Time Out.");
			return mapping.findForward(ERROR_FORWARD);
		}

		MForm form = getForm(wsc.ctx, FORM_ID);
		wsc.ctx.setContext("FormName", form.getName());

		PayPrintForm payPrintForm = null;
		if (payPrintForm == null) {
			payPrintForm = (PayPrintForm) actionForm;
			if (payPrintForm == null) {
				payPrintForm = new PayPrintForm();
			}
		}
		
		payPrintForm.statInit(wsc.ctx);
		// Clear all
		session.setAttribute("searchResultPayment", null);
		
		//get org list
		ArrayList<NamePair> paySelectList = getPaySelectList(request, payPrintForm);
		session.setAttribute("paySelectList", paySelectList);
		
		//loadPaySelectInfo
		loadPaySelectInfo(request, payPrintForm);
		//load loadPaymentRule
		loadPaymentRule(request, payPrintForm);
		//load loadPaymentRule
		loadPaymentRuleInfo(request, payPrintForm);

		// Set search info form
		payPrintForm.setTitle(Msg.getMsg(wsc.ctx, "PayPrint"));
		session.setAttribute("payPrintForm", payPrintForm);
		
        if(payPrintForm.isEnabledBProcess()){
        	request.setAttribute("enabledBProcess", Constants.ENABLED);
        }
		
		return mapping.findForward("success");
    }
    
    /**
     *  Get Form from Form ID.
     *  @param ctx Properties
     *  @param formId Form ID
     *  @return form
     */
    private MForm getForm(final Ctx ctx, final int formId) {

        // Get Form from Form ID
        MForm form = new MForm(ctx, formId, null);
        
        boolean trl = !Env.isBaseLanguage(ctx, "AD_Form");
        if (trl) {
            String sql = "SELECT t.Name, t.Description, t.Help "
                       + "FROM AD_Form f INNER JOIN AD_Form_Trl t"
                       + " ON (f.AD_Form_ID=t.AD_Form_ID AND AD_Language=?)"
                       + "WHERE f.AD_Form_ID=?";
            try {
                PreparedStatement pstmt = DB.prepareStatement(sql, null);
                if (trl) {
                    pstmt.setString(1, Env.getAD_Language(ctx));
                    pstmt.setInt(2, formId);

                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next()) {
                        form.setName(rs.getString(1));
                        form.setDescription(rs.getString(2));
                        form.setHelp(rs.getString(3));
                    }
                    rs.close();
                    pstmt.close();
                }
            } catch (SQLException e) {
                log.log(Level.SEVERE, sql, e);
            }
        }

        return form;
    }   //  getForm
    
    private ArrayList<NamePair> getPaySelectList(HttpServletRequest request, PayPrintForm form){
    	HttpSession session = request.getSession();
		ArrayList<NamePair> paySelectList = new ArrayList();
		WebSessionCtx wsc = WebSessionCtx.get(request); 
		Ctx ctx = wsc.ctx;
		
		int AD_Client_ID = ctx.getAD_Client_ID();

		//  Load PaySelect
		//jz String sql = "SELECT C_PaySelection_ID, Name || ' - ' || TotalAmt FROM C_PaySelection "
		String sql = "SELECT C_PaySelection_ID, Name || ' - ' || " + DB.TO_CHAR("TotalAmt", DisplayType.Number, Env.getAD_Language(ctx)) + " FROM C_PaySelection "
			+ "WHERE AD_Client_ID=? AND Processed='Y' AND IsActive='Y'"
			+ "ORDER BY PayDate DESC";
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql, null);
			pstmt.setInt(1, AD_Client_ID);
			ResultSet rs = pstmt.executeQuery();
			//
			while (rs.next())
			{
				KeyNamePair pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
				paySelectList.add(pp);
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql, e);
		}
		
		if(paySelectList!=null && paySelectList.size() > 0){
			if(StringUtils.isEmpty(form.getPaySelect())){
				KeyNamePair pp = (KeyNamePair)(paySelectList.get(0));
				form.setPaySelect(String.valueOf(pp.getKey()));
			}
		}
		
		return paySelectList;
    }
 
	/**
	 *  PaySelect changed - load Bank
	 */
	public void loadPaySelectInfo(HttpServletRequest request, PayPrintForm form)
	{
		log.info( "VPayPrint.loadPaySelectInfo");
		if (StringUtils.isEmpty(form.getPaySelect()))
			return;

		//  load Banks from PaySelectLine
		int C_PaySelection_ID = StringToIntConverter.StringToInt(form.getPaySelect());
		form.setM_C_BankAccount_ID(-1);
		String sql = "SELECT ps.C_BankAccount_ID, b.Name || ' ' || ba.AccountNo,"	//	1..2
			+ " c.ISO_Code, CurrentBalance "										//	3..4
			+ "FROM C_PaySelection ps"
			+ " INNER JOIN C_BankAccount ba ON (ps.C_BankAccount_ID=ba.C_BankAccount_ID)"
			+ " INNER JOIN C_Bank b ON (ba.C_Bank_ID=b.C_Bank_ID)"
			+ " INNER JOIN C_Currency c ON (ba.C_Currency_ID=c.C_Currency_ID) "
			+ "WHERE ps.C_PaySelection_ID=? AND ps.Processed='Y' AND ba.IsActive='Y'";
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql, null);
			pstmt.setInt(1, C_PaySelection_ID);
			ResultSet rs = pstmt.executeQuery();
			if (rs.next())
			{
				form.setM_C_BankAccount_ID(rs.getInt(1));
				form.setBank(rs.getString(2));
				form.setCurrency(rs.getString(3));
				form.setBalance(rs.getBigDecimal(4).toString());
			}
			else
			{
				form.setM_C_BankAccount_ID(-1);
				form.setBank("");
				form.setCurrency("");
				form.setBalance(Env.ZERO.toString());
				log.log(Level.SEVERE, "No active BankAccount for C_PaySelection_ID=" + C_PaySelection_ID);
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql, e);
		}
	}   //  loadPaySelectInfo    
    
	/**
	 *  Bank changed - load PaymentRule
	 */
    public void loadPaymentRule(HttpServletRequest request, PayPrintForm form){
		HttpSession session = request.getSession();
		WebSessionCtx wsc = WebSessionCtx.get(request); 
		Ctx ctx = wsc.ctx;
		ArrayList<NamePair> paymentRuleList = new ArrayList();
		if (form.getM_C_BankAccount_ID() == -1){
			session.setAttribute("paymentRuleList", paymentRuleList);
			return;
		}
		
		// load PaymentRule for Bank
		int C_PaySelection_ID = StringToIntConverter.StringToInt(form.getPaySelect());
		
		int AD_Reference_ID = 195;  //  MLookupInfo.getAD_Reference_ID("All_Payment Rule");
		Language language = Language.getLanguage(Env.getAD_Language(ctx));
		MLookupInfo info = MLookupFactory.getLookup_List(language, AD_Reference_ID);
		String sql = info.Query.substring(0, info.Query.indexOf(" ORDER BY"))
			+ " AND " + info.KeyColumn
			+ " IN (SELECT PaymentRule FROM C_PaySelectionCheck WHERE C_PaySelection_ID=?) "
			+ info.Query.substring(info.Query.indexOf(" ORDER BY"));
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql, null);
			pstmt.setInt(1, C_PaySelection_ID);
			ResultSet rs = pstmt.executeQuery();
			//
			while (rs.next())
			{
				ValueNamePair pp = new ValueNamePair(rs.getString(2), rs.getString(3));
				paymentRuleList.add(pp);
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql, e);
		}
		
		if(paymentRuleList!=null && paymentRuleList.size() > 0){
			if(StringUtils.isEmpty(form.getPaymentRule())){
				ValueNamePair pp = (ValueNamePair)paymentRuleList.get(0);
				form.setPaymentRule(pp.getValue());
			}			
		}
		
		session.setAttribute("paymentRuleList", paymentRuleList);
	}   //  loadPaymentRule
	
	public void loadPaymentRuleInfo(HttpServletRequest request, PayPrintForm form)
	{
		WebSessionCtx wsc = WebSessionCtx.get(request); 
		Ctx ctx = wsc.ctx;
		
		String PaymentRule = form.getPaymentRule();

		log.info("PaymentRule=" + PaymentRule);
		form.setNoPayments("");

		int C_PaySelection_ID = StringToIntConverter.StringToInt(form.getPaySelect());
		String sql = "SELECT COUNT(*) "
			+ "FROM C_PaySelectionCheck "
			+ "WHERE C_PaySelection_ID=?";
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql, null);
			pstmt.setInt(1, C_PaySelection_ID);
			ResultSet rs = pstmt.executeQuery();
			//
			if (rs.next())
				form.setNoPayments(String.valueOf(rs.getInt(1)));
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql, e);
		}
		form.setEnabledBProcess(PaymentRule.equals("T"));

		//  DocumentNo
		sql = "SELECT CurrentNext "
			+ "FROM C_BankAccountDoc "
			+ "WHERE C_BankAccount_ID=? AND PaymentRule=? AND IsActive='Y'";
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql, null);
			pstmt.setInt(1, form.getM_C_BankAccount_ID());
			pstmt.setString(2, PaymentRule);
			ResultSet rs = pstmt.executeQuery();
			//
			if (rs.next())
				form.setDocumentNo(String.valueOf(rs.getInt(1)));
			else
			{
				log.log(Level.SEVERE, "VPayPrint.loadPaymentRuleInfo - No active BankAccountDoc for C_BankAccount_ID="
					+ form.getM_C_BankAccount_ID() + " AND PaymentRule=" + PaymentRule);
				request.setAttribute(WARNING_INFO, Msg.getMsg(ctx, "VPayPrintNoDoc"));
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql, e);
		}
	}   //  loadPaymentRuleInfo	
}
