package com.ampiere.web.struts.form;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MCurrency;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.MPaymentBatch;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.WebSessionCtx;

import com.ampiere.util.Constants;
import com.jware.util.StringToIntConverter;

/**
 * 
 * @author clmg
 *
 */
public class PayPrintAction extends Action {

    /** Logger. */
    private CLogger log = CLogger.getCLogger(this.getClass());

    /** Global Error Forward. */
    private static final String ERROR_FORWARD = "error";
    
    /** Alert Info. */
    private static final String WARNING_INFO = "warningInfo";

    /** Form ID. */
    private static final int FORM_ID = 106;
    
    /** Form ID. */
    private static final String ACTION_TYPE = "";
    private static final String SELECT_ACTION = "1";
    private static final String EXPORT_ACTION = "2";
    private static final String PRINT_ACTION = "3";
    private static final String PROCESS_ACTION = "4";
    
	/** BPartner Info Index for Value       */
	private static final int     BP_VALUE = 0;
	/** BPartner Info Index for Name        */
	private static final int     BP_NAME = 1;
	/** BPartner Info Index for Contact Name    */
	private static final int     BP_CONTACT = 2;
	/** BPartner Info Index for Address 1   */
	private static final int     BP_ADDR1 = 3;
	/** BPartner Info Index for Address 2   */
	private static final int     BP_ADDR2 = 4;
	/** BPartner Info Index for City        */
	private static final int     BP_CITY = 5;
	/** BPartner Info Index for Region      */
	private static final int     BP_REGION = 6;
	/** BPartner Info Index for Postal Code */
	private static final int     BP_POSTAL = 7;
	/** BPartner Info Index for Country     */
	private static final int     BP_COUNTRY = 8;
	/** BPartner Info Index for Reference No    */
	private static final int     BP_REFNO = 9;
	
	/** BankAccount Info Index for RoutingNo       */
	private static final int     BPBA_RoutingNo = 0;
	/** BankAccount Info Index for AccountNo       */
	private static final int     BPBA_AccountNo = 1;
	/** BankAccount Info Index for AccountName     */
	private static final int     BPBA_AName = 2;
	/** BankAccount Info Index for AccountCity     */
	private static final int     BPBA_ACity = 3;
	/** BankAccount Info Index for BBAN            */
	private static final int     BPBA_BBAN = 4;
	/** BankAccount Info Index for IBAN            */
	private static final int     BPBA_IBAN = 5;
	/** BankAccount Info Index for Bank Name       */
	private static final int     BA_Name = 6;
	/** BankAccount Info Index for Bank RoutingNo  */
	private static final int     BA_RoutingNo = 7;
	/** BankAccount Info Index for Bank SwiftCode  */
	private static final int     BA_SwitftCode = 8;

    /**
     * Action execute.
     * @param mapping mapping
     * @param form form
     * @param request request
     * @param response response
     * @throws Exception Exception
     * @return ActionForward
     * @see org.apache.struts.action.Action#execute(
     *      org.apache.struts.action.ActionMapping,
     *      org.apache.struts.action.ActionForm,
     *      javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse)
     */
    public final ActionForward execute(
            final ActionMapping mapping,
            final ActionForm form,
            final HttpServletRequest request,
            final HttpServletResponse response)
    throws Exception {
    	
		//201001 
        WebSessionCtx wscTest = WebSessionCtx.get(request); 
        if (wscTest == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute(Constants.SESSION_TIMEOUT_INFO, "Session Time Out. Please login again.");
            return mapping.findForward(Constants.SESSION_TIMEOUT);
        }
        //--201001	 

    	HttpSession session = request.getSession();

        WebSessionCtx wsc = WebSessionCtx.get(request); 
        if (wsc == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        
        PayPrintForm payPrintForm =  (PayPrintForm) form;
        payPrintForm.statInit(wsc.ctx);
        
        
        if(SELECT_ACTION.equals(payPrintForm.getActionType())){
    		//loadPaySelectInfo
            PayPrint tmp = new PayPrint();
    		tmp.loadPaySelectInfo(request, payPrintForm);
    		//load loadPaymentRule
    		tmp.loadPaymentRule(request, payPrintForm);
    		//load loadPaymentRule
    		tmp.loadPaymentRuleInfo(request, payPrintForm);
    	    payPrintForm.setTitle(Msg.getMsg(wsc.ctx, "PayPrint"));
    	    session.setAttribute("payPrintForm", payPrintForm);
        }else if(EXPORT_ACTION.equals(payPrintForm.getActionType())){
        	payPrintForm = (PayPrintForm)session.getAttribute("payPrintForm");
        	cmd_export(request, response, payPrintForm);
        	return null;
        }else if (PROCESS_ACTION.equals(payPrintForm.getActionType())){
        	cmd_EFT(request, payPrintForm);
        }

        if(payPrintForm.isEnabledBProcess()){
        	request.setAttribute("enabledBProcess", Constants.ENABLED);
        }
        
        return mapping.findForward("success");
    } 
    
	/**************************************************************************
	 *  Export payments to file
	 */
	private void cmd_export(HttpServletRequest request, HttpServletResponse response, PayPrintForm form)
	{
		WebSessionCtx wsc = WebSessionCtx.get(request); 
		Ctx ctx = wsc.ctx;
		String PaymentRule = form.getPaymentRule();
		
		log.info(PaymentRule);
		if (!getChecks(request, form))
			return;

		//  Create File
		int no = exportToResponse(response, form.getM_checks(), ctx);

//		if (ADialog.ask(m_WindowNo, this, "VPayPrintSuccess?"))
//		{
//		//	int lastDocumentNo = 
//			MPaySelectionCheck.confirmPrint (form.getM_checks(), form.getM_batch());
//			//	document No not updated
//		}

	}   //  cmd_export
	
	/**************************************************************************
	 *  Get Checks
	 *  @param PaymentRule Payment Rule
	 *  @return true if payments were created
	 */
	private boolean getChecks(HttpServletRequest request, PayPrintForm form)
	{
		WebSessionCtx wsc = WebSessionCtx.get(request); 
		Ctx ctx = wsc.ctx;
		String PaymentRule = form.getPaymentRule();
		//  do we have values
		if (StringUtils.isEmpty(form.getPaySelect()) || form.getM_C_BankAccount_ID() == -1
			|| StringUtils.isEmpty(form.getPaymentRule()) || StringUtils.isEmpty(form.getDocumentNo()))
		{
			request.setAttribute(WARNING_INFO, Msg.getMsg(ctx, "VPayPrintNoRecords") 
					+ Msg.translate(ctx, "C_PaySelectionLine_ID") + "=0)");
			return false;
		}

		//  get data
		int C_PaySelection_ID = StringToIntConverter.StringToInt(form.getPaySelect());
		int startDocumentNo = StringToIntConverter.StringToInt(form.getDocumentNo());

		log.config("C_PaySelection_ID=" + C_PaySelection_ID + ", PaymentRule=" +  PaymentRule + ", DocumentNo=" + startDocumentNo);

		//	get Slecetions
		form.setM_checks(MPaySelectionCheck.get(C_PaySelection_ID, PaymentRule, startDocumentNo, null));
		
		//
		if (form.getM_checks() == null || form.getM_checks().length == 0)
		{
			request.setAttribute(WARNING_INFO, Msg.getMsg(ctx, "VPayPrintNoRecords") 
					+ Msg.translate(ctx, "C_PaySelectionLine_ID") + " #0");
			return false;
		}
		form.setM_batch(MPaymentBatch.getForPaySelection (ctx, C_PaySelection_ID, null));
		return true;
	}   //  getChecks	
	
	/**************************************************************************
	 *  Export to File
	 *  @param checks array of checks
	 *  @param file file to export checks
	 *  @return number of lines
	 */
	public static int exportToResponse (HttpServletResponse response, MPaySelectionCheck[] checks, Ctx ctx)
	{
		if (checks == null || checks.length == 0)
			return 0;

		char x = '"';      //  ease
		int noLines = 0;
		StringBuffer line = null;
		try
		{
			response.setContentType("application/text");
			response.setHeader("Content-Disposition","inline; filename=paymentExport.txt");
			response.setHeader("Content-Description","File download for PDF.");
			ServletOutputStream ouputStream = response.getOutputStream();

			//  write header
			line = new StringBuffer();
			line.append(x).append("Value").append(x).append(",")
				.append(x).append("Name").append(x).append(",")
				.append(x).append("Contact").append(x).append(",")
				.append(x).append("Addr1").append(x).append(",")
				.append(x).append("Addr2").append(x).append(",")
				.append(x).append("City").append(x).append(",")
				.append(x).append("State").append(x).append(",")
				.append(x).append("ZIP").append(x).append(",")
				.append(x).append("Country").append(x).append(",")
				.append(x).append("ReferenceNo").append(x).append(",")
			    .append(x).append("BPRoutingNo").append(x).append(",")
				.append(x).append("BPAccountNo").append(x).append(",")
				.append(x).append("BPAName").append(x).append(",")
				.append(x).append("BPACity").append(x).append(",")
				.append(x).append("BPBBAN").append(x).append(",")
				.append(x).append("BPIBAN").append(x).append(",")
				.append(x).append("BAName").append(x).append(",")
				.append(x).append("BARoutingNo").append(x).append(",")
				.append(x).append("BASwiftCode").append(x).append(",")
				.append(x).append("DocumentNo").append(x).append(",")
				.append(x).append("PayDate").append(x).append(",")
				.append(x).append("Currency").append(x).append(",")
				.append(x).append("PayAmount").append(x).append(",")
				.append(x).append("Comment").append(x)
				.append(Env.NL);
			ouputStream.print(line.toString());
			noLines++;

			//  write lines
			for (int i = 0; i < checks.length; i++)
			{
				MPaySelectionCheck mpp = checks[i];
				if (mpp == null)
					continue;
				//  BPartner Info
				String bp[] = getBPartnerInfo(mpp.getC_BPartner_ID());
				//  Target BankAccount Info
				String bpba[] = getBPBankAccountInfo(mpp.getC_BP_BankAccount_ID ());

				//  Comment - list of invoice document no
				StringBuffer comment = new StringBuffer();
				MPaySelectionLine[] psls = mpp.getPaySelectionLines(false);
				for (int l = 0; l < psls.length; l++)
				{
					if (l > 0)
						comment.append(", ");
					comment.append(psls[l].getInvoice().getDocumentNo());
				}
				line = new StringBuffer();
				line.append(x).append(bp[BP_VALUE]).append(x).append(",")   // Value
					.append(x).append(bp[BP_NAME]).append(x).append(",")    // Name
					.append(x).append(bp[BP_CONTACT]).append(x).append(",") // Contact
					.append(x).append(bp[BP_ADDR1]).append(x).append(",")   // Addr1
					.append(x).append(bp[BP_ADDR2]).append(x).append(",")   // Addr2
					.append(x).append(bp[BP_CITY]).append(x).append(",")    // City
					.append(x).append(bp[BP_REGION]).append(x).append(",")  // State
					.append(x).append(bp[BP_POSTAL]).append(x).append(",")  // ZIP
					.append(x).append(bp[BP_COUNTRY]).append(x).append(",") // Country
					.append(x).append(bp[BP_REFNO]).append(x).append(",")   // ReferenceNo
				    .append(x).append(bpba[BPBA_RoutingNo]).append(x).append(",")   // Routing No (as of BPBankAccount
					.append(x).append(bpba[BPBA_AccountNo]).append(x).append(",")   // AccountNo
					.append(x).append(bpba[BPBA_AName]).append(x).append(",")       // Account Name
					.append(x).append(bpba[BPBA_ACity]).append(x).append(",")       // Account City
					.append(x).append(bpba[BPBA_BBAN]).append(x).append(",")        // BBAN
					.append(x).append(bpba[BPBA_IBAN]).append(x).append(",")        // IBAN
					.append(x).append(bpba[BA_Name]).append(x).append(",")          // Bank Name
					.append(x).append(bpba[BA_RoutingNo]).append(x).append(",")     // Bank RoutingNo
					.append(x).append(bpba[BA_SwitftCode]).append(x).append(",")    // SwiftCode
					//  Payment Info
					.append(x).append(mpp.getDocumentNo()).append(x).append(",")    // DocumentNo
					.append(mpp.getParent().getPayDate()).append(",")               // PayDate
					.append(x).append(MCurrency.getISO_Code(ctx, mpp.getParent().getC_Currency_ID())).append(x).append(",")    // Currency
					.append(mpp.getPayAmt()).append(",")                // PayAmount
					.append(x).append(comment.toString()).append(x)     // Comment
					.append(Env.NL);
				ouputStream.print(line.toString());
				noLines++;
			}   //  write line
		}
		catch (Exception e)
		{
			;
		}

		return noLines;
	}   //  exportToFile
	
	/**
	 *  Get Customer/Vendor Info.
	 *  Based on BP_ static variables
	 *  @param C_BPartner_ID BPartner
	 *  @return info array
	 */
	private static String[] getBPartnerInfo (int C_BPartner_ID)
	{
		String[] bp = new String[10];

		String sql = "SELECT bp.Value, bp.Name, c.Name AS Contact, "
			+ "a.Address1, a.Address2, a.City, r.Name AS Region, a.Postal, "
			+ "cc.Name AS Country, bp.ReferenceNo "
			/*//jz use SQL standard outer join
			+ "FROM C_BPartner bp, AD_User c, C_BPartner_Location l, C_Location a, C_Region r, C_Country cc "
			+ "WHERE bp.C_BPartner_ID=?"        // #1
			+ " AND bp.C_BPartner_ID=c.C_BPartner_ID(+)"
			+ " AND bp.C_BPartner_ID=l.C_BPartner_ID"
			+ " AND l.C_Location_ID=a.C_Location_ID"
			+ " AND a.C_Region_ID=r.C_Region_ID(+)"
			+ " AND a.C_Country_ID=cc.C_Country_ID "
			*/
			+ "FROM C_BPartner bp "
			+ "LEFT OUTER JOIN AD_User c ON (bp.C_BPartner_ID=c.C_BPartner_ID) "
			+ "INNER JOIN C_BPartner_Location l ON (bp.C_BPartner_ID=l.C_BPartner_ID) "
			+ "INNER JOIN C_Location a ON (l.C_Location_ID=a.C_Location_ID) "
			+ "LEFT OUTER JOIN C_Region r ON (a.C_Region_ID=r.C_Region_ID) "
			+ "INNER JOIN C_Country cc ON (a.C_Country_ID=cc.C_Country_ID) "
			+ "WHERE bp.C_BPartner_ID=?"        // #1
			+ "ORDER BY l.IsBillTo DESC";
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql, null);
			pstmt.setInt(1, C_BPartner_ID);
			ResultSet rs = pstmt.executeQuery();
			//
			if (rs.next())
			{
				bp[BP_VALUE] = rs.getString(1);
				if (bp[BP_VALUE] == null)
					bp[BP_VALUE] = "";
				bp[BP_NAME] = rs.getString(2);
				if (bp[BP_NAME] == null)
					bp[BP_NAME] = "";
				bp[BP_CONTACT] = rs.getString(3);
				if (bp[BP_CONTACT] == null)
					bp[BP_CONTACT] = "";
				bp[BP_ADDR1] = rs.getString(4);
				if (bp[BP_ADDR1] == null)
					bp[BP_ADDR1] = "";
				bp[BP_ADDR2] = rs.getString(5);
				if (bp[BP_ADDR2] == null)
					bp[BP_ADDR2] = "";
				bp[BP_CITY] = rs.getString(6);
				if (bp[BP_CITY] == null)
					bp[BP_CITY] = "";
				bp[BP_REGION] = rs.getString(7);
				if (bp[BP_REGION] == null)
					bp[BP_REGION] = "";
				bp[BP_POSTAL] = rs.getString(8);
				if (bp[BP_POSTAL] == null)
					bp[BP_POSTAL] = "";
				bp[BP_COUNTRY] = rs.getString(9);
				if (bp[BP_COUNTRY] == null)
					bp[BP_COUNTRY] = "";
				bp[BP_REFNO] = rs.getString(10);
				if (bp[BP_REFNO] == null)
					bp[BP_REFNO] = "";
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			;
		}
		return bp;
	}   //  getBPartnerInfo	
	
	/**
	 *  Get Bank Account Info for target Accpimt.
	 *  Based on BP_ static variables
	 *  @param C_BPartner_ID BPartner
	 *  @return info array
	 */
	private static String[] getBPBankAccountInfo (int C_BP_BankAccount_ID)
	{
		String[] bp = new String[10];

		String sql = "SELECT bpba.RoutingNo, bpba.AccountNo, bpba.A_Name, bpba.A_City, bpba.BBAN, "
			+ "bpba.IBAN, ba.Name, ba.RoutingNo, ba.SwiftCode "
			/*//jz use SQL standard outer join
			+ "FROM C_BPartner bp, AD_User c, C_BPartner_Location l, C_Location a, C_Region r, C_Country cc "
			+ "WHERE bp.C_BPartner_ID=?"        // #1
			+ " AND bp.C_BPartner_ID=c.C_BPartner_ID(+)"
			+ " AND bp.C_BPartner_ID=l.C_BPartner_ID"
			+ " AND l.C_Location_ID=a.C_Location_ID"
			+ " AND a.C_Region_ID=r.C_Region_ID(+)"
			+ " AND a.C_Country_ID=cc.C_Country_ID "
			*/
			+ "FROM C_BP_BankAccount bpba "
			+ "LEFT OUTER JOIN C_Bank ba ON (bpba.C_Bank_ID = ba.C_Bank_ID) "
			+ "WHERE bpba.C_BP_BankAccount_ID=?";        // #1
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql, null);
			pstmt.setInt(1, C_BP_BankAccount_ID);
			ResultSet rs = pstmt.executeQuery();
			//
			if (rs.next())
			{
				bp[BPBA_RoutingNo] = rs.getString(1);
				if (bp[BPBA_RoutingNo] == null)
					bp[BPBA_RoutingNo] = "";
				bp[BPBA_AccountNo] = rs.getString(2);
				if (bp[BPBA_AccountNo] == null)
					bp[BPBA_AccountNo] = "";
				bp[BPBA_AName] = rs.getString(3);
				if (bp[BPBA_AName] == null)
					bp[BPBA_AName] = "";
				bp[BPBA_ACity] = rs.getString(4);
				if (bp[BPBA_ACity] == null)
					bp[BPBA_ACity] = "";
				bp[BPBA_BBAN] = rs.getString(5);
				if (bp[BPBA_BBAN] == null)
					bp[BPBA_BBAN] = "";
				bp[BPBA_IBAN] = rs.getString(6);
				if (bp[BPBA_IBAN] == null)
					bp[BPBA_IBAN] = "";
				bp[BA_Name] = rs.getString(7);
				if (bp[BA_Name] == null)
					bp[BA_Name] = "";
				bp[BA_RoutingNo] = rs.getString(8);
				if (bp[BA_RoutingNo] == null)
					bp[BA_RoutingNo] = "";
				bp[BA_SwitftCode] = rs.getString(9);
				if (bp[BA_SwitftCode] == null)
					bp[BA_SwitftCode] = "";
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			;
		}
		return bp;
	}   //  getBPartnerInfo	
	
	/**
	 *  Create EFT payment
	 */
	private void cmd_EFT(HttpServletRequest request, PayPrintForm form)
	{
		String PaymentRule = form.getPaymentRule();
		log.info(PaymentRule);
		if (!getChecks(request, form))
			return;
	}   //  cmd_EFT
}
