package com.ampiere.web.struts.form;

import java.io.Serializable;

import org.apache.struts.action.ActionForm;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPaymentBatch;
import org.compiere.util.Ctx;
import org.compiere.util.Msg;

/**
 * 
 * @author clmg
 *
 */
public class PayPrintForm extends ActionForm implements Serializable {


	private String title;
	
	private String paySelect;
	private String bank;
	private String paymentRule;
	private String documentNo;
	private String noPayments;
	private String Balance;
	private String currency;
	
	private String paySelectLabel;
	private String bankLabel;
	private String paymentRuleLabel;
	private String documentNoLabel;
	private String noPaymentsLabel;
	private String currencyLabel;
	private String BalanceLabel;
	
	private int m_C_BankAccount_ID = -1;
	private boolean enabledBProcess;
	
	/** Payment Information */
	private MPaySelectionCheck[]     m_checks = null;
	/** Payment Batch		*/
	private MPaymentBatch	m_batch = null; 
	/** action type */
	private String	actionType = ""; 


	/**
	 *	Static Setup - set field value
	 */
	public void statInit(Ctx ctx) {
		setPaySelectLabel(Msg.translate(ctx, "C_PaySelection_ID"));
		setBankLabel(Msg.translate(ctx, "C_BankAccount_ID"));
		setPaymentRuleLabel(Msg.translate(ctx, "PaymentRule"));
		setDocumentNoLabel(Msg.translate(ctx, "DocumentNo"));
		setNoPaymentsLabel(Msg.getMsg(ctx, "NoOfPayments"));
		setBalanceLabel(Msg.translate(ctx, "CurrentBalance"));
		setCurrencyLabel(Msg.translate(ctx, "C_Currency_ID"));
	}


	public String getTitle() {
		return title;
	}


	public void setTitle(String title) {
		this.title = title;
	}


	public String getPaySelect() {
		return paySelect;
	}


	public void setPaySelect(String paySelect) {
		this.paySelect = paySelect;
	}


	public String getBank() {
		return bank;
	}


	public void setBank(String bank) {
		this.bank = bank;
	}


	public String getPaymentRule() {
		return paymentRule;
	}


	public void setPaymentRule(String paymentRule) {
		this.paymentRule = paymentRule;
	}


	public String getDocumentNo() {
		return documentNo;
	}


	public void setDocumentNo(String documentNo) {
		this.documentNo = documentNo;
	}


	public String getNoPayments() {
		return noPayments;
	}


	public void setNoPayments(String noPayments) {
		this.noPayments = noPayments;
	}


	public String getCurrency() {
		return currency;
	}


	public void setCurrency(String currency) {
		this.currency = currency;
	}


	public String getPaySelectLabel() {
		return paySelectLabel;
	}


	public void setPaySelectLabel(String paySelectLabel) {
		this.paySelectLabel = paySelectLabel;
	}


	public String getBankLabel() {
		return bankLabel;
	}


	public void setBankLabel(String bankLabel) {
		this.bankLabel = bankLabel;
	}


	public String getPaymentRuleLabel() {
		return paymentRuleLabel;
	}


	public void setPaymentRuleLabel(String paymentRuleLabel) {
		this.paymentRuleLabel = paymentRuleLabel;
	}


	public String getDocumentNoLabel() {
		return documentNoLabel;
	}


	public void setDocumentNoLabel(String documentNoLabel) {
		this.documentNoLabel = documentNoLabel;
	}


	public String getNoPaymentsLabel() {
		return noPaymentsLabel;
	}


	public void setNoPaymentsLabel(String noPaymentsLabel) {
		this.noPaymentsLabel = noPaymentsLabel;
	}


	public String getCurrencyLabel() {
		return currencyLabel;
	}


	public void setCurrencyLabel(String currencyLabel) {
		this.currencyLabel = currencyLabel;
	}


	public String getBalance() {
		return Balance;
	}


	public void setBalance(String balance) {
		Balance = balance;
	}


	public String getBalanceLabel() {
		return BalanceLabel;
	}


	public void setBalanceLabel(String balanceLabel) {
		BalanceLabel = balanceLabel;
	}


	public int getM_C_BankAccount_ID() {
		return m_C_BankAccount_ID;
	}


	public void setM_C_BankAccount_ID(int bankAccount_ID) {
		m_C_BankAccount_ID = bankAccount_ID;
	}


	public boolean isEnabledBProcess() {
		return enabledBProcess;
	}


	public void setEnabledBProcess(boolean enabledBProcess) {
		this.enabledBProcess = enabledBProcess;
	}


	public MPaySelectionCheck[] getM_checks() {
		return m_checks;
	}


	public void setM_checks(MPaySelectionCheck[] m_checks) {
		this.m_checks = m_checks;
	}


	public MPaymentBatch getM_batch() {
		return m_batch;
	}


	public void setM_batch(MPaymentBatch m_batch) {
		this.m_batch = m_batch;
	}


	public String getActionType() {
		return actionType;
	}


	public void setActionType(String actionType) {
		this.actionType = actionType;
	}

}
