package com.ampiere.web.struts.form;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.httpclient.NameValuePair;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MForm;
import org.compiere.model.MLocatorLookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.WebSessionCtx;

import com.ampiere.util.Constants;
import com.ampiere.web.servlet.WWindowStatus;

/**
 * @author clmg
 */
public class TrxMaterial extends Action {

    /** Logger. */
    private CLogger log = CLogger.getCLogger(this.getClass());
    
    /** IMPORT FORMAT List. */
    private static final String IMP_FORMAT_LIST = "IMP_FORMAT_LIST";
    
    /** SUCCESS FORWARD. */
    private static final String SUCCESS = "success";

    /** Action Form. */
    private static final String ACTION_FORM = "GenerateShipmentFromOrderForm";

    /** Global Error Forward. */
    private static final String ERROR_FORWARD = "error";

    /** C_OrderLine.M_Warehouse_ID. */
    private static final int ORDERLINE_WAREHOUSE_COLUMN_ID = 2223;

    /** Form ID. */
    private static final int FORM_ID = 110;

    /**
     * Action execute.
     * @param mapping mapping
     * @param actionForm actionForm
     * @param request request
     * @param response response
     * @throws Exception Exception
     * @return ActionForward
     * @see org.apache.struts.action.Action#execute(
     *      org.apache.struts.action.ActionMapping,
     *      org.apache.struts.action.ActionForm,
     *      javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse)
     */
    public final ActionForward execute(
            final ActionMapping mapping,
            final ActionForm actionForm,
            final HttpServletRequest request,
            final HttpServletResponse response)
    throws Exception {
    	
		//201001 
        WebSessionCtx wscTest = WebSessionCtx.get(request); 
        if (wscTest == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute(Constants.SESSION_TIMEOUT_INFO, "Session Time Out. Please login again.");
            return mapping.findForward(Constants.SESSION_TIMEOUT);
        }
        //--201001	 

		String doQurey = "0";
		HttpSession session = request.getSession();
		
		WebSessionCtx wsc = WebSessionCtx.get(request); 
		WWindowStatus ws = WWindowStatus.get(request);
		if (wsc == null) {
			log.log(Level.SEVERE, "Session Time Out.");
			return mapping.findForward(ERROR_FORWARD);
		}

		MForm form = getForm(wsc.ctx, FORM_ID);
		wsc.ctx.setContext("FormName", form.getName());

		TrxMaterialForm trxMaterialForm =
			(TrxMaterialForm) request.getAttribute(ACTION_FORM);
		if (trxMaterialForm == null) {
			trxMaterialForm = (TrxMaterialForm) actionForm;
			if (trxMaterialForm == null) {
				trxMaterialForm = new TrxMaterialForm();
			}
		}
		trxMaterialForm.statInit(wsc.ctx);
		// Clear all
		session.setAttribute("searchResultPayment", null);
		
		//get org list
		ArrayList<NamePair> orgList = getOrgList(request);
		session.setAttribute("orgList", orgList);
		//get movement type
		ArrayList<NamePair> mtypeList = getMtypeList(request);
		session.setAttribute("mtypeList", mtypeList);
		
		//get locator list
		ArrayList<NamePair> locatorList = getLocatorList(request);
		session.setAttribute("locatorList", locatorList);

		// Set search info form
		trxMaterialForm.setTitle(Msg.getMsg(wsc.ctx, "TrxMaterial"));
		session.setAttribute("trxMaterialForm", trxMaterialForm);
		
		
		return mapping.findForward("success");
    }
    
    /**
     * Get Order List.
     * @param wsc context
     * @param warehouseId Ware House ID
     * @param businessPartnerId Business Partner ID
     * @return Order List
     */
    private ArrayList getImpFormatList() {
        
        ArrayList < NameValuePair > dataList = new ArrayList < NameValuePair > ();

		//	Load Formats
		String sql = "SELECT Name from AD_ImpFormat";
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql, null);
			ResultSet rs = pstmt.executeQuery();
			while (rs.next()){
				NameValuePair tmp = new NameValuePair(rs.getString(1), rs.getString(1));
				dataList.add(tmp);
			}
				
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql, e);
		}
        
        return dataList;
    }
    
    /**
     *  Get Form from Form ID.
     *  @param ctx Properties
     *  @param formId Form ID
     *  @return form
     */
    private MForm getForm(final Ctx ctx, final int formId) {

        // Get Form from Form ID
        MForm form = new MForm(ctx, formId, null);
        
        boolean trl = !Env.isBaseLanguage(ctx, "AD_Form");
        if (trl) {
            String sql = "SELECT t.Name, t.Description, t.Help "
                       + "FROM AD_Form f INNER JOIN AD_Form_Trl t"
                       + " ON (f.AD_Form_ID=t.AD_Form_ID AND AD_Language=?)"
                       + "WHERE f.AD_Form_ID=?";
            try {
                PreparedStatement pstmt = DB.prepareStatement(sql, null);
                if (trl) {
                    pstmt.setString(1, Env.getAD_Language(ctx));
                    pstmt.setInt(2, formId);

                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next()) {
                        form.setName(rs.getString(1));
                        form.setDescription(rs.getString(2));
                        form.setHelp(rs.getString(3));
                    }
                    rs.close();
                    pstmt.close();
                }
            } catch (SQLException e) {
                log.log(Level.SEVERE, sql, e);
            }
        }

        return form;
    }   //  getForm
    
    private ArrayList<NamePair> getOrgList(HttpServletRequest request){
    	WebSessionCtx wsc = WebSessionCtx.get(request); 
		MLookup orgLookup = MLookupFactory.get (wsc.ctx, 0, 3660, DisplayType.TableDir);
		ArrayList<NamePair> orgList = orgLookup.getData(true, false, false, false);
		return orgList;
    }
    
    private ArrayList<NamePair> getLocatorList(HttpServletRequest request){
    	WebSessionCtx wsc = WebSessionCtx.get(request); 
    	MLocatorLookup locatorLookup = new MLocatorLookup(wsc.ctx, 0);
    	ArrayList<NamePair> locatorList = locatorLookup.getData(true, false, false, false);
		return locatorList;
    }    

    private ArrayList<NamePair> getMtypeList(HttpServletRequest request){
    	WebSessionCtx wsc = WebSessionCtx.get(request); 
    	MLookup mtypeLookup = MLookupFactory.get (wsc.ctx, 0, 3666, DisplayType.List);
    	ArrayList<NamePair> mtypeList = mtypeLookup.getData(true, false, false, false);
		return mtypeList;
    }
}
