package com.ampiere.web.struts.form;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringUtils;
import org.apache.ecs.AlignType;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.framework.Query;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridWindow;
import org.compiere.model.GridWindowVO;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DisplayType;
import org.compiere.util.Msg;
import org.compiere.util.WebSessionCtx;

import com.ampiere.search.ColBean;
import com.ampiere.util.Constants;
import com.ampiere.web.servlet.WWindowStatus;

/**
 * @author siqinbilige
 */
public class TrxMaterialAction extends Action {

    /** Logger. */
    private CLogger log = CLogger.getCLogger(this.getClass());
    
    /** Order List Forward. */
    private static final String ORDER_LIST = "orderlist";

    /** Shipment List Forward. */
    private static final String SHIPMENT_LIST = "shipmentlist";

    /** Action Form. */
    private static final String ACTION_FORM = "GenerateShipmentFromOrderForm";

    /** Global Error Forward. */
    private static final String ERROR_FORWARD = "error";

    /** C_OrderLine.M_Warehouse_ID. */
    private static final int ORDER_BUSINESS_PARTNER_COLUMN_ID = 2762;

    /** Form ID. */
    private static final int FORM_ID = 110;

    /**
     * Action execute.
     * @param mapping mapping
     * @param form form
     * @param request request
     * @param response response
     * @throws Exception Exception
     * @return ActionForward
     * @see org.apache.struts.action.Action#execute(
     *      org.apache.struts.action.ActionMapping,
     *      org.apache.struts.action.ActionForm,
     *      javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse)
     */
    public final ActionForward execute(
            final ActionMapping mapping,
            final ActionForm form,
            final HttpServletRequest request,
            final HttpServletResponse response)
    throws Exception {
    	
		//201001 
        WebSessionCtx wscTest = WebSessionCtx.get(request); 
        if (wscTest == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute(Constants.SESSION_TIMEOUT_INFO, "Session Time Out. Please login again.");
            return mapping.findForward(Constants.SESSION_TIMEOUT);
        }
        //--201001	 

    	HttpSession session = request.getSession();

        WebSessionCtx wsc = WebSessionCtx.get(request); 
        if (wsc == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        
        TrxMaterialForm trxMaterialForm =  (TrxMaterialForm) form;        
       
        ArrayList<ColBean> result = getList(request, trxMaterialForm);
	    	// Set search result
	    session.setAttribute("searchResultTrxMaterial", result);
        
		trxMaterialForm.setTitle(Msg.getMsg(wsc.ctx, "TrxMaterial"));
		request.setAttribute("trxMaterialForm", trxMaterialForm);

        return mapping.findForward("success");
    }
    
    private ArrayList<ColBean> getList(HttpServletRequest request, TrxMaterialForm form){
    	WebSessionCtx wsc = WebSessionCtx.get(request); 
		int AD_Window_ID = 223;		//	Hardcoded
		int m_WindowNo = 0;
		WWindowStatus ws = WWindowStatus.get(request);
		GridWindowVO wVO = null;
		if(ws == null){
			wVO = GridWindowVO.create(wsc.ctx, 1, AD_Window_ID, 0);
			ws = new WWindowStatus(wVO);
//			sess.setAttribute(WWindowStatus.NAME, ws);
			WWindowStatus.set(request, ws.getCurTab().getAD_Window_ID(), ws);
		}else{
			wVO = GridWindowVO.create(wsc.ctx, ws.getCurTab().getWindowNo()+1 , AD_Window_ID, 0);
		}
		//GridWindowVO wVO = AEnv.getMWindowVO (m_WindowNo, AD_Window_ID, 0);
		 
		if (wVO == null)
			return null;
		GridWindow m_mWindow = new GridWindow (wVO);
		GridTab m_mTab = m_mWindow.getTab(0);
		
		m_mTab.setQuery(getQuery(request, form));
		m_mTab.query(0);
		ArrayList<ColBean> resultList = executeQuery(request, m_mTab);
		return resultList;
    }
    
	public ArrayList executeQuery(HttpServletRequest request, GridTab tab)
	{
		ArrayList<ColBean> resultList = new ArrayList<ColBean>();
		WebSessionCtx wsc = WebSessionCtx.get(request); 
		WWindowStatus ws = WWindowStatus.get(request);
		Ctx ctx = wsc.ctx;
		for (int i = 0; i < tab.getRowCount(); i++){
			ColBean colBean = new ColBean();
			int colOffset = 0;  //  columns start with 1
			int beanOffset = 0;
			
			for (int col = 0; col < tab.getFieldCount(); col++)
			{
				GridField field = tab.getField(col);
				
				Object data = null;
				int displayType = field.getDisplayType();
				int colIndex = col + colOffset;
				String style = "";
				Object test = ws.getCurTab().getValue(field);
				if (DisplayType.isID(displayType)) {
					data = tab.getValue(i, field.getColumnName());
				} else if (displayType == DisplayType.YesNo) {
					data = tab.getValue(i, field.getColumnName());
					if (data == null || "".equals(data)) {
						data = "N";
					}
					style += "text-align: " + AlignType.CENTER + ";";
				} else if (DisplayType.isDate(displayType)) {
					data = tab.getValue(i, field.getColumnName());
					data = wsc.dateFormat.format(data);
					style += "white-space: nowrap;";
				} else if (DisplayType.isNumeric(displayType)) {
					data = tab.getValue(i, field.getColumnName());
					style += "text-align: " + AlignType.RIGHT + ";";
				} else if (displayType == DisplayType.Integer) {
					data = tab.getValue(i, field.getColumnName());
					style += "text-align: " + AlignType.RIGHT + ";";
				} else {
					data = tab.getValue(i, field.getColumnName());
				}
				
				if(field.getLookup()!=null){
					data = field.getLookup().get(data);
				}
				
				colBean.setColData(beanOffset, data);
				colBean.setStyle(beanOffset, style);
				colBean.setColTitle(colIndex, Msg.translate(ctx, field.getColumnName()));
				if (field.isKey()) {
					colBean.setColId(data.toString());
					String colName = data.toString();
					colBean.setColName(colName);
				}
				beanOffset++;
			}
			
			resultList.add(colBean);
		}
		return resultList;
	}   //  executeQuery

	private Query getQuery(HttpServletRequest request, TrxMaterialForm form){
		WebSessionCtx wsc = WebSessionCtx.get(request); 
		Query query = new Query();
		query.addRestriction("AD_Client_ID", Query.EQUAL, wsc.ctx.getAD_Client_ID());
		//  Organization
		String value = form.getOrg();
		if (value != null && value.toString().length() > 0)
			query.addRestriction("AD_Org_ID", Query.EQUAL, value);
		//  Locator
		value = form.getLocator();
		if (value != null && value.toString().length() > 0)
			query.addRestriction("M_Locator_ID", Query.EQUAL, value);
		//  Product
		value = form.getProductd();
		if (value != null && value.toString().length() > 0)
			query.addRestriction("M_Product_ID", Query.EQUAL, value);
		//  MovementType
		value = form.getMtype();
		if (value != null && value.toString().length() > 0)
			query.addRestriction("MovementType", Query.EQUAL, value);
		//  DateFrom
		String fDateFrom = form.getDateF();		
		if (!StringUtils.isEmpty(fDateFrom))
		{
			try{
				Timestamp from = null;
				try{
					from = new Timestamp(wsc.dateFormat.parse(fDateFrom).getTime());
				}catch (Exception e){
					from = null;
				}
				query.addRestriction("TRUNC(MovementDate,'DD')", Query.GREATER_EQUAL, from);
			}catch(Exception e){
				;
			}
		}
		//  DateTO
		String fDateTo = form.getDateT();		
		if (!StringUtils.isEmpty(fDateTo))
		{
			try{
				Timestamp to = null;
				try{
					to = new Timestamp(wsc.dateFormat.parse(fDateTo).getTime());
				}catch (Exception e){
					to = null;
				}
				query.addRestriction("TRUNC(MovementDate,'DD')", Query.LESS_EQUAL, to);
			}catch(Exception e){
				;
			}
		}
		
		return query;
	}
}
