package com.ampiere.web.struts.form;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MColumn;
import org.compiere.model.MForm;
import org.compiere.model.MRefList;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;
import org.compiere.wf.MWFActivity;
import org.compiere.wf.MWFNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ampiere.util.AWebUtil;
import com.ampiere.util.Constants;
import com.ampiere.web.servlet.WWindowStatus;
import com.jware.util.StringToIntConverter;

/**
 * @author clmg
 */
public class WorkFlowActivity extends Action {

    /** Logger. */
    private CLogger log = CLogger.getCLogger(this.getClass());    
    
    /** SUCCESS FORWARD. */
    private static final String SUCCESS = "success";

    /** Action Form. */
    private static final String ACTION_FORM = "WorkFlowActivityForm";

    /** Global Error Forward. */
    private static final String ERROR_FORWARD = "error";

    /** Form ID. */
    private static final int FORM_ID = 117;
    
    private static final String PREV_ACTION = "1";
    private static final String NEXT_ACTION = "2";
    private static final String APPROVE_ACTION = "3";

    /**
     * Action execute.
     * @param mapping mapping
     * @param actionForm actionForm
     * @param request request
     * @param response response
     * @throws Exception Exception
     * @return ActionForward
     * @see org.apache.struts.action.Action#execute(
     *      org.apache.struts.action.ActionMapping,
     *      org.apache.struts.action.ActionForm,
     *      javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse)
     */
    public final ActionForward execute(
            final ActionMapping mapping,
            final ActionForm actionForm,
            final HttpServletRequest request,
            final HttpServletResponse response)
    throws Exception {
    	
        WebSessionCtx wscTest = WebSessionCtx.get(request); 
        if (wscTest == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute(Constants.SESSION_TIMEOUT_INFO, "Session Time Out. Please login again.");
            return mapping.findForward(Constants.SESSION_TIMEOUT);
        }

		String doQurey = "0";
		HttpSession session = request.getSession();
		
		WebSessionCtx wsc = WebSessionCtx.get(request); 
		WWindowStatus ws = WWindowStatus.get(request);
		if (wsc == null) {
			log.log(Level.SEVERE, "Session Time Out.");
			return mapping.findForward(ERROR_FORWARD);
		}

		MForm form = getForm(wsc.ctx, FORM_ID);
		wsc.ctx.setContext("FormName", form.getName());

		WorkFlowActivityForm workFlowActivityForm =
			(WorkFlowActivityForm) request.getAttribute(ACTION_FORM);
		if (workFlowActivityForm == null) {
			workFlowActivityForm = (WorkFlowActivityForm) actionForm;
			if (workFlowActivityForm == null) {
				workFlowActivityForm = new WorkFlowActivityForm();
			}
		}
		workFlowActivityForm.statInit(wsc.ctx);
		workFlowActivityForm.setTitle(form.getName());
		
		//ここから。。。
		String actionType = request.getParameter(Constants.ACTION_TYPE);
		if(PREV_ACTION.equals(actionType)){
		//prev/next workflow, asynchronous
			Document xml_doc = null;
			if(xml_doc == null){
				//成功した場合 workflow viewを更新(current workflowを更新)
				MWFActivity currentWorkflow = getPrevWfActivity(request);
				if(currentWorkflow != null){
					xml_doc = setWorkFlowActivityAjax(request, currentWorkflow);
				}
			}
			AWebUtil.createCalloutAjaxResponse(response, xml_doc);
			return null;
		}else if(NEXT_ACTION.equals(actionType)){
			Document xml_doc = null;
			if(xml_doc == null){
				//成功した場合 workflow viewを更新(current workflowを更新)
				MWFActivity currentWorkflow = getNextWfActivity(request);
				if(currentWorkflow != null){
					xml_doc = setWorkFlowActivityAjax(request, currentWorkflow);
				}
			}
			AWebUtil.createCalloutAjaxResponse(response, xml_doc);
			return null;
		}else if(APPROVE_ACTION.equals(actionType)){
			//asynchronous
			Document xml_doc = cmd_OK(request, workFlowActivityForm);
			if(xml_doc == null){
				//成功した場合 workflow viewを更新(current workflowを更新)
				MWFActivity currentWorkflow = getCurrentWfActivity(request);
				if(currentWorkflow != null){
					xml_doc = setWorkFlowActivityAjax(request, currentWorkflow);
				}else{
					//reload, not ajax
					ArrayList<MWFActivity> workFlowList = loadActivities(request);
					if(workFlowList!=null && workFlowList.size() > 0){
						int m_index = 0;
						currentWorkflow = workFlowList.get(m_index);
						setWorkFlowActivityForm(workFlowActivityForm, currentWorkflow);
						workFlowActivityForm.setWfActivityId(String.valueOf(currentWorkflow.getAD_WF_Activity_ID()));
						workFlowActivityForm.setWfActivitySeqNo("0");
						workFlowActivityForm.setWorkflowNum(workFlowList.size());
					}else{
						workFlowActivityForm.setWorkflowNum(0);
					}
					//get org list
					ArrayList<ValueNamePair> answerList = getAnswerList(request);
					session.setAttribute("answerList", answerList);

					// Set search info form
					workFlowActivityForm.setTitle(Msg.getMsg(wsc.ctx, "WFActivity"));
					session.setAttribute("WorkFlowActivityForm", workFlowActivityForm);			
					
					return mapping.findForward("success");
				}
			}
			AWebUtil.createCalloutAjaxResponse(response, xml_doc);
			return null;
		}else{
			MWFActivity currentWorkflow = null;
			ArrayList<MWFActivity> workFlowList = loadActivities(request);
			if(workFlowList!=null && workFlowList.size() > 0){
				int m_index = 0;
				currentWorkflow = workFlowList.get(m_index);
				setWorkFlowActivityForm(workFlowActivityForm, currentWorkflow);
				workFlowActivityForm.setWfActivityId(String.valueOf(currentWorkflow.getAD_WF_Activity_ID()));
				workFlowActivityForm.setWfActivitySeqNo("0");
				workFlowActivityForm.setWorkflowNum(workFlowList.size());
			}else{
				workFlowActivityForm.setWorkflowNum(0);
			}
			//get org list
			ArrayList<ValueNamePair> answerList = getAnswerList(request);
			session.setAttribute("answerList", answerList);

			// Set search info form
			workFlowActivityForm.setTitle(Msg.getMsg(wsc.ctx, "WFActivity"));
			session.setAttribute("WorkFlowActivityForm", workFlowActivityForm);			
			
			return mapping.findForward("success");
		}
    }    
   
    /**
     *  Get Form from Form ID.
     *  @param ctx Properties
     *  @param formId Form ID
     *  @return form
     */
    private MForm getForm(final Ctx ctx, final int formId) {

        // Get Form from Form ID
        MForm form = new MForm(ctx, formId, null);
        
        boolean trl = !Env.isBaseLanguage(ctx, "AD_Form");
        if (trl) {
            String sql = "SELECT t.Name, t.Description, t.Help "
                       + "FROM AD_Form f INNER JOIN AD_Form_Trl t"
                       + " ON (f.AD_Form_ID=t.AD_Form_ID AND AD_Language=?)"
                       + "WHERE f.AD_Form_ID=?";
            try {
                PreparedStatement pstmt = DB.prepareStatement(sql, null);
                if (trl) {
                    pstmt.setString(1, Env.getAD_Language(ctx));
                    pstmt.setInt(2, formId);

                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next()) {
                        form.setName(rs.getString(1));
                        form.setDescription(rs.getString(2));
                        form.setHelp(rs.getString(3));
                    }
                    rs.close();
                    pstmt.close();
                }
            } catch (SQLException e) {
                log.log(Level.SEVERE, sql, e);
            }
        }

        return form;
    }   //  getForm
    
    /**
     * _YesNo
     * @param request
     * @return
     */
    private ArrayList<ValueNamePair> getAnswerList(HttpServletRequest request){
    	WebSessionCtx wsc = WebSessionCtx.get(request); 
    	ValueNamePair[] values = MRefList.getList(319, false);		//	_YesNo
    	ArrayList<ValueNamePair> answerList = new ArrayList(Arrays.asList(values)); 
		return answerList;
    }
    
	/**
	 * 	Load Activities
	 * 	@return int
	 */
	public ArrayList<MWFActivity> loadActivities(HttpServletRequest request)
	{
		WebSessionCtx wsc = WebSessionCtx.get(request); 
		long start = System.currentTimeMillis();
		ArrayList<MWFActivity> list = new ArrayList<MWFActivity>();
		String sql = "SELECT * FROM AD_WF_Activity a "
			+ "WHERE a.Processed='N' AND a.WFState='OS' AND ("
			//	Owner of Activity
			+ " a.AD_User_ID=?"	//	#1
			//	Invoker (if no invoker = all)
			+ " OR EXISTS (SELECT * FROM AD_WF_Responsible r WHERE a.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID"
			+ " AND COALESCE(r.AD_User_ID,0)=0 AND (a.AD_User_ID=? OR a.AD_User_ID IS NULL))"	//	#2
			// Responsible User
			+ " OR EXISTS (SELECT * FROM AD_WF_Responsible r WHERE a.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID"
			+ " AND r.AD_User_ID=?)"		//	#3
			//	Responsible Role
			+ " OR EXISTS (SELECT * FROM AD_WF_Responsible r INNER JOIN AD_User_Roles ur ON (r.AD_Role_ID=ur.AD_Role_ID)"
			+ " WHERE a.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND ur.AD_User_ID=?)"	//	#4
			//
			+ ") ORDER BY a.Priority DESC, Created";
		int AD_User_ID = wsc.ctx.getAD_User_ID();
		PreparedStatement pstmt = null;
		try
		{
			pstmt = DB.prepareStatement (sql, null);
			pstmt.setInt (1, AD_User_ID);
			pstmt.setInt (2, AD_User_ID);
			pstmt.setInt (3, AD_User_ID);
			pstmt.setInt (4, AD_User_ID);
			ResultSet rs = pstmt.executeQuery ();
			while (rs.next ())
			{
				list.add (new MWFActivity(wsc.ctx, rs, null));
				if (list.size() > 200)		//	HARDCODED
				{
					log.warning("More then 200 Activities - ignored");
					break;
				}
			}
			rs.close ();
			pstmt.close ();
			pstmt = null;
		}
		catch (Exception e)
		{
			log.log(Level.SEVERE, sql, e);
		}
		try
		{
			if (pstmt != null)
				pstmt.close ();
			pstmt = null;
		}
		catch (Exception e)
		{
			pstmt = null;
		}	
		
		return list;
	}	//	loadActivities   
	
	private MWFActivity getWfActivity(HttpServletRequest request, int wfActivityId){
		ArrayList<MWFActivity> workFlowList = loadActivities(request);
		MWFActivity m_activity = null;
		for(int i = 0; i < workFlowList.size(); i++){
			MWFActivity tmpActivity = workFlowList.get(i);
			if(tmpActivity.getAD_WF_Activity_ID() == wfActivityId){
				m_activity = tmpActivity;
				break;
			}
		}
		return m_activity;
	}
	
	private MWFActivity getCurrentWfActivity(HttpServletRequest request){
		ArrayList<MWFActivity> workFlowList = loadActivities(request);
		int wfActivitySeqNo = StringToIntConverter.StringToInt(WebUtil.getParameter(request, "wfActivitySeqNo"));
		MWFActivity m_activity = null;
		if(workFlowList !=null && workFlowList.size() > 0){
			if(wfActivitySeqNo <  workFlowList.size()){
				m_activity = workFlowList.get(wfActivitySeqNo);
				request.setAttribute("wfActivitySeqNo", wfActivitySeqNo);
			}else{
				m_activity = workFlowList.get(0);
				request.setAttribute("wfActivitySeqNo", 0);
			}
		}

		return m_activity;
	}
	
	private MWFActivity getNextWfActivity(HttpServletRequest request){
		ArrayList<MWFActivity> workFlowList = loadActivities(request);
		int wfActivitySeqNo = StringToIntConverter.StringToInt(WebUtil.getParameter(request, "wfActivitySeqNo"));
		wfActivitySeqNo++;
		MWFActivity m_activity = null;
		if(workFlowList !=null && workFlowList.size() > 0){
			if(wfActivitySeqNo <  workFlowList.size()){
				m_activity = workFlowList.get(wfActivitySeqNo);
				request.setAttribute("wfActivitySeqNo", wfActivitySeqNo);
			}else{
				m_activity = workFlowList.get(workFlowList.size() - 1);
				request.setAttribute("wfActivitySeqNo", workFlowList.size() - 1);
			}
		}

		return m_activity;
	}
	
	private MWFActivity getPrevWfActivity(HttpServletRequest request){
		ArrayList<MWFActivity> workFlowList = loadActivities(request);
		int wfActivitySeqNo = StringToIntConverter.StringToInt(WebUtil.getParameter(request, "wfActivitySeqNo"));
		wfActivitySeqNo --;
		if(wfActivitySeqNo < 1){
			wfActivitySeqNo = 0;
		}
		MWFActivity m_activity = null;
		if(workFlowList !=null && workFlowList.size() > 0){
			if(wfActivitySeqNo <  workFlowList.size()){
				m_activity = workFlowList.get(wfActivitySeqNo);
				request.setAttribute("wfActivitySeqNo", wfActivitySeqNo);
			}else{
				m_activity = workFlowList.get(0);
				request.setAttribute("wfActivitySeqNo", 0);
			}
		}

		return m_activity;
	}
	
	private void setWorkFlowActivityForm(WorkFlowActivityForm workFlowActivityForm, MWFActivity workflow){
		workFlowActivityForm.setNode(workflow.getNodeName());
		workFlowActivityForm.setDescription(workflow.getNodeDescription());
		workFlowActivityForm.setHelp(workflow.getNodeHelp());
		workFlowActivityForm.setHistory(workflow.getHistoryHTML());
		workFlowActivityForm.setTextMsg(workflow.getTextMsg());		
	}
	
	private Document setWorkFlowActivityAjax(HttpServletRequest request, MWFActivity workflow){
		Document document = null;

		try{
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			document = builder.newDocument();
			Element elements = document.createElement(Constants.ELEMENTS);
			document.appendChild(elements);   
			Element element = document.createElement(Constants.ELEMENT);
			elements.appendChild(element);
			
			addElement(document, element, "wfActivityId", String.valueOf(workflow.getAD_WF_Activity_ID()));
			addElement(document, element, "wfActivitySeqNo", String.valueOf(request.getAttribute("wfActivitySeqNo")));
			addElement(document, element, "wfNode", workflow.getNodeName());
			addElement(document, element, "wfDescription", workflow.getNodeDescription());
			addElement(document, element, "wfHelp", workflow.getNodeDescription());
			addElement(document, element, "wfHistory", workflow.getHistoryHTML());
			addElement(document, element, "wfTextMsg", workflow.getTextMsg());
			addElement(document, element, "wfPreviousButton", Constants.ENABLED);
			addElement(document, element, "wfNextButton", Constants.ENABLED);
			addElement(document, element, "wfApproveButton", Constants.ENABLED);
			
			ArrayList<MWFActivity> workFlowList = loadActivities(request);
			addElement(document, element, "wfNum", String.valueOf(workFlowList.size()));
		}catch(Exception e){
			log.warning("Error occured in function setWorkFlowActivityAjax\n");
		}
		return document;
	}
	
	private void addElement(Document document, Element element, String tagName, String tagValue){
		Element newElement = document.createElement(tagName);
		if(tagValue==null){
			tagValue = "";
		}
		newElement.appendChild(document.createTextNode(tagValue));
		element.appendChild(newElement);
	}
	
	
	/**
	 * 	Save
	 */
	private Document cmd_OK(HttpServletRequest request, WorkFlowActivityForm workFlowActivityForm)
	{
		WebSessionCtx wsc = WebSessionCtx.get(request); 	
		int wfActivityId = StringToIntConverter.StringToInt(WebUtil.getParameter(request, "wfActivityId"));
		MWFActivity m_activity = getWfActivity(request, wfActivityId);;
		if (m_activity == null)
			return null;
		
		Document document = null;

		try{
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			//ビルダーからDOMを取得する
			document = builder.newDocument();
			int AD_User_ID = wsc.ctx.getAD_User_ID();
			String textMsg = workFlowActivityForm.getTextMsg();	

			//
			MWFNode node = m_activity.getNode();
			
			String forward = workFlowActivityForm.getForwardId();
			if (!StringUtils.isEmpty(forward))
			{
				log.config("Forward to " + forward);
				int fw = StringToIntConverter.StringToInt(forward);
				if (fw == AD_User_ID || fw == 0)
				{
					log.log(Level.SEVERE, "Forward User=" + fw);
					return document;
				}
				if (!m_activity.forwardTo(fw, textMsg))
				{
					Element element = document.createElement(Constants.SCRIPT);
					document.appendChild(element);
					String message = Msg.getMsg(wsc.ctx, "CannotForward");
					element.appendChild(document.createTextNode(message));
					return document;
				}
			}
			//	User Choice - Answer
			else if (MWFNode.ACTION_UserChoice.equals(node.getAction()))
			{
				MColumn	m_column = node.getColumn();
				//	Do we have an answer?
				int dt = m_column.getAD_Reference_ID();
				String value = workFlowActivityForm.getAnswer();
				if (value == null || value.length() == 0)
				{
					Element element = document.createElement(Constants.SCRIPT);
					document.appendChild(element);
					String message = Msg.getMsg(wsc.ctx, "FillMandatory") 
						+ "\n"
						+ Msg.getMsg(wsc.ctx, "Answer");
					element.appendChild(document.createTextNode(message));
					return document;
				}
				//
				log.config("Answer=" + value + " - " + textMsg);
				try
				{
					m_activity.setUserChoice(AD_User_ID, value, dt, textMsg);
				}
				catch (Exception e)
				{
					Element element = document.createElement(Constants.SCRIPT);
					document.appendChild(element);
					String message = Msg.getMsg(wsc.ctx, "Error") 
						+ "\n"
						+ e.toString();
					element.appendChild(document.createTextNode(message));
					return document;
				}
			}
			//	User Action
			else
			{
				log.config("Action=" + node.getAction() + " - " + textMsg);
				try
				{
					m_activity.setUserConfirmation(AD_User_ID, textMsg);
				}
				catch (Exception e)
				{
					log.log(Level.SEVERE, node.getName(), e);
					Element element = document.createElement(Constants.SCRIPT);
					document.appendChild(element);
					String message = Msg.getMsg(wsc.ctx, "Error") 
						+ "\n"
						+ e.toString();
					element.appendChild(document.createTextNode(message));
					return document;
				}
				
			}
		}catch(Exception e){
			;
		}
		return null;
	}	//	cmd_OK	
}
