package com.ampiere.web.struts.search;

import java.rmi.RemoteException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.commons.lang.StringUtils;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.db.CConnection;
import org.compiere.interfaces.Server;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MFactAcct;
import org.compiere.model.MRefList;
import org.compiere.model.X_C_AcctSchema_Element;
import org.compiere.report.core.RColumn;
import org.compiere.report.core.RModel;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;
import org.compiere.util.WebSessionCtx;
import org.w3c.dom.Document;

import com.ampiere.acct.Post;
import com.ampiere.util.AWebUtil;
import com.ampiere.util.AmpiereUtil;
import com.ampiere.util.Constants;
import com.ampiere.web.servlet.WWindowStatus;
import com.jware.util.StringToIntConverter;

/**
 * @author clmg
 */
public class AcctViewer extends Action {

    /** Logger. */
    private CLogger log = CLogger.getCLogger(this.getClass());    
    
    /** SUCCESS FORWARD. */
    private static final String SUCCESS = "success";

    /** Action Form. */
    private static final String ACTION_FORM = "AcctViewerForm";

    /** Global Error Forward. */
    private static final String ERROR_FORWARD = "error";
    
    int m_leadingColumns = 0;
	String m_ref1;
	String m_ref2;
	
	String ACTION_SEL_SCHEMA = "1";
	String ACTION_QUERY = "2";
	String ACTION_SEL_DOCUMENT = "3";
	String ACTION_SEL_TABLE = "4";
	String ACTION_RE_POST = "5";
	String ACTION_PRINT = "6";
	int SEL_COUNT = 8;
	
	String RESULT_DIV_ID = "resultDiv";
	String SELECTED_TABLE_KEY = "selectedKey";

    /**
     * Action execute.
     * @param mapping mapping
     * @param actionForm actionForm
     * @param request request
     * @param response response
     * @throws Exception Exception
     * @return ActionForward
     * @see org.apache.struts.action.Action#execute(
     *      org.apache.struts.action.ActionMapping,
     *      org.apache.struts.action.ActionForm,
     *      javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse)
     */
    public final ActionForward execute(
            final ActionMapping mapping,
            final ActionForm actionForm,
            final HttpServletRequest request,
            final HttpServletResponse response)
    throws Exception {
    	
        WebSessionCtx wscTest = WebSessionCtx.get(request); 
        if (wscTest == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute(Constants.SESSION_TIMEOUT_INFO, "Session Time Out. Please login again.");
            return mapping.findForward(Constants.SESSION_TIMEOUT);
        }
        
	  	WebSessionCtx wsc = WebSessionCtx.get(request);
	  	WWindowStatus ws = WWindowStatus.get(request);
	  	HttpSession session = request.getSession();

		String doQurey = "0";
		
		
		if (wsc == null) {
			log.log(Level.SEVERE, "Session Time Out.");
			return mapping.findForward(ERROR_FORWARD);
		}

		AcctViewerForm acctViewerForm =
			(AcctViewerForm) request.getAttribute(ACTION_FORM);
		if (acctViewerForm == null) {
			acctViewerForm = (AcctViewerForm) actionForm;
			if (acctViewerForm == null) {
				acctViewerForm = new AcctViewerForm();
			}
		}
		acctViewerForm.statInit(wsc.ctx);
		
		String actionType = request.getParameter(Constants.ACTION_TYPE);
		if(ACTION_SEL_SCHEMA.equals(actionType)){
			//ページを再ロードする。			
		}
		else if(ACTION_QUERY.equals(actionType)){
			Document xml_doc = actionQuery(request);
			AWebUtil.createCalloutAjaxResponse(response, xml_doc);
			return null;
		}		
		else if(ACTION_RE_POST.equals(actionType)){
			Document xml_doc = actionRePost(request);
			AWebUtil.createCalloutAjaxResponse(response, xml_doc);
			return null;
		}
	
		// Set search info form
		acctViewerForm.setTitle(Msg.getMsg(wsc.ctx, "Archive"));
		List<KeyNamePair> acctSchemaList = getAcctSchemaList(request);
		List<ValueNamePair> tableList = getTableList(request);
		List<ValueNamePair> postingTypeList = getPostingTypeList(request);
		List<KeyNamePair> orgList = getOrgList(request);
		List<ValueNamePair> sortByItemList = getSortByItemList(request);
		
		request.setAttribute("acctSchemaList", acctSchemaList);
		request.setAttribute("tableList", tableList);
		request.setAttribute("postingTypeList", postingTypeList);
		request.setAttribute("orgList", orgList);
		request.setAttribute("sortByItemList", sortByItemList);
		
		addButtons(request, acctViewerForm);
		
		acctViewerForm.setRePostMsg(AWebUtil.info(request, "PostImmediate?", null));
		
		//set default record id
		if(tableList != null){
			acctViewerForm.setRecordId(tableList.get(0).getID()+"_ID");
		}
		
		request.setAttribute(ACTION_FORM, acctViewerForm);	

		return mapping.findForward("success");
    }    
 
    /**
     * 
     * @param request
     * @return
     */
    private List<KeyNamePair> getAcctSchemaList(HttpServletRequest request){
		WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);
		List<KeyNamePair> acctSchemaList = new ArrayList();
		int AD_Client_ID = wsc.ctx.getContextAsInt( "AD_Client_ID");
		//
		MAcctSchema[] ASchemas = MAcctSchema.getClientAcctSchema(wsc.ctx, AD_Client_ID);
		KeyNamePair onePair;
		for( int i = 0; i < ASchemas.length; i++ ){
			onePair = new KeyNamePair( ASchemas[i].getC_AcctSchema_ID(), ASchemas[i].getName() ) ;
			acctSchemaList.add(onePair);
		}
		
    	return acctSchemaList;
    }

    /**
     * 
     * @param request
     * @return
     */
    private List<ValueNamePair> getTableList(HttpServletRequest request){
		WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);
		int AD_Table_ID = 0;
		List<ValueNamePair> tableList = new ArrayList();
		String defaultKey = null;
		//
		String sql = "SELECT AD_Table_ID, TableName FROM AD_Table t "
			+ "WHERE EXISTS (SELECT * FROM AD_Column c"
			+ " WHERE t.AD_Table_ID=c.AD_Table_ID AND c.ColumnName='Posted')"
			+ " AND IsView='N'";
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql, null);
			ResultSet rs = pstmt.executeQuery();
			while (rs.next())
			{
				int id = rs.getInt(1);
				String tableName = rs.getString(2);
				String name = Msg.translate(wsc.ctx, tableName+"_ID");
				//
				ValueNamePair pp = new ValueNamePair(tableName, name);
				tableList.add(pp);
				if (id == AD_Table_ID)
					defaultKey = pp.getValue();
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql, e);
		}
    	return tableList;
    }
    
    /**
     * 
     * @param request
     * @return
     */
    private List<ValueNamePair> getTableIdNameList(HttpServletRequest request){
		List<ValueNamePair> tableList = new ArrayList();
		//
		String sql = "SELECT AD_Table_ID, TableName FROM AD_Table t "
			+ "WHERE EXISTS (SELECT * FROM AD_Column c"
			+ " WHERE t.AD_Table_ID=c.AD_Table_ID AND c.ColumnName='Posted')"
			+ " AND IsView='N'";
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql, null);
			ResultSet rs = pstmt.executeQuery();
			while (rs.next())
			{
				int id = rs.getInt(1);
				String tableName = rs.getString(2);
				//
				ValueNamePair pp = new ValueNamePair(String.valueOf(id), tableName);
				tableList.add(pp);
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql, e);
		}
    	return tableList;
    }
    
    /**
     * 
     * @param request
     * @return
     */
    private List<ValueNamePair> getPostingTypeList(HttpServletRequest request){
		WebSessionCtx wsc = WebSessionCtx.get(request);
		int AD_Role_ID = wsc.ctx.getAD_Role_ID();
		int AD_Reference_ID = 125;
		ArrayList< ValueNamePair > postingTypeList = new ArrayList< ValueNamePair >( Arrays.asList( MRefList.getList( AD_Reference_ID, true ) ) );
    	return postingTypeList;
    }
    
    private List<KeyNamePair> getOrgList(HttpServletRequest request){
		WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);
		int AD_Client_ID = wsc.ctx.getContextAsInt( "AD_Client_ID");
		ArrayList< KeyNamePair > orgList = new ArrayList< KeyNamePair >();
		KeyNamePair pp = new KeyNamePair(0, "");
		orgList.add( pp );
		String sql = "SELECT AD_Org_ID, Name FROM AD_Org WHERE AD_Client_ID=? ORDER BY Value";
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql, null);
			pstmt.setInt(1, AD_Client_ID);
			ResultSet rs = pstmt.executeQuery();
			while (rs.next())
				orgList.add( new KeyNamePair( rs.getInt( 1 ), rs.getString( 2 ) ) );
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql, e);
		}
		return orgList;
    }
    
    private List<ValueNamePair> getSortByItemList(HttpServletRequest request){
		WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);
		int AD_Client_ID = wsc.ctx.getContextAsInt( "AD_Client_ID");
		ArrayList< ValueNamePair > sortByItemList = new ArrayList< ValueNamePair >();
		sortByItemList.add(new ValueNamePair("",""));
		sortByItemList.add(new ValueNamePair("DateAcct", Msg.translate(wsc.ctx, "DateAcct")));
		sortByItemList.add(new ValueNamePair("DateTrx", Msg.translate(wsc.ctx, "DateTrx")));
		sortByItemList.add(new ValueNamePair("C_Period_ID", Msg.translate(wsc.ctx, "C_Period_ID")));
		MAcctSchema[] ASchemas = MAcctSchema.getClientAcctSchema(wsc.ctx, AD_Client_ID);
		MAcctSchemaElement[] elements = ASchemas[0].getAcctSchemaElements();
		int selectionIndex = 0;
		for (int i = 0; i < elements.length && selectionIndex < 8; i++)
		{
			MAcctSchemaElement ase = elements[i];
			String columnName = ase.getColumnName();
			String displayColumnName = ase.getDisplayColumnName();
			//  Add Sort Option
			sortByItemList.add(new ValueNamePair(columnName, Msg.translate(wsc.ctx, displayColumnName)));
		}
		return sortByItemList;
    }
    
    private void addButtons(HttpServletRequest request, AcctViewerForm acctViewerForm){
		WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);
		int AD_Client_ID = wsc.ctx.getContextAsInt( "AD_Client_ID");
		int selectionIndex = 1;
		MAcctSchema[] ASchemas = MAcctSchema.getClientAcctSchema(wsc.ctx, AD_Client_ID);
		int acctSchemaId = StringToIntConverter.StringToInt(request.getParameter("acctSchema"));
		MAcctSchemaElement[] elements = ASchemas[0].getAcctSchemaElements();
		for (int i = 0; i < elements.length && selectionIndex <= SEL_COUNT; i++)
		{
			MAcctSchemaElement ase = elements[i];
			String columnName = ase.getColumnName();
			String displayColumnName = ase.getDisplayColumnName();
			//  Additional Elements
			if (!ase.isElementType(X_C_AcctSchema_Element.ELEMENTTYPE_Organization) 
				&& !ase.isElementType(X_C_AcctSchema_Element.ELEMENTTYPE_Account))
			{
				String label = Msg.translate(wsc.ctx, displayColumnName);
				switch(selectionIndex){
				case 1: 
					acctViewerForm.setSel1L(label);
					acctViewerForm.setSel1(columnName);
					acctViewerForm.setSel1Id(String.valueOf(AmpiereUtil.getFixedColumnID(columnName)));
					break;
				case 2: 
					acctViewerForm.setSel2L(label);
					acctViewerForm.setSel2(columnName);
					acctViewerForm.setSel2Id(String.valueOf(AmpiereUtil.getFixedColumnID(columnName)));
					break;
				case 3: 
					acctViewerForm.setSel3L(label);
					acctViewerForm.setSel3(columnName);
					acctViewerForm.setSel3Id(String.valueOf(AmpiereUtil.getFixedColumnID(columnName)));
					break;
				case 4: 
					acctViewerForm.setSel4L(label);
					acctViewerForm.setSel4(columnName);
					acctViewerForm.setSel4Id(String.valueOf(AmpiereUtil.getFixedColumnID(columnName)));
					break;
				case 5: 
					acctViewerForm.setSel5L(label);
					acctViewerForm.setSel5(columnName);
					acctViewerForm.setSel5Id(String.valueOf(AmpiereUtil.getFixedColumnID(columnName)));
					break;
				case 6: 
					acctViewerForm.setSel6L(label);
					acctViewerForm.setSel6(columnName);
					acctViewerForm.setSel6Id(String.valueOf(AmpiereUtil.getFixedColumnID(columnName)));
					break;
				case 7: 
					acctViewerForm.setSel7L(label);
					acctViewerForm.setSel7(columnName);
					acctViewerForm.setSel7Id(String.valueOf(AmpiereUtil.getFixedColumnID(columnName)));
					break;
				case 8: 
					acctViewerForm.setSel8L(label);
					acctViewerForm.setSel8(columnName);
					acctViewerForm.setSel8Id(String.valueOf(AmpiereUtil.getFixedColumnID(columnName)));
					break;
				}
				selectionIndex++;
			}
		}
    }
    
	/**
	 *  Query
	 */
	private Document actionQuery(HttpServletRequest request)
	{
		WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);
		int AD_Table_ID = getAdTableId(request);
		int Record_ID = 0;
		if(!StringUtils.isEmpty(request.getParameter(SELECTED_TABLE_KEY))){
			Record_ID = StringToIntConverter.StringToInt(request.getParameter(SELECTED_TABLE_KEY));
		}
		Timestamp from = null;
		Timestamp to = null;		
		
		Document document = CreateNewDocument(request);		
		//  Parameter Info
		StringBuffer para = new StringBuffer();
		//  Reset Selection Data
		int C_AcctSchema_ID = 0;
		int AD_Org_ID = 0;

		//  Save Selection Choices
		C_AcctSchema_ID = StringToIntConverter.StringToInt(request.getParameter("acctSchema"));
		para.append("C_AcctSchema_ID=").append(C_AcctSchema_ID);
		//
		String PostingType = request.getParameter("postingType");
		para.append(", PostingType=").append(PostingType);

		//  Document
		boolean documentQuery = false;
		if(Constants.ON.equals(request.getParameter("documentSelected"))){
			documentQuery = true;
		}
		para.append(", DocumentQuery=").append(documentQuery);
		if (documentQuery)
		{
			if (AD_Table_ID == 0 || Record_ID == 0)
				return null;
			para.append(", AD_Table_ID=").append(AD_Table_ID)
				.append(", Record_ID=").append(Record_ID);
		}
		else
		{
			String DateFrom = request.getParameter("dateFrom");
			if (!StringUtils.isEmpty(DateFrom))
			{
				try{					
					try{
						from = new Timestamp(wsc.dateFormat.parse(DateFrom).getTime());
					}catch (Exception e){
						from = null;
					}
					para.append(", DateFrom=").append(from);
				}catch(Exception e){
					;
				}
			}
			
			String DateTo = request.getParameter("dateTo");
			if (!StringUtils.isEmpty(DateTo))
			{
				try{					
					try{
						to = new Timestamp(wsc.dateFormat.parse(DateTo).getTime());
					}catch (Exception e){
						to = null;
					}
					para.append(", DateTo=").append(to);
				}catch(Exception e){
					;
				}
			}

			
			AD_Org_ID = StringToIntConverter.StringToInt(request.getParameter("adOrgID"));
			para.append(", AD_Org_ID=").append(AD_Org_ID);
			//action button
			for(int i = 1; i <= SEL_COUNT; i++){
				String columnName = "selColumn" + i;
				String keyColumn = request.getParameter(columnName);
				String queryValue = "sel" + i + "D";
				if(!StringUtils.isEmpty(request.getParameter(queryValue))){
					String value = request.getParameter(queryValue);
					para.append(", ").append(keyColumn + "=" + value);
				}
			}
		}
//
		//  Save Display Choices
		boolean displayQty = AWebUtil.onoffStringToBoolean(request.getParameter("displayQty"));
		para.append(" - Display Qty=").append(displayQty);
		boolean displaySourceAmt = AWebUtil.onoffStringToBoolean(request.getParameter("displaySourceInfo"));
		para.append(", Source=").append(displaySourceAmt);
		boolean displayDocumentInfo = AWebUtil.onoffStringToBoolean(request.getParameter("displayDocumentInfo"));
		para.append(", Doc=").append(displayDocumentInfo);
		//
		String sortBy1 = request.getParameter("sortBy1");
		boolean group1 = AWebUtil.onoffStringToBoolean(request.getParameter("group1"));
		para.append(" - Sorting: ").append(sortBy1).append("/").append(group1);
		String sortBy2 = request.getParameter("sortBy2");
		boolean group2 = AWebUtil.onoffStringToBoolean(request.getParameter("group2"));
		para.append(", ").append(sortBy2).append("/").append(group2);
		String sortBy3 = request.getParameter("sortBy3");
		boolean group3 = AWebUtil.onoffStringToBoolean(request.getParameter("group3"));
		para.append(", ").append(sortBy3).append("/").append(group3);
		String sortBy4 = request.getParameter("sortBy4");
		boolean group4 = AWebUtil.onoffStringToBoolean(request.getParameter("group4"));
		para.append(", ").append(sortBy4).append("/").append(group4);

		log.config(para.toString());
		
		//  Set Where Clause
		StringBuffer whereClause = new StringBuffer();
		//  Add Organization
		if (C_AcctSchema_ID != 0)
			whereClause.append(RModel.TABLE_ALIAS)
			.append(".C_AcctSchema_ID=").append(C_AcctSchema_ID);

		//	Posting Type Selected
		if (PostingType != null && PostingType.length() > 0)
		{
			if (whereClause.length() > 0)
				whereClause.append(" AND ");
			whereClause.append(RModel.TABLE_ALIAS)
			.append(".PostingType='").append(PostingType).append("'");
		}

		//
		if (documentQuery)
		{
			if (whereClause.length() > 0)
				whereClause.append(" AND ");
			whereClause.append(RModel.TABLE_ALIAS).append(".AD_Table_ID=").append(AD_Table_ID)
			.append(" AND ").append(RModel.TABLE_ALIAS).append(".Record_ID=").append(Record_ID);
		}
		else
		{
			//  get values (Queries) TODO: button
			for(int i = 1; i <= SEL_COUNT; i++){
				String columnName = "selColumn" + i;
				String keyColumn = request.getParameter(columnName);
				String queryValue = "sel" + i + "D";
				if(!StringUtils.isEmpty(request.getParameter(queryValue))){
					String value = request.getParameter(queryValue);
					String where = keyColumn + "=" + value;
					whereClause.append(" AND ");
					whereClause.append(RModel.TABLE_ALIAS).append(".").append(where);
				}
			}

			if (from != null || to != null)
			{
				if (whereClause.length() > 0)
					whereClause.append(" AND ");
				if (from != null && to != null)
					whereClause.append("TRUNC(").append(RModel.TABLE_ALIAS).append(".DateAcct,'DD') BETWEEN ")
					.append(DB.TO_DATE(from)).append(" AND ").append(DB.TO_DATE(to));
				else if (from != null)
					whereClause.append("TRUNC(").append(RModel.TABLE_ALIAS).append(".DateAcct,'DD') >= ")
					.append(DB.TO_DATE(from));
				else    //  DateTo != null
					whereClause.append("TRUNC(").append(RModel.TABLE_ALIAS).append(".DateAcct,'DD') <= ")
					.append(DB.TO_DATE(to));
			}
			//  Add Organization
			if (AD_Org_ID != 0)
			{
				if (whereClause.length() > 0)
					whereClause.append(" AND ");
				whereClause.append(RModel.TABLE_ALIAS).append(".AD_Org_ID=").append(AD_Org_ID);
			}
		}

		//  Set Order By Clause
		StringBuffer orderClause = new StringBuffer();
		if (sortBy1.length() > 0)
			orderClause.append(RModel.TABLE_ALIAS).append(".").append(sortBy1);
		if (sortBy2.length() > 0)
		{
			if (orderClause.length() > 0)
				orderClause.append(",");
			orderClause.append(RModel.TABLE_ALIAS).append(".").append(sortBy2);
		}
		if (sortBy3.length() > 0)
		{
			if (orderClause.length() > 0)
				orderClause.append(",");
			orderClause.append(RModel.TABLE_ALIAS).append(".").append(sortBy3);
		}
		if (sortBy4.length() > 0)
		{
			if (orderClause.length() > 0)
				orderClause.append(",");
			orderClause.append(RModel.TABLE_ALIAS).append(".").append(sortBy4);
		}
		if (orderClause.length() == 0)
			orderClause.append(RModel.TABLE_ALIAS).append(".Fact_Acct_ID");

		RModel rm = getRModel( request, wsc.ctx );

		//  Groups
		if (group1 && sortBy1.length() > 0)
			rm.setGroup(sortBy1);
		if (group2 && sortBy2.length() > 0)
			rm.setGroup(sortBy2);
		if (group3 && sortBy3.length() > 0)
			rm.setGroup(sortBy3);
		if (group4 && sortBy4.length() > 0)
			rm.setGroup(sortBy4);

		//  Totals
		rm.setFunction("AmtAcctDr", RModel.FUNCTION_SUM);
		rm.setFunction("AmtAcctCr", RModel.FUNCTION_SUM);

		rm.query( wsc.ctx, whereClause.toString(), orderClause.toString() );
		
		//show result
		table resultTable = new table("1", "0", "5", "auto", null);
		if(rm.getColumnCount()>=19){
			resultTable = new table("1", "0", "5", "2000px", null);
		}
		tr headerTr = new tr();
		resultTable.addElement(headerTr);

		for(int j=0; j<rm.getColumnCount(); j++){
			td oneColumn = new td();
			oneColumn.addElement(rm.getColumnName(j));
			headerTr.addElement(oneColumn);
		}
		
		for(int i=0; i<rm.getRowCount(); i++){
			tr oneTr = new tr();
			resultTable.addElement(oneTr);
			for(int j=0; j<rm.getColumnCount(); j++){
				td oneColumn = new td();
				String content = "";
				if(rm.getValueAt(i, j) != null){
					content = rm.getValueAt(i, j).toString();
					if(rm.getColumnClass(j).equals(java.sql.Timestamp.class)){
						content = wsc.dateFormat.format(rm.getValueAt(i, j));
					}
					
					if(java.math.BigDecimal.class.equals(rm.getColumnClass(j))){
						int idx = content.indexOf(".");
						if(idx + 3 < content.length() ){
							content = content.substring(0, idx + 2);
						}
					}
					
					if(content!=null && content.length()>50){ 
						content = content.substring(0, 50);
					}
				}
				oneColumn.addElement(content);
				oneTr.addElement(oneColumn);
			}
		}
		
		String resultHtml = resultTable.toString();
		List<String> resultList = new ArrayList();
		int unit = 2000;
		int beginIndex = 0;
		int endIndex = 0;
		String tempStr = "";
		
		while(resultHtml.length() > 0){
			if(resultHtml.length() < unit){
				resultList.add(resultHtml);
				break;
			}
			endIndex = resultHtml.indexOf("<tr>") + "<tr>".length();
			String str1 = resultHtml.substring(beginIndex, endIndex);
			String str2 = resultHtml.substring(endIndex, resultHtml.length());
			tempStr += str1;
			if(tempStr.length() > unit){
				resultList.add(tempStr);
				tempStr = "";
			}
			resultHtml = str2;
		}
		
		//build document below
    	try{
    		for(int i=0; i<resultList.size(); i++){
        		org.w3c.dom.Element element = document.createElement(Constants.ELEMENT);
    			document.getFirstChild().appendChild(element);

    			org.w3c.dom.Element elm_id=document.createElement(Constants.ID);
    			String objId = RESULT_DIV_ID;
    			elm_id.appendChild(document.createTextNode(objId));
    			element.appendChild(elm_id);

    			org.w3c.dom.Element elm_lookup=document.createElement(Constants.LOOKUP);
    			element.appendChild(elm_lookup);
    			elm_lookup.appendChild(document.createTextNode(Constants.DISABLED));

    			org.w3c.dom.Element elm_visibility=document.createElement(Constants.VISIBILITY);
    			element.appendChild(elm_visibility);
    			elm_visibility.appendChild(document.createTextNode(Constants.ENABLED));

    			org.w3c.dom.Element elm_newValue=document.createElement(Constants.NEW_VALUE);
    			element.appendChild(elm_newValue);
    			elm_newValue.appendChild(document.createTextNode(resultList.get(i)));

    			org.w3c.dom.Element elm_readonly=document.createElement(Constants.READONLY);
    			element.appendChild(elm_readonly);
    			elm_readonly.appendChild(document.createTextNode(Constants.NO));

    			org.w3c.dom.Element elm_type=document.createElement(Constants.TYPE);
    			element.appendChild(elm_type);
    			elm_type.appendChild(document.createTextNode(Constants.HTML));
    		}
    	}catch(Exception e){
    		;
    	}		
		
		return document;
	}   //  actionQuery
	
	/**
	 *  Create Report Model (Columns)
	 *  @return Report Model
	 */
	public RModel getRModel( HttpServletRequest request, Ctx ctx )
	{
		
		boolean displayQty = AWebUtil.onoffStringToBoolean(request.getParameter("displayQty"));
		boolean displayDocumentInfo = AWebUtil.onoffStringToBoolean(request.getParameter("displayDocumentInfo"));
		String PostingType = request.getParameter("postingType");		
		
		RModel rm = new RModel("Fact_Acct");
		//  Add Key (Lookups)
		ArrayList<String> keys = createKeyColumns(request);
		int max = m_leadingColumns;
		if (max == 0)
			max = keys.size();
		for (int i = 0; i < max; i++)
		{
			String column = (String)keys.get(i);
			if (column != null && column.startsWith("Date"))
				rm.addColumn(new RColumn(ctx, column, DisplayType.Date));
			else if (column != null && column.endsWith("_ID"))
				rm.addColumn(new RColumn(ctx, column, DisplayType.TableDir));
		}
		//  Main Info
		rm.addColumn(new RColumn(ctx, "AmtAcctDr", DisplayType.Amount));
		rm.addColumn(new RColumn(ctx, "AmtAcctCr", DisplayType.Amount));
		boolean displaySourceAmt = AWebUtil.onoffStringToBoolean(request.getParameter("displaySourceInfo"));
		if (displaySourceAmt)
		{
			if (!keys.contains("DateTrx"))
				rm.addColumn(new RColumn(ctx, "DateTrx", DisplayType.Date));
			rm.addColumn(new RColumn(ctx, "C_Currency_ID", DisplayType.TableDir));
			rm.addColumn(new RColumn(ctx, "AmtSourceDr", DisplayType.Amount));
			rm.addColumn(new RColumn(ctx, "AmtSourceCr", DisplayType.Amount));
			rm.addColumn(new RColumn(ctx, "Rate", DisplayType.Amount,
				"CASE WHEN (AmtSourceDr + AmtSourceCr) = 0 THEN 0"
				+ " ELSE (AmtAcctDr + AmtAcctCr) / (AmtSourceDr + AmtSourceCr) END"));
		}
		//	Remaining Keys
		for (int i = max; i < keys.size(); i++)
		{
			String column = (String)keys.get(i);
			if (column != null && column.startsWith("Date"))
				rm.addColumn(new RColumn(ctx, column, DisplayType.Date));
			else if (column.startsWith("UserElement"))
			{
				if (column.indexOf("1") != -1)
					rm.addColumn(new RColumn(ctx, column, DisplayType.TableDir, null, 0, m_ref1));
				else
					rm.addColumn(new RColumn(ctx, column, DisplayType.TableDir, null, 0, m_ref2));
			}
			else if (column != null && column.endsWith("_ID"))
				rm.addColumn(new RColumn(ctx, column, DisplayType.TableDir));
		}
		//	Info
		if (!keys.contains("DateAcct"))
			rm.addColumn(new RColumn(ctx, "DateAcct", DisplayType.Date));
		if (!keys.contains("C_Period_ID"))
			rm.addColumn(new RColumn(ctx, "C_Period_ID", DisplayType.TableDir));		
		if (displayQty)
		{
			rm.addColumn(new RColumn(ctx, "C_UOM_ID", DisplayType.TableDir));
			rm.addColumn(new RColumn(ctx, "Qty", DisplayType.Quantity));
		}		
		if (displayDocumentInfo)
		{
			rm.addColumn(new RColumn(ctx, "AD_Table_ID", DisplayType.TableDir));
			rm.addColumn(new RColumn(ctx, "Record_ID", DisplayType.ID));
			rm.addColumn(new RColumn(ctx, "Description", DisplayType.String));
		}
		if (PostingType == null || PostingType.length() == 0)
			rm.addColumn(new RColumn(ctx, "PostingType", DisplayType.List, 
				MFactAcct.POSTINGTYPE_AD_Reference_ID));
		return rm;
	}   //  createRModel	
	
	/**
	 *  Create the key columns in sequence
	 *  @return List of Key Columns
	 */
	private ArrayList<String> createKeyColumns(HttpServletRequest request)
	{
		WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);
		int AD_Client_ID = wsc.ctx.getContextAsInt( "AD_Client_ID");
		
		ArrayList<String> columns = new ArrayList<String>();		
		String sortBy1 = request.getParameter("sortBy1");
		String sortBy2 = request.getParameter("sortBy2");
		String sortBy3 = request.getParameter("sortBy3");
		String sortBy4 = request.getParameter("sortBy4");
		
		//  Sorting Fields
		columns.add(sortBy1);               //  may add ""
		if (!columns.contains(sortBy2))
			columns.add(sortBy2);
		if (!columns.contains(sortBy3))
			columns.add(sortBy3);
		if (!columns.contains(sortBy4))
			columns.add(sortBy4);

		//  Add Account Segments
		MAcctSchema[] ASchemas = MAcctSchema.getClientAcctSchema(wsc.ctx, AD_Client_ID);
		MAcctSchemaElement[] elements = ASchemas[0].getAcctSchemaElements();
		for (int i = 0; i < elements.length; i++)
		{
			if (m_leadingColumns == 0 && columns.contains("AD_Org_ID") && columns.contains("Account_ID"))
				m_leadingColumns = columns.size();
			//
			MAcctSchemaElement ase = elements[i];
			String columnName = ase.getColumnName();
			if (columnName.startsWith("UserElement"))
			{
				if (columnName.indexOf("1") != -1)
					m_ref1 = ase.getDisplayColumnName();
				else
					m_ref2 = ase.getDisplayColumnName();
			}
			if (!columns.contains(columnName))
				columns.add(columnName);
		}
		if (m_leadingColumns == 0 && columns.contains("AD_Org_ID") && columns.contains("Account_ID"))
			m_leadingColumns = columns.size();
		return columns;
	}   //  createKeyColumns
	
	int getAdTableId(HttpServletRequest request){
		int AD_Table_ID = 0;
		String column = request.getParameter("recordId");
		if(!StringUtils.isEmpty(column)){
			List<ValueNamePair> tableList = getTableIdNameList(request);
			for(int i = 0; i < tableList.size(); i++){
				ValueNamePair valueNamePair = tableList.get(i);
				if(column.equals(valueNamePair.getName())){
					AD_Table_ID = StringToIntConverter.StringToInt(valueNamePair.getValue());
					break;
				}
			}
			
		}
		return AD_Table_ID;
	}
	
	/**
	 *  RePost Record
	 */
	private Document actionRePost(HttpServletRequest request)
	{
		WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);
		int WindowNo = 0;
		int AD_Client_ID = wsc.ctx.getContextAsInt( "AD_Client_ID");
		int AD_Table_ID = getAdTableId(request);
		int Record_ID = 0;
		if(!StringUtils.isEmpty(request.getParameter(SELECTED_TABLE_KEY))){
			Record_ID = StringToIntConverter.StringToInt(request.getParameter(SELECTED_TABLE_KEY));
		}
		
		boolean documentQuery = false;
		if(Constants.ON.equals(request.getParameter("documentSelected"))){
			documentQuery = true;
		}
		
		boolean force = false;
		if(Constants.ON.equals(request.getParameter("force"))){
			force = true;
		}
		
		Document document = CreateNewDocument(request);
		
		if (documentQuery 
			&& AD_Table_ID != 0 && Record_ID != 0)
		{
			String error = postImmediate ( wsc.ctx, WindowNo, AD_Client_ID,
				AD_Table_ID, Record_ID, force);
			
			document = actionQuery(request);
			
			if (error != null){
				String script = AWebUtil.info(request, "PostingError-N", error);
				document = AmpiereUtil.addScriptToDocument(document, AmpiereUtil.getAlertScript(script));
			}
		}
		
		return document;
	}   //  actionRePost
	
	/**
	 *  Post Immediate
	 *  @param  WindowNo 		window
	 *  @param  AD_Table_ID     Table ID of Document
	 *  @param  AD_Client_ID    Client ID of Document
	 *  @param  Record_ID       Record ID of this document
	 *  @param  force           force posting
	 *  @return null if success, otherwise error
	 */
	public static String postImmediate ( Ctx ctx, int WindowNo, int AD_Client_ID, 
		int AD_Table_ID, int Record_ID, boolean force)
	{
		Server s_server = null;

		String error = null;
		//  try to get from Server when enabled
		if (Post.isServerActive())
		{
			try
			{
				s_server = CConnection.get().getServer();
				if (s_server != null)
				{
					error = s_server.postImmediate( ctx, AD_Client_ID, 
						AD_Table_ID, Record_ID, force, null);
				}
				else
				{
					return "NoAppsServer";
				}
			}
			catch (RemoteException e)
			{
				error = e.getMessage();
				s_server = null;
			}
			catch (Exception e)
			{
				error = e.getMessage();
				s_server = null;
			}
		}
		else
		{
			return "NoAppsServer";
		}
		return error;
	}   //  postImmediate	
	
	private Document CreateNewDocument(HttpServletRequest request)
	{
		HttpSession session = request.getSession();
    	WebSessionCtx wsc = WebSessionCtx.get(request);
    	WWindowStatus ws = WWindowStatus.get(request);
    	
    	Document document = null;
    	
    	try{
    		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    		DocumentBuilder builder = factory.newDocumentBuilder();
    		//ビルダーからDOMを取得する
    		document = builder.newDocument();
    		
    		org.w3c.dom.Element elements = document.createElement(Constants.ELEMENTS);
    		document.appendChild(elements);
    	}catch(Exception e){
    		;
    	}
    	
    	return document;
	}
	

}
