/**
 * 
 */
package com.ampiere.web.struts.search;

import java.util.logging.Level;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.framework.Lookup;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.X_C_AcctSchema_Element;
import org.compiere.util.CLogger;
import org.compiere.util.Msg;
import org.compiere.util.WebSessionCtx;

import com.ampiere.search.Info;
import com.ampiere.util.AmpiereUtil;
import com.ampiere.util.Constants;
import com.ampiere.web.servlet.WWindowStatus;
import com.jware.util.StringToIntConverter;


/**
 * clmg
 */
public class AcctViewerButtonAction extends InfoBaseAction {
	/**	Logger			*/
	protected CLogger	log = CLogger.getCLogger(this.getClass());

	/* (non-Javadoc)
	 * @see com.jware.base.web.struts.jWareBaseAction#doExecute(org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, org.apache.struts.action.ActionErrors, boolean)
	 */
	public ActionForward doExecute(ActionMapping mapping, ActionForm baseForm,
			HttpServletRequest request, HttpServletResponse response,
			ActionErrors errors, boolean mochaFlag) throws Exception {
		super.doExecute(mapping, baseForm, request, response, errors, mochaFlag);

		//201001 
        WebSessionCtx wscTest = WebSessionCtx.get(request); 
        if (wscTest == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute(Constants.SESSION_TIMEOUT_INFO, "Session Time Out. Please login again.");
            return mapping.findForward(Constants.SESSION_TIMEOUT);
        }
        //--201001       
		WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);
		int AD_Client_ID = wsc.ctx.getContextAsInt( "AD_Client_ID");
		int selectionIndex = 0;
		MAcctSchema[] ASchemas = MAcctSchema.getClientAcctSchema(wsc.ctx, AD_Client_ID);
		int acctSchemaId = StringToIntConverter.StringToInt(request.getParameter("acctSchema"));
		MAcctSchema ASchema = null;
		for(int i=0; i<ASchemas.length; i++){
			if(acctSchemaId == ASchemas[i].get_ID()){
				ASchema = ASchemas[i];
				break;
			}
		}
		//  Document
		boolean documentQuery = false;
		if(Constants.ON.equals(request.getParameter("documentSelected"))){
			documentQuery = true;
		}
        
		String doQurey = "0";
		HttpSession session = request.getSession();
		InfoLookupForm searchInfoForm = (InfoLookupForm)baseForm;
		if (searchInfoForm != null) {
			int windowNo = searchInfoForm.getWindowNo();
			String name = searchInfoForm.getName();
			String columnName = searchInfoForm.getColumnName();
			String lookupID = AmpiereUtil.getFixedColumnName(columnName);
			//TODO
			//lookupID = "General";
			String forward = lookupID.toLowerCase();
			session.setAttribute("searchResult" + lookupID, null);

			if (name != null && name.length() > 0) {
				doQurey = "1";
			}
			
			String keyColumn = columnName;
			log.info(keyColumn);
			String whereClause = "IsSummary='N'";
			String lookupColumn = keyColumn;
			if (keyColumn.equals("Account_ID"))
			{
				lookupColumn = "C_ElementValue_ID";
				MAcctSchemaElement ase = ASchema
					.getAcctSchemaElement(X_C_AcctSchema_Element.ELEMENTTYPE_Account);
				if (ase != null)
					whereClause += " AND C_Element_ID=" + ase.getC_Element_ID();
			}
			else if (keyColumn.equals("User1_ID"))
			{
				lookupColumn = "C_ElementValue_ID";
				MAcctSchemaElement ase = ASchema
					.getAcctSchemaElement(X_C_AcctSchema_Element.ELEMENTTYPE_UserList1);
				if (ase != null)
					whereClause += " AND C_Element_ID=" + ase.getC_Element_ID();
			}
			else if (keyColumn.equals("User2_ID"))
			{
				lookupColumn = "C_ElementValue_ID";
				MAcctSchemaElement ase = ASchema
					.getAcctSchemaElement(X_C_AcctSchema_Element.ELEMENTTYPE_UserList2);
				if (ase != null)
					whereClause += " AND C_Element_ID=" + ase.getC_Element_ID();
			}
			else if (documentQuery)
				whereClause = "";
			
			// Create column lookup 
			int AD_Column_ID = AmpiereUtil.getFixedColumnID(columnName);
			Lookup lookup = createLookup(wsc.ctx, windowNo, AD_Column_ID, columnName);			
			
			// sets table name & key column
			getDirectAccessSQL(wsc.ctx, "*", columnName, lookup);
			String tableName = lookupColumn.substring(0, lookupColumn.length()-3);
			name = "";

			Info info = Info.create(windowNo, tableName, lookupColumn, name, false, whereClause, wsc.ctx);
			session.setAttribute("infoLookup" + lookupID, info);

			searchInfoForm.statInit(wsc.ctx);
			if (info != null) {
				searchInfoForm.setTitle(info.getTitle());
			}
			searchInfoForm.setDateInfos(wsc.language.getLocale(), wsc.dateFormat.toPattern(), Msg.translate(wsc.ctx, "InvalidDate"));
			searchInfoForm.setLookupID(lookupID);

			// Set search info form
			session.setAttribute("searchInfoForm" + lookupID, searchInfoForm);

			request.setAttribute("doQuery", doQurey);
		    return mapping.findForward(forward);
		}

		request.setAttribute("doQuery", doQurey);
	    return mapping.findForward("general");
	}
}
