/**
 *
 */
package com.ampiere.web.struts.search;

import java.util.logging.Level;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.util.CLogger;
import org.compiere.util.Msg;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;

import com.ampiere.util.AmpiereUtil;
import com.ampiere.util.Constants;


/**
 * @author clmg
 *
 */
public class InfoInOutAction extends InfoBaseAction {
	/**	Logger			*/
	protected CLogger	log = CLogger.getCLogger(this.getClass());

	/* (non-Javadoc)
	 * @see com.jware.base.web.struts.jWareBaseAction#doExecute(org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, org.apache.struts.action.ActionErrors, boolean)
	 */
	public ActionForward doExecute(ActionMapping mapping, ActionForm baseForm,
			HttpServletRequest request, HttpServletResponse response,
			ActionErrors errors, boolean mochaFlag) throws Exception {
		super.doExecute(mapping, baseForm, request, response, errors, mochaFlag);

		//201001 
        WebSessionCtx wscTest = WebSessionCtx.get(request); 
        if (wscTest == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute(Constants.SESSION_TIMEOUT_INFO, "Session Time Out. Please login again.");
            return mapping.findForward(Constants.SESSION_TIMEOUT);
        }
        //--201001	 
		
		String doQurey = "0";
		HttpSession session = request.getSession();
		InfoInOutForm searchInfoFormInOut = (InfoInOutForm)baseForm;
		// Clear all
		session.setAttribute("searchResultInOut", null);
		if (searchInfoFormInOut != null) {
		  	WebSessionCtx wsc = WebSessionCtx.get(request);
			int windowNo = searchInfoFormInOut.getWindowNo();
			String bPartner = searchInfoFormInOut.getName();
			if (WebEnv.NBSP_UNICODE.equals(bPartner)) {
				bPartner = "";
			}

			int M_Warehouse_ID = wsc.ctx.getContextAsInt(windowNo, "M_Warehouse_ID");
			
			searchInfoFormInOut.statInit(wsc.ctx);
			if (!StringUtils.isEmpty(bPartner)) {
				searchInfoFormInOut.setCbpartnerId(bPartner);
				searchInfoFormInOut.setCbpartneridd(bPartner);
				String bpartnerName = AmpiereUtil.getBPartnerName(bPartner);
				searchInfoFormInOut.setCbpartneridf(bpartnerName);
			}else{
				searchInfoFormInOut.setCbpartnerId("");
				searchInfoFormInOut.setCbpartneridd("");
				searchInfoFormInOut.setCbpartneridf("");
			}
			
			searchInfoFormInOut.initInfo("", M_Warehouse_ID, wsc.ctx, windowNo);

			// Set search info form
			searchInfoFormInOut.setTitle(Msg.getMsg(wsc.ctx, "InfoInOut"));
			session.setAttribute("searchInfoFormInOut", searchInfoFormInOut);
		}

		request.setAttribute("doQuery", doQurey);
	    return mapping.findForward("success");
	}
}
